// Base on Microsoft "cpuid.cpp"
//
#pragma once

#define _INC_CPUID

#define _CPU_FEATURE_MMX		0x0001
#define _CPU_FEATURE_SSE		0x0002
#define _CPU_FEATURE_SSE2		0x0004
#define _CPU_FEATURE_3DNOW		0x0008
//
#define _CPU_FEATURE_MMX_P		0x0010
#define _CPU_FEATURE_3DNOW_P	0x0020
#define _CPU_FEATURE_SSE3		0x0040
#define _CPU_FEATURE_IA64		0x0080
#define _CPU_FEATURE_HT			0x0100
#define _CPU_FEATURE_TM			0x0200

struct ProcessorInfo
{
    CString			VendorName;				// vendor name
    CString			ModelName;				// name of model, e.g. Intel Pentium-Pro
    unsigned int	Family;                 // family of the processor, e.g. 6 = Pentium-Pro architecture
    unsigned int	Model;                  // model of processor, e.g. 1 = Pentium-Pro for family = 6
    unsigned int	BrandID;                // Brand ID for Intel Pentium 4 and Celerom
    unsigned int	Stepping;               // processor revision number
    unsigned int	Feature;                // processor feature (same as return value from _cpuid)
    unsigned int	OS_Support;             // does OS Support the feature?
    unsigned int	Checks;                 // mask of checked bits in feature and os_support fields
	//
	unsigned int	L1CacheCode;
	unsigned int	L1CacheData;
	unsigned int	L2Cache;
	unsigned int	L3Cache;
	unsigned int	Speed;
};

class CProcessorInfo
{
public:
	CProcessorInfo();
	~CProcessorInfo();
	void			Initial(bool IsDetectSpeed);
	bool			IsCompatibleFeature(unsigned int Feature);
	CString			GetVendorName()						{ return CPU_Info.VendorName;}
	CString			GetModelName()						{ return CPU_Info.ModelName;}
	unsigned int	GetFamily()							{ return CPU_Info.Family;}
	unsigned int	GetModel()							{ return CPU_Info.Model;}
	unsigned int	GetBrandID()						{ return CPU_Info.BrandID;}
	unsigned int	GetStepping()						{ return CPU_Info.Stepping;}
	unsigned int	GetFeature()						{ return CPU_Info.Feature;}
	unsigned int	GetOS_Support()						{ return CPU_Info.OS_Support;}
	unsigned int	GetChecks()							{ return CPU_Info.Checks;}
	unsigned int	GetL1CacheCode()					{ return CPU_Info.L1CacheCode;}
	unsigned int	GetL1CacheData()					{ return CPU_Info.L1CacheData;}
	unsigned int	GetL2Cache()						{ return CPU_Info.L2Cache;}
	unsigned int	GetL3Cache()						{ return CPU_Info.L3Cache;}
	unsigned int	GetSpeed()							{ return CPU_Info.Speed;}
	CString			GetFeatureString();
	CString			GetOS_SupportString();
	void			SetSpeed();
private:
	bool			IsCPUID();
	bool			IsOS_Support(unsigned int Feature);
	void			SetModelName();
	void			SetCache(DWORD ExtendedLevel = 0);
	void			CheckConfig(unsigned int Value);
	unsigned int	TimeStamp();
	ProcessorInfo	CPU_Info;
};