//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include <io.h>
#include "emule.h"
#include "FriendList.h"
#include "UpDownClient.h"
#include "Friend.h"
#include "Preferences.h"
#include "SafeFile.h"
#include "OtherFunctions.h"
#include "opcodes.h"
#include "emuledlg.h"
#include "FriendListCtrl.h"
#include "Log.h"
#include "UploadQueue.h"
// RT, Include
#include "ServerWnd.h"
#include "0RatioFile/RT_FriendListCtrl.h"
#include "0RatioFile/RT_Version.h"
#include "Ini2.h"
// End

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define EMFRIENDS_MET_FILENAME	_T("emfriends.met")

CFriendList::CFriendList()
{
// RT,
//	RT_LoadList();
	LoadList();
	m_nLastSaved = ::GetTickCount();
	m_wndOutput = NULL;
	rt_FriendWindow = NULL;
}

CFriendList::~CFriendList()
{
	SaveList();
	for (POSITION pos = m_listFriends.GetHeadPosition();pos != 0;)
		delete m_listFriends.GetNext(pos);
}

bool CFriendList::LoadList(){
	CString strFileName = CString(thePrefs.GetConfigDir()) + CString(EMFRIENDS_MET_FILENAME);
	CSafeBufferedFile file;
	CFileException fexp;
	if (!file.Open(strFileName.GetBuffer(),CFile::modeRead|CFile::osSequentialScan|CFile::typeBinary|CFile::shareDenyWrite, &fexp)){
		if (fexp.m_cause != CFileException::fileNotFound){
			CString strError(GetResString(IDS_ERR_READEMFRIENDS));
			TCHAR szError[MAX_CFEXP_ERRORMSG];
			if (fexp.GetErrorMessage(szError, ARRSIZE(szError))){
				strError += _T(" - ");
				strError += szError;
			}
			LogError(LOG_STATUSBAR, _T("%s"), strError);
		}
		return false;
	}

	try {
		uint8 header = file.ReadUInt8();
		if (header != MET_HEADER){
			file.Close();
			return false;
		}
		UINT nRecordsNumber = file.ReadUInt32();
		for (UINT i = 0; i < nRecordsNumber; i++) {
			CFriend* Record =  new CFriend();
			Record->LoadFromFile(&file);
			m_listFriends.AddTail(Record);
		}
		file.Close();
	}
	catch(CFileException* error){
		if (error->m_cause == CFileException::endOfFile)
			LogError(LOG_STATUSBAR,GetResString(IDS_ERR_EMFRIENDSINVALID));
		else{
			TCHAR buffer[MAX_CFEXP_ERRORMSG];
			error->GetErrorMessage(buffer, ARRSIZE(buffer));
			LogError(LOG_STATUSBAR,GetResString(IDS_ERR_READEMFRIENDS),buffer);
		}
		error->Delete();
		return false;
	}

	return true;
}

void CFriendList::SaveList(){
	if (thePrefs.GetLogFileSaving())
		AddDebugLogLine(false, _T("Saving friends list file \"%s\""), EMFRIENDS_MET_FILENAME);
	m_nLastSaved = ::GetTickCount();

	CString strFileName = CString(thePrefs.GetConfigDir()) + CString(EMFRIENDS_MET_FILENAME);
	CSafeBufferedFile file;
	CFileException fexp;
	if (!file.Open(strFileName.GetBuffer(),CFile::modeCreate|CFile::modeWrite|CFile::typeBinary|CFile::shareDenyWrite, &fexp)){
		CString strError(_T("Failed to save ") EMFRIENDS_MET_FILENAME _T(" file"));
		TCHAR szError[MAX_CFEXP_ERRORMSG];
		if (fexp.GetErrorMessage(szError, ARRSIZE(szError))){
			strError += _T(" - ");
			strError += szError;
		}
		LogError(LOG_STATUSBAR, _T("%s"), strError);
		return;
	}
	setvbuf(file.m_pStream, NULL, _IOFBF, 16384);
	
	try{
		file.WriteUInt8(MET_HEADER);
		file.WriteUInt32(m_listFriends.GetCount());
		for (POSITION pos = m_listFriends.GetHeadPosition();pos != 0;)
			m_listFriends.GetNext(pos)->WriteToFile(&file);
		if (thePrefs.GetCommitFiles() >= 2 || (thePrefs.GetCommitFiles() >= 1 && !theApp.emuledlg->IsRunning())){
			file.Flush(); // flush file stream buffers to disk buffers
			if (_commit(_fileno(file.m_pStream)) != 0) // commit disk buffers to disk
				AfxThrowFileException(CFileException::hardIO, GetLastError(), file.GetFileName());
		}
		file.Close();
	}
	catch(CFileException* error){
		CString strError(_T("Failed to save ") EMFRIENDS_MET_FILENAME _T(" file"));
		TCHAR szError[MAX_CFEXP_ERRORMSG];
		if (error->GetErrorMessage(szError, ARRSIZE(szError))){
			strError += _T(" - ");
			strError += szError;
		}
		LogError(LOG_STATUSBAR, _T("%s"), strError);
		error->Delete();
	}
}

CFriend* CFriendList::SearchFriend(const uchar* abyUserHash, uint32 dwIP, uint16 nPort) const {
	POSITION pos = m_listFriends.GetHeadPosition();
	while (pos){
		CFriend* cur_friend = m_listFriends.GetNext(pos);
		// to avoid that unwanted clients become a friend, we have to distinguish between friends with
		// a userhash and of friends which are identified by IP+port only.
		if (cur_friend->m_dwHasHash){
			// check for a friend which has the same userhash as the specified one
			if (!md4cmp(cur_friend->m_abyUserhash, abyUserHash))
				return cur_friend;
		}
		else{
			if (cur_friend->m_dwLastUsedIP == dwIP && cur_friend->m_nLastUsedPort == nPort)
				return cur_friend;
		}
	}
	return NULL;
}

void CFriendList::RefreshFriend(CFriend* torefresh) const {
	if (m_wndOutput)   m_wndOutput->RefreshFriend(torefresh);
	if (rt_FriendWindow)   rt_FriendWindow->RefreshFriend(torefresh);
}

void CFriendList::ShowFriends() const {
	if (!m_wndOutput){
		ASSERT ( false );
		return;
	}
	m_wndOutput->DeleteAllItems();
	for (POSITION pos = m_listFriends.GetHeadPosition();pos != 0;)
		m_wndOutput->AddFriend(m_listFriends.GetNext(pos));
	m_wndOutput->UpdateList();
	//
	if (rt_FriendWindow)
	{
		rt_FriendWindow->DeleteAllItems();
		POSITION ListPos = m_listFriends.GetHeadPosition();
		while (ListPos != NULL)   rt_FriendWindow->AddFriend( m_listFriends.GetNext(ListPos) );
		rt_FriendWindow->UpdateList();
	}
}

//You can add a friend without a IP to allow the IRC to trade links with lowID users.
bool CFriendList::AddFriend(const uchar* abyUserhash, uint32 dwLastSeen, uint32 dwLastUsedIP, uint32 nLastUsedPort, 
							uint32 dwLastChatted, LPCTSTR pszName, uint32 dwHasHash){
	// client must have an IP (HighID) or a hash
	// TODO: check if this can be switched to a hybridID so clients with *.*.*.0 can be added..
	if (IsLowID(dwLastUsedIP) && dwHasHash==0)
		return false;
	if( dwLastUsedIP && IsAlreadyFriend(dwLastUsedIP, nLastUsedPort))
		return false;
	CFriend* Record = new CFriend( abyUserhash, dwLastSeen, dwLastUsedIP, nLastUsedPort, dwLastChatted, pszName, dwHasHash );
	m_listFriends.AddTail(Record);
	ShowFriends();
	SaveList();
	return true;
}

// Added for the friends function in the IRC..
bool CFriendList::IsAlreadyFriend(uint32 dwLastUsedIP, uint32 nLastUsedPort) const
{
	for (POSITION pos = m_listFriends.GetHeadPosition();pos != 0;){
		const CFriend* cur_friend = m_listFriends.GetNext(pos);
		if (cur_friend->m_dwLastUsedIP == dwLastUsedIP && cur_friend->m_nLastUsedPort == nLastUsedPort)
			return true;
	}
	return false;
}

bool CFriendList::AddFriend(CUpDownClient* toadd){
	if (toadd->IsFriend())
		return false;
	// client must have an IP (HighID) or a hash
	if (toadd->HasLowID() && !toadd->HasValidHash())
		return false;
	CFriend* NewFriend = new CFriend(toadd);
	toadd->m_Friend = NewFriend;
	m_listFriends.AddTail(NewFriend);
	if (m_wndOutput){
		m_wndOutput->AddFriend(NewFriend);
		m_wndOutput->UpdateList();
	}
	if (rt_FriendWindow)
	{
		rt_FriendWindow->AddFriend(NewFriend);
		rt_FriendWindow->UpdateList();
	}
	SaveList();
// RT, Refresh MaskNO after AddFriend
	toadd->SetMaskNO();
// End
	return true;
}

void CFriendList::RemoveFriend(CFriend* todel){
	POSITION pos = m_listFriends.Find(todel);
	if (!pos){
		ASSERT ( false );
		return;
	}

// RT, Keep Friend Slot
	if (thePrefs.IsCurrentFS(todel->m_abyUserhash) == true)
	{
		thePrefs.SetUserHashFS( CString("") );
		theApp.emuledlg->serverwnd->UpdateMyInfo();
		thePrefs.RT_SaveSettings();
	}
	CUpDownClient* Client = todel->GetLinkedClient();
	todel->SetLinkedClient(NULL);
	// Refresh MaskNO after RemoveFriend
	if (Client != NULL)
	{
		if ( (Client->GetUploadState() == US_ONUPLOADQUEUE) || (Client->GetUploadState() == US_UPLOADING) )
			Client->SetQueueScore( Client->GetScore(false, Client->IsDownloading(), false) );
		Client->SetMaskNO();
	}
// Original	todel->SetLinkedClient(NULL);

	if (m_wndOutput)   m_wndOutput->RemoveFriend(todel);
	if (rt_FriendWindow)   rt_FriendWindow->RemoveFriend(todel);
	m_listFriends.RemoveAt(pos);
	delete todel;
	SaveList();
	if (m_wndOutput)   m_wndOutput->UpdateList();
	if (rt_FriendWindow)   rt_FriendWindow->UpdateList();
}

// RT, New Code at Bottom
/* Original
void CFriendList::RemoveAllFriendSlots(){
	for (POSITION pos = m_listFriends.GetHeadPosition();pos != 0;){
		CFriend* cur_friend = m_listFriends.GetNext(pos);
        cur_friend->SetFriendSlot(false);
	}
}
*/

void CFriendList::Process()
{
	if (::GetTickCount() - m_nLastSaved > MIN2MS(19))
		SaveList();
// RT,
//		RT_SaveList();
}

//*************
// RT, New Code
//-------------
// Keep Friend Slot
void CFriendList::SetFriendSlot()
{
	if ( (thePrefs.IsFriendSlotAuto() == true) || (thePrefs.IsKeepFriendSlot() == false) )   return;
	POSITION pos = m_listFriends.GetHeadPosition();
	while (pos != NULL)
	{
		CUpDownClient* Client = ((CFriend*)m_listFriends.GetNext(pos))->GetLinkedClient();
		if (Client != NULL)
		{
			if (Client->m_bAddNextConnect == false)
				Client->SetFriendSlot(false);
			if (thePrefs.IsCurrentFS( Client->GetUserHash() ) == true)
				Client->SetFriendSlot(true);
		}
	}
	if (m_wndOutput)   m_wndOutput->UpdateList();
	if (rt_FriendWindow)   rt_FriendWindow->UpdateList();
}

// Keep Friend Slot
void CFriendList::SetFriendSlot(CUpDownClient* Client, bool OldStatus)
{
	if (Client->m_Friend != NULL)   SetFriendSlot(Client->m_Friend, OldStatus);
}

// Keep Friend Slot
void CFriendList::SetFriendSlot(CFriend* Friend, bool OldStatus)
{
	if (thePrefs.IsFriendSlotAuto() == true)   return;
	CUpDownClient* Client = Friend->GetLinkedClient();
	RemoveAllFriendSlots();
	if (OldStatus == false)
		Friend->SetFriendSlot(true);
	else
	{
		Friend->SetFriendSlot(false);
		if (Client != NULL)   Client->m_bAddNextConnect = false;
	}
	if (thePrefs.IsKeepFriendSlot() == true)
	{
		if (OldStatus == false)
			thePrefs.SetUserHashFS(Friend->m_abyUserhash);
		else
			thePrefs.SetUserHashFS( CString("") );
		thePrefs.RT_SaveSettings();
		theApp.emuledlg->serverwnd->UpdateMyInfo();
	}
	// Update
	if (Client != NULL)
	{
		uint32 CurrentScore = Client->GetScore(false);
		Client->SetQueueScore(CurrentScore);
	}
	if (m_wndOutput)   m_wndOutput->UpdateList();
	if (rt_FriendWindow)   rt_FriendWindow->UpdateList();
	RefreshFriend(Friend);
}

// New Code to RemoveAllFriendSlots
void CFriendList::RemoveAllFriendSlots()
{
	POSITION pos = m_listFriends.GetHeadPosition();
	while (pos != NULL)
	{
		CUpDownClient* Client = ((CFriend*)m_listFriends.GetNext(pos))->GetLinkedClient();
		if (Client != NULL)
		{
			if (Client->GetFriendSlot() == true)
			{
				Client->m_bAddNextConnect = false;
				Client->SetFriendSlot(false);
//				if ( (Client->GetUploadState() == US_ONUPLOADQUEUE) || (Client->GetUploadState() == US_UPLOADING) )
				Client->SetMaskNO();
				Client->SetQueueScore( Client->GetScore(false) );
			}
		}
	}
}

/*
#define RT_FRIENDS_LIST	_T("RT_Friends.ini")
//
bool CFriendList::RT_LoadList()
{
	CString Filename = CString(thePrefs.GetConfigDir()) + CString(RT_FRIENDS_LIST);
	if (PathFileExists(Filename) == FALSE)   return LoadList();
	CIni RatioIni( Filename, _T("FileInfomation") );
	//
	switch ( RatioIni.GetInt(_T("Version"), 0, _T("FileInfomation")) )
	{
		case RT_FRIENDS_VERSION:
			break;
		case 0:
		default:
			return LoadList();
	}
	uint32 FriendCount = RatioIni.GetInt( _T("FriendCount"), 0, _T("FileInfomation") );
	if (FriendCount == 0)   return true;
	//
	CString Index;
	for (uint32 i = 0; i < FriendCount; i++)
	{
		Index.Format( _T("Friend%05u"), i );
		CFriend* Record = new CFriend();
		//
		Record->m_strName = RatioIni.GetString( _T("Username"), _T(""), Index );
		strmd4( RatioIni.GetString( _T("Userhash"), _T(""), Index ), Record->m_abyUserhash );
		Record->m_dwLastSeen = RatioIni.GetUInt64( _T("LastSeen"), 0, Index );
		Record->m_dwLastUsedIP = RatioIni.GetUInt64( _T("LastUsedIP"), 0, Index );
		Record->m_nLastUsedPort = RatioIni.GetUInt64( _T("LastUsedPort"), 0, Index );
		Record->m_dwLastChatted = RatioIni.GetUInt64( _T("LastChatted"), 0, Index );
		Record->m_dwHasHash = RatioIni.GetUInt64( _T("HasHash"), 0, Index );
		Record->rt_IdentState = RatioIni.GetUInt64( _T("IdentState"), 0, Index );
		Record->rt_Software = RatioIni.GetString( _T("Software"), _T(""), Index );
		Record->SetFriendSlot(false);
		Record->SetLinkedClient(NULL);
		//
		m_listFriends.AddTail(Record);
	}
	return true;
}

void CFriendList::RT_SaveList()
{
	if (thePrefs.GetLogFileSaving() == true)
		AddDebugLogLine(false, _T("Saving friends list file \"%s\""), RT_FRIENDS_LIST);
	m_nLastSaved = ::GetTickCount();

	CString Filename = CString(thePrefs.GetConfigDir()) + CString(RT_FRIENDS_LIST);
	RatioAppendINI RatioINI;
	if (RatioINI.OpenFile(Filename, _T("w")) == true)
	{
		uint32 FriendCount = 0;
		CString Index;
		RatioINI.WriteSection( _T("FileInfomation") );
		RatioINI.Write( _T("Version"), RT_FRIENDS_VERSION );
		RatioINI.Write( _T("FriendCount"), FriendCount );
		//
		POSITION ListPos = m_listFriends.GetHeadPosition();
		while (ListPos != NULL)
		{
			CFriend* Friend = m_listFriends.GetNext(ListPos);
			Index.Format( _T("Friend%05u"), FriendCount );
			RatioINI.Write(Index);
			RatioINI.Write( _T("Username"), Friend->m_strName );
			RatioINI.Write( _T("Userhash"), md4str(Friend->m_abyUserhash) );
			RatioINI.Write( _T("LastSeen"), Friend->m_dwLastSeen );
			RatioINI.Write( _T("LastUsedIP"), Friend->m_dwLastUsedIP );
			RatioINI.Write( _T("LastUsedPort"), Friend->m_nLastUsedPort );
			RatioINI.Write( _T("LastChatted"), Friend->m_dwLastChatted );
			RatioINI.Write( _T("HasHash"), Friend->m_dwHasHash );
			RatioINI.Write( _T("IdentState"), Friend->rt_IdentState );
			RatioINI.Write( _T("Software"), Friend->rt_Software );
			FriendCount++;
		}
		RatioINI.CloseFile();
		if (FriendCount > 0)
		{
			CIni RatioIni( Filename, _T("FileInfomation") );
			RatioIni.WriteUInt64( _T("FriendCount"), FriendCount, _T("FileInfomation") );
		}
	}
}
*/