//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "friend.h"
#include "ClientDetailDialog.h"
#include "Addfriend.h"
#include "FriendList.h"
#include "emuledlg.h"
#include "ClientList.h"
#include "OtherFunctions.h"
#include "UpDownClient.h"
#include "ListenSocket.h"
#include "MenuCmds.h"
#include "ChatWnd.h"
// RT, Include
#include "Log.h"
#include "Ini2.h"
#include "MemDC.h"
#include "ServerWnd.h"
#include "TransferWnd.h"
#include "ClientCredits.h"
#include "RT_FriendListCtrl.h"
// End

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// CRT_FriendListCtrl

IMPLEMENT_DYNAMIC(CRT_FriendListCtrl, CMuleListCtrl)
CRT_FriendListCtrl::CRT_FriendListCtrl()
{
}

CRT_FriendListCtrl::~CRT_FriendListCtrl()
{
}

void CRT_FriendListCtrl::SaveAllSettings()
{
	CString Filename;
	Filename.Format( _T("%sRT_Preferences.ini"), thePrefs.GetConfigDir() );
	CIni RatioINI( Filename, _T("Column") );
	//
	SaveSettings(&RatioINI, _T("FriendListCtrl") );
	RatioINI.WriteInt( _T("FriendListCtrlSortItem"), GetSortItem() );
	RatioINI.WriteInt( _T("FriendListCtrlSortAscending"), GetSortAscending() );
}

BEGIN_MESSAGE_MAP(CRT_FriendListCtrl, CMuleListCtrl)
	ON_WM_CONTEXTMENU()
	ON_WM_SYSCOLORCHANGE()
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnNMDblclk)
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnLvnColumnclick)
END_MESSAGE_MAP()



// CRT_FriendListCtrl message handlers

void CRT_FriendListCtrl::Init()
{
	//dummy list for getting the proper height of listview entries
	CImageList ilDummyImageList;
	ilDummyImageList.Create(1, theApp.GetSmallSytemIconSize().cy,theApp.m_iDfltImageListColorFlags|ILC_MASK, 1, 1); 
	SetImageList(&ilDummyImageList, LVSIL_SMALL);
	ASSERT( (GetStyle() & LVS_SHAREIMAGELISTS) == 0 );
	ilDummyImageList.Detach();

	SetExtendedStyle(LVS_EX_FULLROWSELECT);
	ModifyStyle(LVS_SINGLESEL, 0);

	InsertColumn(0, GetResString(IDS_QL_USERNAME), LVCFMT_LEFT, 200, 0);
	InsertColumn(1, GetResString(IDS_CD_TUP), LVCFMT_LEFT, 100, 0);
	InsertColumn(2, GetResString(IDS_CD_TDOWN), LVCFMT_LEFT, 100, 0);
	InsertColumn(3, GetResString(IDS_CD_CSOFT), LVCFMT_LEFT, 100, 0);
	InsertColumn(4, GetResString(IDS_CD_IDENT), LVCFMT_LEFT, 100, 0);
	InsertColumn(5, GetResString(IDS_CD_UHASH), LVCFMT_LEFT, 200, 0);
	InsertColumn(6, GetResString(IDS_LASTSEEN), LVCFMT_LEFT, 200, 0);
	SetAllIcons();
	Localize();
	//
	CString Filename;
	Filename.Format( _T("%sRT_Preferences.ini"), thePrefs.GetConfigDir() );
	CIni RatioINI( Filename, _T("Column") );
	//
	LoadSettings(&RatioINI, _T("FriendListCtrl") );
	int SortItem = RatioINI.GetInt( _T("FriendListCtrlSortItem") );
	bool SortAscending = RatioINI.GetInt( _T("FriendListCtrlSortAscending") );
	SetSortArrow(SortItem, SortAscending);
	//
	rt_IsAcceptUpdate = true;
	theApp.friendlist->SetFriendWindow(this);
}

void CRT_FriendListCtrl::OnSysColorChange()
{
	CMuleListCtrl::OnSysColorChange();
	SetAllIcons();
}

void CRT_FriendListCtrl::SetAllIcons()
{
// RT, Client Icon
	rt_ClientImageList.DeleteImageList();
	rt_ClientImageList.Create(16, 16, theApp.m_iDfltImageListColorFlags|ILC_MASK, 0, 1);
	rt_ClientImageList.SetBkColor(CLR_NONE);
	rt_ClientImageList.Add( CTempIconLoader(_T("FriendNoClient")) );
	//
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientEDonkey")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientCompatible")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientMLDonkey")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientEDonkeyHybrid")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientShareaza")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientAMule")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientLphant")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("Server")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("Friend")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientEastShare")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientWombat")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientLSD")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientMorph")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientPhoenix")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientPlus")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientRT")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientSivka")) );
	rt_ClientImageList.Add( CTempIconLoader(_T("ClientWebCache")) );
	rt_ClientImageList.SetOverlayImage( rt_ClientImageList.Add(CTempIconLoader(_T("ClientMaskPlus"))), 1 );
	rt_ClientImageList.SetOverlayImage( rt_ClientImageList.Add(CTempIconLoader(_T("ClientMaskFriend"))), 2 );
	rt_ClientImageList.SetOverlayImage( rt_ClientImageList.Add(CTempIconLoader(_T("ClientMaskPlusFriend"))), 3 );
	rt_ClientImageList.SetOverlayImage( rt_ClientImageList.Add(CTempIconLoader(_T("ClientSecureOvl"))), 4 );
	// Load Flag Image
	CBitmap Bitmap;
	if (Bitmap.LoadBitmap(RT_IDB_FLAG) == TRUE)
	{
		BITMAP bm = {0};
		Bitmap.GetObject(sizeof(bm), &bm);
		if ( rt_FlagImageList.Create(16, bm.bmHeight, ILC_COLOR16|ILC_MASK, 0, 1) )
		{
			rt_FlagImageList.Add(&Bitmap, RGB(0, 254, 0));
		}
		Bitmap.DeleteObject();
	}
	else
		AddLogLine( true, _T(">> [RT Debug] Error when Load Flag") );
/* Original
	CImageList iml;
	iml.Create(16,16,theApp.m_iDfltImageListColorFlags|ILC_MASK,0,1);
	iml.SetBkColor(CLR_NONE);
	iml.Add(CTempIconLoader(_T("FriendNoClient")));
	iml.Add(CTempIconLoader(_T("FriendWithClient")));
	iml.Add(CTempIconLoader(_T("FriendConnected")));
	ASSERT( (GetStyle() & LVS_SHAREIMAGELISTS) == 0 );
	HIMAGELIST himlOld = ApplyImageList(iml.Detach());
	if (himlOld)   ImageList_Destroy(himlOld);
*/
}

void CRT_FriendListCtrl::Localize()
{
	CHeaderCtrl* pHeaderCtrl = GetHeaderCtrl();
	HDITEM hdi;
	hdi.mask = HDI_TEXT;

	if (pHeaderCtrl->GetItemCount() != 0)
	{
		CString strRes;

		strRes = GetResString(IDS_QL_USERNAME);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(0, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_CD_TUP);
		strRes.Remove( _T(':') );
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(1, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_CD_TDOWN);
		strRes.Remove( _T(':') );
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(2, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_CD_CSOFT);
		strRes.Remove( _T(':') );
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(3, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_CD_IDENT);
		strRes.Remove( _T(':') );
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(4, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_CD_UHASH);
		strRes.Remove( _T(':') );
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(5, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_LASTSEEN);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(6, &hdi);
		strRes.ReleaseBuffer();
//		int iItems = GetItemCount();
//		for (int i = 0; i < iItems; i++)   UpdateFriend( i, (CFriend*)GetItemData(i) );
	}
}

#define DLC_DT_TEXT (DT_LEFT|DT_SINGLELINE|DT_VCENTER|DT_NOPREFIX|DT_END_ELLIPSIS)

void CRT_FriendListCtrl::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	if (theApp.emuledlg->IsRunning() == false)   return;
	if (lpDrawItemStruct->itemData == false)   return;
	//
	CDC* odc = CDC::FromHandle(lpDrawItemStruct->hDC);
	BOOL bCtrlFocused = ((GetFocus() == this ) || (GetStyle() & LVS_SHOWSELALWAYS));
	if ( (lpDrawItemStruct->itemAction | ODA_SELECT) && (lpDrawItemStruct->itemState & ODS_SELECTED) )
	{
		if(bCtrlFocused)
			odc->SetBkColor(m_crHighlight);
		else
			odc->SetBkColor(m_crNoHighlight);
	}
	else
		odc->SetBkColor(GetBkColor());
	//
	const CFriend* Friend = (CFriend*)lpDrawItemStruct->itemData;
	const CUpDownClient* Client = Friend->GetLinkedClient();
	CClientCredits* ClientCredit = NULL;
	if (Client != NULL)   ClientCredit = Client->credits;
	if (ClientCredit == NULL)   ClientCredit = theApp.clientcredits->GetCredit(Friend->m_abyUserhash, false);
	//
	CMemDC dc( CDC::FromHandle(lpDrawItemStruct->hDC), &lpDrawItemStruct->rcItem );
	CFont* pOldFont = dc.SelectObject(GetFont());
	RECT cur_rec = lpDrawItemStruct->rcItem;
	COLORREF crOldTextColor = dc.SetTextColor(m_crWindowText);

	int iOldBkMode;
	if (m_crWindowTextBk == CLR_NONE)
	{
		DefWindowProc( WM_ERASEBKGND, WPARAM(HDC(dc)), 0 );
		iOldBkMode = dc.SetBkMode(TRANSPARENT);
	}
	else
		iOldBkMode = OPAQUE;

	CString Buffer;

	CHeaderCtrl *pHeaderCtrl = GetHeaderCtrl();
	int iCount = pHeaderCtrl->GetItemCount();
	cur_rec.right = cur_rec.left - 8;
	cur_rec.left += 4;

	for (int iCurrent = 0; iCurrent < iCount; iCurrent++)
	{
		int iColumn = pHeaderCtrl->OrderToIndex(iCurrent);
		if (IsColumnHidden(iColumn) == FALSE)
		{
			cur_rec.right += GetColumnWidth(iColumn);
			switch (iColumn)
			{
				case 0:
				{
					if (Client != NULL)
					{
						uint8 Image = Client->GetIconNO() + 1;
						POINT point = {cur_rec.left, cur_rec.top + 1};
						rt_ClientImageList.Draw( dc, Image, point, (ILD_NORMAL | INDEXTOOVERLAYMASK(Client->GetMaskNO())) );
						// Display Country Code
						if (Client->GetUserName() == NULL)
							Buffer.Format(_T("(%s)"), GetResString(IDS_UNKNOWN));
						else
						{
							if (thePrefs.IsDisplayCountry() == true)
								Buffer.Format( _T("<%s> %s"), Client->GetCountryCode(), Client->GetUserName() );
							else
								Buffer = Client->GetUserName();
						}
						cur_rec.left += 20;
						// Text Color
						if (thePrefs.IsRatioColor() == true)
						{
							if ( (Client->GetDownloadState() == DS_DOWNLOADING) ||
								(Client->GetUploadState() == US_UPLOADING) )
							{
								if ( (Client->GetDownloadState() == DS_DOWNLOADING) &&
									(Client->GetUploadState() == US_UPLOADING) )
									dc->SetTextColor( thePrefs.GetRatioColor(RT_CR_CT_TRADE) );
								else
									dc->SetTextColor( thePrefs.GetRatioColor(RT_CR_CT_TRANSFER) );
							}
							else if (Client->IsDontDownload() == true)
							{
								dc->SetTextColor( thePrefs.GetRatioColor(RT_CR_CT_BAD) );
							}
							else if (Client->GetUploadState() == US_ONUPLOADQUEUE)
							{
								if (Client->GetQueueScore() < RT_SCORE_DONT_UPLOAD)
									dc->SetTextColor( thePrefs.GetRatioColor(RT_CR_CT_BAD) );
							}
						}
						// Display Flag
						Image = Client->GetFlagNO();
						if (thePrefs.IsDisplayFlag() == true)
						{
							POINT FlagPoint = {cur_rec.left, (cur_rec.top + 3)};
							rt_FlagImageList.Draw(dc, Image, FlagPoint, ILD_NORMAL);
							cur_rec.left += 20;
							dc->DrawText(Buffer, Buffer.GetLength(), &cur_rec, DLC_DT_TEXT);
							cur_rec.left -= 20;
						}
						else
							dc->DrawText(Buffer, Buffer.GetLength(), &cur_rec, DLC_DT_TEXT);
						cur_rec.left -= 20;
					}
					else
					{
						POINT point = {cur_rec.left, cur_rec.top + 1};
						rt_ClientImageList.Draw(dc, 0, point, ILD_NORMAL);
						if (thePrefs.IsDisplayCountry() == true)
							Buffer.Format( _T("<%s> %s"), theApp.IP2Country->GetCountryCode(Friend->m_dwLastUsedIP), Friend->m_strName );
						else
							Buffer.Format( _T("%s"), Friend->m_strName );
						cur_rec.left += 20;
						if (thePrefs.IsDisplayFlag() == true)
						{
							POINT FlagPoint = {cur_rec.left, (cur_rec.top + 3)};
							rt_FlagImageList.Draw(dc, theApp.IP2Country->GetFlagNO(Friend->m_dwLastUsedIP), FlagPoint, ILD_NORMAL);
							cur_rec.left += 20;
							dc->DrawText(Buffer, Buffer.GetLength(), &cur_rec, DLC_DT_TEXT);
							cur_rec.left -= 20;
						}
						else
							dc->DrawText(Buffer, Buffer.GetLength(), &cur_rec, DLC_DT_TEXT);
						cur_rec.left -= 20;
					}
					break;
				}
				case 1:
				{
					if (ClientCredit != NULL)
						Buffer = CastItoXBytes(ClientCredit->GetUploadedTotal(), false, false);
					else
						Buffer.Empty();
					break;
				}
				case 2:
				{
					if (ClientCredit != NULL)
						Buffer = CastItoXBytes(ClientCredit->GetDownloadedTotal(), false, false);
					else
						Buffer.Empty();
					break;
				}
				case 3:
				{
					if (Client != NULL)
					{
						Buffer = Client->GetClientSoftVer();
						if (Buffer.IsEmpty() == true)   Buffer = GetResString(IDS_UNKNOWN);
					}
					else
						Buffer.Empty();
					break;
				}
				case 4:
				{
					if ( (Client != NULL) && (Client->credits != NULL) )
					{
						if (theApp.clientcredits->CryptoAvailable() == true)
						{
							switch ( Client->credits->GetCurrentIdentState(Client->GetIP()) )
							{
								case IS_NOTAVAILABLE:
									Buffer = GetResString(IDS_IDENTNOSUPPORT);
									break;
								case IS_IDFAILED:
								case IS_IDNEEDED:
								case IS_IDBADGUY:
									Buffer = GetResString(IDS_IDENTFAILED);
									break;
								case IS_IDENTIFIED:
									Buffer = GetResString(IDS_IDENTOK);
									break;
							}
						}
						else
							Buffer = GetResString(IDS_IDENTNOSUPPORT);
					}
					else
						Buffer.Empty();
					break;
				}
				case 5:
				{
					Buffer = md4str(Friend->m_abyUserhash);
					break;
				}
				case 6:
				{
					if (Friend->m_dwLastSeen > 0)
					{
						CTime LastSeen(time_t(Friend->m_dwLastSeen));
						Buffer = LastSeen.Format(thePrefs.GetDateTimeFormat());
					}
					else
						Buffer = GetResString(IDS_UNKNOWN);
				}
			}
			if (iColumn != 0)   dc->DrawText(Buffer, Buffer.GetLength(), &cur_rec, DLC_DT_TEXT);
			cur_rec.left += GetColumnWidth(iColumn);
		}
	}
	//draw rectangle around selected item(s)
	if ( (lpDrawItemStruct->itemAction | ODA_SELECT) && (lpDrawItemStruct->itemState & ODS_SELECTED) )
	{
		RECT outline_rec = lpDrawItemStruct->rcItem;

		outline_rec.top--;
		outline_rec.bottom++;
		dc->FrameRect(&outline_rec, &CBrush(GetBkColor()));
		outline_rec.top++;
		outline_rec.bottom--;
		outline_rec.left++;
		outline_rec.right--;

		if ( (lpDrawItemStruct->itemID > 0) && GetItemState((lpDrawItemStruct->itemID - 1), LVIS_SELECTED) )
			outline_rec.top--;

		if ( (lpDrawItemStruct->itemID + 1 < UINT(GetItemCount())) &&
			GetItemState((lpDrawItemStruct->itemID + 1), LVIS_SELECTED) )
		{
			outline_rec.bottom++;
		}

		if (bCtrlFocused)
			dc->FrameRect(&outline_rec, &CBrush(m_crFocusLine));
		else
			dc->FrameRect(&outline_rec, &CBrush(m_crNoFocusLine));
	}
	//
	if (m_crWindowTextBk == CLR_NONE)   dc.SetBkMode(iOldBkMode);
	dc.SelectObject(pOldFont);
	dc.SetTextColor(crOldTextColor);
}

/*
void CRT_FriendListCtrl::UpdateFriend(int iItem, const CFriend* pFriend)
{
	SetItemText(iItem,0,pFriend->m_strName);

	int iImage;
    if (!pFriend->GetLinkedClient())
		iImage = 0;
	else if (pFriend->GetLinkedClient()->socket && pFriend->GetLinkedClient()->socket->IsConnected())
		iImage = 2;
	else
		iImage = 1;
// RT, Keep Friend Slot
	if (thePrefs.IsCurrentFS(pFriend->m_abyUserhash) == true)   iImage = 3;
// End
	SetItem(iItem,0,LVIF_IMAGE,0,iImage,0,0,0,0);
}
*/

void CRT_FriendListCtrl::AddFriend(const CFriend* pFriend)
{
	if (theApp.emuledlg->IsRunning() == false)   return;
	//
	int iItem = InsertItem(LVIF_TEXT|LVIF_PARAM, GetItemCount(), pFriend->m_strName, 0, 0, 0, (LPARAM)pFriend);
	if (iItem >= 0)   Update(iItem);
//		UpdateFriend(iItem, pFriend);
	theApp.emuledlg->transferwnd->UpdateListCount(RT_LPI_FRIEND_LIST);
}

void CRT_FriendListCtrl::RemoveFriend(const CFriend* pFriend)
{
	if (theApp.emuledlg->IsRunning() == false)   return;
	//
	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)pFriend;
	int iItem = FindItem(&find);
	if (iItem != -1)   DeleteItem(iItem);
	theApp.emuledlg->transferwnd->UpdateListCount(RT_LPI_FRIEND_LIST);
}

void CRT_FriendListCtrl::RefreshFriend(const CFriend* pFriend)
{
	if (theApp.emuledlg->IsRunning() == false)   return;
	//
	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)pFriend;
	int iItem = FindItem(&find);
	if (iItem != -1)   Update(iItem);
//	UpdateFriend(iItem, pFriend);
}

void CRT_FriendListCtrl::OnContextMenu(CWnd* /*pWnd*/, CPoint point)
{
	CTitleMenu FriendMenu;
	FriendMenu.CreatePopupMenu();
	FriendMenu.AddMenuTitle(GetResString(IDS_FRIENDLIST), true);
	FriendMenu.AppendMenu(MF_SEPARATOR);

	if (GetSelectedCount() > 1)
	{
		FriendMenu.AppendMenu( MF_STRING | MF_GRAYED, MP_DETAIL, GetResString(IDS_SHOWDETAILS), _T("CLIENTDETAILS") );
		FriendMenu.AppendMenu( MF_STRING | MF_GRAYED, MP_ADDFRIEND, GetResString(IDS_ADDAFRIEND), _T("ADDFRIEND") );
		FriendMenu.AppendMenu( MF_STRING | MF_ENABLED, MP_REMOVEFRIEND, GetResString(IDS_REMOVEFRIEND), _T("DELETEFRIEND") );
		FriendMenu.AppendMenu( MF_STRING | MF_GRAYED, MP_MESSAGE, GetResString(IDS_SEND_MSG), _T("SENDMESSAGE") );
		FriendMenu.AppendMenu( MF_STRING | MF_GRAYED, MP_SHOWLIST, GetResString(IDS_VIEWFILES) , _T("VIEWFILES") );
		FriendMenu.AppendMenu( MF_STRING | MF_GRAYED, MP_FRIENDSLOT, GetResString(IDS_FRIENDSLOT), _T("FRIENDSLOT") );
		FriendMenu.SetDefaultItem(MP_REMOVEFRIEND);
	}
	else
	{
		const CFriend* Friend = NULL;
		int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
		if (iSel != -1)
		{
			Friend = (CFriend*)GetItemData(iSel);
			FriendMenu.AppendMenu( MF_STRING,MP_DETAIL, GetResString(IDS_SHOWDETAILS), _T("CLIENTDETAILS") );
			FriendMenu.SetDefaultItem(MP_DETAIL);
		}

		FriendMenu.AppendMenu( MF_STRING, MP_ADDFRIEND, GetResString(IDS_ADDAFRIEND), _T("ADDFRIEND") );
		FriendMenu.AppendMenu( MF_STRING | (Friend ? MF_ENABLED : MF_GRAYED), MP_REMOVEFRIEND, GetResString(IDS_REMOVEFRIEND), _T("DELETEFRIEND") );
		FriendMenu.AppendMenu( MF_STRING | (Friend ? MF_ENABLED : MF_GRAYED), MP_MESSAGE, GetResString(IDS_SEND_MSG), _T("SENDMESSAGE") );
		FriendMenu.AppendMenu( MF_STRING | ((Friend==NULL || (Friend && Friend->GetLinkedClient() && !Friend->GetLinkedClient()->GetViewSharedFilesSupport())) ? MF_GRAYED : MF_ENABLED), MP_SHOWLIST, GetResString(IDS_VIEWFILES) , _T("VIEWFILES") );
		FriendMenu.AppendMenu( MF_STRING, MP_FRIENDSLOT, GetResString(IDS_FRIENDSLOT), _T("FRIENDSLOT") );
		// Keep Friend Slot
		if ( (Friend) && (thePrefs.IsFriendSlotAuto() == false) &&
			((Friend->GetLinkedClient() != NULL) || (thePrefs.IsKeepFriendSlot() == true)) )
		{
			FriendMenu.EnableMenuItem(MP_FRIENDSLOT, MF_ENABLED);
		}
		else
			FriendMenu.EnableMenuItem(MP_FRIENDSLOT, MF_GRAYED);
		FriendMenu.CheckMenuItem(MP_FRIENDSLOT, (Friend && Friend->GetFriendSlot()) ? MF_CHECKED : MF_UNCHECKED);
	}
	GetPopupMenuPos(*this, point);
	FriendMenu.TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y, this);
}

BOOL CRT_FriendListCtrl::OnCommand(WPARAM wParam, LPARAM lParam)
{
	CTypedPtrList <CPtrList, CFriend*> FriendList;
	POSITION ListPos = GetFirstSelectedItemPosition();
	while (ListPos != NULL)
	{
		int Index = GetNextSelectedItem(ListPos);
		if (Index >= 0)   FriendList.AddTail( (CFriend*)GetItemData(Index) );
	}
	// Multi Select
	if (FriendList.GetCount() > 1)
	{
		if (wParam == MP_REMOVEFRIEND)
		{
			rt_IsAcceptUpdate = false;
			CFriend* Friend = NULL;
			ListPos = FriendList.GetHeadPosition();
			while (ListPos != NULL)
			{
				Friend = FriendList.GetNext(ListPos);
				theApp.friendlist->RemoveFriend(Friend);
			}
			rt_IsAcceptUpdate = true;
			UpdateList();
		}
		return true;
	}
	else if (FriendList.GetCount() < 1)
		return true;
	// Single Select
	rt_IsAcceptUpdate = true;
	CFriend* Friend = FriendList.GetHead();
	switch (wParam)
	{
		case MP_MESSAGE:
		{
			if (Friend->GetLinkedClient() != NULL)
				theApp.emuledlg->chatwnd->StartSession( Friend->GetLinkedClient() );
			else
			{
				CUpDownClient* ChatClient = new CUpDownClient(0, Friend->m_nLastUsedPort, Friend->m_dwLastUsedIP, 0, 0, true);
				ChatClient->SetUserName(Friend->m_strName);
				theApp.clientlist->AddClient(ChatClient);
				theApp.emuledlg->chatwnd->StartSession(ChatClient);
			}
			break;
		}
		case MP_ADDFRIEND:
		{
			CAddFriend dialog2;
			dialog2.DoModal();
			break;
		}
		case MP_REMOVEFRIEND:
			theApp.friendlist->RemoveFriend(Friend);
			break;
		case MPG_ALTENTER:
		case MP_DETAIL:
			ShowFriendDetails(Friend);
			break;
		case MP_SHOWLIST:
		{
			if (Friend->GetLinkedClient() != NULL)
				Friend->GetLinkedClient()->RequestSharedFileList();
			else
			{
				CUpDownClient* NewClient = new CUpDownClient(0, Friend->m_nLastUsedPort, Friend->m_dwLastUsedIP, 0, 0, true);
				NewClient->SetUserName(Friend->m_strName);
				theApp.clientlist->AddClient(NewClient);
				NewClient->RequestSharedFileList();
			}
			break;
		}
		case MP_FRIENDSLOT:
		{
			// Keep Friend Slot
			theApp.friendlist->SetFriendSlot( Friend, Friend->GetFriendSlot() );
			break;
		}
	}
	return true;
}

void CRT_FriendListCtrl::OnNMDblclk(NMHDR *pNMHDR, LRESULT *pResult)
{
	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	if (iSel != -1)   ShowFriendDetails( (CFriend*)GetItemData(iSel) );
	*pResult = 0;
}

void CRT_FriendListCtrl::ShowFriendDetails(const CFriend* pFriend)
{
	if (pFriend)
	{
		if (pFriend->GetLinkedClient() != NULL)
		{
			CClientDetailDialog dialog(pFriend->GetLinkedClient());
			dialog.DoModal();
		}
		else
		{
			CAddFriend dlg;
			dlg.m_pShowFriend = const_cast<CFriend*>(pFriend);
			dlg.DoModal();
		}
	}
}

BOOL CRT_FriendListCtrl::PreTranslateMessage(MSG* pMsg) 
{
   	if ( pMsg->message == 260 && pMsg->wParam == 13 && GetAsyncKeyState(VK_MENU) < 0 )
	{
		PostMessage(WM_COMMAND, MPG_ALTENTER, 0);
		return TRUE;
	}
	else if (pMsg->message == WM_KEYDOWN && pMsg->wParam == VK_DELETE)
		PostMessage(WM_COMMAND, MP_REMOVEFRIEND, 0);
	else if (pMsg->message == WM_KEYDOWN && pMsg->wParam == VK_INSERT)
		PostMessage(WM_COMMAND, MP_ADDFRIEND, 0);

	return CMuleListCtrl::PreTranslateMessage(pMsg);
}

void CRT_FriendListCtrl::OnLvnColumnclick(NMHDR *pNMHDR, LRESULT *pResult)
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	// Determine ascending based on whether already sorted on this column
	int iSortItem = GetSortItem();
	bool bOldSortAscending = GetSortAscending();
	bool bSortAscending = (iSortItem != pNMListView->iSubItem) ? true : !bOldSortAscending;

	// Item is column clicked
	iSortItem = pNMListView->iSubItem;

	// Sort table
	SetSortArrow(iSortItem, bSortAscending);
	SortItems( SortProc, MAKELONG(iSortItem, (bSortAscending ? 0 : 0x0001)) );

	*pResult = 0;
}

int CRT_FriendListCtrl::SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	CFriend* Friend1 = (CFriend*)lParam1;
	CFriend* Friend2 = (CFriend*)lParam2; 
	if (Friend1 == NULL || Friend2 == NULL)   return 0;
	CUpDownClient* Client1 = Friend1->GetLinkedClient();
	CUpDownClient* Client2 = Friend2->GetLinkedClient();
	CClientCredits* ClientCredit1 = NULL;
	CClientCredits* ClientCredit2 = NULL;
	if (Client1 != NULL)   ClientCredit1 = Client1->credits;
	if (Client2 != NULL)   ClientCredit2 = Client2->credits;
	if (ClientCredit1 == NULL)   ClientCredit1 = theApp.clientcredits->GetCredit(Friend1->m_abyUserhash, false);
	if (ClientCredit2 == NULL)   ClientCredit2 = theApp.clientcredits->GetCredit(Friend2->m_abyUserhash, false);
	//
	int iResult;
	switch ( LOWORD(lParamSort) )
	{
		case 0:
			iResult = CompareLocaleStringNoCase(Friend1->m_strName, Friend2->m_strName);
			break;
		case 1:
			if ( (ClientCredit1 == NULL) && (ClientCredit2 == NULL) )
				iResult = 0;
			else if (ClientCredit1 == NULL)
				iResult = -1;
			else
			{
				if (ClientCredit2 == NULL)
					iResult = 1;
				else
					iResult = ClientCredit1->GetUploadedTotal() - ClientCredit2->GetUploadedTotal();
			}
			break;
		case 2:
			if ( (ClientCredit1 == NULL) && (ClientCredit2 == NULL) )
				iResult = 0;
			else if (ClientCredit1 == NULL)
				iResult = -1;
			else
			{
				if (ClientCredit2 == NULL)
					iResult = 1;
				else
					iResult = ClientCredit1->GetDownloadedTotal() - ClientCredit2->GetDownloadedTotal();
			}
			break;
		case 3:
			if ( (Client1 == NULL) && (Client2 == NULL) )
				iResult = 0;
			else if (Client1 == NULL)
				iResult = -1;
			else
			{
				if (Client2 == NULL)
					iResult = 1;
				else
					iResult = CompareLocaleStringNoCase( Client1->GetClientSoftVer(), Client2->GetClientSoftVer() );
			}
			break;
		case 4:
			if ( (ClientCredit1 == NULL) && (ClientCredit2 == NULL) )
				iResult = 0;
			else if (ClientCredit1 == NULL)
				iResult = -1;
			else
			{
				if (ClientCredit2 == NULL)
					iResult = 1;
				else
					iResult = ClientCredit1->GetCurrentIdentState(Client1->GetIP()) - ClientCredit2->GetCurrentIdentState(Client2->GetIP());
			}
			break;
		case 5:
			iResult =  CompareLocaleStringNoCase( md4str(Friend1->m_abyUserhash), md4str(Friend2->m_abyUserhash) );
			break;
		case 6:
			iResult = Friend1->m_dwLastSeen - Friend2->m_dwLastSeen;
			break;
		default:
			return 0;
	}
	if (HIWORD(lParamSort))   iResult = -iResult;
	return iResult;
}

void CRT_FriendListCtrl::UpdateList()
{
	if (rt_IsAcceptUpdate == false)   return;
	theApp.emuledlg->transferwnd->UpdateListCount(RT_LPI_FRIEND_LIST);
	SortItems( SortProc, MAKELONG(GetSortItem(), (GetSortAscending() ? 0 : 0x0001)) );
}
