//
#include "stdafx.h"
#include "emule.h"
#include "emuleDlg.h"
#include "FriendList.h"
#include "TransferWnd.h"
#include "SearchResultsWnd.h"
#include "SearchDlg.h"
#include "SharedFilesWnd.h"
#include "ChatWnd.h"
#include "IrcWnd.h"
#include "StatisticsDlg.h"
#include "PreferencesDlg.h"
#include "KademliaWnd.h"
#include "KadSearchListCtrl.h"
#include "KadContactListCtrl.h"
#include "kademlia/kademlia/kademlia.h"
#include "MuleToolbarCtrl.h"
#include "TaskbarNotifier.h"
#include "MuleStatusBarCtrl.h"
#include "Preferences.h"
#include "Sockets.h"
#include "UploadQueue.h"
#include "OtherFunctions.h"
#include "RT_GUI.h"
#include "RT_MenuCommands.h"
// Add Server Dialog
#include "ED2KLink.h"
#include "ServerWnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// **************************
// *** CMuleStatusBarCtrl ***
// **************************
void CMuleStatusBarCtrl::OnRButtonDblClk(UINT nFlags, CPoint point)
{
	int Pane = GetPaneAtPosition(point);
	switch (Pane){
		case -1:
		case SBarLog:
			return;
		case SBarUsers:
		case SBarUpDown:
		case SBarConnected:
			thePrefs.SetStatusExpand( Pane, !thePrefs.IsStatusExpand(Pane) );
			theApp.emuledlg->SetStatusBarPartsSize();
			break;
	}
}

// *********************
// *** CExitSmoothly ***
// *********************
//
CExitSmoothly::CExitSmoothly(CWnd* pParent) : CDialog(RT_IDD_EXIT_SMOOTHLY, pParent)
{
	ForceExit = false;
}

CExitSmoothly::~CExitSmoothly()
{
}

BOOL CExitSmoothly::OnInitDialog()
{
	UploadCountTotal = theApp.uploadqueue->GetUploadQueueLength();
	CurrentUploadCount = 0;

	return TRUE;
}

bool CExitSmoothly::CheckUploadQueueEmpty()
{
	if ( (theApp.uploadqueue->GetUploadQueueLength() == 0) || (ForceExit == true) )   return true;
	if (theApp.uploadqueue->GetUploadQueueLength() != CurrentUploadCount){
		CString Buffer;
		CurrentUploadCount = theApp.uploadqueue->GetUploadQueueLength();
		Buffer.Format(GetResString(RT_IDS_WAITING_UL_COMPLETE), CurrentUploadCount);
		GetDlgItem(RT_IDC_EXIT_SMOOTHLY)->SetWindowText(Buffer);
	}
	return false;
}

BEGIN_MESSAGE_MAP(CExitSmoothly, CDialog)
ON_BN_CLICKED(RT_IDC_EXIT_NOW, OnBnClickedIdcExitNow)
END_MESSAGE_MAP()

void CExitSmoothly::OnBnClickedIdcExitNow()
{
	ForceExit = true;
}

// *********************
// *** CAddServerDlg ***
// *********************
//
CAddServerDlg::CAddServerDlg(CWnd* pParent)	: CDialog(RT_IDD_ADD_SERVER, pParent)
{
}

CAddServerDlg::~CAddServerDlg()
{
}

BOOL CAddServerDlg::OnInitDialog()
{
    GetDlgItem(RT_IDC_AS_ADD_GROUP)->SetWindowText( GetResString(IDS_SV_NEWSERVER) );
    GetDlgItem(RT_IDC_AS_IPADDRESS_TEXT)->SetWindowText( GetResString(IDS_SV_ADDRESS) );
    GetDlgItem(RT_IDC_AS_PORT_TEXT)->SetWindowText( GetResString(IDS_SV_PORT) );
    GetDlgItem(RT_IDC_AS_NAME_TEXT)->SetWindowText( GetResString(IDS_SW_NAME) );
    GetDlgItem(RT_IDC_AS_ADD)->SetWindowText( GetResString(IDS_SV_ADD) );
    GetDlgItem(RT_IDC_AS_UPDATE_GROUP)->SetWindowText( GetResString(IDS_SV_MET) );
    GetDlgItem(RT_IDC_AS_UPDATE)->SetWindowText( GetResString(IDS_SV_UPDATE) );
	return TRUE;
}

BEGIN_MESSAGE_MAP(CAddServerDlg, CDialog)
ON_BN_CLICKED(RT_IDC_AS_ADD, OnBnClickedIdcAsAdd)
ON_BN_CLICKED(RT_IDC_AS_UPDATE, OnBnClickedIdcAsUpdate)
END_MESSAGE_MAP()

// Add Server
void CAddServerDlg::OnBnClickedIdcAsAdd()
{
	CString ServerAddress;
	if (GetDlgItem(RT_IDC_AS_IPADDRESS)->GetWindowTextLength() == 0){
		AfxMessageBox( GetResString(IDS_SRV_ADDR) );
		return;
	}
	else
		GetDlgItem(RT_IDC_AS_IPADDRESS)->GetWindowText(ServerAddress);

	uint16 ServerPort = 0;
	if (_tcsncmp(ServerAddress, _T("ed2k://"), 7) == 0){
		CED2KLink* pLink = NULL;
		try{
			pLink = CED2KLink::CreateLinkFromUrl(ServerAddress);
			ServerAddress.Empty();
			if (pLink && pLink->GetKind() == CED2KLink::kServer){
				CED2KServerLink* pServerLink = pLink->GetServerLink();
				if (pServerLink){
					ServerAddress = ipstr( pServerLink->GetIP() );
					ServerPort = pServerLink->GetPort();
					SetDlgItemText(RT_IDC_AS_IPADDRESS, ServerAddress);
					SetDlgItemInt(RT_IDC_AS_PORT, ServerPort, FALSE);
				}
			}
		}
		catch(CString strError){
			AfxMessageBox(strError);
			ServerAddress.Empty();
		}
		delete pLink;
	}
	else{
		if (GetDlgItem(RT_IDC_AS_PORT)->GetWindowTextLength() == 0){
			AfxMessageBox( GetResString(IDS_SRV_PORT) );
			return;
		}

		BOOL bTranslated = FALSE;
		ServerPort = GetDlgItemInt(RT_IDC_AS_PORT, &bTranslated, FALSE);
		if (bTranslated == FALSE){
			AfxMessageBox( GetResString(IDS_SRV_PORT) );
			return;
		}
	}

	if (ServerAddress.IsEmpty() || ServerPort == 0){
		AfxMessageBox( GetResString(IDS_SRV_ADDR) );
		return;
	}

	CString ServerName;
	GetDlgItem(RT_IDC_AS_NAME)->GetWindowText(ServerName);

	theApp.emuledlg->serverwnd->AddServer(ServerPort, ServerAddress, ServerName);
}

// Update Server.met form URL
void CAddServerDlg::OnBnClickedIdcAsUpdate()
{
	CString URL;
	GetDlgItem(RT_IDC_AS_URL)->GetWindowText(URL);
	
	if (URL.IsEmpty() == true)
		AfxMessageBox( GetResString(IDS_SRV_NOURLAV) );
	else
		theApp.emuledlg->serverwnd->UpdateServerMetFromURL(URL);
}

// **********************
// *** CMessageDialog ***
// **********************
//
CMessageDialog::CMessageDialog(CWnd* pParent) : CDialog(RT_IDD_MESSAGE, pParent)
{
}

CMessageDialog::~CMessageDialog()
{
}

void CMessageDialog::ShowMessage(CString NewValue, uint32 SleepTime)
{
	GetDlgItem(RT_IDC_MD_MESSAGE)->SetWindowText( NewValue );
	Sleep(SleepTime);
}