// by Superlexx, based on IPFilter from eMule project, http://emule-project.net

#include "stdafx.h"
#include "emule.h"
#include "emuledlg.h"
#include "otherfunctions.h"
#include "Preferences.h"
#include "EnBitmap.h"
#include "RT_Opcodes.h"
#include "RT_IP2Country.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*
const uint16 FlagCount = 199;
const CString CountryCodeList[] = {
			"AF","AL","DZ","AD","AO","AG","AR","AM","AU","AT","AZ",
			"BS","BH","BD","BB","BY","BE","BZ","BJ","BT","BO","BA","BW","BR","BN","BG","BF","BI",
			"KH","CM","CA","CV","CF","TD","CL","CN","CO","KM","CG","CD","CR","CI","HR","CU","CY","CZ",
			"DK","DJ","DM","DO",
			"TP","EC","EG","SV","GQ","ER","EE","ET",
			"FJ","FI","FR",
			"GA","GM","GE","DE","GH","GR","GD","GT","GN","GW","GY",
			"HT","VA","HN","HU",
			"IS","IN","ID","IR","IQ","IE","IL","IT",
			"JM","JP","JO",
			"KZ","KE","KI","KR","**","KW","KG",
			"LA","LV","LB","LS","LR","LY","LI","LT","LU",
			"MK","MG","MW","MY","MV","ML","MT","MH","MR","MU","MX","FM","MD","MC","MN","MA","MZ","MM",
			"NA","NR","NP","NL","NZ","NI","NE","NG","NO",
			"OM",
			"PK","**","PW","PA","PG","PY","PE","PH","PL","PT",
			"QA",
			"RO","RU","RW",
			"KN","LC","VC","WS","SM","ST","SA","SN","SC","SL","SG","SK","SI","SB","SO","ZA","**",
			"ES","LK","SD","SR","SZ","SE","CH","SY",
			"TW", "TJ","TZ","TH","TG","TO","TT","TN","TR","TM","TV",
			"UG","UA","AE","UK","US","UY","UZ",
			"VU","VE","VN",
			"YE","YU",
			"ZM","ZW",
			"GB","HK","MO","PS"
};
*/

// 0 = Unuse, Fill **
const CString CountryCodeString = _T("**AFALDZADAOAGARAMAUATAZBSBHBDBBBYBEBZBJBTBOBABWBRBNBGBFBIKHCMCACVCFTDCLCNCOKMCGCDCRCIHRCUCYCZDKDJDMDOTPECEGSVGQEREEETFJFIFRGAGMGEDEGHGRGDGTGNGWGYHTVAHNHUISINIDIRIQIEILITJMJPJOKZKEKIKR**KWKGLALVLBLSLRLYLILTLUMKMGMWMYMVMLMTMHMRMUMXFMMDMCMNMAMZMMNANRNPNLNZNINENGNOOMPK**PWPAPGPYPEPHPLPTQARORURWKNLCVCWSSMSTSASNSCSLSGSKSISBSOZA**ESLKSDSRSZSECHSYTWTJTZTHTGTOTTTNTRTMTVUGUAAEUKUSUYUZVUVEVNYEYUZMZWGBHKMOPS");

CIP2Country::CIP2Country()
{
	rt_IsEnableCountryCode = true;
	SetCountryCode();
	rt_IsEnableLocation = LoadLocation();
	rt_IsEnableCountryCode = LoadCountryCodeByDAT();
	if (rt_IsEnableCountryCode == false)   rt_IsEnableLocation = false;
}

CIP2Country::~CIP2Country()
{
	RemoveAllIPs();
}

void CIP2Country::AddIPRange(uint32 IPfrom, uint32 IPto, uint8 FlagNO)
{
	IP2Country_Struct* NewRange = new IP2Country_Struct;

	NewRange->IPend = IPto;
	NewRange->FlagNO = FlagNO;

	IPlist.SetAt(IPfrom, NewRange);
}

void CIP2Country::RemoveAllIPs()
{
	uint32 Key;
	IP2Country_Struct* Value;
	POSITION Pos = IPlist.GetHeadPosition();
	POSITION CurrentPos;
	while (Pos != NULL)
	{
		CurrentPos = Pos;
		IPlist.GetNextAssoc(Pos, Key, Value);
		delete Value;
		IPlist.RemoveAt(CurrentPos);
	}
}

bool CIP2Country::LoadCountryCodeByDAT()
{
	bool IsEnableCountryCode = false;

	// Is Need Update
	CString FilenameCSV, FilenameDAT;
	FilenameDAT.Format( _T("%sRT_IP2Country.dat"), thePrefs.GetConfigDir() );
	FilenameCSV.Format( _T("%sip-to-country.csv"), thePrefs.GetConfigDir() );
	CFileStatus StatusCSV, StatusDAT;
	CFile::GetStatus(FilenameCSV, StatusCSV);
	CFile::GetStatus(FilenameDAT, StatusDAT);
	if ( ((PathFileExists(FilenameDAT) == FALSE) || (StatusCSV.m_mtime > StatusDAT.m_mtime)) &&
		(PathFileExists(FilenameCSV) == TRUE) )
	{
		if (AfxMessageBox(GetResString(RT_IDS_IS_IMPORT_IP2COUNTRY_CSV), MB_YESNO | MB_DEFBUTTON3) == IDYES)
			return LoadCountryCode();
	}
	//
	RemoveAllIPs();
	CFile SourceFile;
	CFileException FileEx;
	if (SourceFile.Open(FilenameDAT,  CFile::modeRead | CFile::typeBinary, &FileEx) == TRUE)
	{
		uint32 Head, IPlistCount, IPstart, IPend;
		CString CountryCode;
		SourceFile.Read( &Head, sizeof(uint32) );
		if (Head == 0)
			SourceFile.Read( &IPlistCount, sizeof(uint32) );
		else
			IPlistCount = Head;
		uint32 BufferSize = IPlistCount * (sizeof(uint32) + sizeof(uint32) + 2);
		BYTE* Buffer = new BYTE[BufferSize];
		uint32 BufferPos = 0;
		SourceFile.Read(Buffer, BufferSize);
		SourceFile.Close();
		for (uint32 i = 0; i < IPlistCount; i++)
		{
			memcpy( &IPstart, Buffer + BufferPos, sizeof(uint32) );
			BufferPos += sizeof(uint32);
			memcpy( &IPend, Buffer + BufferPos, sizeof(uint32) );
			BufferPos += sizeof(uint32);
			CountryCode.Format( _T("%c%c"), Buffer[BufferPos], Buffer[(BufferPos+1)] );
			BufferPos += 2;
			AddIPRange( IPstart, IPend, GetFlagNO(CountryCode) );
		}
		delete [] Buffer;
		IsEnableCountryCode = true;
		if (thePrefs.IsLogRatioVerbose() == true)
			theApp.QueueLogLine( false, _T(">> [RT Debug] Loaded { %s }"), FilenameDAT );
	}
	else
		AfxMessageBox(GetResString(RT_IDS_MISS_IP2COUNTRY), MB_ICONERROR);

	return IsEnableCountryCode;
}

void CIP2Country::SaveCountryCodeByDAT()
{
	CString Filename;
	Filename.Format( _T("%sRT_IP2Country.dat"), thePrefs.GetConfigDir() );
	CFile TargetFile;
	CFileException FileEx;
	if (TargetFile.Open(Filename, CFile::modeWrite | CFile::modeCreate | CFile::typeBinary, &FileEx) == false)
		return;
	// Write to Buffer
	uint32 IPlistCount = IPlist.GetCount();
	uint32 IPstart;
	IP2Country_Struct* Value;
	POSITION Pos = IPlist.GetHeadPosition();
	POSITION CurrentPos;
	uint32 BufferSize = IPlistCount * (sizeof(uint32) + sizeof(uint32) + 2);
	BYTE* Buffer = new BYTE[BufferSize];
	uint32 BufferPos = 0;
	while (Pos != NULL)
	{
		CurrentPos = Pos;
		IPlist.GetNextAssoc(Pos, IPstart, Value);
		memcpy( Buffer + BufferPos, &IPstart, sizeof(uint32) );
		BufferPos += sizeof(uint32);
		memcpy( Buffer + BufferPos, &Value->IPend, sizeof(uint32) );
		BufferPos += sizeof(uint32);
		memcpy( Buffer + BufferPos, CStringA(GetCountryCode(Value->FlagNO)), 2 );
		BufferPos += 2;
	}
	// Write to File
	try{
		uint32 Head = 0;
		TargetFile.Write(&Head, 4);
		TargetFile.Write(&IPlistCount, 4);
		TargetFile.Write(Buffer, BufferPos);
		TargetFile.Flush();
		TargetFile.Close();
		theApp.QueueLogLine( false, _T(">> [RT Debug] Created { %s }"), Filename );
	}
	catch (CFileException* error)
	{
		error->Delete();
		return;
	}
	delete [] Buffer;
}

bool CIP2Country::LoadCountryCode()
{
	CString Data, IPstart, IPend, CountryCode;
	TCHAR Buffer[1024];
	const int BufferLen = 1024;
	int CurrentPos = 0;
	bool IsEnableCountryCode = false;

	RemoveAllIPs();

	FILE* ReadFile;
	CString Filename;
	Filename.Format( _T("%sip-to-country.csv"), thePrefs.GetConfigDir() );
	ReadFile = _tfopen( Filename, _T("r") );
	if (ReadFile != NULL)
	{
		while (feof(ReadFile) == 0)
		{
			if (_fgetts(Buffer, BufferLen, ReadFile) == 0)   break;
			Data = Buffer;
			// we assume that the ip-to-country.csv is valid and doesn't cause any troubles
			// get & process IP range
			Data.Remove( _T('"') ); // get rid of the " signs
			CurrentPos = 0;
			IPstart = Data.Tokenize( _T(","), CurrentPos );
			if (CurrentPos == -1)   continue;
			IPend = Data.Tokenize( _T(","), CurrentPos );
			if (CurrentPos == -1)   continue;
			CountryCode = Data.Tokenize( _T(","), CurrentPos );   // 2 char Country Name
			if (CurrentPos == -1)   continue;
			CountryCode.MakeUpper();
			AddIPRange( _ttoi(IPstart), _ttoi(IPend), GetFlagNO(CountryCode) );
			IsEnableCountryCode = true;
		}
		fclose(ReadFile);
		if (thePrefs.IsLogRatioVerbose() == true)
			theApp.QueueLogLine( false, _T(">> [RT Debug] Loaded { %s }"), Filename );
		if (IsEnableCountryCode == true)   SaveCountryCodeByDAT();
	}
	else
		AfxMessageBox(GetResString(RT_IDS_MISS_IP2COUNTRY), MB_ICONERROR);

	return IsEnableCountryCode;
}

bool CIP2Country::LoadLocation()
{
	CString Data, CountryCode, Location;
	TCHAR Buffer[1024];
	const int BufferLen = 1024;
	int CurrentPos = 0;
	bool IsEnableLocation = false;

	LocationList.RemoveAll();
	LocationList.SetSize(RT_COUNTRY_COUNT);

	FILE* ReadFile;
	CString Filename;
	Filename.Format( _T("%sCountry_%s.csv"), thePrefs.GetLangDir(), thePrefs.GetLangDLLNameByID(thePrefs.GetLanguageID()).Tokenize(_T("."), CurrentPos) );
	ReadFile = _tfopen( Filename, _T("r") );
	if (ReadFile == NULL)
	{
		Filename.Format( _T("%sCountry_en_US.csv"), thePrefs.GetLangDir() );
		ReadFile = _tfopen( Filename, _T("r") );
	}
	if (ReadFile != NULL)
	{
		while (feof(ReadFile) == 0)
		{
			if (_fgetts(Buffer, BufferLen, ReadFile) == 0)   break;
			Data = Buffer;
			// we assume that the ip-to-country.csv is valid and doesn't cause any troubles
			// get & process IP range
			Data.Remove( _T('"') ); // get rid of the " signs
			CurrentPos = 0;
			CountryCode = Data.Tokenize( _T(",") , CurrentPos);
			if (CurrentPos == -1)   continue;
			Location = Data.Tokenize( _T(",") , CurrentPos);
			if (CurrentPos == -1)   continue;
			CountryCode.MakeUpper();
			const int StringLength = Location.GetLength() - 1;
			if (Location.GetAt(Location.GetLength() - 1) == 10)
			{
				Location.Delete(Location.GetLength() - 1);   // delete the EOL
			}
			SetLocation(CountryCode, Location);
			IsEnableLocation = true;
		}
		fclose(ReadFile);
		if (thePrefs.IsLogRatioVerbose() == true)
			theApp.QueueLogLine( false, _T(">> [RT Debug] Loaded { %s }"), Filename );
		// Set 0 = ** = Unknown
		SetLocation( _T("**"), GetResString(IDS_UNKNOWN) );
	}
	else
		AfxMessageBox(GetResString(RT_IDS_MISS_LOCATION), MB_ICONERROR);

	return IsEnableLocation;
}

void CIP2Country::SetLocation(CString CountryCode, CString Location)
{
	int FlagNO = GetFlagNO(CountryCode);
	if ( FlagNO < LocationList.GetCount() )   LocationList.SetAt(FlagNO, Location);
}

void CIP2Country::SetCountryCode()
{
	CString CountryCode;
	CountryCodeList.SetSize(RT_COUNTRY_COUNT);
	for (int i = 0; i < RT_COUNTRY_COUNT; i++)
	{
		CountryCode = CountryCodeString.Mid( (i * 2), 2 );
		CountryCodeList.SetAt(i, CountryCode);
	}
}

CString CIP2Country::GetCountryCode(uint32 IP)
{
	if (IP == 0)   return _T("**");
	return GetCountryCode( GetFlagNO(IP) );
}

CString CIP2Country::GetCountryCode(uint8 FlagNO)
{
	if ( (rt_IsEnableCountryCode == true) && (FlagNO < RT_COUNTRY_COUNT) )
	{
		return CountryCodeList.GetAt(FlagNO);
	}
	return _T("**");
}

CString CIP2Country::GetLocation(uint32 IP)
{
	return GetLocation( GetFlagNO(IP) );
}

CString CIP2Country::GetLocation(CString CountryCode)
{
	return GetLocation( GetFlagNO(CountryCode) );
}

CString CIP2Country::GetLocation(uint8 FlagNO)
{
	if (rt_IsEnableLocation == false)   return GetResString(IDS_DISABLED);
	//
	if ( FlagNO < LocationList.GetCount() )
		return LocationList.GetAt(FlagNO);
	else
		return GetResString(IDS_UNKNOWN);
}

uint8 CIP2Country::GetFlagNO(uint32 IP)
{
	if (rt_IsEnableCountryCode == false)   return RT_NO_FLAG;
	//
	if ( IP && (IPlist.IsEmpty() == false) )
	{
		IP = htonl(IP);

		POSITION Pos = IPlist.FindFirstKeyAfter(IP);
		if (Pos == NULL)
			Pos = IPlist.GetTailPosition();
		else
			IPlist.GetPrev(Pos);

		while (Pos != NULL)
		{
			const CIP2CountryList::CPair* Pair = IPlist.GetPrev(Pos);
			if (IP > Pair->m_value->IPend)   break;
			if (IP >= Pair->m_key && IP <= Pair->m_value->IPend)   return Pair->m_value->FlagNO;
		}
	}
	return RT_NO_FLAG;
}

uint8 CIP2Country::GetFlagNO(CString CountryCode)
{
	if (rt_IsEnableCountryCode == false)   return RT_NO_FLAG;
	//
	int ListPos = -1;
	do
	{
		ListPos++;
		ListPos = CountryCodeString.Find(CountryCode, ListPos);
		if (ListPos == -1)   return RT_NO_FLAG;
	}while( (ListPos % 2) == 1 );
	return (ListPos / 2);
}