// by Superlexx, based on IPFilter from eMule project, http://emule-project.net

#pragma once
#include <atlcoll.h>
#include "UpDownClient.h"

struct IP2Country_Struct
{
	uint32		IPend;
	uint8		FlagNO;
//	CString		CountryCode;
};

typedef CRBMap<uint32, IP2Country_Struct*>	CIP2CountryList;

class CIP2Country
{
public:
	CIP2Country();
	~CIP2Country();
	void		AddIPRange(uint32 IPfrom, uint32 IPto, uint8 FlagNO);
	void		RemoveAllIPs();
	bool		LoadCountryCode();
	bool		LoadLocation();
	void		SetLocation(CString CountryCode, CString Location);
	CString		GetCountryCode(uint32 IP);
	CString		GetCountryCode(uint8 FlagNO);
	void		SetCountryCode();
	CString		GetLocation(uint32 IP);
	CString		GetLocation(CString CountryCode);
	CString		GetLocation(uint8 FlagNO);
	uint8		GetFlagNO(uint32 IP);
	uint8		GetFlagNO(CString CountryCode);
private:
	bool		LoadCountryCodeByDAT();
	void		SaveCountryCodeByDAT();
	bool		rt_IsEnableCountryCode;
	bool		rt_IsEnableLocation;
	CIP2CountryList	IPlist;
	CArray<CString, CString&> CountryCodeList;
	CArray<CString, CString&> LocationList;
};