//
#pragma once

// Upload Score	
#define	RT_SCORE_BASIC				5			// Disable upload when score <
#define	RT_SCORE_DONT_UPLOAD		4			// Don't Upload when score <
#define	RT_SCORE_BANNED				0
#define	RT_SCORE_INVALID			1
#define	RT_SCORE_LEECHER			2
#define	RT_SCORE_GPL_EVILDOER		3
#define	RT_SCORE_WAITING			4
#define	RT_SCORE_RELEASE_LEVEL		0x01000000
#define	RT_SCORE_RELEASE			0x10000000
#define	RT_SCORE_FRIEND				0x20000000
#define	RT_SCORE_CREDIT1			0x30000000

// Country & Flag
#define	RT_NO_FLAG					0
#define	RT_MOD_COUNT				25
#define	RT_COUNTRY_COUNT			200

// Priority
enum RT_FilePriority
{
		RT_PR_VERYLOW				= 0,
		RT_PR_LOW,
		RT_PR_NORMAL,
		RT_PR_HIGH,
		RT_PR_VERYHIGH,
		// Count
		RT_PRIORITY_COUNT
};

// Leecher
#define RT_LEECHER					0x1F			// Client is Leecher
#define RT_LEECHER_COUNT_MAX		0x1E			// Check Transferred
// Credit
#define RT_CREDIT_FILE_VERSION		0x80			// New Struct
#define RT_CREDIT_RATIO_LOW_LIMIT	0.01f			// Low Limit of Credit Ratio
#define RT_CREDIT_LEECHER_COUNT		0x000000FF		// bit7 ~ bit0 = Leecher Count
#define RT_CREDIT_DONT_DOWNLOAD		0x00010000		// bit16 = Don't Download Flag
#define RT_FILE_RATIO_LOW_LIMIT		0.1f			// Low Limit of File Ratio

// File
#define RT_A4AF_SWAP_TIMER			900				// A4AF Swap Time (Sec)
#define RT_FILE_UPDATE_TIME			5000			// Update Info Time (Sec)
// File--Feature
#define RT_FF_RELEASE_RAREST_PART	0x00000001		// bit 0 = Release Rarest Part
#define RT_FF_HIDE_SECOND_PART		0x00000002		// bit 1 = Hide Second Part
#define RT_FF_RELEASE_PRIORITY		0x00000004		// bit 2 = Release Priority

// Color
#define RT_COLOR_SECTION			6
enum RT_Colors
{
		// Download Bar
		RT_CR_DB_MISS				= 0,
		RT_CR_DB_HAVE,
		RT_CR_DB_PENDING,
		RT_CR_DB_PROGRESS,
		// Client Bar
		RT_CR_CB_NEITHER,
		RT_CR_CB_BOTH,
		RT_CR_CB_HAVE,
		RT_CR_CB_CLIENT,
		RT_CR_CB_PENDING,
		RT_CR_CB_NEXT,
		// Uploaded Bar
		RT_CR_UB_1TIME,
		RT_CR_UB_2TIME,
		RT_CR_UB_3TIME,
		RT_CR_UB_4TIME,
		RT_CR_UB_5TIME,
		RT_CR_UB_6TIME,
		RT_CR_UB_7TIME,
		// Download Text
		RT_CR_DT_COMPLETED,
		RT_CR_DT_DOWNLOADING,
		RT_CR_DT_WAITING,
		RT_CR_DT_MISS,
		RT_CR_DT_STOPPED,
		// Shared Text
		RT_CR_ST_TRANSFERRED,
		RT_CR_ST_COMPLETED,
		RT_CR_ST_DOWNLOADING,
		RT_CR_ST_WAITING,
		// Client Text
		RT_CR_CT_TRADE,
		RT_CR_CT_TRANSFER,
		RT_CR_CT_BAD,
		// Count
		RT_COLOR_COUNT
};

// Start Next File
enum RT_StartNextFile
{
		RT_BY_PRIORITY				= 0,
		RT_BY_FILENAME,
		RT_BY_FILESIZE,
		RT_BY_REMAINING
};

// Extract Meta Data
enum RT_ExtractMetaData
{
		RT_EMD_DISABLE				= 0,
		RT_EMD_MP3AVI,
		RT_EMD_MEDIA_DETAIL
};

// Auto Backup Config
enum RT_AutoBackupConfig
{
		RT_ABC_DISABLE				= 0,
		RT_ABC_BACKUP1,
		RT_ABC_BACKUP2
};

// List Pane Items
enum RT_ListPaneItems
{
		RT_LPI_DOWNLOAD_LIST		= 0,
		RT_LPI_UPLOAD_LIST,
		RT_LPI_QUEUE_LIST,
		RT_LPI_CLIENT_LIST,
		RT_LPI_FRIEND_LIST,
		RT_LPI_COUNT
};

// Icon Number Order
enum RT_IconNumberOrder
{
		RT_INO_GENERAL				= 0,
		RT_INO_EMULE,
		RT_INO_MLDONKEY,
		RT_INO_EDONKEYHYBRID,
		RT_INO_SHAREAZA,
		RT_INO_AMULE,
		RT_INO_LPHANT,
		RT_INO_URL,
		RT_INO_FRIEND,
		RT_INO_EASTSHARE,
		RT_INO_EWOMBAT,
		RT_INO_LSD,
		RT_INO_MORPH,
		RT_INO_PHOENIX,
		RT_INO_PLUS,
		RT_INO_RT,
		RT_INO_SIVKA,
		RT_INO_WEBCACHE,
		RT_INO_COUNT
};

// MOD Number Order
enum RT_ModNumberOrder
{
		RT_MNO_OFFICIAL				= 0,
		RT_MNO_OTHER,
		RT_MNO_UNKNOWN,
		RT_MNO_ACAT,
		RT_MNO_AMULE,
		RT_MNO_EASTSHARE,
		RT_MNO_ECHANBLARD,
		RT_MNO_EF_MOD,
		RT_MNO_EWOMBAT,
		RT_MNO_HEBMULE,
		RT_MNO_LSD,
		RT_MNO_MFCK,
		RT_MNO_MORPH,
		RT_MNO_PAWCIO,
		RT_MNO_PEACE,
		RT_MNO_PHOENIX,
		RT_MNO_PLUS,
		RT_MNO_RT,
		RT_MNO_SF_IOM,
		RT_MNO_SIVKA,
		RT_MNO_STORM,
		RT_MNO_SWAT,
		RT_MNO_THE_BLACK_HAND,
		RT_MNO_WEBCACHE,
		RT_MNO_ZZUL,
		RT_MNO_COUNT
};

// RT, WebCache (Code by JP)
#define OP_WEBCACHEPROT				0x57 
#define OP_THE_LETTER_G				0x47	// yonatan http - first byte in an http GET header
#define OP_DONT_SEND_OHCBS			0xFE	// protocol == OP_WEBCACHEPROT
#define	OP_RESUME_SEND_OHCBS		0xFD	// protocol == OP_WEBCACHEPROT
#define OP_HTTP_CACHED_BLOCK		0xFF	// <Proxy-ip 4><IP 4><PORT 2><filehash 16><startoffset 4><endoffset 4>
// End