//
#include "stdafx.h"
#include "winsock2.h"
#include "Clientlist.h"
#include "emule.h"
#include "emuledlg.h"
#include "Ini2.h"
#include "OtherFunctions.h"
#include "Preferences.h"
#include "Pinger.h"
#include "opcodes.h"
#include "PartFile.h"
#include "ClientCredits.h"
#include "0RatioFile/RT_Other.h"
#include "0RatioFile/RT_Version.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//
// *********************
// *** OtherFunction ***
// *********************
//
CString InvalidChar = _T("\\/\":*?<>|;,");
// New Method for Cleanup Filename
CString CleanupFilename(CString filename)
{
	CString NewFilename, Buffer;
	NewFilename = URLDecode(filename);
	NewFilename.MakeLower();

	// remove substrings, defined in the preferences (.ini)
	CString TokenString;
	CString CleanupString = thePrefs.GetFilenameCleanups().MakeLower();
	int TokenPos = 0;
	TokenString = CleanupString.Tokenize(_T("|"), TokenPos);
	while (TokenString.IsEmpty() == false)
	{
		Buffer.Empty();
		for (int i = 0; i < TokenString.GetLength(); i++)   Buffer += _T("?");
		NewFilename.Replace(TokenString, Buffer);
		TokenString = CleanupString.Tokenize(_T("|"), TokenPos);
	}
	Buffer.Format( _T("%s"), NewFilename );
	NewFilename = URLDecode(filename);
	for (int i = 0; i < NewFilename.GetLength(); i++)
	{
		if ( Buffer.GetAt(i) == _T('?') )   NewFilename.SetAt( i, _T('?'));
	}

	// Replace . with Spaces - except the last one (extention-dot)
	int CurrentPos = 0;
	int LastDotPos = NewFilename.ReverseFind( _T('.') );
	if (LastDotPos > 0)
	{
		if ( NewFilename.GetAt(0) == _T('.') )   NewFilename.SetAt( 0, _T(' ') );
		CurrentPos = NewFilename.Find(_T('.'), CurrentPos);
		while ( (CurrentPos >= 0) && (CurrentPos < LastDotPos) )
		{
			if ( !isdigit(NewFilename.GetAt(CurrentPos - 1)) || !isdigit(NewFilename.GetAt(CurrentPos + 1)) )
				NewFilename.SetAt( CurrentPos, _T(' ') );
			CurrentPos = NewFilename.Find( _T('.'), (CurrentPos + 1) );
		}
	}

	// Replace Space-holders with Spaces
	NewFilename.Replace(_T('_'),_T(' '));
	NewFilename.Replace(_T("+"),_T(" ")); //SyruS for Jigle

	// SyruS additional cleanup
	// invalid for filenames
	for (int i = 0; i < InvalidChar.GetLength(); i++)
	{
		NewFilename.Replace( CString(InvalidChar.GetAt(i)), _T("") );
	}
	// other common nonsense (u can use dots here!)
	NewFilename.Replace( _T("="), _T("") );

	// Barry - Some additional formatting
	NewFilename.Replace(_T("()"), _T(""));
	NewFilename.Replace(_T("  "), _T(" "));
	NewFilename.Replace(_T(" ."), _T("."));
	NewFilename.Replace(_T("( "), _T("("));
	NewFilename.Replace(_T(" )"), _T(")"));
	NewFilename.Replace(_T("()"), _T(""));
	NewFilename.Replace(_T("{ "), _T("{"));
	NewFilename.Replace(_T(" }"), _T("}"));
	NewFilename.Replace(_T("{}"), _T(""));
	NewFilename.Replace(_T("[]"), _T(""));

	// Make leading Caps 
/*
	if (NewFilename.GetLength() > 1)
	{
		Buffer = NewFilename.GetAt(0);
		Buffer.MakeUpper();
		NewFilename.SetAt( 0, Buffer.GetAt(0) );
		int LengthLimit = NewFilename.GetLength() - 2;
		int DotPos = NewFilename.ReverseFind( _T('.') ) - 1;
		if (DotPos < 0)   DotPos = NewFilename.GetLength() - 1;
		for (int i = 0; i < DotPos; i++)
		{
			if ( (IsCharAlpha(NewFilename.GetAt(i)) == 0) && ((uint8)NewFilename.GetAt(i) < 0x80) )
			{
				if ( (i < LengthLimit) && isdigit(NewFilename.GetAt(i + 2)) )   continue;
				int LeadingPos = i + 1;
				Buffer = NewFilename.GetAt(LeadingPos);
				Buffer.MakeUpper();
				NewFilename.SetAt( LeadingPos, Buffer.GetAt(0) );
			}
		}
	}
*/
	NewFilename.Trim();
	return NewFilename;
}

// Adjust IP (1.2.3.4 -> 4.3.2.1)
uint32 AdjustIP(uint32 IP)
{
	uint32 Temp;
	BYTE* PosIP = (BYTE*)&IP;
	BYTE* PosTemp = (BYTE*)&Temp;
	PosTemp[0] = PosIP[3];
	PosTemp[1] = PosIP[2];
	PosTemp[2] = PosIP[1];
	PosTemp[3] = PosIP[0];
	return Temp;
}

// Compare Priority (> 1 , = 0, < -1)
int	ComparePriority(uint8 Priority1, uint8 Priority2)
{
	if (Priority1 == Priority2)   return 0;
	if (Priority1 > Priority2)
	{
		if (Priority1 == PR_VERYLOW)
			return -1;
		else
			return 1;
	}
	else
	{
		if (Priority2 == PR_VERYLOW)
			return 1;
		else
			return -1;
	}
}

// Compare Username (> 1 , = 0, < -1)
int	CompareUsername(const CUpDownClient* Client1, const CUpDownClient* Client2, bool SortPlus)
{
	int Result = 0;
	if ( (SortPlus == true) && (Client1->GetCountryCode() != Client2->GetCountryCode()) )
	{
		if (Client1->GetCountryCode().IsEmpty() == true)
			Result = -1;
		else
		{
			if (Client2->GetCountryCode().IsEmpty() == true)
				Result = 1;
			else
				Result = CompareLocaleStringNoCase( Client1->GetCountryCode(), Client2->GetCountryCode() );
		}
	}
	else
	{
		if ( Client1->GetUserName() == Client2->GetUserName() )
			Result = 0 ;
		else
		{
			if (Client1->GetUserName() == NULL)
				Result = -1;
			else
			{
				if (Client2->GetUserName() == NULL)
					Result = 1;
				else
					Result = CompareLocaleStringNoCase( Client1->GetUserName(), Client2->GetUserName() );
			}
		}
	}
	return Result;
}

// Compare UL/DL Total (> 1 , = 0, < -1)
int	CompareUDTotal(const CUpDownClient* Client1, const CUpDownClient* Client2, bool SortPlus)
{
	int Result = 0;
	if ( (Client1->credits != NULL) && (Client2->credits != NULL) )
	{
		if (SortPlus == true)
		{
			Result = Client1->credits->GetDownloadedTotal() - Client2->credits->GetDownloadedTotal();
			if (Result == 0)
				Result = Client1->credits->GetUploadedTotal() - Client2->credits->GetUploadedTotal();
		}
		else
		{
			Result = Client1->credits->GetUploadedTotal() - Client2->credits->GetUploadedTotal();
			if (Result == 0)
				Result = Client1->credits->GetDownloadedTotal() - Client2->credits->GetDownloadedTotal();
		}
	}
	return Result;
}

// Compare Software (> 1 , = 0, < -1)
int	CompareSoftware(const CUpDownClient* Client1, const CUpDownClient* Client2, bool SortPlus, int SortMode)
{
	int Result = 0;
	if (SortPlus == true)
	{
		if ( Client1->GetClientModVer() == Client2->GetClientModVer() )
		{
			if ( Client1->GetClientSoftVer() != Client2->GetClientSoftVer() )
				Result = CompareLocaleStringNoCase( Client1->GetClientSoftVer(), Client2->GetClientSoftVer() );
			else
				Result = CompareLocaleStringNoCase( Client1->GetUserName(), Client2->GetUserName() );
/*
			if ( Client1->GetClientSoft() == Client2->GetClientSoft() )
				Result = Client1->GetVersion() - Client2->GetVersion();
			else
				Result = Client1->GetClientSoft() - Client2->GetClientSoft();
*/
		}
		else
		{
			if ( (Client1->GetClientModVer().IsEmpty() == false) && (Client2->GetClientModVer().IsEmpty() == false) )
				Result = CompareLocaleStringNoCase( Client1->GetClientModVer(), Client2->GetClientModVer() );
			else
			{
				if (Client1->GetClientModVer().IsEmpty() == true)
					Result = SortMode;
				else
					Result = int(-1) * SortMode;
			}
		}
	}
	else
	{
		if ( Client1->GetClientSoftVer() != Client2->GetClientSoftVer() )
			Result = CompareLocaleStringNoCase( Client1->GetClientSoftVer(), Client2->GetClientSoftVer() );
		else
			Result = CompareLocaleStringNoCase( Client1->GetUserName(), Client2->GetUserName() );
/*
		if ( Client1->GetClientSoft() == Client2->GetClientSoft() )
		{
			if ( Client1->GetVersion() == Client2->GetVersion() )
				Result = CompareLocaleStringNoCase( Client1->GetClientModVer(), Client2->GetClientModVer() );
			else
				Result = Client1->GetVersion() - Client2->GetVersion();
		}
		else
			Result = Client1->GetClientSoft() - Client2->GetClientSoft();
*/
	}
	return Result * SortMode;
}

// Copy Directory
void CopyDirectory(CString Source, CString Target, bool IgnoreBak, bool DeleteBak, CString IgnoreFileList)
{
	IgnoreFileList.MakeLower();
	CFileFind Finder;
	BOOL IsFind;
	CString SourceFile, TargetFile, Buffer;
	CFileStatus SourceStatus, TargetStatus;
	//
	CString TargetFolder = Target;
	if ( TargetFolder.Right(1) != _T("\\") )   TargetFolder.Append( _T("\\") );
	Buffer = Source;
	if ( Buffer.Right(1) != _T("\\") )
		Buffer.Append( _T("\\*.*") );
	else
		Buffer.Append( _T("*.*") );
	//
	IsFind = Finder.FindFile(Buffer);
	while (IsFind == TRUE)
	{
		IsFind = Finder.FindNextFile();
		if ( (Finder.IsDirectory() == false) || (Finder.GetFileName().Left(1) != _T(".")) )
		{
			// Check .Bak and .Old
			Buffer = Finder.GetFilePath();
			Buffer.MakeLower();
			if ( (IgnoreFileList.IsEmpty() == true) || (IgnoreFileList.Find(Finder.GetFileName().MakeLower()) == -1) )
			{
				if ( (IgnoreBak == false) || ((Buffer.Find(_T(".bak")) == -1) && (Buffer.Find(_T(".old")) == -1)) )
				{
					SourceFile = Finder.GetFilePath();
					TargetFile = TargetFolder + Finder.GetFileName();
					CFile::GetStatus(SourceFile, SourceStatus);
					CFile::GetStatus(TargetFile, TargetStatus);
					if ( (SourceStatus.m_size > 0) &&
						((SourceStatus.m_size != TargetStatus.m_size) || (SourceStatus.m_mtime != TargetStatus.m_mtime)) )
					{
						::CopyFile(SourceFile, TargetFile, FALSE);
						theApp.QueueDebugLogLine( false, _T(">> [RT Debug] Backup { %s }"), SourceFile );
					}
				}
				else if (DeleteBak == true)
				{
					::DeleteFile(Buffer);
					theApp.QueueDebugLogLine( false, _T(">> [RT Debug] Delete Backup File { %s }"), Buffer );
				}
			}
		}
	}
}

// Move Directory
void MoveDirectory(CString Source, CString Target, bool IsOverWrite, CString CopyOnlyFileList)
{
	CopyOnlyFileList.MakeLower();
	CFileFind Finder;
	BOOL IsFind;
	CString SourceFile, TargetFile;
	CFileStatus SourceStatus, TargetStatus;
	//
	CString TargetFolder = Target;
	if ( TargetFolder.Right(1) != _T("\\") )   TargetFolder.Append( _T("\\") );
	CString Buffer = Source;
	if ( Buffer.Right(1) != _T("\\") )
		Buffer.Append( _T("\\*.*") );
	else
		Buffer.Append( _T("*.*") );
	IsFind = Finder.FindFile(Buffer);
	while (IsFind == TRUE)
	{
		IsFind = Finder.FindNextFile();
		if ( (Finder.IsDirectory() == false) || (Finder.GetFileName().Left(1) != _T(".")) )
		{
			SourceFile = Finder.GetFilePath();
			TargetFile = TargetFolder + Finder.GetFileName();
			bool IsCopyOnly = (CopyOnlyFileList.Find(Finder.GetFileName().MakeLower()) != -1);
			CFile::GetStatus(SourceFile, SourceStatus);
			CFile::GetStatus(TargetFile, TargetStatus);
			if (SourceStatus.m_size > 2)
			{
				if ( (SourceStatus.m_size != TargetStatus.m_size) || (SourceStatus.m_mtime != TargetStatus.m_mtime) )
				{
					if ( (PathFileExists(TargetFile) == FALSE) || (IsOverWrite == true) )
					{
						if (IsCopyOnly == true)
						{
							::CopyFile(SourceFile, TargetFile, FALSE);
						}
						else
						{
							_tremove(TargetFile);
							_trename(SourceFile, TargetFile);
						}
						theApp.QueueDebugLogLine( false, _T(">> [RT Debug] Backup { %s }"), SourceFile );
					}
				}
			}
		}
	}
}

// Clear Directory
void ClearDirectory(CString Directory)
{
	CFileFind Finder;
	BOOL IsFind;
	//
	IsFind = Finder.FindFile( Directory + _T("\\*.*") );
	while (IsFind == TRUE)
	{
		IsFind = Finder.FindNextFile();
		if ( (Finder.IsDirectory() == false) || (Finder.GetFileName().Left(1) != _T(".")) )
		{
			_tremove( Finder.GetFilePath() );
		}
	}
}

// RSA-CIDE by enkeyDev
class CKnownFile;
void MD4HashThis(void * input, int length, void * output)
{
	CKnownFile MD4;		// ridiculous!
	MD4.CreateHash((uchar *)input, length, (uchar *)output);
}

// RSA-CIDE by enkeyDev
bool HashPKMatch(void * public_key, int key_length, void * userhash)
{
	char key_hash[16];
	char user_hash[16];
	MD4HashThis(public_key, key_length, key_hash);
	md4cpy(user_hash, userhash);
	key_hash[5] = 0;	// reset client type infos
	key_hash[14] = 0;
	user_hash[5] = 0;
	user_hash[14] = 0;
	return !md4cmp(key_hash, user_hash);
}

// Random Port
uint16 GetRandomPort(CString PortList, uint16 IgnorePort)
{
	int RandomCount = -1;
	int StringLength;
	for (int i = 0; i < 2; i++)
	{
		int PortCount = 0;
		int	TokenPos = 0;
		CString TokenString = PortList.Tokenize( _T(","), TokenPos );
		while (TokenString.IsEmpty() == false)
		{
			TokenString.Trim();
			int RangPos = TokenString.Find( _T("~") );
			if (RangPos != -1)
			{
				// Multi Port
				if (RangPos == 0)   return 0;
				uint64 StartPort = 0, EndPort = 0;
				// Start
				CString Buffer = TokenString.Left(RangPos);
				Buffer.Trim();
				StringLength = Buffer.GetLength();
				if (StringLength > 5)   return 0;
				for (int i = 0; i < StringLength; i++)
				{
					if (isdigit(Buffer.GetAt(i)) == 0)   return 0;
					StartPort = (StartPort * 10) + (Buffer.GetAt(i) - _T('0'));
				}
				// End
				Buffer = TokenString.Right( (TokenString.GetLength() - RangPos - 1) );
				Buffer.Trim();
				StringLength = Buffer.GetLength();
				if (StringLength > 5)   return 0;
				for (int i = 0; i < StringLength; i++)
				{
					if (isdigit(Buffer.GetAt(i)) == 0)   return 0;
					EndPort = (EndPort * 10) + (Buffer.GetAt(i) - _T('0'));
				}
				//
				if (StartPort > EndPort)
				{
					int Temp = StartPort;
					StartPort = EndPort;
					EndPort = Temp;
				}
				//
				int OldPortCount = PortCount;
				PortCount += ((EndPort - StartPort) + 1);
				if ( (RandomCount > OldPortCount) && (RandomCount <= PortCount) )
				{
					uint16 CurrentPort = uint16(EndPort - (PortCount - RandomCount));
					if (CurrentPort != IgnorePort)
                        return CurrentPort;
					else
					{
						if (CurrentPort < EndPort)
							return (CurrentPort + 1);
						else if (CurrentPort > StartPort)
							return (CurrentPort - 1);
						else
							return 0;
					}
				}
			}
			else
			{
				// 1 Port
				uint64 CurrentPort = 0;
				StringLength = TokenString.GetLength();
				if (StringLength > 5)   return 0;
				for (int i = 0; i < StringLength; i++)
				{
					if (isdigit(TokenString.GetAt(i)) == 0)   return 0;
					CurrentPort = (CurrentPort * 10) + (TokenString.GetAt(i) - _T('0'));
				}
				if (CurrentPort != IgnorePort)   PortCount++;
				if (RandomCount == PortCount)   return CurrentPort;
			}
			TokenString = PortList.Tokenize( _T(","), TokenPos );
		}
		if (PortCount == 0)   return 0;
		do
		{
			RandomCount = 1 + (uint64(rand()) * uint64(PortCount - 1) / uint64(RAND_MAX));
		}while(RandomCount > PortCount);
	}
	return 0;
}

// ************************
// *** Ratio Append INI ***
// ************************
//
RatioAppendINI::RatioAppendINI()
{
	TargetFile = NULL;
}

RatioAppendINI::~RatioAppendINI()
{
	if (TargetFile != NULL)   fclose(TargetFile);
}

bool RatioAppendINI::OpenFile(CString Filename, CString Method)
{
	TargetFile = _tfopen(Filename, Method);
	return (TargetFile != NULL);
}

void RatioAppendINI::CloseFile()
{
	if (TargetFile != NULL)
	{
		if (fclose(TargetFile) == 0)   TargetFile = NULL;
	}
}

// Section
void RatioAppendINI::WriteSection(CString Section)
{
	CString Buffer;
	_ftprintf( TargetFile, _T("[%s]\n"), Section );
}

void RatioAppendINI::Write(CString Section)
{
	_fputts(Section, TargetFile);
}

// Single
void RatioAppendINI::Write(CString Entry, bool Value)
{
	_ftprintf( TargetFile, _T("%s=%u\n"), Entry, Value);
}

void RatioAppendINI::Write(CString Entry, int Value)
{
	_ftprintf( TargetFile, _T("%s=%i\n"), Entry, Value);
}

void RatioAppendINI::Write(CString Entry, __int64 Value)
{
	_ftprintf( TargetFile, _T("%s=%I64i\n"), Entry, Value);
}

void RatioAppendINI::Write(CString Entry, uint8 Value)
{
	_ftprintf( TargetFile, _T("%s=%u\n"), Entry, Value);
}

void RatioAppendINI::Write(CString Entry, uint16 Value)
{
	_ftprintf( TargetFile, _T("%s=%u\n"), Entry, Value);
}

void RatioAppendINI::Write(CString Entry, uint32 Value)
{
	_ftprintf( TargetFile, _T("%s=%u\n"), Entry, Value);
}

void RatioAppendINI::Write(CString Entry, uint64 Value)
{
	_ftprintf( TargetFile, _T("%s=%I64u\n"), Entry, Value);
}

void RatioAppendINI::Write(CString Entry, float Value)
{
	_ftprintf( TargetFile, _T("%s=%f\n"), Entry, Value);
}

void RatioAppendINI::Write(CString Entry, double Value)
{
	_ftprintf( TargetFile, _T("%s=%f\n"), Entry, Value);
}

void RatioAppendINI::Write(CString Entry, CString Value)
{
	_ftprintf( TargetFile, _T("%s=%s\n"), Entry, Value);
}

void RatioAppendINI::Write(CString Entry, COLORREF Value)
{
	_ftprintf( TargetFile, _T("%s=%u\n"), Entry, Value);
}

// Serial
void RatioAppendINI::WriteSerial(CString Entry, bool* Array, int Count)
{
	Entry.Append( _T("=") );
	for (int i = 0; i < Count; i++)   Entry.AppendFormat(_T("%u,"), Array[i]);
	int LastChar = Entry.GetLength() - 1;
	if ( Entry.GetAt(LastChar) == _T(',') )
	{
		Entry.SetAt( LastChar, _T('\n') );
	}
	else
		Entry.Append( _T("\n") );
	_fputts(Entry, TargetFile);
}

void RatioAppendINI::WriteSerial(CString Entry, int* Array, int Count)
{
	Entry.Append( _T("=") );
	for (int i = 0; i < Count; i++)   Entry.AppendFormat(_T("%i,"), Array[i]);
	int LastChar = Entry.GetLength() - 1;
	if ( Entry.GetAt(LastChar) == _T(',') )
	{
		Entry.SetAt( LastChar, _T('\n') );
	}
	else
		Entry.Append( _T("\n") );
	_fputts(Entry, TargetFile);
}

void RatioAppendINI::WriteSerial(CString Entry, uint8* Array, int Count)
{
	Entry.Append( _T("=") );
	for (int i = 0; i < Count; i++)   Entry.AppendFormat(_T("%u,"), Array[i]);
	int LastChar = Entry.GetLength() - 1;
	if ( Entry.GetAt(LastChar) == _T(',') )
	{
		Entry.SetAt( LastChar, _T('\n') );
	}
	else
		Entry.Append( _T("\n") );
	_fputts(Entry, TargetFile);
}

void RatioAppendINI::WriteSerial(CString Entry, uint16* Array, int Count)
{
	Entry.Append( _T("=") );
	for (int i = 0; i < Count; i++)   Entry.AppendFormat(_T("%u,"), Array[i]);
	int LastChar = Entry.GetLength() - 1;
	if ( Entry.GetAt(LastChar) == _T(',') )
	{
		Entry.SetAt( LastChar, _T('\n') );
	}
	else
		Entry.Append( _T("\n") );
	_fputts(Entry, TargetFile);
}

void RatioAppendINI::WriteSerial(CString Entry, uint32* Array, int Count)
{
	Entry.Append( _T("=") );
	for (int i = 0; i < Count; i++)   Entry.AppendFormat(_T("%u,"), Array[i]);
	int LastChar = Entry.GetLength() - 1;
	if ( Entry.GetAt(LastChar) == _T(',') )
	{
		Entry.SetAt( LastChar, _T('\n') );
	}
	else
		Entry.Append( _T("\n") );
	_fputts(Entry, TargetFile);
}

void RatioAppendINI::WriteSerial(CString Entry, COLORREF* Array, int Count)
{
	Entry.Append( _T("=") );
	for (int i = 0; i < Count; i++)   Entry.AppendFormat(_T("%u,"), Array[i]);
	int LastChar = Entry.GetLength() - 1;
	if ( Entry.GetAt(LastChar) == _T(',') )
	{
		Entry.SetAt( LastChar, _T('\n') );
	}
	else
		Entry.Append( _T("\n") );
	_fputts(Entry, TargetFile);
}

void RatioAppendINI::WriteFont(CString Entry, LPBYTE Array, int Count)
{
	Entry.Append( _T("=") );
	for (int i = 0; i < Count; i++)
	{
		// low nibble, high nibble
		Entry.AppendFormat(_T("%c%c"), TCHAR(((Array[i] & 0x0F) + 'A')), TCHAR((((Array[i] >> 4) & 0x0F) + 'A')) );
	}
	Entry.Append( _T("\n") );
	_fputts(Entry, TargetFile);
}
//-----------------------
// END -- RatioAppendINI
//***********************

//*****************
// Fake File Check
//-----------------
CFakeFile::CFakeFile()
{
//#ifdef _DEBUG
	// Is Need Update
	CString FilenameDAT, FilenameINI;
	FilenameDAT.Format( _T("%sfakes.dat"), thePrefs.GetConfigDir() );
	FilenameINI.Format( _T("%sRT_FakeFiles.INI"), thePrefs.GetConfigDir() );
	CFileStatus StatusDAT, StatusINI;
	CFile::GetStatus(FilenameDAT, StatusDAT);
	CFile::GetStatus(FilenameINI, StatusINI);
	if ( ((PathFileExists(FilenameINI) == FALSE) || (StatusDAT.m_mtime > StatusINI.m_mtime)) &&
		(PathFileExists(FilenameDAT) == TRUE) )
	{
		if (AfxMessageBox(GetResString(RT_IDS_IS_IMPORT_FAKES_DAT), MB_YESNO | MB_DEFBUTTON3) == IDYES)
			Convert();
	}
//#endif
}

CFakeFile::~CFakeFile()
{
}

void CFakeFile::Convert()
{
	// Load Data
	FILE* SourceFile;
	CString Filename;
	Filename.Format( _T("%sfakes.dat"), thePrefs.GetConfigDir() );
	SourceFile = _tfopen( Filename, _T("r") );
	if (SourceFile != NULL)
	{
		Filename.Format( _T("%sRT_FakeFiles.ini"), thePrefs.GetConfigDir() );
		RatioAppendINI FakeFile;
		if (FakeFile.OpenFile(Filename, _T("w")) == true)
		{
			CArray <CString, CString&> FileCommentList;
			CArray <uint32, uint32> CommentCountList;
			// Initial
			TCHAR Buffer[1024];
			const int BufferLen = 1024;
			int CurrentPos = 0;
			FakeFile.WriteSection( _T("General") );
			FakeFile.Write( _T("Version"), RT_FAKE_FILE_VERSION );
			FakeFile.WriteSection( _T("FakeFilesList") );
			CString Data, FileHash, FileSize, FileComment;
			// Read Data
			while (feof(SourceFile) == 0)
			{
				// Read Data
				if (_fgetts(Buffer, BufferLen, SourceFile) == 0)   break;
				Data = Buffer;
				// Process Data
				CurrentPos = 0;
				FileHash = Data.Tokenize(_T(","), CurrentPos);
				if (CurrentPos == -1)   continue;
				FileSize = Data.Tokenize(_T(","), CurrentPos);
				if (CurrentPos == -1)   continue;
				FileComment = Data.Tokenize(_T(","), CurrentPos);
				if (CurrentPos == -1)   continue;
				FileComment.Remove( TCHAR(0x0D) );
				FileComment.Remove( TCHAR(0x0A) );
				FileComment.MakeLower();
				// Write
				FakeFile.Write(FileHash.MakeUpper(), FileComment);
				// Comment List
				bool IsFound = false;
				for (int i = 0; i < FileCommentList.GetCount(); i++)
				{
					if (FileCommentList[i] == FileComment)
					{
						IsFound = true;
						CommentCountList[i] += 1;
						break;
					}
				}
				if (IsFound == false)
				{
					FileCommentList.Add(FileComment);
					CommentCountList.Add(1);
				}
			}
			// Creat Comment Language File 
			CString LanguageFile;
			LanguageFile.Format( _T("%sLang\\FakeFiles_en_US.ini"), thePrefs.GetAppDir() );
			RatioAppendINI CommentFile;
			if (CommentFile.OpenFile(LanguageFile, _T("w")) == true)
			{
				CommentFile.WriteSection( _T("Comment") );
				for (int i = 0; i < FileCommentList.GetCount(); i++)
				{
					if (CommentCountList[i] >= 5)   CommentFile.Write(FileCommentList[i], FileCommentList[i]);
				}
				CommentFile.CloseFile();
			}
			FileCommentList.RemoveAll();
			CommentCountList.RemoveAll();
		}
		fclose(SourceFile);
	}
}

bool CFakeFile::IsFakeFile(const uchar* FileHash, CString Filename)
{
	CString FilenameINI;
	FilenameINI.Format( _T("%sRT_FakeFiles.INI"), thePrefs.GetConfigDir() );
	CIni FakeIni( FilenameINI, _T("FakeFilesList") );
	CString Buffer = FakeIni.GetString( md4str(FileHash), _T(""), _T("FakeFilesList") );
	if (Buffer.IsEmpty() == false)
	{
		int CurrentPos = 0;
		CString LanguageFile;
		LanguageFile.Format( _T("%sFakeFiles_%s.ini"), thePrefs.GetLangDir(), thePrefs.GetLangDLLNameByID(thePrefs.GetLanguageID()).Tokenize(_T("."), CurrentPos) );
		if (PathFileExists(LanguageFile) == FALSE)
			LanguageFile.Format( _T("%sFakeFiles_en_US.ini"), thePrefs.GetLangDir() );
		CIni CommentFile( LanguageFile, _T("Comment") );
		CString Comment = CommentFile.GetString(Buffer, Buffer);
		Buffer.Format( _T("%s\n%s: %s\n%s: %s"), GetResString(RT_IDS_DOWNLOAD_FAKE_FILE), GetResString(IDS_DL_FILENAME), Filename, GetResString(IDS_COMMENT), Comment );
		if (AfxMessageBox(Buffer, MB_ICONQUESTION | MB_YESNO) == IDNO)   return true;
	}
	return false;
}
//-----------------------
// END -- Fake File Check
//***********************

//*****************
// Downloaded File
//-----------------
CDownloadedFile::CDownloadedFile()
{
}

CDownloadedFile::~CDownloadedFile()
{
}

void CDownloadedFile::RecordeFile(const uchar* FileHash, CString Information)
{
	CString Filename;
	Filename.Format( _T("%sRT_History.ini"), thePrefs.GetConfigDir() );
	CIni HistoryIni( Filename, _T("History") );
	HistoryIni.WriteString( md4str(FileHash), Information, _T("History") );
}

bool CDownloadedFile::IsDownloadedFile(const uchar* FileHash, CString Filename)
{
	CString FilenameINI;
	FilenameINI.Format( _T("%sRT_History.ini"), thePrefs.GetConfigDir() );
	CIni HistoryIni( FilenameINI, _T("History") );
	CString Buffer = HistoryIni.GetString( md4str(FileHash), _T(""), _T("History") );
	if (Buffer.IsEmpty() == false)
	{
		Buffer.Format( _T("%s\n%s: %s"), GetResString(RT_IDS_DOWNLOAD_FILE_AGAIN), GetResString(IDS_DL_FILENAME), Filename);
		if (AfxMessageBox(Buffer, MB_ICONQUESTION | MB_YESNO) == IDNO)
			return true;
	}
	return false;
}
//-----------------------
// END -- Downloaded File
//***********************

//*****************
// Shareaza Detect
//-----------------
CShareazaDetect::CShareazaDetect()
{
	IsRun = true;
	AfxBeginThread( DetectThread, LPVOID(this) );
}

CShareazaDetect::~CShareazaDetect()
{
	while (IsDetectThread == true);
	Sleep(1000);
	DetectLocker.Lock();
	ClientList.RemoveAll();
	DetectLocker.Unlock();
}

void CShareazaDetect::AddClient(CUpDownClient* Client)
{
	DetectLocker.Lock();
	if (ClientList.Find(Client) == NULL)   ClientList.AddTail(Client);
	DetectLocker.Unlock();
}

void CShareazaDetect::RemoveClient(CUpDownClient* Client)
{
	DetectLocker.Lock();
	POSITION ListPos = ClientList.Find(Client);
	if (ListPos != NULL)   ClientList.RemoveAt(ListPos);
	DetectLocker.Unlock();
}

void CShareazaDetect::EndDetect()
{
	IsRun = false;
	while (IsDetectThread == true);
}

UINT AFX_CDECL CShareazaDetect::DetectThread(LPVOID pvParams)
{
	DbgSetThreadName("ShareazaDetect");
	InitThreadLocale();
	CShareazaDetect* ShareazaDetect = (CShareazaDetect*)pvParams;
	return ShareazaDetect->Detect();
}

UINT CShareazaDetect::Detect()
{
	WSADATA wsaData;
	int Result = WSAStartup( MAKEWORD(2,2), &wsaData );
	if (Result != NO_ERROR)
	{
		AddDebugLogLine(false, _T(">> [RT Debug] WSAStartup Error. { %u }"), Result );
	}
	int ErrorCode = 0;
	SOCKADDR_IN SocketAddress;
	CUpDownClient* Client;
	while (IsRun == true)
	{
		if (ClientList.IsEmpty() == FALSE)
		{
			DetectLocker.Lock();
			Client = ClientList.RemoveHead();
			bool CanToDetect = ((Client->GetClientSoft() == SO_SHAREAZA) && (Client->HasLowID() == false));
			uint32 ClientIP = Client->GetIP();
			UINT ClientPort = Client->GetUserPort();
			CString ClientUsername(Client->GetUserName());
			DetectLocker.Unlock();
			if ( (CanToDetect == true) && (ClientIP != 0) && (ClientPort != 0) )
			{
				SOCKET ShareazaSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
				if (ShareazaSocket != INVALID_SOCKET)
				{
					ErrorCode = 0;
					memset( &SocketAddress, 0, sizeof(SocketAddress) );
					SocketAddress.sin_family = AF_INET;
					SocketAddress.sin_addr.s_addr = ClientIP;
					SocketAddress.sin_port = htons(ClientPort);
					if (connect(ShareazaSocket, (SOCKADDR*)&SocketAddress, sizeof(SocketAddress)) != SOCKET_ERROR)
					{
						CStringA ShareazaRequest;
						ShareazaRequest.AppendFormat( "GET http://%s:%u HTTP/1.1\r\n\r\n", ipstrA(ClientIP), ClientPort );
						char Buffer[10240];
						memset( &Buffer, 0, sizeof(Buffer) );
						send( ShareazaSocket, ShareazaRequest, ShareazaRequest.GetLength(), 0 );
						recv( ShareazaSocket, Buffer, sizeof(Buffer), 0 );
						//
						CString ReceiveData(Buffer);
						if (ReceiveData.IsEmpty() == false)
						{
							CString ReceiveDataLower = ReceiveData;
							ReceiveDataLower.MakeLower();
							int ServerPos = ReceiveDataLower.Find( _T("server:") );
							if ( (ServerPos != -1) && ((ServerPos + 7) < ReceiveData.GetLength()) )
							{
								ServerPos += 7;
								CString ShareazaVersion = ReceiveData.Tokenize( _T("\r\n"), ServerPos );
								ShareazaVersion.Trim();
								if (ShareazaVersion.IsEmpty() == false)
								{
									if (ShareazaVersion.Find(_T("Etomi")) != -1)
									{
										ShareazaVersion.Replace( _T("Etomi"), _T("Shareaza") );
										ShareazaVersion.Append( _T(" [Etomi]") );
									}
									if (ShareazaVersion.Find(_T("Shareaza")) != -1)
									{
										DetectLocker.Lock();
										if (theApp.clientlist->IsValidClient(Client) == true)
										{
											Client->SetClientSoftVer(ShareazaVersion);
//											if (thePrefs.IsLogRatioVerbose() == true)
//												AddDebugLogLine(false, _T(">> [RT Debug] Detect the current version of Shareaza. { %s, %s }"), ClientUsername, ShareazaVersion );
										}
										DetectLocker.Unlock();
									}
									else if (thePrefs.IsLogRatioVerbose() == true)
										AddDebugLogLine(false, _T(">> [RT Debug] Error when detect version of Shareaza. { Unknown Version: %s }"), ShareazaVersion );
								}
							}
						}
					}
//					else if (thePrefs.IsLogRatioVerbose() == true)
//						AddDebugLogLine(false, _T(">> [RT Debug] Error when detect version of Shareaza. { %s } { ErrorCode = %u }"), ClientUsername, WSAGetLastError() );
					//
					closesocket(ShareazaSocket);
				}
			}
		}
		Sleep(1000);
	}
	IsDetectThread = false;
	return 0;
}
//-----------------------
// END -- Shareaza Detect
//***********************