//
#pragma once

class CUpDownClient;
#include "MapKey.h"

// Adjust IP (1.2.3.4 -> 4.3.2.1)
uint32	AdjustIP(uint32 IP);

// Compare Priority (> 1 , = 0, < -1)
int		ComparePriority(uint8 Priority1, uint8 Priority2);

// Compare Username (> 1 , = 0, < -1)
int		CompareUsername(const CUpDownClient* Client1, const CUpDownClient* Client2, bool SortPlus);

// Compare UL/DL Total (> 1 , = 0, < -1)
int		CompareUDTotal(const CUpDownClient* Client1, const CUpDownClient* Client2, bool SortPlus);

// Compare Software (> 1 , = 0, < -1)
int		CompareSoftware(const CUpDownClient* Client1, const CUpDownClient* Client2, bool SortPlus, int SortMode);

// Copy Directory
void	CopyDirectory(CString Source, CString Target, bool IgnoreBak = false, bool DeleteBak = false, CString IgnoreFileList = _T(""));

// Move Directory
void	MoveDirectory(CString Source, CString Target, bool IsOverWrite = false, CString CopyOnlyFileList = _T(""));

// Clear Directory
void	ClearDirectory(CString Directory);

// RSA-CIDE by enkeyDev
void	MD4HashThis(void * input, int length, void * output);
bool	HashPKMatch(void * public_key, int key_length, void * userhash);

// Random Port
uint16	GetRandomPort(CString PortList, uint16 IgnorePort = 0);

// Ratio Append INI Class
class	RatioAppendINI
{
public:
	RatioAppendINI();
	~RatioAppendINI();
	bool	OpenFile(CString Filename, CString Method);
	void	CloseFile();
	bool	IsOpenFile() const								{ return (TargetFile != NULL);}
	// Section
	void	WriteSection(CString Section);
	void	Write(CString Section);
	// Single
	void	Write(CString Entry, bool Value);
	void	Write(CString Entry, int Value);
	void	Write(CString Entry, __int64 Value);
	void	Write(CString Entry, uint8 Value);
	void	Write(CString Entry, uint16 Value);
	void	Write(CString Entry, uint32 Value);
	void	Write(CString Entry, uint64 Value);
	void	Write(CString Entry, float Value);
	void	Write(CString Entry, double Value);
	void	Write(CString Entry, CString Value);
	void	Write(CString Entry, COLORREF Value);
	// Serial
	void	WriteSerial(CString Entry, bool* Array, int Count);
	void	WriteSerial(CString Entry, int* Array, int Count);
	void	WriteSerial(CString Entry, uint8* Array, int Count);
	void	WriteSerial(CString Entry, uint16* Array, int Count);
	void	WriteSerial(CString Entry, uint32* Array, int Count);
	void	WriteSerial(CString Entry, COLORREF* Array, int Count);
	// Font
	void	WriteFont(CString Entry, LPBYTE Array, int Count);
private:
	FILE*	TargetFile;
};

// Fake File Check
class	CFakeFile
{
public:
	CFakeFile();
	~CFakeFile();
	void			Convert();
	bool			IsFakeFile( const uchar* FileHash, CString Filename = _T("") );
};

// Downloaded File
class	CDownloadedFile
{
public:
	CDownloadedFile();
	~CDownloadedFile();
	void			RecordeFile( const uchar* FileHash, CString Information );
	bool			IsDownloadedFile( const uchar* FileHash, CString Filename = _T("") );
};

// Shareaza Detect
class	CShareazaDetect : public CWinThread
{
public:
	CShareazaDetect();
	~CShareazaDetect();
	void			AddClient(CUpDownClient* Client);
	void			RemoveClient(CUpDownClient* Client);
	void			EndDetect();
	static UINT		DetectThread(LPVOID pvParams);
	UINT			Detect();
private:
	bool			IsRun;
	bool			IsDetectThread;
    CCriticalSection DetectLocker;
	CList <CUpDownClient*, CUpDownClient*> ClientList;
};