//
#include "stdafx.h"
#include "emule.h"
#include "emuledlg.h"
#include "Preferences.h"
#include "OtherFunctions.h"
#include "PartFile.h"
#include "UploadQueue.h"
#include "FriendList.h"
#include "opcodes.h"
#include "LastCommonRouteFinder.h"
#include "SharedFilesWnd.h"
#include "SharedFilesCtrl.h"
#include "UserMsgs.h"
#include "RT_Other.h"
#include "RT_Opcodes.h"
#include "RT_PPgRatio.h"
#include "../0WapServer/PassTreeOptionsEdit.h"
#define HIDDEN_PASSWORD _T("*****")

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

///////////////////////////////////////////////////////////////////////////////
// CPPgRatio dialog

IMPLEMENT_DYNAMIC(CPPgRatio, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgRatio, CPropertyPage)
	ON_WM_DESTROY()
	ON_MESSAGE(UM_TREEOPTSCTRL_NOTIFY, OnTreeOptsCtrlNotify)
END_MESSAGE_MAP()

CPPgRatio::CPPgRatio() : CPropertyPage(RT_IDD_PPG_RATIO), m_ctrlTreeOptions(theApp.m_iDfltImageListColorFlags)
{
	// General
	m_htiRatioGeneral = NULL;
	m_htiLeecherCount = NULL;
	m_htiRunHighPriority = NULL;
	m_htiAutoBackupConfig = NULL;
	m_htiABC_Disable = NULL;
	m_htiABC_BACKUP1 = NULL;
	m_htiABC_BACKUP2 = NULL;
	m_htiRecordUploadQueueWaitedTime = NULL;
	m_htiFlushBufferTimeLimit = NULL;
	m_htiSaveCpuLoad = NULL;
	// Display
	m_htiRatioDisplay = NULL;
	m_htiRatioColor = NULL;
	m_htiHashNick = NULL;
	m_htiDisplayCountry = NULL;
	m_htiDisplayFlag = NULL;
	m_htiFontForAllWindows = NULL;
	m_htiRatioStyleServer = NULL;
	m_htiRatioStyleTransfer = NULL;
	m_htiDownloadSortSeparateStop = NULL;
	m_htiDisplayIconOfFiletype = NULL;
	// Display--Color
	for (int i = 0; i < RT_COLOR_SECTION; i++)   m_htiRatioColorNode[i] = NULL;
	for (int i = 0; i < RT_COLOR_COUNT; i++)   m_htiRatioColors[i] = NULL;
	// Connection
	m_htiRatioConnection = NULL;
	m_htiPingCustomIP = NULL;
	m_htiCustomIP = NULL;
	m_htiSaveOverhead = NULL;
	m_htiConnectTimeOut = NULL;
	m_htiRandomTCPPort = NULL;
	m_htiRTP_Enable = NULL;
	m_htiRTP_RandomPortList = NULL;
	m_htiRandomUDPPort = NULL;
	m_htiRUP_Enable = NULL;
	m_htiRUP_RandomPortList = NULL;
	// Wap Server by MoNKi
	m_htiWapServer = NULL;
	m_htiWapEnable = NULL;
	m_htiWapPort = NULL;
	m_htiWapTemplate = NULL;
	m_htiWapPass = NULL;
	m_htiWapLowEnable = NULL;
	m_htiWapLowPass = NULL;
	// Directory
	m_htiRatioDirectory = NULL;
	// Upload
	m_htiRatioUpload = NULL;
	m_htiFriendSlotAuto = NULL;
	m_htiMoreRarestPart = NULL;
	m_htiMinUploadSlot = NULL;
	m_htiMaxUploadSlot = NULL;
	m_htiKeepFriendSlot = NULL;
	m_htiMaxReleaseSlot = NULL;
	m_htiMaxCredit1Slot = NULL;
	m_htiSlotFocus = NULL;
	m_htiSharedPriority = NULL;
	// Download
	m_htiRatioDownload = NULL;
	m_htiPreCheckDiskspace = NULL;
	m_htiAutoSwapA4AF = NULL;
	m_htiMaxQR = NULL;
	m_htiDownloadPriority = NULL;
	m_htiIncludeStoppedFile = NULL;
	m_htiStartNextFile = NULL;
	m_htiByFilePriority = NULL;
	m_htiByFileName = NULL;
	m_htiByFileSize = NULL;
	m_htiByRemaining = NULL;
	// Release
	m_htiReleaseRarestOnly = NULL;
	m_htiAutoRelease = NULL;
	m_htiAutoReleaseMin = NULL;
	m_htiAutoReleaseMax = NULL;
	// Verbose
	m_htiRatioVerbose = NULL;
	m_htiLogRatioVerbose = NULL;
	m_htiLogNormalVerbose = NULL;
	m_htiLogWebCacheVerbose = NULL;
	//
	m_bInitializedTreeOpts = false;
}

CPPgRatio::~CPPgRatio()
{
}

void CPPgRatio::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, RT_IDC_SETTING_TREE, m_ctrlTreeOptions);
	if (m_bInitializedTreeOpts == false)
	{
		CImageList* piml = m_ctrlTreeOptions.GetImageList(TVSIL_NORMAL);
		int GeneralIcon = 8;
		int DisplayIcon = 8;
		int ConnectionIcon = 8;
		int DirectoryIcon = 8;
		int FileIcon = 8;
		int UploadIcon = 8;
		int DownloadIcon = 8;
		int VerboseIcon = 8;
		int MobileIcon = 8;
		if (piml)
		{
			// Ratio Setting Icon = Tweak Icon
			GeneralIcon = piml->Add( CTempIconLoader(_T("Preferences")) );
			DisplayIcon = piml->Add( CTempIconLoader(_T("DISPLAY")) );
			ConnectionIcon = piml->Add( CTempIconLoader(_T("CONNECTION")) );
			DirectoryIcon = piml->Add( CTempIconLoader(_T("FOLDERS")) );
			FileIcon = piml->Add( CTempIconLoader(_T("SharedFiles")) );
			UploadIcon = piml->Add( CTempIconLoader(_T("Upload")) );
			DownloadIcon = piml->Add( CTempIconLoader(_T("Download")) );
			VerboseIcon = piml->Add( CTempIconLoader(_T("Log")) );
			MobileIcon = piml->Add( CTempIconLoader(_T("Mobile")) );
		}
		CString Buffer;
		// General
		m_htiRatioGeneral = m_ctrlTreeOptions.InsertGroup( GetResString(IDS_PW_GENERAL), GeneralIcon, TVI_ROOT);
		m_htiRunHighPriority = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_RUN_HIGH_PRIORITY), m_htiRatioGeneral, m_iRunHighPriority);
		m_htiSaveCpuLoad = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_SAVE_CPU_LOAD), m_htiRatioGeneral, m_iSaveCpuLoad);
		m_htiRecordUploadQueueWaitedTime = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_SAVE_UPLOAD_QUEUE_WAITED_TIME), m_htiRatioGeneral, m_iRecordUploadQueueWaitedTime);
		m_htiFlushBufferTimeLimit = m_ctrlTreeOptions.InsertItem(GetResString(RT_IDS_FLUSH_BUFFER_TIME_LIMIT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiRatioGeneral);
		m_htiLeecherCount = m_ctrlTreeOptions.InsertItem(GetResString(RT_IDS_LEECHER_COUNT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiRatioGeneral);
		m_ctrlTreeOptions.AddEditBox(m_htiFlushBufferTimeLimit, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_ctrlTreeOptions.AddEditBox(m_htiLeecherCount, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiAutoBackupConfig = m_ctrlTreeOptions.InsertGroup( GetResString(RT_IDS_AUTO_BACKUP_CONFIG), GeneralIcon, m_htiRatioGeneral);
		m_htiABC_Disable = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_DISABLED), m_htiAutoBackupConfig, m_iAutoBackupConfig == RT_ABC_DISABLE);
		m_htiABC_BACKUP1 = m_ctrlTreeOptions.InsertRadioButton(GetResString(RT_IDS_ABC_BACKUP1), m_htiAutoBackupConfig, m_iAutoBackupConfig == RT_ABC_BACKUP1);
		m_htiABC_BACKUP2 = m_ctrlTreeOptions.InsertRadioButton(GetResString(RT_IDS_ABC_BACKUP2), m_htiAutoBackupConfig, m_iAutoBackupConfig == RT_ABC_BACKUP2);
		// Display
		m_htiRatioDisplay = m_ctrlTreeOptions.InsertGroup( GetResString(IDS_PW_DISPLAY), DisplayIcon, TVI_ROOT );
		m_htiHashNick = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_USE_HASH_NICK), m_htiRatioDisplay, m_iHashNick );
		m_htiDisplayCountry = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_DISPLAY_COUNTRY), m_htiRatioDisplay, m_iDisplayCountry );
		m_htiDisplayFlag = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_DISPLAY_FLAG), m_htiRatioDisplay, m_iDisplayFlag );
		m_htiDisplayIconOfFiletype = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_DISPLAY_ICON_FILETYPE), m_htiRatioDisplay, m_iDisplayIconOfFiletype );
		m_htiRatioStyleServer = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_STYLE_SERVER), m_htiRatioDisplay, m_iRatioStyleServer );
		m_htiRatioStyleTransfer = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_STYLE_TRANSFER), m_htiRatioDisplay, m_iRatioStyleTransfer );
		m_htiDownloadSortSeparateStop = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_DOWNLOAD_SORT_SEPARATE_STOP), m_htiRatioDisplay, m_iDownloadSortSeparateStop );
		m_htiFontForAllWindows = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_FONT_ALL_WINDOWS), m_htiRatioDisplay, m_iFontForAllWindows );
		m_htiRatioColor = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_STYLE_COLOR), m_htiRatioDisplay, m_iRatioStyleColor );
		// Display--Color
		int Pos = 0;
		CString ColorSection;
		ColorSection = GetResString(RT_IDS_COLOR_SECTION);
		for (int i = 0; i < RT_COLOR_SECTION; i++)
		{
			Buffer = ColorSection.Tokenize(_T(";"), Pos);
			m_htiRatioColorNode[i] =  m_ctrlTreeOptions.InsertGroup(Buffer, DisplayIcon, m_htiRatioColor);
		}
		//
		Pos = 0;
		int Section = 0;
		CString ColorState;
		ColorState = GetResString(RT_IDS_COLOR_STATE);
		for (int i = 0; i < RT_COLOR_COUNT; i++)
		{
			Buffer = ColorState.Tokenize(_T(";"), Pos);
			m_htiRatioColors[i] =  m_ctrlTreeOptions.InsertItem(Buffer, TREEOPTSCTRLIMG_NONE, TREEOPTSCTRLIMG_NONE, m_htiRatioColorNode[Section]);
			m_ctrlTreeOptions.AddColorSelector( m_htiRatioColors[i], RUNTIME_CLASS(CTreeOptionsBrowseButton) );
			m_ctrlTreeOptions.SetColor(m_htiRatioColors[i], m_uRatioColors[i]);
			// Change Section
			switch (i)
			{
				case RT_CR_DB_PROGRESS:
				case RT_CR_CB_NEXT:
				case RT_CR_UB_7TIME:
				case RT_CR_DT_STOPPED:
				case RT_CR_ST_WAITING:
				case RT_CR_CT_BAD:
					Section++;
					break;
			}
		}
		// Connection
		m_htiRatioConnection = m_ctrlTreeOptions.InsertGroup( GetResString(IDS_PW_CONNECTION), ConnectionIcon, TVI_ROOT);
		m_htiSaveOverhead = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_SAVE_OVERHEAD), m_htiRatioConnection, m_iSaveOverhead);
		m_htiConnectTimeOut = m_ctrlTreeOptions.InsertItem(GetResString(RT_IDS_CONNECT_TIME_OUT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiRatioConnection);
		m_ctrlTreeOptions.AddEditBox( m_htiConnectTimeOut, RUNTIME_CLASS(CNumTreeOptionsEdit) );
		m_htiPingCustomIP = m_ctrlTreeOptions.InsertCheckBox(GetResString(RT_IDS_PING_CUSTOM_IP), m_htiRatioConnection, m_iPingCustomIP);
		m_htiCustomIP = m_ctrlTreeOptions.InsertItem(GetResString(RT_IDS_CUSTOM_IP), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiPingCustomIP);
		m_ctrlTreeOptions.AddIPAddress( m_htiCustomIP, RUNTIME_CLASS(CTreeOptionsIPAddressCtrl) );
		m_ctrlTreeOptions.SetIPAddress(m_htiCustomIP, m_iCustomIP);
		m_htiRandomTCPPort = m_ctrlTreeOptions.InsertGroup(GetResString(RT_IDS_RANDOM_TCP_PORT), ConnectionIcon, m_htiRatioConnection);
		m_htiRTP_Enable = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_ENABLED), m_htiRandomTCPPort, m_iRandomTCPPort);
		m_htiRTP_RandomPortList = m_ctrlTreeOptions.InsertItem(GetResString(RT_IDS_PORT_LIST), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiRandomTCPPort);
		m_ctrlTreeOptions.AddEditBox( m_htiRTP_RandomPortList, RUNTIME_CLASS(CTreeOptionsEdit) );
		m_htiRandomUDPPort = m_ctrlTreeOptions.InsertGroup(GetResString(RT_IDS_RANDOM_UDP_PORT), ConnectionIcon, m_htiRatioConnection);
		m_htiRUP_Enable = m_ctrlTreeOptions.InsertCheckBox(GetResString(IDS_ENABLED), m_htiRandomUDPPort, m_iRandomUDPPort);
		m_htiRUP_RandomPortList = m_ctrlTreeOptions.InsertItem(GetResString(RT_IDS_PORT_LIST), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiRandomUDPPort);
		m_ctrlTreeOptions.AddEditBox( m_htiRUP_RandomPortList, RUNTIME_CLASS(CTreeOptionsEdit) );
		// Connection--Wap Server by MoNKi
		m_htiWapServer = m_ctrlTreeOptions.InsertGroup( _T("Wap Interface"), MobileIcon, m_htiRatioConnection );
		m_htiWapEnable  = m_ctrlTreeOptions.InsertCheckBox( _T("Enable Wap Interface"), m_htiWapServer, m_bWapEnable );
		m_htiWapTemplate = m_ctrlTreeOptions.InsertItem( _T("Template"), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiWapServer );
		m_ctrlTreeOptions.AddFileEditBox( m_htiWapTemplate,RUNTIME_CLASS(CTreeOptionsEdit), RUNTIME_CLASS(CTreeOptionsBrowseButton) );
		m_htiWapPort = m_ctrlTreeOptions.InsertItem( _T("Port"), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiWapServer );
		m_ctrlTreeOptions.AddEditBox( m_htiWapPort, RUNTIME_CLASS(CNumTreeOptionsEdit) );
		m_htiWapPass = m_ctrlTreeOptions.InsertItem(_T("Pass"), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiWapServer );
		m_ctrlTreeOptions.AddPassEditBox( m_htiWapPass, RUNTIME_CLASS(CPassTreeOptionsEdit) );
		m_htiWapLowEnable = m_ctrlTreeOptions.InsertCheckBox( _T("Low Enable"), m_htiWapServer, m_bWapLowEnable );
		m_htiWapLowPass = m_ctrlTreeOptions.InsertItem( _T("Low Pass"), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiWapServer );
		m_ctrlTreeOptions.AddPassEditBox( m_htiWapLowPass, RUNTIME_CLASS(CPassTreeOptionsEdit) );
		// Directory
//		m_htiRatioDirectory = m_ctrlTreeOptions.InsertGroup( GetResString(IDS_PW_DIR), DirectoryIcon, TVI_ROOT);
		// Release
		m_htiRatioRelease = m_ctrlTreeOptions.InsertGroup( GetResString(RT_IDS_RELEASE_FILE), FileIcon, TVI_ROOT);
		m_htiReleaseRarestOnly = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_RELEASE_RAREST_ONLY), m_htiRatioRelease, m_iReleaseRarestOnly);
		m_htiMoreRarestPart = m_ctrlTreeOptions.InsertItem(GetResString(RT_IDS_MORE_RAREST_PART), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiRatioRelease);
		m_ctrlTreeOptions.AddEditBox(m_htiMoreRarestPart, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiAutoRelease = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_AUTO_RELEASE), m_htiRatioRelease, m_iAutoRelease);
		m_htiAutoReleaseMin = m_ctrlTreeOptions.InsertItem(GetResString(RT_IDS_AUTO_RELEASE_MIN), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoRelease);
		m_ctrlTreeOptions.AddEditBox(m_htiAutoReleaseMin, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiAutoReleaseMax = m_ctrlTreeOptions.InsertItem(GetResString(RT_IDS_AUTO_RELEASE_MAX), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiAutoRelease);
		m_ctrlTreeOptions.AddEditBox(m_htiAutoReleaseMax, RUNTIME_CLASS(CNumTreeOptionsEdit));
		// Upload
		m_htiRatioUpload = m_ctrlTreeOptions.InsertGroup( GetResString(IDS_PW_CON_UPLBL), UploadIcon, TVI_ROOT);
		m_htiFriendSlotAuto = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_FRIEND_SLOT_AUTO), m_htiRatioUpload, m_iFriendSlotAuto);
		m_htiKeepFriendSlot = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_KEEP_FRIEND_SLOT), m_htiRatioUpload, m_iKeepFriendSlot);
		m_htiSlotFocus = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_SLOT_FOCUS), m_htiRatioUpload, m_iSlotFocus);
		m_htiMaxReleaseSlot = m_ctrlTreeOptions.InsertItem(GetResString(RT_IDS_MAX_RELEASE_SLOT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiRatioUpload);
		m_ctrlTreeOptions.AddEditBox(m_htiMaxReleaseSlot, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiMaxCredit1Slot = m_ctrlTreeOptions.InsertItem(GetResString(RT_IDS_MAX_CREDIT1_SLOT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiRatioUpload);
		m_ctrlTreeOptions.AddEditBox(m_htiMaxCredit1Slot, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiMinUploadSlot = m_ctrlTreeOptions.InsertItem(GetResString(RT_IDS_MIN_UPLOAD_SLOT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiRatioUpload);
		m_ctrlTreeOptions.AddEditBox(m_htiMinUploadSlot, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiMaxUploadSlot = m_ctrlTreeOptions.InsertItem(GetResString(RT_IDS_MAX_UPLOAD_SLOT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiRatioUpload);
		m_ctrlTreeOptions.AddEditBox(m_htiMaxUploadSlot, RUNTIME_CLASS(CNumTreeOptionsEdit));
		// Upload--Shared Priority Limit
		m_htiSharedPriority = m_ctrlTreeOptions.InsertGroup( GetResString(RT_IDS_SHARED_PRIORITY), FileIcon, m_htiRatioUpload);
		Buffer.Format( GetResString(RT_IDS_SHARED_PRIORITY_LIMIT), GetResString(IDS_PRIOVERYLOW) );
		m_htiULPrioLimit[RT_PR_VERYLOW] = m_ctrlTreeOptions.InsertItem( Buffer, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSharedPriority);
		m_ctrlTreeOptions.AddEditBox( m_htiULPrioLimit[RT_PR_VERYLOW], RUNTIME_CLASS(CNumTreeOptionsEdit) );
		Buffer.Format( GetResString(RT_IDS_SHARED_PRIORITY_LIMIT), GetResString(IDS_PRIOLOW) );
		m_htiULPrioLimit[RT_PR_LOW] = m_ctrlTreeOptions.InsertItem( Buffer, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSharedPriority);
		m_ctrlTreeOptions.AddEditBox( m_htiULPrioLimit[RT_PR_LOW], RUNTIME_CLASS(CNumTreeOptionsEdit) );
		Buffer.Format( GetResString(RT_IDS_SHARED_PRIORITY_LIMIT), GetResString(IDS_PRIONORMAL) );
		m_htiULPrioLimit[RT_PR_NORMAL] = m_ctrlTreeOptions.InsertItem( Buffer, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSharedPriority);
		m_ctrlTreeOptions.AddEditBox( m_htiULPrioLimit[RT_PR_NORMAL], RUNTIME_CLASS(CNumTreeOptionsEdit) );
		Buffer.Format( GetResString(RT_IDS_SHARED_PRIORITY_LIMIT), GetResString(IDS_PRIOHIGH) );
		m_htiULPrioLimit[RT_PR_HIGH] = m_ctrlTreeOptions.InsertItem( Buffer, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiSharedPriority);
		m_ctrlTreeOptions.AddEditBox( m_htiULPrioLimit[RT_PR_HIGH], RUNTIME_CLASS(CNumTreeOptionsEdit) );
		// Download
		m_htiRatioDownload = m_ctrlTreeOptions.InsertGroup( GetResString(IDS_PW_CON_DOWNLBL), DownloadIcon, TVI_ROOT);
		m_htiPreCheckDiskspace = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_CHECK_DISKSPACE), m_htiRatioDownload, m_iPreCheckDiskspace);
		m_htiAutoSwapA4AF = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_AUTO_SWAP_A4AF), m_htiRatioDownload, m_iAutoSwapA4AF);
		m_htiIncludeStoppedFile = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_INCLUDE_STOPPED_FILE), m_htiRatioDownload, m_iIncludeStoppedFile);
		m_htiMaxQR = m_ctrlTreeOptions.InsertItem(GetResString(RT_IDS_QR_LIMIT), TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiRatioDownload);
		m_ctrlTreeOptions.AddEditBox(m_htiMaxQR, RUNTIME_CLASS(CNumTreeOptionsEdit));
		m_htiStartNextFile = m_ctrlTreeOptions.InsertGroup(GetResString(IDS_STARTNEXTFILE), FileIcon, m_htiRatioDownload);
		m_htiByFilePriority = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_FILEPRIO), m_htiStartNextFile, m_iStartNextFile == RT_BY_PRIORITY);
		m_htiByFileName = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_DL_FILENAME), m_htiStartNextFile, m_iStartNextFile == RT_BY_FILENAME);
		m_htiByFileSize = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_DL_SIZE), m_htiStartNextFile, m_iStartNextFile == RT_BY_FILESIZE);
		m_htiByRemaining = m_ctrlTreeOptions.InsertRadioButton(GetResString(IDS_DL_REMAINS), m_htiStartNextFile, m_iStartNextFile == RT_BY_REMAINING);
		// Download--Download Priority Limit
		m_htiDownloadPriority = m_ctrlTreeOptions.InsertGroup( GetResString(RT_IDS_DOWNLOAD_PRIORITY), FileIcon, m_htiRatioDownload);
		Buffer.Format( GetResString(RT_IDS_DOWNLOAD_PRIORITY_LIMIT), GetResString(IDS_PRIOVERYLOW) );
		m_htiDLPrioLimit[RT_PR_VERYLOW] = m_ctrlTreeOptions.InsertItem( Buffer, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDownloadPriority);
		m_ctrlTreeOptions.AddEditBox( m_htiDLPrioLimit[RT_PR_VERYLOW], RUNTIME_CLASS(CNumTreeOptionsEdit) );
		Buffer.Format( GetResString(RT_IDS_DOWNLOAD_PRIORITY_LIMIT), GetResString(IDS_PRIOLOW) );
		m_htiDLPrioLimit[RT_PR_LOW] = m_ctrlTreeOptions.InsertItem( Buffer, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDownloadPriority);
		m_ctrlTreeOptions.AddEditBox( m_htiDLPrioLimit[RT_PR_LOW], RUNTIME_CLASS(CNumTreeOptionsEdit) );
		Buffer.Format( GetResString(RT_IDS_DOWNLOAD_PRIORITY_LIMIT), GetResString(IDS_PRIONORMAL) );
		m_htiDLPrioLimit[RT_PR_NORMAL] = m_ctrlTreeOptions.InsertItem( Buffer, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDownloadPriority);
		m_ctrlTreeOptions.AddEditBox( m_htiDLPrioLimit[RT_PR_NORMAL], RUNTIME_CLASS(CNumTreeOptionsEdit) );
		Buffer.Format( GetResString(RT_IDS_DOWNLOAD_PRIORITY_LIMIT), GetResString(IDS_PRIOHIGH) );
		m_htiDLPrioLimit[RT_PR_HIGH] = m_ctrlTreeOptions.InsertItem( Buffer, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, m_htiDownloadPriority);
		m_ctrlTreeOptions.AddEditBox( m_htiDLPrioLimit[RT_PR_HIGH], RUNTIME_CLASS(CNumTreeOptionsEdit) );
		// Verbose
		m_htiRatioVerbose = m_ctrlTreeOptions.InsertGroup( GetResString(RT_IDS_VERBOSE), VerboseIcon, TVI_ROOT);
		m_htiLogRatioVerbose = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_LOG_RATIO_VERBOSE), m_htiRatioVerbose, m_iLogRatioVerbose);
		m_htiLogNormalVerbose = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_LOG_NORMAL_VERBOSE), m_htiRatioVerbose, m_iLogNormalVerbose);
		m_htiLogWebCacheVerbose = m_ctrlTreeOptions.InsertCheckBox( GetResString(RT_IDS_WC_LOG_WEBCACHE_VERBOSE), m_htiRatioVerbose, m_iLogWebCacheVerbose);
		// Expand
		m_ctrlTreeOptions.Expand(m_htiRatioColor, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiPingCustomIP, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiRandomTCPPort, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiRandomUDPPort, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiAutoRelease, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiSharedPriority, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiDownloadPriority, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiStartNextFile, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiAutoBackupConfig, TVE_EXPAND);
		m_ctrlTreeOptions.Expand(m_htiWapServer, TVE_EXPAND);
		//

        m_bInitializedTreeOpts = true;
	}

	// Ratio Setting
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiRatioColor, m_iRatioStyleColor);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiFriendSlotAuto, m_iFriendSlotAuto);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiPreCheckDiskspace, m_iPreCheckDiskspace);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiAutoSwapA4AF, m_iAutoSwapA4AF);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiReleaseRarestOnly, m_iReleaseRarestOnly);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiAutoRelease, m_iAutoRelease);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiHashNick, m_iHashNick);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiDisplayCountry, m_iDisplayCountry);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiDisplayFlag, m_iDisplayFlag);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiSlotFocus, m_iSlotFocus);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiKeepFriendSlot, m_iKeepFriendSlot);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiRunHighPriority, m_iRunHighPriority);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiFontForAllWindows, m_iFontForAllWindows);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiIncludeStoppedFile, m_iIncludeStoppedFile);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiLogRatioVerbose, m_iLogRatioVerbose);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiLogNormalVerbose, m_iLogNormalVerbose);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiLogWebCacheVerbose, m_iLogWebCacheVerbose);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiPingCustomIP, m_iPingCustomIP);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiRatioStyleServer, m_iRatioStyleServer);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiRatioStyleTransfer, m_iRatioStyleTransfer);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiRecordUploadQueueWaitedTime, m_iRecordUploadQueueWaitedTime);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiDownloadSortSeparateStop, m_iDownloadSortSeparateStop);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiSaveCpuLoad, m_iSaveCpuLoad);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiSaveOverhead, m_iSaveOverhead);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiDisplayIconOfFiletype, m_iDisplayIconOfFiletype);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiRTP_Enable, m_iRandomTCPPort);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiRUP_Enable, m_iRandomUDPPort);
	DDX_TreeRadio(pDX, RT_IDC_SETTING_TREE, m_htiStartNextFile, m_iStartNextFile);
	DDX_TreeRadio(pDX, RT_IDC_SETTING_TREE, m_htiAutoBackupConfig, m_iAutoBackupConfig);
	DDX_TreeIPAddress(pDX, RT_IDC_SETTING_TREE, m_htiCustomIP, m_iCustomIP);
	DDX_Text(pDX, RT_IDC_SETTING_TREE, m_htiLeecherCount, m_iLeecherCount);
	DDX_Text(pDX, RT_IDC_SETTING_TREE, m_htiMoreRarestPart, m_iMoreRarestPart);
	DDX_Text(pDX, RT_IDC_SETTING_TREE, m_htiMaxQR, m_iMaxQR);
	DDX_Text(pDX, RT_IDC_SETTING_TREE, m_htiAutoReleaseMin, m_iAutoReleaseMin);
	DDX_Text(pDX, RT_IDC_SETTING_TREE, m_htiAutoReleaseMax, m_iAutoReleaseMax);
	DDX_Text(pDX, RT_IDC_SETTING_TREE, m_htiMinUploadSlot, m_iMinUploadSlot);
	DDX_Text(pDX, RT_IDC_SETTING_TREE, m_htiMaxUploadSlot, m_iMaxUploadSlot);
	DDX_Text(pDX, RT_IDC_SETTING_TREE, m_htiMaxReleaseSlot, m_iMaxReleaseSlot);
	DDX_Text(pDX, RT_IDC_SETTING_TREE, m_htiMaxCredit1Slot, m_iMaxCredit1Slot);
	DDX_Text(pDX, RT_IDC_SETTING_TREE, m_htiFlushBufferTimeLimit, m_iFlushBufferTimeLimit);
	DDX_Text(pDX, RT_IDC_SETTING_TREE, m_htiConnectTimeOut, m_iConnectTimeOut);
	DDX_Text(pDX, RT_IDC_SETTING_TREE, m_htiRTP_RandomPortList, m_sRandomTCPPortList);
	DDX_Text(pDX, RT_IDC_SETTING_TREE, m_htiRUP_RandomPortList, m_sRandomUDPPortList);
	DDV_MinMaxInt( pDX, m_iAutoReleaseMin, 1, 100 );
	DDV_MinMaxInt( pDX, m_iAutoReleaseMax, 5, 100 );
	DDV_MinMaxInt( pDX, m_iLeecherCount, 3, 31 );
	DDV_MinMaxInt( pDX, m_iMoreRarestPart, 0, 15 );
	DDV_MinMaxInt( pDX, m_iMaxQR, 100, 10000);
	uint8 MinUploadSlotLimit = uint8(thePrefs.GetMaxGraphUploadRate() / 3);
	if (MinUploadSlotLimit < 3)
		MinUploadSlotLimit = 3;
	else if (MinUploadSlotLimit > MAX_UP_CLIENTS_ALLOWED)
		MinUploadSlotLimit = MAX_UP_CLIENTS_ALLOWED;
	DDV_MinMaxInt( pDX, m_iMinUploadSlot, 2, MinUploadSlotLimit );
	DDV_MinMaxInt( pDX, m_iMaxUploadSlot, 2, MAX_UP_CLIENTS_ALLOWED );
	DDV_MinMaxInt( pDX, m_iMaxReleaseSlot, 0, thePrefs.GetMaxUploadSlot() );
	DDV_MinMaxInt( pDX, m_iMaxCredit1Slot, 0, thePrefs.GetMaxUploadSlot() );
	DDV_MinMaxInt( pDX, m_iFlushBufferTimeLimit, MIN2S(1), MIN2S(15) );
	DDV_MinMaxInt( pDX, m_iConnectTimeOut, 2, 60 );
	// Wap Server by MoNKi
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiWapEnable, m_bWapEnable);
	DDX_TreeCheck(pDX, RT_IDC_SETTING_TREE, m_htiWapLowEnable, m_bWapLowEnable);
	DDX_TreeEdit(pDX, RT_IDC_SETTING_TREE, m_htiWapPort, m_iWapPort);
	DDX_TreeEdit(pDX, RT_IDC_SETTING_TREE, m_htiWapTemplate, m_sWapTemplate);
	DDX_TreeEdit(pDX, RT_IDC_SETTING_TREE, m_htiWapPass, m_sWapPass);
	DDX_TreeEdit(pDX, RT_IDC_SETTING_TREE, m_htiWapLowPass, m_sWapLowPass);
	DDV_MinMaxInt(pDX, m_iWapPort, 0, 0xFFFF);
	// Download Priority Limit
	for (int i = 0; i < RT_PR_VERYHIGH; i++)
	{
		DDX_Text( pDX, RT_IDC_SETTING_TREE, m_htiDLPrioLimit[i], m_iDLPrioLimit[i] );
		DDV_MinMaxInt(pDX, m_iDLPrioLimit[i], 1, INT_MAX);
		// Shared Priority Limit
		DDX_Text( pDX, RT_IDC_SETTING_TREE, m_htiULPrioLimit[i], m_iULPrioLimit[i] );
		DDV_MinMaxInt(pDX, m_iULPrioLimit[i], 1, INT_MAX);
	}
	// Display--Color
	for (int i = 0; i < RT_COLOR_COUNT; i++)
	{
		DDX_TreeColor( pDX, RT_IDC_SETTING_TREE, m_htiRatioColors[i], m_uRatioColors[i] );
	}
}

BOOL CPPgRatio::OnInitDialog()
{
	// General
	m_iRatioStyleColor = thePrefs.IsRatioColor();
	m_iLeecherCount = thePrefs.GetLeecherCount();
	m_iMoreRarestPart = thePrefs.GetMoreRarestPart();
	m_iPreCheckDiskspace = thePrefs.IsPreCheckDiskspace();
	m_iAutoSwapA4AF = thePrefs.IsAutoSwapA4AF();
	m_iMaxQR = thePrefs.GetMaxQR();
	m_iReleaseRarestOnly = thePrefs.IsReleaseRarestOnly();
	m_iAutoRelease = thePrefs.IsAutoRelease();
	m_iAutoReleaseMin = thePrefs.GetAutoReleaseMin();
	m_iAutoReleaseMax = thePrefs.GetAutoReleaseMax();
	m_iMinUploadSlot = thePrefs.GetMinUploadSlot();
	m_iMaxUploadSlot = thePrefs.GetMaxUploadSlot();
	m_iHashNick = thePrefs.IsHashNick();
	m_iDisplayCountry = thePrefs.IsDisplayCountry();
	m_iDisplayFlag = thePrefs.IsDisplayFlag();
	m_iKeepFriendSlot = thePrefs.IsKeepFriendSlot();
	m_iSlotFocus = thePrefs.IsSlotFocus();
	m_iFriendSlotAuto = thePrefs.IsFriendSlotAuto();
	m_iMaxReleaseSlot = thePrefs.GetMaxReleaseSlot();
	m_iMaxCredit1Slot = thePrefs.GetMaxCredit1Slot();
	m_iRunHighPriority = thePrefs.IsRunHighPriority();
	m_iFontForAllWindows = thePrefs.IsFontForAllWindows();
	m_iAutoBackupConfig = thePrefs.GetAutoBackupConfig();
	m_iIncludeStoppedFile = thePrefs.IsIncludeStoppedFile();
	m_iLogRatioVerbose = thePrefs.IsLogRatioVerbose();
	m_iLogNormalVerbose = thePrefs.IsLogNormalVerbose();
	m_iLogWebCacheVerbose = thePrefs.IsLogWebCacheVerbose();
	m_iStartNextFile = thePrefs.GetStartNextFileBy();
	m_iRatioStyleServer = thePrefs.IsRatioStyleServer();
	m_iRatioStyleTransfer = thePrefs.IsRatioStyleTransfer();
	m_iRecordUploadQueueWaitedTime = thePrefs.IsRecordUploadQueueWaitedTime();
	m_iDownloadSortSeparateStop = thePrefs.IsDownloadSortSeparateStop();
	m_iFlushBufferTimeLimit = thePrefs.GetFlushBufferTimeLimit() / 1000;
	m_iSaveCpuLoad = thePrefs.IsSaveCpuLoad();
	m_iSaveOverhead = thePrefs.IsSaveOverhead();
	m_iConnectTimeOut = thePrefs.GetConnectTimeOut() / 1000;
	m_iDisplayIconOfFiletype = thePrefs.IsDisplayIconOfFiletype();
	m_iRandomTCPPort = thePrefs.IsRandomTCPPort();
	m_sRandomTCPPortList = thePrefs.GetRandomTCPPortList();
	m_iRandomUDPPort = thePrefs.IsRandomUDPPort();
	m_sRandomUDPPortList = thePrefs.GetRandomUDPPortList();
	// Download Priority Limit
	m_iDLPrioLimit[RT_PR_VERYLOW] = thePrefs.GetDLPrioLimit(RT_PR_VERYLOW);
	m_iDLPrioLimit[RT_PR_LOW] = thePrefs.GetDLPrioLimit(RT_PR_LOW);
	m_iDLPrioLimit[RT_PR_NORMAL] = thePrefs.GetDLPrioLimit(RT_PR_NORMAL);
	m_iDLPrioLimit[RT_PR_HIGH] = thePrefs.GetDLPrioLimit(RT_PR_HIGH);
	// Shared Priority Limit
	m_iULPrioLimit[RT_PR_VERYLOW] = thePrefs.GetULPrioLimit(RT_PR_VERYLOW);
	m_iULPrioLimit[RT_PR_LOW] = thePrefs.GetULPrioLimit(RT_PR_LOW);
	m_iULPrioLimit[RT_PR_NORMAL] = thePrefs.GetULPrioLimit(RT_PR_NORMAL);
	m_iULPrioLimit[RT_PR_HIGH] = thePrefs.GetULPrioLimit(RT_PR_HIGH);
	// Wap Server by MoNKi
	m_bWapEnable = thePrefs.GetWapServerEnabled();
	m_iWapPort = thePrefs.GetWapPort();
	m_sWapTemplate = thePrefs.GetWapTemplate();
	m_sWapPass = HIDDEN_PASSWORD;
	m_bWapLowEnable = thePrefs.GetWapIsLowUserEnabled();
	m_sWapLowPass = HIDDEN_PASSWORD;
	// Custom IP
	m_iPingCustomIP = thePrefs.IsPingCustomIP();
	m_iCustomIP = AdjustIP( thePrefs.GetCustomIP() );
	// Display--Color
	for (int i = 0; i < RT_COLOR_COUNT; i++)
	{
		m_uRatioColors[i] = thePrefs.GetRatioColor(i);
	}

    CPropertyPage::OnInitDialog();
	InitWindowStyles(this);

	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPgRatio::OnKillActive()
{
	// if prop page is closed by pressing VK_ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();
	return CPropertyPage::OnKillActive();
}

BOOL CPPgRatio::OnApply()
{
	// if prop page is closed by pressing VK_ENTER we have to explicitly commit any possibly pending
	// data from an open edit control
	m_ctrlTreeOptions.HandleChildControlLosingFocus();

	if (UpdateData() == FALSE)   return FALSE;

	bool IsNeedRestart = false;
	// General
	// Keep Friend Slot
	if ( (thePrefs.IsKeepFriendSlot() == false) && (m_iKeepFriendSlot > 0) )   theApp.friendlist->SetFriendSlot();
	//
	thePrefs.SetPreCheckDiskspace(m_iPreCheckDiskspace);
	thePrefs.SetAutoSwapA4AF(m_iAutoSwapA4AF);
	thePrefs.SetLeecherCount( uint8(m_iLeecherCount) );
	thePrefs.SetMoreRarestPart( uint8(m_iMoreRarestPart) );
	thePrefs.SetMaxQR( uint16(m_iMaxQR) );
	thePrefs.SetRatioColor(m_iRatioStyleColor);
	thePrefs.SetReleaseRarestOnly(m_iReleaseRarestOnly);
	thePrefs.SetAutoRelease(m_iAutoRelease);
	thePrefs.SetAutoReleaseMin( uint16(m_iAutoReleaseMin) );
	thePrefs.SetAutoReleaseMax( uint16(m_iAutoReleaseMax) );
	thePrefs.SetMinUploadSlot( uint8(m_iMinUploadSlot) );
	if (m_iMaxUploadSlot < m_iMinUploadSlot)   m_iMaxUploadSlot = m_iMinUploadSlot;
	thePrefs.SetMaxUploadSlot( uint8(m_iMaxUploadSlot) );
	thePrefs.SetHashNick(m_iHashNick);
	thePrefs.SetDisplayCountry(m_iDisplayCountry);
	thePrefs.SetDisplayFlag(m_iDisplayFlag);
	thePrefs.SetKeepFriendSlot(m_iKeepFriendSlot);
	thePrefs.SetSlotFocus(m_iSlotFocus);
	if (m_iMaxReleaseSlot > m_iMaxUploadSlot)   m_iMaxReleaseSlot = m_iMaxUploadSlot;
	thePrefs.SetMaxReleaseSlot( uint8(m_iMaxReleaseSlot) );
	if (m_iMaxCredit1Slot > m_iMaxUploadSlot)   m_iMaxCredit1Slot = m_iMaxUploadSlot;
	thePrefs.SetMaxCredit1Slot( uint8(m_iMaxCredit1Slot) );
	thePrefs.SetRunHighPriority(m_iRunHighPriority);
	thePrefs.SetFontForAllWindows(m_iFontForAllWindows);
	thePrefs.SetAutoBackupConfig(m_iAutoBackupConfig);
	thePrefs.SetFriendSlotAuto(m_iFriendSlotAuto);
	thePrefs.SetStartNextFileBy(m_iStartNextFile);
	thePrefs.SetRecordUploadQueueWaitedTime(m_iRecordUploadQueueWaitedTime);
	thePrefs.SetDownloadSortSeparateStop(m_iDownloadSortSeparateStop);
	thePrefs.SetFlushBufferTimeLimit( (uint32(m_iFlushBufferTimeLimit) * 1000) );
	thePrefs.SetSaveCpuLoad(m_iSaveCpuLoad);
	thePrefs.SetSaveOverhead(m_iSaveOverhead);
	thePrefs.SetConnectTimeOut( (uint32(m_iConnectTimeOut) * 1000) );
	thePrefs.SetDisplayIconOfFiletype(m_iDisplayIconOfFiletype);
	thePrefs.SetRandomTCPPortList(m_sRandomTCPPortList);
	thePrefs.SetRandomUDPPortList(m_sRandomUDPPortList);
	if ( thePrefs.IsRandomTCPPort() != bool(m_iRandomTCPPort) )
	{
		IsNeedRestart = true;
		thePrefs.SetRandomTCPPort(m_iRandomTCPPort);
	}
	if ( thePrefs.IsRandomUDPPort() != bool(m_iRandomUDPPort) )
	{
		IsNeedRestart = true;
		thePrefs.SetRandomUDPPort(m_iRandomUDPPort);
	}
	if ( thePrefs.IsRatioStyleServer() != bool(m_iRatioStyleServer) )
	{
		IsNeedRestart = true;
		thePrefs.SetRatioStyleServer(m_iRatioStyleServer);
	}
	if ( thePrefs.IsRatioStyleTransfer() != bool(m_iRatioStyleTransfer) )
	{
		IsNeedRestart = true;
		thePrefs.SetRatioStyleTransfer(m_iRatioStyleTransfer);
	}
	//
	thePrefs.SetDLPrioLimit( RT_PR_VERYLOW, m_iDLPrioLimit[RT_PR_VERYLOW] );
	thePrefs.SetDLPrioLimit( RT_PR_LOW, m_iDLPrioLimit[RT_PR_LOW] );
	thePrefs.SetDLPrioLimit( RT_PR_NORMAL, m_iDLPrioLimit[RT_PR_NORMAL] );
	thePrefs.SetDLPrioLimit( RT_PR_HIGH, m_iDLPrioLimit[RT_PR_HIGH] );
	//
	thePrefs.SetULPrioLimit( RT_PR_VERYLOW, m_iULPrioLimit[RT_PR_VERYLOW] );
	thePrefs.SetULPrioLimit( RT_PR_LOW, m_iULPrioLimit[RT_PR_LOW] );
	thePrefs.SetULPrioLimit( RT_PR_NORMAL, m_iULPrioLimit[RT_PR_NORMAL] );
	thePrefs.SetULPrioLimit( RT_PR_HIGH, m_iULPrioLimit[RT_PR_HIGH] );
	//
	thePrefs.SetIncludeStoppedFile(m_iIncludeStoppedFile);
	thePrefs.SetLogRatioVerbose(m_iLogRatioVerbose);
	thePrefs.SetLogNormalVerbose(m_iLogNormalVerbose);
	thePrefs.SetLogWebCacheVerbose(m_iLogWebCacheVerbose);
	// Wap Server by MoNKi
	thePrefs.SetWapServerEnabled(m_bWapEnable);
	thePrefs.SetWapIsLowUserEnabled(m_bWapLowEnable);
	if ( m_sWapPass != CString(HIDDEN_PASSWORD) )   thePrefs.SetWapPass(m_sWapPass);
	if ( m_sWapLowPass != CString(HIDDEN_PASSWORD) )   thePrefs.SetWapLowPass(m_sWapLowPass);
// RT, MINI Version
#ifndef MINI
	if ( m_sWapTemplate != thePrefs.GetWapTemplate() )
	{
		thePrefs.SetWapTemplate(m_sWapTemplate);
		theApp.WapServer->ReloadTemplates();
	}
	if ( m_iWapPort != thePrefs.GetWapPort() )
	{
		thePrefs.SetWapPort(m_iWapPort);
		theApp.WapServer->RestartServer();
	}
	theApp.WapServer->StartServer();
#else
	if ( m_sWapTemplate != thePrefs.GetWapTemplate() )   thePrefs.SetWapTemplate(m_sWapTemplate);
	if ( m_iWapPort != thePrefs.GetWapPort() )   thePrefs.SetWapPort(m_iWapPort);
#endif
/*Original
	if ( m_sWapTemplate != thePrefs.GetWapTemplate() )
	{
		thePrefs.SetWapTemplate(m_sWapTemplate);
		theApp.WapServer->ReloadTemplates();
	}
	if ( m_iWapPort != thePrefs.GetWapPort() )
	{
		thePrefs.SetWapPort(m_iWapPort);
		theApp.WapServer->RestartServer();
	}
	theApp.WapServer->StartServer();
*/
	// Custom IP
	thePrefs.SetPingCustomIP(m_iPingCustomIP);
	m_iCustomIP = m_ctrlTreeOptions.GetIPAddress(m_htiCustomIP);
	thePrefs.SetCustomIP( AdjustIP(m_iCustomIP) );
	// Display--Color
	for (int i = 0; i < RT_COLOR_COUNT; i++)
	{
		thePrefs.SetRatioColor( i, m_uRatioColors[i] );
	}

	SetModified(FALSE);

	if (IsNeedRestart == true)   AfxMessageBox( GetResString(IDS_SETTINGCHANGED_RESTART) );
	return CPropertyPage::OnApply();
}

void CPPgRatio::Localize(void)
{	
	if(m_hWnd)
	{
		SetWindowText(GetResString(RT_IDS_RATIO_SETTING));
		CString Buffer;
		// General
		if (m_htiRatioGeneral)   m_ctrlTreeOptions.SetItemText( m_htiRatioGeneral, GetResString(IDS_PW_GENERAL) );
		if (m_htiLeecherCount)   m_ctrlTreeOptions.SetEditLabel( m_htiLeecherCount, GetResString(RT_IDS_LEECHER_COUNT) );
		if (m_htiRunHighPriority)   m_ctrlTreeOptions.SetItemText( m_htiRunHighPriority, GetResString(RT_IDS_RUN_HIGH_PRIORITY) );
		if (m_htiAutoBackupConfig)   m_ctrlTreeOptions.SetItemText( m_htiAutoBackupConfig, GetResString(RT_IDS_AUTO_BACKUP_CONFIG) );
		if (m_htiABC_Disable)   m_ctrlTreeOptions.SetItemText( m_htiABC_Disable, GetResString(IDS_DISABLED) );
		if (m_htiABC_BACKUP1)   m_ctrlTreeOptions.SetItemText( m_htiABC_BACKUP1, GetResString(RT_IDS_ABC_BACKUP1) );
		if (m_htiABC_BACKUP2)   m_ctrlTreeOptions.SetItemText( m_htiABC_BACKUP2, GetResString(RT_IDS_ABC_BACKUP2) );
		if (m_htiRecordUploadQueueWaitedTime)   m_ctrlTreeOptions.SetItemText( m_htiRecordUploadQueueWaitedTime, GetResString(RT_IDS_SAVE_UPLOAD_QUEUE_WAITED_TIME) );
		if (m_htiFlushBufferTimeLimit)   m_ctrlTreeOptions.SetEditLabel( m_htiFlushBufferTimeLimit, GetResString(RT_IDS_FLUSH_BUFFER_TIME_LIMIT) );
		if (m_htiSaveCpuLoad)   m_ctrlTreeOptions.SetItemText( m_htiSaveCpuLoad, GetResString(RT_IDS_SAVE_CPU_LOAD) );
		// Display
		if (m_htiRatioDisplay)   m_ctrlTreeOptions.SetItemText( m_htiRatioDisplay, GetResString(IDS_PW_DISPLAY) );
		if (m_htiRatioColor)   m_ctrlTreeOptions.SetItemText( m_htiRatioColor, GetResString(RT_IDS_STYLE_COLOR) );
		if (m_htiHashNick)   m_ctrlTreeOptions.SetItemText( m_htiHashNick, GetResString(RT_IDS_USE_HASH_NICK) );
		if (m_htiDisplayCountry)   m_ctrlTreeOptions.SetItemText( m_htiDisplayCountry, GetResString(RT_IDS_DISPLAY_COUNTRY) );
		if (m_htiDisplayFlag)   m_ctrlTreeOptions.SetItemText( m_htiDisplayFlag, GetResString(RT_IDS_DISPLAY_FLAG) );
		if (m_htiFontForAllWindows)   m_ctrlTreeOptions.SetItemText( m_htiFontForAllWindows, GetResString(RT_IDS_FONT_ALL_WINDOWS) );
		if (m_htiRatioStyleServer)   m_ctrlTreeOptions.SetItemText( m_htiRatioStyleServer, GetResString(RT_IDS_STYLE_SERVER) );
		if (m_htiRatioStyleTransfer)   m_ctrlTreeOptions.SetItemText( m_htiRatioStyleTransfer, GetResString(RT_IDS_STYLE_TRANSFER) );
		if (m_htiDownloadSortSeparateStop)   m_ctrlTreeOptions.SetItemText( m_htiDownloadSortSeparateStop, GetResString(RT_IDS_DOWNLOAD_SORT_SEPARATE_STOP) );
		if (m_htiDisplayIconOfFiletype)   m_ctrlTreeOptions.SetItemText( m_htiDisplayIconOfFiletype, GetResString(RT_IDS_DISPLAY_ICON_FILETYPE) );
		// Display--Color
		int Pos = 0;
		CString ColorSection;
		ColorSection = GetResString(RT_IDS_COLOR_SECTION);
		for (int i = 0; i < RT_COLOR_SECTION; i++)
		{
			Buffer = ColorSection.Tokenize(_T(";"), Pos);
			if (m_htiRatioColorNode[i])   m_ctrlTreeOptions.SetItemText(m_htiRatioColorNode[i], Buffer);
		}
		//
		Pos = 0;
		CString ColorState;
		ColorState = GetResString(RT_IDS_COLOR_STATE);
		for (int i = 0; i < RT_COLOR_COUNT; i++)
		{
			Buffer = ColorState.Tokenize(_T(";"), Pos);
			if (m_htiRatioColors[i])   m_ctrlTreeOptions.SetItemText(m_htiRatioColors[i], Buffer);
		}
		// Connection
		if (m_htiRatioConnection)   m_ctrlTreeOptions.SetItemText( m_htiRatioConnection, GetResString(IDS_PW_CONNECTION) );
		if (m_htiPingCustomIP)   m_ctrlTreeOptions.SetItemText( m_htiPingCustomIP, GetResString(RT_IDS_PING_CUSTOM_IP) );
		if (m_htiCustomIP)   m_ctrlTreeOptions.SetEditLabel(m_htiCustomIP, GetResString(RT_IDS_CUSTOM_IP));
		if (m_htiSaveOverhead)   m_ctrlTreeOptions.SetItemText( m_htiSaveOverhead, GetResString(RT_IDS_SAVE_OVERHEAD) );
		if (m_htiConnectTimeOut)   m_ctrlTreeOptions.SetEditLabel( m_htiConnectTimeOut, GetResString(RT_IDS_CONNECT_TIME_OUT) );
		if (m_htiRandomTCPPort)   m_ctrlTreeOptions.SetItemText( m_htiRandomTCPPort, GetResString(RT_IDS_RANDOM_TCP_PORT) );
		if (m_htiRTP_Enable)   m_ctrlTreeOptions.SetItemText( m_htiRTP_Enable, GetResString(IDS_ENABLED) );
		if (m_htiRTP_RandomPortList)   m_ctrlTreeOptions.SetEditLabel( m_htiRTP_RandomPortList, GetResString(RT_IDS_PORT_LIST) );
		if (m_htiRandomUDPPort)   m_ctrlTreeOptions.SetItemText( m_htiRandomUDPPort, GetResString(RT_IDS_RANDOM_UDP_PORT) );
		if (m_htiRUP_Enable)   m_ctrlTreeOptions.SetItemText( m_htiRUP_Enable, GetResString(IDS_ENABLED) );
		if (m_htiRUP_RandomPortList)   m_ctrlTreeOptions.SetEditLabel( m_htiRUP_RandomPortList, GetResString(RT_IDS_PORT_LIST) );
		// Connection--Wap Server by MoNKi
		if (m_htiWapServer)   m_ctrlTreeOptions.SetItemText(m_htiWapServer, GetResString(RT_IDS_WAP_INTERFACE));
		if (m_htiWapEnable)   m_ctrlTreeOptions.SetItemText(m_htiWapEnable, GetResString(IDS_ENABLED));
		if (m_htiWapPort)   m_ctrlTreeOptions.SetEditLabel(m_htiWapPort, GetResString(IDS_PORT));
		if (m_htiWapTemplate)   m_ctrlTreeOptions.SetEditLabel(m_htiWapTemplate, GetResString(IDS_WS_RELOAD_TMPL));
		if (m_htiWapPass)   m_ctrlTreeOptions.SetEditLabel(m_htiWapPass, GetResString(IDS_WS_PASS));
		if (m_htiWapLowEnable)   m_ctrlTreeOptions.SetItemText(m_htiWapLowEnable, GetResString(IDS_WEB_LOWUSER));
		if (m_htiWapLowPass)   m_ctrlTreeOptions.SetEditLabel(m_htiWapLowPass, GetResString(IDS_WS_PASS));
		// Directory
//		if (m_htiRatioDirectory) m_ctrlTreeOptions.SetItemText( m_htiRatioDirectory, GetResString(IDS_PW_DIR) );
		// Upload
		if (m_htiRatioUpload)   m_ctrlTreeOptions.SetItemText( m_htiRatioUpload, GetResString(IDS_PW_CON_UPLBL) );
		if (m_htiFriendSlotAuto)   m_ctrlTreeOptions.SetItemText( m_htiFriendSlotAuto, GetResString(RT_IDS_FRIEND_SLOT_AUTO) );
		if (m_htiKeepFriendSlot)   m_ctrlTreeOptions.SetItemText( m_htiKeepFriendSlot, GetResString(RT_IDS_KEEP_FRIEND_SLOT) );
		if (m_htiSlotFocus)   m_ctrlTreeOptions.SetItemText( m_htiSlotFocus, GetResString(RT_IDS_SLOT_FOCUS) );
		if (m_htiMaxReleaseSlot)   m_ctrlTreeOptions.SetEditLabel( m_htiMaxReleaseSlot, GetResString(RT_IDS_MAX_RELEASE_SLOT) );
		if (m_htiMaxCredit1Slot)   m_ctrlTreeOptions.SetEditLabel( m_htiMaxCredit1Slot, GetResString(RT_IDS_MAX_CREDIT1_SLOT) );
		if (m_htiMinUploadSlot)   m_ctrlTreeOptions.SetEditLabel( m_htiMinUploadSlot, GetResString(RT_IDS_MIN_UPLOAD_SLOT) );
		if (m_htiMaxUploadSlot)   m_ctrlTreeOptions.SetEditLabel( m_htiMaxUploadSlot, GetResString(RT_IDS_MAX_UPLOAD_SLOT) );
		// Upload--Priority
		if (m_htiSharedPriority)   m_ctrlTreeOptions.SetItemText( m_htiSharedPriority, GetResString(RT_IDS_SHARED_PRIORITY) );
		Buffer.Format( GetResString(RT_IDS_SHARED_PRIORITY_LIMIT), GetResString(IDS_PRIOVERYLOW) );
		if (m_htiULPrioLimit[RT_PR_VERYLOW])   m_ctrlTreeOptions.SetEditLabel( m_htiULPrioLimit[RT_PR_VERYLOW], Buffer );
		Buffer.Format( GetResString(RT_IDS_SHARED_PRIORITY_LIMIT), GetResString(IDS_PRIOLOW) );
		if (m_htiULPrioLimit[RT_PR_LOW])   m_ctrlTreeOptions.SetEditLabel( m_htiULPrioLimit[RT_PR_LOW], Buffer );
		Buffer.Format( GetResString(RT_IDS_SHARED_PRIORITY_LIMIT), GetResString(IDS_PRIONORMAL) );
		if (m_htiULPrioLimit[RT_PR_NORMAL])   m_ctrlTreeOptions.SetEditLabel( m_htiULPrioLimit[RT_PR_NORMAL], Buffer );
		Buffer.Format( GetResString(RT_IDS_SHARED_PRIORITY_LIMIT), GetResString(IDS_PRIOHIGH) );
		if (m_htiULPrioLimit[RT_PR_HIGH])   m_ctrlTreeOptions.SetEditLabel( m_htiULPrioLimit[RT_PR_HIGH], Buffer );
		// Download
		if (m_htiRatioDownload)   m_ctrlTreeOptions.SetItemText( m_htiRatioDownload, GetResString(IDS_PW_CON_DOWNLBL) );
		if (m_htiPreCheckDiskspace)   m_ctrlTreeOptions.SetItemText( m_htiPreCheckDiskspace, GetResString(RT_IDS_CHECK_DISKSPACE) );
		if (m_htiAutoSwapA4AF)   m_ctrlTreeOptions.SetItemText( m_htiAutoSwapA4AF, GetResString(RT_IDS_AUTO_SWAP_A4AF) );
		if (m_htiMaxQR)   m_ctrlTreeOptions.SetEditLabel( m_htiMaxQR, GetResString(RT_IDS_QR_LIMIT) );
		if (m_htiIncludeStoppedFile)   m_ctrlTreeOptions.SetItemText( m_htiIncludeStoppedFile, GetResString(RT_IDS_INCLUDE_STOPPED_FILE) );
		if (m_htiStartNextFile)  m_ctrlTreeOptions.SetItemText( m_htiStartNextFile, GetResString(IDS_STARTNEXTFILE) );
		if (m_htiByFilePriority)  m_ctrlTreeOptions.SetItemText( m_htiByFilePriority, GetResString(IDS_FILEPRIO) );
		if (m_htiByFileName)  m_ctrlTreeOptions.SetItemText( m_htiByFileName, GetResString(IDS_DL_FILENAME) );
		if (m_htiByFileSize)  m_ctrlTreeOptions.SetItemText( m_htiByFileSize, GetResString(IDS_DL_SIZE) );
		if (m_htiByRemaining)  m_ctrlTreeOptions.SetItemText( m_htiByRemaining, GetResString(IDS_DL_REMAINS) );
		// Download--Priority
		if (m_htiDownloadPriority)   m_ctrlTreeOptions.SetItemText( m_htiDownloadPriority, GetResString(RT_IDS_DOWNLOAD_PRIORITY) );
		Buffer.Format( GetResString(RT_IDS_DOWNLOAD_PRIORITY_LIMIT), GetResString(IDS_PRIOVERYLOW) );
		if (m_htiDLPrioLimit[RT_PR_VERYLOW])   m_ctrlTreeOptions.SetEditLabel( m_htiDLPrioLimit[RT_PR_VERYLOW], Buffer );
		Buffer.Format( GetResString(RT_IDS_DOWNLOAD_PRIORITY_LIMIT), GetResString(IDS_PRIOLOW) );
		if (m_htiDLPrioLimit[RT_PR_LOW])   m_ctrlTreeOptions.SetEditLabel( m_htiDLPrioLimit[RT_PR_LOW], Buffer );
		Buffer.Format( GetResString(RT_IDS_DOWNLOAD_PRIORITY_LIMIT), GetResString(IDS_PRIONORMAL) );
		if (m_htiDLPrioLimit[RT_PR_NORMAL])   m_ctrlTreeOptions.SetEditLabel( m_htiDLPrioLimit[RT_PR_NORMAL], Buffer );
		Buffer.Format( GetResString(RT_IDS_DOWNLOAD_PRIORITY_LIMIT), GetResString(IDS_PRIOHIGH) );
		if (m_htiDLPrioLimit[RT_PR_HIGH])   m_ctrlTreeOptions.SetEditLabel( m_htiDLPrioLimit[RT_PR_HIGH], Buffer );
		// Release
		if (m_htiRatioRelease)   m_ctrlTreeOptions.SetItemText( m_htiRatioRelease, GetResString(RT_IDS_RELEASE_FILE) );
		if (m_htiReleaseRarestOnly)   m_ctrlTreeOptions.SetItemText( m_htiReleaseRarestOnly, GetResString(RT_IDS_RELEASE_RAREST_ONLY) );
		if (m_htiAutoRelease)   m_ctrlTreeOptions.SetEditLabel( m_htiAutoRelease, GetResString(RT_IDS_AUTO_RELEASE) );
		if (m_htiAutoReleaseMin)   m_ctrlTreeOptions.SetEditLabel( m_htiAutoReleaseMin, GetResString(RT_IDS_AUTO_RELEASE_MIN) );
		if (m_htiAutoReleaseMax)   m_ctrlTreeOptions.SetEditLabel( m_htiAutoReleaseMax, GetResString(RT_IDS_AUTO_RELEASE_MAX) );
		if (m_htiMoreRarestPart)   m_ctrlTreeOptions.SetEditLabel( m_htiMoreRarestPart, GetResString(RT_IDS_MORE_RAREST_PART) );
		// Verbose
		if (m_htiRatioVerbose)   m_ctrlTreeOptions.SetItemText( m_htiRatioVerbose, GetResString(RT_IDS_VERBOSE) );
		if (m_htiLogRatioVerbose)   m_ctrlTreeOptions.SetItemText( m_htiLogRatioVerbose, GetResString(RT_IDS_LOG_RATIO_VERBOSE) );
		if (m_htiLogNormalVerbose)   m_ctrlTreeOptions.SetItemText( m_htiLogNormalVerbose, GetResString(RT_IDS_LOG_NORMAL_VERBOSE) );
		if (m_htiLogWebCacheVerbose)   m_ctrlTreeOptions.SetItemText( m_htiLogWebCacheVerbose, GetResString(RT_IDS_WC_LOG_WEBCACHE_VERBOSE) );
	}
}

void CPPgRatio::OnDestroy()
{
	m_ctrlTreeOptions.DeleteAllItems();
	m_ctrlTreeOptions.DestroyWindow();
	m_bInitializedTreeOpts = false;

	// General
	m_htiRatioGeneral = NULL;
	m_htiLeecherCount = NULL;
	m_htiRunHighPriority = NULL;
	m_htiAutoBackupConfig = NULL;
	m_htiABC_Disable = NULL;
	m_htiABC_BACKUP1 = NULL;
	m_htiABC_BACKUP2 = NULL;
	m_htiRecordUploadQueueWaitedTime = NULL;
	m_htiFlushBufferTimeLimit = NULL;
	m_htiSaveCpuLoad = NULL;
	// Display
	m_htiRatioDisplay = NULL;
	m_htiRatioColor = NULL;
	m_htiHashNick = NULL;
	m_htiDisplayCountry = NULL;
	m_htiDisplayFlag = NULL;
	m_htiFontForAllWindows = NULL;
	m_htiRatioStyleServer = NULL;
	m_htiRatioStyleTransfer = NULL;
	m_htiDownloadSortSeparateStop = NULL;
	m_htiDisplayIconOfFiletype = NULL;
	// Display--Color
	for (int i = 0; i < RT_COLOR_SECTION; i++)   m_htiRatioColorNode[i] = NULL;
	for (int i = 0; i < RT_COLOR_COUNT; i++)   m_htiRatioColors[i] = NULL;
	// Connection
	m_htiRatioConnection = NULL;
	m_htiPingCustomIP = NULL;
	m_htiCustomIP = NULL;
	m_htiSaveOverhead = NULL;
	m_htiConnectTimeOut = NULL;
	m_htiRandomTCPPort = NULL;
	m_htiRTP_Enable = NULL;
	m_htiRTP_RandomPortList = NULL;
	m_htiRandomUDPPort = NULL;
	m_htiRUP_Enable = NULL;
	m_htiRUP_RandomPortList = NULL;
	// Wap Server by MoNKi
	m_htiWapServer = NULL;
	m_htiWapEnable = NULL;
	m_htiWapPort = NULL;
	m_htiWapTemplate = NULL;
	m_htiWapPass = NULL;
	m_htiWapLowEnable = NULL;
	m_htiWapLowPass = NULL;
	// Directory
	m_htiRatioDirectory = NULL;
	// Upload
	m_htiRatioUpload = NULL;
	m_htiMoreRarestPart = NULL;
	m_htiMinUploadSlot = NULL;
	m_htiMaxUploadSlot = NULL;
	m_htiKeepFriendSlot = NULL;
	m_htiMaxReleaseSlot = NULL;
	m_htiMaxCredit1Slot = NULL;
	m_htiSlotFocus = NULL;
	m_htiSharedPriority = NULL;
	// Download
	m_htiRatioDownload = NULL;
	m_htiPreCheckDiskspace = NULL;
	m_htiAutoSwapA4AF = NULL;
	m_htiMaxQR = NULL;
	m_htiDownloadPriority = NULL;
	m_htiIncludeStoppedFile = NULL;
	m_htiStartNextFile = NULL;
	m_htiByFilePriority = NULL;
	m_htiByFileName = NULL;
	m_htiByFileSize = NULL;
	m_htiByRemaining = NULL;
	// Release
	m_htiReleaseRarestOnly = NULL;
	m_htiAutoRelease = NULL;
	m_htiAutoReleaseMin = NULL;
	m_htiAutoReleaseMax = NULL;
	// Verbose
	m_htiRatioVerbose = NULL;
	m_htiLogRatioVerbose = NULL;
	m_htiLogNormalVerbose = NULL;
	m_htiLogWebCacheVerbose = NULL;
	//
	CPropertyPage::OnDestroy();
}

LRESULT CPPgRatio::OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam)
{
	if (wParam == RT_IDC_SETTING_TREE)
	{
		TREEOPTSCTRLNOTIFY* pton = (TREEOPTSCTRLNOTIFY*)lParam;
		SetModified();
	}
	return 0;
}