//
#pragma once
#include "TreeOptionsCtrlEx.h"
#include "0RatioFile/RT_Opcodes.h"

// pre defined treeview image list indices
#define	TREEOPTSCTRLIMG_NONE	10

class CPPgRatio : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPgRatio)

protected:
	int			m_iRatioStyleColor;
	int			m_iLeecherCount;
	int			m_iMoreRarestPart;
	int			m_iPreCheckDiskspace;
	int			m_iAutoSwapA4AF;			
	int			m_iMaxQR;
	int			m_iReleaseRarestOnly;
	int			m_iAutoRelease;
	int			m_iAutoReleaseMin;
	int			m_iAutoReleaseMax;
	int			m_iMinUploadSlot;
	int			m_iMaxUploadSlot;
	int			m_iHashNick;
	int			m_iDisplayCountry;
	int			m_iDisplayFlag;
	int			m_iKeepFriendSlot;
	int			m_iMaxReleaseSlot;
	int			m_iMaxCredit1Slot;
	int			m_iFriendSlotAuto;
	int			m_iSlotFocus;
	int			m_iRunHighPriority;
	int			m_iFontForAllWindows;
	int			m_iAutoBackupConfig;
	int			m_iIncludeStoppedFile;
	int			m_iLogRatioVerbose;
	int			m_iLogNormalVerbose;
	int			m_iLogWebCacheVerbose;
	int			m_iPingCustomIP;
	DWORD		m_iCustomIP;
	int			m_iStartNextFile;
	int			m_iRatioStyleServer;
	int			m_iRatioStyleTransfer;
	int			m_iRecordUploadQueueWaitedTime;
	int			m_iRandomTCPPort;
	CString		m_sRandomTCPPortList;
	int			m_iRandomUDPPort;
	CString		m_sRandomUDPPortList;
	int			m_iDownloadSortSeparateStop;
	int			m_iFlushBufferTimeLimit;
	int			m_iSaveCpuLoad;
	int			m_iSaveOverhead;
	int			m_iConnectTimeOut;
	int			m_iDisplayIconOfFiletype;
	// Wap Server by MoNKi
	BOOL		m_bWapEnable;
	int			m_iWapPort;
	CString		m_sWapTemplate;
	CString		m_sWapPass;
	BOOL		m_bWapLowEnable;
	CString		m_sWapLowPass;
	//
	int			m_iDLPrioLimit[RT_PRIORITY_COUNT];
	int			m_iULPrioLimit[RT_PRIORITY_COUNT];
	COLORREF	m_uRatioColors[RT_COLOR_COUNT];
	//
	HTREEITEM	m_htiRatioGeneral;							// node, General
	HTREEITEM	m_htiRatioDisplay;							// node, Display
	HTREEITEM	m_htiRatioConnection;						// node, Connection
	HTREEITEM	m_htiRatioDirectory;						// node, Directory
	HTREEITEM	m_htiRatioRelease;							// node, Release
	HTREEITEM	m_htiRatioUpload;							// node, Upload
	HTREEITEM	m_htiRatioDownload;							// node, Download
	HTREEITEM	m_htiRatioVerbose;							// node, Verbose
	HTREEITEM	m_htiRatioColor;							// Ratio Color Style
	HTREEITEM	m_htiLeecherCount;							// Leecher, if Count >
	HTREEITEM	m_htiMoreRarestPart;						// Release Part More than Rarest
	HTREEITEM	m_htiPreCheckDiskspace;						// PreCheck Free Diskspace
	HTREEITEM	m_htiAutoSwapA4AF;							// Automatically Swap A4AF
	HTREEITEM	m_htiMaxQR;									// Max Limit of Download QR
	HTREEITEM	m_htiReleaseRarestOnly;						// Release Rarest Only
	HTREEITEM	m_htiAutoRelease;							// Auto Release, if > Max and < Min
	HTREEITEM	m_htiAutoReleaseMin;
	HTREEITEM	m_htiAutoReleaseMax;
	HTREEITEM	m_htiMinUploadSlot;							// Minimum of Upload Slot
	HTREEITEM	m_htiMaxUploadSlot;							// Maximum of Upload Slot
	HTREEITEM	m_htiHashNick;								// Use Hash Nick
	HTREEITEM	m_htiDisplayCountry;						// Display Country
	HTREEITEM	m_htiDisplayFlag;							// Display Flag
	HTREEITEM	m_htiKeepFriendSlot;						// Keep Friend Slot Setting
	HTREEITEM	m_htiMaxReleaseSlot;						// Maximum of Release Slot
	HTREEITEM	m_htiMaxCredit1Slot;						// Maximum of Credit1 Slot
	HTREEITEM	m_htiFriendSlotAuto;						// Friend Slot Auto
	HTREEITEM	m_htiSlotFocus;								// Slot Focus
	HTREEITEM	m_htiRunHighPriority;						// Run in the High Priority
	HTREEITEM	m_htiFontForAllWindows;						// Font For All Windows
	HTREEITEM	m_htiAutoBackupConfig;						// Auto Backup Config
	HTREEITEM	m_htiABC_Disable;
	HTREEITEM	m_htiABC_BACKUP1;
	HTREEITEM	m_htiABC_BACKUP2;
	HTREEITEM	m_htiIncludeStoppedFile;					// Include Stopped File
	HTREEITEM	m_htiLogRatioVerbose;						// Log Ratio Verbose
	HTREEITEM	m_htiLogNormalVerbose;						// Log Normal Verbose
	HTREEITEM	m_htiLogWebCacheVerbose;					// Log WebCache Verbose
	HTREEITEM	m_htiPingCustomIP;							// Ping CustomIP
	HTREEITEM	m_htiCustomIP;
	HTREEITEM	m_htiStartNextFile;							// Start Next File
	HTREEITEM	m_htiByFilePriority;
	HTREEITEM	m_htiByFileName;
	HTREEITEM	m_htiByFileSize;
	HTREEITEM	m_htiByRemaining;
	HTREEITEM	m_htiRatioStyleServer;						// RT Style
	HTREEITEM	m_htiRatioStyleTransfer;
	HTREEITEM	m_htiRecordUploadQueueWaitedTime;			// Upload Queue Waited Time
	HTREEITEM	m_htiRandomTCPPort;							// Random Port
	HTREEITEM	m_htiRTP_Enable;
	HTREEITEM	m_htiRTP_RandomPortList;
	HTREEITEM	m_htiRandomUDPPort;
	HTREEITEM	m_htiRUP_Enable;
	HTREEITEM	m_htiRUP_RandomPortList;
	HTREEITEM	m_htiDownloadSortSeparateStop;				// Download Sort Separate Stop
	HTREEITEM	m_htiFlushBufferTimeLimit;					// Flush Buffer Time Limit
	HTREEITEM	m_htiSaveCpuLoad;							// Save CPU Load
	HTREEITEM	m_htiSaveOverhead;							// Save Overhead
	HTREEITEM	m_htiConnectTimeOut;						// Connect Time Out
	HTREEITEM	m_htiDisplayIconOfFiletype;					// Display Icon Of Filetype
	// Wap Server by MoNKi
	HTREEITEM	m_htiWapServer;
	HTREEITEM	m_htiWapEnable;
	HTREEITEM	m_htiWapPort;
	HTREEITEM	m_htiWapTemplate;
	HTREEITEM	m_htiWapPass;
	HTREEITEM	m_htiWapLowEnable;
	HTREEITEM	m_htiWapLowPass;
	//
	HTREEITEM	m_htiDownloadPriority;						// Download Priority Limit
	HTREEITEM	m_htiDLPrioLimit[RT_PRIORITY_COUNT];
	HTREEITEM	m_htiSharedPriority;						// Shared Priority Limit
	HTREEITEM	m_htiULPrioLimit[RT_PRIORITY_COUNT];
	HTREEITEM	m_htiRatioColorNode[RT_COLOR_SECTION];		// Ratio Color Node
	HTREEITEM	m_htiRatioColors[RT_COLOR_COUNT];
	//
public:
	CPPgRatio();
	virtual ~CPPgRatio();

	void Localize(void);

    CTreeOptionsCtrlEx m_ctrlTreeOptions;
	bool m_bInitializedTreeOpts;

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual BOOL OnApply();
	virtual BOOL OnKillActive();

	DECLARE_MESSAGE_MAP()
	afx_msg void OnDestroy();
	afx_msg LRESULT OnTreeOptsCtrlNotify(WPARAM wParam, LPARAM lParam);
};
