//
#include "stdafx.h"
#include "URLClient.h"
#include "UpDownClient.h"
#include "emule.h"
#include "ClientCredits.h"
#include "ClientList.h"
#include "SharedFileList.h"
#include "UploadQueue.h"
#include "KnownFile.h"
#include "PartFile.h"
#include "SafeFile.h"
#include "Packets.h"
#include "Preferences.h"
#include "ListenSocket.h"
#include "OtherFunctions.h"
#include "Sockets.h"
#include "TransferWnd.h"
#include "Statistics.h"
#ifndef _CONSOLE
#include "emuledlg.h"
#endif
// Base
#include "0RatioFile/RT_IP2Country.h"
#include "0RatioFile/RT_Opcodes.h"
// Upload
#include <math.h>
#include "FriendList.h"
#include "0RatioFile/RT_Version.h"
// Download
#include <zlib/zlib.h>

// Default Nick List
const int DefaultNickCount = 11;
const CString DefaultNickList[] =
{
	_T("http://www.emule-project.org"), _T("http://emule-project.net"), _T("http://www.emule-project.net"),
	_T("www.shareaza.com"), _T("http://www.winmule.com"), _T("http://emule-element.tk"), _T("[KOR]www.Pruna.com"),
	_T("[KOR]www.MediaVAMP.com"), _T("http://Www.LioNetwork.Net [lh.2y.net]"), _T("http://Www.L!0Network.Net"),
	_T("http://Www.Li@Network.Net")
};

// Default Mod List
const CString ModList[] =
{
	_T("Official"), _T("Other Client"), _T("Unknown"), _T("ACAT"), _T("AMULE"),
	_T("BLACKRAT"), _T("EASTSHARE"), _T("ECHANBLARD"), _T("EF-MOD"), _T("EWOMBAT"),
	_T("HEBMULE"), _T("LSD"), _T("MFCK"), _T("MORPH"), _T("PAWCIO"),
	_T("PEACE"), _T("PHOENIX"), _T("PLUS"), _T("RT"), _T("SF-IOM"),
	_T("SIVKA"), _T("STORM"), _T("S.W.A.T."), _T("THE BLACK HAND"), _T("ZZUL")
};

/***********
*** Base ***
***********/
//
// Get Client Rating String
CString CUpDownClient::GetRatingString() const
{
	if (m_pszUsername == NULL)   return _T("?");
	if (rt_QueueScore < RT_SCORE_BASIC)
	{
		switch (rt_QueueScore)
		{
			case RT_SCORE_INVALID:
				return GetResString(IDS_IDENTFAILED);
			case RT_SCORE_LEECHER:
			{
				CString RatingString = GetResString(RT_IDS_LEECHER);
				if (GetLeecherCount() != RT_LEECHER)   RatingString.AppendFormat( _T(" (%u)"), GetLeecherCount() );
				return RatingString;
			}
			case RT_SCORE_GPL_EVILDOER:
				return GetResString(RT_IDS_GPL_EVILDOER);
			case RT_SCORE_WAITING:
				return GetResString(IDS_WAITING);
			case RT_SCORE_BANNED:
				if (IsBanned() == true)   return GetResString(IDS_BANNED);
			default:
				return _T("?");
		}
	}
	else
	{
		if (rt_QueueScore >= RT_SCORE_FRIEND)
		{
			if (rt_QueueScore >= RT_SCORE_CREDIT1)
				return GetResString(RT_IDS_CREDIT1);
			else
				return GetResString(IDS_FRIENDLIST);
		}
		else
		{
			if (rt_QueueScore >= RT_SCORE_RELEASE)
				return GetResString(IDS_PRIORELEASE);
			else
			{
				CString RatingString;
				RatingString.Format( _T("%u"), GetScore(false,false,true) );
				return RatingString;
			}
		}
	}
}

// Get Download State String
CString CUpDownClient::GetDownloadStateString() const
{
	if (m_pszUsername == NULL)   return _T("?");
	switch (m_nDownloadState)
	{
		case DS_DOWNLOADING:
			return GetResString(IDS_DOWNLOADING);
		case DS_ONQUEUE:
		{
			if (m_bRemoteQueueFull == true)
				return GetResString(IDS_QUEUEFULL);
			else
			{
				CString Buffer;
				Buffer.Format( _T("%u"), GetRemoteQueueRank() );
				return Buffer;
			}
		}
		case DS_CONNECTING:
			return GetResString(IDS_CONNECTING);
		case DS_NONEEDEDPARTS:
			return GetResString(IDS_NONEEDEDPARTS);
		case DS_BANNED:
			return GetResString(IDS_BANNED);
		default:
			return _T("-");
	}
}

// Get Upload State String
CString CUpDownClient::GetUploadStateString() const
{
	if (m_pszUsername == NULL)   return _T("?");
	switch (m_nUploadState)
	{
		case US_UPLOADING:
			return GetResString(RT_IDS_UPLOADING);
		case US_ONUPLOADQUEUE:
		{
			CString Buffer;
			Buffer.Format( _T("%u"), theApp.uploadqueue->GetWaitingPosition((CUpDownClient*)this, true) );
			return Buffer;
		}
		case US_CONNECTING:
			return GetResString(IDS_CONNECTING);
		case US_BANNED:
			return GetResString(IDS_BANNED);
		default:
			return _T("-");
	}
}

// Set Icon NO
void CUpDownClient::SetIconNO()
{
	if (m_pszUsername == NULL)
	{
		rt_IconNO = 0;
		return;
	}
	switch (m_clientSoft)
	{
		case SO_MLDONKEY:
			rt_IconNO = 2;
			break;
		case SO_EDONKEYHYBRID:
			rt_IconNO = 3;
			break;
		case SO_SHAREAZA:
			rt_IconNO = 4;
			break;
		case SO_AMULE:
			rt_IconNO = 5;
			break;
		case SO_LPHANT:
			rt_IconNO = 6;
			break;
		case SO_URL:
			rt_IconNO = 7;
			break;
		default:
			if (m_bEmuleProtocol == false)
				rt_IconNO = 0;
			else
				rt_IconNO = 1;
	}
	if (m_bFriendSlot == true)   rt_IconNO = 8;
}

// Set Mask NO
void CUpDownClient::SetMaskNO()
{
	if (m_pszUsername == NULL)
	{
		rt_MaskNO = 0;
		return;
	}
	if (credits != NULL)
	{
		switch( credits->GetCurrentIdentState(m_dwUserIP) )
		{
			case IS_IDFAILED:
			case IS_IDNEEDED:
			case IS_IDBADGUY:
				rt_MaskNO = 4;
				return;
		}
	}
	if ( (m_Friend != NULL) && (m_bFriendSlot == false) )
		rt_MaskNO = 2;
	else
		rt_MaskNO = 0;
	if (rt_CreditRatio > 1)   rt_MaskNO++;
}

CString CUpDownClient::GetCountryCode() const
{
	return theApp.IP2Country->GetCountryCode(rt_FlagNO);
}

// Set Flag NO
void CUpDownClient::SetFlagNO()
{
	rt_FlagNO = uint8(theApp.IP2Country->GetFlagNO(m_dwUserIP));
}

// Is Bad Client
bool CUpDownClient::IsBadClient()
{
	// Reset
	if (GetLeecherCount() == RT_LEECHER)   SetLeecherCount(0);
	// known major gpl breaker
	CString strBuffer = m_pszUsername;
	strBuffer.MakeUpper();
	if ( (strBuffer.Find(_T("EMULE-CLIENT")) != -1) || (strBuffer.Find(_T("POWERMULE")) != -1) )
	{
		m_bGPLEvildoer = true;  
		return true;
	}
	// Leecher Userhash
	if (theApp.GetLeecherUserhash().Find(md4str(m_achUserHash)) >= 0)
	{
		SetLeecherCount(RT_LEECHER);
		return false;
	}
	// Check Mod Version
	if (m_strModVersion.IsEmpty() == false)
	{
		CString Buffer = m_strModVersion;
		Buffer.MakeUpper();
		// Include Special Letter
//		if ( uint8(Buffer.GetAt(0)) >= 0x80 )   return true;
		// known major gpl breaker
		if ( (Buffer.Find(_T("LH")) == 0) || (Buffer.Find(_T("LIO")) == 0) )
		{
			m_bGPLEvildoer = true;
			return true;
		}
	}
	// Good Client
	return false;
}

// Client Credit Ratio
float CUpDownClient::GetCreditRatio() const
{
	if (rt_UpdateCreditRatio == true)   ((CUpDownClient*)this)->SetCreditRatio();
	return rt_CreditRatio;
}

// Client Credit Ratio
void CUpDownClient::SetCreditRatio()
{
	rt_UpdateCreditRatio = false;
	if (credits != NULL)   rt_CreditRatio = credits->GetScoreRatio(m_dwUserIP);
	// Set Mask
	SetMaskNO();
}

// Check No Transfer, Default Check Upload
bool CUpDownClient::CheckNoTransferTime(bool CheckDownload)
{
	if (CheckDownload == true)
	{
		if ( (m_nDownDatarate < 50) && (reqfile != NULL) )
		{
			if ( (rt_NoTransferTimeDL != 0) && (reqfile->GetTransferingSrcCount() > 1) && 
				((reqfile->GetAvailablePartCount() + 2) >= reqfile->GetPartCount()) &&
				(::GetTickCount() - rt_NoTransferTimeDL) > SEC2MS(90) )
			{
				if (thePrefs.IsLogRatioVerbose() == true)
					AddDebugLogLine( false, _T(">> [RT Debug] Download session ended due to [Datarate < 0.05KB/s]. { %s } { %s }"), GetUserName(), GetClientSoftVer() );
				return true;
			}
			else
				rt_NoTransferTimeDL = ::GetTickCount();
		}
		else
			rt_NoTransferTimeDL = 0;
	}
	else
	{
		// Speed < 0.05KB/s
		if (m_nUpDatarate < 50)
		{
			if (rt_NoTransferTimeUL == 0)
			{
				if ( (GetQueueSessionPayloadUp() > 0) && (m_BlockRequests_queue.IsEmpty() == TRUE) )
				{
					// No more Request Block
					CKnownFile* UploadFile = theApp.sharedfiles->GetFileByID( GetUploadFileID() );
					UploadFile->AddUploadedStatus(rt_FirstRequestedPart);
					if (thePrefs.IsLogRatioVerbose() == true)
						AddDebugLogLine( false, _T(">> [RT Debug] Upload session ended due to No more Request Block. { %s } { %s } { %s }"), CastItoXBytes(GetQueueSessionPayloadUp()), GetUserName(), GetClientSoftVer() );
					return true;
				}
				else
					rt_NoTransferTimeUL = ::GetTickCount();
			}
			else
			{
				if ( (::GetTickCount() - rt_NoTransferTimeUL) > SEC2MS(90) )
				{
					// Update File Status handshark not finish
					if (IsUpdateFileStatus() == true)
					{
						if (thePrefs.IsLogRatioVerbose() == true)
							AddDebugLogLine(false, _T(">> [RT Debug] Update File Status handshark not finish. { %s } { %s }"), GetUserName(), GetClientSoftVer() );
						return true;
					}
					// Speed < 0.05KB/s keep 90secs
					if (thePrefs.IsLogRatioVerbose() == true)
						AddDebugLogLine(false, _T(">> [RT Debug] Upload session ended due to [Datarate < 0.05KB/s]. { %s } { %s }"), GetUserName(), GetClientSoftVer() );
					return true;
				}
			}
		}
		else
			rt_NoTransferTimeUL = 0;
	}
	return false;
}

// New Method to Set Friend Slot
void CUpDownClient::SetFriendSlot(bool IsFriendSlot)
{
	m_bFriendSlot = IsFriendSlot;
	SetIconNO();
	SetMaskNO();
}

// Insteal of Default Nick
void CUpDownClient::InstealOfDefaultNick(CString Nick)
{
	bool IsHashNick = false;
	if (thePrefs.IsHashNick() == true)
	{
		for (int i = 0; i < DefaultNickCount; i++)
		{
			if (DefaultNickList[i].CompareNoCase(Nick) == 0)
			{
				IsHashNick = true;
				break;
			}
		}
	}
	if (IsHashNick == true)
	{
		if (HasValidHash() == true)
			Nick.Format( _T("[%02X%02X%02X%02X]"), m_achUserHash[0], m_achUserHash[1], m_achUserHash[2], m_achUserHash[3] );
		else
			Nick.Format( _T("[-No Hash-]") );
	}
	m_pszUsername = _tcsdup( Nick.GetBuffer() );
}

// MOD Number Order
void CUpDownClient::SetModNO()
{
	if (m_strModVersion.IsEmpty() == false)
	{
		CString Buffer;
		Buffer.Format( _T("%s"), m_strModVersion );
		Buffer.MakeUpper();
		rt_ModNO = 2;
		for (uint16 i = 3; i < RT_MOD_COUNT; i++)
		{
			if (Buffer.Find(ModList[i]) != -1)
			{
				rt_ModNO = i;
				break;
			}
		}
	}
	else
	{
		// eMule = 0, Other Client Software = 1, Unknown = 2
		switch (m_clientSoft)
		{
			case SO_EMULE:
			case SO_OLDEMULE:
				rt_ModNO = 0;
				break;
			default:
				rt_ModNO = 1;
		}
	}
}

// Client Filename
CString CUpDownClient::GetClientFilename() const
{
	if ( (reqfile != NULL) && (rt_FilenameIndex != -1) )
		return reqfile->GetClientFilename(rt_FilenameIndex);
	else
		return _T("");
}

/*************
*** Upload ***
*************/
//
// Update File Status
bool CUpDownClient::UpdateFileStatus()
{
	CKnownFile* RequstFile = theApp.sharedfiles->GetFileByID( this->GetUploadFileID() );
	if (RequstFile->IsPartFile() == true)   return false;
	if (RequstFile->IsNeedToHidePart(this) == true)
	{
//		if (thePrefs.IsLogRatioVerbose() == true)
//			AddDebugLogLine( false, ">> [RT Debug] Update File Status.<%s> %s <%s>.", m_pszUsername, GetClientSoftVer(), RequstFile->GetFileName() );
		CSafeMemFile data(16+16);
		data.Write(RequstFile->GetFileHash(), 16);
		RequstFile->UpdatePartsInfo();
		RequstFile->HideSomePart(&data);
		Packet* packet = new Packet(&data);
		packet->opcode = OP_FILESTATUS;
		theStats.AddUpDataOverheadFileRequest(packet->size);
		this->socket->SendPacket(packet, true);
		return true;
	}
	return false;
}

// New Method to Calculate Score
uint32 CUpDownClient::GetScore(bool sysvalue, bool isdownloading, bool onlybasevalue) const
{
	if (m_pszUsername == NULL)   return 0;

	if (credits == 0)
	{
		ASSERT ( IsKindOf(RUNTIME_CLASS(CUrlClient)) );
		return 0;
	}

	CKnownFile* UploadFile = theApp.sharedfiles->GetFileByID(requpfileid);
	if (UploadFile == NULL)   return 0;

	if ( sysvalue && HasLowID() && !(socket && socket->IsConnected()) )   return 0;
	
	// Special State
	if ( (GetLeecherCount() == RT_LEECHER) && (m_bGPLEvildoer == false) )   return RT_SCORE_LEECHER;
	if (GetFriendSlot() == true)   return RT_SCORE_FRIEND;
	if ( (isdownloading == true) || (m_bAddNextConnect == true) )
	{
		if (rt_QueueScore >= RT_SCORE_RELEASE)
		{
			if (rt_QueueScore >= RT_SCORE_CREDIT1)
				return RT_SCORE_CREDIT1;
			else
				return RT_SCORE_RELEASE;
		}
	}
	//
	float CreditsRatio = GetCreditRatio();
	// Identification Invalid
	if ( (CreditsRatio == 0) && (GetTransferedDown() < 1048576) )   return RT_SCORE_INVALID;
	// Banned
	if (IsBanned() == true)
	{
		if (CreditsRatio > 1)
			((CUpDownClient*)this)->UnBan();
		else
		{
			return RT_SCORE_BANNED;
		}
	}
	// GPL Evildoer
	if (m_bGPLEvildoer == true)
	{
		if (CreditsRatio > 1)
			((CUpDownClient*)this)->m_bGPLEvildoer = false;
		else
		{
			return RT_SCORE_GPL_EVILDOER;
		}
	}
	//
	uint32 StartTimer = ::GetTickCount() - this->GetWaitStartTime();
	// Wait 30s or 60s
	if (isdownloading == false)
	{
		if (CreditsRatio <= 1)
		{
			if ( (onlybasevalue == false) && (credits->GetCurrentIdentState(GetIP()) != IS_IDENTIFIED) )
			{
				// failed the secure identification
				if (GetClientSoft() != SO_EDONKEYHYBRID)   CreditsRatio = 0.1f;
			}
			if (CreditsRatio < 1)
			{
				if ( StartTimer < SEC2MS(60) )   return RT_SCORE_WAITING;
			}
			else
			{
				if ( StartTimer < SEC2MS(30) )   return RT_SCORE_WAITING;
			}
		}
		else
		{
			if ( StartTimer < SEC2MS(5) )   return RT_SCORE_WAITING;
		}
	}
	// Leecher Count
	if ( GetLeecherCount() >= thePrefs.GetLeecherCount() )
	{
		if (CreditsRatio <= 1)
		{
			uint32 TransferedCheck = GetLeecherCount() * 184320;   // 1 Block = 180 KB
			if ( (GetTransferedDown() < TransferedCheck) && ( credits->GetDownloadedTotal() < TransferedCheck ) )
			{
				return RT_SCORE_LEECHER;
			}
		}
		else
		{
			if (GetLeecherCount() < RT_LEECHER)   ((CUpDownClient*)this)->SetLeecherCount(0);
		}
	}
	// calculate score, based on waitingtime and other factors
	float fBaseValue;
	if (onlybasevalue == true)
	{
		fBaseValue = 100 * CreditsRatio;
		if ( (UploadFile->GetFileRatio() > 1) || (CreditsRatio <= 1) )
			fBaseValue *= UploadFile->GetFileRatio();
	}
	else
	{ 
		// Upload Queue Waited Time
		fBaseValue = GetWaitTime( thePrefs.IsRecordUploadQueueWaitedTime() );
		//
		if ( (isdownloading == true) && (thePrefs.TransferFullChunks() != true) )
		{
			// you get a 30 min bonus
			fBaseValue = fBaseValue + 1800;
			ASSERT ( fBaseValue >= 0 ); //oct 28, 02: changed this from "> 0" to ">= 0"
		}
		// x Credit Ratio
		if (thePrefs.UseCreditSystem() == true)   fBaseValue *= CreditsRatio;
		// x Bonus Ratio
		if ( (UploadFile->GetFileRatio() > 1) || (CreditsRatio <= 1) )
			fBaseValue *= UploadFile->GetFileRatio();
		// Check Credit1 or Release
		if (m_nUploadState == US_ONUPLOADQUEUE)
		{
			// Credit1 Slot
			if ( (thePrefs.GetMaxCredit1Slot() > 0) && (CreditsRatio <= 1) )
			{
				if ( theApp.uploadqueue->GetCredit1SlotCount() >= thePrefs.GetMaxCredit1Slot() )
					fBaseValue /= 60;
				else if ( (HasLowID() == false) || (theApp.uploadqueue->IsCredit1SlotLowID() == false) )
					return ( fBaseValue + RT_SCORE_CREDIT1 );
			}
			// Release Slot
			// Shared File Priority -> Release : Score + <0x10000000 ~ 0x14000000>
			if ( (UploadFile->IsReleaseFile() == true) && (StartTimer > SEC2MS(30)) )
			{
				if ( theApp.uploadqueue->GetReleaseSlotCount() < thePrefs.GetMaxReleaseSlot() )
				{
					if ( (HasLowID() == false) || (theApp.uploadqueue->IsReleaseSlotLowID() == false) )
					{
						// Miss Part ??
						if (UploadFile->GetMissingPart() != -1)
						{
							if ( (CreditsRatio >= 1) && (GetTransferedUp() < PARTSIZE) )
							{
								switch( GetClientSoft() )
								{
									case SO_EMULE:
									case SO_OLDEMULE:
									case SO_XMULE:
										if (GetVersion() >= 260)
										{
											if (CreditsRatio > 1)
												fBaseValue += ( RT_SCORE_RELEASE + (RT_SCORE_RELEASE_LEVEL * 4) );
											else
												fBaseValue += ( RT_SCORE_RELEASE + (RT_SCORE_RELEASE_LEVEL * 3) );
											break;
										}
									default:
										fBaseValue += ( RT_SCORE_RELEASE + (RT_SCORE_RELEASE_LEVEL * 2) );
								}
							}
							else
								fBaseValue += (RT_SCORE_RELEASE + RT_SCORE_RELEASE_LEVEL);
						}
						else
						{ 
							// By Credits
							if ( (CreditsRatio >= 1) && (GetTransferedUp() < PARTSIZE) )
							{
								if (CreditsRatio > 1)
									fBaseValue += ( RT_SCORE_RELEASE + (RT_SCORE_RELEASE_LEVEL * 2) );
								else
									fBaseValue += (RT_SCORE_RELEASE + RT_SCORE_RELEASE_LEVEL);
							}
							else
								fBaseValue += RT_SCORE_RELEASE;
						}
						return uint32(fBaseValue);
					}
				}
			}
		}
	}

	if( (IsEmuleClient() || this->GetClientSoft() < 10) && m_byEmuleVersion <= 0x19 )   fBaseValue *= 0.5f;

	if( (m_bySupportSecIdent == 0) && (CreditsRatio <= 1) )   fBaseValue *= 0.5f;

	if ( (onlybasevalue == true) && (fBaseValue < RT_SCORE_BASIC) )
		fBaseValue = RT_SCORE_BASIC;
	else
		fBaseValue += RT_SCORE_BASIC;

	return uint32(fBaseValue);
}

// Leecher Count
uint8 CUpDownClient::GetLeecherCount() const
{
	if (credits != NULL)
		return credits->GetLeecherCount();
	else
		return 0;
}

// Leecher Count
void CUpDownClient::AddLeecherCount()
{
	if (credits != NULL)   credits->AddLeecherCount();
}

// Leecher Count
void CUpDownClient::SetLeecherCount(uint8 NewValue)
{
	if (credits != NULL)   credits->SetLeecherCount(NewValue);
}

// Wait Start Time
uint32 CUpDownClient::GetWaitStartTime() const
{
	if ( (credits == NULL) || (rt_UploadWaitingTime == 0) )
		return (::GetTickCount() - 1);
	else
		return rt_UploadWaitingTime;
}

// Wait Start Time
void CUpDownClient::SetWaitStartTime()
{
	rt_UploadWaitingTime = ::GetTickCount();
}

// Wait Start Time
void CUpDownClient::ClearWaitStartTime()
{
	rt_UploadWaitingTime = 0;
}

// Upload Queue Waited Time, CUQWT = Credit Upload Queue Waited Time, return Second (not ms, Official)
uint32 CUpDownClient::GetWaitTime(bool IncludeCUQWT) const
{
	if (credits == NULL)   return 0;
	if (IncludeCUQWT == true)
	{
		uint32 Time;
		if (m_dwUploadTime > 0)
			Time = m_dwUploadTime - GetWaitStartTime();
		else
			Time = ::GetTickCount() - GetWaitStartTime();
		return ( (Time / 1000) + credits->GetUploadQueueWaitedTime() );
	}
	else
	{
		if (m_dwUploadTime > 0)
			return ( (m_dwUploadTime - GetWaitStartTime()) / 1000 );
		else
			return ( (::GetTickCount() - GetWaitStartTime()) / 1000 );
	}
}

// Upload Queue Waited Time
uint32 CUpDownClient::GetUploadQueueWaitedTime() const
{
	if (credits == NULL)   return 0;
	return credits->GetUploadQueueWaitedTime();
}

// Upload Queue Waited Time
void CUpDownClient::SetUploadQueueWaitedTime(uint32 NewValue)
{
	if (credits == NULL)   return;
	credits->SetUploadQueueWaitedTime(NewValue);
}

/***************
*** Download ***
***************/
//
// Don't Download
bool CUpDownClient::IsDontDownload() const
{
	if (credits != NULL)
		return credits->IsDontDownload();
	else
		return false;
}

// Don't Download
void CUpDownClient::SetDontDownload(bool NewState)
{
	if (credits != NULL)
	{
		credits->SetDontDownload(NewState);
		if (GetDownloadState() == DS_NONEEDEDPARTS)   SetDownloadState(DS_NONE);
	}
}

// Save CPU Load
void CUpDownClient::CreateBlockRequests(int iMaxBlocks)
{
	ASSERT( iMaxBlocks >= 1 /*&& iMaxBlocks <= 3*/ );
	if (m_DownloadBlocks_list.IsEmpty())
	{
		uint16 BlockCount = iMaxBlocks;
		Requested_Block_Struct** toadd = new Requested_Block_Struct*[BlockCount];
		if (reqfile->GetNextRequestedBlock(this, toadd, &BlockCount) == true)
		{
			for (int i = 0; i < BlockCount; i++)   m_DownloadBlocks_list.AddTail(toadd[i]);
#ifdef	RT_TEST
			if (thePrefs.IsLogRatioVerbose() == true)
				AddDebugLogLine( false, _T(">> [RT Debug] Get Next Requested Blocks List.[%u Blocks]  { %s }  { %s }"), BlockCount, GetUserName(), reqfile->GetFileName() );
#endif
		}
		delete[] toadd;
	}
	//
	while ( (m_PendingBlocks_list.GetCount() < 3) && (m_DownloadBlocks_list.IsEmpty() == false) )
	{
		Pending_Block_Struct* pblock = new Pending_Block_Struct;
		pblock->block = m_DownloadBlocks_list.RemoveHead();
		m_PendingBlocks_list.AddTail(pblock);
	}
}

// RT, Save CPU load
void CUpDownClient::UpdateDisplayedInfo(bool force)
{
#ifdef _DEBUG
	force = true;
#endif
    DWORD curTick = ::GetTickCount();
    if ( (force == true) || ((curTick - m_lastRefreshedDLDisplay) > SEC2MS(3)) )
	{
        // Update display
		if (theApp.emuledlg->activewnd == theApp.emuledlg->transferwnd)
		{
		    theApp.emuledlg->transferwnd->downloadlistctrl.UpdateItem(this);
			theApp.emuledlg->transferwnd->clientlistctrl.RefreshClient(this);
		}
        m_lastRefreshedDLDisplay = curTick - (m_lastRefreshedDLDisplay & 0x000003FF);
    }
}

// Reask For Download
bool CUpDownClient::IsReaskForDownload() const
{
	return ( (m_dwLastTriedToConnect == 0) || ((::GetTickCount() - m_dwLastTriedToConnect) > MIN2MS(50)) );
}

// Abort Downloading
void CUpDownClient::AbortDownloading(CString Reason)
{
	if (GetSentCancelTransfer() == false)
	{
		SendCancelTransfer();
		SetDownloadState( ((reqfile == NULL) || (reqfile->IsStopped() == true)) ? DS_NONE : DS_NONEEDEDPARTS );
	}
	if (thePrefs.IsLogRatioVerbose() == true)
		AddDebugLogLine( false, _T(">> [RT Debug] Abort Downloading, Because [%s]. { %s } { %s }"), Reason, GetUserName(), GetClientSoftVer() );
}