//
#include "stdafx.h"
#include "emule.h"
#include "FriendList.h"
#include "UpDownClient.h"
#include "Friend.h"
#include "Preferences.h"
#include "ServerWnd.h"
#ifndef _CONSOLE
#include "emuledlg.h"
#include "FriendListCtrl.h"
#endif

// Keep Friend Slot
void CFriendList::SetFriendSlot()
{
	if ( (thePrefs.IsFriendSlotAuto() == true) || (thePrefs.IsKeepFriendSlot() == false) )   return;
	POSITION pos = m_listFriends.GetHeadPosition();
	while (pos != NULL)
	{
		CUpDownClient* Client = ((CFriend*)m_listFriends.GetNext(pos))->GetLinkedClient();
		if (Client != NULL)
		{
			if (Client->m_bAddNextConnect == false)
				Client->SetFriendSlot(false);
			if (thePrefs.IsCurrentFS( Client->GetUserHash() ) == true)
				Client->SetFriendSlot(true);
		}
	}
	if (m_wndOutput)   m_wndOutput->UpdateList();
}

// Keep Friend Slot
void CFriendList::SetFriendSlot(CUpDownClient* Client, bool OldStatus)
{
	if (Client->m_Friend != NULL)   SetFriendSlot(Client->m_Friend, OldStatus);
}

// Keep Friend Slot
void CFriendList::SetFriendSlot(CFriend* Friend, bool OldStatus)
{
	if (thePrefs.IsFriendSlotAuto() == true)   return;
	CUpDownClient* Client = Friend->GetLinkedClient();
	RemoveAllFriendSlots();
	if (OldStatus == false)
		Friend->SetFriendSlot(true);
	else
	{
		Friend->SetFriendSlot(false);
		if (Client != NULL)   Client->m_bAddNextConnect = false;
	}
	if (thePrefs.IsKeepFriendSlot() == true)
	{
		if (OldStatus == false)
			thePrefs.SetUserHashFS(Friend->m_abyUserhash);
		else
			thePrefs.SetUserHashFS( CString("") );
		thePrefs.RT_SaveSettings();
		theApp.emuledlg->serverwnd->UpdateMyInfo();
	}
	// Update
	if (Client != NULL)
	{
		uint32 CurrentScore = Client->GetScore(false);
		Client->SetQueueScore(CurrentScore);
	}
	if (m_wndOutput)   m_wndOutput->UpdateList();
	RefreshFriend(Friend);
}

// New Method to RemoveAllFriendSlots
void CFriendList::RemoveAllFriendSlots()
{
	POSITION pos = m_listFriends.GetHeadPosition();
	while (pos != NULL)
	{
		CUpDownClient* Client = ((CFriend*)m_listFriends.GetNext(pos))->GetLinkedClient();
		if (Client != NULL)
		{
			if ( (Client->GetFriendSlot() == true) && (Client->IsDownloading() == false) )
			{
				Client->m_bAddNextConnect = false;
				Client->SetFriendSlot(false);
			}
		}
	}
}