//
#include "stdafx.h"
#include "Preferences.h"
#include "Ini2.h"
#include "emule.h"
#include "PartFile.h"
#include "math.h"
#include "Pinger.h"
#include "Statistics.h"
#include "ServerList.h"
#include "sockets.h"
#include "ListenSocket.h"
#include "UploadQueue.h"
#include "DownloadQueue.h"
#include "OtherFunctions.h"
#include "Opcodes.h"
#include "SharedFileList.h"
#include "ClientCredits.h"
#include "0RatioFile/RT_Other.h"
#include "0RatioFile/RT_Version.h"
#include "0RatioFile/RT_Opcodes.h"

// Default Mod List
const CString ModList[] =	{_T("Official"), _T("Other Client"), _T("Unknown"), _T("ACAT"), _T("aMule"),
							 _T("BlackRat"), _T("EastShare"), _T("eChanblard"), _T("eF-Mod"), _T("eWombat"),
							 _T("hebMule"), _T("LSD"), _T("MFCK"), _T("Morph"), _T("Pawcio"),
							 _T("Peace"), _T("pHoeniX"), _T("Plus"), _T("RT"), _T("SF-IOM"),
							 _T("Sivka"), _T("Stormit"), _T("S.W.A.T."), _T("The Black Hand"), _T("ZZUL")};
// Country List
const CString CountryList = _T("??AFALDZADAOAGARAMAUATAZBSBHBDBBBYBEBZBJBTBOBABWBRBNBGBFBIKHCMCACVCFTDCLTWCNCOKMCGCDCRCIHRCUCYCZDKDJDMDOTPECEGSVGQEREEETFJFIFRGAGMGEDEGHGRGDGTGNGWGYHTVAHNHUISINIDIRIQIEILITJMJPJOKZKEKIKR88KWKGLALVLBLSLRLYLILTLUMKMGMWMYMVMLMTMHMRMUMXFMMDMCMNMAMZMMNANRNPNLNZNINENGNOOMPK88PWPAPGPYPEPHPLPTQARORURWKNLCVCWSSMSTSASNSCSLSGSKSISBSOZA88ESLKSDSRSZSECHSYTJTZTHTGTOTTTNTRTMTVUGUAAEUKUSUYUZVUVEVNYEYUZMZWGBHKMOPS");
// Ignore File for Backup
const CString IgnoreFileList = _T("clients.met, known.met, RT_Clients.dat");
// Copy Only File for Backup2
const CString CopyOnlyFileList = _T("adresses.dat, webservices.dat, cryptkey.dat, fileinfo.ini, staticservers.dat, \
									index.dat, AC_IPFilterUpdateURLs.dat, AC_ServerMetURLs.dat, AC_SearchStrings.dat \
									AC_BootstrapIPs.dat, Ipfilter.dat, statbkup.ini, RT_IP2Country.dat, s_index.dat, \
									preferencesK.dat, k_index.dat, RT_FakeFiles.ini, Category.ini, RT_Category.ini, \
									known2.met");
//
//
// Friend Slot Auto
bool		CPreferences::rt_FriendSlotAuto;
// PreCheck Diskspace
bool		CPreferences::rt_PreCheckDiskspace;
// Auto Swap A4AF
bool		CPreferences::rt_AutoSwapA4AF;
// Use Ratio Color
bool		CPreferences::rt_RatioColor;
// New User Hash
bool		CPreferences::rt_NewUserHash;
// Release Rarest Only
bool		CPreferences::rt_ReleaseRarestOnly;
// Auto Release, if > Max and < Min
bool		CPreferences::rt_AutoRelease;
// Use Hash Nick
bool		CPreferences::rt_HashNick;
// More than Rarest Part
uint8		CPreferences::rt_MoreRarestPart;
// Leecher, if Count >
uint8		CPreferences::rt_LeecherCount;
// Maximum, Minimum of Upload Slot
uint8		CPreferences::rt_MinUploadSlot;
uint8		CPreferences::rt_MaxUploadSlot;
// Max QR of Download
uint16		CPreferences::rt_MaxQR;
// Auto Release Minimum, Maximum
uint16		CPreferences::rt_AutoReleaseMin;
uint16		CPreferences::rt_AutoReleaseMax;
// Display Country Name
bool		CPreferences::rt_DisplayCountry;
bool		CPreferences::rt_DisplayFlag;
// Keep Friend Slot Setting
bool		CPreferences::rt_KeepFriendSlot;
uchar		CPreferences::rt_UserHashFS[16];
// Maximum of Release Slot
uint8		CPreferences::rt_MaxReleaseSlot;
// Maximum of Credit1 Slot
uint8		CPreferences::rt_MaxCredit1Slot;
// Slot Focus
bool		CPreferences::rt_SlotFocus;
// UserNick for Server
CString		CPreferences::rt_UserNickforServer;
// Run in the High Priority
bool		CPreferences::rt_RunHighPriority;
// Font for All Windows
bool		CPreferences::rt_FontForAllWindows;
// Backup Config
uint8		CPreferences::rt_AutoBackupConfig;
// Download Priority Limit
uint16		CPreferences::rt_DLPrioLimit[RT_PRIORITY_COUNT];
// Shared Priority Limit
uint16		CPreferences::rt_ULPrioLimit[RT_PRIORITY_COUNT];
// Include Stopped File
bool		CPreferences::rt_IncludeStoppedFile;
// Log Ratio Verbose
bool		CPreferences::rt_LogRatioVerbose;
// Log Normal Verbose
bool		CPreferences::rt_LogNormalVerbose;
// Table Sort Plus
uint16		CPreferences::rt_TableSortPlus;
// Cumulative source breakdown stats for transfer bytes...
uint64		CPreferences::rt_CumulativeUploadMod[RT_MOD_COUNT];
uint64		CPreferences::rt_CumulativeUploadCountry[RT_COUNTRY_COUNT];
uint64		CPreferences::rt_CumulativeDownloadMod[RT_MOD_COUNT];
uint64		CPreferences::rt_CumulativeDownloadCountry[RT_COUNTRY_COUNT];
// Session source breakdown stats for transfer bytes...
uint64		CPreferences::rt_SessionUploadMod[RT_MOD_COUNT];
uint64		CPreferences::rt_SessionUploadCountry[RT_COUNTRY_COUNT];
uint64		CPreferences::rt_SessionDownloadMod[RT_MOD_COUNT];
uint64		CPreferences::rt_SessionDownloadCountry[RT_COUNTRY_COUNT];
// Status Expand
uint8		CPreferences::rt_StatusExpand;
// Ping Custom IP
bool		CPreferences::rt_PingCustomIP;
uint32		CPreferences::rt_CustomIP;
// Start Next File By
uint8		CPreferences::rt_StartNextFileBy;
// RT Style
bool		CPreferences::rt_RatioStyleServer;
bool		CPreferences::rt_RatioStyleTransfer;
// Upload Queue Waited Time
bool		CPreferences::rt_RecordUploadQueueWaitedTime;
// Download Sort Separate Stop
bool		CPreferences::rt_DownloadSortSeparateStop;
// Flush Buffer Time Limit
uint32		CPreferences::rt_FlushBufferTimeLimit;
// Normal Exit
bool		CPreferences::rt_NormalExitLastTime;
// Ratio Colors
COLORREF	CPreferences::rt_RatioColors[RT_COLOR_COUNT];
// Category Temporary Directory
CArray		<CString, CString&> CPreferences::rt_CategoryTempDir;
// Category View Filter
CArray		<int, int> CPreferences::rt_CategoryViewFilter;
// Column Settings
uint16		CPreferences::downloadColumnWidths[14];   // Original = 13
BOOL		CPreferences::downloadColumnHidden[14];
INT			CPreferences::downloadColumnOrder[14];
uint16		CPreferences::uploadColumnWidths[11];   // Original = 8
BOOL		CPreferences::uploadColumnHidden[11];
INT			CPreferences::uploadColumnOrder[11];
uint16		CPreferences::queueColumnWidths[13];   // Original = 10
BOOL		CPreferences::queueColumnHidden[13];
INT			CPreferences::queueColumnOrder[13];
uint16		CPreferences::searchColumnWidths[14];   // No Change
BOOL		CPreferences::searchColumnHidden[14];
INT			CPreferences::searchColumnOrder[14];
uint16		CPreferences::sharedColumnWidths[13];   // Original = 12
BOOL		CPreferences::sharedColumnHidden[13];
INT			CPreferences::sharedColumnOrder[13];
uint16		CPreferences::serverColumnWidths[14];   // No Change
BOOL		CPreferences::serverColumnHidden[14];
INT			CPreferences::serverColumnOrder[14];
uint16		CPreferences::clientListColumnWidths[9];   // Original = 8
BOOL		CPreferences::clientListColumnHidden[9];
INT			CPreferences::clientListColumnOrder[9];
//
// Load Ratio Setting
void CPreferences::RT_LoadSettings()
{
	CString Filename, Buffer;
	Filename.Format( _T("%sRT_Preferences.ini"), configdir);
	CIni RatioIni( Filename, _T("General") );
	//
	int MinUploadSlot = (int)sqrt((double)maxGraphUploadRate + 1) - 1;
	if (MinUploadSlot < 2)   MinUploadSlot = 2;
	int MaxUploadSlot = (int)maxGraphUploadRate / 3;
	if (MaxUploadSlot < 2)   MaxUploadSlot = 2;
	CString VersionRT = RatioIni.GetString( _T("Version"), _T(""), _T("General") );
	if (VersionRT.IsEmpty() == false)
	{
		// General
		rt_RunHighPriority = RatioIni.GetBool( _T("RunHighPriority"), false, _T("General") );
		rt_AutoBackupConfig = RatioIni.GetInt( _T("BackupConfig"), RT_ABC_BACKUP1, _T("General") );
		rt_LeecherCount = RatioIni.GetInt( _T("LeecherCount"), 3, _T("General") );
		rt_UserNickforServer = RatioIni.GetString( _T("UserNickforServer"), _T(""), _T("General") );
		rt_TableSortPlus = RatioIni.GetInt( _T("TableSortPlus"), 0, _T("General") );
		rt_StatusExpand = RatioIni.GetInt( _T("StatusExpand"), 0xFF, _T("General") );
		rt_RecordUploadQueueWaitedTime = RatioIni.GetBool( _T("RecordUploadQueueWaitedTime"), true, _T("General") );
		rt_FlushBufferTimeLimit = RatioIni.GetUInt64( _T("FlushBufferTimeLimit"), MIN2MS(1), _T("General") );
		// Display
		rt_HashNick = RatioIni.GetBool( _T("IsHashNick"), true, _T("Display") );
		rt_DisplayCountry = RatioIni.GetBool( _T("IsDisplayCountry"), true, _T("Display") );
		rt_DisplayFlag = RatioIni.GetBool( _T("IsDisplayFlag"), true, _T("Display") );
		rt_FontForAllWindows = RatioIni.GetBool( _T("FontForAllWindows"), false, _T("Display") );
		rt_RatioColor = RatioIni.GetBool( _T("IsRatioColor"), true, _T("Display") );
		rt_RatioStyleServer = RatioIni.GetBool( _T("IsRatioStyleServer"), true, _T("Display") );
		rt_RatioStyleTransfer = RatioIni.GetBool( _T("IsRatioStyleTransfer"), true, _T("Display") );
		rt_DownloadSortSeparateStop = RatioIni.GetBool( _T("IsDownloadSortSeparateStop"), true, _T("Display") );
		// Display--Color
		RatioIni.SerGet(true, rt_RatioColors, ARRSIZE(rt_RatioColors), _T("RatioColors"), _T("Display") );
		// Connection
		rt_PingCustomIP = RatioIni.GetBool( _T("IsPingCustomIP"), false, _T("Connection") );
		rt_CustomIP = RatioIni.GetUInt64( _T("CustomIP"), 0, _T("Connection") );
		// Directory
		// Release
		rt_ReleaseRarestOnly = RatioIni.GetBool( _T("IsReleaseRarestOnly"), true, _T("Release") );
		rt_MoreRarestPart = RatioIni.GetInt( _T("MoreRarestPart"), 0, _T("Release") );
		rt_AutoRelease = RatioIni.GetBool( _T("IsAutoRelease"), true, _T("Release") );
		rt_AutoReleaseMin = RatioIni.GetInt( _T("AutoReleaseMin"), 1, _T("Release") );
		rt_AutoReleaseMax = RatioIni.GetInt( _T("AutoReleaseMax"), 20, _T("Release") );
		// Upload
		rt_FriendSlotAuto = RatioIni.GetBool( _T("FriendSlotAuto"), false, _T("Upload") );
		rt_MinUploadSlot = RatioIni.GetInt( _T("MinUploadSlot"), MinUploadSlot, _T("Upload") );
		rt_MaxUploadSlot = RatioIni.GetInt( _T("MaxUploadSlot"), MaxUploadSlot, _T("Upload") );
		rt_KeepFriendSlot = RatioIni.GetBool( _T("IsKeepFriendSlot"), false, _T("Upload") );
		rt_SlotFocus = RatioIni.GetBool( _T("IsSlotFocus"), false, _T("Upload") );
		rt_MaxReleaseSlot = RatioIni.GetInt( _T("MaxReleaseSlot"), 1, _T("Upload") );
		rt_MaxCredit1Slot = RatioIni.GetInt( _T("MaxCredit1Slot"), 0, _T("Upload") );
		SetUserHashFS( RatioIni.GetString( _T("UserHashFS"), _T(""), _T("Upload") ) );
		// Upload--Priority Limit
		RatioIni.SerGet(true, rt_ULPrioLimit, ARRSIZE(rt_ULPrioLimit), _T("ULPriorityLimit"), _T("Upload") );
		// Download
		rt_PreCheckDiskspace = RatioIni.GetBool( _T("PreCheckDiskspace"), true, _T("Download") );
		rt_AutoSwapA4AF = RatioIni.GetBool( _T("AutoSwapA4AF"), true, _T("Download") );
		rt_MaxQR = RatioIni.GetInt( _T("MaxQR"), 2000, _T("Download") );
		rt_IncludeStoppedFile = RatioIni.GetBool( _T("IncludeStoppedFile"), true, _T("Download") );
		rt_StartNextFileBy = RatioIni.GetInt( _T("StartNextFileBy"), RT_BY_PRIORITY, _T("Download") );
		// Download--Priority Limit
		RatioIni.SerGet(true, rt_DLPrioLimit, ARRSIZE(rt_DLPrioLimit), _T("DLPriorityLimit"), _T("Download") );
		// Log
		rt_LogRatioVerbose = RatioIni.GetBool( _T("LogRatioVerbose"), false, _T("Log") );
		rt_LogNormalVerbose = RatioIni.GetBool( _T("LogNormalVerbose"), true, _T("Log") );
		// Column Settings
		RatioIni.SerGet(true, downloadColumnWidths, ARRSIZE(downloadColumnWidths), _T("DownloadColumnWidths"), _T("Column") );
		RatioIni.SerGet(true, downloadColumnHidden, ARRSIZE(downloadColumnHidden), _T("DownloadColumnHidden"), _T("Column") );
		RatioIni.SerGet(true, downloadColumnOrder, ARRSIZE(downloadColumnOrder), _T("DownloadColumnOrder"), _T("Column") );
		RatioIni.SerGet(true, uploadColumnWidths, ARRSIZE(uploadColumnWidths), _T("UploadColumnWidths"), _T("Column") );
		RatioIni.SerGet(true, uploadColumnHidden, ARRSIZE(uploadColumnHidden), _T("UploadColumnHidden"), _T("Column") );
		RatioIni.SerGet(true, uploadColumnOrder, ARRSIZE(uploadColumnOrder), _T("UploadColumnOrder"), _T("Column") );
		RatioIni.SerGet(true, sharedColumnWidths, ARRSIZE(sharedColumnWidths), _T("SharedColumnWidths"), _T("Column") );
		RatioIni.SerGet(true, sharedColumnHidden, ARRSIZE(sharedColumnHidden), _T("SharedColumnHidden"), _T("Column") );
		RatioIni.SerGet(true, sharedColumnOrder, ARRSIZE(sharedColumnOrder), _T("SharedColumnOrder"), _T("Column") );
		RatioIni.SerGet(true, queueColumnWidths, ARRSIZE(queueColumnWidths), _T("QueueColumnWidths"), _T("Column") );
		RatioIni.SerGet(true, queueColumnHidden, ARRSIZE(queueColumnHidden), _T("QueueColumnHidden"), _T("Column") );
		RatioIni.SerGet(true, queueColumnOrder, ARRSIZE(queueColumnOrder), _T("QueueColumnOrder"), _T("Column") );
		RatioIni.SerGet(true, clientListColumnWidths, ARRSIZE(clientListColumnWidths), _T("ClientListColumnWidths"), _T("Column") );
		RatioIni.SerGet(true, clientListColumnHidden, ARRSIZE(clientListColumnHidden), _T("ClientListColumnHidden"), _T("Column") );
		RatioIni.SerGet(true, clientListColumnOrder, ARRSIZE(clientListColumnOrder), _T("ClientListColumnOrder"), _T("Column") );
	}
	else
	{
		rt_PreCheckDiskspace = RatioIni.GetBool( _T("PreCheckDiskspace"), true, _T("Ratio") );
		rt_AutoSwapA4AF = RatioIni.GetBool( _T("AutoSwapA4AF"), true, _T("Ratio") );
		rt_RatioColor = RatioIni.GetBool( _T("IsRatioColor"), true, _T("Ratio") );
		rt_ReleaseRarestOnly = RatioIni.GetBool( _T("IsReleaseRarestOnly"), true, _T("Ratio") );
		rt_MoreRarestPart = RatioIni.GetInt( _T("MoreRarestPart"), 0, _T("Ratio") );
		rt_MaxQR = RatioIni.GetInt( _T("MaxQR"), 2000, _T("Ratio") );
		rt_LeecherCount = RatioIni.GetInt( _T("LeecherCount"), 3, _T("Ratio") );
		rt_AutoRelease = RatioIni.GetBool( _T("IsAutoRelease"), true, _T("Ratio") );
		rt_AutoReleaseMin = RatioIni.GetInt( _T("AutoReleaseMin"), 1, _T("Ratio") );
		rt_AutoReleaseMax = RatioIni.GetInt( _T("AutoReleaseMax"), 20, _T("Ratio") );
		rt_MinUploadSlot = RatioIni.GetInt( _T("MinUploadSlot"), MinUploadSlot, _T("Ratio") );
		rt_MaxUploadSlot = RatioIni.GetInt( _T("MaxUploadSlot"), MaxUploadSlot, _T("Ratio") );
		rt_HashNick = RatioIni.GetBool( _T("IsHashNick"), true, _T("Ratio") );
		rt_DisplayCountry = RatioIni.GetBool( _T("IsDisplayCountry"), true, _T("Ratio") );
		rt_DisplayFlag = RatioIni.GetBool( _T("IsDisplayFlag"), true, _T("Ratio") );
		rt_KeepFriendSlot = RatioIni.GetBool( _T("IsKeepFriendSlot"), false, _T("Ratio") );
		rt_SlotFocus = RatioIni.GetBool( _T("IsSlotFocus"), false, _T("Ratio") );
		rt_FriendSlotAuto = RatioIni.GetBool( _T("FriendSlotAuto"), false, _T("Ratio") );
		rt_MaxReleaseSlot = RatioIni.GetInt( _T("MaxReleaseSlot"), 1, _T("Ratio") );
		rt_MaxCredit1Slot = RatioIni.GetInt( _T("MaxCredit1Slot"), 0, _T("Ratio") );
		rt_UserNickforServer = RatioIni.GetString( _T("UserNickforServer"), _T(""), _T("Ratio") );
		rt_RunHighPriority = RatioIni.GetBool( _T("RunHighPriority"), false, _T("Ratio") );
		rt_FontForAllWindows = RatioIni.GetBool( _T("FontForAllWindows"), false, _T("Ratio") );
		rt_AutoBackupConfig = RatioIni.GetInt( _T("BackupConfig"), RT_ABC_BACKUP1, _T("Ratio") );
		//
		RatioIni.SerGet(true, rt_ULPrioLimit, ARRSIZE(rt_ULPrioLimit), _T("ULPriorityLimit"), _T("Ratio") );
		//
		RatioIni.SerGet(true, rt_DLPrioLimit, ARRSIZE(rt_DLPrioLimit), _T("DLPriorityLimit"), _T("Ratio") );
		// Display--Color
		RatioIni.SerGet(true, rt_RatioColors, ARRSIZE(rt_RatioColors), _T("RatioColors"), _T("Ratio") );
		//
		rt_IncludeStoppedFile = RatioIni.GetBool( _T("IncludeStoppedFile"), true, _T("Ratio") );
		rt_LogRatioVerbose = RatioIni.GetBool( _T("LogRatioVerbose"), false, _T("Ratio") );
		rt_LogNormalVerbose = RatioIni.GetBool( _T("LogNormalVerbose"), true, _T("Ratio") );
		rt_TableSortPlus = RatioIni.GetInt( _T("TableSortPlus"), 0, _T("Ratio") );
		rt_StatusExpand = RatioIni.GetInt( _T("StatusExpand"), 0xFF, _T("Ratio") );
		rt_PingCustomIP = RatioIni.GetBool( _T("IsPingCustomIP"), false, _T("Ratio") );
		rt_CustomIP = RatioIni.GetUInt64( _T("CustomIP"), 0, _T("Ratio") );
		rt_StartNextFileBy = RatioIni.GetInt( _T("StartNextFileBy"), RT_BY_PRIORITY, _T("Ratio") );
		rt_RatioStyleServer = RatioIni.GetBool( _T("IsRatioStyleServer"), true, _T("Ratio") );
		rt_RatioStyleTransfer = RatioIni.GetBool( _T("IsRatioStyleTransfer"), true, _T("Ratio") );
		rt_RecordUploadQueueWaitedTime = RatioIni.GetBool( _T("RecordUploadQueueWaitedTime"), true, _T("Ratio") );
		rt_DownloadSortSeparateStop = RatioIni.GetBool( _T("IsDownloadSortSeparateStop"), true, _T("Ratio") );
		rt_FlushBufferTimeLimit = RatioIni.GetUInt64( _T("FlushBufferTimeLimit"), MIN2MS(1), _T("Ratio") );
		SetUserHashFS( RatioIni.GetString( _T("UserHashFS"), _T(""), _T("Ratio") ) );
		// Column Settings
		RatioIni.SerGet(true, downloadColumnWidths, ARRSIZE(downloadColumnWidths), _T("DownloadColumnWidths"), _T("Column") );
		RatioIni.SerGet(true, downloadColumnHidden, ARRSIZE(downloadColumnHidden), _T("DownloadColumnHidden"), _T("Column") );
		RatioIni.SerGet(true, downloadColumnOrder, ARRSIZE(downloadColumnOrder), _T("DownloadColumnOrder"), _T("Column") );
		RatioIni.SerGet(true, uploadColumnWidths, ARRSIZE(uploadColumnWidths), _T("UploadColumnWidths"), _T("Column") );
		RatioIni.SerGet(true, uploadColumnHidden, ARRSIZE(uploadColumnHidden), _T("UploadColumnHidden"), _T("Column") );
		RatioIni.SerGet(true, uploadColumnOrder, ARRSIZE(uploadColumnOrder), _T("UploadColumnOrder"), _T("Column") );
		RatioIni.SerGet(true, sharedColumnWidths, ARRSIZE(sharedColumnWidths), _T("SharedColumnWidths"), _T("Column") );
		RatioIni.SerGet(true, sharedColumnHidden, ARRSIZE(sharedColumnHidden), _T("SharedColumnHidden"), _T("Column") );
		RatioIni.SerGet(true, sharedColumnOrder, ARRSIZE(sharedColumnOrder), _T("SharedColumnOrder"), _T("Column") );
		RatioIni.SerGet(true, queueColumnWidths, ARRSIZE(queueColumnWidths), _T("QueueColumnWidths"), _T("Column") );
		RatioIni.SerGet(true, queueColumnHidden, ARRSIZE(queueColumnHidden), _T("QueueColumnHidden"), _T("Column") );
		RatioIni.SerGet(true, queueColumnOrder, ARRSIZE(queueColumnOrder), _T("QueueColumnOrder"), _T("Column") );
		RatioIni.SerGet(true, clientListColumnWidths, ARRSIZE(clientListColumnWidths), _T("ClientListColumnWidths"), _T("Column") );
		RatioIni.SerGet(true, clientListColumnHidden, ARRSIZE(clientListColumnHidden), _T("ClientListColumnHidden"), _T("Column") );
		RatioIni.SerGet(true, clientListColumnOrder, ARRSIZE(clientListColumnOrder), _T("ClientListColumnOrder"), _T("Column") );
	}
	if (theApp.GetModVersion() != VersionRT)
	{
		// Changed--Not use RT before
		if (VersionRT.IsEmpty() == true)
		{
			deadserverretries = 0;
			m_iExtractMetaData = 0;
			m_iCommitFiles = 2;
			if (m_iFileBufferSize < 524288)   m_iFileBufferSize = 524288;   // 524288 = 512 * 1024
		}
		// Changed--Below "RT.13b"
		else if (VersionRT.Compare(_T("RT.13b")) < 0)
		{
			deadserverretries = 0;
			m_iExtractMetaData = 0;
		}
		// Initial
		rt_UserNickforServer.Format( _T("[CHN][eDtoon][Popgo][KOR][ARC][TLF][VeryCD][Cyndi][Dmhy][EastShare]") );
		// Connection
		if (rt_PingCustomIP == false)   rt_PingCustomIP = RatioIni.GetBool( _T("IsPingCustomIP"), false, _T("General") );
		if (rt_CustomIP == 0)   rt_CustomIP = RatioIni.GetUInt64( _T("CustomIP"), 0, _T("General") );
		// Priority Limit
		if (rt_DLPrioLimit[RT_PR_VERYLOW] == 0)
			rt_DLPrioLimit[RT_PR_VERYLOW] = RatioIni.GetInt( _T("DLPriorityLimit_VeryLow"), 400, _T("Download") );
		if (rt_DLPrioLimit[RT_PR_LOW] == 0)
			rt_DLPrioLimit[RT_PR_LOW] = RatioIni.GetInt( _T("DLPriorityLimit_Low"), 200, _T("Download") );
		if (rt_DLPrioLimit[RT_PR_NORMAL] == 0)
			rt_DLPrioLimit[RT_PR_NORMAL] = RatioIni.GetInt( _T("DLPriorityLimit_Normal"), 100, _T("Download") );
		if (rt_DLPrioLimit[RT_PR_HIGH] == 0)
			rt_DLPrioLimit[RT_PR_HIGH] = RatioIni.GetInt( _T("DLPriorityLimit_High"), 50, _T("Download") );
		//
		if (rt_ULPrioLimit[RT_PR_VERYLOW] == 0)
			rt_ULPrioLimit[RT_PR_VERYLOW] = RatioIni.GetInt( _T("ULPriorityLimit_VeryLow"), 80, _T("Upload") );
		if (rt_ULPrioLimit[RT_PR_LOW] == 0)
			rt_ULPrioLimit[RT_PR_LOW] = RatioIni.GetInt( _T("ULPriorityLimit_Low"), 40, _T("Upload") );
		if (rt_ULPrioLimit[RT_PR_NORMAL] == 0)
			rt_ULPrioLimit[RT_PR_NORMAL] = RatioIni.GetInt( _T("ULPriorityLimit_Normal"), 20, _T("Upload") );
		if (rt_ULPrioLimit[RT_PR_HIGH] == 0)
			rt_ULPrioLimit[RT_PR_HIGH] = RatioIni.GetInt( _T("ULPriorityLimit_High"), 10, _T("Upload") );
		// Convert Old Format KnownFile to New Format
		RT_ConvertOldKnownFile();
		// Convert Official Credits File to RT Format
		RT_ClientsMet2RT();
		// Delete Old File
		const FileCount = 8;
		CString FilenameList[] = { _T("RatioPreferences.ini"), _T("RatioCategory.ini"), _T("RatioFakeFiles.ini"),
								_T("RatioHistory.ini"), _T("RatioKnownFile.ini"), _T("RatioStatistics.ini"),
								_T("RatioIP2Country.dat"), _T("") };
		CString OldFilename;
		// Config Dir
		for (int i = 0; i < FileCount; i++)
		{
			OldFilename.Format( _T("%s%s"), configdir, FilenameList[i] );
			_tremove(OldFilename);
		}
		// Backup Dir
		for (int i = 0; i < FileCount; i++)
		{
			OldFilename.Format( _T("%sBACKUP\\%s"), appdir, FilenameList[i] );
			_tremove(OldFilename);
		}
		// Backup2 Dir
		for (int i = 0; i < FileCount; i++)
		{
			OldFilename.Format( _T("%sBACKUP2\\%s"), appdir, FilenameList[i] );
			_tremove(OldFilename);
		}
		// Delete Old Ratio Ini File
		if (PathFileExists(Filename) == TRUE)   _tremove(Filename);
	}
}

// Save Ratio Setting
void CPreferences::RT_SaveSettings()
{
	CString Filename;
	Filename.Format( _T("%sRT_Preferences.ini"), configdir);
	CIni RatioIni(Filename);
	uint64 LastBackupTime = RatioIni.GetUInt64( _T("LastBackupTime"), 0, _T("Extended") );
	RatioAppendINI RatioINI;
	if (RatioINI.OpenFile(Filename, _T("w")) == true)
	{
		// General
		RatioINI.WriteSection( _T("General") );
		RatioINI.Write( _T("Version"), theApp.GetModVersion() );
		RatioINI.Write( _T("UserHash"), md4str(GetUserHash()) );
		RatioINI.Write( _T("LeecherCount"), rt_LeecherCount );
		RatioINI.Write( _T("UserNickforServer"), rt_UserNickforServer );
		RatioINI.Write( _T("RunHighPriority"), rt_RunHighPriority );
		RatioINI.Write( _T("BackupConfig"), rt_AutoBackupConfig );
		RatioINI.Write( _T("TableSortPlus"), rt_TableSortPlus );
		RatioINI.Write( _T("StatusExpand"), rt_StatusExpand );
		RatioINI.Write( _T("RecordUploadQueueWaitedTime"), rt_RecordUploadQueueWaitedTime );
		RatioINI.Write( _T("FlushBufferTimeLimit"), rt_FlushBufferTimeLimit );
		// Display
		RatioINI.WriteSection( _T("Display") );
		RatioINI.Write( _T("IsHashNick"), rt_HashNick );
		RatioINI.Write( _T("IsDisplayCountry"), rt_DisplayCountry );
		RatioINI.Write( _T("IsDisplayFlag"), rt_DisplayFlag );
		RatioINI.Write( _T("FontForAllWindows"), rt_FontForAllWindows );
		RatioINI.Write( _T("IsRatioColor"), rt_RatioColor );
		RatioINI.Write( _T("IsRatioStyleServer"), rt_RatioStyleServer );
		RatioINI.Write( _T("IsRatioStyleTransfer"), rt_RatioStyleTransfer );
		RatioINI.Write( _T("IsDownloadSortSeparateStop"), rt_DownloadSortSeparateStop );
		// Display--Color
		RatioINI.WriteSerial( _T("RatioColors"), rt_RatioColors, ARRSIZE(rt_RatioColors) );
		// Connection
		RatioINI.WriteSection( _T("Connection") );
		RatioINI.Write( _T("IsPingCustomIP"), rt_PingCustomIP );
		RatioINI.Write( _T("CustomIP"), rt_CustomIP );
		// Directory
		// Release
		RatioINI.WriteSection( _T("Release") );
		RatioINI.Write( _T("IsReleaseRarestOnly"), rt_ReleaseRarestOnly );
		RatioINI.Write( _T("MoreRarestPart"), rt_MoreRarestPart );
		RatioINI.Write( _T("IsAutoRelease"), rt_AutoRelease );
		RatioINI.Write( _T("AutoReleaseMin"), rt_AutoReleaseMin );
		RatioINI.Write( _T("AutoReleaseMax"), rt_AutoReleaseMax );
		// Upload
		RatioINI.WriteSection( _T("Upload") );
		RatioINI.Write( _T("FriendSlotAuto"), rt_FriendSlotAuto );
		RatioINI.Write( _T("MinUploadSlot"), rt_MinUploadSlot );
		RatioINI.Write( _T("MaxUploadSlot"), rt_MaxUploadSlot );
		RatioINI.Write( _T("IsKeepFriendSlot"), rt_KeepFriendSlot );
		RatioINI.Write( _T("IsSlotFocus"), rt_SlotFocus );
		RatioINI.Write( _T("MaxReleaseSlot"), rt_MaxReleaseSlot );
		RatioINI.Write( _T("MaxCredit1Slot"), rt_MaxCredit1Slot );
		RatioINI.Write( _T("UserHashFS"), md4str(rt_UserHashFS) );
		// Upload--Priority Limit
		RatioINI.WriteSerial( _T("ULPriorityLimit"), rt_ULPrioLimit, ARRSIZE(rt_ULPrioLimit) );
		// Download
		RatioINI.WriteSection( _T("Download") );
		RatioINI.Write( _T("PreCheckDiskspace"), rt_PreCheckDiskspace );
		RatioINI.Write( _T("AutoSwapA4AF"), rt_AutoSwapA4AF );
		RatioINI.Write( _T("MaxQR"), rt_MaxQR );
		RatioINI.Write( _T("IncludeStoppedFile"), rt_IncludeStoppedFile );
		RatioINI.Write( _T("StartNextFileBy"), rt_StartNextFileBy );
		// Download--Priority Limit
		RatioINI.WriteSerial( _T("DLPriorityLimit"), rt_DLPrioLimit, ARRSIZE(rt_DLPrioLimit) );
		// Log
		RatioINI.WriteSection( _T("Log") );
		RatioINI.Write( _T("LogRatioVerbose"), rt_LogRatioVerbose );
		RatioINI.Write( _T("LogNormalVerbose"), rt_LogNormalVerbose );
		// Column Settings
		RatioINI.WriteSection( _T("Column") );
		RatioINI.WriteSerial( _T("DownloadColumnWidths"), downloadColumnWidths, ARRSIZE(downloadColumnWidths) );
		RatioINI.WriteSerial( _T("DownloadColumnHidden"), downloadColumnHidden, ARRSIZE(downloadColumnHidden) );
		RatioINI.WriteSerial( _T("DownloadColumnOrder"), downloadColumnOrder, ARRSIZE(downloadColumnOrder) );
		RatioINI.WriteSerial( _T("UploadColumnWidths"), uploadColumnWidths, ARRSIZE(uploadColumnWidths) );
		RatioINI.WriteSerial( _T("UploadColumnHidden"), uploadColumnHidden, ARRSIZE(uploadColumnHidden) );
		RatioINI.WriteSerial( _T("UploadColumnOrder"), uploadColumnOrder, ARRSIZE(uploadColumnOrder) );
		RatioINI.WriteSerial( _T("SharedColumnWidths"), sharedColumnWidths, ARRSIZE(sharedColumnWidths) );
		RatioINI.WriteSerial( _T("SharedColumnHidden"), sharedColumnHidden, ARRSIZE(sharedColumnHidden) );
		RatioINI.WriteSerial( _T("SharedColumnOrder"), sharedColumnOrder, ARRSIZE(sharedColumnOrder) );
		RatioINI.WriteSerial( _T("QueueColumnWidths"), queueColumnWidths, ARRSIZE(queueColumnWidths) );
		RatioINI.WriteSerial( _T("QueueColumnHidden"), queueColumnHidden, ARRSIZE(queueColumnHidden) );
		RatioINI.WriteSerial( _T("QueueColumnOrder"), queueColumnOrder, ARRSIZE(queueColumnOrder) );
		RatioINI.WriteSerial( _T("ClientListColumnWidths"), clientListColumnWidths, ARRSIZE(clientListColumnWidths) );
		RatioINI.WriteSerial( _T("ClientListColumnHidden"), clientListColumnHidden, ARRSIZE(clientListColumnHidden) );
		RatioINI.WriteSerial( _T("ClientListColumnOrder"), clientListColumnOrder, ARRSIZE(clientListColumnOrder) );
		// Clear Normal Exit Flag
		RatioINI.WriteSection( _T("Extended") );
		RatioINI.Write( _T("IsNormalExit"), false );
		RatioINI.Write( _T("LastBackupTime"), LastBackupTime );
		//
		RatioINI.CloseFile();
	}
}

// Initial Ratio Setting
void CPreferences::RT_InitialSettings()
{
	// More than Rarest Part
	if (rt_MoreRarestPart < 0)
		rt_MoreRarestPart = 0;
	else if (rt_MoreRarestPart > 15)
		rt_MoreRarestPart = 15;
	// Max QR
	if (rt_MaxQR < 100)
		rt_MaxQR = 100;
	else if (rt_MaxQR > 10000)
		rt_MaxQR = 10000;
	// Leecher Count
	if (rt_LeecherCount < 3)
		rt_LeecherCount = 3;
	else if (rt_LeecherCount > 31)
		rt_LeecherCount = 31;
	// Auto Release Min
	if (rt_AutoReleaseMin < 1)
		rt_AutoReleaseMin = 1;
	else if (rt_AutoReleaseMin > 100)
		rt_AutoReleaseMin = 100;
	// Auto Release Max
	if (rt_AutoReleaseMax < 5)
		rt_AutoReleaseMax = 5;
	else if (rt_AutoReleaseMax > 100)
		rt_AutoReleaseMax = 100;
	// Min Upload Slot
	if ( rt_MinUploadSlot > uint8(maxGraphUploadRate / 3) )   rt_MinUploadSlot = uint8(maxGraphUploadRate / 3);
	if (rt_MinUploadSlot < 3)
		rt_MinUploadSlot = 3;
	else if (rt_MinUploadSlot > MAX_UP_CLIENTS_ALLOWED)
		rt_MinUploadSlot = MAX_UP_CLIENTS_ALLOWED;
	// Max Upload Slot
	if (rt_MaxUploadSlot < 3)
		rt_MaxUploadSlot = 3;
	else if (rt_MaxUploadSlot > MAX_UP_CLIENTS_ALLOWED)
		rt_MaxUploadSlot = MAX_UP_CLIENTS_ALLOWED;
	// Max Release Slot
	if (rt_MaxReleaseSlot < 0)
		rt_MaxReleaseSlot = 0;
	else if (rt_MaxReleaseSlot > MAX_UP_CLIENTS_ALLOWED)
		rt_MaxReleaseSlot = MAX_UP_CLIENTS_ALLOWED;
	// Max Credit1 Slot
	if (rt_MaxCredit1Slot < 0)
		rt_MaxCredit1Slot = 0;
	else if (rt_MaxCredit1Slot > MAX_UP_CLIENTS_ALLOWED)
		rt_MaxCredit1Slot = MAX_UP_CLIENTS_ALLOWED;
	//
	if (rt_MaxUploadSlot < rt_MinUploadSlot)   rt_MaxUploadSlot = rt_MinUploadSlot;
	if (rt_MaxReleaseSlot > rt_MaxUploadSlot)   rt_MaxReleaseSlot = rt_MaxUploadSlot;
	if (rt_MaxCredit1Slot > rt_MaxUploadSlot)   rt_MaxCredit1Slot = rt_MaxUploadSlot;
	// User Nick for Server
	if (rt_UserNickforServer.IsEmpty() == true)   rt_UserNickforServer.Format( _T("[CHN][eDtoon][Popgo][ARC][TLF][VeryCD][Cyndi][Dmhy][EastShare]") );
	// Upload Queue
	if ( (m_iQueueSize > 10000) && (m_iQueueSize != 10100) )
		m_iQueueSize = 10000;
	else if (m_iQueueSize < 2000)
		m_iQueueSize = 2000;
	// USS
    if (m_iDynUpPingTolerance < 200)   m_iDynUpPingTolerance = 200;
	if (m_iDynUpPingToleranceMilliseconds < 200)   m_iDynUpPingToleranceMilliseconds = 200;
	// Always Enable "Full Chunk Transfer"
	m_btransferfullchunks = true;
	// Always Enable "A4AF Save SPU"
	m_bA4AFSaveCpu = true;
	// Limit All Files or Uncategorized
	if (allcatType > 1)   allcatType = 0;
	// Flush Buffer Time Limit
	if (rt_FlushBufferTimeLimit < BUFFER_TIME_LIMIT)
		rt_FlushBufferTimeLimit = BUFFER_TIME_LIMIT;
	else if ( rt_FlushBufferTimeLimit > MIN2MS(15) )
		rt_FlushBufferTimeLimit = MIN2MS(15);
	// Download Priority Limit
	if (rt_DLPrioLimit[RT_PR_HIGH] == 0)   rt_DLPrioLimit[RT_PR_HIGH] = 50;
	if (rt_DLPrioLimit[RT_PR_NORMAL] == 0)   rt_DLPrioLimit[RT_PR_NORMAL] = 100;
	if (rt_DLPrioLimit[RT_PR_LOW] == 0)   rt_DLPrioLimit[RT_PR_LOW] = 200;
	if (rt_DLPrioLimit[RT_PR_VERYLOW] == 0)   rt_DLPrioLimit[RT_PR_VERYLOW] = 400;
	// Upload Priority Limit
	if (rt_ULPrioLimit[RT_PR_HIGH] == 0)   rt_ULPrioLimit[RT_PR_HIGH] = 10;
	if (rt_ULPrioLimit[RT_PR_NORMAL] == 0)   rt_ULPrioLimit[RT_PR_NORMAL] = 20;
	if (rt_ULPrioLimit[RT_PR_LOW] == 0)   rt_ULPrioLimit[RT_PR_LOW] = 40;
	if (rt_ULPrioLimit[RT_PR_VERYLOW] == 0)   rt_ULPrioLimit[RT_PR_VERYLOW] = 80;
	// Display Color--Download Bar
	if (rt_RatioColors[RT_CR_DB_MISS] == 0)   rt_RatioColors[RT_CR_DB_MISS] = RGB(255, 0, 0);
	if (rt_RatioColors[RT_CR_DB_HAVE] == 0)   rt_RatioColors[RT_CR_DB_HAVE] = RGB(0, 200, 0);
	if (rt_RatioColors[RT_CR_DB_PENDING] == 0)   rt_RatioColors[RT_CR_DB_PENDING] = RGB(230, 180, 0);
	if (rt_RatioColors[RT_CR_DB_PROGRESS] == 0)   rt_RatioColors[RT_CR_DB_PROGRESS] = RGB(0, 255, 0);
	// Display Color--Client Bar
	if (rt_RatioColors[RT_CR_CB_NEITHER] == 0)   rt_RatioColors[RT_CR_CB_NEITHER] = RGB(245, 245, 245);
	if (rt_RatioColors[RT_CR_CB_BOTH] == 0)   rt_RatioColors[RT_CR_CB_BOTH] = RGB(0, 0, 0);
	if (rt_RatioColors[RT_CR_CB_HAVE] == 0)   rt_RatioColors[RT_CR_CB_HAVE] = RGB(0, 200, 0);
	if (rt_RatioColors[RT_CR_CB_CLIENT] == 0)   rt_RatioColors[RT_CR_CB_CLIENT] = RGB(0, 0, 255);
	if (rt_RatioColors[RT_CR_CB_PENDING] == 0)   rt_RatioColors[RT_CR_CB_PENDING] = RGB(255, 208, 0);
	if (rt_RatioColors[RT_CR_CB_NEXT] == 0)   rt_RatioColors[RT_CR_CB_NEXT] = RGB(255, 255, 0);
	// Display Color--Uploaded Bar
	if (rt_RatioColors[RT_CR_UB_1TIME] == 0)   rt_RatioColors[RT_CR_UB_1TIME] = RGB(255, 0, 0);
	if (rt_RatioColors[RT_CR_UB_2TIME] == 0)   rt_RatioColors[RT_CR_UB_2TIME] = RGB(255, 200, 0);
	if (rt_RatioColors[RT_CR_UB_3TIME] == 0)   rt_RatioColors[RT_CR_UB_3TIME] = RGB(255, 255, 0);
	if (rt_RatioColors[RT_CR_UB_4TIME] == 0)   rt_RatioColors[RT_CR_UB_4TIME] = RGB(0, 230, 0);
	if (rt_RatioColors[RT_CR_UB_5TIME] == 0)   rt_RatioColors[RT_CR_UB_5TIME] = RGB(0, 0, 255);
	if (rt_RatioColors[RT_CR_UB_6TIME] == 0)   rt_RatioColors[RT_CR_UB_6TIME] = RGB(0, 245, 245);
	if (rt_RatioColors[RT_CR_UB_7TIME] == 0)   rt_RatioColors[RT_CR_UB_7TIME] = RGB(210, 210, 255);
	// Display Color--Download Text
	if (rt_RatioColors[RT_CR_DT_COMPLETED] == 0)   rt_RatioColors[RT_CR_DT_COMPLETED] = RGB(0, 200, 0);
	if (rt_RatioColors[RT_CR_DT_DOWNLOADING] == 0)   rt_RatioColors[RT_CR_DT_DOWNLOADING] = RGB(220, 160, 0);
	if (rt_RatioColors[RT_CR_DT_WAITING] == 0)   rt_RatioColors[RT_CR_DT_WAITING] = RGB(0, 0, 0);
	if (rt_RatioColors[RT_CR_DT_MISS] == 0)   rt_RatioColors[RT_CR_DT_MISS] = RGB(230, 0, 0);
	if (rt_RatioColors[RT_CR_DT_STOPPED] == 0)   rt_RatioColors[RT_CR_DT_STOPPED] = RGB(128, 128, 128);
	// Display Color--Share Text
	if (rt_RatioColors[RT_CR_ST_TRANSFERRED] == 0)   rt_RatioColors[RT_CR_ST_TRANSFERRED] = RGB(0, 200, 0);
	if (rt_RatioColors[RT_CR_ST_COMPLETED] == 0)   rt_RatioColors[RT_CR_ST_COMPLETED] = RGB(0, 0, 0);
	if (rt_RatioColors[RT_CR_ST_DOWNLOADING] == 0)   rt_RatioColors[RT_CR_ST_DOWNLOADING] = RGB(220, 160, 0);
	if (rt_RatioColors[RT_CR_ST_WAITING] == 0)   rt_RatioColors[RT_CR_ST_WAITING] = RGB(230, 0, 0);
	// Display Color--Client Text
	if (rt_RatioColors[RT_CR_CT_TRADE] == 0)   rt_RatioColors[RT_CR_CT_TRADE] = RGB(0, 200, 0);
	if (rt_RatioColors[RT_CR_CT_TRANSFER] == 0)   rt_RatioColors[RT_CR_CT_TRANSFER] = RGB(0, 0, 255);
	if (rt_RatioColors[RT_CR_CT_BAD] == 0)   rt_RatioColors[RT_CR_CT_BAD] = RGB(230, 0, 0);
}

// Set UserHash of Friend Slot
void CPreferences::SetUserHashFS(const uchar* NewUserHashFS)
{
	md4cpy(rt_UserHashFS, NewUserHashFS);
}

// Set UserHash of Friend Slot
void CPreferences::SetUserHashFS(const CString NewUserHashFS)
{
	if (NewUserHashFS.IsEmpty() == true)
	{
		md4clr(rt_UserHashFS);
		return;
	}
	strmd4(NewUserHashFS, rt_UserHashFS);
}

// Set UserHash of Friend Slot
bool CPreferences::IsCurrentFS(const uchar* UserHash)
{
	return (md4cmp(UserHash, rt_UserHashFS) == 0);
}

// Backup Config
void CPreferences::BackupConfig()
{
	CString RatioIniFileName;
	RatioIniFileName.Format( _T("%sRT_Preferences.ini"), configdir);
	if (PathFileExists(RatioIniFileName) == FALSE)   return;
	CIni RatioIni(RatioIniFileName, _T("General") );
	if (RatioIni.GetString( _T("Version"), _T(""), _T("General") ).IsEmpty() == true)   return;
	rt_AutoBackupConfig = RatioIni.GetBool( _T("BackupConfig"), true, _T("General") );
	if (rt_AutoBackupConfig == RT_ABC_DISABLE)   return;
	uint32 LastBackupTime = RatioIni.GetUInt64( _T("LastBackupTime"), 0, _T("Extended") );
	if ( (uint64(time(NULL)) - LastBackupTime) < 300 )   return;
	RatioIni.WriteUInt64( _T("LastBackupTime"), uint64(time(NULL)), _T("Extended") );
	rt_NormalExitLastTime = RatioIni.GetBool( _T("IsNormalExit"), true, _T("Extended") );
	if (rt_NormalExitLastTime == false)
	{
		AfxMessageBox( GetResString(RT_IDS_UNNORMAL_EXIT) );
		return;
	}
	// Create Config Backup Directory
	CString ConfigBackup = appdir + _T("BACKUP");
	if (PathFileExists(ConfigBackup) == FALSE)   ::CreateDirectory(ConfigBackup, 0);
	if (rt_AutoBackupConfig == RT_ABC_BACKUP2)
	{
		ConfigBackup = appdir + _T("BACKUP2");
		if (PathFileExists(ConfigBackup) == FALSE)   ::CreateDirectory(ConfigBackup, 0);
		MoveDirectory( (appdir + _T("BACKUP")), (appdir + _T("BACKUP2")), true, CopyOnlyFileList );
	}
	CopyDirectory( configdir, (appdir + _T("BACKUP")), true, false, IgnoreFileList );
}

// Table Sort Plus
bool CPreferences::GetTableSortPlus(uint16 Source)
{
	uint16 SourceTable = 1 << Source;
	return (rt_TableSortPlus & SourceTable);
}

// Table Sort Plus
void CPreferences::SetTableSortPlus(uint16 Target, bool Status)
{
	uint16 TargetTable = 1 << Target;
	if (Status == true)
		rt_TableSortPlus |= TargetTable;
	else
	{
		TargetTable ^= 0xFFFF;
		rt_TableSortPlus &= TargetTable;
	}
	CString RatioIniFileName;
	RatioIniFileName.Format( _T("%sRT_Preferences.ini"), configdir);
	CIni RatioIni(RatioIniFileName, _T("General") );
	// General
	RatioIni.WriteInt( _T("TableSortPlus"), rt_TableSortPlus, _T("General") );
}

// Transfer Bytes
void CPreferences::RT_AddStatistics(CUpDownClient* Client, bool IsDownloadData, uint32 Bytes)
{
	if (Bytes == 0)   return;
	// Add Transfer Bytes for MOD
	int ModNO = Client->GetModNO();
	if (ModNO < RT_MOD_COUNT)
	{
		if (IsDownloadData == true)
		{
			rt_SessionDownloadMod[ModNO] = (rt_SessionDownloadMod[ModNO] + Bytes);
			rt_CumulativeDownloadMod[ModNO] = (rt_CumulativeDownloadMod[ModNO] + Bytes);
		}
		else
		{
			rt_SessionUploadMod[ModNO] = (rt_SessionUploadMod[ModNO] + Bytes);
			rt_CumulativeUploadMod[ModNO] = (rt_CumulativeUploadMod[ModNO] + Bytes);
		}
	}
	else if (thePrefs.IsLogRatioVerbose() == true)
		AddDebugLogLine(false, _T(">> [RT Debug] Over Array Rang. [ModNO = %u]"), ModNO);
	// Add Transfer Bytes for Country
	int CountryNO = Client->GetFlagNO();
	if (CountryNO < RT_COUNTRY_COUNT)
	{
		if (IsDownloadData == true)
		{
			rt_SessionDownloadCountry[CountryNO] = (rt_SessionDownloadCountry[CountryNO] + Bytes);
			rt_CumulativeDownloadCountry[CountryNO] = (rt_CumulativeDownloadCountry[CountryNO] + Bytes);
		}
		else
		{
			rt_SessionUploadCountry[CountryNO] = (rt_SessionUploadCountry[CountryNO] + Bytes);
			rt_CumulativeUploadCountry[CountryNO] = (rt_CumulativeUploadCountry[CountryNO] + Bytes);
		}
	}
	else if (thePrefs.IsLogRatioVerbose() == true)
		AddDebugLogLine(false, _T(">> [RT Debug] Over Array Rang. [CountryNO = %u]"), CountryNO);
}

// Ratio Statistics
void CPreferences::RT_LoadStatistics()
{
	CString FileName;
	FileName.Format( _T("%sRT_Statistics.ini"), configdir);
	CIni RatioIni(FileName, _T("Transferred") );
	CString Buffer;

	// Mod
	for (int i = 0; i < RT_MOD_COUNT; i++)
	{
		rt_CumulativeUploadMod[i] = RatioIni.GetUInt64(ModList[i], 0, _T("ModCumulativeUpload") );
		rt_CumulativeDownloadMod[i] = RatioIni.GetUInt64(ModList[i], 0, _T("ModCumulativeDownload") );
	}
	// Country
	for (int i = 0; i < RT_COUNTRY_COUNT; i++)
	{
		Buffer.Format( _T("%s"), CountryList.Mid((i * 2), 2) );
		rt_CumulativeUploadCountry[i] = RatioIni.GetUInt64(Buffer, 0, _T("CountryCumulativeUpload") );
		rt_CumulativeDownloadCountry[i] = RatioIni.GetUInt64(Buffer, 0, _T("CountryCumulativeDownload") );
	}
}

// Ratio Statistics
void CPreferences::RT_SaveStatistics()
{
	CString Filename;
	Filename.Format( _T("%sRT_Statistics.ini"), configdir );
	RatioAppendINI RatioINI;
	if (RatioINI.OpenFile(Filename, _T("w")) == true)
	{
		int i;
		// General
		RatioINI.WriteSection( _T("General") );
		RatioINI.Write( _T("StatisticsVersion"), RT_STATISTICES_VERSION );
		// Mod Upload
		RatioINI.WriteSection( _T("ModCumulativeUpload") );
		for (i = 0; i < RT_MOD_COUNT; i++)
		{
			RatioINI.Write( ModList[i], rt_CumulativeUploadMod[i] );
		}
		// Mod Download
		RatioINI.WriteSection( _T("ModCumulativeDownload") );
		for (i = 0; i < RT_MOD_COUNT; i++)
		{
			RatioINI.Write( ModList[i], rt_CumulativeDownloadMod[i] );
		}
		// Country Upload
		RatioINI.WriteSection( _T("CountryCumulativeUpload") );
		for (i = 0; i < RT_COUNTRY_COUNT; i++)
		{
			RatioINI.Write( CountryList.Mid((i * 2), 2), rt_CumulativeUploadCountry[i] );
		}
		// Country Download
		RatioINI.WriteSection( _T("CountryCumulativeDownload") );
		for (i = 0; i < RT_COUNTRY_COUNT; i++)
		{
			RatioINI.Write( CountryList.Mid((i * 2), 2), rt_CumulativeDownloadCountry[i] );
		}
		//
		RatioINI.CloseFile();
	}
}

// Status Expand
bool CPreferences::IsStatusExpand(uint8 Pane)
{
	uint8 CurrentPane = 1 << Pane;
	return (rt_StatusExpand & CurrentPane);
}

// Status Expand
void CPreferences::SetStatusExpand(uint8 Pane, bool IsExpand)
{
	uint8 CurrentPane = 1 << Pane;
	if (IsExpand == true)
		rt_StatusExpand |= CurrentPane;
	else
	{
		CurrentPane ^= 0xFFFF;
		rt_StatusExpand &= CurrentPane;
	}
	CString RatioIniFileName;
	RatioIniFileName.Format( _T("%sRT_Preferences.ini"), configdir);
	CIni RatioIni(RatioIniFileName, _T("General") );
	// General
	RatioIni.WriteInt( _T("StatusExpand"), rt_StatusExpand, _T("General") );
}

// Category Temporary Directory
CString CPreferences::GetTempDir(int Category)
{
	if ( (Category < 0) || (Category >= rt_CategoryTempDir.GetCount()) )   return GetTempDir();
	CString Buffer;
	Buffer = rt_CategoryTempDir.GetAt(Category);
	if (Buffer.IsEmpty() == true)
		return GetTempDir();
	else
		return Buffer;
}

// Category Temporary Directory
void CPreferences::SetTempDir(int Category, CString Directory)
{
	if ( (Category < 0) || (Category >= rt_CategoryTempDir.GetCount()) )   return;
	rt_CategoryTempDir.SetAt(Category, Directory);
}

// Ratio Category
void CPreferences::RT_LoadCategory()
{
	CString Filename, Category, Buffer, TempDir;

	Filename.Format( _T("%sRT_Category.ini"), configdir);
	TempDir.Format( _T("%s"), GetTempDir() );

	if (PathFileExists(Filename) == FALSE)   return;

	bool IsNeedSave = false;
	CIni RatioIni(Filename, _T("General") );
	int CategoryCount = GetCatCount() - 1;
	for (int i = 0; i <= CategoryCount; i++)
	{
		Category.Format( _T("Cat#%u"), i);
		Buffer.Format( _T("%s"), RatioIni.GetString( _T("TempDir"), _T(""), Category) );
		if ( (catMap.GetAt(i)->title != RatioIni.GetString( _T("Title"), _T(""), Category)) || (PathFileExists(Buffer) == FALSE) )
		{
			IsNeedSave = true;
			Buffer = TempDir;
		}
		char DiskName = Buffer.GetAt(0);
		if ( (DiskName >= 'a') && (DiskName <= 'z') )
		{
			DiskName = (DiskName - ('a'-'A'));
			Buffer.SetAt( 0, TCHAR(DiskName) );
		}
		rt_CategoryTempDir.SetAt(i, Buffer);
		rt_CategoryViewFilter.SetAt( i, RatioIni.GetInt( _T("VewFilter"), 0, Category) );
	}
	if (IsNeedSave == true)   RT_SaveCategory();
}

// New Code for SavePreferences()
void CPreferences::SavePreferences()
{
	USES_CONVERSION;
	CString Filename, Buffer;
	Filename.Format( _T("%spreferences.ini"), configdir );
	CIni RatioIni(Filename);
	RatioAppendINI RatioINI;
	if (RatioINI.OpenFile(Filename, _T("w")) == false)   return;
	//---
	RatioINI.WriteSection( _T("eMule") );
	RatioINI.Write( _T("AppVersion"), CString(theApp.m_strCurVersionLong + _T("RT")) );
	//---

#ifdef _DEBUG
	RatioINI.Write( _T("DebugHeap"), m_iDbgHeap );
#endif

	RatioINI.Write( _T("Nick"), strNick );
	RatioINI.Write( _T("IncomingDir"), CString(incomingdir) );
	RatioINI.Write( _T("TempDir"), CString(tempdir) );

	// ZZ:UploadSpeedSense -->
    RatioINI.Write( _T("MinUpload"), minupload );
	// ZZ:UploadSpeedSense <--
	RatioINI.Write( _T("MaxUpload"), maxupload );
	RatioINI.Write( _T("MaxDownload"), maxdownload );
	RatioINI.Write( _T("MaxConnections"), maxconnections );
	RatioINI.Write( _T("MaxHalfConnections"), maxhalfconnections);
	RatioINI.Write( _T("Port"), port );
	RatioINI.Write( _T("UDPPort"), udpport );
	RatioINI.Write( _T("ServerUDPPort"), nServerUDPPort );
	RatioINI.Write( _T("MaxSourcesPerFile"), maxsourceperfile );
	RatioINI.Write( _T("Language"), m_wLanguageID );
	RatioINI.Write( _T("SeeShare"), uint32(m_iSeeShares) );
	RatioINI.Write( _T("ToolTipDelay"), m_iToolDelayTime );
	RatioINI.Write( _T("StatGraphsInterval"), trafficOMeterInterval );
	RatioINI.Write( _T("StatsInterval"), statsInterval );
	RatioINI.Write( _T("DownloadCapacity"), maxGraphDownloadRate );
	RatioINI.Write( _T("UploadCapacity"), maxGraphUploadRate );
	RatioINI.Write( _T("DeadServerRetry"), deadserverretries );
	RatioINI.Write( _T("ServerKeepAliveTimeout"), m_dwServerKeepAliveTimeout );
	RatioINI.Write( _T("SplitterbarPosition"), splitterbarPosition+2 );
	RatioINI.Write( _T("SplitterbarPositionStat"), splitterbarPositionStat+1 );
	RatioINI.Write( _T("SplitterbarPositionStat_HL"), splitterbarPositionStat_HL+1 );
	RatioINI.Write( _T("SplitterbarPositionStat_HR"), splitterbarPositionStat_HR+1 );
	RatioINI.Write( _T("SplitterbarPositionFriend"), splitterbarPositionFriend );
	RatioINI.Write( _T("SplitterbarPositionIRC"), splitterbarPositionIRC+2 );
	RatioINI.Write( _T("TransferWnd2"), m_uTransferWnd2 );
	RatioINI.Write( _T("VariousStatisticsMaxValue"), statsMax );
	RatioINI.Write( _T("StatsAverageMinutes"), statsAverageMinutes );
	RatioINI.Write( _T("MaxConnectionsPerFiveSeconds"), MaxConperFive );
	RatioINI.Write( _T("Check4NewVersionDelay"), versioncheckdays );

	RatioINI.Write( _T("Reconnect"), reconnect );
	RatioINI.Write( _T("Scoresystem"), scorsystem );
	RatioINI.Write( _T("Serverlist"), autoserverlist );
	RatioINI.Write( _T("UpdateNotifyTestClient"), updatenotify );
	RatioINI.Write( _T("MinToTray"), mintotray );
	RatioINI.Write( _T("AddServersFromServer"), addserversfromserver );
	RatioINI.Write( _T("AddServersFromClient"), addserversfromclient );
	RatioINI.Write( _T("Splashscreen"), splashscreen );
	RatioINI.Write( _T("BringToFront"), bringtoforeground );
	RatioINI.Write( _T("TransferDoubleClick"), transferDoubleclick );
	RatioINI.Write( _T("BeepOnError"), beepOnError );
	RatioINI.Write( _T("ConfirmExit"), confirmExit );
	RatioINI.Write( _T("FilterBadIPs"), filterLANIPs );
    RatioINI.Write( _T("Autoconnect"), autoconnect );
	RatioINI.Write( _T("OnlineSignature"), onlineSig );
	RatioINI.Write( _T("StartupMinimized"), startMinimized );
	RatioINI.Write( _T("AutoStart"), m_bAutoStart );
	RatioINI.Write( _T("LastMainWndDlgID"), m_iLastMainWndDlgID );
	RatioINI.Write( _T("LastLogPaneID"), m_iLastLogPaneID );
	RatioINI.Write( _T("SafeServerConnect"), safeServerConnect );
	RatioINI.Write( _T("ShowRatesOnTitle"), showRatesInTitle );
	RatioINI.Write( _T("IndicateRatings"), indicateratings );
	RatioINI.Write( _T("WatchClipboard4ED2kFilelinks"), watchclipboard );
	RatioINI.Write( _T("SearchMethod"), m_iSearchMethod );
	RatioINI.Write( _T("CheckDiskspace"), checkDiskspace );	// SLUGFILLER: checkDiskspace
	RatioINI.Write( _T("MinFreeDiskSpace"), m_uMinFreeDiskSpace );
	// itsonlyme: hostnameSource
	RatioINI.Write( _T("YourHostname"), CString(yourHostname) );
	// itsonlyme: hostnameSource

	// Barry - New properties...
    RatioINI.Write( _T("AutoConnectStaticOnly"), autoconnectstaticonly );  
	RatioINI.Write( _T("AutoTakeED2KLinks"), autotakeed2klinks );  
    RatioINI.Write( _T("AddNewFilesPaused"), addnewfilespaused );  
    RatioINI.Write( _T("3DDepth"), depth3D );  

	RatioINI.Write( _T("NotifyOnDownload"), useDownloadNotifier ); // Added by enkeyDEV
	RatioINI.Write( _T("NotifyOnNewDownload"), useNewDownloadNotifier );
	RatioINI.Write( _T("NotifyOnChat"), useChatNotifier );		  
	RatioINI.Write( _T("NotifyOnLog"), useLogNotifier );
	RatioINI.Write( _T("NotifierUseSound"), useSoundInNotifier );
	RatioINI.Write( _T("NotifierPopEveryChatMessage"), notifierPopsEveryChatMsg );
	RatioINI.Write( _T("NotifierPopNewVersion"), notifierNewVersion );
	RatioINI.Write( _T("NotifyOnImportantError"), notifierImportantError );
	RatioINI.Write( _T("NotifierSoundPath"), CString(notifierSoundFilePath) );
	RatioINI.Write( _T("NotifierConfiguration"), CString(notifierConfiguration) );

	RatioINI.Write( _T("TxtEditor"), CString(TxtEditor) );
	RatioINI.Write( _T("VideoPlayer"), CString(VideoPlayer) );
	RatioINI.Write( _T("MessageFilter"), CString(messageFilter) );
	RatioINI.Write( _T("CommentFilter"), CString(commentFilter) );
	RatioINI.Write( _T("DateTimeFormat"), GetDateTimeFormat() );
	RatioINI.Write( _T("DateTimeFormat4Log"), GetDateTimeFormat4Log() );
	RatioINI.Write( _T("WebTemplateFile"), CString(m_sTemplateFile) );
	RatioINI.Write( _T("FilenameCleanups"), CString(filenameCleanups) );
	RatioINI.Write( _T("ExtractMetaData"), m_iExtractMetaData );

	RatioINI.Write( _T("DefaultIRCServerNew"), CString(m_sircserver) );
	RatioINI.Write( _T("IRCNick"), CString(m_sircnick) );
	RatioINI.Write( _T("IRCAddTimestamp"), m_bircaddtimestamp );
	RatioINI.Write( _T("IRCFilterName"), CString(m_sircchannamefilter) );
	RatioINI.Write( _T("IRCFilterUser"), m_iircchanneluserfilter );
	RatioINI.Write( _T("IRCUseFilter"), m_bircusechanfilter );
	RatioINI.Write( _T("IRCPerformString"), CString(m_sircperformstring) );
	RatioINI.Write( _T("IRCUsePerform"), m_bircuseperform );
	RatioINI.Write( _T("IRCListOnConnect"), m_birclistonconnect );
	RatioINI.Write( _T("IRCAcceptLink"), m_bircacceptlinks );
	RatioINI.Write( _T("IRCAcceptLinkFriends"), m_bircacceptlinksfriends );
	RatioINI.Write( _T("IRCSoundEvents"), m_bircsoundevents );
	RatioINI.Write( _T("IRCIgnoreMiscMessages"), m_bircignoremiscmessage );
	RatioINI.Write( _T("IRCIgnoreJoinMessages"), m_bircignorejoinmessage );
	RatioINI.Write( _T("IRCIgnorePartMessages"), m_bircignorepartmessage );
	RatioINI.Write( _T("IRCIgnoreQuitMessages"), m_bircignorequitmessage );
	RatioINI.Write( _T("IRCIgnoreEmuleProtoAddFriend"), m_bircignoreemuleprotoaddfriend );
	RatioINI.Write( _T("IRCAllowEmuleProtoAddFriend"), m_bircallowemuleprotoaddfriend );
	RatioINI.Write( _T("IRCIgnoreEmuleProtoSendLink"), m_bircignoreemuleprotosendlink );
	RatioINI.Write( _T("IRCHelpChannel"), m_birchelpchannel );
	RatioINI.Write( _T("SmartIdCheck"), smartidcheck );
	RatioINI.Write( _T("Verbose"), m_bVerbose );
	RatioINI.Write( _T("DebugSourceExchange"), m_bDebugSourceExchange );	// do *not* use the according 'Get...' function here!
	RatioINI.Write( _T("LogBannedClients"), m_bLogBannedClients );			// do *not* use the according 'Get...' function here!
	RatioINI.Write( _T("LogRatingDescReceived"), m_bLogRatingDescReceived );// do *not* use the according 'Get...' function here!
	RatioINI.Write( _T("LogSecureIdent"), m_bLogSecureIdent );				// do *not* use the according 'Get...' function here!
	RatioINI.Write( _T("LogFilteredIPs"), m_bLogFilteredIPs );				// do *not* use the according 'Get...' function here!
	RatioINI.Write( _T("LogFileSaving"), m_bLogFileSaving );				// do *not* use the according 'Get...' function here!
    RatioINI.Write( _T("LogA4AF"), m_bLogA4AF );                           // do *not* use the according 'Get...' function here!
	RatioINI.Write( _T("LogUlDlEvents"), m_bLogUlDlEvents );
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	// following options are for debugging or when using an external debug device viewer only.
	RatioINI.Write( _T("DebugServerTCP"), m_iDebugServerTCPLevel );
	RatioINI.Write( _T("DebugServerUDP"), m_iDebugServerUDPLevel );
	RatioINI.Write( _T("DebugServerSources"), m_iDebugServerSourcesLevel );
	RatioINI.Write( _T("DebugServerSearches"), m_iDebugServerSearchesLevel );
	RatioINI.Write( _T("DebugClientTCP"), m_iDebugClientTCPLevel );
	RatioINI.Write( _T("DebugClientUDP"), m_iDebugClientUDPLevel );
	RatioINI.Write( _T("DebugClientKadUDP"), m_iDebugClientKadUDPLevel );
#endif
	RatioINI.Write( _T("PreviewPrio"), m_bpreviewprio );
	RatioINI.Write( _T("UpdateQueueListPref"), m_bupdatequeuelist );
	RatioINI.Write( _T("ManualHighPrio"), m_bmanualhighprio );
	RatioINI.Write( _T("FullChunkTransfers"), m_btransferfullchunks );
	RatioINI.Write( _T("ShowOverhead"), m_bshowoverhead );
	RatioINI.Write( _T("VideoPreviewBackupped"), moviePreviewBackup );
	RatioINI.Write( _T("PreviewSmallBlocks"), m_iPreviewSmallBlocks );
	RatioINI.Write( _T("StartNextFile"), m_istartnextfile );

//	ini.DeleteKey(_T("FileBufferSizePref") ); // delete old 'file buff size' setting
	RatioINI.Write( _T("FileBufferSize"), m_iFileBufferSize );

//	ini.DeleteKey(_T("QueueSizePref") ); // delete old 'queue size' setting
	RatioINI.Write( _T("QueueSize"), m_iQueueSize );

	RatioINI.Write( _T("CommitFiles"), m_iCommitFiles );
	RatioINI.Write( _T("DAPPref"), m_bDAP );
	RatioINI.Write( _T("UAPPref"), m_bUAP );
	RatioINI.Write( _T("AllcatType"), allcatType );
	RatioINI.Write( _T("FilterServersByIP"), filterserverbyip );
	RatioINI.Write( _T("DisableKnownClientList"), m_bDisableKnownClientList );
	RatioINI.Write( _T("DisableQueueList"), m_bDisableQueueList );
	RatioINI.Write( _T("UseCreditSystem"), m_bCreditSystem );
	RatioINI.Write( _T("SaveLogToDisk"), log2disk );
	RatioINI.Write( _T("SaveDebugToDisk"), debug2disk );
	RatioINI.Write( _T("EnableScheduler"), scheduler );
	RatioINI.Write( _T("MessagesFromFriendsOnly"), msgonlyfriends );
	RatioINI.Write( _T("MessageFromValidSourcesOnly"), msgsecure );
	RatioINI.Write( _T("ShowInfoOnCatTabs"), showCatTabInfos );
	RatioINI.Write( _T("DontRecreateStatGraphsOnResize"), dontRecreateGraphs );
	RatioINI.Write( _T("AutoFilenameCleanup"), autofilenamecleanup );
	RatioINI.Write( _T("ShowExtControls"), m_bExtControls );
	RatioINI.Write( _T("UseAutocompletion"), m_bUseAutocompl );
	RatioINI.Write( _T("NetworkKademlia"), networkkademlia );
	RatioINI.Write( _T("NetworkED2K"), networked2k );
	RatioINI.Write( _T("AutoClearCompleted"), m_bRemoveFinishedDownloads );
	RatioINI.Write( _T("TransflstRemainOrder"), m_bTransflstRemain );

	RatioINI.Write( _T("UseSimpleTimeRemainingcomputation"), m_bUseOldTimeRemaining );
	RatioINI.Write( _T("VersionCheckLastAutomatic"), versioncheckLastAutomatic );
	RatioINI.Write( _T("FilterLevel"), filterlevel );

	RatioINI.Write( _T("SecureIdent"), m_bUseSecureIdent );// change the name in future version to enable it by default
	RatioINI.Write( _T("AdvancedSpamFilter"), m_bAdvancedSpamfilter );
	RatioINI.Write( _T("ShowDwlPercentage"), m_bShowDwlPercentage );
	RatioINI.Write( _T("RemoveFilesToBin"), m_bRemove2bin );

	// Toolbar
	RatioINI.Write( _T("ToolbarSetting"), CString(m_sToolbarSettings) );
	RatioINI.Write( _T("ToolbarBitmap"), CString(m_sToolbarBitmap)  );
	RatioINI.Write( _T("ToolbarBitmapFolder"), CString(m_sToolbarBitmapFolder) );
	RatioINI.Write( _T("ToolbarLabels"), m_nToolbarLabels );
	RatioINI.Write( _T("SkinProfile"), CString(m_szSkinProfile) );
	RatioINI.Write( _T("SkinProfileDir"), CString(m_szSkinProfileDir) );

	//
	RatioINI.WriteSerial( _T("SearchColumnWidths"), searchColumnWidths, ARRSIZE(searchColumnWidths) );
	RatioINI.WriteSerial( _T("SearchColumnHidden"), searchColumnHidden, ARRSIZE(searchColumnHidden) );
	RatioINI.WriteSerial( _T("SearchColumnOrder"), searchColumnOrder, ARRSIZE(searchColumnOrder) );
	RatioINI.WriteSerial( _T("ServerColumnWidths"), serverColumnWidths, ARRSIZE(serverColumnWidths) );
	RatioINI.WriteSerial( _T("ServerColumnHidden"), serverColumnHidden, ARRSIZE(serverColumnHidden) );
	RatioINI.WriteSerial( _T("ServerColumnOrder"), serverColumnOrder, ARRSIZE(serverColumnOrder) );
	RatioINI.WriteSerial( _T("FilenamesListColumnWidths"), FilenamesListColumnWidths, ARRSIZE(FilenamesListColumnWidths) );
	RatioINI.WriteSerial( _T("FilenamesListColumnHidden"), FilenamesListColumnHidden, ARRSIZE(FilenamesListColumnHidden) );
	RatioINI.WriteSerial( _T("FilenamesListColumnOrder"), FilenamesListColumnOrder, ARRSIZE(FilenamesListColumnOrder) );

	// Barry - Provide a mechanism for all tables to store/retrieve sort order
	RatioINI.Write( _T("TableSortItemDownload"), tableSortItemDownload );
	RatioINI.Write( _T("TableSortItemUpload"), tableSortItemUpload );
	RatioINI.Write( _T("TableSortItemQueue"), tableSortItemQueue );
	RatioINI.Write( _T("TableSortItemSearch"), tableSortItemSearch );
	RatioINI.Write( _T("TableSortItemShared"), tableSortItemShared );
	RatioINI.Write( _T("TableSortItemServer"), tableSortItemServer );
	RatioINI.Write( _T("TableSortItemClientList"), tableSortItemClientList );
	RatioINI.Write( _T("TableSortItemFilenames"), tableSortItemFilenames );
	RatioINI.Write( _T("TableSortAscendingDownload"), tableSortAscendingDownload );
	RatioINI.Write( _T("TableSortAscendingUpload"), tableSortAscendingUpload );
	RatioINI.Write( _T("TableSortAscendingQueue"), tableSortAscendingQueue );
	RatioINI.Write( _T("TableSortAscendingSearch"), tableSortAscendingSearch );
	RatioINI.Write( _T("TableSortAscendingShared"), tableSortAscendingShared );
	RatioINI.Write( _T("TableSortAscendingServer"), tableSortAscendingServer );
	RatioINI.Write( _T("TableSortAscendingClientList"), tableSortAscendingClientList );
	RatioINI.Write( _T("TableSortAscendingFilenames"), tableSortAscendingFilenames );
	RatioINI.WriteFont( _T("HyperTextFont"), (LPBYTE)&m_lfHyperText, sizeof(m_lfHyperText) );
	RatioINI.WriteFont( _T("LogTextFont"), (LPBYTE)&m_lfLogText, sizeof(m_lfLogText) );

	// ZZ:UploadSpeedSense -->
    RatioINI.Write( _T("USSEnabled"), m_bDynUpEnabled );
    RatioINI.Write( _T("USSUseMillisecondPingTolerance"), m_bDynUpUseMillisecondPingTolerance );
    RatioINI.Write( _T("USSPingTolerance"), m_iDynUpPingTolerance );
	RatioINI.Write( _T("USSPingToleranceMilliseconds"), m_iDynUpPingToleranceMilliseconds ); // EastShare - Add by TAHO, USS limit
    RatioINI.Write( _T("USSGoingUpDivider"), m_iDynUpGoingUpDivider );
    RatioINI.Write( _T("USSGoingDownDivider"), m_iDynUpGoingDownDivider );
    RatioINI.Write( _T("USSNumberOfPings"), m_iDynUpNumberOfPings );
	// ZZ:UploadSpeedSense <--

    RatioINI.Write( _T("A4AFSaveCpu"), m_bA4AFSaveCpu ); // ZZ:DownloadManager
	RatioINI.Write( _T("WebMirrorAlertLevel"), m_nWebMirrorAlertLevel );
	RatioINI.Write( _T("RunAsUnprivilegedUser"), m_bRunAsUser );
	RatioINI.Write( _T("OpenPortsOnStartUp"), m_bOpenPortsOnStartUp );
	RatioINI.Write( _T("DebugLogLevel"), m_byLogLevel );


	///////////////////////////////////////////////////////////////////////////
	// Section: "Proxy"
	//
	RatioINI.WriteSection( _T("Proxy") );
	RatioINI.Write( _T("ProxyEnablePassword"), proxy.EnablePassword );
	RatioINI.Write( _T("ProxyEnableProxy"), proxy.UseProxy );
	RatioINI.Write( _T("ProxyName"), CString(proxy.name) );
	RatioINI.Write( _T("ProxyPassword"), CString(A2CT(proxy.password)) );
	RatioINI.Write( _T("ProxyUser"), CString(A2CT(proxy.user)) );
	RatioINI.Write( _T("ProxyPort"), proxy.port );
	RatioINI.Write( _T("ProxyType"), proxy.type );
	RatioINI.Write( _T("ConnectWithoutProxy"), m_bIsASCWOP );
	RatioINI.Write( _T("ShowErrors"), m_bShowProxyErrors );


	///////////////////////////////////////////////////////////////////////////
	// Section: "Statistics"
	//
	RatioINI.WriteSection( _T("Statistics") );
	RatioINI.Write( _T("statsConnectionsGraphRatio"), statsConnectionsGraphRatio );
	RatioINI.Write( _T("statsExpandedTreeItems"), CString(statsExpandedTreeItems) );
	for (int i = 0; i < 15 ;i++)
	{
		Buffer.Format( _T("StatColor%i=0x%06x\n"), i, GetStatsColor(i) );
		RatioINI.Write( Buffer );
	}


	///////////////////////////////////////////////////////////////////////////
	// Section: "WebServer"
	//
	RatioINI.WriteSection( _T("WebServer") );
	RatioINI.Write( _T("Password"), GetWSPass() );
	RatioINI.Write( _T("PasswordLow"), GetWSLowPass() );
	RatioINI.Write( _T("Port"), m_nWebPort );
	RatioINI.Write( _T("Enabled"), m_bWebEnabled );
	RatioINI.Write( _T("UseGzip"), m_bWebUseGzip );
	RatioINI.Write( _T("PageRefreshTime"), m_nWebPageRefresh );
	RatioINI.Write( _T("UseLowRightsUser"), m_bWebLowEnabled );


	///////////////////////////////////////////////////////////////////////////
	// Section: "MobileMule"
	//
	RatioINI.WriteSection( _T("MobileMule") );
	RatioINI.Write( _T("Password"), GetMMPass() );
	RatioINI.Write( _T("Enabled"), m_bMMEnabled );
	RatioINI.Write( _T("Port"), m_nMMPort );


	///////////////////////////////////////////////////////////////////////////
	// Section: "PeerCache"
	//
	RatioINI.WriteSection( _T("PeerCache") );
	RatioINI.Write( _T("LastSearch"), m_uPeerCacheLastSearch );
	RatioINI.Write( _T("Found"), m_bPeerCacheWasFound );
	RatioINI.Write( _T("Enabled"), m_bPeerCacheEnabled );
	RatioINI.Write( _T("PCPort"), m_nPeerCachePort );
}

// New Code for SaveCats()
void CPreferences::SaveCats()
{
	//
	RT_SaveCategory();
	// Cats
	CString Filename;
	Filename.Format( _T("%sCategory.ini"), configdir );
	RatioAppendINI RatioINI;
	if (RatioINI.OpenFile(Filename, _T("w")) == true)
	{
		if (GetCatCount() > 1)
		{
			CString Buffer;
			// General
			RatioINI.Write( _T("[General]\n") );
			RatioINI.Write( _T("Count"), (catMap.GetCount() - 1) );
			// Category
			for (int i = 1; i < catMap.GetCount(); i++)
			{
				Buffer.Format( _T("[Cat#%u]\n"), i);
				RatioINI.Write(Buffer);
				RatioINI.Write( _T("Title"), CString(catMap.GetAt(i)->title) );
				RatioINI.Write( _T("Incoming"), CString(catMap.GetAt(i)->incomingpath) );
				RatioINI.Write( _T("Comment"), CString(catMap.GetAt(i)->comment) );
				RatioINI.Write( _T("Color"), catMap.GetAt(i)->color );
				RatioINI.Write( _T("a4afPriority"), catMap.GetAt(i)->prio ); // ZZ:DownloadManager
				RatioINI.Write( _T("AutoCat"), catMap.GetAt(i)->autocat );
				RatioINI.Write( _T("downloadInAlphabeticalOrder"), catMap.GetAt(i)->downloadInAlphabeticalOrder ); // ZZ:DownloadManager
			}
		}
		RatioINI.CloseFile();
	}
}

// New Code for SaveStats()
void CPreferences::SaveStats(int bBackUp)
{
	// This function saves all of the new statistics in my addon.  It is also used to
	// save backups for the Reset Stats function, and the Restore Stats function (Which is actually LoadStats)
	// bBackUp = 0: DEFAULT; save to statistics.ini
	// bBackUp = 1: Save to statbkup.ini, which is used to restore after a reset
	// bBackUp = 2: Save to statbkuptmp.ini, which is temporarily created during a restore and then renamed to statbkup.ini

	CString Filename(configdir);
	if (bBackUp == 1)
		Filename += _T("statbkup.ini");
	else if (bBackUp == 2)
		Filename += _T("statbkuptmp.ini");
	else
		Filename += _T("statistics.ini");
	
	RatioAppendINI RatioINI;
	if (RatioINI.OpenFile(Filename, _T("w")) == true)
	{
		CString Buffer;
		// General
		RatioINI.WriteSection( _T("Statistics") );
	    // Save Cum Down Data
		RatioINI.Write( _T("TotalDownloadedBytes"), (theStats.sessionReceivedBytes + GetTotalDownloaded()) );

		RatioINI.Write( _T("DownSuccessfulSessions"), cumDownSuccessfulSessions );
		RatioINI.Write( _T("DownFailedSessions"), cumDownFailedSessions );
		RatioINI.Write( _T("DownAvgTime"), ((GetDownC_AvgTime() + GetDownS_AvgTime()) / 2) );
		RatioINI.Write( _T("LostFromCorruption"), (cumLostFromCorruption + sesLostFromCorruption) );
		RatioINI.Write( _T("SavedFromCompression"), (sesSavedFromCompression + cumSavedFromCompression) );
		RatioINI.Write( _T("PartsSavedByICH"), (cumPartsSavedByICH + sesPartsSavedByICH) );
		// Client
		RatioINI.Write( _T("DownData_EDONKEY"), GetCumDownData_EDONKEY() );
		RatioINI.Write( _T("DownData_EDONKEYHYBRID"), GetCumDownData_EDONKEYHYBRID() );
		RatioINI.Write( _T("DownData_EMULE"), GetCumDownData_EMULE() );
		RatioINI.Write( _T("DownData_MLDONKEY"), GetCumDownData_MLDONKEY() );
		RatioINI.Write( _T("DownData_LMULE"), GetCumDownData_EMULECOMPAT() );
		RatioINI.Write( _T("DownData_AMULE"), GetCumDownData_AMULE() );
		RatioINI.Write( _T("DownData_SHAREAZA"), GetCumDownData_SHAREAZA() );
		RatioINI.Write( _T("DownData_URL"), GetCumDownData_URL() );
		RatioINI.Write( _T("DownDataPort_4662"), GetCumDownDataPort_4662() );
		RatioINI.Write( _T("DownDataPort_OTHER"), GetCumDownDataPort_OTHER() );
		// Overhead
		RatioINI.Write( _T("DownOverheadTotal"), (theStats.GetDownDataOverheadFileRequest() +
													theStats.GetDownDataOverheadSourceExchange() +
													theStats.GetDownDataOverheadServer() +
													theStats.GetDownDataOverheadKad() +
													theStats.GetDownDataOverheadOther() +
													GetDownOverheadTotal())  );
		RatioINI.Write( _T("DownOverheadFileReq"), theStats.GetDownDataOverheadFileRequest() + GetDownOverheadFileReq() );
		RatioINI.Write( _T("DownOverheadSrcEx"), theStats.GetDownDataOverheadSourceExchange() + GetDownOverheadSrcEx() );
		RatioINI.Write( _T("DownOverheadServer"), theStats.GetDownDataOverheadServer() + GetDownOverheadServer() );
		RatioINI.Write( _T("DownOverheadKad"), theStats.GetDownDataOverheadKad() + GetDownOverheadKad() );
		RatioINI.Write( _T("DownOverheadTotalPackets"), (theStats.GetDownDataOverheadFileRequestPackets() + 
															theStats.GetDownDataOverheadSourceExchangePackets() + 
															theStats.GetDownDataOverheadServerPackets() + 
															theStats.GetDownDataOverheadKadPackets() + 
															theStats.GetDownDataOverheadOtherPackets() + 
															GetDownOverheadTotalPackets()) );
		RatioINI.Write( _T("DownOverheadFileReqPackets"), theStats.GetDownDataOverheadFileRequestPackets() + GetDownOverheadFileReqPackets() );
		RatioINI.Write( _T("DownOverheadSrcExPackets"), theStats.GetDownDataOverheadSourceExchangePackets() + GetDownOverheadSrcExPackets() );
		RatioINI.Write( _T("DownOverheadServerPackets"), theStats.GetDownDataOverheadServerPackets() + GetDownOverheadServerPackets() );
		RatioINI.Write( _T("DownOverheadKadPackets"), theStats.GetDownDataOverheadKadPackets() + GetDownOverheadKadPackets() );
		// Save Cumulative Upline Statistics
		RatioINI.Write( _T("TotalUploadedBytes"), theStats.sessionSentBytes + GetTotalUploaded() );
		RatioINI.Write( _T("UpSuccessfulSessions"), theApp.uploadqueue->GetSuccessfullUpCount() + GetUpSuccessfulSessions() );
		RatioINI.Write( _T("UpFailedSessions"), theApp.uploadqueue->GetFailedUpCount() + GetUpFailedSessions() );
		RatioINI.Write( _T("UpAvgTime"), ((theApp.uploadqueue->GetAverageUpTime() + GetUpAvgTime()) / 2) );
		// Client
		RatioINI.Write( _T("UpData_EDONKEY"), GetCumUpData_EDONKEY() );
		RatioINI.Write( _T("UpData_EDONKEYHYBRID"), GetCumUpData_EDONKEYHYBRID() );
		RatioINI.Write( _T("UpData_EMULE"), GetCumUpData_EMULE() );
		RatioINI.Write( _T("UpData_MLDONKEY"), GetCumUpData_MLDONKEY() );
		RatioINI.Write( _T("UpData_LMULE"), GetCumUpData_EMULECOMPAT() );
		RatioINI.Write( _T("UpData_AMULE"), GetCumUpData_AMULE() );
		RatioINI.Write( _T("UpData_SHAREAZA"), GetCumUpData_SHAREAZA() );
		RatioINI.Write( _T("UpDataPort_4662"), GetCumUpDataPort_4662() );
		RatioINI.Write( _T("UpDataPort_OTHER"), GetCumUpDataPort_OTHER() );
		RatioINI.Write( _T("UpData_File"), GetCumUpData_File() );
		RatioINI.Write( _T("UpData_Partfile"), GetCumUpData_Partfile() );
		// Overhead
		RatioINI.Write( _T("UpOverheadTotal"), (theStats.GetUpDataOverheadFileRequest() + 
												theStats.GetUpDataOverheadSourceExchange() + 
												theStats.GetUpDataOverheadServer() + 
												theStats.GetUpDataOverheadKad() + 
												theStats.GetUpDataOverheadOther() + 
												GetUpOverheadTotal()) );
		RatioINI.Write( _T("UpOverheadFileReq"), theStats.GetUpDataOverheadFileRequest() + GetUpOverheadFileReq() );
		RatioINI.Write( _T("UpOverheadSrcEx"), theStats.GetUpDataOverheadSourceExchange() + GetUpOverheadSrcEx() );
		RatioINI.Write( _T("UpOverheadServer"), theStats.GetUpDataOverheadServer() + GetUpOverheadServer() );
		RatioINI.Write( _T("UpOverheadKad"), theStats.GetUpDataOverheadKad() + GetUpOverheadKad() );
		RatioINI.Write( _T("UpOverheadTotalPackets"), (theStats.GetUpDataOverheadFileRequestPackets() + 
														theStats.GetUpDataOverheadSourceExchangePackets() + 
														theStats.GetUpDataOverheadServerPackets() + 
														theStats.GetUpDataOverheadKadPackets() + 
														theStats.GetUpDataOverheadOtherPackets() + 
														GetUpOverheadTotalPackets()) );
		RatioINI.Write( _T("UpOverheadFileReqPackets"), theStats.GetUpDataOverheadFileRequestPackets() + GetUpOverheadFileReqPackets() );
		RatioINI.Write( _T("UpOverheadSrcExPackets"), theStats.GetUpDataOverheadSourceExchangePackets() + GetUpOverheadSrcExPackets() );
		RatioINI.Write( _T("UpOverheadServerPackets"), theStats.GetUpDataOverheadServerPackets() + GetUpOverheadServerPackets() );
		RatioINI.Write( _T("UpOverheadKadPackets"), theStats.GetUpDataOverheadKadPackets() + GetUpOverheadKadPackets() );
		// Save Cumulative Connection Statistics
		float tempRate = 0.0F;

		// Download Rate Average
		tempRate = theStats.GetAvgDownloadRate(AVG_TOTAL);
		RatioINI.Write( _T("ConnAvgDownRate"), tempRate );

		// Max Download Rate Average
		if ( tempRate > GetConnMaxAvgDownRate() )   SetConnMaxAvgDownRate(tempRate);
		RatioINI.Write( _T("ConnMaxAvgDownRate"), GetConnMaxAvgDownRate() );

		// Max Download Rate
		tempRate = float(theApp.downloadqueue->GetDatarate()) / 1024;
		if ( tempRate > GetConnMaxDownRate() )   SetConnMaxDownRate(tempRate);
		RatioINI.Write( _T("ConnMaxDownRate"), GetConnMaxDownRate() );

		// Upload Rate Average
		tempRate = theStats.GetAvgUploadRate(AVG_TOTAL);
		RatioINI.Write( _T("ConnAvgUpRate"), tempRate );

		// Max Upload Rate Average
		if ( tempRate > GetConnMaxAvgUpRate() )   SetConnMaxAvgUpRate(tempRate);
		RatioINI.Write( _T("ConnMaxAvgUpRate"), GetConnMaxAvgUpRate() );

		// Max Upload Rate
		tempRate = float(theApp.uploadqueue->GetDatarate()) / 1024;
		if ( tempRate > GetConnMaxUpRate() )   SetConnMaxUpRate(tempRate);
		RatioINI.Write( _T("ConnMaxUpRate"), GetConnMaxUpRate() );
	
		// Overall Run Time
		RatioINI.Write( _T("ConnRunTime"), (GetTickCount() - theStats.starttime)/1000 + GetConnRunTime() );
	
		// Number of Reconnects
		RatioINI.Write( _T("ConnNumReconnects"), (theStats.reconnects>0) ? (theStats.reconnects - 1 + GetConnNumReconnects()) : GetConnNumReconnects() );
	
		// Average Connections
		if (theApp.serverconnect->IsConnected())
			RatioINI.Write( _T("ConnAvgConnections"), (theApp.listensocket->GetAverageConnections() + cumConnAvgConnections)/2 );
		else
			RatioINI.Write( _T("ConnAvgConnections"), cumConnAvgConnections );
	
		// Peak Connections
		if (theApp.listensocket->GetPeakConnections() > cumConnPeakConnections)
			cumConnPeakConnections = theApp.listensocket->GetPeakConnections();
		RatioINI.Write( _T("ConnPeakConnections"), cumConnPeakConnections );
	
		// Max Connection Limit Reached
		if (theApp.listensocket->GetMaxConnectionReached() + cumConnMaxConnLimitReached > cumConnMaxConnLimitReached)
			RatioINI.Write( _T("ConnMaxConnLimitReached"), theApp.listensocket->GetMaxConnectionReached() + cumConnMaxConnLimitReached );
		else
			RatioINI.Write( _T("ConnMaxConnLimitReached"), cumConnMaxConnLimitReached );
	
		// Time Stuff...
		RatioINI.Write( _T("ConnTransferTime"), GetConnTransferTime() + theStats.GetTransferTime() );
		RatioINI.Write( _T("ConnUploadTime"), GetConnUploadTime() + theStats.GetUploadTime() );
		RatioINI.Write( _T("ConnDownloadTime"), GetConnDownloadTime() + theStats.GetDownloadTime() );
		RatioINI.Write( _T("ConnServerDuration"), GetConnServerDuration() + theStats.GetServerDuration() );
	
		// Compare and Save Server Records
		uint32 servtotal, servfail, servuser, servfile, servlowiduser, servtuser, servtfile;
		float servocc;
		theApp.serverlist->GetStatus(servtotal, servfail, servuser, servfile, servlowiduser, servtuser, servtfile, servocc);
	
		if (servtotal - servfail > cumSrvrsMostWorkingServers)
			cumSrvrsMostWorkingServers = servtotal - servfail;
		RatioINI.Write( _T("SrvrsMostWorkingServers"), cumSrvrsMostWorkingServers );

		if (servtuser > cumSrvrsMostUsersOnline)
			cumSrvrsMostUsersOnline = servtuser;
		RatioINI.Write( _T("SrvrsMostUsersOnline"), cumSrvrsMostUsersOnline );

		if (servtfile > cumSrvrsMostFilesAvail)
			cumSrvrsMostFilesAvail = servtfile;
		RatioINI.Write( _T("SrvrsMostFilesAvail"), cumSrvrsMostFilesAvail );

		// Compare and Save Shared File Records
		if (theApp.sharedfiles->GetCount() > cumSharedMostFilesShared)
			cumSharedMostFilesShared = theApp.sharedfiles->GetCount();
		RatioINI.Write( _T("SharedMostFilesShared"), cumSharedMostFilesShared );

		uint64 bytesLargestFile = 0;
		uint64 allsize = theApp.sharedfiles->GetDatasize(bytesLargestFile);
		if (allsize > cumSharedLargestShareSize)   cumSharedLargestShareSize = allsize;
		RatioINI.Write( _T("SharedLargestShareSize"), cumSharedLargestShareSize );
		if (bytesLargestFile > cumSharedLargestFileSize)   cumSharedLargestFileSize = bytesLargestFile;
		RatioINI.Write( _T("SharedLargestFileSize"), cumSharedLargestFileSize );

		if (theApp.sharedfiles->GetCount() != 0)
		{
			uint64 tempint = allsize/theApp.sharedfiles->GetCount();
			if (tempint > cumSharedLargestAvgFileSize)   cumSharedLargestAvgFileSize = tempint;
		}

		RatioINI.Write( _T("SharedLargestAvgFileSize"), cumSharedLargestAvgFileSize );
		RatioINI.Write( _T("statsDateTimeLastReset"), stat_datetimeLastReset );
		//
		RatioINI.Write( _T("DownCompletedFiles"), GetDownCompletedFiles() );
		RatioINI.Write( _T("DownSessionCompletedFiles"), GetDownSessionCompletedFiles() );
		//
		RatioINI.CloseFile();
	}
	// If we are saving a back-up or a temporary back-up, return now.
	if (bBackUp != 0)   return;
}

// Ratio Category
void CPreferences::RT_SaveCategory()
{
	int CategoryCount = GetCatCount();
	if (CategoryCount < 1)   return;
	CString Filename;
	Filename.Format( _T("%sRT_Category.ini"), configdir);
	RatioAppendINI RatioINI;
	if (RatioINI.OpenFile(Filename, _T("w")) == true)
	{
		CString Buffer;
		// General
		RatioINI.WriteSection( _T("General") );
		RatioINI.Write( _T("Count"), GetCatCount() );
		// Category
		CategoryCount--;
		for (int i = 0; i <= CategoryCount; i++)
		{
			Buffer.Format( _T("[Cat#%u]\n"), i);
			RatioINI.Write( Buffer );
			RatioINI.Write( _T("Title"), CString(catMap.GetAt(i)->title) );
			RatioINI.Write( _T("TempDir"), GetTempDir(i) );
			RatioINI.Write( _T("VewFilter"), rt_CategoryViewFilter.GetAt(i) );
		}
		RatioINI.CloseFile();
	}
}

// Ratio Category
int CPreferences::AddCat(Category_Struct* cat)
{
	catMap.Add(cat);
	rt_CategoryTempDir.Add( CString(GetTempDir()) );
	rt_CategoryViewFilter.Add(0);
	return (catMap.GetCount() - 1);
}

// Category View Filter
int CPreferences::GetCategoryViewFilter(int Category)
{
	if ( (Category < 0) || (Category >= rt_CategoryViewFilter.GetCount()) )   return 0;
	return rt_CategoryViewFilter.GetAt(Category);
}

// Category View Filter
void CPreferences::SetCategoryViewFilter(int Category, int Filter)
{
	if ( (Category < 0) || (Category >= rt_CategoryViewFilter.GetCount()) )   return;
	if (Filter > 0)
	{
		uint16 WhichFilter = (1 << Filter);
		Filter = (uint16(rt_CategoryViewFilter.GetAt(Category)) ^ WhichFilter);
	}
	rt_CategoryViewFilter.SetAt(Category, Filter);
}

// Convert Old Format KnownFile to New Format
void CPreferences::RT_ConvertOldKnownFile()
{
	CString Filename;
	Filename.Format( _T("%sRT_KnownFile.ini"), thePrefs.GetConfigDir() );
	if (PathFileExists(Filename) == FALSE)   return;
	CIni RatioIni( Filename, _T("General") );
	uint16 OldVersion = RatioIni.GetInt( _T("KnownFileVersion"), RT_KNOWN_FILE_VERSION, _T("General") );
	if (OldVersion == RT_KNOWN_FILE_VERSION)   return;
	FILE *SourceFile, *TargetFile;
	SourceFile = _tfopen(Filename, _T("r"));
	if (SourceFile != NULL)
	{
		TargetFile = _tfopen(CString(Filename + _T(".new")), _T("w"));
		if (TargetFile != NULL)
		{
			// Initial
			TCHAR SourceBuffer[1024];
			int SourceBufferLen = 1024;
			CString Buffer;
			_fputts(_T("[General]\n"), TargetFile);
			Buffer.Format(_T("KnownFileVersion=%u\n"), RT_KNOWN_FILE_VERSION);
			_fputts(Buffer, TargetFile);
			_fputts(_T("[FileStatus]\n"), TargetFile);
			if (OldVersion == 1)
			{
				_fgetts(SourceBuffer, SourceBufferLen, SourceFile);
				_fgetts(SourceBuffer, SourceBufferLen, SourceFile);
				_fgetts(SourceBuffer, SourceBufferLen, SourceFile);
				while (feof(SourceFile) == 0)
				{
					SourceBuffer[0] = _T('\0');
					_fgetts(SourceBuffer, SourceBufferLen, SourceFile);
					_fputts(SourceBuffer, TargetFile);
				}
			}
			//
			fclose(TargetFile);
		}
		fclose(SourceFile);
		if (TargetFile != NULL)
		{
			_tremove(Filename);
			_trename( (Filename + _T(".new")), Filename );
		}
	}
}

// Convert Official Credits File to RT Format
void CPreferences::RT_ClientsMet2RT()
{
	CString Filename, NewFilename;
	Filename.Format( _T("%sclients.met"), thePrefs.GetConfigDir() );
	NewFilename.Format( _T("%sRT_Clients.dat"), thePrefs.GetConfigDir() );
	if (PathFileExists(NewFilename) == TRUE)   return;
	if (PathFileExists(Filename) == FALSE)   return;
	// Open File
	CFileException fexp;
	const int OpenFlags = (CFile::modeRead | CFile::osSequentialScan | CFile::typeBinary | CFile::shareDenyWrite);
	CSafeBufferedFile OfficialCreditsFile;
	if (OfficialCreditsFile.Open(Filename, OpenFlags, &fexp) == FALSE)   return;
	setvbuf(OfficialCreditsFile.m_pStream, NULL, _IOFBF, 16384);
	//
	CFile RT_CreditsFile;
	if (RT_CreditsFile.Open(NewFilename, CFile::modeWrite|CFile::modeCreate|CFile::typeBinary|CFile::shareDenyWrite, &fexp) == FALSE)
	{
		OfficialCreditsFile.Close();
		return;
	}
	//
	BYTE* WriteBuffer = NULL;
	try
	{
		// Check Version
		uint8 CreditsVersion = OfficialCreditsFile.ReadUInt8();
		if ( (CreditsVersion != CREDITFILE_VERSION) && (CreditsVersion != CREDITFILE_VERSION_29) )
		{
			OfficialCreditsFile.Close();
			RT_CreditsFile.Close();
			_tremove(NewFilename);
			return;
		}
		// Initial
		const uint32 CreditsCount = OfficialCreditsFile.ReadUInt32();
		const uint32 CreditsExpired = time(NULL) - 12960000;	// today - 150 day
		WriteBuffer = new BYTE[ (CreditsCount * sizeof(CreditStruct)) ];
		uint32 BufferPos = 0;
		uint32 ValidCreditsCount = 0;
		CreditStruct_Official* OfficialCredit = new CreditStruct_Official;
		CreditStruct* RT_Credit = new CreditStruct;
		// Convert
		for (uint32 i = 0; i < CreditsCount; i++)
		{
			// Load
			if (CreditsVersion == CREDITFILE_VERSION_29)
				OfficialCreditsFile.Read( OfficialCredit, sizeof(CreditStruct_29a) );
			else
				OfficialCreditsFile.Read( OfficialCredit, sizeof(CreditStruct_Official) );
			if (OfficialCredit->nLastSeen < CreditsExpired)   continue;
			// Reset Leecher Count and Don't Donwload
			RT_Credit->Feature = 0;
			// Write to Buffer
			if ( (OfficialCredit->nDownloadedLo > 1048576) || (OfficialCredit->nUploadedLo > 1048576) ||
				(OfficialCredit->nDownloadedHi > 0) || (OfficialCredit->nUploadedHi > 0) )
			{
				// Copy to RT Struct
				RT_Credit->UploadedTotal = ( (uint64(OfficialCredit->nUploadedHi) << 32) + OfficialCredit->nUploadedLo );
				RT_Credit->DownloadedTotal = ( (uint64(OfficialCredit->nDownloadedHi) << 32) + OfficialCredit->nDownloadedLo );
				RT_Credit->UploadQueueWaitedTime = 0;
				RT_Credit->nLastSeen = OfficialCredit->nLastSeen;
				RT_Credit->nKeySize = OfficialCredit->nKeySize;
				memcpy( RT_Credit->abyKey, OfficialCredit->abyKey, sizeof(OfficialCredit->abyKey) );
				memcpy( RT_Credit->abySecureIdent, OfficialCredit->abySecureIdent, sizeof(OfficialCredit->abySecureIdent) );
				// Write to Buffer
				memcpy( (WriteBuffer + BufferPos), RT_Credit, sizeof(CreditStruct) );
				ValidCreditsCount++;
				BufferPos += sizeof(CreditStruct);
			}
		}
		delete OfficialCredit;
		delete RT_Credit;
		// Save to File
		CreditsVersion = RT_CREDIT_FILE_VERSION;
		RT_CreditsFile.Write(&CreditsVersion, 1);
		RT_CreditsFile.Write(&ValidCreditsCount, 4);
		RT_CreditsFile.Write( WriteBuffer, (ValidCreditsCount * sizeof(CreditStruct)) );
		RT_CreditsFile.Flush();
		RT_CreditsFile.Close();
		OfficialCreditsFile.Close();
	}
	catch (CFileException* error)
	{
		if (error->m_cause == CFileException::endOfFile)
			AddLogLine(true, GetResString(IDS_CREDITFILECORRUPT));
		else
		{
			TCHAR Buffer[MAX_CFEXP_ERRORMSG];
			error->GetErrorMessage( Buffer, ARRSIZE(Buffer) );
			AddLogLine(true, GetResString(IDS_ERR_CREDITFILEREAD), Buffer);
		}
		error->Delete();
	}
	if (WriteBuffer != NULL)   delete [] WriteBuffer;
}