//
#include "stdafx.h"
#include <io.h>
#include "emule.h"
#include "Ini2.h"
#include "UploadQueue.h"
#include "DownloadQueue.h"
#include "UpDownClient.h"
#include "ClientList.h"
#include "ClientCredits.h"
#include "Preferences.h"
#include "opcodes.h"
#include "PartFile.h"
#include "KnownFile.h"
#include "KnownFileList.h"
#include "SharedFileList.h"
#include "Sockets.h"
#include "ServerList.h"
#include "Packets.h"
#include "ListenSocket.h"
#include "LastCommonRouteFinder.h"
#include "UploadBandwidthThrottler.h"
#include "OtherFunctions.h"
#include "TaskbarNotifier.h"
#include "SearchList.h"
#include "ed2kLink.h"
#include "SafeFile.h"
#include "Statistics.h"
#include "FriendList.h"
#include "0RatioFile/RT_Other.h"
#include "0RatioFile/RT_Opcodes.h"
#ifndef _CONSOLE
#include "emuledlg.h"
#include "TransferWnd.h"
#endif

// ********************
// *** Upload Queue ***
// ********************
//
// Friend Slot Auto
bool CUploadQueue::IsFriendInQueue(bool IsSetFriendSlot)
{
	uint32 CurrentWaitStartTime;
	uint32 WaitStartTime = ::GetTickCount() - 60000;
	uint32 WaitStartTimeLowID = ::GetTickCount() - 60000;
	CUpDownClient* Client;
	CUpDownClient* Friend = NULL;
	CUpDownClient* FriendLowID = NULL;
	bool UseFriendSlotByLowID = false;

	POSITION Pos = waitinglist.GetHeadPosition();
	while (Pos != NULL)
	{
		Client = waitinglist.GetNext(Pos);
		if (Client->IsFriend() == true)
		{
			if (IsSetFriendSlot == false)   return true;
			if (Client->GetScore(false) >= RT_SCORE_BASIC)
			{
				// Is Already Accept to Upload
				if (Client->m_bAddNextConnect == false)
				{
					// Clear Flag
					if (Client->GetFriendSlot() == true)   Client->SetFriendSlot(false);
					if (Client->HasLowID() == true)
					{
						// Find LowID Client which has the Longest WaitTime
						CurrentWaitStartTime = Client->GetWaitStartTime();
						if (CurrentWaitStartTime < WaitStartTimeLowID)
						{
							WaitStartTimeLowID = CurrentWaitStartTime;
							FriendLowID = Client;
						}
					}
					else
					{
						// Find Client which has the Longest WaitTime
						CurrentWaitStartTime = Client->GetWaitStartTime();
						if (CurrentWaitStartTime < WaitStartTime)
						{
							WaitStartTime = CurrentWaitStartTime;
							Friend = Client;
						}
					}
				}
				else if (Client->GetFriendSlot() == true)
					UseFriendSlotByLowID = true;
			}
		}
	}
	if (UseFriendSlotByLowID == true)   FriendLowID = NULL;
	// Set Frined Slot
	if (FriendLowID != NULL)
	{
		if ( (Friend == NULL) || (WaitStartTimeLowID < WaitStartTime) )
		{
			FriendLowID->SetFriendSlot(true);
			return true;
		}
	}
	if (Friend != NULL)
	{
		Friend->SetFriendSlot(true);
		return true;
	}
	return false;
}

// Friend Slot Auto
bool CUploadQueue::IsFriendSlotInUse() const
{
	CUpDownClient* Client;
	POSITION Pos = uploadinglist.GetHeadPosition();
	// Find Client who use the Frined Slot
	while (Pos != NULL)
	{
		Client = uploadinglist.GetNext(Pos);
		if (Client->GetFriendSlot() == true)   return true;
	}
	return false;
}

// Check Uploading Status
void CUploadQueue::CheckUploadingStatus()
{
	CUpDownClient* Client;
	rt_ReleaseSlotCount = 0;
	rt_Credit1SlotCount = 0;
	POSITION pos = uploadinglist.GetHeadPosition();
	while (pos != NULL)
	{
		Client =  uploadinglist.GetNext(pos);
		if ( (Client->GetQueueScore() >= RT_SCORE_RELEASE) && (Client->GetFriendSlot() == false) )
		{
			if (Client->GetQueueScore() >= RT_SCORE_CREDIT1)
				rt_Credit1SlotCount++;
			else
				rt_ReleaseSlotCount++;
		}
	}
}

// New Method to AddUpNextClient
bool CUploadQueue::AddUpNextClient(CUpDownClient* DirectAdd)
{
	if (theApp.ExitSmoothlyDialog != NULL)   return false;

	CUpDownClient* BestClient = NULL;
	CUpDownClient* BestClientLowID = NULL;
	uint32	BestScore = 0;
	uint32  BestScoreLowID = 0;
	CUpDownClient* NewClient = NULL;

	// select next client or use given client
	if (DirectAdd == NULL)
	{
		// Special count of queue
		rt_InvalidCount = 0;
		rt_LeecherCount = 0;
		rt_GPLEvildoerCount = 0;
		rt_FriendCount = 0;
		// Check Uploading Status before Search Client
		CheckUploadingStatus();
		// Friend Slot Auto
		if ( thePrefs.IsFriendSlotAuto() && (IsFriendSlotInUse() == false) )   IsFriendInQueue(true);
		// Search client who has best score
		DWORD CurrentTick = ::GetTickCount();
		POSITION ListPos = waitinglist.GetHeadPosition();
		while (ListPos != NULL)
		{
			CUpDownClient* CurrentClient = waitinglist.GetNext(ListPos);
			// clear dead clients
			ASSERT ( CurrentClient->GetLastUpRequest() );
			if ( (CurrentTick - CurrentClient->GetLastUpRequest() > MAX_PURGEQUEUETIME) ||
				(theApp.sharedfiles->GetFileByID(CurrentClient->GetUploadFileID()) == NULL) )
			{
				// Upload Queue Waited Time
				if (thePrefs.IsRecordUploadQueueWaitedTime() == true)
					CurrentClient->SetUploadQueueWaitedTime( CurrentClient->GetWaitTime(true) );
				//
				CurrentClient->ClearWaitStartTime();
				RemoveFromWaitingQueue(CurrentClient, true);
				//
				if (CurrentClient->socket == NULL)
				{
					if (CurrentClient->Disconnected(_T("AddUpNextClient - purged")) == true)
					{
						delete CurrentClient;
						CurrentClient = NULL;
					}
				}
				continue;
			}
			// Compare Score
			if (CurrentClient->m_bAddNextConnect == false)
			{
				// finished clearing
				uint32 CurrentScore = CurrentClient->GetScore(false);
				CurrentClient->SetQueueScore(CurrentScore);
				// Special count of queue
				if (CurrentClient->IsFriend() == true)   rt_FriendCount++;
				if (CurrentScore < RT_SCORE_BASIC)
				{
					switch (CurrentScore)
					{
						case RT_SCORE_INVALID:
							rt_InvalidCount++;
							break;
						case RT_SCORE_LEECHER:
							rt_LeecherCount++;
							break;
						case RT_SCORE_GPL_EVILDOER:
							rt_GPLEvildoerCount++;
							break;
					}
				}
				else
				{
					if (CurrentClient->HasLowID() == false)
					{
						// Best Score
						if (CurrentScore > BestScore)
						{
							BestScore = CurrentScore;
							BestClient = CurrentClient;
						}
					}
					else
					{
						// LowID Best Score
						if (CurrentScore > BestScoreLowID)
						{
							BestScoreLowID = CurrentScore;
							BestClientLowID = CurrentClient;
						}
					}
				}
			}
		}
		
		if (BestScoreLowID > BestScore)
		{
			NewClient = BestClientLowID;
			NewClient->m_bAddNextConnect = true;
			if (NewClient->GetQueueScore() >= RT_SCORE_RELEASE)
			{
				if (NewClient->GetQueueScore() >= RT_SCORE_CREDIT1)
					rt_Credit1SlotLowID = true;
				else
					rt_ReleaseSlotLowID = true;
			}
		}
		if ( (NewClient == NULL) || (NewClient->socket == NULL) || (NewClient->socket->IsConnected() == false) )
		{
			if (BestClient == NULL)   return false;
			// Don't Add Client which Sorce < RT_SCORE_BASIC
			if (BestClient->GetScore(false) < RT_SCORE_BASIC)   return false;
			NewClient = BestClient;
			lastupslotHighID = true; // VQB LowID alternate
			RemoveFromWaitingQueue(BestClient, true);
			theApp.emuledlg->transferwnd->ShowQueueCount( waitinglist.GetCount() );
		}
		else
		{
			lastupslotHighID = false;
			RemoveFromWaitingQueue(NewClient, true);
			if (thePrefs.IsLogRatioVerbose() == true)
				AddDebugLogLine( false, _T(">> [RT Debug] LowID Direct to Upload. { %s }"), NewClient->GetUserName() );
		}
	}
	else
	{
		// Don't Add Client which Sorce < RT_SCORE_BASIC
		if (DirectAdd->GetScore(false) < RT_SCORE_BASIC)
		{
			if (waitinglist.Find(DirectAdd) == NULL)   waitinglist.AddTail(DirectAdd);
			return false;
		}
		NewClient = DirectAdd;
	}
	//
	if (IsDownloading(NewClient) == true)   return false;
	// New Method to tell the client that we are now ready to upload
	CKnownFile* RequstFile = theApp.sharedfiles->GetFileByID(NewClient->GetUploadFileID());
	if (RequstFile == NULL)   return false;
	bool IsSendAcceptUpload = false;
	if ( (NewClient->socket == NULL) || (NewClient->socket->IsConnected() == false) )
	{
		NewClient->SetUploadState(US_CONNECTING);
		if (NewClient->TryToConnect(true) == false)   return false;
	}
	else
	{
		NewClient->SetUpdateFileStatus(true);
		NewClient->SetUploadState(US_UPLOADING);
		IsSendAcceptUpload = true;
	}
	// statistic
	RequstFile->statistic.AddAccepted();
	// Upload Special State
	if ( (NewClient->GetFriendSlot() == false) && (NewClient->GetQueueScore() >= RT_SCORE_RELEASE) )
	{
		if (NewClient->GetQueueScore() >= RT_SCORE_CREDIT1)
			rt_Credit1SlotCount++;
		else
			rt_ReleaseSlotCount++;
	}
	NewClient->SetNoTransferTimeUL(0);
	//
	NewClient->SetUpStartTime();
	theApp.uploadBandwidthThrottler->AddToStandardList(uploadinglist.GetCount(), NewClient->socket);
	uploadinglist.AddTail(NewClient);
	NewClient->SetModNO();
	NewClient->ResetSessionUp();
	theApp.emuledlg->transferwnd->uploadlistctrl.AddClient(NewClient);

	if (IsSendAcceptUpload)
	{
		// Update File Status
		if (NewClient->UpdateFileStatus() == false)
		{
			NewClient->SetUpdateFileStatus(false);
			Packet* packet = new Packet(OP_ACCEPTUPLOADREQ, 0);
			theStats.AddUpDataOverheadFileRequest(packet->size);
			NewClient->socket->SendPacket(packet,true);
		}
	}
	return true;
}

// New Method to AcceptNewClient
bool CUploadQueue::AcceptNewClient()
{
	if ( (::GetTickCount() - m_nLastStartUpload) < SEC2MS(1) )   return false;
	if ( uploadinglist.GetCount() < int(thePrefs.GetMinUploadSlot()) )   return true;
	if ( uploadinglist.GetCount() >= int(thePrefs.GetMaxUploadSlot()) )
	{
		m_nLastStartUpload = ::GetTickCount();
		return false;
	}
	uint32 MaxUpload = theApp.lastCommonRouteFinder->GetUpload();
	if ( (datarate + 2000) < MaxUpload )
	{
		uint32 DelayTime = uint32(::GetTickCount()) - m_nLastStartUpload;
		if ( (DelayTime >= SEC2MS(10)) || ((datarate + (SEC2MS(10) - DelayTime)) < MaxUpload) )   return true;
	}
	else
		m_nLastStartUpload = ::GetTickCount();
	return false;
}

// New Method to CheckForTimeOver
bool CUploadQueue::CheckForTimeOver(CUpDownClient* client)
{
	// Check Friend Slot
	if (client->GetFriendSlot() == true)
	{
		if ( (thePrefs.IsFriendSlotAuto() == false) && (theApp.ExitSmoothlyDialog == NULL) )   return false;
    }
	else
	{
		// Transfer Limit
		if ( (theApp.ExitSmoothlyDialog == NULL) && (thePrefs.GetMaxCredit1Slot() > 0) &&
			(client->GetCreditRatio() < 1) )
		{
			if ( client->GetSessionUp() > GetTransferLimit(client) )
			{
				if (thePrefs.IsLogRatioVerbose() == true)
					AddDebugLogLine( false, _T(">> [RT Debug] Upload session ended due to Credit < 1. { %s } { %s }"), CastItoXBytes(client->GetSessionUp()), client->GetUserName() );
				return true;
			}
		}
	}
	// Transfer Full Chunks
	if (thePrefs.TransferFullChunks() == false)
	{
		// Try to keep the clients from downloading for ever.
		if (client->GetUpStartTimeDelay() > SESSIONMAXTIME)
		{
			AddDebugLogLine( false, _T("%s: Upload session ended due to excessive time."), client->GetUserName() );
			return true;
		}
		// Cache current client score
		const uint32 score = client->GetScore(true, true);
		// Check if another client has a bigger score
		if ( score < GetMaxClientScore() )
		{
			AddDebugLogLine(false, _T("%s: Upload session ended due to score."), client->GetUserName());
			return true;
		}
	}
	else
	{
		// Allow the client to download a specified amount per session
		if (client->GetQueueSessionPayloadUp() > SESSIONMAXTRANS)
		{
			AddDebugLogLine( false, _T("%s: Upload session ended due to excessive transfered amount."), client->GetUserName() );
			return true;
		}
	}
	// Sorce < RT_SCORE_BASIC
	if (client->GetScore(false) < RT_SCORE_BASIC)
	{
		if (thePrefs.IsLogRatioVerbose() == true)
			AddDebugLogLine( false, _T(">> [RT Debug] Upload session ended due to { %s }. { %s }"), client->GetRatingString(), client->GetUserName() );
		return true;
	}
	// Check Time for No Transfer
	return client->CheckNoTransferTime(false);
}

// Transfer Limit
uint32 CUploadQueue::GetTransferLimit(CUpDownClient* Client)
{
	if (Client->IsFriend() == true)   return 10000000;
	if (Client->GetFirstRequestedPart() == 0xFFFF)   return 10000000;
	CKnownFile* UploadFile = theApp.sharedfiles->GetFileByID( Client->GetUploadFileID() );
	if (UploadFile == NULL)   return 10000000;
	if (UploadFile->IsReleaseFile() == true)   return 10000000;
	if ( Client->GetFirstRequestedPart() < UploadFile->GetPartCount() )
	{
		if (UploadFile->IsPartFile() == true)
		{
			uint16 PartFrequency = ((CPartFile*)UploadFile)->GetPartFrequency( Client->GetFirstRequestedPart() );
			if (PartFrequency > 400)   return 2000000;
			if (PartFrequency > 200)   return 4000000;
			if (PartFrequency > 100)   return 6000000;
			if (PartFrequency > 50)   return 8000000;
		}
		else
		{
			uint16 PartFrequency = UploadFile->GetPartFrequency( Client->GetFirstRequestedPart() );
			if (PartFrequency > 80)   return 2000000;
			if (PartFrequency > 40)   return 4000000;
			if (PartFrequency > 20)   return 6000000;
			if (PartFrequency > 10)   return 8000000;
		}
	}
	else
		AddDebugLogLine( false, _T(">> [RT Debug] Transfer Limit error. [%u, %u] { %s }"), Client->GetFirstRequestedPart(), UploadFile->GetPartCount(), Client->GetUserName() );
	return 10000000;
}

// Queue Score
uint16 CUploadQueue::GetWaitingPosition(CUpDownClient* Client, bool RealScore)
{
	if (IsOnUploadQueue(Client) == false)   return 0;
	UINT Rank = 1;
	uint32 ClientScore, Score;
	if (RealScore == true)
	{
		ClientScore = Client->GetScore(false);
		Client->SetQueueScore(ClientScore);
	}
	else
		ClientScore = Client->GetQueueScore();
	//
	POSITION Pos = waitinglist.GetHeadPosition();
	while (Pos != NULL)
	{
		CUpDownClient* CurrentClient = waitinglist.GetNext(Pos);
		if (RealScore == true)
		{
			Score = CurrentClient->GetScore(false);
			CurrentClient->SetQueueScore(Score);
		}
		else
			Score = CurrentClient->GetQueueScore();
		if (Score > ClientScore)   Rank++;
	}
	return Rank;
}

// Keep Friend Slot
void CUploadQueue::KeepFriendSlot(CUpDownClient* Client)
{
	if (thePrefs.IsCurrentFS( Client->GetUserHash() ) == true)
	{
		theApp.friendlist->RemoveAllFriendSlots();
		Client->SetFriendSlot(true);
		if (thePrefs.IsLogRatioVerbose() == true)
			AddDebugLogLine( false, _T(">> [RT Debug] Keep Friend Slot { %s } { %s }"), md4str(Client->GetUserHash()), Client->GetUserName() );
	}
	else
		Client->SetFriendSlot(false);
}

// Upload Queue Waited Time
void CUploadQueue::RecordUploadQueueWaitedTime()
{
	POSITION Pos = waitinglist.GetHeadPosition();
	while (Pos != NULL)
	{
		CUpDownClient* CurrentClient = waitinglist.GetNext(Pos);
		CurrentClient->SetUploadQueueWaitedTime( CurrentClient->GetWaitTime(true) );
		CurrentClient->ClearWaitStartTime();
	}
	Pos = uploadinglist.GetHeadPosition();
	while (Pos != NULL)
	{
		CUpDownClient* CurrentClient = uploadinglist.GetNext(Pos);
		CurrentClient->SetUploadQueueWaitedTime( CurrentClient->GetWaitTime(true) );
		CurrentClient->ClearWaitStartTime();
	}
}

// New Code for RemoveFromUploadQueue()
bool CUploadQueue::RemoveFromUploadQueue(CUpDownClient* client, LPCTSTR pszReason, bool updatewindow, bool earlyabort){
	POSITION Pos = uploadinglist.Find(client);
	if (Pos != NULL)
	{
		if (updatewindow == true)
			theApp.emuledlg->transferwnd->uploadlistctrl.RemoveClient(client);

		if (thePrefs.GetLogUlDlEvents() == true)
			AddDebugLogLine(DLP_VERYLOW, true,_T("---- %s: Removing client from upload list. Reason: %s ----"), client->GetUserName(), pszReason==NULL ? _T("") : pszReason);

		uploadinglist.RemoveAt(Pos);
		theApp.uploadBandwidthThrottler->RemoveFromStandardList(client->socket);

		if (client->GetSessionUp() > 0)
		{
			++successfullupcount;
			totaluploadtime += client->GetUpStartTimeDelay()/1000;
		}
		else if(earlyabort == false)
			++failedupcount;

		CKnownFile* requestedFile = theApp.sharedfiles->GetFileByID(client->GetUploadFileID());

		if (requestedFile != NULL)   requestedFile->UpdatePartsInfo();

		theApp.clientlist->AddTrackClient(client); // Keep track of this client
		// Clear UpdateFileStatus Flag
		if (client->IsUpdateFileStatus() == true)
		{
			--failedupcount;
			client->SetUpdateFileStatus(false);
		}
		// Last Upload Time
		if ( (client->GetSessionUp() > 1048576) && (requestedFile->statistic.GetTransferred() >= PARTSIZE) )
			requestedFile->ResetLastUploadTime();
		// Reset Client
		if (pszReason != NULL)
		{
			CString Buffer( _T("Completed transfer") );
			if ( (Buffer.Compare(pszReason) == 0) && (client->GetSessionUp() > 1048576) )
			{
				client->SetUploadQueueWaitedTime(0);
				if (thePrefs.IsLogRatioVerbose() == true)
					AddDebugLogLine( false, _T(">> [RT Debug] Completed Transfer, Reset [Upload Queue Waited Time]. { %s } [Waited Time = %u]"), client->GetUserName(), client->credits->GetUploadQueueWaitedTime() );
			}
		}
		client->SetUploadState(US_NONE);
		client->ClearUploadBlockRequests();
		client->ClearUploadTime();
		client->SetFirstRequestedPart(0xFFFF);
		client->SetFriendSlot(false);
		client->m_bAddNextConnect = false;
		return true;
	}
	return false;
}

// Update Queue
void CUploadQueue::UpdateQueue()
{
	// Update Queue Thread
	CSingleLock SingleLock(&UpdateQueueLocker);
	SingleLock.Lock();
	// Update
	POSITION Pos = waitinglist.GetHeadPosition();
	while (Pos != NULL)
	{
		CUpDownClient* CurrentClient = waitinglist.GetNext(Pos);
		CurrentClient->SetQueueScore( CurrentClient->GetScore(false) );
		theApp.emuledlg->transferwnd->queuelistctrl.RefreshClient(CurrentClient);
	}
	SingleLock.Unlock();
}

// **********************
// *** Download Queue ***
// **********************
//
// Initial
void CDownloadQueue::Init()
{
	// Initial
	CFileFind Finder;
	uint32 FileCount = 0;
	CString BaseTempDir = thePrefs.GetTempDir();
	CString SearchPath, CurrentTempDir;
	// Inital--List
	CString FileListPath = thePrefs.GetConfigDir() + _T("RT_Downloading.htm");
	FILE* ListFile;
	ListFile = _tfopen( FileListPath, _T("w") );
	if (ListFile != NULL)
	{
		_fputts( _T("<HTML><TITLE>eMuleRT Downloading File List</TITLE>\r\n"), ListFile );
		_fputts( _T("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=big5\">\r\n"), ListFile );
		_fputts( _T("<BODY>\r\n"), ListFile );
		_fputts( _T("<B>eMuleRT Downloading File List</B><BR><BR>\r\n"), ListFile );
		_ftprintf( ListFile, _T("Date:      %s<BR>\r\n"), CTime::GetCurrentTime().Format(_T("%c")) );
		_fputts( _T("<BR>\r\n"), ListFile );
	}
	//  Category Temporary Directory
	int CategoryCount = thePrefs.GetCatCount();
	for (int i = 0; i < CategoryCount; i++)
	{
		FileCount = 0;
		CurrentTempDir = thePrefs.GetTempDir(i);
		if ( (i == 0) || (CompareDirectories(BaseTempDir, CurrentTempDir) != 0) )
		{
			if (ListFile != NULL)
			{
				_fputts( _T("********************************************************************************<BR>\r\n"), ListFile );
				_ftprintf( ListFile, _T("Directory:  [%s]<BR>\r\n"), CurrentTempDir );
				_fputts( _T("<BR>\r\n"), ListFile );
				_fputts( _T("Part file &nbsp;&nbsp;&nbsp;eD2K link<BR>\r\n"), ListFile );
				_fputts( _T("--------------------------------------------------------------------------------<BR>\r\n"), ListFile );
			}
			SearchPath.Format( _T("%s\\*.part.met"), CurrentTempDir );
			// check all part.met files
			bool IsFind = Finder.FindFile(SearchPath, 0);
			while (IsFind)
			{
				IsFind = Finder.FindNextFile();
				if (Finder.IsDirectory() == TRUE)   continue;
				CPartFile* CurrentFile = new CPartFile();
				if (CurrentFile->LoadPartFile(CurrentTempDir, Finder.GetFileName().GetBuffer()) > 0)
				{
					CurrentFile->SetCategoryTempDir(true);
					FileCount++;
					filelist.AddTail(CurrentFile);
					if (CurrentFile->GetStatus(true) == PS_READY)   sharedfilelist->SafeAddKFile(CurrentFile);
					theApp.emuledlg->transferwnd->downloadlistctrl.AddFile(CurrentFile);
					if (PreCheckFreeDiskspace(CurrentFile) == false)   CurrentFile->StopFile();
					// List
					if ( (ListFile != NULL) && (CurrentFile->GetStatus(true) != PS_COMPLETE) )
					{
						CString PartFilePath( CurrentFile->GetFilePath() );
						TCHAR PartFileName[_MAX_FNAME];
						TCHAR PartFileExt[_MAX_EXT];
						_tsplitpath(PartFilePath, NULL, NULL, PartFileName, PartFileExt);
						_ftprintf( ListFile, _T("%s%s &nbsp;&nbsp;&nbsp;%s<BR>\r\n"), PartFileName, PartFileExt, CreateHTMLED2kLink(CurrentFile) );
					}
				}
				else
					delete CurrentFile;
			}
			Finder.Close();
			// try recovering any part.met files
			SearchPath += _T(".backup");
			IsFind = Finder.FindFile(SearchPath, 0);
			while (IsFind)
			{
				IsFind = Finder.FindNextFile();
				if (Finder.IsDirectory() == TRUE)   continue;
				CPartFile* CurrentFile = new CPartFile();
				if (CurrentFile->LoadPartFile(CurrentTempDir, Finder.GetFileName().GetBuffer()) > 0)
				{
					CurrentFile->SavePartFile();
					CurrentFile->SetCategoryTempDir(true);
					FileCount++;
					filelist.AddTail(CurrentFile);
					if (CurrentFile->GetStatus(true) == PS_READY)   sharedfilelist->SafeAddKFile(CurrentFile);
					theApp.emuledlg->transferwnd->downloadlistctrl.AddFile(CurrentFile);
					if (PreCheckFreeDiskspace(CurrentFile) == false)   CurrentFile->StopFile();
					AddLogLine( false, GetResString(IDS_RECOVERED_PARTMET), CurrentFile->GetFileName() );
					// List
					if (ListFile != NULL)
					{
						if (CurrentFile->GetStatus(true) != PS_COMPLETE)
						{
							CString PartFilePath( CurrentFile->GetFilePath() );
							TCHAR PartFileName[_MAX_FNAME];
							TCHAR PartFileExt[_MAX_EXT];
							_tsplitpath(PartFilePath, NULL, NULL, PartFileName, PartFileExt);
							_ftprintf( ListFile, _T("%s%s &nbsp;&nbsp;&nbsp;%s<BR>\r\n"), PartFileName, PartFileExt, CreateHTMLED2kLink(CurrentFile) );
						}
					}
				}
				else
					delete CurrentFile;
			}
			Finder.Close();
			if (ListFile != NULL)
			{
				_fputts( _T("<BR>\r\n"), ListFile );
			}
		}
		if (FileCount > 0)
		{
			CString Buffer;
			Buffer.Format( _T("%s. [%s]"), GetResString(IDS_FOUNDPARTS), thePrefs.GetTempDir(i) );
			AddLogLine(false, Buffer, FileCount);
		}
	}
	// List
	if (ListFile != NULL)
	{
		_fputts( _T("</BODY></HTML>\r\n"), ListFile );
		fclose(ListFile);
	}
	//
	if (filelist.GetCount() > 0)
	{
		SortByPriority();
		CheckDiskspace();	// SLUGFILLER: checkDiskspace
	}
	else
		AddLogLine( false, GetResString(IDS_NOPARTSFOUND) );
	//
	VERIFY( m_srcwnd.CreateEx(0, AfxRegisterWndClass(0), _T("Hostname Resolve Wnd"), WS_OVERLAPPED, 0, 0, 0, 0, NULL, NULL) );
}

// New Code for CDownloadQueue::Process()
void CDownloadQueue::Process()
{
	uint32 downspeed = 0;
    uint64 maxDownload = thePrefs.GetMaxDownloadInBytesPerSec(true);
	// Download Limit
	if ( (rt_DownloadLimit != UNLIMITED) && (datarate > 1500) )
	{
		downspeed = (rt_DownloadLimit * 100) / (datarate + 1);
		if (downspeed < 50)
			downspeed = 50;
		else if (downspeed > 200)
			downspeed = 200;
	}
	//
	while ( (avarage_dr_list.GetCount() > 0) && ((GetTickCount() - avarage_dr_list.GetHead().timestamp) > 10*1000) )
		m_datarateMS -= avarage_dr_list.RemoveHead().datalen;
	
	if (avarage_dr_list.GetCount() > 1)
		datarate = m_datarateMS / avarage_dr_list.GetCount();
	else
		datarate = 0;

	uint32 datarateX=0;
	udcounter++;
	//
	switch (udcounter)
	{
		// send src requests to local server
		case 2:
			ProcessLocalRequests();
			break;
		// Server Status
		case 5:
			if (theApp.serverconnect->IsUDPSocketAvailable() == true)
			{
			    if ( (lastudpstattime != 0) || ((::GetTickCount() - lastudpstattime) > UDPSERVERSTATTIME) )
				{
					lastudpstattime = ::GetTickCount();
					theApp.serverlist->ServerStats();
				}
			}
			break;
		// Check DiskSpace
		case 8:
			CheckDiskspaceTimed();
			break;
		// Server Reask
		case 10:
			if (theApp.serverconnect->IsUDPSocketAvailable() == true)
			{
				if ( (lastudpsearchtime != 0) || ((::GetTickCount() - lastudpsearchtime) > UDPSERVERREASKTIME) )
					SendNextUDPPacket();
			}
			break;
		case 11:
			udcounter = 0;
	}
	//filelist is already sorted by prio, therefore I removed all the extra loops..
	POSITION ListPos = filelist.GetHeadPosition();
	while (ListPos != NULL)
	{
		CPartFile* CurrentFile = filelist.GetNext(ListPos);
		if ( (CurrentFile->GetStatus() == PS_READY) || (CurrentFile->GetStatus() == PS_EMPTY) )
			datarateX += CurrentFile->Process(downspeed, udcounter);
		else
			CurrentFile->StopPausedFile();
	}

	TransferredData newitem = {datarateX, ::GetTickCount()};
	avarage_dr_list.AddTail(newitem);
	m_datarateMS += datarateX;
}
//*/

//
void CDownloadQueue::StartNextFileIfPrefs(int cat)
{
    if (thePrefs.StartNextFile() > 0)
	{
        int catTemp = thePrefs.StartNextFile() > 1 ? cat : -1;
        bool force = thePrefs.StartNextFile() == 3 ? false:true;

		StartNextFile(catTemp, force);
    }
}

// New Code for Start Next File
// 1 = Start Next File
// 2 = Start Next File--Prefer the same Category
// 3 = Start Next File--Only in the same Category
void CDownloadQueue::StartNextFile(int Category, bool force)
{
	CPartFile* NextFile = NULL;
	CPartFile* CurrentFile;
	POSITION Pos;
	int StartBy = thePrefs.GetStartNextFileBy();
	int StartLevel;
	if (force == false)
		StartLevel = 3;
	else if (Category == -1)
		StartLevel = 1;
	else
		StartLevel = 2;
	bool IsSameCat = (StartLevel == 3);
	bool IsGetAllcatType = (thePrefs.GetAllcatType() == 0);
	Pos = filelist.GetHeadPosition();
	while (Pos != NULL)
	{
		CurrentFile = filelist.GetNext(Pos);
		if ( (CurrentFile->GetStatus() == PS_PAUSED) &&
			((CurrentFile->IsStopped() == false) || (thePrefs.IsIncludeStoppedFile() == true)) )
		{
			if ( (IsSameCat == false) || (CurrentFile->GetCategory() == Category) || 
				((Category == 0) && IsGetAllcatType && (CurrentFile->GetCategory() > 0)) )
			{				
				if (NextFile == NULL)
				{
					NextFile = CurrentFile;
					if ( (StartBy == RT_BY_PRIORITY) && (NextFile->GetDownPriority() == PR_VERYHIGH) )
					{
						if ( (StartLevel == 1) || (NextFile->GetCategory() == Category) )   break;
					}
					// Prefer Same Category
					if ( (NextFile->GetCategory() == Category) && (StartLevel == 2) )   IsSameCat = true;
				}
				else
				{
					// Prefer Same Category
					if ( (IsSameCat == false) && (StartLevel == 2) && (CurrentFile->GetCategory() == Category) )
					{
						NextFile = CurrentFile;
						if ( (StartBy == RT_BY_PRIORITY) && (NextFile->GetDownPriority() == PR_VERYHIGH) )   break;
						IsSameCat = true;
					}
					else
					{
						switch (StartBy)
						{
							case RT_BY_PRIORITY:
							{
								if (ComparePriority(CurrentFile->GetDownPriority(), NextFile->GetDownPriority()) == 1)
								{
									NextFile = CurrentFile;
									if (NextFile->GetDownPriority() == PR_VERYHIGH)
									{
										if ( (StartLevel == 1) || (NextFile->GetCategory() == Category) )   break;
									}
								}
								break;
							}
							case RT_BY_FILENAME:
							{
								if (NextFile->GetFileName().CompareNoCase(CurrentFile->GetFileName()) == 1)
									NextFile = CurrentFile;
								break;
							}
							case RT_BY_FILESIZE:
							{
								if ( NextFile->GetFileSize() > CurrentFile->GetFileSize() )
									NextFile = CurrentFile;
								break;
							}
							case RT_BY_REMAINING:
							{
								if ( NextFile->GetPercentCompleted() < CurrentFile->GetPercentCompleted() )
									NextFile = CurrentFile;
								break;
							}
						}
					}
				}
			}
		}
	}
	// Check Free Space When Resume
	if (NextFile != NULL)
	{
		if (PreCheckFreeDiskspace(NextFile) == true)
		{
			NextFile->ResumeFile();
		}
	}
}

// Download Limit
void CDownloadQueue::SetDownloadLimit(uint32 UploadSpeed)
{
	if (UploadSpeed < 9500)
	{
		if (rt_LastChangeTimeDL == 0)
		{
			rt_LastChangeTimeDL = ::GetTickCount();
			return;
		}
		if ( (::GetTickCount() - rt_LastChangeTimeDL) > 15000 )
		{
			if (UploadSpeed < 3500)
				rt_DownloadLimit = UploadSpeed * 3;
			else
				rt_DownloadLimit = UploadSpeed * 4;
			if ( (UploadSpeed != 0) || (theApp.uploadqueue->GetWaitingUserCount() > 0) ||
				(theApp.uploadqueue->GetUploadQueueLength() > 0) )
			{
				return;
			}
		}
		else
			return;
	}
	rt_LastChangeTimeDL = 0;
	if (thePrefs.GetMaxDownload() != UNLIMITED)
		rt_DownloadLimit = thePrefs.GetMaxDownload() * 1024;
	else
		rt_DownloadLimit = UNLIMITED;
}

// Category Temporary Directory
void CDownloadQueue::AddSearchToDownload(CSearchFile* SearchFile, uint8 Paused, uint8 Category)
{
	// Check File Existing
	if (IsFileExisting(SearchFile->GetFileHash()) == true)   return;
	// Check Recorded Filehash
	if (theApp.DownloadedFile->IsDownloadedFile(SearchFile->GetFileHash()) == true)   return;
	// Check Fake File
	if (theApp.FakeFile->IsFakeFile(SearchFile->GetFileHash()) == true)   return;
	//
	CPartFile* NewFile = new CPartFile(SearchFile, Category);
	if (NewFile->GetStatus() == PS_ERROR)
	{
		delete NewFile;
		return;
	}
	NewFile->SetCategory(Category);
	if (Paused == 2)   Paused = uint8(thePrefs.AddNewFilesPaused());
	AddDownload( NewFile, (Paused==1) );

	// If the search result is from OP_GLOBSEARCHRES there may also be a source
	if (SearchFile->GetClientID() && SearchFile->GetClientPort())
	{
		CSafeMemFile Sources(1+4+2);
		try
		{
			Sources.WriteUInt8(1);
			Sources.WriteUInt32(SearchFile->GetClientID());
			Sources.WriteUInt16(SearchFile->GetClientPort());
		    Sources.SeekToBegin();
		    NewFile->AddSources(&Sources, SearchFile->GetClientServerIP(), SearchFile->GetClientServerPort());
		}
		catch(CFileException* error)
		{
			ASSERT(0);
			error->Delete();
		}
	}

	// Add more sources which were found via global UDP search
	const CSimpleArray<CSearchFile::SClient>& aClients = SearchFile->GetClients();
	for (int i = 0; i < aClients.GetSize(); i++)
	{
		CSafeMemFile Sources(1+4+2);
		try
		{
			Sources.WriteUInt8(1);
			Sources.WriteUInt32(aClients[i].m_nIP);
			Sources.WriteUInt16(aClients[i].m_nPort);
		    Sources.SeekToBegin();
			NewFile->AddSources(&Sources, aClients[i].m_nServerIP, aClients[i].m_nServerPort);
	    }
		catch(CFileException* error)
		{
			ASSERT(0);
			error->Delete();
			break;
		}
	}
}

// Category Temporary Directory
void CDownloadQueue::AddSearchToDownload(CString Link,uint8 Paused, uint8 Category)
{
	CED2KLink* pLink = CED2KLink::CreateLinkFromUrl(Link);
	if (pLink != NULL)
	{
		CED2KFileLink* pFileLink = pLink->GetFileLink();
		if (pFileLink != NULL)
		{
			// Check Recorded Filehash
			if (theApp.DownloadedFile->IsDownloadedFile(pFileLink->GetHashKey()) == true)
			{
				delete pLink;
				return;
			}
			// Check Fake File
			if (theApp.FakeFile->IsFakeFile(pFileLink->GetHashKey()) == true)
			{
				delete pLink;
				return;
			}
		}
	}
	delete pLink;
	//
	CPartFile* NewFile = new CPartFile(Link, Category);
	if (NewFile->GetStatus() == PS_ERROR)
	{
		delete NewFile;
		return;
	}
	NewFile->SetCategory(Category);
	if (Paused == 2)
		Paused = uint8(thePrefs.AddNewFilesPaused());
	AddDownload( NewFile, (Paused==1) );
}

// Category Temporary Directory
void CDownloadQueue::AddFileLinkToDownload(CED2KFileLink* FileLink, uint8 Category)
{
	// Check File Existing
	if (IsFileExisting(FileLink->GetHashKey()) == true)   return;
	// Check Recorded Filehash
	if (theApp.DownloadedFile->IsDownloadedFile(FileLink->GetHashKey()) == true)   return;
	// Check Fake File
	if (theApp.FakeFile->IsFakeFile(FileLink->GetHashKey()) == true)   return;
	//
	CPartFile* NewFile = new CPartFile(FileLink, Category);
	if (NewFile->GetStatus() == PS_ERROR)
	{
		delete NewFile;
		NewFile = NULL;
	}
	else
	{
		NewFile->SetCategory(Category);
		AddDownload(NewFile, thePrefs.AddNewFilesPaused());
	}
	// Source and AICH Hash
	CPartFile* DownloadingFile = NewFile;
	if (DownloadingFile == NULL)   DownloadingFile = GetFileByID(FileLink->GetHashKey());
	if (DownloadingFile)
	{
		if (FileLink->HasValidSources() == true)
			DownloadingFile->AddClientSources(FileLink->SourcesList, 1);
		if (FileLink->HasValidAICHHash() == true)
		{
			if ( (DownloadingFile->GetAICHHashset()->HasValidMasterHash() == false) ||
				(DownloadingFile->GetAICHHashset()->GetMasterHash() != FileLink->GetAICHHash()) )
			{
				DownloadingFile->GetAICHHashset()->SetMasterHash(FileLink->GetAICHHash(), AICH_VERIFIED);
				DownloadingFile->GetAICHHashset()->FreeHashSet();
			}
		}
	}
	// Hostname Source
	if (FileLink->HasHostnameSources() == true)
	{
		POSITION ListPos = FileLink->m_HostnameSourcesList.GetHeadPosition();
		while (ListPos != NULL)
		{
			const SUnresolvedHostname* Host = FileLink->m_HostnameSourcesList.GetNext(ListPos);
			m_srcwnd.AddToResolve(FileLink->GetHashKey(), Host->strHostname, Host->nPort, Host->strURL);
		}
	}
}

// New Code for ExportPartMetFilesOverview()
void CDownloadQueue::ExportPartMetFilesOverview() const
{
	return;
}

// PreCheck Free Diskspace
bool CDownloadQueue::PreCheckFreeDiskspace(CPartFile* CheckFile) const
{
	if (thePrefs.IsPreCheckDiskspace() == false)   return true;
	// File Status
	switch ( CheckFile->GetStatus() )
	{
		case PS_PAUSED:
		case PS_ERROR:
		case PS_COMPLETING:
		case PS_COMPLETE:
			return true;
	}
	//
	if ( CheckFile->GetRealFileSize() >= uint64(CheckFile->GetFileSize()) )   return true;
	uint64 DiskSpaceNeed = uint64(CheckFile->GetFileSize()) - CheckFile->GetRealFileSize();
	TCHAR DiskName = thePrefs.GetTempDir(CheckFile->GetCategory()).GetAt(0);
	uint64 DiskSpaceFree = GetFreeDiskSpaceX( thePrefs.GetTempDir(CheckFile->GetCategory()) );
	uint64 DiskSpaceAllow = DiskSpaceFree;
	POSITION ListPos = filelist.GetHeadPosition();
	while (ListPos != NULL)
	{
		CPartFile* CurrentFile = filelist.GetNext(ListPos);
		switch ( CurrentFile->GetStatus() )
		{
			case PS_PAUSED:
			case PS_ERROR:
			case PS_COMPLETING:
			case PS_COMPLETE:
				break;
			default:
				if ( (CurrentFile != CheckFile) &&
					(thePrefs.GetTempDir(CurrentFile->GetCategory()).GetAt(0) == DiskName) &&
					(CurrentFile->GetRealFileSize() < uint64(CurrentFile->GetFileSize())) )
				{
					uint64 SpaceNeeded = uint64(CurrentFile->GetFileSize()) - CurrentFile->GetRealFileSize();
					if (DiskSpaceAllow > SpaceNeeded)
						DiskSpaceAllow -= SpaceNeeded;
					else
					{
						DiskSpaceAllow = 0;
						ListPos = NULL;
					}
				}
		}
	}
	if (DiskSpaceAllow >= DiskSpaceNeed)
		return true;
	else
	{
		CString SpaceNeededMsg, TempBuffer;
		TempBuffer.Format( GetResString(RT_IDS_DISK_SPACE_STATUS), DiskName, CastItoXBytes(DiskSpaceFree),
							CastItoXBytes(DiskSpaceAllow), CastItoXBytes(DiskSpaceNeed), CheckFile->GetFileName() );
		SpaceNeededMsg.Format(GetResString(IDS_ERR_OUTOFSPACE), TempBuffer);
		AddLogLine(false, SpaceNeededMsg);
		theApp.emuledlg->ShowNotifier(SpaceNeededMsg, TBN_NULL, NULL, true);
		return false;
	}
}