//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include <io.h>
#include "emule.h"
#include "SharedFileList.h"
#include "KnownFileList.h"
#include "KnownFile.h"
#include "opcodes.h"
#include "Preferences.h"
#include "SafeFile.h"
#include "OtherFunctions.h"
#include "UpDownClient.h"
#include "DownloadQueue.h"
#include "emuledlg.h"
#include "TransferWnd.h"
#include "Log.h"
// RT, Include
#include "Ini2.h"
#include "shahashset.h"
#include "0RatioFile/RT_Other.h"
#include "0RatioFile/RT_Version.h"
static bool rt_IsInitialList;
// End

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define KNOWN_MET_FILENAME	_T("known.met")


CKnownFileList::CKnownFileList()
{
	m_Files_map.InitHashTable(1031);
	accepted = 0;
	requested = 0;
	transferred = 0;
	m_nLastSaved = ::GetTickCount();
// RT, Initial
	rt_IsInitialList = true;
	Init();
	rt_IsInitialList = false;
// Original	Init();
}

CKnownFileList::~CKnownFileList()
{
	Clear();
}

bool CKnownFileList::Init()
{
	CString fullpath=thePrefs.GetConfigDir();
	fullpath.Append(KNOWN_MET_FILENAME);
	CSafeBufferedFile file;
	CFileException fexp;
	if (!file.Open(fullpath,CFile::modeRead|CFile::osSequentialScan|CFile::typeBinary|CFile::shareDenyWrite, &fexp)){
		if (fexp.m_cause != CFileException::fileNotFound){
			CString strError(_T("Failed to load ") KNOWN_MET_FILENAME _T(" file"));
			TCHAR szError[MAX_CFEXP_ERRORMSG];
			if (fexp.GetErrorMessage(szError, ARRSIZE(szError))){
				strError += _T(" - ");
				strError += szError;
			}
			LogError(LOG_STATUSBAR, _T("%s"), strError);
		}
		return false;
	}
	setvbuf(file.m_pStream, NULL, _IOFBF, 16384);

	CKnownFile* pRecord = NULL;
	try {
		uint8 header = file.ReadUInt8();
		if (header != MET_HEADER){
			file.Close();
			return false;
		}

		UINT RecordsNumber = file.ReadUInt32();
		for (UINT i = 0; i < RecordsNumber; i++) {
			pRecord = new CKnownFile();
			if (!pRecord->LoadFromFile(&file)){
				TRACE(_T("*** Failed to load entry %u (name=%s  hash=%s  size=%u  parthashs=%u expected parthashs=%u) from known.met\n"), i, 
					pRecord->GetFileName(), md4str(pRecord->GetFileHash()), pRecord->GetFileSize(), pRecord->GetHashCount(), pRecord->GetED2KPartHashCount());
				delete pRecord;
				pRecord = NULL;
				continue;
			}
			SafeAddKFile(pRecord);
			pRecord = NULL;
		}
		file.Close();
	}
	catch(CFileException* error){
		if (error->m_cause == CFileException::endOfFile)
			LogError(LOG_STATUSBAR, GetResString(IDS_ERR_SERVERMET_BAD));
		else{
			TCHAR buffer[MAX_CFEXP_ERRORMSG];
			error->GetErrorMessage(buffer, ARRSIZE(buffer));
			LogError(LOG_STATUSBAR, GetResString(IDS_ERR_SERVERMET_UNKNOWN),buffer);
		}
		error->Delete();
		delete pRecord;
		return false;
	}

// RT, Initial
	RT_LoadKnownFileStatus();
	RT_CreatKnownFileHistory();
// End
	return true;
}

void CKnownFileList::Save()
{
	if (thePrefs.GetLogFileSaving())
		AddDebugLogLine(false, _T("Saving known files list file \"%s\""), KNOWN_MET_FILENAME);
	m_nLastSaved = ::GetTickCount(); 
	CString fullpath=thePrefs.GetConfigDir();
	fullpath += KNOWN_MET_FILENAME;
	CSafeBufferedFile file;
	CFileException fexp;
// RT, Backup
	CString BackupFile = fullpath + CString( _T(".bak") );
	if (PathFileExists(fullpath) == TRUE)
	{
		if (PathFileExists(BackupFile) == TRUE)   _tremove(BackupFile);
		_trename(fullpath, BackupFile);
	}
// End
	if (!file.Open(fullpath, CFile::modeWrite|CFile::modeCreate|CFile::typeBinary|CFile::shareDenyWrite, &fexp)){
		CString strError(_T("Failed to save ") KNOWN_MET_FILENAME _T(" file"));
		TCHAR szError[MAX_CFEXP_ERRORMSG];
		if (fexp.GetErrorMessage(szError, ARRSIZE(szError))){
			strError += _T(" - ");
			strError += szError;
		}
		LogError(LOG_STATUSBAR, _T("%s"), strError);
		return;
	}
	setvbuf(file.m_pStream, NULL, _IOFBF, 16384);

// RT, Flag of Normal Exit
	thePrefs.SetNormalExit( _T("KnownFiles"), false );
// End
	try{
		file.WriteUInt8(MET_HEADER);

		UINT nRecordsNumber = m_Files_map.GetCount();
		file.WriteUInt32(nRecordsNumber);
// RT, Delete Data of Unshared File
		uint32 ExpiredTime = DAY2S(30);
		UINT NewRecordsNumber = 0;
		POSITION PosNext = m_Files_map.GetStartPosition();
		while (PosNext != NULL)
		{
			CKnownFile* CurrentFile;
			CCKey KeyTemp;
			m_Files_map.GetNextAssoc(PosNext, KeyTemp, CurrentFile);
			if ( (theApp.emuledlg->IsRunning() == true) ||
				(theApp.sharedfiles->GetFileByID(CurrentFile->GetFileHash()) != NULL) ||
				(uint32(time(NULL) - CurrentFile->GetLastUploadTime()) < ExpiredTime) )
			{
				CurrentFile->WriteToFile(&file);
				NewRecordsNumber++;
			}
		}
		if (NewRecordsNumber != nRecordsNumber)
		{
			file.Seek(sizeof(uint8), 0);
			file.WriteUInt32(NewRecordsNumber);
			if (thePrefs.IsLogRatioVerbose() == true)
				AddLogLine( false, _T(">> [RT Debug] Saved Known Files List. Before Clear = %u, After Clear = %u"), nRecordsNumber, NewRecordsNumber );
			// Delete AICH of Unshared File
			if (theApp.m_app_state == APP_STATE_SHUTINGDOWN)   RT_DeleteUnsharedAICH();
		}
/* Original
		POSITION pos = m_Files_map.GetStartPosition();
		while( pos != NULL )
		{
			CKnownFile* pFile;
			CCKey key;
			m_Files_map.GetNextAssoc( pos, key, pFile );
			pFile->WriteToFile(&file);
		}
*/
		if (thePrefs.GetCommitFiles() >= 2 || (thePrefs.GetCommitFiles() >= 1 && !theApp.emuledlg->IsRunning())){
			file.Flush(); // flush file stream buffers to disk buffers
			if (_commit(_fileno(file.m_pStream)) != 0) // commit disk buffers to disk
				AfxThrowFileException(CFileException::hardIO, GetLastError(), file.GetFileName());
		}
		file.Close();
// RT, Save RT Settings
		RT_SaveKnownFileStatus();
// End
	}
	catch(CFileException* error){
		CString strError(_T("Failed to save ") KNOWN_MET_FILENAME _T(" file"));
		TCHAR szError[MAX_CFEXP_ERRORMSG];
		if (error->GetErrorMessage(szError, ARRSIZE(szError))){
			strError += _T(" - ");
			strError += szError;
		}
		LogError(LOG_STATUSBAR, _T("%s"), strError);
		error->Delete();
// RT, Delete File
		if (PathFileExists(fullpath) == TRUE)   _tremove(fullpath);
		// Restore File
		if (PathFileExists(BackupFile) == TRUE)   _trename(BackupFile, fullpath);
	}
	// Flag of Normal Exit
	thePrefs.SetNormalExit( _T("KnownFiles"), true );
}
/* Original
	}
}
*/

void CKnownFileList::Clear()
{
	POSITION pos = m_Files_map.GetStartPosition();
	while( pos != NULL )
	{
		CKnownFile* pFile;
		CCKey key;
		m_Files_map.GetNextAssoc( pos, key, pFile );
	    delete pFile;
	}
	m_Files_map.RemoveAll();
}

void CKnownFileList::Process()
{
	if (::GetTickCount() - m_nLastSaved > MIN2MS(11))
		Save();
}

bool CKnownFileList::SafeAddKFile(CKnownFile* toadd)
{
	CCKey key(toadd->GetFileHash());
	CKnownFile* pFileInMap;
	if (m_Files_map.Lookup(key, pFileInMap))
	{
		TRACE(_T("%hs: File already in known file list: %s \"%s\" \"%s\"\n"), __FUNCTION__, md4str(pFileInMap->GetFileHash()), pFileInMap->GetFileName(), pFileInMap->GetFilePath());
		TRACE(_T("%hs: Old entry replaced with:         %s \"%s\" \"%s\"\n"), __FUNCTION__, md4str(toadd->GetFileHash()), toadd->GetFileName(), toadd->GetFilePath());
#if 1
		// if we hash files which are already in known file list and add them later (when the hashing thread is finished),
		// we can not delete any already available entry from known files list. that entry can already be used by the
		// shared file list -> crash.

		m_Files_map.RemoveKey(CCKey(pFileInMap->GetFileHash()));
		//This can happen in a couple situations..
		//File was renamed outside of eMule.. 
		//A user decided to redownload a file he has downloaded and unshared..
		//RemovingKeyWords I believe is not thread safe if I'm looking at this right.
		//Not sure of a good solution yet..
		if (theApp.sharedfiles)
		{
			theApp.sharedfiles->RemoveKeywords(pFileInMap);
			ASSERT( !theApp.sharedfiles->IsFilePtrInList(pFileInMap) );
		}
		//Double check to make sure this is the same file as it's possible that a two files have the same hash.
		//Maybe in the furture we can change the client to not just use Hash as a key throughout the entire client..
		ASSERT( toadd->GetFileSize() == pFileInMap->GetFileSize() );
		ASSERT( toadd != pFileInMap );
		if (toadd->GetFileSize() == pFileInMap->GetFileSize())
			toadd->statistic.MergeFileStats(&pFileInMap->statistic);

		ASSERT( theApp.sharedfiles==NULL || !theApp.sharedfiles->IsFilePtrInList(pFileInMap) );
		ASSERT( theApp.downloadqueue==NULL || !theApp.downloadqueue->IsPartFile(pFileInMap) );

		// Quick fix: If we downloaded already downloaded files again and if those files all had the same file names
		// and were renamed during file completion, we have a pending ptr in transfer window.
		if (theApp.emuledlg && theApp.emuledlg->transferwnd && theApp.emuledlg->transferwnd->downloadlistctrl.m_hWnd)
			theApp.emuledlg->transferwnd->downloadlistctrl.RemoveFile((CPartFile*)pFileInMap);

		delete pFileInMap;
#else
		// if the new entry is already in list, update the stats and return false, but do not delete the entry which is
		// alreay in known file list!
		ASSERT( toadd->GetFileSize() == pFileInMap->GetFileSize() );
		ASSERT( toadd != pFileInMap );
		if (toadd->GetFileSize() == pFileInMap->GetFileSize() && toadd != pFileInMap)
		{
			pFileInMap->statistic.MergeFileStats(&toadd->statistic);
			pFileInMap->SetFileName(toadd->GetFileName(), false);
			pFileInMap->SetPath(toadd->GetPath());
			pFileInMap->SetFilePath(toadd->GetFilePath());
			pFileInMap->date = toadd->date;
		}
		ASSERT( !theApp.sharedfiles->IsFilePtrInList(pFileInMap) );
		ASSERT( theApp.sharedfiles->IsFilePtrInList(toadd) );
		return false;
#endif
	}
	m_Files_map.SetAt(key, toadd);
// RT, Recorde Filehash
	if (rt_IsInitialList == false)
	{
		CString Information;
		Information.Format( _T("[ed2k://|file|%s|%u|%s|/]"),
							StripInvalidFilenameChars(toadd->GetFileName(), true),
							toadd->GetFileSize(),
							md4str(toadd->GetFileHash()) );
		theApp.DownloadedFile->RecordeFile(toadd->GetFileHash(), Information);
		if (thePrefs.IsLogRatioVerbose() == true)
			AddDebugLogLine( false, _T(">> [RT Debug] Recorde File. { %s } { %s }"), md4str(toadd->GetFileHash()), toadd->GetFileName() );
	}
// End
	return true;
}

CKnownFile* CKnownFileList::FindKnownFile(LPCTSTR filename, uint32 date, uint32 size) const
{
	POSITION pos = m_Files_map.GetStartPosition();
	while (pos != NULL)
	{
		CKnownFile* cur_file;
		CCKey key;
		m_Files_map.GetNextAssoc(pos, key, cur_file);
		if (cur_file->GetUtcFileDate() == date && cur_file->GetFileSize() == size && !_tcscmp(filename, cur_file->GetFileName()))
			return cur_file;
	}
	return NULL;
}

CKnownFile* CKnownFileList::FindKnownFileByID(const uchar* hash) const
{
	if (hash)
	{
		CKnownFile* found_file;
		CCKey key(hash);
		if (m_Files_map.Lookup(key, found_file))
			return found_file;
	}
	return NULL;
}

bool CKnownFileList::IsKnownFile(const CKnownFile* file) const
{
	if (file)
		return FindKnownFileByID(file->GetFileHash()) != NULL;
	return false;
}

bool CKnownFileList::IsFilePtrInList(const CKnownFile* file) const
{
	if (file)
	{
		POSITION pos = m_Files_map.GetStartPosition();
		while (pos)
		{
			CCKey key;
			CKnownFile* cur_file;
			m_Files_map.GetNextAssoc(pos, key, cur_file);
			if (file == cur_file)
				return true;
		}
	}
	return false;
}

//*************
// RT, New Code
//-------------
void CKnownFileList::RT_LoadKnownFileStatus()
{
	// Initial
	CString Filename, Buffer, Data;
	Filename.Format( _T("%sRT_KnownFile.ini"), thePrefs.GetConfigDir() );
	CIni RatioIni( Filename, _T("General") );
	// Load
	CKnownFile* CurrentFile;
	CCKey TempKey;
	uint32 Feature;
	POSITION MapPos = m_Files_map.GetStartPosition();
	while (MapPos != NULL)
	{
		m_Files_map.GetNextAssoc(MapPos, TempKey, CurrentFile);
		Buffer = RatioIni.GetString( md4str(CurrentFile->GetFileHash()), _T(""), _T("FileStatus") );
		int BufferPos = 0;
		// Uploaded Status
		if ( Buffer.GetAt(0) != _T(',') )
			Data = Buffer.Tokenize(_T(","), BufferPos);
		else
		{
			BufferPos++;
			Data.Empty();
		}
		CurrentFile->SetUploadedStatus(Data);
		// Last Upload Time
		if (BufferPos >= 0)   Data = Buffer.Tokenize(_T(","), BufferPos);
		if (BufferPos >= 0)
			CurrentFile->SetLastUploadTime( _tstol(Data) );
		else
			CurrentFile->ResetLastUploadTime();
		// Feature
		if (BufferPos >= 0)   Data = Buffer.Tokenize(_T(","), BufferPos);
		if (BufferPos >= 0)
			Feature = _tstol(Data);
		else
			Feature = 0;
		CurrentFile->SetReleaseRarestPart( (Feature & RT_FF_RELEASE_RAREST_PART) );
		CurrentFile->SetReleaseFile( (Feature & RT_FF_RELEASE_PRIORITY) );
	}
}

void CKnownFileList::RT_SaveKnownFileStatus()
{
	// Initial
	CString Filename, Buffer;
	Filename.Format( _T("%sRT_KnownFile.ini"), thePrefs.GetConfigDir() );
	RatioAppendINI HistoryFile;
	if (HistoryFile.OpenFile(Filename, _T("w")) == true)
	{
		HistoryFile.WriteSection( _T("General") );
		HistoryFile.Write( _T("Version"), RT_KNOWN_FILE_VERSION );
		HistoryFile.WriteSection( _T("FileStatus") );
	}
	else
		return;
	// Save
	CKnownFile* CurrentFile;
	CCKey TempKey;
	POSITION MapPos = m_Files_map.GetStartPosition();
	while (MapPos != NULL)
	{
		m_Files_map.GetNextAssoc( MapPos, TempKey, CurrentFile );
		// Feature
		uint32 Feature = 0;
		// bit1 = Release Rarest Part
		if (CurrentFile->IsReleaseRarestPart() == true)   Feature |= RT_FF_RELEASE_RAREST_PART;
		// bit2 = Unuse
		// bit3 = Release File
		if (CurrentFile->IsReleaseFile() == true)   Feature |= RT_FF_RELEASE_PRIORITY;
		//
		Buffer.Format( _T("%s=%s,%u,%u\r\n"), md4str(CurrentFile->GetFileHash()), CurrentFile->GetUploadedStatus(),
											CurrentFile->GetLastUploadTime(), Feature );
		HistoryFile.Write(Buffer);
	}
	HistoryFile.CloseFile();
}

void CKnownFileList::RT_CreatKnownFileHistory()
{
	// Initial
	CString Filename, Buffer;
	Filename.Format( _T("%sRT_History.ini"), thePrefs.GetConfigDir() );
	CIni RatioIni( Filename, _T("History") );
	uint16 HistoryVersion = RatioIni.GetInt( _T("HistoryVersion"), 0, _T("General") );
	if (HistoryVersion != 0)   return;
	RatioAppendINI HistoryFile;
	if (HistoryFile.OpenFile(Filename, _T("w")) == true)
	{
		HistoryFile.WriteSection( _T("General") );
		HistoryFile.Write( _T("HistoryVersion"), RT_HISTORY_VERSION );
		HistoryFile.WriteSection( _T("History") );
	}
	else
		return;
	// Recorde Filehash
	CKnownFile* CurrentFile;
	CCKey TempKey;
	POSITION MapPos = m_Files_map.GetStartPosition();
	while (MapPos != NULL)
	{
		m_Files_map.GetNextAssoc(MapPos, TempKey, CurrentFile);
		if (HistoryFile.IsOpenFile() == true)
		{
			Buffer.Format( _T("%s=[ed2k://|file|%s|%u|%s|/]\r\n"),
							md4str(CurrentFile->GetFileHash()),
							StripInvalidFilenameChars(CurrentFile->GetFileName(), true),
							CurrentFile->GetFileSize(),
							md4str(CurrentFile->GetFileHash()) );
			HistoryFile.Write( Buffer );
#ifdef _DEBUG
			if (thePrefs.IsLogRatioVerbose() == true)
				AddDebugLogLine(false, _T(">> [RT Debug] Recorde Filehash. { %s } { %s }"), md4str(CurrentFile->GetFileHash()) , CurrentFile->GetFileName() );
#endif
		}
	}
	HistoryFile.CloseFile();
}

void CKnownFileList::RT_DeleteUnsharedAICH()
{
	CString Filename;
	Filename.Format( _T("%sknown2.met"), thePrefs.GetConfigDir() );
	CSafeFile Known2File;
	CFileException fexp;
	if (Known2File.Open(Filename, CFile::modeCreate|CFile::modeRead|CFile::modeNoTruncate|CFile::osSequentialScan|CFile::typeBinary|CFile::shareDenyNone, &fexp) == FALSE)
	{
		if (fexp.m_cause != CFileException::fileNotFound)
		{
			CString strError( _T("Failed to load ") KNOWN2_MET_FILENAME _T(" file") );
			TCHAR szError[MAX_CFEXP_ERRORMSG];
			if (fexp.GetErrorMessage(szError, ARRSIZE(szError)) == FALSE)
			{
				strError += _T(" - ");
				strError += szError;
			}
			theApp.QueueLogLine(true, _T("%s"), strError);
		}
		return;
	}
	BYTE* Buffer = NULL;
	try
	{
		uint32 ExpiredTime = DAY2S(7);
		CAICHHash CurrentHash;
		uint32 ExistingSize = Known2File.GetLength();
		uint16 HashCount;
		CSafeMemFile BufferFile;
		while (Known2File.GetPosition() < ExistingSize)
		{
			CurrentHash.Read(&Known2File);
			HashCount = Known2File.ReadUInt16();
			uint32 BufferSize = HashCount * HASHSIZE;
			if ( (Known2File.GetPosition() + BufferSize) > ExistingSize )
			{
				AfxThrowFileException( CFileException::endOfFile, 0, Known2File.GetFileName() );
			}
			//
			bool IsFound = false;
			POSITION PosNext = m_Files_map.GetStartPosition();
			while (PosNext != NULL)
			{
				CKnownFile* CurrentFile;
				CCKey KeyTemp;
				m_Files_map.GetNextAssoc(PosNext, KeyTemp, CurrentFile);
				if ( (theApp.sharedfiles->GetFileByID(CurrentFile->GetFileHash()) != NULL) ||
					(uint32(time(NULL) - CurrentFile->GetLastUploadTime()) < ExpiredTime) )
				{
					if (CurrentFile->GetAICHHashset()->GetMasterHash() == CurrentHash)
					{
						Buffer = new BYTE[BufferSize];
						Known2File.Read(Buffer, BufferSize);
						BufferFile.Write( CurrentHash.GetRawHash(), HASHSIZE );
						BufferFile.WriteUInt16(HashCount);
						BufferFile.Write(Buffer, BufferSize);
						delete [] Buffer;
						Buffer = NULL;
						IsFound = true;
						break;
					}
				}
			}
			// Not Found
			if (IsFound == false)
			{
				// skip the rest of this hashset
				Known2File.Seek( BufferSize, CFile::current );
			}
		}
		Known2File.Close();
		// Write to Disk
		if (BufferFile.GetLength() > 0)
		{
			CString TargetFilename;
			TargetFilename.Format( _T("%sknown2_met.tmp"), thePrefs.GetConfigDir() );
			CFile TargetFile;
			CFileException FileEx;
			if (TargetFile.Open(TargetFilename, CFile::modeWrite | CFile::modeCreate | CFile::typeBinary, &FileEx) == TRUE)
			{
				TargetFile.Write( BufferFile.GetBuffer(), BufferFile.GetLength() );
				TargetFile.Flush();
				TargetFile.Close();
				_tremove(Filename);
				_trename(TargetFilename, Filename);
			}
		}
		else
			_tremove(Filename);
		BufferFile.Close();
	}
	catch (CFileException* error)
	{
		if (error->m_cause == CFileException::endOfFile)
			theApp.QueueLogLine( true, GetResString(IDS_ERR_SERVERMET_BAD) );
		else
		{
			TCHAR buffer[MAX_CFEXP_ERRORMSG];
			error->GetErrorMessage( buffer, ARRSIZE(buffer) );
			theApp.QueueLogLine(true, GetResString(IDS_ERR_SERVERMET_UNKNOWN), buffer);
		}
		error->Delete();
	}
	if (Buffer != NULL)   delete [] Buffer;
}