//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include <io.h>
#include <share.h>
#include "emule.h"
#include "Preferences.h"
#include "Opcodes.h"
#include "OtherFunctions.h"
#include "Ini2.h"
#include "DownloadQueue.h"
#include "UploadQueue.h"
#include "Statistics.h"
#include "MD5Sum.h"
#include "PartFile.h"
#include "Sockets.h"
#include "ListenSocket.h"
#include "ServerList.h"
#include "SharedFileList.h"
#include "UpDownClient.h"
#include "SafeFile.h"
#include "emuledlg.h"
#include "StatisticsDlg.h"
#include "Log.h"
#include "MuleToolbarCtrl.h"
// RT, Include
#include "math.h"
#include "ClientCredits.h"
#include "UploadBandwidthThrottler.h"
#include "0RatioFile/RT_Other.h"
#include "0RatioFile/RT_Version.h"
#include "0RatioFile/RT_Opcodes.h"
// End

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#pragma pack(1)
struct Preferences_Import19c_Struct{
	uint8	version;
	char	nick[50];
	uint16	maxupload;
	uint16	maxdownload;
	uint16	port;
	uint16	maxconnections;
	uint8	reconnect;
	uint8	deadserver;
	uint8	scorsystem;
	char	incomingdir[510];
	char	tempdir[510];
	uint8	ICH;
	uint8	autoserverlist;
	uint8	updatenotify;
	uint8	mintotray;
	uchar	userhash[16];
	uint8	autoconnect;
	uint8	addserversfromserver;
	uint8	addserversfromclient;
};
#pragma pack()

#pragma pack(1)
struct Preferences_Import20a_Struct{
	uint8	version;
	char	nick[50];
	uint16	maxupload;
	uint16	maxdownload;
	uint16	port;
	uint16	maxconnections;
	uint8	reconnect;
	uint8	deadserver;
	uint16	deadserverretries;
	uint8	scorsystem;
	char	incomingdir[510];
	char	tempdir[510];
	uint8	ICH;
	uint8	autoserverlist;
	uint8	updatenotify;
	uint8	mintotray;
	uchar	userhash[16];
	uint8	autoconnect;
	uint8	addserversfromserver;
	uint8	addserversfromclient;
	uint16	maxsourceperfile;
	uint16	trafficOMeterInterval;
	uint32	totalDownloaded;
	uint32	totalUploaded;
	int		maxGraphDownloadRate;
	int		maxGraphUploadRate;
	uint8	beepOnError;
	uint8	confirmExit;
	WINDOWPLACEMENT EmuleWindowPlacement;
	int transferColumnWidths[9];
	int serverColumnWidths[8];
	uint8	splashscreen;
	uint8	filterLANIPs;
};
#pragma pack()

#pragma pack(1)
struct Preferences_Import20b_Struct{
	uint8	version;
	char	nick[50];
	uint16	maxupload;
	uint16	maxdownload;
	uint16	port;
	uint16	maxconnections;
	uint8	reconnect;
	uint8	deadserver;
	uint8	scorsystem;
	char	incomingdir[510];
	char	tempdir[510];
	uint8	ICH;
	uint8	autoserverlist;
	uint8	updatenotify;
	uint8	mintotray;
	uchar	userhash[16];
	uint8	autoconnect;
	uint8	addserversfromserver;
	uint8	addserversfromclient;
	uint16	maxsourceperfile;
	uint16	trafficOMeterInterval;
	uint32	totalDownloaded;	// outdated
	uint32	totalUploaded;		// outdated
	int		maxGraphDownloadRate;
	int		maxGraphUploadRate;
	uint8	beepOnError;
	uint8	confirmExit;
	WINDOWPLACEMENT EmuleWindowPlacement;
	int transferColumnWidths[9];
	int serverColumnWidths[8];
	uint8	splashscreen;
	uint8	filterLANIPs;
	uint64	totalDownloadedBytes;
	uint64	totalUploadedBytes;
};
#pragma pack()

CPreferences thePrefs;

int		CPreferences::m_iDbgHeap;
CString	CPreferences::strNick;
uint16	CPreferences::minupload;
uint16	CPreferences::maxupload;
uint16	CPreferences::maxdownload;
uint16	CPreferences::port;
uint16	CPreferences::udpport;
uint16	CPreferences::nServerUDPPort;
uint16	CPreferences::maxconnections;
uint16	CPreferences::maxhalfconnections;
uint8	CPreferences::reconnect;
uint8	CPreferences::scorsystem;
TCHAR	CPreferences::incomingdir[MAX_PATH];
TCHAR	CPreferences::tempdir[MAX_PATH];
uint8	CPreferences::ICH;
uint8	CPreferences::autoserverlist;
uint8	CPreferences::updatenotify;
uint8	CPreferences::mintotray;
uint8	CPreferences::autoconnect;
uint8	CPreferences::autoconnectstaticonly;
uint8	CPreferences::autotakeed2klinks;
uint8	CPreferences::addnewfilespaused;
uint8	CPreferences::depth3D;
bool	CPreferences::m_bEnableMiniMule;
int		CPreferences::m_iStraightWindowStyles;
CString	CPreferences::m_strSkinProfile;
CString	CPreferences::m_strSkinProfileDir;
uint8	CPreferences::addserversfromserver;
uint8	CPreferences::addserversfromclient;
uint16	CPreferences::maxsourceperfile;
uint16	CPreferences::trafficOMeterInterval;
uint16	CPreferences::statsInterval;
uchar	CPreferences::userhash[16];
WINDOWPLACEMENT CPreferences::EmuleWindowPlacement;
int		CPreferences::maxGraphDownloadRate;
int		CPreferences::maxGraphUploadRate;
uint8	CPreferences::beepOnError;
uint8	CPreferences::confirmExit;
// RT, New Code at Bottom
/* Official
uint16	CPreferences::downloadColumnWidths[13];
BOOL	CPreferences::downloadColumnHidden[13];
INT		CPreferences::downloadColumnOrder[13];
uint16	CPreferences::uploadColumnWidths[8];
BOOL	CPreferences::uploadColumnHidden[8];
INT		CPreferences::uploadColumnOrder[8];
uint16	CPreferences::queueColumnWidths[10];
BOOL	CPreferences::queueColumnHidden[10];
INT		CPreferences::queueColumnOrder[10];
uint16	CPreferences::searchColumnWidths[14];
BOOL	CPreferences::searchColumnHidden[14];
INT		CPreferences::searchColumnOrder[14];
uint16	CPreferences::sharedColumnWidths[12];
BOOL	CPreferences::sharedColumnHidden[12];
INT		CPreferences::sharedColumnOrder[12];
uint16	CPreferences::serverColumnWidths[14];
BOOL	CPreferences::serverColumnHidden[14];
INT		CPreferences::serverColumnOrder[14];
uint16	CPreferences::clientListColumnWidths[8];
BOOL	CPreferences::clientListColumnHidden[8];
INT		CPreferences::clientListColumnOrder[8];
*/
uint16	CPreferences::FilenamesListColumnWidths[2];
BOOL	CPreferences::FilenamesListColumnHidden[2];
INT		CPreferences::FilenamesListColumnOrder[2];
DWORD	CPreferences::m_adwStatsColors[15];
uint8	CPreferences::splashscreen;
uint8	CPreferences::filterLANIPs;
bool	CPreferences::m_bAllocLocalHostIP;
uint8	CPreferences::onlineSig;
uint64	CPreferences::cumDownOverheadTotal;
uint64	CPreferences::cumDownOverheadFileReq;
uint64	CPreferences::cumDownOverheadSrcEx;
uint64	CPreferences::cumDownOverheadServer;
uint64	CPreferences::cumDownOverheadKad;
uint64	CPreferences::cumDownOverheadTotalPackets;
uint64	CPreferences::cumDownOverheadFileReqPackets;
uint64	CPreferences::cumDownOverheadSrcExPackets;
uint64	CPreferences::cumDownOverheadServerPackets;
uint64	CPreferences::cumDownOverheadKadPackets;
uint64	CPreferences::cumUpOverheadTotal;
uint64	CPreferences::cumUpOverheadFileReq;
uint64	CPreferences::cumUpOverheadSrcEx;
uint64	CPreferences::cumUpOverheadServer;
uint64	CPreferences::cumUpOverheadKad;
uint64	CPreferences::cumUpOverheadTotalPackets;
uint64	CPreferences::cumUpOverheadFileReqPackets;
uint64	CPreferences::cumUpOverheadSrcExPackets;
uint64	CPreferences::cumUpOverheadServerPackets;
uint64	CPreferences::cumUpOverheadKadPackets;
uint32	CPreferences::cumUpSuccessfulSessions;
uint32	CPreferences::cumUpFailedSessions;
uint32	CPreferences::cumUpAvgTime;
uint64	CPreferences::cumUpData_EDONKEY;
uint64	CPreferences::cumUpData_EDONKEYHYBRID;
uint64	CPreferences::cumUpData_EMULE;
uint64	CPreferences::cumUpData_MLDONKEY;
uint64	CPreferences::cumUpData_AMULE;
uint64	CPreferences::cumUpData_EMULECOMPAT;
uint64	CPreferences::cumUpData_SHAREAZA;
uint64	CPreferences::sesUpData_EDONKEY;
uint64	CPreferences::sesUpData_EDONKEYHYBRID;
uint64	CPreferences::sesUpData_EMULE;
uint64	CPreferences::sesUpData_MLDONKEY;
uint64	CPreferences::sesUpData_AMULE;
uint64	CPreferences::sesUpData_EMULECOMPAT;
uint64	CPreferences::sesUpData_SHAREAZA;
uint64	CPreferences::cumUpDataPort_4662;
uint64	CPreferences::cumUpDataPort_OTHER;
uint64	CPreferences::cumUpDataPort_PeerCache;
uint64	CPreferences::sesUpDataPort_4662;
uint64	CPreferences::sesUpDataPort_OTHER;
uint64	CPreferences::sesUpDataPort_PeerCache;
uint64	CPreferences::cumUpData_File;
uint64	CPreferences::cumUpData_Partfile;
uint64	CPreferences::sesUpData_File;
uint64	CPreferences::sesUpData_Partfile;
uint32	CPreferences::cumDownCompletedFiles;
uint32	CPreferences::cumDownSuccessfulSessions;
uint32	CPreferences::cumDownFailedSessions;
uint32	CPreferences::cumDownAvgTime;
uint64	CPreferences::cumLostFromCorruption;
uint64	CPreferences::cumSavedFromCompression;
uint32	CPreferences::cumPartsSavedByICH;
uint32	CPreferences::sesDownSuccessfulSessions;
uint32	CPreferences::sesDownFailedSessions;
uint32	CPreferences::sesDownAvgTime;
uint32	CPreferences::sesDownCompletedFiles;
uint64	CPreferences::sesLostFromCorruption;
uint64	CPreferences::sesSavedFromCompression;
uint32	CPreferences::sesPartsSavedByICH;
uint64	CPreferences::cumDownData_EDONKEY;
uint64	CPreferences::cumDownData_EDONKEYHYBRID;
uint64	CPreferences::cumDownData_EMULE;
uint64	CPreferences::cumDownData_MLDONKEY;
uint64	CPreferences::cumDownData_AMULE;
uint64	CPreferences::cumDownData_EMULECOMPAT;
uint64	CPreferences::cumDownData_SHAREAZA;
uint64	CPreferences::cumDownData_URL;
uint64	CPreferences::sesDownData_EDONKEY;
uint64	CPreferences::sesDownData_EDONKEYHYBRID;
uint64	CPreferences::sesDownData_EMULE;
uint64	CPreferences::sesDownData_MLDONKEY;
uint64	CPreferences::sesDownData_AMULE;
uint64	CPreferences::sesDownData_EMULECOMPAT;
uint64	CPreferences::sesDownData_SHAREAZA;
uint64	CPreferences::sesDownData_URL;
uint64	CPreferences::cumDownDataPort_4662;
uint64	CPreferences::cumDownDataPort_OTHER;
uint64	CPreferences::cumDownDataPort_PeerCache;
uint64	CPreferences::sesDownDataPort_4662;
uint64	CPreferences::sesDownDataPort_OTHER;
uint64	CPreferences::sesDownDataPort_PeerCache;
float	CPreferences::cumConnAvgDownRate;
float	CPreferences::cumConnMaxAvgDownRate;
float	CPreferences::cumConnMaxDownRate;
float	CPreferences::cumConnAvgUpRate;
float	CPreferences::cumConnMaxAvgUpRate;
float	CPreferences::cumConnMaxUpRate;
uint64	CPreferences::cumConnRunTime;
uint32	CPreferences::cumConnNumReconnects;
uint32	CPreferences::cumConnAvgConnections;
uint32	CPreferences::cumConnMaxConnLimitReached;
uint32	CPreferences::cumConnPeakConnections;
uint32	CPreferences::cumConnTransferTime;
uint32	CPreferences::cumConnDownloadTime;
uint32	CPreferences::cumConnUploadTime;
uint32	CPreferences::cumConnServerDuration;
uint32	CPreferences::cumSrvrsMostWorkingServers;
uint32	CPreferences::cumSrvrsMostUsersOnline;
uint32	CPreferences::cumSrvrsMostFilesAvail;
uint32	CPreferences::cumSharedMostFilesShared;
uint64	CPreferences::cumSharedLargestShareSize;
uint64	CPreferences::cumSharedLargestAvgFileSize;
uint64	CPreferences::cumSharedLargestFileSize;
__int64 CPreferences::stat_datetimeLastReset;
uint8	CPreferences::statsConnectionsGraphRatio;
UINT	CPreferences::statsSaveInterval;
TCHAR	CPreferences::statsExpandedTreeItems[256];
bool	CPreferences::m_bShowVerticalHourMarkers;
uint64	CPreferences::totalDownloadedBytes;
uint64	CPreferences::totalUploadedBytes;
WORD	CPreferences::m_wLanguageID;
uint8	CPreferences::transferDoubleclick;
EViewSharedFilesAccess CPreferences::m_iSeeShares;
uint8	CPreferences::m_iToolDelayTime;
uint8	CPreferences::bringtoforeground;
uint8	CPreferences::splitterbarPosition;
uint8	CPreferences::splitterbarPositionStat;
uint8	CPreferences::splitterbarPositionStat_HL;
uint8	CPreferences::splitterbarPositionStat_HR;
uint16	CPreferences::splitterbarPositionFriend;
uint16	CPreferences::splitterbarPositionIRC;
uint8	CPreferences::m_uTransferWnd2;
uint16	CPreferences::deadserverretries;
DWORD	CPreferences::m_dwServerKeepAliveTimeout;
uint16	CPreferences::statsMax;
uint8	CPreferences::statsAverageMinutes;
uint8	CPreferences::useDownloadNotifier;
uint8	CPreferences::useNewDownloadNotifier;
uint8	CPreferences::useChatNotifier;
uint8	CPreferences::useLogNotifier;
uint8	CPreferences::useSoundInNotifier;
uint8	CPreferences::notifierPopsEveryChatMsg;
uint8	CPreferences::notifierImportantError;
uint8	CPreferences::notifierNewVersion;
TCHAR	CPreferences::notifierSoundFilePath[510];
TCHAR	CPreferences::m_sircserver[50];
TCHAR	CPreferences::m_sircnick[30];
TCHAR	CPreferences::m_sircchannamefilter[50];
bool	CPreferences::m_bircaddtimestamp;
bool	CPreferences::m_bircusechanfilter;
uint16	CPreferences::m_iircchanneluserfilter;
TCHAR	CPreferences::m_sircperformstring[255];
bool	CPreferences::m_bircuseperform;
bool	CPreferences::m_birclistonconnect;
bool	CPreferences::m_bircacceptlinks;
bool	CPreferences::m_bircacceptlinksfriends;
bool	CPreferences::m_bircsoundevents;
bool	CPreferences::m_bircignoremiscmessage;
bool	CPreferences::m_bircignorejoinmessage;
bool	CPreferences::m_bircignorepartmessage;
bool	CPreferences::m_bircignorequitmessage;
bool	CPreferences::m_bircignoreemuleprotoaddfriend;
bool	CPreferences::m_bircallowemuleprotoaddfriend;
bool	CPreferences::m_bircignoreemuleprotosendlink;
bool	CPreferences::m_birchelpchannel;
bool	CPreferences::m_bRemove2bin;
bool	CPreferences::m_bShowCopyEd2kLinkCmd;
bool	CPreferences::m_bpreviewprio;
bool	CPreferences::smartidcheck;
uint8	CPreferences::smartidstate;
bool	CPreferences::safeServerConnect;
bool	CPreferences::startMinimized;
bool	CPreferences::m_bAutoStart;
bool	CPreferences::m_bRestoreLastMainWndDlg;
int		CPreferences::m_iLastMainWndDlgID;
bool	CPreferences::m_bRestoreLastLogPane;
int		CPreferences::m_iLastLogPaneID;
uint16	CPreferences::MaxConperFive;
int		CPreferences::checkDiskspace;
UINT	CPreferences::m_uMinFreeDiskSpace;
bool	CPreferences::m_bSparsePartFiles;
CString	CPreferences::m_strYourHostname;
bool	CPreferences::m_bEnableVerboseOptions;
bool	CPreferences::m_bVerbose;
bool	CPreferences::m_bFullVerbose;
bool	CPreferences::m_bDebugSourceExchange;
bool	CPreferences::m_bLogBannedClients;
bool	CPreferences::m_bLogRatingDescReceived;
bool	CPreferences::m_bLogSecureIdent;
bool	CPreferences::m_bLogFilteredIPs;
bool	CPreferences::m_bLogFileSaving;
bool	CPreferences::m_bLogA4AF; // ZZ:DownloadManager
bool	CPreferences::m_bLogUlDlEvents;
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
bool	CPreferences::m_bUseDebugDevice = true;
#else
bool	CPreferences::m_bUseDebugDevice = false;
#endif
int		CPreferences::m_iDebugServerTCPLevel;
int		CPreferences::m_iDebugServerUDPLevel;
int		CPreferences::m_iDebugServerSourcesLevel;
int		CPreferences::m_iDebugServerSearchesLevel;
int		CPreferences::m_iDebugClientTCPLevel;
int		CPreferences::m_iDebugClientUDPLevel;
int		CPreferences::m_iDebugClientKadUDPLevel;
bool	CPreferences::m_bupdatequeuelist;
bool	CPreferences::m_bmanualhighprio;
bool	CPreferences::m_btransferfullchunks;
int		CPreferences::m_istartnextfile;
bool	CPreferences::m_bshowoverhead;
bool	CPreferences::m_bDAP;
bool	CPreferences::m_bUAP;
bool	CPreferences::m_bDisableKnownClientList;
bool	CPreferences::m_bDisableQueueList;
bool	CPreferences::m_bExtControls;
bool	CPreferences::m_bTransflstRemain;
uint8	CPreferences::versioncheckdays;
int		CPreferences::tableSortItemDownload;
int		CPreferences::tableSortItemUpload;
int		CPreferences::tableSortItemQueue;
int		CPreferences::tableSortItemSearch;
int		CPreferences::tableSortItemShared;
int		CPreferences::tableSortItemServer;
int		CPreferences::tableSortItemClientList;
int		CPreferences::tableSortItemFilenames;
bool	CPreferences::tableSortAscendingDownload;
bool	CPreferences::tableSortAscendingUpload;
bool	CPreferences::tableSortAscendingQueue;
bool	CPreferences::tableSortAscendingSearch;
bool	CPreferences::tableSortAscendingShared;
bool	CPreferences::tableSortAscendingServer;
bool	CPreferences::tableSortAscendingClientList;
bool	CPreferences::tableSortAscendingFilenames;
bool	CPreferences::showRatesInTitle;
TCHAR	CPreferences::TxtEditor[256];
TCHAR	CPreferences::VideoPlayer[256];
bool	CPreferences::moviePreviewBackup;
int		CPreferences::m_iPreviewSmallBlocks;
int		CPreferences::m_iPreviewCopiedArchives;
int		CPreferences::m_iInspectAllFileTypes;
bool	CPreferences::m_bPreviewOnIconDblClk;
bool	CPreferences::indicateratings;
bool	CPreferences::watchclipboard;
bool	CPreferences::filterserverbyip;
bool	CPreferences::m_bFirstStart;
bool	CPreferences::m_bCreditSystem;
bool	CPreferences::log2disk;
bool	CPreferences::debug2disk;
int		CPreferences::iMaxLogBuff;
UINT	CPreferences::uMaxLogFileSize;
bool	CPreferences::scheduler;
bool	CPreferences::dontcompressavi;
bool	CPreferences::msgonlyfriends;
bool	CPreferences::msgsecure;
uint8	CPreferences::filterlevel;
UINT	CPreferences::m_iFileBufferSize;
UINT	CPreferences::m_iQueueSize;
int		CPreferences::m_iCommitFiles;
uint16	CPreferences::maxmsgsessions;
uint32	CPreferences::versioncheckLastAutomatic;
TCHAR	CPreferences::messageFilter[512];
CString	CPreferences::commentFilter;
TCHAR	CPreferences::filenameCleanups[512];
TCHAR	CPreferences::notifierConfiguration[510];
TCHAR	CPreferences::datetimeformat[64];
TCHAR	CPreferences::datetimeformat4log[64];
LOGFONT CPreferences::m_lfHyperText;
LOGFONT CPreferences::m_lfLogText;
COLORREF CPreferences::m_crLogError = RGB(255, 0, 0);
COLORREF CPreferences::m_crLogWarning = RGB(128, 0, 128);
COLORREF CPreferences::m_crLogSuccess = RGB(0, 0, 255);
int		CPreferences::m_iExtractMetaData;
bool	CPreferences::m_bAdjustNTFSDaylightFileTime = true;
TCHAR	CPreferences::m_sWebPassword[256];
TCHAR	CPreferences::m_sWebLowPassword[256];
uint16	CPreferences::m_nWebPort;
bool	CPreferences::m_bWebEnabled;
bool	CPreferences::m_bWebUseGzip;
int		CPreferences::m_nWebPageRefresh;
bool	CPreferences::m_bWebLowEnabled;
TCHAR	CPreferences::m_sWebResDir[MAX_PATH];
int		CPreferences::m_iWebTimeoutMins;
TCHAR	CPreferences::m_sTemplateFile[MAX_PATH];
ProxySettings CPreferences::proxy;
bool	CPreferences::m_bIsASCWOP;
bool	CPreferences::m_bShowProxyErrors;
bool	CPreferences::showCatTabInfos;
bool	CPreferences::resumeSameCat;
bool	CPreferences::dontRecreateGraphs;
bool	CPreferences::autofilenamecleanup;
bool	CPreferences::m_bUseAutocompl;
bool	CPreferences::m_bShowDwlPercentage;
bool	CPreferences::m_bRemoveFinishedDownloads;
uint16	CPreferences::m_iMaxChatHistory;
bool	CPreferences::m_bShowActiveDownloadsBold;
int		CPreferences::m_iSearchMethod;
bool	CPreferences::m_bAdvancedSpamfilter;
bool	CPreferences::m_bUseSecureIdent;
TCHAR	CPreferences::m_sMMPassword[256];
bool	CPreferences::m_bMMEnabled;
uint16	CPreferences::m_nMMPort;
bool	CPreferences::networkkademlia;
bool	CPreferences::networked2k;
EToolbarLabelType CPreferences::m_nToolbarLabels;
CString	CPreferences::m_sToolbarBitmap;
CString	CPreferences::m_sToolbarBitmapFolder;
CString	CPreferences::m_sToolbarSettings;
bool	CPreferences::m_bReBarToolbar;
CSize	CPreferences::m_sizToolbarIconSize;
bool	CPreferences::m_bPreviewEnabled;
bool	CPreferences::m_bDynUpEnabled;
int		CPreferences::m_iDynUpPingTolerance;
int		CPreferences::m_iDynUpGoingUpDivider;
int		CPreferences::m_iDynUpGoingDownDivider;
int		CPreferences::m_iDynUpNumberOfPings;
int		CPreferences::m_iDynUpPingToleranceMilliseconds;
bool	CPreferences::m_bDynUpUseMillisecondPingTolerance;

// ZZ:DownloadManager -->
bool    CPreferences::m_bA4AFSaveCpu;
// ZZ:DownloadManager <--

CStringList CPreferences::shareddir_list;
CStringList CPreferences::adresses_list;
CString CPreferences::appdir;
CString CPreferences::configdir;
CString CPreferences::m_strWebServerDir;
CString CPreferences::m_strLangDir;
CString CPreferences::m_strFileCommentsFilePath;
CString	CPreferences::m_strLogDir;
Preferences_Ext_Struct* CPreferences::prefsExt;
WORD	CPreferences::m_wWinVer;
bool	CPreferences::m_UseProxyListenPort;
uint16	CPreferences::ListenPort;
CArray<Category_Struct*,Category_Struct*> CPreferences::catMap;
uint8	CPreferences::m_nWebMirrorAlertLevel;
bool	CPreferences::m_bRunAsUser;
bool	CPreferences::m_bUseOldTimeRemaining;
uint32	CPreferences::m_uPeerCacheLastSearch;
bool	CPreferences::m_bPeerCacheWasFound;
bool	CPreferences::m_bPeerCacheEnabled;
uint16	CPreferences::m_nPeerCachePort;
bool	CPreferences::m_bPeerCacheShow;

bool	CPreferences::m_bOpenPortsOnStartUp;
uint8	CPreferences::m_byLogLevel;
bool	CPreferences::m_bTrustEveryHash;

CPreferences::CPreferences()
{
// RT, WebCache (Code by JP/yonatan/Superlexx)
	expectingWebCachePing = false;
	WebCachePingSendTime = 0;
	WebCacheDisabledThisSession = true;
	webcacheReleaseAllowed = true; //jp webcache release
// End--WebCache
#ifdef _DEBUG
	m_iDbgHeap = 1;
#endif
}

CPreferences::~CPreferences()
{
	delete prefsExt;
}

void CPreferences::Init()
{
	srand((uint32)time(0)); // we need random numbers sometimes

	prefsExt = new Preferences_Ext_Struct;
	memset(prefsExt, 0, sizeof *prefsExt);

	//get application start directory
	TCHAR buffer[490];
	::GetModuleFileName(0, buffer, 490);
	LPTSTR pszFileName = _tcsrchr(buffer, _T('\\')) + 1;
	*pszFileName = _T('\0');

	appdir = buffer;
	configdir = appdir + CONFIGFOLDER;
	m_strWebServerDir = appdir + _T("webserver\\");
	m_strLangDir = appdir + _T("lang\\");
	m_strFileCommentsFilePath = configdir + _T("fileinfo.ini");
	m_strLogDir = appdir + _T("logs\\");

	///////////////////////////////////////////////////////////////////////////
	// Create 'config' directory (and optionally move files from application directory)
	//
	::CreateDirectory(GetConfigDir(), 0);
// RT, Initial
	// Rename
	CString OldFilename;
	OldFilename.Format( _T("%sRatioPreferences.ini"), configdir );
	if (PathFileExists(OldFilename) == TRUE)
	{
		_trename( OldFilename, (configdir + _T("RT_Preferences.ini")) );
		OldFilename.Format( _T("%sRatioCategory.ini"), configdir );
		if (PathFileExists(OldFilename) == TRUE)   _trename( OldFilename, (configdir + _T("RT_Category.ini")) );
		OldFilename.Format( _T("%sRatioFakeFiles.ini"), configdir );
		if (PathFileExists(OldFilename) == TRUE)   _trename( OldFilename, (configdir + _T("RT_FakeFiles.ini")) );
		OldFilename.Format( _T("%sRatioHistory.ini"), configdir );
		if (PathFileExists(OldFilename) == TRUE)   _trename( OldFilename, (configdir + _T("RT_History.ini")) );
		OldFilename.Format( _T("%sRatioKnownFile.ini"), configdir );
		if (PathFileExists(OldFilename) == TRUE)   _trename( OldFilename, (configdir + _T("RT_KnownFile.ini")) );
		OldFilename.Format( _T("%sRatioStatistics.ini"), configdir );
		if (PathFileExists(OldFilename) == TRUE)   _trename( OldFilename, (configdir + _T("RT_Statistics.ini")) );
		OldFilename.Format( _T("%sRatioIP2Country.dat"), configdir );
		if (PathFileExists(OldFilename) == TRUE)   _trename( OldFilename, (configdir + _T("RT_IP2Country.dat")) );
	}
	// Backup Config
	RT_BackupConfig();
	// New UserHash
	rt_NewUserHash = false;
	// Wap Server by MoNKi
	m_strWapServerDir = appdir + _T("wapserver\\");
// End
	// lets move config-files in the appdir to the configdir (for upgraders <0.29a to >=0.29a )
	if (PathFileExists(appdir + _T("preferences.ini")))		MoveFile(appdir + _T("preferences.ini"), configdir + _T("preferences.ini"));
	if (PathFileExists(appdir + _T("preferences.dat")))		MoveFile(appdir + _T("preferences.dat"), configdir + _T("preferences.dat"));
	if (PathFileExists(appdir + _T("adresses.dat")))		MoveFile(appdir + _T("adresses.dat"), configdir + _T("adresses.dat"));
	if (PathFileExists(appdir + _T("Category.ini")))		MoveFile(appdir + _T("Category.ini"), configdir + _T("Category.ini"));
	if (PathFileExists(appdir + _T("clients.met")))			MoveFile(appdir + _T("clients.met"), configdir + _T("clients.met"));
	if (PathFileExists(appdir + _T("emfriends.met")))		MoveFile(appdir + _T("emfriends.met"), configdir + _T("emfriends.met"));
	if (PathFileExists(appdir + _T("fileinfo.ini")))		MoveFile(appdir + _T("fileinfo.ini"), configdir + _T("fileinfo.ini"));
	if (PathFileExists(appdir + _T("ipfilter.dat")))		MoveFile(appdir + _T("ipfilter.dat"), configdir + _T("ipfilter.dat"));
	if (PathFileExists(appdir + _T("known.met")))			MoveFile(appdir + _T("known.met"), configdir + _T("known.met"));
	if (PathFileExists(appdir + _T("server.met")))			MoveFile(appdir + _T("server.met"), configdir + _T("server.met"));
	if (PathFileExists(appdir + _T("shareddir.dat")))		MoveFile(appdir + _T("shareddir.dat"), configdir + _T("shareddir.dat"));
	if (PathFileExists(appdir + _T("staticservers.dat")))	MoveFile(appdir + _T("staticservers.dat"), configdir + _T("staticservers.dat"));
	if (PathFileExists(appdir + _T("webservices.dat")))		MoveFile(appdir + _T("webservices.dat"), configdir + _T("webservices.dat"));

	///////////////////////////////////////////////////////////////////////////
	// Create 'logs' directory (and optionally move files from application directory)
	//
	::CreateDirectory(GetLogDir(), 0);
	CFileFind ff;
	bool bFoundFile = ff.FindFile(GetAppDir() + _T("eMule*.log"), 0);
	while (bFoundFile)
	{
		bFoundFile = ff.FindNextFile();
		if (ff.IsDots() || ff.IsSystem() || ff.IsDirectory() || ff.IsHidden())
			continue;
		MoveFile(ff.GetFilePath(), GetLogDir() + ff.GetFileName());
	}


	CreateUserHash();

	// load preferences.dat or set standart values
	TCHAR* fullpath = new TCHAR[_tcslen(configdir)+16];
	_stprintf(fullpath,_T("%spreferences.dat"),configdir);
	FILE* preffile = _tfsopen(fullpath,_T("rb"), _SH_DENYWR);
	delete[] fullpath;

	LoadPreferences();

	if (!preffile){
		SetStandartValues();
	}
	else{
		fread(prefsExt,sizeof(Preferences_Ext_Struct),1,preffile);
		if (ferror(preffile))
			SetStandartValues();

		// import old pref-files
		if (prefsExt->version<20) {
			if (prefsExt->version>17) {// v0.20b+
				Preferences_Import20b_Struct* prefsImport20b;
				prefsImport20b=new Preferences_Import20b_Struct;
				memset(prefsImport20b,0,sizeof(Preferences_Import20b_Struct));
				fseek(preffile,0,0);
				fread(prefsImport20b,sizeof(Preferences_Import20b_Struct),1,preffile);

				md4cpy(userhash, prefsImport20b->userhash);
				memcpy(incomingdir, prefsImport20b->incomingdir, 510);
				memcpy(tempdir, prefsImport20b->tempdir, 510);
				strNick = prefsImport20b->nick;

				totalDownloadedBytes=prefsImport20b->totalDownloadedBytes;
				totalUploadedBytes=prefsImport20b->totalUploadedBytes;
				delete prefsImport20b;
			} else if (prefsExt->version>7) { // v0.20a
				Preferences_Import20a_Struct* prefsImport20a;
				prefsImport20a=new Preferences_Import20a_Struct;
				memset(prefsImport20a,0,sizeof(Preferences_Import20a_Struct));
				fseek(preffile,0,0);
				fread(prefsImport20a,sizeof(Preferences_Import20a_Struct),1,preffile);

				md4cpy(userhash, prefsImport20a->userhash);
				memcpy(incomingdir, prefsImport20a->incomingdir, 510);
				memcpy(tempdir, prefsImport20a->tempdir, 510);
				strNick = prefsImport20a->nick;

				totalDownloadedBytes=prefsImport20a->totalDownloaded;
				totalUploadedBytes=prefsImport20a->totalUploaded;
				delete prefsImport20a;
			} else {	//v0.19c-
				Preferences_Import19c_Struct* prefsImport19c;
				prefsImport19c=new Preferences_Import19c_Struct;
				memset(prefsImport19c,0,sizeof(Preferences_Import19c_Struct));

				fseek(preffile,0,0);
				fread(prefsImport19c,sizeof(Preferences_Import19c_Struct),1,preffile);

				if (prefsExt->version < 3)
					CreateUserHash();
				else
					md4cpy(userhash, prefsImport19c->userhash);
				memcpy(incomingdir, prefsImport19c->incomingdir, 510);
				memcpy(tempdir, prefsImport19c->tempdir, 510);
				strNick = prefsImport19c->nick;
				delete prefsImport19c;
			}
 		} else {
			md4cpy(userhash, prefsExt->userhash);
			EmuleWindowPlacement = prefsExt->EmuleWindowPlacement;
		}
		fclose(preffile);
		smartidstate = 0;
	}

	// shared directories
	fullpath = new TCHAR[_tcslen(configdir) + MAX_PATH];
	_stprintf(fullpath, _T("%sshareddir.dat"), configdir);
	CStdioFile* sdirfile = new CStdioFile();
	bool bIsUnicodeFile = IsUnicodeFile(fullpath); // check for BOM
	// open the text file either in ANSI (text) or Unicode (binary), this way we can read old and new files
	// with nearly the same code..
	if (sdirfile->Open(fullpath, CFile::modeRead | CFile::shareDenyWrite | (bIsUnicodeFile ? CFile::typeBinary : 0)))
	{
		try {
			if (bIsUnicodeFile)
				sdirfile->Seek(sizeof(WORD), SEEK_CUR); // skip BOM

			CString toadd;
			while (sdirfile->ReadString(toadd))
			{
				toadd.Trim(_T("\r\n")); // need to trim '\r' in binary mode
				TCHAR szFullPath[MAX_PATH];
				if (PathCanonicalize(szFullPath, toadd))
					toadd = szFullPath;

				if (IsInstallationDirectory(toadd))
					continue;

				if (_taccess(toadd, 0) == 0) { // only add directories which still exist
					if (toadd.Right(1) != _T('\\'))
						toadd.Append(_T("\\"));
					shareddir_list.AddHead(toadd);
				}
			}
		}
		catch (CFileException* ex) {
			ASSERT(0);
			ex->Delete();
		}
		sdirfile->Close();
	}
	delete sdirfile;
	delete[] fullpath;

	// serverlist adresses
	fullpath = new TCHAR[_tcslen(configdir) + 20];
	_stprintf(fullpath, _T("%sadresses.dat"), configdir);
	sdirfile = new CStdioFile();
	bIsUnicodeFile = IsUnicodeFile(fullpath);
	if (sdirfile->Open(fullpath, CFile::modeRead | CFile::shareDenyWrite | (bIsUnicodeFile ? CFile::typeBinary : 0)))
	{
		try {
			if (bIsUnicodeFile)
				sdirfile->Seek(sizeof(WORD), SEEK_CUR); // skip BOM

			CString toadd;
			while (sdirfile->ReadString(toadd))
			{
				toadd.Trim(_T("\r\n")); // need to trim '\r' in binary mode
				adresses_list.AddHead(toadd);
			}
		}
		catch (CFileException* ex) {
			ASSERT(0);
			ex->Delete();
		}
		sdirfile->Close();
	}
	delete sdirfile;
	delete[] fullpath;
	fullpath = NULL;

	userhash[5] = 14;
	userhash[14] = 111;

	// deadlake PROXYSUPPORT
	m_UseProxyListenPort = false;
	ListenPort = 0;

	// Explicitly inform the user about errors with incoming/temp folders!
	if (!PathFileExists(GetIncomingDir()) && !::CreateDirectory(GetIncomingDir(),0)) {
		CString strError;
		strError.Format(GetResString(IDS_ERR_CREATE_DIR), GetResString(IDS_PW_INCOMING), GetIncomingDir(), GetErrorMessage(GetLastError()));
		AfxMessageBox(strError, MB_ICONERROR);
		_stprintf(incomingdir,_T("%sincoming"),appdir);
		if (!PathFileExists(GetIncomingDir()) && !::CreateDirectory(GetIncomingDir(),0)){
			strError.Format(GetResString(IDS_ERR_CREATE_DIR), GetResString(IDS_PW_INCOMING), GetIncomingDir(), GetErrorMessage(GetLastError()));
			AfxMessageBox(strError, MB_ICONERROR);
		}
	}
	if (!PathFileExists(GetTempDir()) && !::CreateDirectory(GetTempDir(),0)) {
		CString strError;
		strError.Format(GetResString(IDS_ERR_CREATE_DIR), GetResString(IDS_PW_TEMP), GetTempDir(), GetErrorMessage(GetLastError()));
		AfxMessageBox(strError, MB_ICONERROR);
		_stprintf(tempdir,_T("%stemp"),appdir);
		if (!PathFileExists(GetTempDir()) && !::CreateDirectory(GetTempDir(),0)){
			strError.Format(GetResString(IDS_ERR_CREATE_DIR), GetResString(IDS_PW_TEMP), GetTempDir(), GetErrorMessage(GetLastError()));
			AfxMessageBox(strError, MB_ICONERROR);
		}
	}

	// Create 'skins' directory
	if (!PathFileExists(GetSkinProfileDir()) && !CreateDirectory(GetSkinProfileDir(), 0)) {
		m_strSkinProfileDir = appdir + _T("skins");
		CreateDirectory(GetSkinProfileDir(), 0);
	}

	// Create 'toolbars' directory
	if (!PathFileExists(GetToolbarBitmapFolderSettings()) && !CreateDirectory(GetToolbarBitmapFolderSettings(), 0)) {
		m_sToolbarBitmapFolder = appdir + _T("skins");
		CreateDirectory(GetToolbarBitmapFolderSettings(), 0);
	}


	if (((int*)userhash[0]) == 0 && ((int*)userhash[1]) == 0 && ((int*)userhash[2]) == 0 && ((int*)userhash[3]) == 0)
		CreateUserHash();
// RT, Load Ratio Setting
	RT_LoadSettings();
	RT_InitialSettings();
	RT_SaveSettings();
//	RT_LoadStatistics();
	RT_LoadCategory();
// End
}

void CPreferences::Uninit()
{
	while (!catMap.IsEmpty())
	{
		Category_Struct* delcat = catMap.GetAt(0); 
		catMap.RemoveAt(0); 
		delete delcat;
	}
}

void CPreferences::SetStandartValues()
{
// RT, New UserHash
	rt_NewUserHash = true;
// End
	CreateUserHash();

	WINDOWPLACEMENT defaultWPM;
	defaultWPM.length = sizeof(WINDOWPLACEMENT);
	defaultWPM.rcNormalPosition.left=10;defaultWPM.rcNormalPosition.top=10;
	defaultWPM.rcNormalPosition.right=700;defaultWPM.rcNormalPosition.bottom=500;
	defaultWPM.showCmd=0;
	EmuleWindowPlacement=defaultWPM;
	versioncheckLastAutomatic=0;

//	Save();
}

bool CPreferences::IsTempFile(const CString& rstrDirectory, const CString& rstrName)
{
	if (CompareDirectories(rstrDirectory, GetTempDir()))
		return false;

	// do not share a file from the temp directory, if it matches one of the following patterns
	CString strNameLower(rstrName);
	strNameLower.MakeLower();
	strNameLower += _T("|"); // append an EOS character which we can query for
	static const LPCTSTR _apszNotSharedExts[] = {
		_T("%u.part") _T("%c"), 
		_T("%u.part.met") _T("%c"), 
		_T("%u.part.met") PARTMET_BAK_EXT _T("%c"), 
		_T("%u.part.met") PARTMET_TMP_EXT _T("%c") 
	};
	for (int i = 0; i < ARRSIZE(_apszNotSharedExts); i++){
		UINT uNum;
		TCHAR iChar;
		// "misuse" the 'scanf' function for a very simple pattern scanning.
		if (_stscanf(strNameLower, _apszNotSharedExts[i], &uNum, &iChar) == 2 && iChar == _T('|'))
			return true;
	}

	return false;
}

// SLUGFILLER: SafeHash
bool CPreferences::IsConfigFile(const CString& rstrDirectory, const CString& rstrName)
{
	if (CompareDirectories(rstrDirectory, configdir))
		return false;

	// do not share a file from the config directory, if it contains one of the following extensions
	static const LPCTSTR _apszNotSharedExts[] = { _T(".met.bak"), _T(".ini.old") };
	for (int i = 0; i < ARRSIZE(_apszNotSharedExts); i++){
		int iLen = _tcslen(_apszNotSharedExts[i]);
		if (rstrName.GetLength()>=iLen && rstrName.Right(iLen).CompareNoCase(_apszNotSharedExts[i])==0)
			return true;
	}

	// do not share following files from the config directory
	static const LPCTSTR _apszNotSharedFiles[] = 
	{
		_T("AC_SearchStrings.dat"),
		_T("AC_ServerMetURLs.dat"),
		_T("adresses.dat"),
		_T("category.ini"),
		_T("clients.met"),
		_T("cryptkey.dat"),
		_T("emfriends.met"),
		_T("fileinfo.ini"),
		_T("ipfilter.dat"),
		_T("known.met"),
		_T("preferences.dat"),
		_T("preferences.ini"),
		_T("server.met"),
		_T("server.met.new"),
		_T("server_met.download"),
		_T("server_met.old"),
		_T("shareddir.dat"),
		_T("sharedsubdir.dat"),
		_T("staticservers.dat"),
		_T("webservices.dat")
	};
	for (int i = 0; i < ARRSIZE(_apszNotSharedFiles); i++){
		if (rstrName.CompareNoCase(_apszNotSharedFiles[i])==0)
			return true;
	}

	return false;
}
// SLUGFILLER: SafeHash

uint16 CPreferences::GetMaxDownload(){
    return GetMaxDownloadInBytesPerSec()/1024;
}

uint64 CPreferences::GetMaxDownloadInBytesPerSec(bool dynamic){
//dont be a Lam3r :)
    uint64 maxup;
    if(dynamic && thePrefs.IsDynUpEnabled() && theApp.uploadqueue->GetWaitingUserCount() != 0 && theApp.uploadqueue->GetDatarate() != 0) {
        maxup = theApp.uploadqueue->GetDatarate();
    } else {
        maxup = GetMaxUpload()*1024;
    }

	if( maxup < 4*1024 )
		return (( (maxup < 10*1024) && (maxup*3 < maxdownload*1024) )? maxup*3 : maxdownload*1024);
	return (( (maxup < 10*1024) && (maxup*4 < maxdownload*1024) )? maxup*4 : maxdownload*1024);
}

// RT, New Code at Bottom
/* Original
// -khaos--+++> A whole bunch of methods!  Keep going until you reach the end tag.
void CPreferences::SaveStats(int bBackUp){
	// This function saves all of the new statistics in my addon.  It is also used to
	// save backups for the Reset Stats function, and the Restore Stats function (Which is actually LoadStats)
	// bBackUp = 0: DEFAULT; save to statistics.ini
	// bBackUp = 1: Save to statbkup.ini, which is used to restore after a reset
	// bBackUp = 2: Save to statbkuptmp.ini, which is temporarily created during a restore and then renamed to statbkup.ini

	CString fullpath(configdir);
	if (bBackUp == 1)
		fullpath += _T("statbkup.ini");
	else if (bBackUp == 2)
		fullpath += _T("statbkuptmp.ini");
	else
		fullpath += _T("statistics.ini");
	
	CIni ini(fullpath, _T("Statistics"));

	// Save cumulative statistics to preferences.ini, going in order as they appear in CStatisticsDlg::ShowStatistics.
	// We do NOT SET the values in prefs struct here.

    // Save Cum Down Data
	ini.WriteUInt64(_T("TotalDownloadedBytes"), theStats.sessionReceivedBytes + GetTotalDownloaded());
	ini.WriteInt(_T("DownSuccessfulSessions"), cumDownSuccessfulSessions);
	ini.WriteInt(_T("DownFailedSessions"), cumDownFailedSessions);
	ini.WriteInt(_T("DownAvgTime"), (GetDownC_AvgTime() + GetDownS_AvgTime()) / 2);
	ini.WriteUInt64(_T("LostFromCorruption"), cumLostFromCorruption + sesLostFromCorruption);
	ini.WriteUInt64(_T("SavedFromCompression"), sesSavedFromCompression + cumSavedFromCompression);
	ini.WriteInt(_T("PartsSavedByICH"), cumPartsSavedByICH + sesPartsSavedByICH);

	ini.WriteUInt64(_T("DownData_EDONKEY"), GetCumDownData_EDONKEY());
	ini.WriteUInt64(_T("DownData_EDONKEYHYBRID"), GetCumDownData_EDONKEYHYBRID());
	ini.WriteUInt64(_T("DownData_EMULE"), GetCumDownData_EMULE());
	ini.WriteUInt64(_T("DownData_MLDONKEY"), GetCumDownData_MLDONKEY());
	ini.WriteUInt64(_T("DownData_LMULE"), GetCumDownData_EMULECOMPAT());
	ini.WriteUInt64(_T("DownData_AMULE"), GetCumDownData_AMULE());
	ini.WriteUInt64(_T("DownData_SHAREAZA"), GetCumDownData_SHAREAZA());
	ini.WriteUInt64(_T("DownData_URL"), GetCumDownData_URL());
	ini.WriteUInt64(_T("DownDataPort_4662"), GetCumDownDataPort_4662());
	ini.WriteUInt64(_T("DownDataPort_OTHER"), GetCumDownDataPort_OTHER());
	ini.WriteUInt64(_T("DownDataPort_PeerCache"), GetCumDownDataPort_PeerCache());

	ini.WriteUInt64(_T("DownOverheadTotal"),theStats.GetDownDataOverheadFileRequest() +
										theStats.GetDownDataOverheadSourceExchange() +
										theStats.GetDownDataOverheadServer() +
										theStats.GetDownDataOverheadKad() +
										theStats.GetDownDataOverheadOther() +
										GetDownOverheadTotal());
	ini.WriteUInt64(_T("DownOverheadFileReq"), theStats.GetDownDataOverheadFileRequest() + GetDownOverheadFileReq());
	ini.WriteUInt64(_T("DownOverheadSrcEx"), theStats.GetDownDataOverheadSourceExchange() + GetDownOverheadSrcEx());
	ini.WriteUInt64(_T("DownOverheadServer"), theStats.GetDownDataOverheadServer() + GetDownOverheadServer());
	ini.WriteUInt64(_T("DownOverheadKad"), theStats.GetDownDataOverheadKad() + GetDownOverheadKad());
	
	ini.WriteUInt64(_T("DownOverheadTotalPackets"), theStats.GetDownDataOverheadFileRequestPackets() + 
												theStats.GetDownDataOverheadSourceExchangePackets() + 
												theStats.GetDownDataOverheadServerPackets() + 
												theStats.GetDownDataOverheadKadPackets() + 
												theStats.GetDownDataOverheadOtherPackets() + 
												GetDownOverheadTotalPackets());
	ini.WriteUInt64(_T("DownOverheadFileReqPackets"), theStats.GetDownDataOverheadFileRequestPackets() + GetDownOverheadFileReqPackets());
	ini.WriteUInt64(_T("DownOverheadSrcExPackets"), theStats.GetDownDataOverheadSourceExchangePackets() + GetDownOverheadSrcExPackets());
	ini.WriteUInt64(_T("DownOverheadServerPackets"), theStats.GetDownDataOverheadServerPackets() + GetDownOverheadServerPackets());
	ini.WriteUInt64(_T("DownOverheadKadPackets"), theStats.GetDownDataOverheadKadPackets() + GetDownOverheadKadPackets());

	// Save Cumulative Upline Statistics
	ini.WriteUInt64(_T("TotalUploadedBytes"), theStats.sessionSentBytes + GetTotalUploaded());
	ini.WriteInt(_T("UpSuccessfulSessions"), theApp.uploadqueue->GetSuccessfullUpCount() + GetUpSuccessfulSessions());
	ini.WriteInt(_T("UpFailedSessions"), theApp.uploadqueue->GetFailedUpCount() + GetUpFailedSessions());
	ini.WriteInt(_T("UpAvgTime"), (theApp.uploadqueue->GetAverageUpTime() + GetUpAvgTime())/2);
	ini.WriteUInt64(_T("UpData_EDONKEY"), GetCumUpData_EDONKEY());
	ini.WriteUInt64(_T("UpData_EDONKEYHYBRID"), GetCumUpData_EDONKEYHYBRID());
	ini.WriteUInt64(_T("UpData_EMULE"), GetCumUpData_EMULE());
	ini.WriteUInt64(_T("UpData_MLDONKEY"), GetCumUpData_MLDONKEY());
	ini.WriteUInt64(_T("UpData_LMULE"), GetCumUpData_EMULECOMPAT());
	ini.WriteUInt64(_T("UpData_AMULE"), GetCumUpData_AMULE());
	ini.WriteUInt64(_T("UpData_SHAREAZA"), GetCumUpData_SHAREAZA());
	ini.WriteUInt64(_T("UpDataPort_4662"), GetCumUpDataPort_4662());
	ini.WriteUInt64(_T("UpDataPort_OTHER"), GetCumUpDataPort_OTHER());
	ini.WriteUInt64(_T("UpDataPort_PeerCache"), GetCumUpDataPort_PeerCache());
	ini.WriteUInt64(_T("UpData_File"), GetCumUpData_File());
	ini.WriteUInt64(_T("UpData_Partfile"), GetCumUpData_Partfile());

	ini.WriteUInt64(_T("UpOverheadTotal"), theStats.GetUpDataOverheadFileRequest() + 
										theStats.GetUpDataOverheadSourceExchange() + 
										theStats.GetUpDataOverheadServer() + 
										theStats.GetUpDataOverheadKad() + 
										theStats.GetUpDataOverheadOther() + 
										GetUpOverheadTotal());
	ini.WriteUInt64(_T("UpOverheadFileReq"), theStats.GetUpDataOverheadFileRequest() + GetUpOverheadFileReq());
	ini.WriteUInt64(_T("UpOverheadSrcEx"), theStats.GetUpDataOverheadSourceExchange() + GetUpOverheadSrcEx());
	ini.WriteUInt64(_T("UpOverheadServer"), theStats.GetUpDataOverheadServer() + GetUpOverheadServer());
	ini.WriteUInt64(_T("UpOverheadKad"), theStats.GetUpDataOverheadKad() + GetUpOverheadKad());

	ini.WriteUInt64(_T("UpOverheadTotalPackets"), theStats.GetUpDataOverheadFileRequestPackets() + 
										theStats.GetUpDataOverheadSourceExchangePackets() + 
										theStats.GetUpDataOverheadServerPackets() + 
										theStats.GetUpDataOverheadKadPackets() + 
										theStats.GetUpDataOverheadOtherPackets() + 
										GetUpOverheadTotalPackets());
	ini.WriteUInt64(_T("UpOverheadFileReqPackets"), theStats.GetUpDataOverheadFileRequestPackets() + GetUpOverheadFileReqPackets());
	ini.WriteUInt64(_T("UpOverheadSrcExPackets"), theStats.GetUpDataOverheadSourceExchangePackets() + GetUpOverheadSrcExPackets());
	ini.WriteUInt64(_T("UpOverheadServerPackets"), theStats.GetUpDataOverheadServerPackets() + GetUpOverheadServerPackets());
	ini.WriteUInt64(_T("UpOverheadKadPackets"), theStats.GetUpDataOverheadKadPackets() + GetUpOverheadKadPackets());

	// Save Cumulative Connection Statistics
	float tempRate = 0.0F;

	// Download Rate Average
	tempRate = theStats.GetAvgDownloadRate(AVG_TOTAL);
	ini.WriteFloat(_T("ConnAvgDownRate"), tempRate);
	
	// Max Download Rate Average
	if (tempRate > GetConnMaxAvgDownRate())
		SetConnMaxAvgDownRate(tempRate);
	ini.WriteFloat(_T("ConnMaxAvgDownRate"), GetConnMaxAvgDownRate());
	
	// Max Download Rate
	tempRate = (float)theApp.downloadqueue->GetDatarate() / 1024;
	if (tempRate > GetConnMaxDownRate())
		SetConnMaxDownRate(tempRate);
	ini.WriteFloat(_T("ConnMaxDownRate"), GetConnMaxDownRate());
	
	// Upload Rate Average
	tempRate = theStats.GetAvgUploadRate(AVG_TOTAL);
	ini.WriteFloat(_T("ConnAvgUpRate"), tempRate);
	
	// Max Upload Rate Average
	if (tempRate > GetConnMaxAvgUpRate())
		SetConnMaxAvgUpRate(tempRate);
	ini.WriteFloat(_T("ConnMaxAvgUpRate"), GetConnMaxAvgUpRate());
	
	// Max Upload Rate
	tempRate = (float)theApp.uploadqueue->GetDatarate() / 1024;
	if (tempRate > GetConnMaxUpRate())
		SetConnMaxUpRate(tempRate);
	ini.WriteFloat(_T("ConnMaxUpRate"), GetConnMaxUpRate());
	
	// Overall Run Time
	ini.WriteInt(_T("ConnRunTime"), (GetTickCount() - theStats.starttime)/1000 + GetConnRunTime());
	
	// Number of Reconnects
	ini.WriteInt(_T("ConnNumReconnects"), (theStats.reconnects>0) ? (theStats.reconnects - 1 + GetConnNumReconnects()) : GetConnNumReconnects());
	
	// Average Connections
	if (theApp.serverconnect->IsConnected())
		ini.WriteInt(_T("ConnAvgConnections"), (theApp.listensocket->GetAverageConnections() + cumConnAvgConnections)/2);
	
	// Peak Connections
	if (theApp.listensocket->GetPeakConnections() > cumConnPeakConnections)
		cumConnPeakConnections = theApp.listensocket->GetPeakConnections();
	ini.WriteInt(_T("ConnPeakConnections"), cumConnPeakConnections);
	
	// Max Connection Limit Reached
	if (theApp.listensocket->GetMaxConnectionReached() + cumConnMaxConnLimitReached > cumConnMaxConnLimitReached)
		ini.WriteInt(_T("ConnMaxConnLimitReached"), theApp.listensocket->GetMaxConnectionReached() + cumConnMaxConnLimitReached);
	
	// Time Stuff...
	ini.WriteInt(_T("ConnTransferTime"), GetConnTransferTime() + theStats.GetTransferTime());
	ini.WriteInt(_T("ConnUploadTime"), GetConnUploadTime() + theStats.GetUploadTime());
	ini.WriteInt(_T("ConnDownloadTime"), GetConnDownloadTime() + theStats.GetDownloadTime());
	ini.WriteInt(_T("ConnServerDuration"), GetConnServerDuration() + theStats.GetServerDuration());
	
	// Compare and Save Server Records
	uint32 servtotal, servfail, servuser, servfile, servlowiduser, servtuser, servtfile;
	float servocc;
	theApp.serverlist->GetStatus(servtotal, servfail, servuser, servfile, servlowiduser, servtuser, servtfile, servocc);
	
	if (servtotal - servfail > cumSrvrsMostWorkingServers)
		cumSrvrsMostWorkingServers = servtotal - servfail;
	ini.WriteInt(_T("SrvrsMostWorkingServers"), cumSrvrsMostWorkingServers);

	if (servtuser > cumSrvrsMostUsersOnline)
		cumSrvrsMostUsersOnline = servtuser;
	ini.WriteInt(_T("SrvrsMostUsersOnline"), cumSrvrsMostUsersOnline);

	if (servtfile > cumSrvrsMostFilesAvail)
		cumSrvrsMostFilesAvail = servtfile;
	ini.WriteInt(_T("SrvrsMostFilesAvail"), cumSrvrsMostFilesAvail);

	// Compare and Save Shared File Records
	if (theApp.sharedfiles->GetCount() > cumSharedMostFilesShared)
		cumSharedMostFilesShared = theApp.sharedfiles->GetCount();
	ini.WriteInt(_T("SharedMostFilesShared"), cumSharedMostFilesShared);

	uint64 bytesLargestFile = 0;
	uint64 allsize = theApp.sharedfiles->GetDatasize(bytesLargestFile);
	if (allsize > cumSharedLargestShareSize)
		cumSharedLargestShareSize = allsize;
	ini.WriteUInt64(_T("SharedLargestShareSize"), cumSharedLargestShareSize);
	if (bytesLargestFile > cumSharedLargestFileSize)
		cumSharedLargestFileSize = bytesLargestFile;
	ini.WriteUInt64(_T("SharedLargestFileSize"), cumSharedLargestFileSize);

	if (theApp.sharedfiles->GetCount() != 0) {
		uint64 tempint = allsize/theApp.sharedfiles->GetCount();
		if (tempint > cumSharedLargestAvgFileSize)
			cumSharedLargestAvgFileSize = tempint;
	}

	ini.WriteUInt64(_T("SharedLargestAvgFileSize"), cumSharedLargestAvgFileSize);
	ini.WriteUInt64(_T("statsDateTimeLastReset"), stat_datetimeLastReset);

	// If we are saving a back-up or a temporary back-up, return now.
	if (bBackUp != 0)
		return;
}
*/

void CPreferences::SetRecordStructMembers() {

	// The purpose of this function is to be called from CStatisticsDlg::ShowStatistics()
	// This was easier than making a bunch of functions to interface with the record
	// members of the prefs struct from ShowStatistics.

	// This function is going to compare current values with previously saved records, and if
	// the current values are greater, the corresponding member of prefs will be updated.
	// We will not write to INI here, because this code is going to be called a lot more often
	// than SaveStats()  - Khaos

	CString buffer;

	// Servers
	uint32 servtotal, servfail, servuser, servfile, servlowiduser, servtuser, servtfile;
	float servocc;
	theApp.serverlist->GetStatus( servtotal, servfail, servuser, servfile, servlowiduser, servtuser, servtfile, servocc );
	if ((servtotal-servfail)>cumSrvrsMostWorkingServers) cumSrvrsMostWorkingServers = (servtotal-servfail);
	if (servtuser>cumSrvrsMostUsersOnline) cumSrvrsMostUsersOnline = servtuser;
	if (servtfile>cumSrvrsMostFilesAvail) cumSrvrsMostFilesAvail = servtfile;

	// Shared Files
	if (theApp.sharedfiles->GetCount()>cumSharedMostFilesShared) cumSharedMostFilesShared = theApp.sharedfiles->GetCount();
	uint64 bytesLargestFile = 0;
	uint64 allsize=theApp.sharedfiles->GetDatasize(bytesLargestFile);
	if (allsize>cumSharedLargestShareSize) cumSharedLargestShareSize = allsize;
	if (bytesLargestFile>cumSharedLargestFileSize) cumSharedLargestFileSize = bytesLargestFile;
	if (theApp.sharedfiles->GetCount() != 0) {
		uint64 tempint = allsize/theApp.sharedfiles->GetCount();
		if (tempint>cumSharedLargestAvgFileSize) cumSharedLargestAvgFileSize = tempint;
	}
} // SetRecordStructMembers()

void CPreferences::SaveCompletedDownloadsStat(){

	// This function saves the values for the completed
	// download members to INI.  It is called from
	// CPartfile::PerformFileComplete ...   - Khaos

	TCHAR* fullpath = new TCHAR[_tcslen(configdir)+MAX_PATH]; // i_a
	_stprintf(fullpath,_T("%sstatistics.ini"),configdir);
	
	CIni ini( fullpath, _T("Statistics") );

	delete[] fullpath;

	ini.WriteInt(_T("DownCompletedFiles"),			GetDownCompletedFiles());
	ini.WriteInt(_T("DownSessionCompletedFiles"),	GetDownSessionCompletedFiles());
} // SaveCompletedDownloadsStat()

void CPreferences::Add2SessionTransferData(UINT uClientID, UINT uClientPort, BOOL bFromPF, 
										   BOOL bUpDown, uint32 bytes, bool sentToFriend)
{
	//	This function adds the transferred bytes to the appropriate variables,
	//	as well as to the totals for all clients. - Khaos
	//	PARAMETERS:
	//	uClientID - The identifier for which client software sent or received this data, eg SO_EMULE
	//	uClientPort - The remote port of the client that sent or received this data, eg 4662
	//	bFromPF - Applies only to uploads.  True is from partfile, False is from non-partfile.
	//	bUpDown - True is Up, False is Down
	//	bytes - Number of bytes sent by the client.  Subtract header before calling.

	switch (bUpDown){
		case true:
			//	Upline Data
			switch (uClientID){
				// Update session client breakdown stats for sent bytes...
				case SO_EMULE:
				case SO_OLDEMULE:		sesUpData_EMULE+=bytes;			break;
				case SO_EDONKEYHYBRID:	sesUpData_EDONKEYHYBRID+=bytes;	break;
				case SO_EDONKEY:		sesUpData_EDONKEY+=bytes;		break;
				case SO_MLDONKEY:		sesUpData_MLDONKEY+=bytes;		break;
				case SO_AMULE:			sesUpData_AMULE+=bytes;			break;
				case SO_SHAREAZA:		sesUpData_SHAREAZA+=bytes;		break;
				case SO_CDONKEY:
				case SO_LPHANT:
				case SO_XMULE:			sesUpData_EMULECOMPAT+=bytes;	break;
			}

			switch (uClientPort){
				// Update session port breakdown stats for sent bytes...
				case 4662:				sesUpDataPort_4662+=bytes;		break;
				case (UINT)-1:			sesUpDataPort_PeerCache+=bytes;	break;
				//case (UINT)-2:		sesUpDataPort_URL+=bytes;		break;
				default:				sesUpDataPort_OTHER+=bytes;		break;
			}

			if (bFromPF)				sesUpData_Partfile+=bytes;
			else						sesUpData_File+=bytes;

			//	Add to our total for sent bytes...
			theApp.UpdateSentBytes(bytes, sentToFriend);

			break;

		case false:
			// Downline Data
			switch (uClientID){
                // Update session client breakdown stats for received bytes...
				case SO_EMULE:
				case SO_OLDEMULE:		sesDownData_EMULE+=bytes;		break;
				case SO_EDONKEYHYBRID:	sesDownData_EDONKEYHYBRID+=bytes;break;
				case SO_EDONKEY:		sesDownData_EDONKEY+=bytes;		break;
				case SO_MLDONKEY:		sesDownData_MLDONKEY+=bytes;	break;
				case SO_AMULE:			sesDownData_AMULE+=bytes;		break;
				case SO_SHAREAZA:		sesDownData_SHAREAZA+=bytes;	break;
				case SO_CDONKEY:
				case SO_LPHANT:
				case SO_XMULE:			sesDownData_EMULECOMPAT+=bytes;	break;
				case SO_URL:			sesDownData_URL+=bytes;			break;
// RT, WebCache (Code by JP/yonatan/Superlexx)
				case SO_WEBCACHE:		sesDownData_WEBCACHE += bytes;	break; // Superlexx - webcache - statistics
// End
			}

			switch (uClientPort){
				// Update session port breakdown stats for received bytes...
				// For now we are only going to break it down by default and non-default.
				// A statistical analysis of all data sent from every single port/domain is
				// beyond the scope of this add-on.
				case 4662:				sesDownDataPort_4662+=bytes;	break;
				case (UINT)-1:			sesDownDataPort_PeerCache+=bytes;break;
				//case (UINT)-2:		sesDownDataPort_URL+=bytes;		break;
				default:				sesDownDataPort_OTHER+=bytes;	break;
			}

			//	Add to our total for received bytes...
			theApp.UpdateReceivedBytes(bytes);
	}
}

// Reset Statistics by Khaos

void CPreferences::ResetCumulativeStatistics(){

// RT, Cumulative source breakdown stats for transfer bytes...
	for (uint16 i = 0; i < RT_MOD_COUNT; i++)   rt_CumulativeUploadMod[i] = 0;
	for (uint16 i = 0; i < RT_COUNTRY_COUNT; i++)   rt_CumulativeUploadCountry[i] = 0;
	for (uint16 i = 0; i < RT_MOD_COUNT; i++)   rt_CumulativeDownloadMod[i] = 0;
	for (uint16 i = 0; i < RT_COUNTRY_COUNT; i++)   rt_CumulativeDownloadCountry[i] = 0;
	// Session source breakdown stats for transfer bytes...
	for (uint16 i = 0; i < RT_MOD_COUNT; i++)   rt_SessionUploadMod[i] = 0;
	for (uint16 i = 0; i < RT_COUNTRY_COUNT; i++)   rt_SessionUploadCountry[i] = 0;
	for (uint16 i = 0; i < RT_MOD_COUNT; i++)   rt_SessionDownloadMod[i] = 0;
	for (uint16 i = 0; i < RT_COUNTRY_COUNT; i++)   rt_SessionDownloadCountry[i] = 0;
// RT, WebCache (Code by JP/yonatan/Superlexx)
	cumDownData_WEBCACHE = 0; // Superlexx - webcache - statistics
// End
	// Save a backup so that we can undo this action
	SaveStats(1);

	// SET ALL CUMULATIVE STAT VALUES TO 0  :'-(

	totalDownloadedBytes=0;
	totalUploadedBytes=0;
	cumDownOverheadTotal=0;
	cumDownOverheadFileReq=0;
	cumDownOverheadSrcEx=0;
	cumDownOverheadServer=0;
	cumDownOverheadKad=0;
	cumDownOverheadTotalPackets=0;
	cumDownOverheadFileReqPackets=0;
	cumDownOverheadSrcExPackets=0;
	cumDownOverheadServerPackets=0;
	cumDownOverheadKadPackets=0;
	cumUpOverheadTotal=0;
	cumUpOverheadFileReq=0;
	cumUpOverheadSrcEx=0;
	cumUpOverheadServer=0;
	cumUpOverheadKad=0;
	cumUpOverheadTotalPackets=0;
	cumUpOverheadFileReqPackets=0;
	cumUpOverheadSrcExPackets=0;
	cumUpOverheadServerPackets=0;
	cumUpOverheadKadPackets=0;
	cumUpSuccessfulSessions=0;
	cumUpFailedSessions=0;
	cumUpAvgTime=0;
	cumUpData_EDONKEY=0;
	cumUpData_EDONKEYHYBRID=0;
	cumUpData_EMULE=0;
	cumUpData_MLDONKEY=0;
	cumUpData_AMULE=0;
	cumUpData_EMULECOMPAT=0;
	cumUpData_SHAREAZA=0;
	cumUpDataPort_4662=0;
	cumUpDataPort_OTHER=0;
	cumUpDataPort_PeerCache=0;
	cumDownCompletedFiles=0;
	cumDownSuccessfulSessions=0;
	cumDownFailedSessions=0;
	cumDownAvgTime=0;
	cumLostFromCorruption=0;
	cumSavedFromCompression=0;
	cumPartsSavedByICH=0;
	cumDownData_EDONKEY=0;
	cumDownData_EDONKEYHYBRID=0;
	cumDownData_EMULE=0;
	cumDownData_MLDONKEY=0;
	cumDownData_AMULE=0;
	cumDownData_EMULECOMPAT=0;
	cumDownData_SHAREAZA=0;
	cumDownData_URL=0;
	cumDownDataPort_4662=0;
	cumDownDataPort_OTHER=0;
	cumDownDataPort_PeerCache=0;
	cumConnAvgDownRate=0;
	cumConnMaxAvgDownRate=0;
	cumConnMaxDownRate=0;
	cumConnAvgUpRate=0;
	cumConnRunTime=0;
	cumConnNumReconnects=0;
	cumConnAvgConnections=0;
	cumConnMaxConnLimitReached=0;
	cumConnPeakConnections=0;
	cumConnDownloadTime=0;
	cumConnUploadTime=0;
	cumConnTransferTime=0;
	cumConnServerDuration=0;
	cumConnMaxAvgUpRate=0;
	cumConnMaxUpRate=0;
	cumSrvrsMostWorkingServers=0;
	cumSrvrsMostUsersOnline=0;
	cumSrvrsMostFilesAvail=0;
    cumSharedMostFilesShared=0;
	cumSharedLargestShareSize=0;
	cumSharedLargestAvgFileSize=0;

	// Set the time of last reset...
	time_t timeNow;
	time(&timeNow);
	stat_datetimeLastReset = (__int64)timeNow;

	// Save the reset stats
	SaveStats();
	theApp.emuledlg->statisticswnd->ShowStatistics(true);
}


// Load Statistics
// This used to be integrated in LoadPreferences, but it has been altered
// so that it can be used to load the backup created when the stats are reset.
// Last Modified: 2-22-03 by Khaos
bool CPreferences::LoadStats(int loadBackUp)
{
// RT, Redirect
	if (RT_LoadStatistics() == true)   return true;
// End
	// loadBackUp is 0 by default
	// loadBackUp = 0: Load the stats normally like we used to do in LoadPreferences
	// loadBackUp = 1: Load the stats from statbkup.ini and create a backup of the current stats.  Also, do not initialize session variables.
	// loadBackUp = 2: Load the stats from preferences.ini.old because the version has changed.
	CString sINI;
	CFileFind findBackUp;

	switch (loadBackUp) {
		case 0:{
			// for transition...
			if(PathFileExists(configdir+_T("statistics.ini")))
				sINI.Format(_T("%sstatistics.ini"), configdir);
			else
				sINI.Format(_T("%spreferences.ini"), configdir);

			break;
			   }
		case 1:
			sINI.Format(_T("%sstatbkup.ini"), configdir);
			if (!findBackUp.FindFile(sINI))
				return false;
			SaveStats(2); // Save our temp backup of current values to statbkuptmp.ini, we will be renaming it at the end of this function.
			break;
		case 2:
			sINI.Format(_T("%spreferences.ini.old"),configdir);
			break;
	}

	bool fileex = PathFileExists(sINI);
	CIni ini(sINI, _T("Statistics"));

	totalDownloadedBytes			= ini.GetUInt64(_T("TotalDownloadedBytes"));
	totalUploadedBytes				= ini.GetUInt64(_T("TotalUploadedBytes"));

	// Load stats for cumulative downline overhead
	cumDownOverheadTotal			= ini.GetUInt64(_T("DownOverheadTotal"));
	cumDownOverheadFileReq			= ini.GetUInt64(_T("DownOverheadFileReq"));
	cumDownOverheadSrcEx			= ini.GetUInt64(_T("DownOverheadSrcEx"));
	cumDownOverheadServer			= ini.GetUInt64(_T("DownOverheadServer"));
	cumDownOverheadKad				= ini.GetUInt64(_T("DownOverheadKad"));
	cumDownOverheadTotalPackets		= ini.GetUInt64(_T("DownOverheadTotalPackets"));
	cumDownOverheadFileReqPackets	= ini.GetUInt64(_T("DownOverheadFileReqPackets"));
	cumDownOverheadSrcExPackets		= ini.GetUInt64(_T("DownOverheadSrcExPackets"));
	cumDownOverheadServerPackets	= ini.GetUInt64(_T("DownOverheadServerPackets"));
	cumDownOverheadKadPackets		= ini.GetUInt64(_T("DownOverheadKadPackets"));

	// Load stats for cumulative upline overhead
	cumUpOverheadTotal				= ini.GetUInt64(_T("UpOverHeadTotal"));
	cumUpOverheadFileReq			= ini.GetUInt64(_T("UpOverheadFileReq"));
	cumUpOverheadSrcEx				= ini.GetUInt64(_T("UpOverheadSrcEx"));
	cumUpOverheadServer				= ini.GetUInt64(_T("UpOverheadServer"));
	cumUpOverheadKad				= ini.GetUInt64(_T("UpOverheadKad"));
	cumUpOverheadTotalPackets		= ini.GetUInt64(_T("UpOverHeadTotalPackets"));
	cumUpOverheadFileReqPackets		= ini.GetUInt64(_T("UpOverheadFileReqPackets"));
	cumUpOverheadSrcExPackets		= ini.GetUInt64(_T("UpOverheadSrcExPackets"));
	cumUpOverheadServerPackets		= ini.GetUInt64(_T("UpOverheadServerPackets"));
	cumUpOverheadKadPackets			= ini.GetUInt64(_T("UpOverheadKadPackets"));

	// Load stats for cumulative upline data
	cumUpSuccessfulSessions			= ini.GetInt(_T("UpSuccessfulSessions"));
	cumUpFailedSessions				= ini.GetInt(_T("UpFailedSessions"));
	cumUpAvgTime					= ini.GetInt(_T("UpAvgTime"));

	// Load cumulative client breakdown stats for sent bytes
	cumUpData_EDONKEY				= ini.GetUInt64(_T("UpData_EDONKEY"));
	cumUpData_EDONKEYHYBRID			= ini.GetUInt64(_T("UpData_EDONKEYHYBRID"));
	cumUpData_EMULE					= ini.GetUInt64(_T("UpData_EMULE"));
	cumUpData_MLDONKEY				= ini.GetUInt64(_T("UpData_MLDONKEY"));
	cumUpData_EMULECOMPAT			= ini.GetUInt64(_T("UpData_LMULE"));
	cumUpData_AMULE					= ini.GetUInt64(_T("UpData_AMULE"));
	cumUpData_SHAREAZA				= ini.GetUInt64(_T("UpData_SHAREAZA"));

	// Load cumulative port breakdown stats for sent bytes
	cumUpDataPort_4662				= ini.GetUInt64(_T("UpDataPort_4662"));
	cumUpDataPort_OTHER				= ini.GetUInt64(_T("UpDataPort_OTHER"));
	cumUpDataPort_PeerCache			= ini.GetUInt64(_T("UpDataPort_PeerCache"));

	// Load cumulative source breakdown stats for sent bytes
	cumUpData_File					= ini.GetUInt64(_T("UpData_File"));
	cumUpData_Partfile				= ini.GetUInt64(_T("UpData_Partfile"));

	// Load stats for cumulative downline data
	cumDownCompletedFiles			= ini.GetInt(_T("DownCompletedFiles"));
	cumDownSuccessfulSessions		= ini.GetInt(_T("DownSuccessfulSessions"));
	cumDownFailedSessions			= ini.GetInt(_T("DownFailedSessions"));
	cumDownAvgTime					= ini.GetInt(_T("DownAvgTime"));

	// Cumulative statistics for saved due to compression/lost due to corruption
	cumLostFromCorruption			= ini.GetUInt64(_T("LostFromCorruption"));
	cumSavedFromCompression			= ini.GetUInt64(_T("SavedFromCompression"));
	cumPartsSavedByICH				= ini.GetInt(_T("PartsSavedByICH"));

	// Load cumulative client breakdown stats for received bytes
	cumDownData_EDONKEY				= ini.GetUInt64(_T("DownData_EDONKEY"));
	cumDownData_EDONKEYHYBRID		= ini.GetUInt64(_T("DownData_EDONKEYHYBRID"));
	cumDownData_EMULE				= ini.GetUInt64(_T("DownData_EMULE"));
	cumDownData_MLDONKEY			= ini.GetUInt64(_T("DownData_MLDONKEY"));
	cumDownData_EMULECOMPAT			= ini.GetUInt64(_T("DownData_LMULE"));
	cumDownData_AMULE				= ini.GetUInt64(_T("DownData_AMULE"));
	cumDownData_SHAREAZA			= ini.GetUInt64(_T("DownData_SHAREAZA"));
	cumDownData_URL					= ini.GetUInt64(_T("DownData_URL"));

	// Load cumulative port breakdown stats for received bytes
	cumDownDataPort_4662			= ini.GetUInt64(_T("DownDataPort_4662"));
	cumDownDataPort_OTHER			= ini.GetUInt64(_T("DownDataPort_OTHER"));
	cumDownDataPort_PeerCache		= ini.GetUInt64(_T("DownDataPort_PeerCache"));

	// Load stats for cumulative connection data
	cumConnAvgDownRate				= ini.GetFloat(_T("ConnAvgDownRate"));
	cumConnMaxAvgDownRate			= ini.GetFloat(_T("ConnMaxAvgDownRate"));
	cumConnMaxDownRate				= ini.GetFloat(_T("ConnMaxDownRate"));
	cumConnAvgUpRate				= ini.GetFloat(_T("ConnAvgUpRate"));
	cumConnMaxAvgUpRate				= ini.GetFloat(_T("ConnMaxAvgUpRate"));
	cumConnMaxUpRate				= ini.GetFloat(_T("ConnMaxUpRate"));
	cumConnRunTime					= ini.GetUInt64(_T("ConnRunTime"));
	cumConnTransferTime				= ini.GetInt(_T("ConnTransferTime"));
	cumConnDownloadTime				= ini.GetInt(_T("ConnDownloadTime"));
	cumConnUploadTime				= ini.GetInt(_T("ConnUploadTime"));
	cumConnServerDuration			= ini.GetInt(_T("ConnServerDuration"));
	cumConnNumReconnects			= ini.GetInt(_T("ConnNumReconnects"));
	cumConnAvgConnections			= ini.GetInt(_T("ConnAvgConnections"));
	cumConnMaxConnLimitReached		= ini.GetInt(_T("ConnMaxConnLimitReached"));
	cumConnPeakConnections			= ini.GetInt(_T("ConnPeakConnections"));

	// Load date/time of last reset
	stat_datetimeLastReset			= ini.GetUInt64(_T("statsDateTimeLastReset"));

	// Smart Load For Restores - Don't overwrite records that are greater than the backed up ones
	if (loadBackUp == 1)
	{
		// Load records for servers / network
		if ((UINT)ini.GetInt(_T("SrvrsMostWorkingServers")) > cumSrvrsMostWorkingServers)
			cumSrvrsMostWorkingServers = ini.GetInt(_T("SrvrsMostWorkingServers"));

		if ((UINT)ini.GetInt(_T("SrvrsMostUsersOnline")) > cumSrvrsMostUsersOnline)
			cumSrvrsMostUsersOnline = ini.GetInt(_T("SrvrsMostUsersOnline"));

		if ((UINT)ini.GetInt(_T("SrvrsMostFilesAvail")) > cumSrvrsMostFilesAvail)
			cumSrvrsMostFilesAvail = ini.GetInt(_T("SrvrsMostFilesAvail"));

		// Load records for shared files
		if ((UINT)ini.GetInt(_T("SharedMostFilesShared")) > cumSharedMostFilesShared)
			cumSharedMostFilesShared =	ini.GetInt(_T("SharedMostFilesShared"));

		uint64 temp64 = ini.GetUInt64(_T("SharedLargestShareSize"));
		if (temp64 > cumSharedLargestShareSize)
			cumSharedLargestShareSize = temp64;

		temp64 = ini.GetUInt64(_T("SharedLargestAvgFileSize"));
		if (temp64 > cumSharedLargestAvgFileSize)
			cumSharedLargestAvgFileSize = temp64;

		temp64 = ini.GetUInt64(_T("SharedLargestFileSize"));
		if (temp64 > cumSharedLargestFileSize)
			cumSharedLargestFileSize = temp64;

		// Check to make sure the backup of the values we just overwrote exists.  If so, rename it to the backup file.
		// This allows us to undo a restore, so to speak, just in case we don't like the restored values...
		CString sINIBackUp;
		sINIBackUp.Format(_T("%sstatbkuptmp.ini"), configdir);
		if (findBackUp.FindFile(sINIBackUp)){
			CFile::Remove(sINI);				// Remove the backup that we just restored from
			CFile::Rename(sINIBackUp, sINI);	// Rename our temporary backup to the normal statbkup.ini filename.
		}

		// Since we know this is a restore, now we should call ShowStatistics to update the data items to the new ones we just loaded.
		// Otherwise user is left waiting around for the tick counter to reach the next automatic update (Depending on setting in prefs)
		theApp.emuledlg->statisticswnd->ShowStatistics();
	}
	// Stupid Load -> Just load the values.
	else
	{
		// Load records for servers / network
		cumSrvrsMostWorkingServers	= ini.GetInt(_T("SrvrsMostWorkingServers"));
		cumSrvrsMostUsersOnline		= ini.GetInt(_T("SrvrsMostUsersOnline"));
		cumSrvrsMostFilesAvail		= ini.GetInt(_T("SrvrsMostFilesAvail"));

		// Load records for shared files
		cumSharedMostFilesShared	= ini.GetInt(_T("SharedMostFilesShared"));
		cumSharedLargestShareSize	= ini.GetUInt64(_T("SharedLargestShareSize"));
		cumSharedLargestAvgFileSize = ini.GetUInt64(_T("SharedLargestAvgFileSize"));
		cumSharedLargestFileSize	= ini.GetUInt64(_T("SharedLargestFileSize"));

		// Initialize new session statistic variables...
		sesDownCompletedFiles		= 0;
		
		sesUpData_EDONKEY			= 0;
		sesUpData_EDONKEYHYBRID		= 0;
		sesUpData_EMULE				= 0;
		sesUpData_MLDONKEY			= 0;
		sesUpData_AMULE				= 0;
		sesUpData_EMULECOMPAT		= 0;
		sesUpData_SHAREAZA			= 0;
		sesUpDataPort_4662			= 0;
		sesUpDataPort_OTHER			= 0;
		sesUpDataPort_PeerCache		= 0;

		sesDownData_EDONKEY			= 0;
		sesDownData_EDONKEYHYBRID	= 0;
		sesDownData_EMULE			= 0;
		sesDownData_MLDONKEY		= 0;
		sesDownData_AMULE			= 0;
		sesDownData_EMULECOMPAT		= 0;
		sesDownData_SHAREAZA		= 0;
		sesDownData_URL				= 0;
		sesDownDataPort_4662		= 0;
		sesDownDataPort_OTHER		= 0;
		sesDownDataPort_PeerCache	= 0;

		sesDownSuccessfulSessions	= 0;
		sesDownFailedSessions		= 0;
		sesPartsSavedByICH			= 0;
	}

	if (!fileex)
	{
		time_t timeNow;
		time(&timeNow);
		stat_datetimeLastReset = (__int64)timeNow;
	}

	return true;
}

// This formats the UTC long value that is saved for stat_datetimeLastReset
// If this value is 0 (Never reset), then it returns Unknown.
CString CPreferences::GetStatsLastResetStr(bool formatLong)
{
	// formatLong dictates the format of the string returned.
	// For example...
	// true: DateTime format from the .ini
	// false: DateTime format from the .ini for the log
	CString	returnStr;
	if (GetStatsLastResetLng()) {
		tm *statsReset;
		TCHAR szDateReset[128];
		time_t lastResetDateTime = (time_t) GetStatsLastResetLng();
		statsReset = localtime(&lastResetDateTime);
		if (statsReset){
			_tcsftime(szDateReset, ARRSIZE(szDateReset), formatLong ? GetDateTimeFormat() : GetDateTimeFormat4Log(), statsReset);
			returnStr = szDateReset;
		}
	}
	if (returnStr.IsEmpty())
		returnStr = GetResString(IDS_UNKNOWN);
	return returnStr;
}

// <-----khaos-

bool CPreferences::Save(){

	bool error = false;
	TCHAR* fullpath = new TCHAR[_tcslen(configdir)+MAX_PATH]; // i_a
	_stprintf(fullpath,_T("%spreferences.dat"),configdir);

	FILE* preffile = _tfsopen(fullpath,_T("wb"), _SH_DENYWR);
	prefsExt->version = PREFFILE_VERSION;

	// -khaos--+++> Don't save stats if preferences.ini doesn't exist yet (Results in unhandled exception).
	_stprintf(fullpath,_T("%spreferences.ini"),configdir);
	bool bSaveStats = true;
	if (!PathFileExists(fullpath))
		bSaveStats = false;
	// <-----khaos-

	delete[] fullpath;
	if (preffile){
		prefsExt->version=PREFFILE_VERSION;
		prefsExt->EmuleWindowPlacement=EmuleWindowPlacement;
		md4cpy(prefsExt->userhash, userhash);

		error = fwrite(prefsExt,sizeof(Preferences_Ext_Struct),1,preffile);
		if (thePrefs.GetCommitFiles() >= 2 || (thePrefs.GetCommitFiles() >= 1 && !theApp.emuledlg->IsRunning())){
			fflush(preffile); // flush file stream buffers to disk buffers
			(void)_commit(_fileno(preffile)); // commit disk buffers to disk
		}
		fclose(preffile);
	}
	else
		error = true;

	SavePreferences();
// RT, Save Ratio Setting
	RT_SaveSettings();
// End
	// -khaos--+++> SaveStats is now called here instead of from SavePreferences...
	if (bSaveStats)
		SaveStats();
	// <-----khaos-

	fullpath = new TCHAR[_tcslen(configdir) + 14];
	_stprintf(fullpath, _T("%sshareddir.dat"), configdir);
	CStdioFile sdirfile;
	if (sdirfile.Open(fullpath, CFile::modeCreate | CFile::modeWrite | CFile::shareDenyWrite | CFile::typeBinary))
	{
		try{
			// write Unicode byte-order mark 0xFEFF
			WORD wBOM = 0xFEFF;
			sdirfile.Write(&wBOM, sizeof(wBOM));
			for (POSITION pos = shareddir_list.GetHeadPosition();pos != 0;){
				sdirfile.WriteString(shareddir_list.GetNext(pos).GetBuffer());
				sdirfile.Write(_T("\r\n"), sizeof(TCHAR)*2);
			}
			if (thePrefs.GetCommitFiles() >= 2 || (thePrefs.GetCommitFiles() >= 1 && !theApp.emuledlg->IsRunning())){
				sdirfile.Flush(); // flush file stream buffers to disk buffers
				if (_commit(_fileno(sdirfile.m_pStream)) != 0) // commit disk buffers to disk
					AfxThrowFileException(CFileException::hardIO, GetLastError(), sdirfile.GetFileName());
			}
			sdirfile.Close();
		}
		catch(CFileException* error){
			TCHAR buffer[MAX_CFEXP_ERRORMSG];
			error->GetErrorMessage(buffer,ARRSIZE(buffer));
			if (thePrefs.GetVerbose())
				AddDebugLogLine(true,_T("Failed to save %s - %s"), fullpath, buffer);
			error->Delete();
		}
	}
	else
		error = true;
	delete[] fullpath;
	fullpath=NULL;
	::CreateDirectory(GetIncomingDir(),0);
	::CreateDirectory(GetTempDir(),0);
	return error;
}

void CPreferences::CreateUserHash()
{
	for (int i = 0; i < 8; i++)
	{
		uint16 random = GetRandomUInt16();
		memcpy(&userhash[i*2], &random, 2);
	}

	// mark as emule client. that will be need in later version
	userhash[5] = 14;
	userhash[14] = 111;
}

int CPreferences::GetColumnWidth(Table t, int index)
{
	switch(t) {
	case tableDownload:
		return downloadColumnWidths[index];
	case tableUpload:
		return uploadColumnWidths[index];
	case tableQueue:
		return queueColumnWidths[index];
	case tableSearch:
		return searchColumnWidths[index];
	case tableShared:
		return sharedColumnWidths[index];
	case tableServer:
		return serverColumnWidths[index];
	case tableClientList:
		return clientListColumnWidths[index];
	case tableFilenames:
		return FilenamesListColumnWidths[index];
	}
	return 0;
}

void CPreferences::SetColumnWidth(Table t, int index, int width) {
	switch(t) {
	case tableDownload:
		downloadColumnWidths[index] = width;
		break;
	case tableUpload:
		uploadColumnWidths[index] = width;
		break;
	case tableQueue:
		queueColumnWidths[index] = width;
		break;
	case tableSearch:
		searchColumnWidths[index] = width;
		break;
	case tableShared:
		sharedColumnWidths[index] = width;
		break;
	case tableServer:
		serverColumnWidths[index] = width;
		break;
	case tableClientList:
		clientListColumnWidths[index] = width;
		break;
	case tableFilenames:
		FilenamesListColumnWidths[index] = width;
		break;
	}
}

BOOL CPreferences::GetColumnHidden(Table t, int index)
{
	switch(t) {
	case tableDownload:
		return downloadColumnHidden[index];
	case tableUpload:
		return uploadColumnHidden[index];
	case tableQueue:
		return queueColumnHidden[index];
	case tableSearch:
		return searchColumnHidden[index];
	case tableShared:
		return sharedColumnHidden[index];
	case tableServer:
		return serverColumnHidden[index];
	case tableClientList:
		return clientListColumnHidden[index];
	case tableFilenames:
		return FilenamesListColumnHidden[index];
	}
	return FALSE;
}

void CPreferences::SetColumnHidden(Table t, int index, BOOL bHidden) {
	switch(t) {
	case tableDownload:
		downloadColumnHidden[index] = bHidden;
		break;
	case tableUpload:
		uploadColumnHidden[index] = bHidden;
		break;
	case tableQueue:
		queueColumnHidden[index] = bHidden;
		break;
	case tableSearch:
		searchColumnHidden[index] = bHidden;
		break;
	case tableShared:
		sharedColumnHidden[index] = bHidden;
		break;
	case tableServer:
		serverColumnHidden[index] = bHidden;
		break;
	case tableClientList:
		clientListColumnHidden[index] = bHidden;
		break;
	case tableFilenames:
		FilenamesListColumnHidden[index] = bHidden;
		break;
	}
}

int CPreferences::GetColumnOrder(Table t, int index)
{
	switch(t) {
	case tableDownload:
		return downloadColumnOrder[index];
	case tableUpload:
		return uploadColumnOrder[index];
	case tableQueue:
		return queueColumnOrder[index];
	case tableSearch:
		return searchColumnOrder[index];
	case tableShared:
		return sharedColumnOrder[index];
	case tableServer:
		return serverColumnOrder[index];
	case tableClientList:
		return clientListColumnOrder[index];
	case tableFilenames:
		return FilenamesListColumnOrder[index];
	}
	return 0;
}

void CPreferences::SetColumnOrder(Table t, INT *piOrder) {
	switch(t) {
	case tableDownload:
		memcpy(downloadColumnOrder, piOrder, sizeof(downloadColumnOrder));
		break;
	case tableUpload:
		memcpy(uploadColumnOrder, piOrder, sizeof(uploadColumnOrder));
		break;
	case tableQueue:
		memcpy(queueColumnOrder, piOrder, sizeof(queueColumnOrder));
		break;
	case tableSearch:
		memcpy(searchColumnOrder, piOrder, sizeof(searchColumnOrder));
		break;
	case tableShared:
		memcpy(sharedColumnOrder, piOrder, sizeof(sharedColumnOrder));
		break;
	case tableServer:
		memcpy(serverColumnOrder, piOrder, sizeof(serverColumnOrder));
		break;
	case tableClientList:
		memcpy(clientListColumnOrder, piOrder, sizeof(clientListColumnOrder));
		break;
	case tableFilenames:
		memcpy(FilenamesListColumnOrder, piOrder, sizeof(FilenamesListColumnOrder));
		break;
	}
}

int CPreferences::GetRecommendedMaxConnections() {
	int iRealMax = ::GetMaxWindowsTCPConnections();
	if(iRealMax == -1 || iRealMax > 520)
		return 500;

	if(iRealMax < 20)
		return iRealMax;

	if(iRealMax <= 256)
		return iRealMax - 10;

	return iRealMax - 20;
}

// RT, New Code at Bottom
/* Original
void CPreferences::SavePreferences()
{
	USES_CONVERSION;
	CString buffer;
	TCHAR* fullpath = new TCHAR[_tcslen(configdir)+MAX_PATH]; // i_a
	_stprintf(fullpath,_T("%spreferences.ini"),configdir);
	
	CIni ini( fullpath, _T("eMule") );
	delete[] fullpath;
	fullpath=NULL;
	//---
	ini.WriteString(_T("AppVersion"), theApp.m_strCurVersionLong);
	//---

#ifdef _DEBUG
	ini.WriteInt(_T("DebugHeap"), m_iDbgHeap);
#endif

	ini.WriteStringUTF8(_T("Nick"), strNick);
	ini.WriteString(_T("IncomingDir"), incomingdir);
	ini.WriteString(_T("TempDir"), tempdir);

    ini.WriteInt(_T("MinUpload"), minupload);
	ini.WriteInt(_T("MaxUpload"),maxupload);
	ini.WriteInt(_T("MaxDownload"),maxdownload);
	ini.WriteInt(_T("MaxConnections"),maxconnections);
	ini.WriteInt(_T("MaxHalfConnections"),maxhalfconnections);
	ini.WriteInt(_T("Port"),port);
	ini.WriteInt(_T("UDPPort"),udpport);
	ini.WriteInt(_T("ServerUDPPort"), nServerUDPPort);
	ini.WriteInt(_T("MaxSourcesPerFile"),maxsourceperfile );
	ini.WriteWORD(_T("Language"),m_wLanguageID);
	ini.WriteInt(_T("SeeShare"),m_iSeeShares);
	ini.WriteInt(_T("ToolTipDelay"),m_iToolDelayTime);
	ini.WriteInt(_T("StatGraphsInterval"),trafficOMeterInterval);
	ini.WriteInt(_T("StatsInterval"),statsInterval);
	ini.WriteInt(_T("DownloadCapacity"),maxGraphDownloadRate);
	ini.WriteInt(_T("UploadCapacity"),maxGraphUploadRate);
	ini.WriteInt(_T("DeadServerRetry"),deadserverretries);
	ini.WriteInt(_T("ServerKeepAliveTimeout"),m_dwServerKeepAliveTimeout);
	ini.WriteInt(_T("SplitterbarPosition"),splitterbarPosition+2);
	ini.WriteInt(_T("SplitterbarPositionStat"),splitterbarPositionStat+1,_T("eMule"));
	ini.WriteInt(_T("SplitterbarPositionStat_HL"),splitterbarPositionStat_HL+1,_T("eMule"));
	ini.WriteInt(_T("SplitterbarPositionStat_HR"),splitterbarPositionStat_HR+1,_T("eMule"));
	ini.WriteInt(_T("SplitterbarPositionFriend"),splitterbarPositionFriend,_T("eMule"));
	ini.WriteInt(_T("SplitterbarPositionIRC"),splitterbarPositionIRC+2,_T("eMule"));
	ini.WriteInt(_T("TransferWnd2"),m_uTransferWnd2);
	ini.WriteInt(_T("VariousStatisticsMaxValue"),statsMax);
	ini.WriteInt(_T("StatsAverageMinutes"),statsAverageMinutes);
	ini.WriteInt(_T("MaxConnectionsPerFiveSeconds"),MaxConperFive);
	ini.WriteInt(_T("Check4NewVersionDelay"),versioncheckdays);

	ini.WriteBool(_T("Reconnect"),reconnect);
	ini.WriteBool(_T("Scoresystem"),scorsystem);
	ini.WriteBool(_T("Serverlist"),autoserverlist);
	ini.WriteBool(_T("UpdateNotifyTestClient"),updatenotify);
	ini.WriteBool(_T("MinToTray"),mintotray);
	ini.WriteBool(_T("AddServersFromServer"),addserversfromserver);
	ini.WriteBool(_T("AddServersFromClient"),addserversfromclient);
	ini.WriteBool(_T("Splashscreen"),splashscreen);
	ini.WriteBool(_T("BringToFront"),bringtoforeground);
	ini.WriteBool(_T("TransferDoubleClick"),transferDoubleclick);
	ini.WriteBool(_T("BeepOnError"),beepOnError);
	ini.WriteBool(_T("ConfirmExit"),confirmExit);
	ini.WriteBool(_T("FilterBadIPs"),filterLANIPs);
    ini.WriteBool(_T("Autoconnect"),autoconnect);
	ini.WriteBool(_T("OnlineSignature"),onlineSig);
	ini.WriteBool(_T("StartupMinimized"),startMinimized);
	ini.WriteBool(_T("AutoStart"),m_bAutoStart);
	ini.WriteInt(_T("LastMainWndDlgID"),m_iLastMainWndDlgID);
	ini.WriteInt(_T("LastLogPaneID"),m_iLastLogPaneID);
	ini.WriteBool(_T("SafeServerConnect"),safeServerConnect);
	ini.WriteBool(_T("ShowRatesOnTitle"),showRatesInTitle);
	ini.WriteBool(_T("IndicateRatings"),indicateratings);
	ini.WriteBool(_T("WatchClipboard4ED2kFilelinks"),watchclipboard);
	ini.WriteInt(_T("SearchMethod"),m_iSearchMethod);
	ini.WriteBool(_T("CheckDiskspace"),checkDiskspace);	// SLUGFILLER: checkDiskspace
	ini.WriteInt(_T("MinFreeDiskSpace"),m_uMinFreeDiskSpace);
	ini.WriteBool(_T("SparsePartFiles"),m_bSparsePartFiles);
	ini.WriteString(_T("YourHostname"),m_strYourHostname);

	// Barry - New properties...
    ini.WriteBool(_T("AutoConnectStaticOnly"), autoconnectstaticonly);  
	ini.WriteBool(_T("AutoTakeED2KLinks"), autotakeed2klinks);  
    ini.WriteBool(_T("AddNewFilesPaused"), addnewfilespaused);  
    ini.WriteInt (_T("3DDepth"), depth3D);  

	ini.WriteBool(_T("NotifyOnDownload"),useDownloadNotifier); // Added by enkeyDEV
	ini.WriteBool(_T("NotifyOnNewDownload"),useNewDownloadNotifier);
	ini.WriteBool(_T("NotifyOnChat"),useChatNotifier);		  
	ini.WriteBool(_T("NotifyOnLog"),useLogNotifier);
	ini.WriteBool(_T("NotifierUseSound"),useSoundInNotifier);
	ini.WriteBool(_T("NotifierPopEveryChatMessage"),notifierPopsEveryChatMsg);
	ini.WriteBool(_T("NotifierPopNewVersion"),notifierNewVersion);
	ini.WriteBool(_T("NotifyOnImportantError"), notifierImportantError);
	ini.WriteString(_T("NotifierSoundPath"),notifierSoundFilePath);
	ini.WriteString(_T("NotifierConfiguration"),notifierConfiguration);

	ini.WriteString(_T("TxtEditor"),TxtEditor);
	ini.WriteString(_T("VideoPlayer"),VideoPlayer);
	ini.WriteString(_T("MessageFilter"),messageFilter);
	ini.WriteString(_T("CommentFilter"),commentFilter);
	ini.WriteString(_T("DateTimeFormat"),GetDateTimeFormat());
	ini.WriteString(_T("DateTimeFormat4Log"),GetDateTimeFormat4Log());
	ini.WriteString(_T("WebTemplateFile"),m_sTemplateFile);
	ini.WriteString(_T("FilenameCleanups"),filenameCleanups);
	ini.WriteInt(_T("ExtractMetaData"),m_iExtractMetaData);

	ini.WriteString(_T("DefaultIRCServerNew"),m_sircserver);
	ini.WriteString(_T("IRCNick"),m_sircnick);
	ini.WriteBool(_T("IRCAddTimestamp"), m_bircaddtimestamp);
	ini.WriteString(_T("IRCFilterName"), m_sircchannamefilter);
	ini.WriteInt(_T("IRCFilterUser"), m_iircchanneluserfilter);
	ini.WriteBool(_T("IRCUseFilter"), m_bircusechanfilter);
	ini.WriteString(_T("IRCPerformString"), m_sircperformstring);
	ini.WriteBool(_T("IRCUsePerform"), m_bircuseperform);
	ini.WriteBool(_T("IRCListOnConnect"), m_birclistonconnect);
	ini.WriteBool(_T("IRCAcceptLink"), m_bircacceptlinks);
	ini.WriteBool(_T("IRCAcceptLinkFriends"), m_bircacceptlinksfriends);
	ini.WriteBool(_T("IRCSoundEvents"), m_bircsoundevents);
	ini.WriteBool(_T("IRCIgnoreMiscMessages"), m_bircignoremiscmessage);
	ini.WriteBool(_T("IRCIgnoreJoinMessages"), m_bircignorejoinmessage);
	ini.WriteBool(_T("IRCIgnorePartMessages"), m_bircignorepartmessage);
	ini.WriteBool(_T("IRCIgnoreQuitMessages"), m_bircignorequitmessage);
	ini.WriteBool(_T("IRCIgnoreEmuleProtoAddFriend"), m_bircignoreemuleprotoaddfriend);
	ini.WriteBool(_T("IRCAllowEmuleProtoAddFriend"), m_bircallowemuleprotoaddfriend);
	ini.WriteBool(_T("IRCIgnoreEmuleProtoSendLink"), m_bircignoreemuleprotosendlink);
	ini.WriteBool(_T("IRCHelpChannel"), m_birchelpchannel);
	ini.WriteBool(_T("SmartIdCheck"), smartidcheck);
	ini.WriteBool(_T("Verbose"), m_bVerbose);
	ini.WriteBool(_T("DebugSourceExchange"), m_bDebugSourceExchange);	// do *not* use the according 'Get...' function here!
	ini.WriteBool(_T("LogBannedClients"), m_bLogBannedClients);			// do *not* use the according 'Get...' function here!
	ini.WriteBool(_T("LogRatingDescReceived"), m_bLogRatingDescReceived);// do *not* use the according 'Get...' function here!
	ini.WriteBool(_T("LogSecureIdent"), m_bLogSecureIdent);				// do *not* use the according 'Get...' function here!
	ini.WriteBool(_T("LogFilteredIPs"), m_bLogFilteredIPs);				// do *not* use the according 'Get...' function here!
	ini.WriteBool(_T("LogFileSaving"), m_bLogFileSaving);				// do *not* use the according 'Get...' function here!
    ini.WriteBool(_T("LogA4AF"), m_bLogA4AF);                           // do *not* use the according 'Get...' function here!
	ini.WriteBool(_T("LogUlDlEvents"), m_bLogUlDlEvents);
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	// following options are for debugging or when using an external debug device viewer only.
	ini.WriteInt(_T("DebugServerTCP"),m_iDebugServerTCPLevel);
	ini.WriteInt(_T("DebugServerUDP"),m_iDebugServerUDPLevel);
	ini.WriteInt(_T("DebugServerSources"),m_iDebugServerSourcesLevel);
	ini.WriteInt(_T("DebugServerSearches"),m_iDebugServerSearchesLevel);
	ini.WriteInt(_T("DebugClientTCP"),m_iDebugClientTCPLevel);
	ini.WriteInt(_T("DebugClientUDP"),m_iDebugClientUDPLevel);
	ini.WriteInt(_T("DebugClientKadUDP"),m_iDebugClientKadUDPLevel);
#endif
	ini.WriteBool(_T("PreviewPrio"), m_bpreviewprio);
	ini.WriteBool(_T("UpdateQueueListPref"), m_bupdatequeuelist);
	ini.WriteBool(_T("ManualHighPrio"), m_bmanualhighprio);
	ini.WriteBool(_T("FullChunkTransfers"), m_btransferfullchunks);
	ini.WriteBool(_T("ShowOverhead"), m_bshowoverhead);
	ini.WriteBool(_T("VideoPreviewBackupped"), moviePreviewBackup);
	ini.WriteInt(_T("StartNextFile"), m_istartnextfile);

	ini.DeleteKey(_T("FileBufferSizePref")); // delete old 'file buff size' setting
	ini.WriteInt(_T("FileBufferSize"), m_iFileBufferSize);

	ini.DeleteKey(_T("QueueSizePref")); // delete old 'queue size' setting
	ini.WriteInt(_T("QueueSize"), m_iQueueSize);

	ini.WriteInt(_T("CommitFiles"), m_iCommitFiles);
	ini.WriteBool(_T("DAPPref"), m_bDAP);
	ini.WriteBool(_T("UAPPref"), m_bUAP);
	ini.WriteBool(_T("FilterServersByIP"),filterserverbyip);
	ini.WriteBool(_T("DisableKnownClientList"),m_bDisableKnownClientList);
	ini.WriteBool(_T("DisableQueueList"),m_bDisableQueueList);
	ini.WriteBool(_T("UseCreditSystem"),m_bCreditSystem);
	ini.WriteBool(_T("SaveLogToDisk"),log2disk);
	ini.WriteBool(_T("SaveDebugToDisk"),debug2disk);
	ini.WriteBool(_T("EnableScheduler"),scheduler);
	ini.WriteBool(_T("MessagesFromFriendsOnly"),msgonlyfriends);
	ini.WriteBool(_T("MessageFromValidSourcesOnly"),msgsecure);
	ini.WriteBool(_T("ShowInfoOnCatTabs"),showCatTabInfos);
	ini.WriteBool(_T("DontRecreateStatGraphsOnResize"),dontRecreateGraphs);
	ini.WriteBool(_T("AutoFilenameCleanup"),autofilenamecleanup);
	ini.WriteBool(_T("ShowExtControls"),m_bExtControls);
	ini.WriteBool(_T("UseAutocompletion"),m_bUseAutocompl);
	ini.WriteBool(_T("NetworkKademlia"),networkkademlia);
	ini.WriteBool(_T("NetworkED2K"),networked2k);
	ini.WriteBool(_T("AutoClearCompleted"),m_bRemoveFinishedDownloads);
	ini.WriteBool(_T("TransflstRemainOrder"),m_bTransflstRemain);
	ini.WriteBool(_T("UseSimpleTimeRemainingcomputation"),m_bUseOldTimeRemaining);

	ini.WriteInt(_T("VersionCheckLastAutomatic"), versioncheckLastAutomatic);
	ini.WriteInt(_T("FilterLevel"),filterlevel);

	ini.WriteBool(_T("SecureIdent"), m_bUseSecureIdent);// change the name in future version to enable it by default
	ini.WriteBool(_T("AdvancedSpamFilter"),m_bAdvancedSpamfilter);
	ini.WriteBool(_T("ShowDwlPercentage"),m_bShowDwlPercentage);
	ini.WriteBool(_T("RemoveFilesToBin"),m_bRemove2bin);
	//ini.WriteBool(_T("ShowCopyEd2kLinkCmd"),m_bShowCopyEd2kLinkCmd);

	// Toolbar
	ini.WriteString(_T("ToolbarSetting"), m_sToolbarSettings);
	ini.WriteString(_T("ToolbarBitmap"), m_sToolbarBitmap );
	ini.WriteString(_T("ToolbarBitmapFolder"), m_sToolbarBitmapFolder);
	ini.WriteInt(_T("ToolbarLabels"), m_nToolbarLabels);
	ini.WriteInt(_T("ToolbarIconSize"), m_sizToolbarIconSize.cx);
	ini.WriteString(_T("SkinProfile"), m_strSkinProfile);
	ini.WriteString(_T("SkinProfileDir"), m_strSkinProfileDir);


	ini.SerGet(false, downloadColumnWidths,
		ARRSIZE(downloadColumnWidths), _T("DownloadColumnWidths"));
	ini.SerGet(false, downloadColumnHidden,
		ARRSIZE(downloadColumnHidden), _T("DownloadColumnHidden"));
	ini.SerGet(false, downloadColumnOrder,
		ARRSIZE(downloadColumnOrder), _T("DownloadColumnOrder"));
	ini.SerGet(false, uploadColumnWidths,
		ARRSIZE(uploadColumnWidths), _T("UploadColumnWidths"));
	ini.SerGet(false, uploadColumnHidden,
		ARRSIZE(uploadColumnHidden), _T("UploadColumnHidden"));
	ini.SerGet(false, uploadColumnOrder,
		ARRSIZE(uploadColumnOrder), _T("UploadColumnOrder"));
	ini.SerGet(false, queueColumnWidths,
		ARRSIZE(queueColumnWidths), _T("QueueColumnWidths"));
	ini.SerGet(false, queueColumnHidden,
		ARRSIZE(queueColumnHidden), _T("QueueColumnHidden"));
	ini.SerGet(false, queueColumnOrder,
		ARRSIZE(queueColumnOrder), _T("QueueColumnOrder"));
	ini.SerGet(false, searchColumnWidths,
		ARRSIZE(searchColumnWidths), _T("SearchColumnWidths"));
	ini.SerGet(false, searchColumnHidden,
		ARRSIZE(searchColumnHidden), _T("SearchColumnHidden"));
	ini.SerGet(false, searchColumnOrder,
		ARRSIZE(searchColumnOrder), _T("SearchColumnOrder"));
	ini.SerGet(false, sharedColumnWidths,
		ARRSIZE(sharedColumnWidths), _T("SharedColumnWidths"));
	ini.SerGet(false, sharedColumnHidden,
		ARRSIZE(sharedColumnHidden), _T("SharedColumnHidden"));
	ini.SerGet(false, sharedColumnOrder,
		ARRSIZE(sharedColumnOrder), _T("SharedColumnOrder"));
	ini.SerGet(false, serverColumnWidths,
		ARRSIZE(serverColumnWidths), _T("ServerColumnWidths"));
	ini.SerGet(false, serverColumnHidden,
		ARRSIZE(serverColumnHidden), _T("ServerColumnHidden"));
	ini.SerGet(false, serverColumnOrder,
		ARRSIZE(serverColumnOrder), _T("ServerColumnOrder"));
	ini.SerGet(false, clientListColumnWidths,
		ARRSIZE(clientListColumnWidths), _T("ClientListColumnWidths"));
	ini.SerGet(false, clientListColumnHidden,
		ARRSIZE(clientListColumnHidden), _T("ClientListColumnHidden"));
	ini.SerGet(false, clientListColumnOrder,
		ARRSIZE(clientListColumnOrder), _T("ClientListColumnOrder"));
	
	ini.SerGet(false, FilenamesListColumnWidths,
		ARRSIZE(FilenamesListColumnWidths), _T("FilenamesListColumnWidths"));
	ini.SerGet(false, FilenamesListColumnHidden,
		ARRSIZE(FilenamesListColumnHidden), _T("FilenamesListColumnHidden"));
	ini.SerGet(false, FilenamesListColumnOrder,
		ARRSIZE(FilenamesListColumnOrder), _T("FilenamesListColumnOrder"));

	// Barry - Provide a mechanism for all tables to store/retrieve sort order
	ini.WriteInt(_T("TableSortItemDownload"), tableSortItemDownload);
	ini.WriteInt(_T("TableSortItemUpload"), tableSortItemUpload);
	ini.WriteInt(_T("TableSortItemQueue"), tableSortItemQueue);
	ini.WriteInt(_T("TableSortItemSearch"), tableSortItemSearch);
	ini.WriteInt(_T("TableSortItemShared"), tableSortItemShared);
	ini.WriteInt(_T("TableSortItemServer"), tableSortItemServer);
	ini.WriteInt(_T("TableSortItemClientList"), tableSortItemClientList);
	ini.WriteInt(_T("TableSortItemFilenames"), tableSortItemFilenames);
	ini.WriteBool(_T("TableSortAscendingDownload"), tableSortAscendingDownload);
	ini.WriteBool(_T("TableSortAscendingUpload"), tableSortAscendingUpload);
	ini.WriteBool(_T("TableSortAscendingQueue"), tableSortAscendingQueue);
	ini.WriteBool(_T("TableSortAscendingSearch"), tableSortAscendingSearch);
	ini.WriteBool(_T("TableSortAscendingShared"), tableSortAscendingShared);
	ini.WriteBool(_T("TableSortAscendingServer"), tableSortAscendingServer);
	ini.WriteBool(_T("TableSortAscendingClientList"), tableSortAscendingClientList);
	ini.WriteBool(_T("TableSortAscendingFilenames"), tableSortAscendingFilenames);
	ini.WriteBinary(_T("HyperTextFont"), (LPBYTE)&m_lfHyperText, sizeof m_lfHyperText);
	ini.WriteBinary(_T("LogTextFont"), (LPBYTE)&m_lfLogText, sizeof m_lfLogText);

	// ZZ:UploadSpeedSense -->
    ini.WriteBool(_T("USSEnabled"), m_bDynUpEnabled, _T("eMule"));
    ini.WriteBool(_T("USSUseMillisecondPingTolerance"), m_bDynUpUseMillisecondPingTolerance);
    ini.WriteInt(_T("USSPingTolerance"), m_iDynUpPingTolerance, _T("eMule"));
	ini.WriteInt(_T("USSPingToleranceMilliseconds"), m_iDynUpPingToleranceMilliseconds); // EastShare - Add by TAHO, USS limit
    ini.WriteInt(_T("USSGoingUpDivider"), m_iDynUpGoingUpDivider, _T("eMule"));
    ini.WriteInt(_T("USSGoingDownDivider"), m_iDynUpGoingDownDivider, _T("eMule"));
    ini.WriteInt(_T("USSNumberOfPings"), m_iDynUpNumberOfPings, _T("eMule"));
	// ZZ:UploadSpeedSense <--

    ini.WriteBool(_T("A4AFSaveCpu"), m_bA4AFSaveCpu, _T("eMule")); // ZZ:DownloadManager
	ini.WriteInt(_T("WebMirrorAlertLevel"), m_nWebMirrorAlertLevel);
	ini.WriteBool(_T("RunAsUnprivilegedUser"), m_bRunAsUser);
	ini.WriteBool(_T("OpenPortsOnStartUp"), m_bOpenPortsOnStartUp);
	ini.WriteInt(_T("DebugLogLevel"), m_byLogLevel);
	ini.WriteInt(_T("WinXPSP2"), IsRunningXPSP2());


	///////////////////////////////////////////////////////////////////////////
	// Section: "Proxy"
	//
	ini.WriteBool(_T("ProxyEnablePassword"),proxy.EnablePassword,_T("Proxy"));
	ini.WriteBool(_T("ProxyEnableProxy"),proxy.UseProxy,_T("Proxy"));
	ini.WriteString(_T("ProxyName"),proxy.name,_T("Proxy"));
	ini.WriteString(_T("ProxyPassword"),A2CT(proxy.password),_T("Proxy"));
	ini.WriteString(_T("ProxyUser"),A2CT(proxy.user),_T("Proxy"));
	ini.WriteInt(_T("ProxyPort"),proxy.port,_T("Proxy"));
	ini.WriteInt(_T("ProxyType"),proxy.type,_T("Proxy"));
	ini.WriteBool(_T("ConnectWithoutProxy"),m_bIsASCWOP,_T("Proxy"));
	ini.WriteBool(_T("ShowErrors"),m_bShowProxyErrors,_T("Proxy"));


	///////////////////////////////////////////////////////////////////////////
	// Section: "Statistics"
	//
	ini.WriteInt(_T("statsConnectionsGraphRatio"), statsConnectionsGraphRatio,_T("Statistics"));
	ini.WriteString(_T("statsExpandedTreeItems"), statsExpandedTreeItems);
	CString buffer2;
	for (int i=0;i<15;i++) {
		buffer.Format(_T("0x%06x"),GetStatsColor(i));
		buffer2.Format(_T("StatColor%i"),i);
		ini.WriteString(buffer2,buffer,_T("Statistics") );
	}


	///////////////////////////////////////////////////////////////////////////
	// Section: "WebServer"
	//
	ini.WriteString(_T("Password"), GetWSPass(), _T("WebServer"));
	ini.WriteString(_T("PasswordLow"), GetWSLowPass());
	ini.WriteInt(_T("Port"), m_nWebPort);
	ini.WriteBool(_T("Enabled"), m_bWebEnabled);
	ini.WriteBool(_T("UseGzip"), m_bWebUseGzip);
	ini.WriteInt(_T("PageRefreshTime"), m_nWebPageRefresh);
	ini.WriteBool(_T("UseLowRightsUser"), m_bWebLowEnabled);


	///////////////////////////////////////////////////////////////////////////
	// Section: "MobileMule"
	//
	ini.WriteString(_T("Password"), GetMMPass(), _T("MobileMule"));
	ini.WriteBool(_T("Enabled"), m_bMMEnabled);
	ini.WriteInt(_T("Port"), m_nMMPort);


	///////////////////////////////////////////////////////////////////////////
	// Section: "PeerCache"
	//
	ini.WriteInt(_T("LastSearch"), m_uPeerCacheLastSearch, _T("PeerCache"));
	ini.WriteBool(_T("Found"), m_bPeerCacheWasFound);
	ini.WriteBool(_T("Enabled"), m_bPeerCacheEnabled);
	ini.WriteInt(_T("PCPort"), m_nPeerCachePort);
}
*/

void CPreferences::ResetStatsColor(int index)
{
	switch(index)
	{
		case  0: m_adwStatsColors[ 0]=RGB(  0,  0, 64);break;
		case  1: m_adwStatsColors[ 1]=RGB(192,192,255);break;
		case  2: m_adwStatsColors[ 2]=RGB(128,255,128);break;
		case  3: m_adwStatsColors[ 3]=RGB(  0,210,  0);break;
		case  4: m_adwStatsColors[ 4]=RGB(  0,128,  0);break;
		case  5: m_adwStatsColors[ 5]=RGB(255,128,128);break;
		case  6: m_adwStatsColors[ 6]=RGB(200,  0,  0);break;
		case  7: m_adwStatsColors[ 7]=RGB(140,  0,  0);break;
		case  8: m_adwStatsColors[ 8]=RGB(150,150,255);break;
		case  9: m_adwStatsColors[ 9]=RGB(192,  0,192);break;
		case 10: m_adwStatsColors[10]=RGB(255,255,128);break;
		case 11: m_adwStatsColors[11]=RGB(  0,  0,  0);break;
		case 12: m_adwStatsColors[12]=RGB(255,255,255);break;
		case 13: m_adwStatsColors[13]=RGB(255,255,255);break;
		case 14: m_adwStatsColors[14]=RGB(255,190,190);break;
	}
}

void CPreferences::GetAllStatsColors(int iCount, LPDWORD pdwColors)
{
	memset(pdwColors, 0, sizeof(*pdwColors) * iCount);
	memcpy(pdwColors, m_adwStatsColors, sizeof(*pdwColors) * min(ARRSIZE(m_adwStatsColors), iCount));
}

bool CPreferences::SetAllStatsColors(int iCount, const DWORD* pdwColors)
{
	bool bModified = false;
	int iMin = min(ARRSIZE(m_adwStatsColors), iCount);
	for (int i = 0; i < iMin; i++)
	{
		if (m_adwStatsColors[i] != pdwColors[i])
		{
			m_adwStatsColors[i] = pdwColors[i];
			bModified = true;
		}
	}
	return bModified;
}

void CPreferences::LoadPreferences()
{
	USES_CONVERSION;
	TCHAR buffer[256];
	// -khaos--+++> Fix to stats being lost when version changes!
	int loadstatsFromOld = 0;
	// <-----khaos-

	//--- Quick hack to add version tag to preferences.ini-file and solve the issue with the FlatStatusBar tag...
	CString strFileName;
	strFileName.Format(_T("%spreferences.ini"), configdir);
	CIni* pIni = new CIni(strFileName, _T("eMule"));

	CString strCurrVersion, strPrefsVersion;

	strCurrVersion = theApp.m_strCurVersionLong;
	strPrefsVersion = pIni->GetString(_T("AppVersion"));
	delete pIni;
	m_bFirstStart = false;

	CFileFind findFileName;

// RT, Initial
	bool rt_IsInitial = false;
	if (strPrefsVersion.IsEmpty() == true)
	{
		rt_IsInitial = true;
		m_bFirstStart = true;
	}
	else
	{
		// Remove "RT" Tag
		if (strPrefsVersion.Find(_T("_RT")) == -1)
		{
			if (strPrefsVersion.Find(_T("RT")) == -1)
				rt_IsInitial = true;
			else
				strPrefsVersion.Replace( _T("RT"), _T("") );
		}
		else
			strPrefsVersion.Replace( _T("_RT"), _T("") );
		//
		if (strCurrVersion != strPrefsVersion)
		{
			if (AfxMessageBox(GetResString(RT_IDS_IS_WIZARD), MB_YESNO | MB_DEFBUTTON3) == IDYES)
				m_bFirstStart = true;
		}
	}
/* Original
	if (strCurrVersion != strPrefsVersion){
		m_bFirstStart = true;
		// don't use this; it'll delete all read-only settings from the current pref.ini
//		if(findFileName.FindFile(strFileName)){
//			CFile file;
//			CFileFind findNewName;
//			CString strNewName;
//			strNewName.Format(_T("%spreferences.ini.old"), configdir);
//	
//			if (findNewName.FindFile(strNewName))
//				file.Remove(strNewName);
//	
//			file.Rename(strFileName, strNewName);
//			strFileName = strNewName;
//			// -khaos--+++> Set this to 2 so that LoadStats will load 'em from ini.old
//			loadstatsFromOld = 2;
//			// <-----khaos-
//		}
	}
*/
	CIni ini(strFileName, _T("eMule"));
	//--- end Ozon :)

#ifdef _DEBUG
	m_iDbgHeap = ini.GetInt(_T("DebugHeap"), 1);
#else
	m_iDbgHeap = 0;
#endif

	m_nWebMirrorAlertLevel = ini.GetInt(_T("WebMirrorAlertLevel"),0,_T("eMule"));
	updatenotify=ini.GetBool(_T("UpdateNotifyTestClient"),true, _T("eMule"));

	SetUserNick(ini.GetStringUTF8(_T("Nick"), DEFAULT_NICK));
	if (strNick.IsEmpty() || IsDefaultNick(strNick))
		SetUserNick(DEFAULT_NICK);

	_stprintf(buffer,_T("%sIncoming"),appdir);
	_stprintf(incomingdir,_T("%s"),ini.GetString(_T("IncomingDir"),buffer ));
	MakeFoldername(incomingdir);

	_stprintf(buffer,_T("%sTemp"),appdir);
	_stprintf(tempdir,_T("%s"),ini.GetString(_T("TempDir"),buffer));
	MakeFoldername(tempdir);

	maxGraphDownloadRate=ini.GetInt(_T("DownloadCapacity"),96);
	if (maxGraphDownloadRate==0) maxGraphDownloadRate=96;
	maxGraphUploadRate=ini.GetInt(_T("UploadCapacity"),16);
	if (maxGraphUploadRate==0) maxGraphUploadRate=16;
    minupload=ini.GetInt(_T("MinUpload"), 1);
	maxupload=ini.GetInt(_T("MaxUpload"),12);
	if (maxupload>maxGraphUploadRate && maxupload!=UNLIMITED) maxupload=maxGraphUploadRate*.8;
	maxdownload=ini.GetInt(_T("MaxDownload"),76);
	if (maxdownload>maxGraphDownloadRate && maxdownload!=UNLIMITED) maxdownload=maxGraphDownloadRate*.8;
	maxconnections=ini.GetInt(_T("MaxConnections"),GetRecommendedMaxConnections());
	maxhalfconnections=ini.GetInt(_T("MaxHalfConnections"),9);

	// reset max halfopen to a default if OS changed to SP2 or away
	int dwSP2 = ini.GetInt(_T("WinXPSP2"), -1);
	int dwCurSP2 = IsRunningXPSP2();
	if (dwSP2 != dwCurSP2){
		if (dwCurSP2 == 0)
			maxhalfconnections = 50;
		else if (dwCurSP2 == 1)
			maxhalfconnections = 9;
	}

	port=ini.GetInt(_T("Port"), DEFAULT_TCP_PORT);
	udpport=ini.GetInt(_T("UDPPort"),port+10);
	nServerUDPPort = ini.GetInt(_T("ServerUDPPort"), -1); // 0 = Don't use UDP port for servers, -1 = use a random port (for backward compatibility)
	maxsourceperfile=ini.GetInt(_T("MaxSourcesPerFile"),400 );
	m_wLanguageID=ini.GetWORD(_T("Language"),0);
	m_iSeeShares=(EViewSharedFilesAccess)ini.GetInt(_T("SeeShare"),vsfaNobody);
	m_iToolDelayTime=ini.GetInt(_T("ToolTipDelay"),1);
	trafficOMeterInterval=ini.GetInt(_T("StatGraphsInterval"),3);
	statsInterval=ini.GetInt(_T("statsInterval"),5);
	dontcompressavi=ini.GetBool(_T("DontCompressAvi"),false);

	deadserverretries=ini.GetInt(_T("DeadServerRetry"),1);
	if (deadserverretries > MAX_SERVERFAILCOUNT)
		deadserverretries = MAX_SERVERFAILCOUNT;
	m_dwServerKeepAliveTimeout=ini.GetInt(_T("ServerKeepAliveTimeout"),0);
	splitterbarPosition=ini.GetInt(_T("SplitterbarPosition"),75);
	if (splitterbarPosition < 9)
		splitterbarPosition = 9;
	else if (splitterbarPosition > 93)
		splitterbarPosition = 93;
	splitterbarPositionStat=ini.GetInt(_T("SplitterbarPositionStat"),30);
	splitterbarPositionStat_HL=ini.GetInt(_T("SplitterbarPositionStat_HL"),66);
	splitterbarPositionStat_HR=ini.GetInt(_T("SplitterbarPositionStat_HR"),33);
	if (splitterbarPositionStat_HR+1>=splitterbarPositionStat_HL){
		splitterbarPositionStat_HL = 66;
		splitterbarPositionStat_HR = 33;
	}
	splitterbarPositionFriend=ini.GetInt(_T("SplitterbarPositionFriend"),300);
	splitterbarPositionIRC=ini.GetInt(_T("SplitterbarPositionIRC"),200);

	m_uTransferWnd2 = ini.GetInt(_T("TransferWnd2"),DFLT_TRANSFER_WND2);

	statsMax=ini.GetInt(_T("VariousStatisticsMaxValue"),100);
	statsAverageMinutes=ini.GetInt(_T("StatsAverageMinutes"),5);
	MaxConperFive=ini.GetInt(_T("MaxConnectionsPerFiveSeconds"),GetDefaultMaxConperFive());

	reconnect=ini.GetBool(_T("Reconnect"),true);
	scorsystem=ini.GetBool(_T("Scoresystem"),true);
	ICH=ini.GetBool(_T("ICH"),true);
	autoserverlist=ini.GetBool(_T("Serverlist"),false);

	mintotray=ini.GetBool(_T("MinToTray"),false);
	addserversfromserver=ini.GetBool(_T("AddServersFromServer"),true);
	addserversfromclient=ini.GetBool(_T("AddServersFromClient"),true);
	splashscreen=ini.GetBool(_T("Splashscreen"),true);
	bringtoforeground=ini.GetBool(_T("BringToFront"),true);
	transferDoubleclick=ini.GetBool(_T("TransferDoubleClick"),true);
	beepOnError=ini.GetBool(_T("BeepOnError"),true);
	confirmExit=ini.GetBool(_T("ConfirmExit"),false);
	filterLANIPs=ini.GetBool(_T("FilterBadIPs"),true);
	m_bAllocLocalHostIP=ini.GetBool(_T("AllowLocalHostIP"),false);
	autoconnect=ini.GetBool(_T("Autoconnect"),false);
	showRatesInTitle=ini.GetBool(_T("ShowRatesOnTitle"),false);

	onlineSig=ini.GetBool(_T("OnlineSignature"),false);
	startMinimized=ini.GetBool(_T("StartupMinimized"),false);
	m_bAutoStart=ini.GetBool(_T("AutoStart"),false);
	m_bRestoreLastMainWndDlg=ini.GetBool(_T("RestoreLastMainWndDlg"),false);
	m_iLastMainWndDlgID=ini.GetInt(_T("LastMainWndDlgID"),0);
	m_bRestoreLastLogPane=ini.GetBool(_T("RestoreLastLogPane"),false);
	m_iLastLogPaneID=ini.GetInt(_T("LastLogPaneID"),0);
	safeServerConnect =ini.GetBool(_T("SafeServerConnect"),false);

	m_bTransflstRemain =ini.GetBool(_T("TransflstRemainOrder"),false);
	filterserverbyip=ini.GetBool(_T("FilterServersByIP"),false);
	filterlevel=ini.GetInt(_T("FilterLevel"),127);
	checkDiskspace=ini.GetBool(_T("CheckDiskspace"),false);	// SLUGFILLER: checkDiskspace
	m_uMinFreeDiskSpace=ini.GetInt(_T("MinFreeDiskSpace"),20*1024*1024);
	m_bSparsePartFiles=ini.GetBool(_T("SparsePartFiles"),false);
	m_strYourHostname=ini.GetString(_T("YourHostname"), _T(""));

	// Barry - New properties...
	autoconnectstaticonly = ini.GetBool(_T("AutoConnectStaticOnly"),false); 
	autotakeed2klinks = ini.GetBool(_T("AutoTakeED2KLinks"),true); 
	addnewfilespaused = ini.GetBool(_T("AddNewFilesPaused"),false); 
	depth3D = ini.GetInt(_T("3DDepth"), 0);
	m_bEnableMiniMule = ini.GetBool(_T("MiniMule"), true);

	// as temporarial converter for previous versions
	if (strPrefsVersion < _T("0.25a")) // before 0.25a
		if (ini.GetBool(_T("FlatStatusBar"),false))
			depth3D = 0;
		else 
			depth3D = 5;

    useDownloadNotifier=ini.GetBool(_T("NotifyOnDownload"),false);	// Added by enkeyDEV
	useNewDownloadNotifier=ini.GetBool(_T("NotifyOnNewDownload"),false);
    useChatNotifier=ini.GetBool(_T("NotifyOnChat"),false);
    useLogNotifier=ini.GetBool(_T("NotifyOnLog"),false);
    useSoundInNotifier=ini.GetBool(_T("NotifierUseSound"),false);
	notifierPopsEveryChatMsg=ini.GetBool(_T("NotifierPopEveryChatMessage"),false);
	notifierNewVersion=ini.GetBool(_T("NotifierPopNewVersion"),false);
	notifierImportantError=ini.GetBool(_T("NotifyOnImportantError"),false);
	_stprintf(notifierSoundFilePath,_T("%s"),ini.GetString(_T("NotifierSoundPath"),_T("")));
	_stprintf(notifierConfiguration,_T("%s"),ini.GetString(_T("NotifierConfiguration"),_T(""))); // Added by enkeyDEV
	_stprintf(datetimeformat,_T("%s"),ini.GetString(_T("DateTimeFormat"),_T("%A, %x, %X")));
	if (_tcslen(datetimeformat)==0) _tcscpy(datetimeformat,_T("%A, %x, %X"));

	_stprintf(datetimeformat4log,_T("%s"),ini.GetString(_T("DateTimeFormat4Log"),_T("%c")));
	if (_tcslen(datetimeformat4log)==0) _tcscpy(datetimeformat4log,_T("%c"));

	_stprintf(m_sircserver,_T("%s"),ini.GetString(_T("DefaultIRCServerNew"),_T("ircchat.emule-project.net")));
	_stprintf(m_sircnick,_T("%s"),ini.GetString(_T("IRCNick"),_T("eMule")));
	m_bircaddtimestamp=ini.GetBool(_T("IRCAddTimestamp"),true);
	_stprintf(m_sircchannamefilter,_T("%s"),ini.GetString(_T("IRCFilterName"), _T("") ));
	m_bircusechanfilter=ini.GetBool(_T("IRCUseFilter"), false);
	m_iircchanneluserfilter=ini.GetInt(_T("IRCFilterUser"), 0);
	_stprintf(m_sircperformstring,_T("%s"),ini.GetString(_T("IRCPerformString"), _T("") ));
	m_bircuseperform=ini.GetBool(_T("IRCUsePerform"), false);
	m_birclistonconnect=ini.GetBool(_T("IRCListOnConnect"), true);
	m_bircacceptlinks=ini.GetBool(_T("IRCAcceptLink"), true);
	m_bircacceptlinksfriends=ini.GetBool(_T("IRCAcceptLinkFriends"), true);
	m_bircsoundevents=ini.GetBool(_T("IRCSoundEvents"), false);
	m_bircignoremiscmessage=ini.GetBool(_T("IRCIgnoreMiscMessages"), false);
	m_bircignorejoinmessage=ini.GetBool(_T("IRCIgnoreJoinMessages"), true);
	m_bircignorepartmessage=ini.GetBool(_T("IRCIgnorePartMessages"), true);
	m_bircignorequitmessage=ini.GetBool(_T("IRCIgnoreQuitMessages"), true);
	m_bircignoreemuleprotoaddfriend=ini.GetBool(_T("IRCIgnoreEmuleProtoAddFriend"), false);
	m_bircallowemuleprotoaddfriend=ini.GetBool(_T("IRCAllowEmuleProtoAddFriend"), true);
	m_bircignoreemuleprotosendlink=ini.GetBool(_T("IRCIgnoreEmuleProtoSendLink"), false);
	m_birchelpchannel=ini.GetBool(_T("IRCHelpChannel"),true);
	smartidcheck=ini.GetBool(_T("SmartIdCheck"),true);

	log2disk=ini.GetBool(_T("SaveLogToDisk"),false);
	uMaxLogFileSize = ini.GetInt(_T("MaxLogFileSize"), 1024*1024);
	iMaxLogBuff = ini.GetInt(_T("MaxLogBuff"),64) * 1024;
	m_bEnableVerboseOptions=ini.GetBool(_T("VerboseOptions"), true);
	if (m_bEnableVerboseOptions)
	{
		m_bVerbose=ini.GetBool(_T("Verbose"),false);
		m_bFullVerbose=ini.GetBool(_T("FullVerbose"),false);
		debug2disk=ini.GetBool(_T("SaveDebugToDisk"),false);
		m_bDebugSourceExchange=ini.GetBool(_T("DebugSourceExchange"),false);
		m_bLogBannedClients=ini.GetBool(_T("LogBannedClients"), true);
		m_bLogRatingDescReceived=ini.GetBool(_T("LogRatingDescReceived"),true);
		m_bLogSecureIdent=ini.GetBool(_T("LogSecureIdent"),true);
		m_bLogFilteredIPs=ini.GetBool(_T("LogFilteredIPs"),true);
		m_bLogFileSaving=ini.GetBool(_T("LogFileSaving"),false);
        m_bLogA4AF=ini.GetBool(_T("LogA4AF"),false); // ZZ:DownloadManager
		m_bLogUlDlEvents=ini.GetBool(_T("LogUlDlEvents"),true);
	}
	else
	{
		if (m_bRestoreLastLogPane && m_iLastLogPaneID>=2)
			m_iLastLogPaneID = 1;
	}
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	// following options are for debugging or when using an external debug device viewer only.
	m_iDebugServerTCPLevel=ini.GetInt(_T("DebugServerTCP"),0);
	m_iDebugServerUDPLevel=ini.GetInt(_T("DebugServerUDP"),0);
	m_iDebugServerSourcesLevel=ini.GetInt(_T("DebugServerSources"),0);
	m_iDebugServerSearchesLevel=ini.GetInt(_T("DebugServerSearches"),0);
	m_iDebugClientTCPLevel=ini.GetInt(_T("DebugClientTCP"),0);
	m_iDebugClientUDPLevel=ini.GetInt(_T("DebugClientUDP"),0);
	m_iDebugClientKadUDPLevel=ini.GetInt(_T("DebugClientKadUDP"),0);
#else
	// for normal release builds ensure that those options are all turned off
	m_iDebugServerTCPLevel=0;
	m_iDebugServerUDPLevel=0;
	m_iDebugServerSourcesLevel=0;
	m_iDebugServerSearchesLevel=0;
	m_iDebugClientTCPLevel=0;
	m_iDebugClientUDPLevel=0;
	m_iDebugClientKadUDPLevel=0;
#endif

	m_bpreviewprio=ini.GetBool(_T("PreviewPrio"),false);
	m_bupdatequeuelist=ini.GetBool(_T("UpdateQueueListPref"),false);
	m_bmanualhighprio=ini.GetBool(_T("ManualHighPrio"),false);
	m_btransferfullchunks=ini.GetBool(_T("FullChunkTransfers"),true);
	m_istartnextfile=ini.GetInt(_T("StartNextFile"),0);
	m_bshowoverhead=ini.GetBool(_T("ShowOverhead"),false);
	moviePreviewBackup=ini.GetBool(_T("VideoPreviewBackupped"),true);
	m_iPreviewSmallBlocks=ini.GetInt(_T("PreviewSmallBlocks"), 0);
	m_iPreviewCopiedArchives=ini.GetInt(_T("PreviewCopiedArchives"), 1);
	m_iInspectAllFileTypes=ini.GetInt(_T("InspectAllFileTypes"), 0);

	// read file buffer size (with backward compatibility)
	m_iFileBufferSize=ini.GetInt(_T("FileBufferSizePref"),0); // old setting
	if (m_iFileBufferSize == 0)
		m_iFileBufferSize = 256*1024;
	else
		m_iFileBufferSize = ((m_iFileBufferSize*15000 + 512)/1024)*1024;
	m_iFileBufferSize=ini.GetInt(_T("FileBufferSize"),m_iFileBufferSize);

	// read queue size (with backward compatibility)
	m_iQueueSize=ini.GetInt(_T("QueueSizePref"),0); // old setting
	if (m_iQueueSize == 0)
		m_iQueueSize = 50*100;
	else
		m_iQueueSize = m_iQueueSize*100;
	m_iQueueSize=ini.GetInt(_T("QueueSize"),m_iQueueSize);

	m_iCommitFiles=ini.GetInt(_T("CommitFiles"), 1); // 1 = "commit" on application shut down; 2 = "commit" on each file saveing
	versioncheckdays=ini.GetInt(_T("Check4NewVersionDelay"),5);
	m_bDAP=ini.GetBool(_T("DAPPref"),true);
	m_bUAP=ini.GetBool(_T("UAPPref"),true);
	m_bPreviewOnIconDblClk=ini.GetBool(_T("PreviewOnIconDblClk"),false);
	indicateratings=ini.GetBool(_T("IndicateRatings"),true);
	watchclipboard=ini.GetBool(_T("WatchClipboard4ED2kFilelinks"),false);
	m_iSearchMethod=ini.GetInt(_T("SearchMethod"),0);

	showCatTabInfos=ini.GetBool(_T("ShowInfoOnCatTabs"),false);
//	resumeSameCat=ini.GetBool(_T("ResumeNextFromSameCat"),false);
	dontRecreateGraphs =ini.GetBool(_T("DontRecreateStatGraphsOnResize"),false);
	m_bExtControls =ini.GetBool(_T("ShowExtControls"),false);

	versioncheckLastAutomatic=ini.GetInt(_T("VersionCheckLastAutomatic"),0);
	m_bDisableKnownClientList=ini.GetInt(_T("DisableKnownClientList"),false);
	m_bDisableQueueList=ini.GetInt(_T("DisableQueueList"),false);
	m_bCreditSystem=ini.GetInt(_T("UseCreditSystem"),true);
	scheduler=ini.GetBool(_T("EnableScheduler"),false);
	msgonlyfriends=ini.GetBool(_T("MessagesFromFriendsOnly"),false);
	msgsecure=ini.GetBool(_T("MessageFromValidSourcesOnly"),true);
	autofilenamecleanup=ini.GetBool(_T("AutoFilenameCleanup"),false);
	m_bUseAutocompl=ini.GetBool(_T("UseAutocompletion"),true);
	m_bShowDwlPercentage=ini.GetBool(_T("ShowDwlPercentage"),false);
	networkkademlia=ini.GetBool(_T("NetworkKademlia"),false);
	networked2k=ini.GetBool(_T("NetworkED2K"),true);
	m_bRemove2bin=ini.GetBool(_T("RemoveFilesToBin"),true);
	m_bShowCopyEd2kLinkCmd=ini.GetBool(_T("ShowCopyEd2kLinkCmd"),false);

	m_iMaxChatHistory=ini.GetInt(_T("MaxChatHistoryLines"),100);
	if (m_iMaxChatHistory < 1)
		m_iMaxChatHistory = 100;
	maxmsgsessions=ini.GetInt(_T("MaxMessageSessions"),50);
	m_bShowActiveDownloadsBold = ini.GetBool(_T("ShowActiveDownloadsBold"), false);

	_stprintf(TxtEditor,_T("%s"),ini.GetString(_T("TxtEditor"),_T("notepad.exe")));
	_stprintf(VideoPlayer,_T("%s"),ini.GetString(_T("VideoPlayer"),_T("")));
	
	_stprintf(m_sTemplateFile,_T("%s"),ini.GetString(_T("WebTemplateFile"),_T("eMule.tmpl")));

	_stprintf(messageFilter,_T("%s"),ini.GetString(_T("MessageFilter"),_T("Your client has an infinite queue|Your client is connecting too fast|fastest download speed")));
	commentFilter = ini.GetString(_T("CommentFilter"),_T("http://|www."));
	commentFilter.MakeLower();
	_stprintf(filenameCleanups,_T("%s"),ini.GetString(_T("FilenameCleanups"),_T("http|www.|.com|shared|powered|sponsored|sharelive|filedonkey|saugstube|eselfilme|eseldownloads|emulemovies|spanishare|eselpsychos.de|saughilfe.de|goldesel.6x.to|freedivx.org|elitedivx|deviance|-ftv|ftv|-flt|flt")));
	m_iExtractMetaData=ini.GetInt(_T("ExtractMetaData"),2); // 0=disable, 1=mp3+avi, 2=MediaDet
	m_bAdjustNTFSDaylightFileTime=ini.GetBool(_T("AdjustNTFSDaylightFileTime"), true);

	m_bUseSecureIdent=ini.GetBool(_T("SecureIdent"),true);
	m_bAdvancedSpamfilter=ini.GetBool(_T("AdvancedSpamFilter"),true);
	m_bRemoveFinishedDownloads=ini.GetBool(_T("AutoClearCompleted"),false);
	m_bUseOldTimeRemaining= ini.GetBool(_T("UseSimpleTimeRemainingcomputation"),false);

	// Toolbar
	m_sToolbarSettings = ini.GetString(_T("ToolbarSetting"), strDefaultToolbar);
	m_sToolbarBitmap = ini.GetString(_T("ToolbarBitmap"), _T(""));
	m_sToolbarBitmapFolder = ini.GetString(_T("ToolbarBitmapFolder"), appdir + _T("skins"));
	m_nToolbarLabels = (EToolbarLabelType)ini.GetInt(_T("ToolbarLabels"), CMuleToolbarCtrl::GetDefaultLabelType());
	m_bReBarToolbar = ini.GetBool(_T("ReBarToolbar"), 1);
	m_sizToolbarIconSize.cx = m_sizToolbarIconSize.cy = ini.GetInt(_T("ToolbarIconSize"), 32);
	m_iStraightWindowStyles=ini.GetInt(_T("StraightWindowStyles"),0);
	m_strSkinProfile = ini.GetString(_T("SkinProfile"), _T(""));
	m_strSkinProfileDir = ini.GetString(_T("SkinProfileDir"), appdir + _T("skins"));

// RT, Loaded at Bottom
	ini.SerGet( true, searchColumnWidths, ARRSIZE(searchColumnWidths), _T("SearchColumnWidths") );
	ini.SerGet( true, searchColumnHidden, ARRSIZE(searchColumnHidden), _T("SearchColumnHidden") );
	ini.SerGet( true, searchColumnOrder, ARRSIZE(searchColumnOrder), _T("SearchColumnOrder") );
	ini.SerGet( true, serverColumnWidths, ARRSIZE(serverColumnWidths), _T("ServerColumnWidths") );
	ini.SerGet( true, serverColumnHidden, ARRSIZE(serverColumnHidden), _T("ServerColumnHidden") );
	ini.SerGet( true, serverColumnOrder, ARRSIZE(serverColumnOrder), _T("ServerColumnOrder") );
/* Official
	ini.SerGet(true, downloadColumnWidths,
		ARRSIZE(downloadColumnWidths), _T("DownloadColumnWidths"));
	ini.SerGet(true, downloadColumnHidden,
		ARRSIZE(downloadColumnHidden), _T("DownloadColumnHidden"));
	ini.SerGet(true, downloadColumnOrder,
		ARRSIZE(downloadColumnOrder), _T("DownloadColumnOrder"));
	ini.SerGet(true, uploadColumnWidths,
		ARRSIZE(uploadColumnWidths), _T("UploadColumnWidths"));
	ini.SerGet(true, uploadColumnHidden,
		ARRSIZE(uploadColumnHidden), _T("UploadColumnHidden"));
	ini.SerGet(true, uploadColumnOrder,
		ARRSIZE(uploadColumnOrder), _T("UploadColumnOrder"));
	ini.SerGet(true, queueColumnWidths,
		ARRSIZE(queueColumnWidths), _T("QueueColumnWidths"));
	ini.SerGet(true, queueColumnHidden,
		ARRSIZE(queueColumnHidden), _T("QueueColumnHidden"));
	ini.SerGet(true, queueColumnOrder,
		ARRSIZE(queueColumnOrder), _T("QueueColumnOrder"));
	ini.SerGet(true, searchColumnWidths,
		ARRSIZE(searchColumnWidths), _T("SearchColumnWidths"));
	ini.SerGet(true, searchColumnHidden,
		ARRSIZE(searchColumnHidden), _T("SearchColumnHidden"));
	ini.SerGet(true, searchColumnOrder,
		ARRSIZE(searchColumnOrder), _T("SearchColumnOrder"));
	ini.SerGet(true, sharedColumnWidths,
		ARRSIZE(sharedColumnWidths), _T("SharedColumnWidths"));
	ini.SerGet(true, sharedColumnHidden,
		ARRSIZE(sharedColumnHidden), _T("SharedColumnHidden"));
	ini.SerGet(true, sharedColumnOrder,
		ARRSIZE(sharedColumnOrder), _T("SharedColumnOrder"));
	ini.SerGet(true, serverColumnWidths,
		ARRSIZE(serverColumnWidths), _T("ServerColumnWidths"));
	ini.SerGet(true, serverColumnHidden,
		ARRSIZE(serverColumnHidden), _T("ServerColumnHidden"));
	ini.SerGet(true, serverColumnOrder,
		ARRSIZE(serverColumnOrder), _T("ServerColumnOrder"));
	ini.SerGet(true, clientListColumnWidths,
		ARRSIZE(clientListColumnWidths), _T("ClientListColumnWidths"));
	ini.SerGet(true, clientListColumnHidden,
		ARRSIZE(clientListColumnHidden), _T("ClientListColumnHidden"));
	ini.SerGet(true, clientListColumnOrder,
		ARRSIZE(clientListColumnOrder), _T("ClientListColumnOrder"));
*/	
	ini.SerGet(true, FilenamesListColumnWidths,
		ARRSIZE(FilenamesListColumnWidths), _T("FilenamesListColumnWidths"));
	ini.SerGet(true, FilenamesListColumnHidden,
		ARRSIZE(FilenamesListColumnHidden), _T("FilenamesListColumnHidden"));
	ini.SerGet(true, FilenamesListColumnOrder,
		ARRSIZE(FilenamesListColumnOrder), _T("FilenamesListColumnOrder"));

	// Barry - Provide a mechanism for all tables to store/retrieve sort order
	tableSortItemDownload = ini.GetInt(_T("TableSortItemDownload"), 0);
	tableSortItemUpload = ini.GetInt(_T("TableSortItemUpload"), 0);
	tableSortItemQueue = ini.GetInt(_T("TableSortItemQueue"), 0);
	tableSortItemSearch = ini.GetInt(_T("TableSortItemSearch"), 0);
	tableSortItemShared = ini.GetInt(_T("TableSortItemShared"), 0);
	tableSortItemServer = ini.GetInt(_T("TableSortItemServer"), 0);
	tableSortItemClientList = ini.GetInt(_T("TableSortItemClientList"), 0);
	tableSortItemFilenames = ini.GetInt(_T("TableSortItemFilenames"), 1);

	tableSortAscendingDownload = ini.GetBool(_T("TableSortAscendingDownload"), true);
	tableSortAscendingUpload = ini.GetBool(_T("TableSortAscendingUpload"), true);
	tableSortAscendingQueue = ini.GetBool(_T("TableSortAscendingQueue"), true);
	tableSortAscendingSearch = ini.GetBool(_T("TableSortAscendingSearch"), true);
	tableSortAscendingShared = ini.GetBool(_T("TableSortAscendingShared"), true);
	tableSortAscendingServer = ini.GetBool(_T("TableSortAscendingServer"), true);
	tableSortAscendingClientList = ini.GetBool(_T("TableSortAscendingClientList"), true);
	tableSortAscendingFilenames = ini.GetBool(_T("TableSortAscendingFilenames"), false);

	LPBYTE pData = NULL;
	UINT uSize = sizeof m_lfHyperText;
	if (ini.GetBinary(_T("HyperTextFont"), &pData, &uSize) && uSize == sizeof m_lfHyperText)
		memcpy(&m_lfHyperText, pData, sizeof m_lfHyperText);
	else
		memset(&m_lfHyperText, 0, sizeof m_lfHyperText);
	delete[] pData;

	pData = NULL;
	uSize = sizeof m_lfLogText;
	if (ini.GetBinary(_T("LogTextFont"), &pData, &uSize) && uSize == sizeof m_lfLogText)
		memcpy(&m_lfLogText, pData, sizeof m_lfLogText);
	else
		memset(&m_lfLogText, 0, sizeof m_lfLogText);
	delete[] pData;

	m_crLogError = ini.GetColRef(_T("LogErrorColor"), m_crLogError);
	m_crLogWarning = ini.GetColRef(_T("LogWarningColor"), m_crLogWarning);
	m_crLogSuccess = ini.GetColRef(_T("LogSuccessColor"), m_crLogSuccess);

	if (statsAverageMinutes < 1)
		statsAverageMinutes = 5;

	// ZZ:UploadSpeedSense -->
    m_bDynUpEnabled = ini.GetBool(_T("USSEnabled"), false, _T("eMule"));
    m_bDynUpUseMillisecondPingTolerance = ini.GetBool(_T("USSUseMillisecondPingTolerance"), false);
    m_iDynUpPingTolerance = ini.GetInt(_T("USSPingTolerance"), 500, _T("eMule"));
	m_iDynUpPingToleranceMilliseconds = ini.GetInt(_T("USSPingToleranceMilliseconds"), 200);
	if( minupload < 1 )
	{
		minupload = 1;
	}
	m_iDynUpGoingUpDivider = ini.GetInt(_T("USSGoingUpDivider"), 1000, _T("eMule"));
    m_iDynUpGoingDownDivider = ini.GetInt(_T("USSGoingDownDivider"), 1000, _T("eMule"));
    m_iDynUpNumberOfPings = ini.GetInt(_T("USSNumberOfPings"), 1, _T("eMule"));
	// ZZ:UploadSpeedSense <--

    m_bA4AFSaveCpu = ini.GetBool(_T("A4AFSaveCpu"), false, _T("eMule")); // ZZ:DownloadManager

	m_bRunAsUser = ini.GetBool(_T("RunAsUnprivilegedUser"), false);
	m_bOpenPortsOnStartUp = ini.GetBool(_T("OpenPortsOnStartUp"), false);
	m_byLogLevel = ini.GetInt(_T("DebugLogLevel"), DLP_VERYLOW);
	m_bTrustEveryHash = ini.GetBool(_T("AICHTrustEveryHash"), false);


	///////////////////////////////////////////////////////////////////////////
	// Section: "Proxy"
	//
	proxy.EnablePassword = ini.GetBool(_T("ProxyEnablePassword"),false,_T("Proxy"));
	proxy.UseProxy = ini.GetBool(_T("ProxyEnableProxy"),false,_T("Proxy"));
	_sntprintf(proxy.name, ARRSIZE(proxy.name), _T("%s"), ini.GetString(_T("ProxyName"), _T(""), _T("Proxy")));
	_snprintf(proxy.password, ARRSIZE(proxy.password), "%s", T2CA(ini.GetString(_T("ProxyPassword"), _T(""), _T("Proxy"))));
	_snprintf(proxy.user, ARRSIZE(proxy.user), "%s", T2CA(ini.GetString(_T("ProxyUser"), _T(""), _T("Proxy"))));
	proxy.port = ini.GetInt(_T("ProxyPort"),1080,_T("Proxy"));
	proxy.type = ini.GetInt(_T("ProxyType"),PROXYTYPE_NOPROXY,_T("Proxy"));
	m_bIsASCWOP = ini.GetBool(_T("ConnectWithoutProxy"),false,_T("Proxy"));
	m_bShowProxyErrors = ini.GetBool(_T("ShowErrors"),false,_T("Proxy"));


	///////////////////////////////////////////////////////////////////////////
	// Section: "Statistics"
	//
	statsSaveInterval = ini.GetInt(_T("SaveInterval"), 60, _T("Statistics"));
	statsConnectionsGraphRatio = ini.GetInt(_T("statsConnectionsGraphRatio"), 3, _T("Statistics"));
	_stprintf(statsExpandedTreeItems,_T("%s"),ini.GetString(_T("statsExpandedTreeItems"),_T("111000000100000110000010000011110000010010"),_T("Statistics")));
	CString buffer2;
	for (int i=0;i<ARRSIZE(m_adwStatsColors);i++) {
		buffer2.Format(_T("StatColor%i"),i);
		_stprintf(buffer,_T("%s"),ini.GetString(buffer2,_T("0"),_T("Statistics")));
		m_adwStatsColors[i] = 0;
		if (_stscanf(buffer, _T("%i"), &m_adwStatsColors[i]) != 1 || m_adwStatsColors[i] == 0)
			ResetStatsColor(i);
	}
	m_bShowVerticalHourMarkers = ini.GetBool(_T("ShowVerticalHourMarkers"),true,_T("Statistics"));

	// -khaos--+++> Load Stats
	// I changed this to a seperate function because it is now also used
	// to load the stats backup and to load stats from preferences.ini.old.
	LoadStats(loadstatsFromOld);
	// <-----khaos-

	///////////////////////////////////////////////////////////////////////////
	// Section: "WebServer"
	//
	_stprintf(m_sWebPassword,_T("%s"),ini.GetString(_T("Password"), _T(""),_T("WebServer")));
	_stprintf(m_sWebLowPassword,_T("%s"),ini.GetString(_T("PasswordLow"), _T("")));
	m_nWebPort=ini.GetInt(_T("Port"), 4711);
	m_bWebEnabled=ini.GetBool(_T("Enabled"), false);
	m_bWebUseGzip=ini.GetBool(_T("UseGzip"), true);
	m_bWebLowEnabled=ini.GetBool(_T("UseLowRightsUser"), false);
	m_nWebPageRefresh=ini.GetInt(_T("PageRefreshTime"), 120);
	m_iWebTimeoutMins=ini.GetInt(_T("WebTimeoutMins"), 5 );

	///////////////////////////////////////////////////////////////////////////
	// Section: "MobileMule"
	//
	_stprintf(m_sMMPassword,_T("%s"),ini.GetString(_T("Password"), _T(""),_T("MobileMule")));
	m_bMMEnabled = ini.GetBool(_T("Enabled"), false);
	m_nMMPort = ini.GetInt(_T("Port"), 80);

	///////////////////////////////////////////////////////////////////////////
	// Section: "PeerCache"
	//
	m_uPeerCacheLastSearch = ini.GetInt(_T("LastSearch"), 0, _T("PeerCache"));
	m_bPeerCacheWasFound = ini.GetBool(_T("Found"), false);
	m_bPeerCacheEnabled = ini.GetBool(_T("Enabled"), true);
	m_nPeerCachePort = ini.GetInt(_T("PCPort"), 0);
	m_bPeerCacheShow = ini.GetBool(_T("Show"), false);

// RT, Default Changed
	if ( (m_bFirstStart == true) || (rt_IsInitial == true) )
	{
		if (m_bFirstStart == true)
		{
			port = 70;
			udpport = 23;
		}
		deadserverretries = MAX_SERVERFAILCOUNT;
		addserversfromserver = false;
		addserversfromclient = false;
		confirmExit = true;
		safeServerConnect = true;
		// 1 = "commit" on application shut down; 2 = "commit" on each file saveing
		m_iCommitFiles = 2;
		m_bDynUpUseMillisecondPingTolerance = true;
	    m_iDynUpPingTolerance = 1000;
		m_iDynUpPingToleranceMilliseconds = 500;
		m_bA4AFSaveCpu = true;
		m_bPeerCacheEnabled = false;
		// 0 = disable, 1 = mp3+avi, 2 = MediaDet
		m_iExtractMetaData = 0;
		// Remove Old File
		if (rt_IsInitial == true)
		{
			CString Buffer;
			Buffer.Format(_T("%sRT_Category.ini"), configdir);
			if (PathFileExists(Buffer) == TRUE)   _tremove(Buffer);
			Buffer.Format(_T("%sRT_Clients.dat"), configdir);
			if (PathFileExists(Buffer) == TRUE)   _tremove(Buffer);
			Buffer.Format(_T("%sRT_Flag.ini"), configdir);
			if (PathFileExists(Buffer) == TRUE)   _tremove(Buffer);
			Buffer.Format(_T("%sRT_KnownFile.ini"), configdir);
			if (PathFileExists(Buffer) == TRUE)   _tremove(Buffer);
			Buffer.Format(_T("%sRT_Preferences.ini"), configdir);
			if (PathFileExists(Buffer) == TRUE)   _tremove(Buffer);
			Buffer.Format(_T("%sRT_Statistics.ini"), configdir);
			if (PathFileExists(Buffer) == TRUE)   _tremove(Buffer);
		}
	}
	// Toolbar Bitmap Folder
	if (PathFileExists(m_sToolbarBitmapFolder) == FALSE)
		m_sToolbarBitmapFolder.Format( _T("%sskins"), appdir );
	// Skin Profile Dir
	if (PathFileExists(m_strSkinProfileDir) == FALSE)
		m_strSkinProfileDir.Format( _T("%sskins"), appdir );
// End
	LoadCats();
	SetLanguage();

	if (loadstatsFromOld == 2)
		SavePreferences();
}


WORD CPreferences::GetWindowsVersion(){
	static bool bWinVerAlreadyDetected = false;
	if(!bWinVerAlreadyDetected)
	{	
		bWinVerAlreadyDetected = true;
		m_wWinVer = DetectWinVersion();	
	}	
	return m_wWinVer;
}

uint16 CPreferences::GetDefaultMaxConperFive(){
	switch (GetWindowsVersion()){
		case _WINVER_98_:
			return 5;
		case _WINVER_95_:	
		case _WINVER_ME_:
			return MAXCON5WIN9X;
		case _WINVER_2K_:
		case _WINVER_XP_:
			return MAXCONPER5SEC;
		default:
			return MAXCONPER5SEC;
	}
}

// Barry - Provide a mechanism for all tables to store/retrieve sort order
int CPreferences::GetColumnSortItem(Table t)
{
	switch(t) 
	{
		case tableDownload:
			return tableSortItemDownload;
		case tableUpload:
			return tableSortItemUpload;
		case tableQueue:
			return tableSortItemQueue;
		case tableSearch:
			return tableSortItemSearch;
		case tableShared:
			return tableSortItemShared;
		case tableServer:
			return tableSortItemServer;
		case tableClientList:
			return tableSortItemClientList;
		case tableFilenames:
			return tableSortItemFilenames;
	}
	return 0;
}

// Barry - Provide a mechanism for all tables to store/retrieve sort order
bool CPreferences::GetColumnSortAscending(Table t)
{
	switch(t) 
	{
		case tableDownload:
			return tableSortAscendingDownload;
		case tableUpload:
			return tableSortAscendingUpload;
		case tableQueue:
			return tableSortAscendingQueue;
		case tableSearch:
			return tableSortAscendingSearch;
		case tableShared:
			return tableSortAscendingShared;
		case tableServer:
			return tableSortAscendingServer;
		case tableClientList:
			return tableSortAscendingClientList;
		case tableFilenames:
			return tableSortAscendingFilenames;
	}
	return true;
}

// Barry - Provide a mechanism for all tables to store/retrieve sort order
void CPreferences::SetColumnSortItem(Table t, int sortItem)
{
	switch(t) 
	{
		case tableDownload:
			tableSortItemDownload = sortItem;
			break;
		case tableUpload:
			tableSortItemUpload = sortItem;
			break;
		case tableQueue:
			tableSortItemQueue = sortItem;
			break;
		case tableSearch:
			tableSortItemSearch = sortItem;
			break;
		case tableShared:
			tableSortItemShared = sortItem;
			break;
		case tableServer:
			tableSortItemServer = sortItem;
			break;
		case tableClientList:
			tableSortItemClientList = sortItem;
			break;
		case tableFilenames:
			tableSortItemFilenames = sortItem;
			break;
	}
}

// Barry - Provide a mechanism for all tables to store/retrieve sort order
void CPreferences::SetColumnSortAscending(Table t, bool sortAscending)
{
	switch(t) 
	{
		case tableDownload:
			tableSortAscendingDownload = sortAscending;
			break;
		case tableUpload:
			tableSortAscendingUpload = sortAscending;
			break;
		case tableQueue:
			tableSortAscendingQueue = sortAscending;
			break;
		case tableSearch:
			tableSortAscendingSearch = sortAscending;
			break;
		case tableShared:
			tableSortAscendingShared = sortAscending;
			break;
		case tableServer:
			tableSortAscendingServer = sortAscending;
			break;
		case tableClientList:
			tableSortAscendingClientList = sortAscending;
			break;
		case tableFilenames:
			tableSortAscendingFilenames= sortAscending;
			break;
	}
}

//////////////////////////////////////////////////////////
// category implementations
//////////////////////////////////////////////////////////
// RT, New Code at Bottom
/*
void CPreferences::SaveCats(){

	// Cats
	CString catinif,ixStr,buffer;
	catinif.Format(_T("%sCategory.ini"),configdir);
	_tremove(catinif);

	CIni catini( catinif, _T("Category") );
	catini.WriteInt(_T("Count"),catMap.GetCount()-1,_T("General"));
	for (int ix=0;ix<catMap.GetCount();ix++){
		ixStr.Format(_T("Cat#%i"),ix);
		catini.WriteString(_T("Title"),catMap.GetAt(ix)->title,ixStr);
		catini.WriteString(_T("Incoming"),catMap.GetAt(ix)->incomingpath,ixStr);
		catini.WriteString(_T("Comment"),catMap.GetAt(ix)->comment,ixStr);
		catini.WriteString(_T("RegularExpression"),catMap.GetAt(ix)->regexp,ixStr);
		buffer.Format(_T("%lu"),catMap.GetAt(ix)->color);
		catini.WriteString(_T("Color"),buffer,ixStr);
		catini.WriteInt(_T("a4afPriority"),catMap.GetAt(ix)->prio,ixStr); // ZZ:DownloadManager
		catini.WriteString(_T("AutoCat"),catMap.GetAt(ix)->autocat,ixStr); 
		catini.WriteInt(_T("Filter"),catMap.GetAt(ix)->filter,ixStr); 
		catini.WriteBool(_T("FilterNegator"),catMap.GetAt(ix)->filterNeg,ixStr);
		catini.WriteBool(_T("AutoCatAsRegularExpression"),catMap.GetAt(ix)->ac_regexpeval,ixStr);
        catini.WriteBool(_T("downloadInAlphabeticalOrder"), catMap.GetAt(ix)->downloadInAlphabeticalOrder, ixStr); // ZZ:DownloadManager
		catini.WriteBool(_T("Care4All"),catMap.GetAt(ix)->care4all,ixStr);
	}
}
*/

void CPreferences::LoadCats() {
	CString ixStr,catinif,cat_a,cat_b,cat_c;
	TCHAR buffer[100];

	catinif.Format(_T("%sCategory.ini"),configdir);

	CIni catini( catinif, _T("Category") );
	int max=catini.GetInt(_T("Count"),0,_T("General"));

	for (int ix=0;ix<=max;ix++){
		ixStr.Format(_T("Cat#%i"),ix);

		Category_Struct* newcat=new Category_Struct;
		newcat->filter=0;
		_stprintf(newcat->title,_T("%s"),catini.GetString(_T("Title"),_T(""),ixStr));
		_stprintf(newcat->incomingpath,_T("%s"),catini.GetString(_T("Incoming"),_T(""),ixStr));
		MakeFoldername(newcat->incomingpath);
// RT, Is Path Exist
		if ( (PathFileExists(newcat->incomingpath) == FALSE) ||
			(IsShareableDirectory(newcat->incomingpath) == false) )
		{
			_sntprintf(newcat->incomingpath, ARRSIZE(newcat->incomingpath), _T("%s"), GetIncomingDir());
			MakeFoldername(newcat->incomingpath);
		}
/* Original
		if (!IsShareableDirectory(newcat->incomingpath)){
			_sntprintf(newcat->incomingpath, ARRSIZE(newcat->incomingpath), _T("%s"), GetIncomingDir());
			MakeFoldername(newcat->incomingpath);
		}
*/
		_stprintf(newcat->comment,_T("%s"),catini.GetString(_T("Comment"),_T(""),ixStr));
		newcat->prio =catini.GetInt(_T("a4afPriority"),PR_NORMAL,ixStr); // ZZ:DownloadManager
		newcat->filter=catini.GetInt(_T("Filter"),0,ixStr);
		newcat->filterNeg =catini.GetBool(_T("FilterNegator"),FALSE,ixStr);
		newcat->ac_regexpeval  =catini.GetBool(_T("AutoCatAsRegularExpression"),FALSE,ixStr);
		newcat->care4all=catini.GetBool(_T("Care4All"),FALSE,ixStr);

		newcat->regexp=catini.GetString(_T("RegularExpression"),_T(""),ixStr);
		newcat->autocat=catini.GetString(_T("Autocat"),_T(""),ixStr);
        newcat->downloadInAlphabeticalOrder = catini.GetBool(_T("downloadInAlphabeticalOrder"), FALSE, ixStr); // ZZ:DownloadManager

		_stprintf(buffer,_T("%s"),catini.GetString(_T("Color"),_T("0"),ixStr));
		newcat->color=_tstoi64(buffer);

		AddCat(newcat);
		if (!PathFileExists(newcat->incomingpath)) 
			::CreateDirectory(newcat->incomingpath,0);
	}
}
void CPreferences::RemoveCat(int index)	{
// RT, Category Temporary Directory
	if ( (index >= 0) && (index < rt_CategoryTempDir.GetCount()) )
	{
		rt_CategoryTempDir.RemoveAt(index);
		rt_CategoryViewFilter.RemoveAt(index);
	}
// End
	if (index>=0 && index<catMap.GetCount()) { 
		Category_Struct* delcat;
		delcat=catMap.GetAt(index); 
		catMap.RemoveAt(index); 
		delete delcat;
	}
}

bool CPreferences::SetCatFilter(int index, int filter){
	if (index>=0 && index<catMap.GetCount()) { 
		Category_Struct* cat;
		cat=catMap.GetAt(index); 
		cat->filter=filter;
		return true;
	} 
	
	return false;
}

int CPreferences::GetCatFilter(int index){
	if (index>=0 && index<catMap.GetCount()) {
		return catMap.GetAt(index)->filter;
	}
	
    return 0;
}

bool CPreferences::GetCatFilterNeg(int index){
	if (index>=0 && index<catMap.GetCount()) {
		return catMap.GetAt(index)->filterNeg;
	}
	
    return false;
}

void CPreferences::SetCatFilterNeg(int index, bool val) {
	if (index>=0 && index<catMap.GetCount()) {
		catMap.GetAt(index)->filterNeg=val;
	}
}


bool CPreferences::MoveCat(UINT from, UINT to){
	if (from>=(UINT)catMap.GetCount() || to >=(UINT)catMap.GetCount()+1 || from==to) return false;

// RT, Category Temporary Directory
	CString Buffer;
	Buffer.Format( _T("%s"), rt_CategoryTempDir.GetAt(from) );
	if (from < to)
	{
		rt_CategoryTempDir.RemoveAt(from);
		rt_CategoryTempDir.InsertAt( (to - 1) , Buffer);
	}
	else
	{
		rt_CategoryTempDir.InsertAt(to, Buffer);
		rt_CategoryTempDir.RemoveAt(from + 1);
	}
// End
	Category_Struct* tomove;

	tomove=catMap.GetAt(from);

	if (from < to) {
		catMap.RemoveAt(from);
		catMap.InsertAt(to-1,tomove);
	} else {
		catMap.InsertAt(to,tomove);
		catMap.RemoveAt(from+1);
	}
	
	SaveCats();

	return true;
}


bool CPreferences::IsInstallationDirectory(const CString& rstrDir)
{
	CString strFullPath;
	if (PathCanonicalize(strFullPath.GetBuffer(MAX_PATH), rstrDir))
		strFullPath.ReleaseBuffer();
	else
		strFullPath = rstrDir;
	
	// skip sharing of several special eMule folders
	if (!CompareDirectories(strFullPath, GetAppDir()))			// ".\eMule"
		return true;
	if (!CompareDirectories(strFullPath, GetConfigDir()))		// ".\eMule\config"
		return true;
	if (!CompareDirectories(strFullPath, GetWebServerDir()))	// ".\eMule\webserver"
		return true;
	if (!CompareDirectories(strFullPath, GetLangDir()))			// ".\eMule\lang"
		return true;
// RT, Wap Server by MoNKi
	if (CompareDirectories(strFullPath, GetWapServerDir()) == 0)	// ".\eMule\wapserver"
		return true;
// End

	return false;
}

bool CPreferences::IsShareableDirectory(const CString& rstrDir)
{
	if (IsInstallationDirectory(rstrDir))
		return false;

	CString strFullPath;
	if (PathCanonicalize(strFullPath.GetBuffer(MAX_PATH), rstrDir))
		strFullPath.ReleaseBuffer();
	else
		strFullPath = rstrDir;
	
	// skip sharing of several special eMule folders
	if (!CompareDirectories(strFullPath, GetTempDir()))			// ".\eMule\temp"
		return false;

	return true;
}

void CPreferences::UpdateLastVC()
{
	versioncheckLastAutomatic = safe_mktime(CTime::GetCurrentTime().GetLocalTm());
}

void CPreferences::SetWSPass(CString strNewPass)
{
	_stprintf(m_sWebPassword,_T("%s"),MD5Sum(strNewPass).GetHash().GetBuffer(0));
}

void CPreferences::SetWSLowPass(CString strNewPass)
{
	_stprintf(m_sWebLowPassword,_T("%s"),MD5Sum(strNewPass).GetHash().GetBuffer(0));
}

void CPreferences::SetMMPass(CString strNewPass)
{
	_stprintf(m_sMMPassword,_T("%s"),MD5Sum(strNewPass).GetHash().GetBuffer(0));
}

void CPreferences::SetMaxUpload(uint16 in)
{
	maxupload = (in) ? in : UNLIMITED;
}

void CPreferences::SetMaxDownload(uint16 in)
{
	maxdownload = (in) ? in : UNLIMITED;
}

uint16 CPreferences::GetMaxSourcePerFileSoft()
{
	UINT temp = ((UINT)maxsourceperfile * 9L) / 10;
	if (temp > MAX_SOURCES_FILE_SOFT)
		return MAX_SOURCES_FILE_SOFT;
	return temp;
}

uint16 CPreferences::GetMaxSourcePerFileUDP()
{	
	UINT temp = ((UINT)maxsourceperfile * 3L) / 4;
	if (temp > MAX_SOURCES_FILE_UDP)
		return MAX_SOURCES_FILE_UDP;
	return temp;
}

void CPreferences::SetNetworkKademlia(bool val)
{
	networkkademlia = val; 
}

CString CPreferences::GetHomepageBaseURLForLevel(uint8 nLevel){
	CString tmp;
	if (nLevel == 0)
		tmp = _T("http://emule-project.net");
	else if (nLevel == 1)
		tmp = _T("http://www.emule-project.org");
	else if (nLevel == 2)
		tmp = _T("http://www.emule-project.com");
	else if (nLevel < 100)
		tmp.Format(_T("http://www%i.emule-project.net"),nLevel-2);
	else if (nLevel < 150)
		tmp.Format(_T("http://www%i.emule-project.org"),nLevel);
	else if (nLevel < 200)
		tmp.Format(_T("http://www%i.emule-project.com"),nLevel);
	else if (nLevel == 200)
		tmp = _T("http://emule.sf.net");
	else if (nLevel == 201)
		tmp = _T("http://www.emuleproject.net");
	else if (nLevel == 202)
		tmp = _T("http://sourceforge.net/projects/emule/");
	else
		tmp = _T("http://www.emule-project.net");
	return tmp;
}

CString CPreferences::GetVersionCheckBaseURL(){
	CString tmp;
	uint8 nWebMirrorAlertLevel = GetWebMirrorAlertLevel();
	if (nWebMirrorAlertLevel < 100)
		tmp = _T("http://vcheck.emule-project.net");
	else if (nWebMirrorAlertLevel < 150)
		tmp.Format(_T("http://vcheck%i.emule-project.org"),nWebMirrorAlertLevel);
	else if (nWebMirrorAlertLevel < 200)
		tmp.Format(_T("http://vcheck%i.emule-project.com"),nWebMirrorAlertLevel);
	else if (nWebMirrorAlertLevel == 200)
		tmp = _T("http://emule.sf.net");
	else if (nWebMirrorAlertLevel == 201)
		tmp = _T("http://www.emuleproject.net");
	else
		tmp = _T("http://vcheck.emule-project.net");
	return tmp;
}

bool CPreferences::IsDefaultNick(const CString strCheck){
	// not fast, but this function is called often
	for (int i = 0; i != 255; i++){
		if (GetHomepageBaseURLForLevel(i) == strCheck)
			return true;
	}
	return ( strCheck == _T("http://emule-project.net") );
}

void CPreferences::SetUserNick(LPCTSTR pszNick)
{
	strNick = pszNick;
}

uint8 CPreferences::GetWebMirrorAlertLevel(){
	// Known upcoming DDoS Attacks
	if (m_nWebMirrorAlertLevel == 0){
		// no threats known at this time
	}
	// end
	if (UpdateNotify())
		return m_nWebMirrorAlertLevel;
	else
		return 0;
}

bool CPreferences::IsRunAsUserEnabled(){
	return (GetWindowsVersion() == _WINVER_XP_ || GetWindowsVersion() == _WINVER_2K_) && m_bRunAsUser;
}

bool CPreferences::GetUseReBarToolbar()
{
	return GetReBarToolbar() && theApp.m_ullComCtrlVer >= MAKEDLLVERULL(5,8,0,0);
}

//*************
// RT, New Code
//-------------
//
// Default Mod List
const CString ModList[] =
{
	_T("Official"), _T("Other Client"), _T("Unknown"), _T("ACAT"), _T("aMule"),
	_T("EastShare"), _T("eChanblard"), _T("eF-Mod"), _T("eWombat"), _T("hebMule"),
	_T("LSD"), _T("MFCK"), _T("Morph"), _T("Pawcio"), _T("Peace"),
	_T("pHoeniX"), _T("Plus"), _T("RT"), _T("SF-IOM"), _T("Sivka"),
	_T("Stormit"), _T("S.W.A.T."), _T("The Black Hand"), _T("WebCache"), _T("ZZUL")
};
// Country Code
const CString CountryCodeString = _T("??AFALDZADAOAGARAMAUATAZBSBHBDBBBYBEBZBJBTBOBABWBRBNBGBFBIKHCMCACVCFTDCLCNCOKMCGCDCRCIHRCUCYCZDKDJDMDOTPECEGSVGQEREEETFJFIFRGAGMGEDEGHGRGDGTGNGWGYHTVAHNHUISINIDIRIQIEILITJMJPJOKZKEKIKR**KWKGLALVLBLSLRLYLILTLUMKMGMWMYMVMLMTMHMRMUMXFMMDMCMNMAMZMMNANRNPNLNZNINENGNOOMPK**PWPAPGPYPEPHPLPTQARORURWKNLCVCWSSMSTSASNSCSLSGSKSISBSOZA**ESLKSDSRSZSECHSYTWTJTZTHTGTOTTTNTRTMTVUGUAAEUKUSUYUZVUVEVNYEYUZMZWGBHKMOPS");
// Ignore File for Backup
const CString IgnoreFileList = _T("clients.met");
// Copy Only File for Backup2
const CString CopyOnlyFileList = _T("adresses.dat, webservices.dat, cryptkey.dat, fileinfo.ini, staticservers.dat, \
									index.dat, AC_IPFilterUpdateURLs.dat, AC_ServerMetURLs.dat, AC_SearchStrings.dat \
									AC_BootstrapIPs.dat, Ipfilter.dat, statbkup.ini, RT_IP2Country.dat, s_index.dat, \
									preferencesK.dat, k_index.dat, RT_FakeFiles.ini, Category.ini, RT_Category.ini, \
									known2.met");
//
// Friend Slot Auto
bool		CPreferences::rt_FriendSlotAuto;
// PreCheck Diskspace
bool		CPreferences::rt_PreCheckDiskspace;
// Auto Swap A4AF
bool		CPreferences::rt_AutoSwapA4AF;
// Use Ratio Color
bool		CPreferences::rt_RatioColor;
// New User Hash
bool		CPreferences::rt_NewUserHash;
// Release Rarest Only
bool		CPreferences::rt_ReleaseRarestOnly;
// Auto Release, if > Max and < Min
bool		CPreferences::rt_AutoRelease;
// Use Hash Nick
bool		CPreferences::rt_HashNick;
// More than Rarest Part
uint8		CPreferences::rt_MoreRarestPart;
// Leecher, if Count >
uint8		CPreferences::rt_LeecherCount;
// Maximum, Minimum of Upload Slot
uint8		CPreferences::rt_MinUploadSlot;
uint8		CPreferences::rt_MaxUploadSlot;
// Max QR of Download
uint16		CPreferences::rt_MaxQR;
// Auto Release Minimum, Maximum
uint16		CPreferences::rt_AutoReleaseMin;
uint16		CPreferences::rt_AutoReleaseMax;
// Display Country Name
bool		CPreferences::rt_DisplayCountry;
bool		CPreferences::rt_DisplayFlag;
// Keep Friend Slot Setting
bool		CPreferences::rt_KeepFriendSlot;
uchar		CPreferences::rt_UserHashFS[16];
// Maximum of Release Slot
uint8		CPreferences::rt_MaxReleaseSlot;
// Maximum of Credit1 Slot
uint8		CPreferences::rt_MaxCredit1Slot;
// Slot Focus
bool		CPreferences::rt_SlotFocus;
// UserNick for Server
CString		CPreferences::rt_UserNickforServer;
// Run in the High Priority
bool		CPreferences::rt_RunHighPriority;
// Font for All Windows
bool		CPreferences::rt_FontForAllWindows;
// Backup Config
uint8		CPreferences::rt_AutoBackupConfig;
// Download Priority Limit
uint16		CPreferences::rt_DLPrioLimit[RT_PRIORITY_COUNT];
// Shared Priority Limit
uint16		CPreferences::rt_ULPrioLimit[RT_PRIORITY_COUNT];
// Include Stopped File
bool		CPreferences::rt_IncludeStoppedFile;
// Log Ratio Verbose
bool		CPreferences::rt_LogRatioVerbose;
// Log Normal Verbose
bool		CPreferences::rt_LogNormalVerbose;
// Table Sort Plus
uint16		CPreferences::rt_TableSortPlus;
// Cumulative source breakdown stats for transfer bytes...
uint64		CPreferences::rt_CumulativeUploadMod[RT_MOD_COUNT];
uint64		CPreferences::rt_CumulativeUploadCountry[RT_COUNTRY_COUNT];
uint64		CPreferences::rt_CumulativeDownloadMod[RT_MOD_COUNT];
uint64		CPreferences::rt_CumulativeDownloadCountry[RT_COUNTRY_COUNT];
// Session source breakdown stats for transfer bytes...
uint64		CPreferences::rt_SessionUploadMod[RT_MOD_COUNT];
uint64		CPreferences::rt_SessionUploadCountry[RT_COUNTRY_COUNT];
uint64		CPreferences::rt_SessionDownloadMod[RT_MOD_COUNT];
uint64		CPreferences::rt_SessionDownloadCountry[RT_COUNTRY_COUNT];
// Status Expand
uint8		CPreferences::rt_StatusExpand;
// Ping Custom IP
bool		CPreferences::rt_PingCustomIP;
uint32		CPreferences::rt_CustomIP;
// Start Next File By
uint8		CPreferences::rt_StartNextFileBy;
// RT Style
bool		CPreferences::rt_RatioStyleServer;
bool		CPreferences::rt_RatioStyleTransfer;
// Upload Queue Waited Time
bool		CPreferences::rt_RecordUploadQueueWaitedTime;
// Download Sort Separate Stop
bool		CPreferences::rt_DownloadSortSeparateStop;
// Flush Buffer Time Limit
uint32		CPreferences::rt_FlushBufferTimeLimit;
// Normal Exit
bool		CPreferences::rt_NormalExitLastTime;
// Reset DontDownload
bool		CPreferences::rt_ResetDontDownload;
// Display Icon of Filetype
bool		CPreferences::rt_DisplayIconOfFiletype;
// Category
int			CPreferences::rt_AllCategoryType;
// Random Port
uint16		CPreferences::rt_RealTCPPort;
uint16		CPreferences::rt_RealUDPPort;
bool		CPreferences::rt_RandomTCPPort;
bool		CPreferences::rt_SessionRandomTCPPort;
bool		CPreferences::rt_RandomUDPPort;
bool		CPreferences::rt_SessionRandomUDPPort;
CString		CPreferences::rt_RandomTCPPortList;
CString		CPreferences::rt_RandomUDPPortList;
// WebCache
uint64		CPreferences::rt_WebCacheUpDataSession;
uint64		CPreferences::rt_WebCacheUpDataCumulative;
//
// *** Tweak Fuction ***
//
// Save Overhead
bool		CPreferences::rt_SaveOverhead;
// Save CPU Load
bool		CPreferences::rt_SaveCpuLoad;
// Connect Time Out
uint32		CPreferences::rt_ConnectTimeOut;
// Wap Server by MoNKi
TCHAR		CPreferences::m_sWapTemplateFile[MAX_PATH];
bool		CPreferences::m_bWapEnabled;
uint16		CPreferences::m_nWapPort;
uint8		CPreferences::m_iWapGraphWidth;
uint8		CPreferences::m_iWapGraphHeight;
bool		CPreferences::m_bWapFilledGraphs;
int			CPreferences::m_iWapMaxItemsInPages;
bool		CPreferences::m_bWapSendImages;
bool		CPreferences::m_bWapSendGraphs;
bool		CPreferences::m_bWapSendProgressBars;
bool		CPreferences::m_bWapAllwaysSendBWImages;
UINT		CPreferences::m_iWapLogsSize;
CString		CPreferences::m_strWapServerDir;
CString		CPreferences::m_sWapPassword;
CString		CPreferences::m_sWapLowPassword;
bool		CPreferences::m_bWapLowEnabled;
// RT, WebCache (Code by JP/yonatan/Superlexx)
uint64		CPreferences::cumDownData_WEBCACHE; //jp webcache statistics
uint64		CPreferences::sesDownData_WEBCACHE; //jp webcache statistics
uint32		CPreferences::ses_WEBCACHEREQUESTS; //jp webcache statistics needs to be uint32 or the statistics won't work
uint32		CPreferences::ses_successfull_WCDOWNLOADS; //jp webcache statistics needs to be uint32 or the statistics won't work
bool		CPreferences::m_bLogWebCacheEvents;//JP log webcache events
CString		CPreferences::webcacheName;
uint16		CPreferences::webcachePort;
bool		CPreferences::webcacheReleaseAllowed; //jp webcache release
uint16		CPreferences::webcacheBlockLimit;
bool		CPreferences::PersistentConnectionsForProxyDownloads; //jp persistent proxy connections
bool		CPreferences::webcacheExtraTimeout;
bool		CPreferences::webcacheCachesLocalTraffic;
bool		CPreferences::webcacheEnabled;
bool		CPreferences::detectWebcacheOnStartup; //jp detect webcache on startup
uint32		CPreferences::webcacheLastSearch;
CString		CPreferences::webcacheLastResolvedName;
uint32		CPreferences::webcacheLastGlobalIP;
bool		CPreferences::UsesCachedTCPPort()  //jp
{
	if ((thePrefs.port==80) || (thePrefs.port==21) || (thePrefs.port==443) || (thePrefs.port==563) || (thePrefs.port==70) || (thePrefs.port==210) || ((thePrefs.port>=1025) && (thePrefs.port<=65535))) return true;
	else return false;
}
//JP proxy configuration test start
bool		CPreferences::WebCacheDisabledThisSession;//jp temp disabled
uint32		CPreferences::WebCachePingSendTime;//jp check proxy config
bool		CPreferences::expectingWebCachePing;//jp check proxy config
bool		CPreferences::IsWebCacheTestPossible()//jp check proxy config
{
	return ( theApp.GetPublicIP() != 0 //we have a public IP
		&& theApp.serverconnect->IsConnected() //connected to a server
		&& !theApp.serverconnect->IsLowID() );//don't have LowID
}
//Jp proxy configuration test end
//JP webcache release START
bool	CPreferences::UpdateWebcacheReleaseAllowed()
{
	webcacheReleaseAllowed = true;
	if (theApp.downloadqueue->ContainsUnstoppedFiles())
		webcacheReleaseAllowed = false;
	return webcacheReleaseAllowed;
}
// End--WebCache
// Ratio Colors
COLORREF	CPreferences::rt_RatioColors[RT_COLOR_COUNT];
// Category Temporary Directory
CArray		<CString, CString&> CPreferences::rt_CategoryTempDir;
// Category View Filter
CArray		<int, int> CPreferences::rt_CategoryViewFilter;
// Column Settings
uint16		CPreferences::downloadColumnWidths[14];   // Original = 13
BOOL		CPreferences::downloadColumnHidden[14];
INT			CPreferences::downloadColumnOrder[14];
uint16		CPreferences::uploadColumnWidths[11];   // Original = 8
BOOL		CPreferences::uploadColumnHidden[11];
INT			CPreferences::uploadColumnOrder[11];
uint16		CPreferences::queueColumnWidths[13];   // Original = 10
BOOL		CPreferences::queueColumnHidden[13];
INT			CPreferences::queueColumnOrder[13];
uint16		CPreferences::searchColumnWidths[14];   // No Change
BOOL		CPreferences::searchColumnHidden[14];
INT			CPreferences::searchColumnOrder[14];
uint16		CPreferences::sharedColumnWidths[13];   // Original = 12
BOOL		CPreferences::sharedColumnHidden[13];
INT			CPreferences::sharedColumnOrder[13];
uint16		CPreferences::serverColumnWidths[14];   // No Change
BOOL		CPreferences::serverColumnHidden[14];
INT			CPreferences::serverColumnOrder[14];
uint16		CPreferences::clientListColumnWidths[9];   // Original = 8
BOOL		CPreferences::clientListColumnHidden[9];
INT			CPreferences::clientListColumnOrder[9];
//
// Load Ratio Setting
void CPreferences::RT_LoadSettings()
{
	CString Filename, Buffer;
	Filename.Format( _T("%sRT_Preferences.ini"), configdir);
	CIni RatioIni( Filename, _T("General") );
	//
	int MinUploadSlot = int(sqrt(double(maxGraphUploadRate + 1)) - 1);
	if (MinUploadSlot < 2)   MinUploadSlot = 2;
	int MaxUploadSlot = int(maxGraphUploadRate) / 3;
	if (MaxUploadSlot < 2)   MaxUploadSlot = 2;
	CString VersionRT = RatioIni.GetString( _T("Version"), _T(""), _T("General") );
	// Load Settings
	// General
	rt_RunHighPriority = RatioIni.GetBool( _T("RunHighPriority"), false, _T("General") );
	rt_AutoBackupConfig = RatioIni.GetInt( _T("BackupConfig"), RT_ABC_BACKUP1, _T("General") );
	rt_LeecherCount = RatioIni.GetInt( _T("LeecherCount"), 3, _T("General") );
	rt_UserNickforServer = RatioIni.GetString( _T("UserNickforServer"), _T(""), _T("General") );
	rt_TableSortPlus = RatioIni.GetInt( _T("TableSortPlus"), 0, _T("General") );
	rt_StatusExpand = RatioIni.GetInt( _T("StatusExpand"), 0xFF, _T("General") );
	rt_RecordUploadQueueWaitedTime = RatioIni.GetBool( _T("RecordUploadQueueWaitedTime"), true, _T("General") );
	rt_FlushBufferTimeLimit = RatioIni.GetUInt64( _T("FlushBufferTimeLimit"), MIN2MS(1), _T("General") );
	rt_ResetDontDownload = ( RatioIni.GetInt( _T("DontDownload"), 0, _T("General") ) != RT_DONT_DOWNLOAD_VERSION );
	rt_SaveCpuLoad = RatioIni.GetInt( _T("SaveCpuLoad"), true, _T("General") );
	rt_AllCategoryType = RatioIni.GetInt( _T("AllCategoryType"), 0, _T("General") );
	// Display
	rt_HashNick = RatioIni.GetBool( _T("IsHashNick"), true, _T("Display") );
	rt_DisplayCountry = RatioIni.GetBool( _T("IsDisplayCountry"), true, _T("Display") );
	rt_DisplayFlag = RatioIni.GetBool( _T("IsDisplayFlag"), true, _T("Display") );
	rt_FontForAllWindows = RatioIni.GetBool( _T("FontForAllWindows"), false, _T("Display") );
	rt_RatioColor = RatioIni.GetBool( _T("IsRatioColor"), true, _T("Display") );
	rt_RatioStyleServer = RatioIni.GetBool( _T("IsRatioStyleServer"), true, _T("Display") );
	rt_RatioStyleTransfer = RatioIni.GetBool( _T("IsRatioStyleTransfer"), true, _T("Display") );
	rt_DownloadSortSeparateStop = RatioIni.GetBool( _T("IsDownloadSortSeparateStop"), true, _T("Display") );
	rt_DisplayIconOfFiletype = RatioIni.GetBool( _T("DisplayIconOfFiletype"), false, _T("Display") );
	// Display--Color
	RatioIni.SerGet(true, rt_RatioColors, ARRSIZE(rt_RatioColors), _T("RatioColors"), _T("Display") );
	// Connection
	rt_PingCustomIP = RatioIni.GetBool( _T("IsPingCustomIP"), false, _T("Connection") );
	rt_CustomIP = RatioIni.GetUInt64( _T("CustomIP"), 0, _T("Connection") );
	rt_SaveOverhead = RatioIni.GetBool( _T("SaveOverhead"), true, _T("Connection") );
	rt_ConnectTimeOut = RatioIni.GetInt( _T("ConnectTimeOut"), 5000, _T("Connection") );
	rt_RandomTCPPort = RatioIni.GetBool( _T("RandomTCPPort"), false, _T("Connection") );
	rt_SessionRandomTCPPort = rt_RandomTCPPort;
	rt_RandomUDPPort = RatioIni.GetBool( _T("RandomUDPPort"), false, _T("Connection") );
	rt_SessionRandomUDPPort = rt_RandomUDPPort;
	rt_RandomTCPPortList = RatioIni.GetString( _T("RandomTCPPortList"), _T("21, 70, 80, 210, 443, 563, 1025 ~ 65535"), _T("Connection") );
	rt_RandomUDPPortList = RatioIni.GetString( _T("RandomUDPPortList"), _T("23, 1025 ~ 65535"), _T("Connection") );
	// Directory
	// Release
	rt_ReleaseRarestOnly = RatioIni.GetBool( _T("IsReleaseRarestOnly"), true, _T("Release") );
	rt_MoreRarestPart = RatioIni.GetInt( _T("MoreRarestPart"), 0, _T("Release") );
	rt_AutoRelease = RatioIni.GetBool( _T("IsAutoRelease"), true, _T("Release") );
	rt_AutoReleaseMin = RatioIni.GetInt( _T("AutoReleaseMin"), 1, _T("Release") );
	rt_AutoReleaseMax = RatioIni.GetInt( _T("AutoReleaseMax"), 20, _T("Release") );
	// Upload
	rt_FriendSlotAuto = RatioIni.GetBool( _T("FriendSlotAuto"), false, _T("Upload") );
	rt_MinUploadSlot = RatioIni.GetInt( _T("MinUploadSlot"), MinUploadSlot, _T("Upload") );
	rt_MaxUploadSlot = RatioIni.GetInt( _T("MaxUploadSlot"), MaxUploadSlot, _T("Upload") );
	rt_KeepFriendSlot = RatioIni.GetBool( _T("IsKeepFriendSlot"), false, _T("Upload") );
	rt_SlotFocus = RatioIni.GetBool( _T("IsSlotFocus"), false, _T("Upload") );
	rt_MaxReleaseSlot = RatioIni.GetInt( _T("MaxReleaseSlot"), 1, _T("Upload") );
	rt_MaxCredit1Slot = RatioIni.GetInt( _T("MaxCredit1Slot"), 0, _T("Upload") );
	SetUserHashFS( RatioIni.GetString( _T("UserHashFS"), _T(""), _T("Upload") ) );
	// Upload--Priority Limit
	RatioIni.SerGet(true, rt_ULPrioLimit, ARRSIZE(rt_ULPrioLimit), _T("ULPriorityLimit"), _T("Upload") );
	// Download
	rt_PreCheckDiskspace = RatioIni.GetBool( _T("PreCheckDiskspace"), true, _T("Download") );
	rt_AutoSwapA4AF = RatioIni.GetBool( _T("AutoSwapA4AF"), true, _T("Download") );
	rt_MaxQR = RatioIni.GetInt( _T("MaxQR"), 2000, _T("Download") );
	rt_IncludeStoppedFile = RatioIni.GetBool( _T("IncludeStoppedFile"), true, _T("Download") );
	rt_StartNextFileBy = RatioIni.GetInt( _T("StartNextFileBy"), RT_BY_PRIORITY, _T("Download") );
	// Download--Priority Limit
	RatioIni.SerGet(true, rt_DLPrioLimit, ARRSIZE(rt_DLPrioLimit), _T("DLPriorityLimit"), _T("Download") );
	// Log
	rt_LogRatioVerbose = RatioIni.GetBool( _T("LogRatioVerbose"), true, _T("Log") );
	rt_LogNormalVerbose = RatioIni.GetBool( _T("LogNormalVerbose"), true, _T("Log") );
	// Log--WebCache (Code By JP)
	m_bLogWebCacheEvents = RatioIni.GetBool( _T("LogWebCacheEvents"), false, _T("Log") );   // JP log webcache events
	// Wap Server by MoNKi
	m_bWapEnabled = RatioIni.GetBool( _T("WapEnabled"), false, _T("WapServer") );
	_stprintf( m_sWapTemplateFile, _T("%s"), RatioIni.GetString(_T("WapTemplateFile"), _T("eMule_Wap.tmpl"), _T("WapServer")) );
	m_nWapPort = RatioIni.GetInt( _T("WapPort"), 80, _T("WapServer") );
	m_iWapGraphWidth = RatioIni.GetInt( _T("WapGraphWidth"), 60, _T("WapServer") );
	m_iWapGraphHeight = RatioIni.GetInt( _T("WapGraphHeight"), 45, _T("WapServer") );
	m_bWapFilledGraphs = RatioIni.GetBool( _T("WapFilledGraphs"), false, _T("WapServer") );
	m_iWapMaxItemsInPages = RatioIni.GetInt( _T("WapMaxItemsInPage"), 5, _T("WapServer") );
	m_bWapSendImages = RatioIni.GetBool( _T("WapSendImages"), true, _T("WapServer") );
	m_bWapSendGraphs = RatioIni.GetBool( _T("WapSendGraphs"), true, _T("WapServer") );
	m_bWapSendProgressBars = RatioIni.GetBool( _T("WapSendProgressBars"), true, _T("WapServer") );
	m_bWapAllwaysSendBWImages = RatioIni.GetBool( _T("WapSendBWImages"), true, _T("WapServer") );
	m_iWapLogsSize = RatioIni.GetInt( _T("WapLogsSize"), 1024, _T("WapServer") );
	m_sWapPassword = RatioIni.GetString( _T("WapPassword"), _T("WapServer"), _T("WapServer") );
	m_sWapLowPassword = RatioIni.GetString( _T("WapPasswordLow"), _T(""), _T("WapServer") );
	m_bWapLowEnabled = RatioIni.GetBool( _T("WapLowEnable"), false, _T("WapServer") );
// RT, WebCache (Code by JP/yonatan/Superlexx)
	// Superlexx - webcache
	/*char tmpWebcacheName[100];
	sprintf(tmpWebcacheName,"%s",ini.GetString(_T("webcacheName"),_T("")));
	webcacheName = tmpWebcacheName; // TODO: something more elegant*/
	webcacheName = RatioIni.GetString( _T("webcacheName"), _T(""), _T("WebCache") );
	webcachePort = RatioIni.GetInt( _T("webcachePort"),0, _T("WebCache") );
	webcacheBlockLimit = RatioIni.GetInt( _T("webcacheBlockLimit"), 0, _T("WebCache") );
	webcacheExtraTimeout = RatioIni.GetBool( _T("webcacheExtraTimeout"), false, _T("WebCache") );
	PersistentConnectionsForProxyDownloads = RatioIni.GetBool( _T("PersistentConnectionsForProxyDownloads"), false, _T("WebCache") );
	webcacheCachesLocalTraffic = RatioIni.GetBool( _T("webcacheCachesLocalTraffic"), true, _T("WebCache") );
	webcacheEnabled = RatioIni.GetBool( _T("webcacheEnabled"), false, _T("WebCache") ); //webcache disabled on first start so webcache detection on start gets called.
	detectWebcacheOnStartup = RatioIni.GetBool( _T("detectWebcacheOnStartup"), true, _T("WebCache") ); // jp detect webcache on startup
	webcacheLastSearch = uint32(RatioIni.GetUInt64( _T("webcacheLastSearch"), 0, _T("WebCache") ));
	webcacheLastGlobalIP = uint32(RatioIni.GetUInt64( _T("webcacheLastGlobalIP"), 0, _T("WebCache") ));
	webcacheLastResolvedName = RatioIni.GetString( _T("webcacheLastResolvedName"), 0, _T("WebCache") );
	WebCacheDisabledThisSession = (webcacheEnabled == false);
// End
	// Column Settings
	RatioIni.SerGet(true, downloadColumnWidths, ARRSIZE(downloadColumnWidths), _T("DownloadColumnWidths"), _T("Column") );
	RatioIni.SerGet(true, downloadColumnHidden, ARRSIZE(downloadColumnHidden), _T("DownloadColumnHidden"), _T("Column") );
	RatioIni.SerGet(true, downloadColumnOrder, ARRSIZE(downloadColumnOrder), _T("DownloadColumnOrder"), _T("Column") );
	RatioIni.SerGet(true, uploadColumnWidths, ARRSIZE(uploadColumnWidths), _T("UploadColumnWidths"), _T("Column") );
	RatioIni.SerGet(true, uploadColumnHidden, ARRSIZE(uploadColumnHidden), _T("UploadColumnHidden"), _T("Column") );
	RatioIni.SerGet(true, uploadColumnOrder, ARRSIZE(uploadColumnOrder), _T("UploadColumnOrder"), _T("Column") );
	RatioIni.SerGet(true, sharedColumnWidths, ARRSIZE(sharedColumnWidths), _T("SharedColumnWidths"), _T("Column") );
	RatioIni.SerGet(true, sharedColumnHidden, ARRSIZE(sharedColumnHidden), _T("SharedColumnHidden"), _T("Column") );
	RatioIni.SerGet(true, sharedColumnOrder, ARRSIZE(sharedColumnOrder), _T("SharedColumnOrder"), _T("Column") );
	RatioIni.SerGet(true, queueColumnWidths, ARRSIZE(queueColumnWidths), _T("QueueColumnWidths"), _T("Column") );
	RatioIni.SerGet(true, queueColumnHidden, ARRSIZE(queueColumnHidden), _T("QueueColumnHidden"), _T("Column") );
	RatioIni.SerGet(true, queueColumnOrder, ARRSIZE(queueColumnOrder), _T("QueueColumnOrder"), _T("Column") );
	RatioIni.SerGet(true, clientListColumnWidths, ARRSIZE(clientListColumnWidths), _T("ClientListColumnWidths"), _T("Column") );
	RatioIni.SerGet(true, clientListColumnHidden, ARRSIZE(clientListColumnHidden), _T("ClientListColumnHidden"), _T("Column") );
	RatioIni.SerGet(true, clientListColumnOrder, ARRSIZE(clientListColumnOrder), _T("ClientListColumnOrder"), _T("Column") );
	//
	int Pos = 0;
	CString MajorVersion = VersionRT.Tokenize( _T(" "), Pos );
	if (theApp.GetModVersion().Find(MajorVersion) == -1)
	{
		// Changed--Not use RT before
		if (MajorVersion.IsEmpty() == true)
		{
			deadserverretries = MAX_SERVERFAILCOUNT;
			m_iExtractMetaData = 0;
			m_iCommitFiles = 2;
			if (m_iFileBufferSize < 524288)   m_iFileBufferSize = 524288;   // 524288 = 512 * 1024
		}
		// Changed--Below "RT.15a" (Include RT.15a)
		else if (MajorVersion.Compare(_T("RT.15a")) <= 0)
		{
			if (rt_ConnectTimeOut == 40000)   rt_ConnectTimeOut = 5000;
			// Changed--Below "RT.14a" (Include RT.14a)
			if (MajorVersion.Compare(_T("RT.14a")) <= 0)
			{
				if ( (port == 23) && (udpport == 70) )
				{
					port = 70;
					udpport = 23;
				}
			}
			// Changed--Below "RT.13e" (Include RT.13e)
			if (MajorVersion.Compare(_T("RT.13e")) <= 0)
			{
				rt_ResetDontDownload = true;
			}
			// Changed--Below "RT.13a" (Include RT.13a)
			if (MajorVersion.Compare(_T("RT.13a")) <= 0)
			{
				deadserverretries = MAX_SERVERFAILCOUNT;
				m_iExtractMetaData = 0;
			}
		}
		// Initial
		rt_UserNickforServer.Format( _T("[CHN][eDtoon][Popgo][KOR][ARC][TLF][VeryCD][Cyndi][Dmhy][EastShare]") );
		// Connection
		if (rt_PingCustomIP == false)   rt_PingCustomIP = RatioIni.GetBool( _T("IsPingCustomIP"), false, _T("General") );
		if (rt_CustomIP == 0)   rt_CustomIP = RatioIni.GetUInt64( _T("CustomIP"), 0, _T("General") );
		// Priority Limit
		if (rt_DLPrioLimit[RT_PR_VERYLOW] == 0)
			rt_DLPrioLimit[RT_PR_VERYLOW] = RatioIni.GetInt( _T("DLPriorityLimit_VeryLow"), 400, _T("Download") );
		if (rt_DLPrioLimit[RT_PR_LOW] == 0)
			rt_DLPrioLimit[RT_PR_LOW] = RatioIni.GetInt( _T("DLPriorityLimit_Low"), 200, _T("Download") );
		if (rt_DLPrioLimit[RT_PR_NORMAL] == 0)
			rt_DLPrioLimit[RT_PR_NORMAL] = RatioIni.GetInt( _T("DLPriorityLimit_Normal"), 100, _T("Download") );
		if (rt_DLPrioLimit[RT_PR_HIGH] == 0)
			rt_DLPrioLimit[RT_PR_HIGH] = RatioIni.GetInt( _T("DLPriorityLimit_High"), 50, _T("Download") );
		//
		if (rt_ULPrioLimit[RT_PR_VERYLOW] == 0)
			rt_ULPrioLimit[RT_PR_VERYLOW] = RatioIni.GetInt( _T("ULPriorityLimit_VeryLow"), 80, _T("Upload") );
		if (rt_ULPrioLimit[RT_PR_LOW] == 0)
			rt_ULPrioLimit[RT_PR_LOW] = RatioIni.GetInt( _T("ULPriorityLimit_Low"), 40, _T("Upload") );
		if (rt_ULPrioLimit[RT_PR_NORMAL] == 0)
			rt_ULPrioLimit[RT_PR_NORMAL] = RatioIni.GetInt( _T("ULPriorityLimit_Normal"), 20, _T("Upload") );
		if (rt_ULPrioLimit[RT_PR_HIGH] == 0)
			rt_ULPrioLimit[RT_PR_HIGH] = RatioIni.GetInt( _T("ULPriorityLimit_High"), 10, _T("Upload") );
		// Convert Old Format KnownFile to New Format
		RT_ConvertOldKnownFile();
		// Convert Official Credits File to RT Format
		RT_ClientsMet2RT();
		// Delete Old File
		const FileCount = 8;
		CString FilenameList[] = { _T("RatioPreferences.ini"), _T("RatioCategory.ini"), _T("RatioFakeFiles.ini"),
								_T("RatioHistory.ini"), _T("RatioKnownFile.ini"), _T("RatioStatistics.ini"),
								_T("RatioIP2Country.dat"), _T("") };
		CString OldFilename;
		// Config Dir
		for (int i = 0; i < FileCount; i++)
		{
			OldFilename.Format( _T("%s%s"), configdir, FilenameList[i] );
			_tremove(OldFilename);
		}
		// Backup Dir
		for (int i = 0; i < FileCount; i++)
		{
			OldFilename.Format( _T("%sBACKUP\\%s"), appdir, FilenameList[i] );
			_tremove(OldFilename);
		}
		// Backup2 Dir
		for (int i = 0; i < FileCount; i++)
		{
			OldFilename.Format( _T("%sBACKUP2\\%s"), appdir, FilenameList[i] );
			_tremove(OldFilename);
		}
		// Delete Old Ratio Ini File
		if (PathFileExists(Filename) == TRUE)   _tremove(Filename);
	}
}

// Save Ratio Setting
void CPreferences::RT_SaveSettings()
{
	CString Filename;
	Filename.Format( _T("%sRT_Preferences.ini"), configdir);
	CIni RatioIni(Filename);
	uint64 LastBackupTime = RatioIni.GetUInt64( _T("LastBackupTime"), 0, _T("Extended") );
	CArray <CString, CString&> KeepData;
	KeepData.Add( RatioIni.GetString(_T("FriendListCtrlColumnWidths"), _T(""), _T("Column")) );
	KeepData.Add( RatioIni.GetString(_T("FriendListCtrlColumnHidden"), _T(""), _T("Column")) );
	KeepData.Add( RatioIni.GetString(_T("FriendListCtrlColumnOrders"), _T(""), _T("Column")) );
	KeepData.Add( RatioIni.GetString(_T("FriendListCtrlSortItem"), _T(""), _T("Column")) );
	KeepData.Add( RatioIni.GetString(_T("FriendListCtrlSortAscending"), _T(""), _T("Column")) );
	RatioAppendINI RatioINI;
	if (RatioINI.OpenFile(Filename, _T("w")) == true)
	{
		// General
		RatioINI.WriteSection( _T("General") );
		RatioINI.Write( _T("Version"), theApp.GetModVersion() );
		RatioINI.Write( _T("UserHash"), md4str(GetUserHash()) );
		RatioINI.Write( _T("LeecherCount"), rt_LeecherCount );
		RatioINI.Write( _T("UserNickforServer"), rt_UserNickforServer );
		RatioINI.Write( _T("RunHighPriority"), rt_RunHighPriority );
		RatioINI.Write( _T("BackupConfig"), rt_AutoBackupConfig );
		RatioINI.Write( _T("TableSortPlus"), rt_TableSortPlus );
		RatioINI.Write( _T("StatusExpand"), rt_StatusExpand );
		RatioINI.Write( _T("RecordUploadQueueWaitedTime"), rt_RecordUploadQueueWaitedTime );
		RatioINI.Write( _T("FlushBufferTimeLimit"), rt_FlushBufferTimeLimit );
		RatioINI.Write( _T("DontDownload"), RT_DONT_DOWNLOAD_VERSION );
		RatioINI.Write( _T("SaveCpuLoad"), rt_SaveCpuLoad );
		RatioINI.Write( _T("AllCategoryType"), rt_AllCategoryType );
		// Display
		RatioINI.WriteSection( _T("Display") );
		RatioINI.Write( _T("IsHashNick"), rt_HashNick );
		RatioINI.Write( _T("IsDisplayCountry"), rt_DisplayCountry );
		RatioINI.Write( _T("IsDisplayFlag"), rt_DisplayFlag );
		RatioINI.Write( _T("FontForAllWindows"), rt_FontForAllWindows );
		RatioINI.Write( _T("IsRatioColor"), rt_RatioColor );
		RatioINI.Write( _T("IsRatioStyleServer"), rt_RatioStyleServer );
		RatioINI.Write( _T("IsRatioStyleTransfer"), rt_RatioStyleTransfer );
		RatioINI.Write( _T("IsDownloadSortSeparateStop"), rt_DownloadSortSeparateStop );
		RatioINI.Write( _T("DisplayIconOfFiletype"), rt_DisplayIconOfFiletype );
		// Display--Color
		RatioINI.WriteSerial( _T("RatioColors"), rt_RatioColors, ARRSIZE(rt_RatioColors) );
		// Connection
		RatioINI.WriteSection( _T("Connection") );
		RatioINI.Write( _T("IsPingCustomIP"), rt_PingCustomIP );
		RatioINI.Write( _T("CustomIP"), rt_CustomIP );
		RatioINI.Write( _T("SaveOverhead"), rt_SaveOverhead );
		RatioINI.Write( _T("ConnectTimeOut"), rt_ConnectTimeOut );
		RatioINI.Write( _T("RandomTCPPort"), rt_RandomTCPPort );
		RatioINI.Write( _T("RandomUDPPort"), rt_RandomUDPPort );
		RatioINI.Write( _T("RandomTCPPortList"), rt_RandomTCPPortList );
		RatioINI.Write( _T("RandomUDPPortList"), rt_RandomUDPPortList );
		// Directory
		// Release
		RatioINI.WriteSection( _T("Release") );
		RatioINI.Write( _T("IsReleaseRarestOnly"), rt_ReleaseRarestOnly );
		RatioINI.Write( _T("MoreRarestPart"), rt_MoreRarestPart );
		RatioINI.Write( _T("IsAutoRelease"), rt_AutoRelease );
		RatioINI.Write( _T("AutoReleaseMin"), rt_AutoReleaseMin );
		RatioINI.Write( _T("AutoReleaseMax"), rt_AutoReleaseMax );
		// Upload
		RatioINI.WriteSection( _T("Upload") );
		RatioINI.Write( _T("FriendSlotAuto"), rt_FriendSlotAuto );
		RatioINI.Write( _T("MinUploadSlot"), rt_MinUploadSlot );
		RatioINI.Write( _T("MaxUploadSlot"), rt_MaxUploadSlot );
		RatioINI.Write( _T("IsKeepFriendSlot"), rt_KeepFriendSlot );
		RatioINI.Write( _T("IsSlotFocus"), rt_SlotFocus );
		RatioINI.Write( _T("MaxReleaseSlot"), rt_MaxReleaseSlot );
		RatioINI.Write( _T("MaxCredit1Slot"), rt_MaxCredit1Slot );
		RatioINI.Write( _T("UserHashFS"), md4str(rt_UserHashFS) );
		// Upload--Priority Limit
		RatioINI.WriteSerial( _T("ULPriorityLimit"), rt_ULPrioLimit, ARRSIZE(rt_ULPrioLimit) );
		// Download
		RatioINI.WriteSection( _T("Download") );
		RatioINI.Write( _T("PreCheckDiskspace"), rt_PreCheckDiskspace );
		RatioINI.Write( _T("AutoSwapA4AF"), rt_AutoSwapA4AF );
		RatioINI.Write( _T("MaxQR"), rt_MaxQR );
		RatioINI.Write( _T("IncludeStoppedFile"), rt_IncludeStoppedFile );
		RatioINI.Write( _T("StartNextFileBy"), rt_StartNextFileBy );
		// Download--Priority Limit
		RatioINI.WriteSerial( _T("DLPriorityLimit"), rt_DLPrioLimit, ARRSIZE(rt_DLPrioLimit) );
		// Log
		RatioINI.WriteSection( _T("Log") );
		RatioINI.Write( _T("LogRatioVerbose"), rt_LogRatioVerbose );
		RatioINI.Write( _T("LogNormalVerbose"), rt_LogNormalVerbose );
		// Log--WebCache (Code By JP)
		RatioINI.Write( _T("LogWebCacheEvents"), m_bLogWebCacheEvents );   // JP log webcache events
		// Column Settings
		RatioINI.WriteSection( _T("Column") );
		RatioINI.WriteSerial( _T("DownloadColumnWidths"), downloadColumnWidths, ARRSIZE(downloadColumnWidths) );
		RatioINI.WriteSerial( _T("DownloadColumnHidden"), downloadColumnHidden, ARRSIZE(downloadColumnHidden) );
		RatioINI.WriteSerial( _T("DownloadColumnOrder"), downloadColumnOrder, ARRSIZE(downloadColumnOrder) );
		RatioINI.WriteSerial( _T("UploadColumnWidths"), uploadColumnWidths, ARRSIZE(uploadColumnWidths) );
		RatioINI.WriteSerial( _T("UploadColumnHidden"), uploadColumnHidden, ARRSIZE(uploadColumnHidden) );
		RatioINI.WriteSerial( _T("UploadColumnOrder"), uploadColumnOrder, ARRSIZE(uploadColumnOrder) );
		RatioINI.WriteSerial( _T("SharedColumnWidths"), sharedColumnWidths, ARRSIZE(sharedColumnWidths) );
		RatioINI.WriteSerial( _T("SharedColumnHidden"), sharedColumnHidden, ARRSIZE(sharedColumnHidden) );
		RatioINI.WriteSerial( _T("SharedColumnOrder"), sharedColumnOrder, ARRSIZE(sharedColumnOrder) );
		RatioINI.WriteSerial( _T("QueueColumnWidths"), queueColumnWidths, ARRSIZE(queueColumnWidths) );
		RatioINI.WriteSerial( _T("QueueColumnHidden"), queueColumnHidden, ARRSIZE(queueColumnHidden) );
		RatioINI.WriteSerial( _T("QueueColumnOrder"), queueColumnOrder, ARRSIZE(queueColumnOrder) );
		RatioINI.WriteSerial( _T("ClientListColumnWidths"), clientListColumnWidths, ARRSIZE(clientListColumnWidths) );
		RatioINI.WriteSerial( _T("ClientListColumnHidden"), clientListColumnHidden, ARRSIZE(clientListColumnHidden) );
		RatioINI.WriteSerial( _T("ClientListColumnOrder"), clientListColumnOrder, ARRSIZE(clientListColumnOrder) );
		RatioINI.Write( _T("FriendListCtrlColumnWidths"), KeepData.GetAt(0) );
		RatioINI.Write( _T("FriendListCtrlColumnHidden"), KeepData.GetAt(1) );
		RatioINI.Write( _T("FriendListCtrlColumnOrders"), KeepData.GetAt(2) );
		RatioINI.Write( _T("FriendListCtrlSortItem"), KeepData.GetAt(3) );
		RatioINI.Write( _T("FriendListCtrlSortAscending"), KeepData.GetAt(4) );
		// Clear Normal Exit Flag
		RatioINI.WriteSection( _T("Extended") );
		RatioINI.Write( _T("IsNormalExit"), false );
		RatioINI.Write( _T("LastBackupTime"), LastBackupTime );
		// Wap Server by MoNKi
		RatioINI.WriteSection( _T("WapServer") );
		RatioINI.Write( _T("WapEnabled"), m_bWapEnabled );
		RatioINI.Write( _T("WapTemplateFile"), CString(m_sWapTemplateFile) );
		RatioINI.Write( _T("WapPort"), m_nWapPort );
		RatioINI.Write( _T("WapGraphWidth"), m_iWapGraphWidth );
		RatioINI.Write( _T("WapGraphHeight"), m_iWapGraphHeight );
		RatioINI.Write( _T("WapFilledGraphs"), m_bWapFilledGraphs );
		RatioINI.Write( _T("WapMaxItemsInPage"), m_iWapMaxItemsInPages );
		RatioINI.Write( _T("WapSendImages"), m_bWapSendImages );
		RatioINI.Write( _T("WapSendGraphs"), m_bWapSendGraphs );
		RatioINI.Write( _T("WapSendProgressBars"), m_bWapSendProgressBars );
		RatioINI.Write( _T("WapSendBWImages"), m_bWapAllwaysSendBWImages );
		RatioINI.Write( _T("WapLogsSize"), m_iWapLogsSize );
		RatioINI.Write( _T("WapPassword"), m_sWapPassword );
		RatioINI.Write( _T("WapPasswordLow"), m_sWapLowPassword );
		RatioINI.Write( _T("WapLowEnable"), m_bWapLowEnabled );
// RT, WebCache (Code by JP/yonatan/Superlexx)
		RatioINI.WriteSection( _T("WebCache") );
		RatioINI.Write( _T("webcacheName"), webcacheName );
		RatioINI.Write( _T("webcachePort"), webcachePort );
		RatioINI.Write( _T("WebCacheBlockLimit"), webcacheBlockLimit );
		RatioINI.Write( _T("PersistentConnectionsForProxyDownloads"), PersistentConnectionsForProxyDownloads ); //JP persistent proxy connections
		RatioINI.Write( _T("WebCacheExtraTimeout"), webcacheExtraTimeout );
		RatioINI.Write( _T("WebCacheCachesLocalTraffic"), webcacheCachesLocalTraffic );
		RatioINI.Write( _T("WebCacheEnabled"), webcacheEnabled );
		RatioINI.Write( _T("detectWebcacheOnStartup"), detectWebcacheOnStartup ); // jp detect webcache on startup
		RatioINI.Write( _T("WebCacheLastSearch"), uint64(webcacheLastSearch) );
		RatioINI.Write( _T("WebCacheLastGlobalIP"), uint64(webcacheLastGlobalIP) );
		RatioINI.Write( _T("WebCacheLastResolvedName"), webcacheLastResolvedName );
// End--WebCache
		//
		RatioINI.CloseFile();
	}
}

// Initial Ratio Setting
void CPreferences::RT_InitialSettings()
{
// RT, MINI Version
#ifdef MINI
	proxy.UseProxy = false;
#endif
	// Uncategorized Temporary Directory
	SetTempDir(0, tempdir);
	// Random Port
	rt_RealTCPPort = port;
	rt_RealUDPPort = udpport;
	if (rt_SessionRandomTCPPort == true)
	{
		port = GetRandomPort(rt_RandomTCPPortList);
		if (port == 0)
		{
			port = rt_RealTCPPort;
			rt_SessionRandomTCPPort = false;
		}
	}
	if (rt_SessionRandomUDPPort == true)
	{
		udpport = GetRandomPort(rt_RandomUDPPortList);
		if (udpport == 0)
		{
			udpport = rt_RealUDPPort;
			rt_SessionRandomUDPPort = false;
		}
		if (udpport == port)
		{
			if (port < 65535)
				udpport = port + 1;
			else
				udpport = port - 1;
		}
	}
	// More than Rarest Part
	if (rt_MoreRarestPart < 0)
		rt_MoreRarestPart = 0;
	else if (rt_MoreRarestPart > 15)
		rt_MoreRarestPart = 15;
	// Max QR
	if (rt_MaxQR < 100)
		rt_MaxQR = 100;
	else if (rt_MaxQR > 10000)
		rt_MaxQR = 10000;
	// Leecher Count
	if (rt_LeecherCount < 3)
		rt_LeecherCount = 3;
	else if (rt_LeecherCount > 31)
		rt_LeecherCount = 31;
	// Auto Release Min
	if (rt_AutoReleaseMin < 1)
		rt_AutoReleaseMin = 1;
	else if (rt_AutoReleaseMin > 100)
		rt_AutoReleaseMin = 100;
	// Auto Release Max
	if (rt_AutoReleaseMax < 5)
		rt_AutoReleaseMax = 5;
	else if (rt_AutoReleaseMax > 100)
		rt_AutoReleaseMax = 100;
	// Min Upload Slot
	if ( rt_MinUploadSlot > uint8(maxGraphUploadRate / 3) )   rt_MinUploadSlot = uint8(maxGraphUploadRate / 3);
	if (rt_MinUploadSlot < 2)
		rt_MinUploadSlot = 2;
	else if (rt_MinUploadSlot > MAX_UP_CLIENTS_ALLOWED)
		rt_MinUploadSlot = MAX_UP_CLIENTS_ALLOWED;
	// Max Upload Slot
	if (rt_MaxUploadSlot < rt_MinUploadSlot)
		rt_MaxUploadSlot = rt_MinUploadSlot;
	else if (rt_MaxUploadSlot > MAX_UP_CLIENTS_ALLOWED)
		rt_MaxUploadSlot = MAX_UP_CLIENTS_ALLOWED;
	// Max Release Slot
	if (rt_MaxReleaseSlot < 0)
		rt_MaxReleaseSlot = 0;
	else if (rt_MaxReleaseSlot > MAX_UP_CLIENTS_ALLOWED)
		rt_MaxReleaseSlot = MAX_UP_CLIENTS_ALLOWED;
	// Max Credit1 Slot
	if (rt_MaxCredit1Slot < 0)
		rt_MaxCredit1Slot = 0;
	else if (rt_MaxCredit1Slot > MAX_UP_CLIENTS_ALLOWED)
		rt_MaxCredit1Slot = MAX_UP_CLIENTS_ALLOWED;
	//
	if (rt_MaxUploadSlot < rt_MinUploadSlot)   rt_MaxUploadSlot = rt_MinUploadSlot;
	if (rt_MaxReleaseSlot > rt_MaxUploadSlot)   rt_MaxReleaseSlot = rt_MaxUploadSlot;
	if (rt_MaxCredit1Slot > rt_MaxUploadSlot)   rt_MaxCredit1Slot = rt_MaxUploadSlot;
	// User Nick for Server
	if (rt_UserNickforServer.IsEmpty() == true)   rt_UserNickforServer.Format( _T("[CHN][eDtoon][Popgo][ARC][TLF][VeryCD][Cyndi][Dmhy][EastShare]") );
	// Upload Queue
	if (m_iQueueSize > 10000)
	{
		if (m_iQueueSize != 10100)   m_iQueueSize = 10000;
	}
	else if (m_iQueueSize < 2000)
		m_iQueueSize = 2000;
	// USS
    if (m_iDynUpPingTolerance < 200)   m_iDynUpPingTolerance = 200;
	if (m_iDynUpPingToleranceMilliseconds < 200)   m_iDynUpPingToleranceMilliseconds = 200;
	// Always Enable "Full Chunk Transfer"
	m_btransferfullchunks = true;
	// Always Enable "A4AF Save SPU"
	m_bA4AFSaveCpu = true;
	// Limit All Files or Uncategorized
	if (rt_AllCategoryType > 1)   rt_AllCategoryType = 0;
	// Flush Buffer Time Limit
	if (rt_FlushBufferTimeLimit < BUFFER_TIME_LIMIT)
		rt_FlushBufferTimeLimit = BUFFER_TIME_LIMIT;
	else if ( rt_FlushBufferTimeLimit > MIN2MS(15) )
		rt_FlushBufferTimeLimit = MIN2MS(15);
	// Dead Server Retries (10 = Disable)
	if (deadserverretries == 0)   deadserverretries = MAX_SERVERFAILCOUNT;
	// Download Priority Limit
	if (rt_DLPrioLimit[RT_PR_HIGH] == 0)   rt_DLPrioLimit[RT_PR_HIGH] = 50;
	if (rt_DLPrioLimit[RT_PR_NORMAL] == 0)   rt_DLPrioLimit[RT_PR_NORMAL] = 100;
	if (rt_DLPrioLimit[RT_PR_LOW] == 0)   rt_DLPrioLimit[RT_PR_LOW] = 200;
	if (rt_DLPrioLimit[RT_PR_VERYLOW] == 0)   rt_DLPrioLimit[RT_PR_VERYLOW] = 400;
	// Upload Priority Limit
	if (rt_ULPrioLimit[RT_PR_HIGH] == 0)   rt_ULPrioLimit[RT_PR_HIGH] = 10;
	if (rt_ULPrioLimit[RT_PR_NORMAL] == 0)   rt_ULPrioLimit[RT_PR_NORMAL] = 20;
	if (rt_ULPrioLimit[RT_PR_LOW] == 0)   rt_ULPrioLimit[RT_PR_LOW] = 40;
	if (rt_ULPrioLimit[RT_PR_VERYLOW] == 0)   rt_ULPrioLimit[RT_PR_VERYLOW] = 80;
	// Display Color
	bool IsResetColor = true;
	for (int i = 0; i < RT_COLOR_COUNT; i++)
	{
		if (rt_RatioColors[i] != 0)
		{
			IsResetColor = false;
			break;
		}
	}
	if (IsResetColor == true)
	{
		// Display Color--Download Bar
		rt_RatioColors[RT_CR_DB_MISS] = RGB(255, 0, 0);
		rt_RatioColors[RT_CR_DB_HAVE] = RGB(0, 200, 0);
		rt_RatioColors[RT_CR_DB_PENDING] = RGB(230, 180, 0);
		rt_RatioColors[RT_CR_DB_PROGRESS] = RGB(0, 255, 0);
		// Display Color--Client Bar
		rt_RatioColors[RT_CR_CB_NEITHER] = RGB(245, 245, 245);
		rt_RatioColors[RT_CR_CB_BOTH] = RGB(0, 0, 0);
		rt_RatioColors[RT_CR_CB_HAVE] = RGB(0, 200, 0);
		rt_RatioColors[RT_CR_CB_CLIENT] = RGB(0, 0, 255);
		rt_RatioColors[RT_CR_CB_PENDING] = RGB(255, 208, 0);
		rt_RatioColors[RT_CR_CB_NEXT] = RGB(255, 255, 0);
		// Display Color--Uploaded Bar
		rt_RatioColors[RT_CR_UB_1TIME] = RGB(255, 0, 0);
		rt_RatioColors[RT_CR_UB_2TIME] = RGB(255, 200, 0);
		rt_RatioColors[RT_CR_UB_3TIME] = RGB(255, 255, 0);
		rt_RatioColors[RT_CR_UB_4TIME] = RGB(0, 230, 0);
		rt_RatioColors[RT_CR_UB_5TIME] = RGB(0, 0, 255);
		rt_RatioColors[RT_CR_UB_6TIME] = RGB(0, 245, 245);
		rt_RatioColors[RT_CR_UB_7TIME] = RGB(210, 210, 255);
		// Display Color--Download Text
		rt_RatioColors[RT_CR_DT_COMPLETED] = RGB(0, 200, 0);
		rt_RatioColors[RT_CR_DT_DOWNLOADING] = RGB(220, 160, 0);
		rt_RatioColors[RT_CR_DT_WAITING] = RGB(0, 0, 0);
		rt_RatioColors[RT_CR_DT_MISS] = RGB(230, 0, 0);
		rt_RatioColors[RT_CR_DT_STOPPED] = RGB(128, 128, 128);
		// Display Color--Share Text
		rt_RatioColors[RT_CR_ST_TRANSFERRED] = RGB(0, 200, 0);
		rt_RatioColors[RT_CR_ST_COMPLETED] = RGB(0, 0, 0);
		rt_RatioColors[RT_CR_ST_DOWNLOADING] = RGB(220, 160, 0);
		rt_RatioColors[RT_CR_ST_WAITING] = RGB(230, 0, 0);
		// Display Color--Client Text
		rt_RatioColors[RT_CR_CT_TRADE] = RGB(0, 200, 0);
		rt_RatioColors[RT_CR_CT_TRANSFER] = RGB(0, 0, 255);
		rt_RatioColors[RT_CR_CT_BAD] = RGB(230, 0, 0);
	}
/*
	// Display Color--Download Bar
	if (rt_RatioColors[RT_CR_DB_MISS] == 0)   rt_RatioColors[RT_CR_DB_MISS] = RGB(255, 0, 0);
	if (rt_RatioColors[RT_CR_DB_HAVE] == 0)   rt_RatioColors[RT_CR_DB_HAVE] = RGB(0, 200, 0);
	if (rt_RatioColors[RT_CR_DB_PENDING] == 0)   rt_RatioColors[RT_CR_DB_PENDING] = RGB(230, 180, 0);
	if (rt_RatioColors[RT_CR_DB_PROGRESS] == 0)   rt_RatioColors[RT_CR_DB_PROGRESS] = RGB(0, 255, 0);
	// Display Color--Client Bar
	if (rt_RatioColors[RT_CR_CB_NEITHER] == 0)   rt_RatioColors[RT_CR_CB_NEITHER] = RGB(245, 245, 245);
	if (rt_RatioColors[RT_CR_CB_BOTH] == 0)   rt_RatioColors[RT_CR_CB_BOTH] = RGB(0, 0, 0);
	if (rt_RatioColors[RT_CR_CB_HAVE] == 0)   rt_RatioColors[RT_CR_CB_HAVE] = RGB(0, 200, 0);
	if (rt_RatioColors[RT_CR_CB_CLIENT] == 0)   rt_RatioColors[RT_CR_CB_CLIENT] = RGB(0, 0, 255);
	if (rt_RatioColors[RT_CR_CB_PENDING] == 0)   rt_RatioColors[RT_CR_CB_PENDING] = RGB(255, 208, 0);
	if (rt_RatioColors[RT_CR_CB_NEXT] == 0)   rt_RatioColors[RT_CR_CB_NEXT] = RGB(255, 255, 0);
	// Display Color--Uploaded Bar
	if (rt_RatioColors[RT_CR_UB_1TIME] == 0)   rt_RatioColors[RT_CR_UB_1TIME] = RGB(255, 0, 0);
	if (rt_RatioColors[RT_CR_UB_2TIME] == 0)   rt_RatioColors[RT_CR_UB_2TIME] = RGB(255, 200, 0);
	if (rt_RatioColors[RT_CR_UB_3TIME] == 0)   rt_RatioColors[RT_CR_UB_3TIME] = RGB(255, 255, 0);
	if (rt_RatioColors[RT_CR_UB_4TIME] == 0)   rt_RatioColors[RT_CR_UB_4TIME] = RGB(0, 230, 0);
	if (rt_RatioColors[RT_CR_UB_5TIME] == 0)   rt_RatioColors[RT_CR_UB_5TIME] = RGB(0, 0, 255);
	if (rt_RatioColors[RT_CR_UB_6TIME] == 0)   rt_RatioColors[RT_CR_UB_6TIME] = RGB(0, 245, 245);
	if (rt_RatioColors[RT_CR_UB_7TIME] == 0)   rt_RatioColors[RT_CR_UB_7TIME] = RGB(210, 210, 255);
	// Display Color--Download Text
	if (rt_RatioColors[RT_CR_DT_COMPLETED] == 0)   rt_RatioColors[RT_CR_DT_COMPLETED] = RGB(0, 200, 0);
	if (rt_RatioColors[RT_CR_DT_DOWNLOADING] == 0)   rt_RatioColors[RT_CR_DT_DOWNLOADING] = RGB(220, 160, 0);
	if (rt_RatioColors[RT_CR_DT_WAITING] == 0)   rt_RatioColors[RT_CR_DT_WAITING] = RGB(0, 0, 0);
	if (rt_RatioColors[RT_CR_DT_MISS] == 0)   rt_RatioColors[RT_CR_DT_MISS] = RGB(230, 0, 0);
	if (rt_RatioColors[RT_CR_DT_STOPPED] == 0)   rt_RatioColors[RT_CR_DT_STOPPED] = RGB(128, 128, 128);
	// Display Color--Share Text
	if (rt_RatioColors[RT_CR_ST_TRANSFERRED] == 0)   rt_RatioColors[RT_CR_ST_TRANSFERRED] = RGB(0, 200, 0);
	if (rt_RatioColors[RT_CR_ST_COMPLETED] == 0)   rt_RatioColors[RT_CR_ST_COMPLETED] = RGB(0, 0, 0);
	if (rt_RatioColors[RT_CR_ST_DOWNLOADING] == 0)   rt_RatioColors[RT_CR_ST_DOWNLOADING] = RGB(220, 160, 0);
	if (rt_RatioColors[RT_CR_ST_WAITING] == 0)   rt_RatioColors[RT_CR_ST_WAITING] = RGB(230, 0, 0);
	// Display Color--Client Text
	if (rt_RatioColors[RT_CR_CT_TRADE] == 0)   rt_RatioColors[RT_CR_CT_TRADE] = RGB(0, 200, 0);
	if (rt_RatioColors[RT_CR_CT_TRANSFER] == 0)   rt_RatioColors[RT_CR_CT_TRANSFER] = RGB(0, 0, 255);
	if (rt_RatioColors[RT_CR_CT_BAD] == 0)   rt_RatioColors[RT_CR_CT_BAD] = RGB(230, 0, 0);
*/
}

// Set UserHash of Friend Slot
void CPreferences::SetUserHashFS(const uchar* NewUserHashFS)
{
	md4cpy(rt_UserHashFS, NewUserHashFS);
}

// Set UserHash of Friend Slot
void CPreferences::SetUserHashFS(const CString NewUserHashFS)
{
	if (NewUserHashFS.IsEmpty() == true)
	{
		md4clr(rt_UserHashFS);
		return;
	}
	strmd4(NewUserHashFS, rt_UserHashFS);
}

// Set UserHash of Friend Slot
bool CPreferences::IsCurrentFS(const uchar* UserHash)
{
	if ( (((uint32 *)userhash[0]) == 0) && (((uint32 *)userhash[1]) == 0) &&
		(((uint32 *)userhash[2]) == 0) && (((uint32 *)userhash[3]) == 0) )
	{
		return false;
	}
	return (md4cmp(UserHash, rt_UserHashFS) == 0);
}

// Backup Config
void CPreferences::RT_BackupConfig()
{
	CString RatioIniFileName;
	RatioIniFileName.Format( _T("%sRT_Preferences.ini"), configdir);
	if (PathFileExists(RatioIniFileName) == FALSE)   return;
	CIni RatioIni(RatioIniFileName, _T("General") );
	if (RatioIni.GetString( _T("Version"), _T(""), _T("General") ).IsEmpty() == true)   return;
	rt_AutoBackupConfig = RatioIni.GetInt( _T("BackupConfig"), true, _T("General") );
	uint32 LastBackupTime = RatioIni.GetUInt64( _T("LastBackupTime"), 0, _T("Extended") );
	if ( (uint64(time(NULL)) - LastBackupTime) < MIN2S(5) )   return;
	rt_NormalExitLastTime = RatioIni.GetBool( _T("IsNormalExit"), true, _T("Extended") );
	// Is Need Restore
	if (rt_NormalExitLastTime == false)
	{
		if (rt_AutoBackupConfig != RT_ABC_DISABLE)   RT_RestoreConfig();
		AfxMessageBox( GetResString(RT_IDS_UNNORMAL_EXIT) );
		return;
	}
	// Create Config Backup Directory
	m_bVerbose = true;
	CString ConfigBackup = appdir + _T("BACKUP");
	if (PathFileExists(ConfigBackup) == FALSE)   ::CreateDirectory(ConfigBackup, 0);
	if (rt_AutoBackupConfig == RT_ABC_BACKUP2)
	{
		ConfigBackup = appdir + _T("BACKUP2");
		if (PathFileExists(ConfigBackup) == FALSE)   ::CreateDirectory(ConfigBackup, 0);
		MoveDirectory( (appdir + _T("BACKUP")), (appdir + _T("BACKUP2")), true, CopyOnlyFileList );
	}
	CopyDirectory( configdir, (appdir + _T("BACKUP")), true, false, IgnoreFileList );
	RatioIni.WriteUInt64( _T("LastBackupTime"), uint64(time(NULL)), _T("Extended") );
}

// Restore Config
void CPreferences::RT_RestoreConfig()
{
	CString Filename;
	Filename.Format( _T("%sRT_Flag.ini"), configdir );
	CIni RatioIni( Filename, _T("NormalExit") );
}

void CPreferences::SetNormalExit(CString EntryKey, bool Flag)
{
	CString Filename;
	Filename.Format( _T("%sRT_Flag.ini"), configdir );
	CIni RatioIni( Filename, _T("NormalExit") );
	RatioIni.WriteBool(EntryKey, Flag);
}

// Table Sort Plus
bool CPreferences::GetTableSortPlus(uint16 Source)
{
	uint16 SourceTable = 1 << Source;
	return (rt_TableSortPlus & SourceTable);
}

// Table Sort Plus
void CPreferences::SetTableSortPlus(uint16 Target, bool Status)
{
	uint16 TargetTable = 1 << Target;
	if (Status == true)
		rt_TableSortPlus |= TargetTable;
	else
	{
		TargetTable ^= 0xFFFF;
		rt_TableSortPlus &= TargetTable;
	}
	CString RatioIniFileName;
	RatioIniFileName.Format( _T("%sRT_Preferences.ini"), configdir);
	CIni RatioIni(RatioIniFileName, _T("General") );
	// General
	RatioIni.WriteInt( _T("TableSortPlus"), rt_TableSortPlus, _T("General") );
}

// Transfer Bytes
void CPreferences::RT_AddStatistics(CUpDownClient* Client, bool IsDownloadData, uint32 Bytes)
{
	if (Bytes == 0)   return;
	// Add Transfer Bytes for MOD
	int ModNO = Client->GetModNO();
	if (ModNO < RT_MOD_COUNT)
	{
		if (IsDownloadData == true)
		{
			rt_SessionDownloadMod[ModNO] = (rt_SessionDownloadMod[ModNO] + Bytes);
			rt_CumulativeDownloadMod[ModNO] = (rt_CumulativeDownloadMod[ModNO] + Bytes);
		}
		else
		{
			rt_SessionUploadMod[ModNO] = (rt_SessionUploadMod[ModNO] + Bytes);
			rt_CumulativeUploadMod[ModNO] = (rt_CumulativeUploadMod[ModNO] + Bytes);
		}
	}
	else if (thePrefs.IsLogRatioVerbose() == true)
		AddDebugLogLine(false, _T(">> [RT Debug] Over Array Rang. [ModNO = %u]"), ModNO);
	// Add Transfer Bytes for Country
	int CountryNO = Client->GetFlagNO();
	if (CountryNO < RT_COUNTRY_COUNT)
	{
		if (IsDownloadData == true)
		{
			rt_SessionDownloadCountry[CountryNO] = (rt_SessionDownloadCountry[CountryNO] + Bytes);
			rt_CumulativeDownloadCountry[CountryNO] = (rt_CumulativeDownloadCountry[CountryNO] + Bytes);
		}
		else
		{
			rt_SessionUploadCountry[CountryNO] = (rt_SessionUploadCountry[CountryNO] + Bytes);
			rt_CumulativeUploadCountry[CountryNO] = (rt_CumulativeUploadCountry[CountryNO] + Bytes);
		}
	}
	else if (thePrefs.IsLogRatioVerbose() == true)
		AddDebugLogLine(false, _T(">> [RT Debug] Over Array Rang. [CountryNO = %u]"), CountryNO);
}

// Ratio Statistics
bool CPreferences::RT_LoadStatistics(int Backup)
{
	// loadBackUp is 0 by default
	// loadBackUp = 0: Load the stats normally like we used to do in LoadPreferences
	// loadBackUp = 1: Load the stats from statbkup.ini and create a backup of the current stats.  Also, do not initialize session variables.
	// loadBackUp = 2: Load the stats from preferences.ini.old because the version has changed.
	CString Filename;
	switch (Backup)
	{
		case 0:
			// for transition...
			Filename.Format( _T("%sRT_Statistics.ini"), configdir );
			if (PathFileExists(Filename) == FALSE)   return false;
			break;
		case 1:
			Filename.Format( _T("%sRT_Statbkup.ini"), configdir );
			if (PathFileExists(Filename) == FALSE)   return false;
			RT_SaveStatistics(2); // Save our temp backup of current values to statbkuptmp.ini, we will be renaming it at the end of this function.
			break;
		case 2:
			Filename.Format( _T("%sRT_Statbkuptmp.ini"), configdir);
			if (PathFileExists(Filename) == FALSE)   return false;
			break;
	}
	//
	bool IsFileExist = PathFileExists(Filename);
	CIni RatioIni(Filename, _T("General") );
	CString Buffer;
	// Is Load Data from Statistics.ini
	bool IsLoaded = true;
	if (RatioIni.GetInt(_T("StatisticsVersion"), 0, _T("General")) != RT_STATISTICES_VERSION)
	{
		IsLoaded = false;
	}
	else
	{
		RatioIni.SetSection(_T("Statistics"));
		//
		totalDownloadedBytes			= RatioIni.GetUInt64(_T("TotalDownloadedBytes"));
		totalUploadedBytes				= RatioIni.GetUInt64(_T("TotalUploadedBytes"));
		// Load stats for cumulative downline overhead
		cumDownOverheadTotal			= RatioIni.GetUInt64(_T("DownOverheadTotal"));
		cumDownOverheadFileReq			= RatioIni.GetUInt64(_T("DownOverheadFileReq"));
		cumDownOverheadSrcEx			= RatioIni.GetUInt64(_T("DownOverheadSrcEx"));
		cumDownOverheadServer			= RatioIni.GetUInt64(_T("DownOverheadServer"));
		cumDownOverheadKad				= RatioIni.GetUInt64(_T("DownOverheadKad"));
		cumDownOverheadTotalPackets		= RatioIni.GetUInt64(_T("DownOverheadTotalPackets"));
		cumDownOverheadFileReqPackets	= RatioIni.GetUInt64(_T("DownOverheadFileReqPackets"));
		cumDownOverheadSrcExPackets		= RatioIni.GetUInt64(_T("DownOverheadSrcExPackets"));
		cumDownOverheadServerPackets	= RatioIni.GetUInt64(_T("DownOverheadServerPackets"));
		cumDownOverheadKadPackets		= RatioIni.GetUInt64(_T("DownOverheadKadPackets"));

		// Load stats for cumulative upline overhead
		cumUpOverheadTotal				= RatioIni.GetUInt64(_T("UpOverHeadTotal"));
		cumUpOverheadFileReq			= RatioIni.GetUInt64(_T("UpOverheadFileReq"));
		cumUpOverheadSrcEx				= RatioIni.GetUInt64(_T("UpOverheadSrcEx"));
		cumUpOverheadServer				= RatioIni.GetUInt64(_T("UpOverheadServer"));
		cumUpOverheadKad				= RatioIni.GetUInt64(_T("UpOverheadKad"));
		cumUpOverheadTotalPackets		= RatioIni.GetUInt64(_T("UpOverHeadTotalPackets"));
		cumUpOverheadFileReqPackets		= RatioIni.GetUInt64(_T("UpOverheadFileReqPackets"));
		cumUpOverheadSrcExPackets		= RatioIni.GetUInt64(_T("UpOverheadSrcExPackets"));
		cumUpOverheadServerPackets		= RatioIni.GetUInt64(_T("UpOverheadServerPackets"));
		cumUpOverheadKadPackets			= RatioIni.GetUInt64(_T("UpOverheadKadPackets"));

		// Load stats for cumulative upline data
		cumUpSuccessfulSessions			= RatioIni.GetInt(_T("UpSuccessfulSessions"));
		cumUpFailedSessions				= RatioIni.GetInt(_T("UpFailedSessions"));
		cumUpAvgTime					= RatioIni.GetInt(_T("UpAvgTime"));

		// Load cumulative client breakdown stats for sent bytes
		cumUpData_EDONKEY				= RatioIni.GetUInt64(_T("UpData_EDONKEY"));
		cumUpData_EDONKEYHYBRID			= RatioIni.GetUInt64(_T("UpData_EDONKEYHYBRID"));
		cumUpData_EMULE					= RatioIni.GetUInt64(_T("UpData_EMULE"));
		cumUpData_MLDONKEY				= RatioIni.GetUInt64(_T("UpData_MLDONKEY"));
		cumUpData_EMULECOMPAT			= RatioIni.GetUInt64(_T("UpData_LMULE"));
		cumUpData_AMULE					= RatioIni.GetUInt64(_T("UpData_AMULE"));
		cumUpData_SHAREAZA				= RatioIni.GetUInt64(_T("UpData_SHAREAZA"));

		// Load cumulative port breakdown stats for sent bytes
		cumUpDataPort_4662				= RatioIni.GetUInt64(_T("UpDataPort_4662"));
		cumUpDataPort_OTHER				= RatioIni.GetUInt64(_T("UpDataPort_OTHER"));

		// Load cumulative source breakdown stats for sent bytes
		cumUpData_File					= RatioIni.GetUInt64(_T("UpData_File"));
		cumUpData_Partfile				= RatioIni.GetUInt64(_T("UpData_Partfile"));

		// Load stats for cumulative downline data
		cumDownCompletedFiles			= RatioIni.GetInt(_T("DownCompletedFiles"));
		cumDownSuccessfulSessions		= RatioIni.GetInt(_T("DownSuccessfulSessions"));
		cumDownFailedSessions			= RatioIni.GetInt(_T("DownFailedSessions"));
		cumDownAvgTime					= RatioIni.GetInt(_T("DownAvgTime"));

		// Cumulative statistics for saved due to compression/lost due to corruption
		cumLostFromCorruption			= RatioIni.GetUInt64(_T("LostFromCorruption"));
		cumSavedFromCompression			= RatioIni.GetUInt64(_T("SavedFromCompression"));
		cumPartsSavedByICH				= RatioIni.GetInt(_T("PartsSavedByICH"));

		// Load cumulative client breakdown stats for received bytes
		cumDownData_EDONKEY				= RatioIni.GetUInt64(_T("DownData_EDONKEY"));
		cumDownData_EDONKEYHYBRID		= RatioIni.GetUInt64(_T("DownData_EDONKEYHYBRID"));
		cumDownData_EMULE				= RatioIni.GetUInt64(_T("DownData_EMULE"));
		cumDownData_MLDONKEY			= RatioIni.GetUInt64(_T("DownData_MLDONKEY"));
		cumDownData_EMULECOMPAT			= RatioIni.GetUInt64(_T("DownData_LMULE"));
		cumDownData_AMULE				= RatioIni.GetUInt64(_T("DownData_AMULE"));
		cumDownData_SHAREAZA			= RatioIni.GetUInt64(_T("DownData_SHAREAZA"));
		cumDownData_URL					= RatioIni.GetUInt64(_T("DownData_URL"));

		// Load cumulative port breakdown stats for received bytes
		cumDownDataPort_4662			= RatioIni.GetUInt64(_T("DownDataPort_4662"));
		cumDownDataPort_OTHER			= RatioIni.GetUInt64(_T("DownDataPort_OTHER"));

		// Load stats for cumulative connection data
		cumConnAvgDownRate				= RatioIni.GetFloat(_T("ConnAvgDownRate"));
		cumConnMaxAvgDownRate			= RatioIni.GetFloat(_T("ConnMaxAvgDownRate"));
		cumConnMaxDownRate				= RatioIni.GetFloat(_T("ConnMaxDownRate"));
		cumConnAvgUpRate				= RatioIni.GetFloat(_T("ConnAvgUpRate"));
		cumConnMaxAvgUpRate				= RatioIni.GetFloat(_T("ConnMaxAvgUpRate"));
		cumConnMaxUpRate				= RatioIni.GetFloat(_T("ConnMaxUpRate"));
		cumConnRunTime					= RatioIni.GetUInt64(_T("ConnRunTime"));
		cumConnTransferTime				= RatioIni.GetInt(_T("ConnTransferTime"));
		cumConnDownloadTime				= RatioIni.GetInt(_T("ConnDownloadTime"));
		cumConnUploadTime				= RatioIni.GetInt(_T("ConnUploadTime"));
		cumConnServerDuration			= RatioIni.GetInt(_T("ConnServerDuration"));
		cumConnNumReconnects			= RatioIni.GetInt(_T("ConnNumReconnects"));
		cumConnAvgConnections			= RatioIni.GetInt(_T("ConnAvgConnections"));
		cumConnMaxConnLimitReached		= RatioIni.GetInt(_T("ConnMaxConnLimitReached"));
		cumConnPeakConnections			= RatioIni.GetInt(_T("ConnPeakConnections"));

		// Load date/time of last reset
		stat_datetimeLastReset			= RatioIni.GetUInt64(_T("statsDateTimeLastReset"));

		// Smart Load For Restores - Don't overwrite records that are greater than the backed up ones
		if (Backup == 1)
		{
			// Load records for servers / network
			if ((UINT)RatioIni.GetInt(_T("SrvrsMostWorkingServers")) > cumSrvrsMostWorkingServers)
				cumSrvrsMostWorkingServers = RatioIni.GetInt(_T("SrvrsMostWorkingServers"));
	
			if ((UINT)RatioIni.GetInt(_T("SrvrsMostUsersOnline")) > cumSrvrsMostUsersOnline)
				cumSrvrsMostUsersOnline = RatioIni.GetInt(_T("SrvrsMostUsersOnline"));

			if ((UINT)RatioIni.GetInt(_T("SrvrsMostFilesAvail")) > cumSrvrsMostFilesAvail)
				cumSrvrsMostFilesAvail = RatioIni.GetInt(_T("SrvrsMostFilesAvail"));

			// Load records for shared files
			if ((UINT)RatioIni.GetInt(_T("SharedMostFilesShared")) > cumSharedMostFilesShared)
				cumSharedMostFilesShared =	RatioIni.GetInt(_T("SharedMostFilesShared"));

			uint64 temp64 = RatioIni.GetUInt64(_T("SharedLargestShareSize"));
			if (temp64 > cumSharedLargestShareSize)
				cumSharedLargestShareSize = temp64;

			temp64 = RatioIni.GetUInt64(_T("SharedLargestAvgFileSize"));
			if (temp64 > cumSharedLargestAvgFileSize)
				cumSharedLargestAvgFileSize = temp64;

			temp64 = RatioIni.GetUInt64(_T("SharedLargestFileSize"));
			if (temp64 > cumSharedLargestFileSize)
				cumSharedLargestFileSize = temp64;

			// Check to make sure the backup of the values we just overwrote exists.  If so, rename it to the backup file.
			// This allows us to undo a restore, so to speak, just in case we don't like the restored values...
			Buffer.Format( _T("%sRT_Statbkuptmp.RatioIni"), configdir );
			if (PathFileExists(Buffer) == TRUE)
			{
				_tremove(Filename);				// Remove the backup that we just restored from
				_trename(Buffer, Filename);	// Rename our temporary backup to the normal statbkup.ini filename.
			}

			// Since we know this is a restore, now we should call ShowStatistics to update the data items to the new ones we just loaded.
			// Otherwise user is left waiting around for the tick counter to reach the next automatic update (Depending on setting in prefs)
			theApp.emuledlg->statisticswnd->ShowStatistics();
		}
		// Stupid Load -> Just load the values.
		else
		{
			// Load records for servers / network
			cumSrvrsMostWorkingServers	= RatioIni.GetInt(_T("SrvrsMostWorkingServers"));
			cumSrvrsMostUsersOnline		= RatioIni.GetInt(_T("SrvrsMostUsersOnline"));
			cumSrvrsMostFilesAvail		= RatioIni.GetInt(_T("SrvrsMostFilesAvail"));

			// Load records for shared files
			cumSharedMostFilesShared	= RatioIni.GetInt(_T("SharedMostFilesShared"));
			cumSharedLargestShareSize	= RatioIni.GetUInt64(_T("SharedLargestShareSize"));
			cumSharedLargestAvgFileSize = RatioIni.GetUInt64(_T("SharedLargestAvgFileSize"));
			cumSharedLargestFileSize	= RatioIni.GetUInt64(_T("SharedLargestFileSize"));

			// Initialize new session statistic variables...
			sesDownCompletedFiles		= 0;
		
			sesUpData_EDONKEY			= 0;
			sesUpData_EDONKEYHYBRID		= 0;
			sesUpData_EMULE				= 0;
			sesUpData_MLDONKEY			= 0;
			sesUpData_AMULE				= 0;
			sesUpData_EMULECOMPAT		= 0;
			sesUpData_SHAREAZA			= 0;
			sesUpDataPort_4662			= 0;
			sesUpDataPort_OTHER			= 0;

			sesDownData_EDONKEY			= 0;
			sesDownData_EDONKEYHYBRID	= 0;
			sesDownData_EMULE			= 0;
			sesDownData_MLDONKEY		= 0;
			sesDownData_AMULE			= 0;
			sesDownData_EMULECOMPAT		= 0;
			sesDownData_SHAREAZA		= 0;
			sesDownData_URL				= 0;
			sesDownDataPort_4662		= 0;
			sesDownDataPort_OTHER		= 0;

			sesDownSuccessfulSessions	= 0;
			sesDownFailedSessions		= 0;
			sesPartsSavedByICH			= 0;
		}
		if (IsFileExist == false)
		{
			time_t timeNow;
			time(&timeNow);
			stat_datetimeLastReset = __int64(timeNow);
		}
	}
	// Mod
	for (int i = 0; i < RT_MOD_COUNT; i++)
	{
		rt_CumulativeUploadMod[i] = RatioIni.GetUInt64(ModList[i], 0, _T("ModCumulativeUpload") );
		rt_CumulativeDownloadMod[i] = RatioIni.GetUInt64(ModList[i], 0, _T("ModCumulativeDownload") );
	}
	// Country
	for (int i = 0; i < RT_COUNTRY_COUNT; i++)
	{
		Buffer.Format( _T("%s"), CountryCodeString.Mid((i * 2), 2) );
		rt_CumulativeUploadCountry[i] = RatioIni.GetUInt64(Buffer, 0, _T("CountryCumulativeUpload") );
		rt_CumulativeDownloadCountry[i] = RatioIni.GetUInt64(Buffer, 0, _T("CountryCumulativeDownload") );
	}
// RT, WebCache (Code by JP/yonatan/Superlexx)
	cumDownData_WEBCACHE = RatioIni.GetUInt64( _T("DownData_WEBCACHE"), 0, _T("WebCache") ); // Superlexx - webcache - statistics
	sesDownData_WEBCACHE		= 0; // Superlexx - webcache - statistics
	ses_WEBCACHEREQUESTS		= 0; //jp webcache statistics
	ses_successfull_WCDOWNLOADS	= 0; //jp webcache statistics
	// Add by so8so
	rt_WebCacheUpDataSession = 0;
	rt_WebCacheUpDataCumulative = RatioIni.GetUInt64( _T("WebCacheUpDataCumulative"), 0, _T("WebCache") );
// End--WebCache
	return IsLoaded;
}

// Ratio Statistics
void CPreferences::RT_SaveStatistics(int Backup)
{
	// This function saves all of the new statistics in my addon.  It is also used to
	// save backups for the Reset Stats function, and the Restore Stats function (Which is actually LoadStats)
	// bBackUp = 0: DEFAULT; save to statistics.ini
	// bBackUp = 1: Save to statbkup.ini, which is used to restore after a reset
	// bBackUp = 2: Save to statbkuptmp.ini, which is temporarily created during a restore and then renamed to statbkup.ini
	CString Filename(configdir);
	if (Backup == 0)
		Filename += _T("RT_Statistics.ini");
	else if (Backup == 1)
		Filename += _T("RT_Statbkup.ini");
	else if (Backup == 2)
		Filename += _T("RT_Statbkuptmp.ini");
	else
		return;
	// Backup
	CString BackupFile = Filename + CString( _T(".bak") );
	if ( (Backup == 0) && (PathFileExists(Filename) == TRUE) )
	{
		if (PathFileExists(BackupFile) == TRUE)   _tremove(BackupFile);
		_trename(Filename, BackupFile);
	}
	// Save
	RatioAppendINI RatioINI;
	if (RatioINI.OpenFile(Filename, _T("w")) == true)
	{
		// Flag of Normal Exit
		thePrefs.SetNormalExit( _T("RT_Statistics"), false );
		//
		try
		{
			int i;
			// General
			RatioINI.WriteSection( _T("General") );
			RatioINI.Write( _T("StatisticsVersion"), uint32(RT_STATISTICES_VERSION) );
			// Official Item
			CString Buffer;
			RatioINI.WriteSection( _T("Statistics") );
			// Save Cum Down Data
			RatioINI.Write( _T("TotalDownloadedBytes"), (theStats.sessionReceivedBytes + GetTotalDownloaded()) );

			RatioINI.Write( _T("DownSuccessfulSessions"), cumDownSuccessfulSessions );
			RatioINI.Write( _T("DownFailedSessions"), cumDownFailedSessions );
			RatioINI.Write( _T("DownAvgTime"), ((GetDownC_AvgTime() + GetDownS_AvgTime()) / 2) );
			RatioINI.Write( _T("LostFromCorruption"), (cumLostFromCorruption + sesLostFromCorruption) );
			RatioINI.Write( _T("SavedFromCompression"), (sesSavedFromCompression + cumSavedFromCompression) );
			RatioINI.Write( _T("PartsSavedByICH"), (cumPartsSavedByICH + sesPartsSavedByICH) );
			// Client
			RatioINI.Write( _T("DownData_EDONKEY"), GetCumDownData_EDONKEY() );
			RatioINI.Write( _T("DownData_EDONKEYHYBRID"), GetCumDownData_EDONKEYHYBRID() );
			RatioINI.Write( _T("DownData_EMULE"), GetCumDownData_EMULE() );
			RatioINI.Write( _T("DownData_MLDONKEY"), GetCumDownData_MLDONKEY() );
			RatioINI.Write( _T("DownData_LMULE"), GetCumDownData_EMULECOMPAT() );
			RatioINI.Write( _T("DownData_AMULE"), GetCumDownData_AMULE() );
			RatioINI.Write( _T("DownData_SHAREAZA"), GetCumDownData_SHAREAZA() );
			RatioINI.Write( _T("DownData_URL"), GetCumDownData_URL() );
			RatioINI.Write( _T("DownDataPort_4662"), GetCumDownDataPort_4662() );
			RatioINI.Write( _T("DownDataPort_OTHER"), GetCumDownDataPort_OTHER() );
			// Overhead
			RatioINI.Write( _T("DownOverheadTotal"), (theStats.GetDownDataOverheadFileRequest() +
													theStats.GetDownDataOverheadSourceExchange() +
													theStats.GetDownDataOverheadServer() +
													theStats.GetDownDataOverheadKad() +
													theStats.GetDownDataOverheadOther() +
													GetDownOverheadTotal())  );
			RatioINI.Write( _T("DownOverheadFileReq"), theStats.GetDownDataOverheadFileRequest() + GetDownOverheadFileReq() );
			RatioINI.Write( _T("DownOverheadSrcEx"), theStats.GetDownDataOverheadSourceExchange() + GetDownOverheadSrcEx() );
			RatioINI.Write( _T("DownOverheadServer"), theStats.GetDownDataOverheadServer() + GetDownOverheadServer() );
			RatioINI.Write( _T("DownOverheadKad"), theStats.GetDownDataOverheadKad() + GetDownOverheadKad() );
			RatioINI.Write( _T("DownOverheadTotalPackets"), (theStats.GetDownDataOverheadFileRequestPackets() + 
															theStats.GetDownDataOverheadSourceExchangePackets() + 
															theStats.GetDownDataOverheadServerPackets() + 
															theStats.GetDownDataOverheadKadPackets() + 
															theStats.GetDownDataOverheadOtherPackets() + 
															GetDownOverheadTotalPackets()) );
			RatioINI.Write( _T("DownOverheadFileReqPackets"), theStats.GetDownDataOverheadFileRequestPackets() + GetDownOverheadFileReqPackets() );
			RatioINI.Write( _T("DownOverheadSrcExPackets"), theStats.GetDownDataOverheadSourceExchangePackets() + GetDownOverheadSrcExPackets() );
			RatioINI.Write( _T("DownOverheadServerPackets"), theStats.GetDownDataOverheadServerPackets() + GetDownOverheadServerPackets() );
			RatioINI.Write( _T("DownOverheadKadPackets"), theStats.GetDownDataOverheadKadPackets() + GetDownOverheadKadPackets() );
			// Save Cumulative Upline Statistics
			RatioINI.Write( _T("TotalUploadedBytes"), theStats.sessionSentBytes + GetTotalUploaded() );
			RatioINI.Write( _T("UpSuccessfulSessions"), theApp.uploadqueue->GetSuccessfullUpCount() + GetUpSuccessfulSessions() );
			RatioINI.Write( _T("UpFailedSessions"), theApp.uploadqueue->GetFailedUpCount() + GetUpFailedSessions() );
			RatioINI.Write( _T("UpAvgTime"), ((theApp.uploadqueue->GetAverageUpTime() + GetUpAvgTime()) / 2) );
			// Client
			RatioINI.Write( _T("UpData_EDONKEY"), GetCumUpData_EDONKEY() );
			RatioINI.Write( _T("UpData_EDONKEYHYBRID"), GetCumUpData_EDONKEYHYBRID() );
			RatioINI.Write( _T("UpData_EMULE"), GetCumUpData_EMULE() );
			RatioINI.Write( _T("UpData_MLDONKEY"), GetCumUpData_MLDONKEY() );
			RatioINI.Write( _T("UpData_LMULE"), GetCumUpData_EMULECOMPAT() );
			RatioINI.Write( _T("UpData_AMULE"), GetCumUpData_AMULE() );
			RatioINI.Write( _T("UpData_SHAREAZA"), GetCumUpData_SHAREAZA() );
			RatioINI.Write( _T("UpDataPort_4662"), GetCumUpDataPort_4662() );
			RatioINI.Write( _T("UpDataPort_OTHER"), GetCumUpDataPort_OTHER() );
			RatioINI.Write( _T("UpData_File"), GetCumUpData_File() );
			RatioINI.Write( _T("UpData_Partfile"), GetCumUpData_Partfile() );
			// Overhead
			RatioINI.Write( _T("UpOverheadTotal"), (theStats.GetUpDataOverheadFileRequest() + 
													theStats.GetUpDataOverheadSourceExchange() + 
													theStats.GetUpDataOverheadServer() + 
													theStats.GetUpDataOverheadKad() + 
													theStats.GetUpDataOverheadOther() + 
													GetUpOverheadTotal()) );
			RatioINI.Write( _T("UpOverheadFileReq"), theStats.GetUpDataOverheadFileRequest() + GetUpOverheadFileReq() );
			RatioINI.Write( _T("UpOverheadSrcEx"), theStats.GetUpDataOverheadSourceExchange() + GetUpOverheadSrcEx() );
			RatioINI.Write( _T("UpOverheadServer"), theStats.GetUpDataOverheadServer() + GetUpOverheadServer() );
			RatioINI.Write( _T("UpOverheadKad"), theStats.GetUpDataOverheadKad() + GetUpOverheadKad() );
			RatioINI.Write( _T("UpOverheadTotalPackets"), (theStats.GetUpDataOverheadFileRequestPackets() + 
														theStats.GetUpDataOverheadSourceExchangePackets() + 
														theStats.GetUpDataOverheadServerPackets() + 
														theStats.GetUpDataOverheadKadPackets() + 
														theStats.GetUpDataOverheadOtherPackets() + 
														GetUpOverheadTotalPackets()) );
			RatioINI.Write( _T("UpOverheadFileReqPackets"), theStats.GetUpDataOverheadFileRequestPackets() + GetUpOverheadFileReqPackets() );
			RatioINI.Write( _T("UpOverheadSrcExPackets"), theStats.GetUpDataOverheadSourceExchangePackets() + GetUpOverheadSrcExPackets() );
			RatioINI.Write( _T("UpOverheadServerPackets"), theStats.GetUpDataOverheadServerPackets() + GetUpOverheadServerPackets() );
			RatioINI.Write( _T("UpOverheadKadPackets"), theStats.GetUpDataOverheadKadPackets() + GetUpOverheadKadPackets() );
			// Save Cumulative Connection Statistics
			float tempRate = 0.0F;

			// Download Rate Average
			tempRate = theStats.GetAvgDownloadRate(AVG_TOTAL);
			RatioINI.Write( _T("ConnAvgDownRate"), tempRate );

			// Max Download Rate Average
			if ( tempRate > GetConnMaxAvgDownRate() )   SetConnMaxAvgDownRate(tempRate);
			RatioINI.Write( _T("ConnMaxAvgDownRate"), GetConnMaxAvgDownRate() );

			// Max Download Rate
			tempRate = float(theApp.downloadqueue->GetDatarate()) / 1024;
			if ( tempRate > GetConnMaxDownRate() )   SetConnMaxDownRate(tempRate);
			RatioINI.Write( _T("ConnMaxDownRate"), GetConnMaxDownRate() );

			// Upload Rate Average
			tempRate = theStats.GetAvgUploadRate(AVG_TOTAL);
			RatioINI.Write( _T("ConnAvgUpRate"), tempRate );

			// Max Upload Rate Average
			if ( tempRate > GetConnMaxAvgUpRate() )   SetConnMaxAvgUpRate(tempRate);
			RatioINI.Write( _T("ConnMaxAvgUpRate"), GetConnMaxAvgUpRate() );

			// Max Upload Rate
			tempRate = float(theApp.uploadqueue->GetDatarate()) / 1024;
			if ( tempRate > GetConnMaxUpRate() )   SetConnMaxUpRate(tempRate);
			RatioINI.Write( _T("ConnMaxUpRate"), GetConnMaxUpRate() );
	
			// Overall Run Time
			RatioINI.Write( _T("ConnRunTime"), (GetTickCount() - theStats.starttime)/1000 + GetConnRunTime() );
	
			// Number of Reconnects
			RatioINI.Write( _T("ConnNumReconnects"), (theStats.reconnects>0) ? (theStats.reconnects - 1 + GetConnNumReconnects()) : GetConnNumReconnects() );
	
			// Average Connections
			if (theApp.serverconnect->IsConnected())
				RatioINI.Write( _T("ConnAvgConnections"), (theApp.listensocket->GetAverageConnections() + cumConnAvgConnections)/2 );
			else
				RatioINI.Write( _T("ConnAvgConnections"), cumConnAvgConnections );
	
			// Peak Connections
			if (theApp.listensocket->GetPeakConnections() > cumConnPeakConnections)
				cumConnPeakConnections = theApp.listensocket->GetPeakConnections();
			RatioINI.Write( _T("ConnPeakConnections"), cumConnPeakConnections );
	
			// Max Connection Limit Reached
			if (theApp.listensocket->GetMaxConnectionReached() + cumConnMaxConnLimitReached > cumConnMaxConnLimitReached)
				RatioINI.Write( _T("ConnMaxConnLimitReached"), theApp.listensocket->GetMaxConnectionReached() + cumConnMaxConnLimitReached );
			else
				RatioINI.Write( _T("ConnMaxConnLimitReached"), cumConnMaxConnLimitReached );
	
			// Time Stuff...
			RatioINI.Write( _T("ConnTransferTime"), GetConnTransferTime() + theStats.GetTransferTime() );
			RatioINI.Write( _T("ConnUploadTime"), GetConnUploadTime() + theStats.GetUploadTime() );
			RatioINI.Write( _T("ConnDownloadTime"), GetConnDownloadTime() + theStats.GetDownloadTime() );
			RatioINI.Write( _T("ConnServerDuration"), GetConnServerDuration() + theStats.GetServerDuration() );
	
			// Compare and Save Server Records
			uint32 servtotal, servfail, servuser, servfile, servlowiduser, servtuser, servtfile;
			float servocc;
			theApp.serverlist->GetStatus(servtotal, servfail, servuser, servfile, servlowiduser, servtuser, servtfile, servocc);
	
			if (servtotal - servfail > cumSrvrsMostWorkingServers)
				cumSrvrsMostWorkingServers = servtotal - servfail;
			RatioINI.Write( _T("SrvrsMostWorkingServers"), cumSrvrsMostWorkingServers );

			if (servtuser > cumSrvrsMostUsersOnline)
				cumSrvrsMostUsersOnline = servtuser;
			RatioINI.Write( _T("SrvrsMostUsersOnline"), cumSrvrsMostUsersOnline );

			if (servtfile > cumSrvrsMostFilesAvail)
				cumSrvrsMostFilesAvail = servtfile;
			RatioINI.Write( _T("SrvrsMostFilesAvail"), cumSrvrsMostFilesAvail );

			// Compare and Save Shared File Records
			if (theApp.sharedfiles->GetCount() > cumSharedMostFilesShared)
				cumSharedMostFilesShared = theApp.sharedfiles->GetCount();
			RatioINI.Write( _T("SharedMostFilesShared"), cumSharedMostFilesShared );

			uint64 bytesLargestFile = 0;
			uint64 allsize = theApp.sharedfiles->GetDatasize(bytesLargestFile);
			if (allsize > cumSharedLargestShareSize)   cumSharedLargestShareSize = allsize;
			RatioINI.Write( _T("SharedLargestShareSize"), cumSharedLargestShareSize );
			if (bytesLargestFile > cumSharedLargestFileSize)   cumSharedLargestFileSize = bytesLargestFile;
			RatioINI.Write( _T("SharedLargestFileSize"), cumSharedLargestFileSize );

			if (theApp.sharedfiles->GetCount() != 0)
			{
				uint64 tempint = allsize/theApp.sharedfiles->GetCount();
				if (tempint > cumSharedLargestAvgFileSize)   cumSharedLargestAvgFileSize = tempint;
			}

			RatioINI.Write( _T("SharedLargestAvgFileSize"), cumSharedLargestAvgFileSize );
			RatioINI.Write( _T("statsDateTimeLastReset"), stat_datetimeLastReset );
			//
			RatioINI.Write( _T("DownCompletedFiles"), GetDownCompletedFiles() );
			RatioINI.Write( _T("DownSessionCompletedFiles"), GetDownSessionCompletedFiles() );
			//
			// Mod Upload
			RatioINI.WriteSection( _T("ModCumulativeUpload") );
			for (i = 0; i < RT_MOD_COUNT; i++)
			{
				RatioINI.Write( ModList[i], rt_CumulativeUploadMod[i] );
			}
			// Mod Download
			RatioINI.WriteSection( _T("ModCumulativeDownload") );
			for (i = 0; i < RT_MOD_COUNT; i++)
			{
				RatioINI.Write( ModList[i], rt_CumulativeDownloadMod[i] );
			}
			// Country Upload
			RatioINI.WriteSection( _T("CountryCumulativeUpload") );
			for (i = 0; i < RT_COUNTRY_COUNT; i++)
			{
				RatioINI.Write( CountryCodeString.Mid((i * 2), 2), rt_CumulativeUploadCountry[i] );
			}
			// Country Download
			RatioINI.WriteSection( _T("CountryCumulativeDownload") );
			for (i = 0; i < RT_COUNTRY_COUNT; i++)
			{
				RatioINI.Write( CountryCodeString.Mid((i * 2), 2), rt_CumulativeDownloadCountry[i] );
			}
// RT, WebCache (Code by JP/yonatan/Superlexx)
			RatioINI.WriteSection( _T("WebCache") );
			RatioINI.Write( _T("DownData_WEBCACHE"), GetCumDownData_WEBCACHE() ); // Superlexx - webcache - statistics
			// Add by so8so
			RatioINI.Write( _T("WebCacheUpDataCumulative"), GetWebCacheUpDataCumulative() );
// End--Cache
			//
			RatioINI.CloseFile();
		}
		catch (CFileException* error)
		{
			/*
			CString strError(GetResString(IDS_ERR_FAILED_CREDITSAVE));
			TCHAR szError[MAX_CFEXP_ERRORMSG];
			if (error->GetErrorMessage(szError, ARRSIZE(szError)) == TRUE)
			{
				strError += _T(" - ");
				strError += szError;
			}
			AddLogLine(true, _T("%s"), strError);
			*/
			error->Delete();
			//
			if (Backup == 0)
			{
				// Delete File
				if (PathFileExists(Filename) == TRUE)   _tremove(Filename);
				// Restore File
				if (PathFileExists(BackupFile) == TRUE)   _trename(BackupFile, Filename);
			}
		}
		// Flag of Normal Exit
		thePrefs.SetNormalExit( _T("RT_Statistics"), true );
	}
}

// Status Expand
bool CPreferences::IsStatusExpand(uint8 Pane)
{
	uint8 CurrentPane = 1 << Pane;
	return (rt_StatusExpand & CurrentPane);
}

// Status Expand
void CPreferences::SetStatusExpand(uint8 Pane, bool IsExpand)
{
	uint8 CurrentPane = 1 << Pane;
	if (IsExpand == true)
		rt_StatusExpand |= CurrentPane;
	else
	{
		CurrentPane ^= 0xFFFF;
		rt_StatusExpand &= CurrentPane;
	}
	CString RatioIniFileName;
	RatioIniFileName.Format( _T("%sRT_Preferences.ini"), configdir);
	CIni RatioIni(RatioIniFileName, _T("General") );
	// General
	RatioIni.WriteInt( _T("StatusExpand"), rt_StatusExpand, _T("General") );
}

// Category Temporary Directory
CString CPreferences::GetTempDir(int Category)
{
	if ( (Category < 0) || (Category >= rt_CategoryTempDir.GetCount()) )   return GetTempDir();
	CString Buffer;
	Buffer = rt_CategoryTempDir.GetAt(Category);
	if (Buffer.IsEmpty() == true)
		return GetTempDir();
	else
		return Buffer;
}

// Category Temporary Directory
void CPreferences::SetTempDir(int Category, CString Directory)
{
	if ( (Category < 0) || (Category >= rt_CategoryTempDir.GetCount()) )   return;
	rt_CategoryTempDir.SetAt(Category, Directory);
}

// Ratio Category
void CPreferences::RT_LoadCategory()
{
	CString Filename, Category, Buffer, TempDir;

	Filename.Format( _T("%sRT_Category.ini"), configdir);
	TempDir.Format( _T("%s"), GetTempDir() );

	if (PathFileExists(Filename) == FALSE)   return;

	bool IsNeedSave = false;
	bool IsNewTempDir = false;
	CIni RatioIni(Filename, _T("General") );
	CString OldDefaultTempDir;
	int CategoryCount = GetCatCount() - 1;
	for (int i = 0; i <= CategoryCount; i++)
	{
		Category.Format( _T("Cat#%u"), i);
		Buffer.Format( _T("%s"), RatioIni.GetString( _T("TempDir"), _T(""), Category) );
		// Check Default Temporary Directory
		if ( (i == 0) && (CompareLocaleStringNoCase(Buffer, tempdir) != 0) )
		{
			if (AfxMessageBox(GetResString(RT_IDS_TEMP_DIR_MODIFY), MB_ICONQUESTION | MB_YESNO) == IDYES)
			{
				IsNewTempDir = true;
				OldDefaultTempDir = Buffer;
			}
		}
		// Uncategorized Temporary Directory
		if ( ((IsNewTempDir == true) && (CompareLocaleStringNoCase(Buffer, OldDefaultTempDir) != 0)) ||
			(catMap.GetAt(i)->title != RatioIni.GetString( _T("Title"), _T(""), Category)) ||
			(PathFileExists(Buffer) == FALSE) )
		{
			IsNeedSave = true;
			Buffer = TempDir;
		}
		char DiskName = Buffer.GetAt(0);
		if ( (DiskName >= 'a') && (DiskName <= 'z') )
		{
			DiskName = (DiskName - ('a'-'A'));
			Buffer.SetAt( 0, TCHAR(DiskName) );
		}
		rt_CategoryTempDir.SetAt(i, Buffer);
		rt_CategoryViewFilter.SetAt( i, RatioIni.GetInt( _T("VewFilter"), 0, Category) );
	}
	if (IsNeedSave == true)   RT_SaveCategory();
}

// New Code for SavePreferences()
void CPreferences::SavePreferences()
{
	USES_CONVERSION;
	CString Filename, Buffer;
	Filename.Format( _T("%spreferences.ini"), configdir );
	CIni RatioIni(Filename);
	// Recorde
	uint64 SystemACP = RatioIni.GetUInt64( _T("SetSystemACP"), 0, _T("eMule") );
	uint64 LanguageACP = RatioIni.GetUInt64( _T("SetLanguageACP"), 0, _T("eMule") );
	CArray <CString, CString&> KeepData;
	KeepData.Add( RatioIni.GetString(_T("ONContactListCtrlColumnWidths"), _T(""), _T("eMule")) );
	KeepData.Add( RatioIni.GetString(_T("ONContactListCtrlColumnHidden"), _T(""), _T("eMule")) );
	KeepData.Add( RatioIni.GetString(_T("ONContactListCtrlColumnOrders"), _T(""), _T("eMule")) );
	KeepData.Add( RatioIni.GetString(_T("ONContactListCtrlSortItem"), _T(""), _T("eMule")) );
	KeepData.Add( RatioIni.GetString(_T("ONContactListCtrlSortAscending"), _T(""), _T("eMule")) );
	KeepData.Add( RatioIni.GetString(_T("KadSearchListCtrlColumnWidths"), _T(""), _T("eMule")) );
	KeepData.Add( RatioIni.GetString(_T("KadSearchListCtrlColumnHidden"), _T(""), _T("eMule")) );
	KeepData.Add( RatioIni.GetString(_T("KadSearchListCtrlColumnOrders"), _T(""), _T("eMule")) );
	KeepData.Add( RatioIni.GetString(_T("KadSearchListCtrlSortItem"), _T(""), _T("eMule")) );
	KeepData.Add( RatioIni.GetString(_T("KadSearchListCtrlSortAscending"), _T(""), _T("eMule")) );
	//
	RatioAppendINI RatioINI;
	if (RatioINI.OpenFile(Filename, _T("w")) == false)   return;
	//---
	RatioINI.WriteSection( _T("eMule") );
	RatioINI.Write( _T("AppVersion"), CString(theApp.m_strCurVersionLong + _T("_RT")) );
	//---

#ifdef _DEBUG
	RatioINI.Write( _T("DebugHeap"), m_iDbgHeap );
#endif

	RatioINI.Write( _T("Nick"), strNick );
	RatioINI.Write( _T("IncomingDir"), CString(incomingdir) );
	RatioINI.Write( _T("TempDir"), CString(tempdir) );

	// ZZ:UploadSpeedSense -->
    RatioINI.Write( _T("MinUpload"), minupload );
	// ZZ:UploadSpeedSense <--
	RatioINI.Write( _T("MaxUpload"), maxupload );
	RatioINI.Write( _T("MaxDownload"), maxdownload );
	RatioINI.Write( _T("MaxConnections"), maxconnections );
	RatioINI.Write( _T("MaxHalfConnections"), maxhalfconnections);
	if (IsSessionRandomTCPPort() == true)
		RatioINI.Write( _T("Port"), rt_RealTCPPort );
	else
		RatioINI.Write( _T("Port"), port );
	if (IsSessionRandomUDPPort() == true)
		RatioINI.Write( _T("UDPPort"), rt_RealUDPPort );
	else
		RatioINI.Write( _T("UDPPort"), udpport );
	RatioINI.Write( _T("ServerUDPPort"), nServerUDPPort );
	RatioINI.Write( _T("MaxSourcesPerFile"), maxsourceperfile );
	RatioINI.Write( _T("Language"), m_wLanguageID );
	RatioINI.Write( _T("SeeShare"), uint32(m_iSeeShares) );
	RatioINI.Write( _T("ToolTipDelay"), m_iToolDelayTime );
	RatioINI.Write( _T("StatGraphsInterval"), trafficOMeterInterval );
	RatioINI.Write( _T("StatsInterval"), statsInterval );
	RatioINI.Write( _T("DownloadCapacity"), maxGraphDownloadRate );
	RatioINI.Write( _T("UploadCapacity"), maxGraphUploadRate );
	RatioINI.Write( _T("DeadServerRetry"), deadserverretries );
	RatioINI.Write( _T("ServerKeepAliveTimeout"), m_dwServerKeepAliveTimeout );
	RatioINI.Write( _T("SplitterbarPosition"), splitterbarPosition+2 );
	RatioINI.Write( _T("SplitterbarPositionStat"), splitterbarPositionStat+1 );
	RatioINI.Write( _T("SplitterbarPositionStat_HL"), splitterbarPositionStat_HL+1 );
	RatioINI.Write( _T("SplitterbarPositionStat_HR"), splitterbarPositionStat_HR+1 );
	RatioINI.Write( _T("SplitterbarPositionFriend"), splitterbarPositionFriend );
	RatioINI.Write( _T("SplitterbarPositionIRC"), splitterbarPositionIRC+2 );
	RatioINI.Write( _T("TransferWnd2"), m_uTransferWnd2 );
	RatioINI.Write( _T("VariousStatisticsMaxValue"), statsMax );
	RatioINI.Write( _T("StatsAverageMinutes"), statsAverageMinutes );
	RatioINI.Write( _T("MaxConnectionsPerFiveSeconds"), MaxConperFive );
	RatioINI.Write( _T("Check4NewVersionDelay"), versioncheckdays );

	RatioINI.Write( _T("Reconnect"), reconnect );
	RatioINI.Write( _T("Scoresystem"), scorsystem );
	RatioINI.Write( _T("Serverlist"), autoserverlist );
	RatioINI.Write( _T("UpdateNotifyTestClient"), updatenotify );
	RatioINI.Write( _T("MinToTray"), mintotray );
	RatioINI.Write( _T("AddServersFromServer"), addserversfromserver );
	RatioINI.Write( _T("AddServersFromClient"), addserversfromclient );
	RatioINI.Write( _T("Splashscreen"), splashscreen );
	RatioINI.Write( _T("BringToFront"), bringtoforeground );
	RatioINI.Write( _T("TransferDoubleClick"), transferDoubleclick );
	RatioINI.Write( _T("BeepOnError"), beepOnError );
	RatioINI.Write( _T("ConfirmExit"), confirmExit );
	RatioINI.Write( _T("FilterBadIPs"), filterLANIPs );
    RatioINI.Write( _T("Autoconnect"), autoconnect );
	RatioINI.Write( _T("OnlineSignature"), onlineSig );
	RatioINI.Write( _T("StartupMinimized"), startMinimized );
	RatioINI.Write( _T("AutoStart"), m_bAutoStart );
	RatioINI.Write( _T("LastMainWndDlgID"), m_iLastMainWndDlgID );
	RatioINI.Write( _T("LastLogPaneID"), m_iLastLogPaneID );
	RatioINI.Write( _T("SafeServerConnect"), safeServerConnect );
	RatioINI.Write( _T("ShowRatesOnTitle"), showRatesInTitle );
	RatioINI.Write( _T("IndicateRatings"), indicateratings );
	RatioINI.Write( _T("WatchClipboard4ED2kFilelinks"), watchclipboard );
	RatioINI.Write( _T("SearchMethod"), m_iSearchMethod );
	RatioINI.Write( _T("CheckDiskspace"), checkDiskspace );	// SLUGFILLER: checkDiskspace
	RatioINI.Write( _T("MinFreeDiskSpace"), m_uMinFreeDiskSpace );
	RatioINI.Write( _T("SparsePartFiles"), m_bSparsePartFiles );
	// itsonlyme: hostnameSource
	RatioINI.Write( _T("YourHostname"), m_strYourHostname );
	// itsonlyme: hostnameSource

	// Barry - New properties...
    RatioINI.Write( _T("AutoConnectStaticOnly"), autoconnectstaticonly );  
	RatioINI.Write( _T("AutoTakeED2KLinks"), autotakeed2klinks );  
    RatioINI.Write( _T("AddNewFilesPaused"), addnewfilespaused );  
    RatioINI.Write( _T("3DDepth"), depth3D );  

	RatioINI.Write( _T("NotifyOnDownload"), useDownloadNotifier ); // Added by enkeyDEV
	RatioINI.Write( _T("NotifyOnNewDownload"), useNewDownloadNotifier );
	RatioINI.Write( _T("NotifyOnChat"), useChatNotifier );		  
	RatioINI.Write( _T("NotifyOnLog"), useLogNotifier );
	RatioINI.Write( _T("NotifierUseSound"), useSoundInNotifier );
	RatioINI.Write( _T("NotifierPopEveryChatMessage"), notifierPopsEveryChatMsg );
	RatioINI.Write( _T("NotifierPopNewVersion"), notifierNewVersion );
	RatioINI.Write( _T("NotifyOnImportantError"), notifierImportantError );
	RatioINI.Write( _T("NotifierSoundPath"), CString(notifierSoundFilePath) );
	RatioINI.Write( _T("NotifierConfiguration"), CString(notifierConfiguration) );

	RatioINI.Write( _T("TxtEditor"), CString(TxtEditor) );
	RatioINI.Write( _T("VideoPlayer"), CString(VideoPlayer) );
	RatioINI.Write( _T("MessageFilter"), CString(messageFilter) );
	RatioINI.Write( _T("CommentFilter"), CString(commentFilter) );
	RatioINI.Write( _T("DateTimeFormat"), GetDateTimeFormat() );
	RatioINI.Write( _T("DateTimeFormat4Log"), GetDateTimeFormat4Log() );
	RatioINI.Write( _T("WebTemplateFile"), CString(m_sTemplateFile) );
	RatioINI.Write( _T("FilenameCleanups"), CString(filenameCleanups) );
	RatioINI.Write( _T("ExtractMetaData"), m_iExtractMetaData );

	RatioINI.Write( _T("DefaultIRCServerNew"), CString(m_sircserver) );
	RatioINI.Write( _T("IRCNick"), CString(m_sircnick) );
	RatioINI.Write( _T("IRCAddTimestamp"), m_bircaddtimestamp );
	RatioINI.Write( _T("IRCFilterName"), CString(m_sircchannamefilter) );
	RatioINI.Write( _T("IRCFilterUser"), m_iircchanneluserfilter );
	RatioINI.Write( _T("IRCUseFilter"), m_bircusechanfilter );
	RatioINI.Write( _T("IRCPerformString"), CString(m_sircperformstring) );
	RatioINI.Write( _T("IRCUsePerform"), m_bircuseperform );
	RatioINI.Write( _T("IRCListOnConnect"), m_birclistonconnect );
	RatioINI.Write( _T("IRCAcceptLink"), m_bircacceptlinks );
	RatioINI.Write( _T("IRCAcceptLinkFriends"), m_bircacceptlinksfriends );
	RatioINI.Write( _T("IRCSoundEvents"), m_bircsoundevents );
	RatioINI.Write( _T("IRCIgnoreMiscMessages"), m_bircignoremiscmessage );
	RatioINI.Write( _T("IRCIgnoreJoinMessages"), m_bircignorejoinmessage );
	RatioINI.Write( _T("IRCIgnorePartMessages"), m_bircignorepartmessage );
	RatioINI.Write( _T("IRCIgnoreQuitMessages"), m_bircignorequitmessage );
	RatioINI.Write( _T("IRCIgnoreEmuleProtoAddFriend"), m_bircignoreemuleprotoaddfriend );
	RatioINI.Write( _T("IRCAllowEmuleProtoAddFriend"), m_bircallowemuleprotoaddfriend );
	RatioINI.Write( _T("IRCIgnoreEmuleProtoSendLink"), m_bircignoreemuleprotosendlink );
	RatioINI.Write( _T("IRCHelpChannel"), m_birchelpchannel );
	RatioINI.Write( _T("SmartIdCheck"), smartidcheck );
	RatioINI.Write( _T("Verbose"), m_bVerbose );
	RatioINI.Write( _T("DebugSourceExchange"), m_bDebugSourceExchange );	// do *not* use the according 'Get...' function here!
	RatioINI.Write( _T("LogBannedClients"), m_bLogBannedClients );			// do *not* use the according 'Get...' function here!
	RatioINI.Write( _T("LogRatingDescReceived"), m_bLogRatingDescReceived );// do *not* use the according 'Get...' function here!
	RatioINI.Write( _T("LogSecureIdent"), m_bLogSecureIdent );				// do *not* use the according 'Get...' function here!
	RatioINI.Write( _T("LogFilteredIPs"), m_bLogFilteredIPs );				// do *not* use the according 'Get...' function here!
	RatioINI.Write( _T("LogFileSaving"), m_bLogFileSaving );				// do *not* use the according 'Get...' function here!
    RatioINI.Write( _T("LogA4AF"), m_bLogA4AF );                           // do *not* use the according 'Get...' function here!
	RatioINI.Write( _T("LogUlDlEvents"), m_bLogUlDlEvents );
#if defined(_DEBUG) || defined(USE_DEBUG_DEVICE)
	// following options are for debugging or when using an external debug device viewer only.
	RatioINI.Write( _T("DebugServerTCP"), m_iDebugServerTCPLevel );
	RatioINI.Write( _T("DebugServerUDP"), m_iDebugServerUDPLevel );
	RatioINI.Write( _T("DebugServerSources"), m_iDebugServerSourcesLevel );
	RatioINI.Write( _T("DebugServerSearches"), m_iDebugServerSearchesLevel );
	RatioINI.Write( _T("DebugClientTCP"), m_iDebugClientTCPLevel );
	RatioINI.Write( _T("DebugClientUDP"), m_iDebugClientUDPLevel );
	RatioINI.Write( _T("DebugClientKadUDP"), m_iDebugClientKadUDPLevel );
#endif
	RatioINI.Write( _T("PreviewPrio"), m_bpreviewprio );
	RatioINI.Write( _T("UpdateQueueListPref"), m_bupdatequeuelist );
	RatioINI.Write( _T("ManualHighPrio"), m_bmanualhighprio );
	RatioINI.Write( _T("FullChunkTransfers"), m_btransferfullchunks );
	RatioINI.Write( _T("ShowOverhead"), m_bshowoverhead );
	RatioINI.Write( _T("VideoPreviewBackupped"), moviePreviewBackup );
	RatioINI.Write( _T("PreviewSmallBlocks"), m_iPreviewSmallBlocks );
	RatioINI.Write( _T("StartNextFile"), m_istartnextfile );

//	ini.DeleteKey(_T("FileBufferSizePref") ); // delete old 'file buff size' setting
	RatioINI.Write( _T("FileBufferSize"), m_iFileBufferSize );

//	ini.DeleteKey(_T("QueueSizePref") ); // delete old 'queue size' setting
	RatioINI.Write( _T("QueueSize"), m_iQueueSize );

	RatioINI.Write( _T("CommitFiles"), m_iCommitFiles );
	RatioINI.Write( _T("DAPPref"), m_bDAP );
	RatioINI.Write( _T("UAPPref"), m_bUAP );
	RatioINI.Write( _T("FilterServersByIP"), filterserverbyip );
	RatioINI.Write( _T("DisableKnownClientList"), m_bDisableKnownClientList );
	RatioINI.Write( _T("DisableQueueList"), m_bDisableQueueList );
	RatioINI.Write( _T("UseCreditSystem"), m_bCreditSystem );
	RatioINI.Write( _T("SaveLogToDisk"), log2disk );
	RatioINI.Write( _T("SaveDebugToDisk"), debug2disk );
	RatioINI.Write( _T("EnableScheduler"), scheduler );
	RatioINI.Write( _T("MessagesFromFriendsOnly"), msgonlyfriends );
	RatioINI.Write( _T("MessageFromValidSourcesOnly"), msgsecure );
	RatioINI.Write( _T("ShowInfoOnCatTabs"), showCatTabInfos );
	RatioINI.Write( _T("DontRecreateStatGraphsOnResize"), dontRecreateGraphs );
	RatioINI.Write( _T("AutoFilenameCleanup"), autofilenamecleanup );
	RatioINI.Write( _T("ShowExtControls"), m_bExtControls );
	RatioINI.Write( _T("UseAutocompletion"), m_bUseAutocompl );
	RatioINI.Write( _T("NetworkKademlia"), networkkademlia );
	RatioINI.Write( _T("NetworkED2K"), networked2k );
	RatioINI.Write( _T("AutoClearCompleted"), m_bRemoveFinishedDownloads );
	RatioINI.Write( _T("TransflstRemainOrder"), m_bTransflstRemain );

	RatioINI.Write( _T("UseSimpleTimeRemainingcomputation"), m_bUseOldTimeRemaining );
	RatioINI.Write( _T("VersionCheckLastAutomatic"), versioncheckLastAutomatic );
	RatioINI.Write( _T("FilterLevel"), filterlevel );

	RatioINI.Write( _T("SecureIdent"), m_bUseSecureIdent );// change the name in future version to enable it by default
	RatioINI.Write( _T("AdvancedSpamFilter"), m_bAdvancedSpamfilter );
	RatioINI.Write( _T("ShowDwlPercentage"), m_bShowDwlPercentage );
	RatioINI.Write( _T("RemoveFilesToBin"), m_bRemove2bin );

	// Toolbar
	RatioINI.Write( _T("ToolbarSetting"), CString(m_sToolbarSettings) );
	RatioINI.Write( _T("ToolbarBitmap"), CString(m_sToolbarBitmap)  );
	RatioINI.Write( _T("ToolbarBitmapFolder"), CString(m_sToolbarBitmapFolder) );
	RatioINI.Write( _T("ToolbarLabels"), m_nToolbarLabels );
	RatioINI.Write( _T("ToolbarIconSize"), m_sizToolbarIconSize.cx );
	RatioINI.Write( _T("SkinProfile"), m_strSkinProfile );
	RatioINI.Write( _T("SkinProfileDir"), m_strSkinProfileDir );

	//
	RatioINI.WriteSerial( _T("SearchColumnWidths"), searchColumnWidths, ARRSIZE(searchColumnWidths) );
	RatioINI.WriteSerial( _T("SearchColumnHidden"), searchColumnHidden, ARRSIZE(searchColumnHidden) );
	RatioINI.WriteSerial( _T("SearchColumnOrder"), searchColumnOrder, ARRSIZE(searchColumnOrder) );
	RatioINI.WriteSerial( _T("ServerColumnWidths"), serverColumnWidths, ARRSIZE(serverColumnWidths) );
	RatioINI.WriteSerial( _T("ServerColumnHidden"), serverColumnHidden, ARRSIZE(serverColumnHidden) );
	RatioINI.WriteSerial( _T("ServerColumnOrder"), serverColumnOrder, ARRSIZE(serverColumnOrder) );
	RatioINI.WriteSerial( _T("FilenamesListColumnWidths"), FilenamesListColumnWidths, ARRSIZE(FilenamesListColumnWidths) );
	RatioINI.WriteSerial( _T("FilenamesListColumnHidden"), FilenamesListColumnHidden, ARRSIZE(FilenamesListColumnHidden) );
	RatioINI.WriteSerial( _T("FilenamesListColumnOrder"), FilenamesListColumnOrder, ARRSIZE(FilenamesListColumnOrder) );

	// Barry - Provide a mechanism for all tables to store/retrieve sort order
	RatioINI.Write( _T("TableSortItemDownload"), tableSortItemDownload );
	RatioINI.Write( _T("TableSortItemUpload"), tableSortItemUpload );
	RatioINI.Write( _T("TableSortItemQueue"), tableSortItemQueue );
	RatioINI.Write( _T("TableSortItemSearch"), tableSortItemSearch );
	RatioINI.Write( _T("TableSortItemShared"), tableSortItemShared );
	RatioINI.Write( _T("TableSortItemServer"), tableSortItemServer );
	RatioINI.Write( _T("TableSortItemClientList"), tableSortItemClientList );
	RatioINI.Write( _T("TableSortItemFilenames"), tableSortItemFilenames );
	RatioINI.Write( _T("TableSortAscendingDownload"), tableSortAscendingDownload );
	RatioINI.Write( _T("TableSortAscendingUpload"), tableSortAscendingUpload );
	RatioINI.Write( _T("TableSortAscendingQueue"), tableSortAscendingQueue );
	RatioINI.Write( _T("TableSortAscendingSearch"), tableSortAscendingSearch );
	RatioINI.Write( _T("TableSortAscendingShared"), tableSortAscendingShared );
	RatioINI.Write( _T("TableSortAscendingServer"), tableSortAscendingServer );
	RatioINI.Write( _T("TableSortAscendingClientList"), tableSortAscendingClientList );
	RatioINI.Write( _T("TableSortAscendingFilenames"), tableSortAscendingFilenames );
	RatioINI.WriteFont( _T("HyperTextFont"), (LPBYTE)&m_lfHyperText, sizeof(m_lfHyperText) );
	RatioINI.WriteFont( _T("LogTextFont"), (LPBYTE)&m_lfLogText, sizeof(m_lfLogText) );

	// ZZ:UploadSpeedSense -->
    RatioINI.Write( _T("USSEnabled"), m_bDynUpEnabled );
    RatioINI.Write( _T("USSUseMillisecondPingTolerance"), m_bDynUpUseMillisecondPingTolerance );
    RatioINI.Write( _T("USSPingTolerance"), m_iDynUpPingTolerance );
	RatioINI.Write( _T("USSPingToleranceMilliseconds"), m_iDynUpPingToleranceMilliseconds ); // EastShare - Add by TAHO, USS limit
    RatioINI.Write( _T("USSGoingUpDivider"), m_iDynUpGoingUpDivider );
    RatioINI.Write( _T("USSGoingDownDivider"), m_iDynUpGoingDownDivider );
    RatioINI.Write( _T("USSNumberOfPings"), m_iDynUpNumberOfPings );
	// ZZ:UploadSpeedSense <--

    RatioINI.Write( _T("A4AFSaveCpu"), m_bA4AFSaveCpu ); // ZZ:DownloadManager
	RatioINI.Write( _T("WebMirrorAlertLevel"), m_nWebMirrorAlertLevel );
	RatioINI.Write( _T("RunAsUnprivilegedUser"), m_bRunAsUser );
	RatioINI.Write( _T("OpenPortsOnStartUp"), m_bOpenPortsOnStartUp );
	RatioINI.Write( _T("DebugLogLevel"), m_byLogLevel );
	RatioINI.Write( _T("WinXPSP2"), IsRunningXPSP2() );

	// Restore
	RatioINI.Write( _T("SetSystemACP"), SystemACP );
	RatioINI.Write( _T("SetLanguageACP"), LanguageACP );
	RatioINI.Write( _T("ONContactListCtrlColumnWidths"), KeepData.GetAt(0) );
	RatioINI.Write( _T("ONContactListCtrlColumnHidden"), KeepData.GetAt(1) );
	RatioINI.Write( _T("ONContactListCtrlColumnOrders"), KeepData.GetAt(2) );
	RatioINI.Write( _T("ONContactListCtrlSortItem"), KeepData.GetAt(3) );
	RatioINI.Write( _T("ONContactListCtrlSortAscending"), KeepData.GetAt(4) );
	RatioINI.Write( _T("KadSearchListCtrlColumnWidths"), KeepData.GetAt(5) );
	RatioINI.Write( _T("KadSearchListCtrlColumnHidden"), KeepData.GetAt(6) );
	RatioINI.Write( _T("KadSearchListCtrlColumnOrders"), KeepData.GetAt(7) );
	RatioINI.Write( _T("KadSearchListCtrlSortItem"), KeepData.GetAt(8) );
	RatioINI.Write( _T("KadSearchListCtrlSortAscending"), KeepData.GetAt(9) );
	//

	///////////////////////////////////////////////////////////////////////////
	// Section: "Proxy"
	//
	RatioINI.WriteSection( _T("Proxy") );
	RatioINI.Write( _T("ProxyEnablePassword"), proxy.EnablePassword );
	RatioINI.Write( _T("ProxyEnableProxy"), proxy.UseProxy );
	RatioINI.Write( _T("ProxyName"), CString(proxy.name) );
	RatioINI.Write( _T("ProxyPassword"), CString(A2CT(proxy.password)) );
	RatioINI.Write( _T("ProxyUser"), CString(A2CT(proxy.user)) );
	RatioINI.Write( _T("ProxyPort"), proxy.port );
	RatioINI.Write( _T("ProxyType"), proxy.type );
	RatioINI.Write( _T("ConnectWithoutProxy"), m_bIsASCWOP );
	RatioINI.Write( _T("ShowErrors"), m_bShowProxyErrors );


	///////////////////////////////////////////////////////////////////////////
	// Section: "Statistics"
	//
	RatioINI.WriteSection( _T("Statistics") );
	RatioINI.Write( _T("statsConnectionsGraphRatio"), statsConnectionsGraphRatio );
	RatioINI.Write( _T("statsExpandedTreeItems"), CString(statsExpandedTreeItems) );
	for (int i = 0; i < 15 ;i++)
	{
		Buffer.Format( _T("StatColor%i=0x%06x\n"), i, GetStatsColor(i) );
		RatioINI.Write( Buffer );
	}


	///////////////////////////////////////////////////////////////////////////
	// Section: "WebServer"
	//
	RatioINI.WriteSection( _T("WebServer") );
	RatioINI.Write( _T("Password"), GetWSPass() );
	RatioINI.Write( _T("PasswordLow"), GetWSLowPass() );
	RatioINI.Write( _T("Port"), m_nWebPort );
	RatioINI.Write( _T("Enabled"), m_bWebEnabled );
	RatioINI.Write( _T("UseGzip"), m_bWebUseGzip );
	RatioINI.Write( _T("PageRefreshTime"), m_nWebPageRefresh );
	RatioINI.Write( _T("UseLowRightsUser"), m_bWebLowEnabled );


	///////////////////////////////////////////////////////////////////////////
	// Section: "MobileMule"
	//
	RatioINI.WriteSection( _T("MobileMule") );
	RatioINI.Write( _T("Password"), GetMMPass() );
	RatioINI.Write( _T("Enabled"), m_bMMEnabled );
	RatioINI.Write( _T("Port"), m_nMMPort );


	///////////////////////////////////////////////////////////////////////////
	// Section: "PeerCache"
	//
	RatioINI.WriteSection( _T("PeerCache") );
	RatioINI.Write( _T("LastSearch"), m_uPeerCacheLastSearch );
	RatioINI.Write( _T("Found"), m_bPeerCacheWasFound );
	RatioINI.Write( _T("Enabled"), m_bPeerCacheEnabled );
	RatioINI.Write( _T("PCPort"), m_nPeerCachePort );
}

// New Code for SaveCats()
void CPreferences::SaveCats()
{
	//
	RT_SaveCategory();
	// Cats
	CString Filename;
	Filename.Format( _T("%sCategory.ini"), configdir );
	RatioAppendINI RatioINI;
	if (RatioINI.OpenFile(Filename, _T("w")) == true)
	{
		if (GetCatCount() > 1)
		{
			CString Buffer;
			// General
			RatioINI.Write( _T("[General]\n") );
			RatioINI.Write( _T("Count"), (catMap.GetCount() - 1) );
			// Category
			for (int i = 1; i < catMap.GetCount(); i++)
			{
				Buffer.Format( _T("[Cat#%u]\n"), i);
				RatioINI.Write(Buffer);
				RatioINI.Write( _T("Title"), CString(catMap.GetAt(i)->title) );
				RatioINI.Write( _T("Incoming"), CString(catMap.GetAt(i)->incomingpath) );
				RatioINI.Write( _T("Comment"), CString(catMap.GetAt(i)->comment) );
				RatioINI.Write( _T("Color"), catMap.GetAt(i)->color );
				RatioINI.Write( _T("a4afPriority"), catMap.GetAt(i)->prio ); // ZZ:DownloadManager
				RatioINI.Write( _T("AutoCat"), catMap.GetAt(i)->autocat );
				RatioINI.Write( _T("Filter"), catMap.GetAt(i)->filter );
				RatioINI.Write( _T("FilterNegator"), catMap.GetAt(i)->filterNeg );
				RatioINI.Write( _T("downloadInAlphabeticalOrder"), catMap.GetAt(i)->downloadInAlphabeticalOrder ); // ZZ:DownloadManager
				RatioINI.Write( _T("AutoCatAsRegularExpression"), catMap.GetAt(i)->ac_regexpeval );
				RatioINI.Write( _T("Care4All"),catMap.GetAt(i)->care4all );
			}
		}
		RatioINI.CloseFile();
	}
}

// New Code for SaveStats()
void CPreferences::SaveStats(int bBackUp)
{
	RT_SaveStatistics(bBackUp);
	if ( (theApp.emuledlg->IsRunning() == true) || (bBackUp != 0) )   return;
	//
	// This function saves all of the new statistics in my addon.  It is also used to
	// save backups for the Reset Stats function, and the Restore Stats function (Which is actually LoadStats)
	// bBackUp = 0: DEFAULT; save to statistics.ini
	// bBackUp = 1: Save to statbkup.ini, which is used to restore after a reset
	// bBackUp = 2: Save to statbkuptmp.ini, which is temporarily created during a restore and then renamed to statbkup.ini

	CString Filename(configdir);
	if (bBackUp == 1)
		Filename += _T("statbkup.ini");
	else if (bBackUp == 2)
		Filename += _T("statbkuptmp.ini");
	else
		Filename += _T("statistics.ini");
	
	// Save
	RatioAppendINI RatioINI;
	if (RatioINI.OpenFile(Filename, _T("w")) == true)
	{
		CString Buffer;
		// General
		RatioINI.WriteSection( _T("Statistics") );
		// Save Cum Down Data
		RatioINI.Write( _T("TotalDownloadedBytes"), (theStats.sessionReceivedBytes + GetTotalDownloaded()) );

		RatioINI.Write( _T("DownSuccessfulSessions"), cumDownSuccessfulSessions );
		RatioINI.Write( _T("DownFailedSessions"), cumDownFailedSessions );
		RatioINI.Write( _T("DownAvgTime"), ((GetDownC_AvgTime() + GetDownS_AvgTime()) / 2) );
		RatioINI.Write( _T("LostFromCorruption"), (cumLostFromCorruption + sesLostFromCorruption) );
		RatioINI.Write( _T("SavedFromCompression"), (sesSavedFromCompression + cumSavedFromCompression) );
		RatioINI.Write( _T("PartsSavedByICH"), (cumPartsSavedByICH + sesPartsSavedByICH) );
		// Client
		RatioINI.Write( _T("DownData_EDONKEY"), GetCumDownData_EDONKEY() );
		RatioINI.Write( _T("DownData_EDONKEYHYBRID"), GetCumDownData_EDONKEYHYBRID() );
		RatioINI.Write( _T("DownData_EMULE"), GetCumDownData_EMULE() );
		RatioINI.Write( _T("DownData_MLDONKEY"), GetCumDownData_MLDONKEY() );
		RatioINI.Write( _T("DownData_LMULE"), GetCumDownData_EMULECOMPAT() );
		RatioINI.Write( _T("DownData_AMULE"), GetCumDownData_AMULE() );
		RatioINI.Write( _T("DownData_SHAREAZA"), GetCumDownData_SHAREAZA() );
		RatioINI.Write( _T("DownData_URL"), GetCumDownData_URL() );
		RatioINI.Write( _T("DownDataPort_4662"), GetCumDownDataPort_4662() );
		RatioINI.Write( _T("DownDataPort_OTHER"), GetCumDownDataPort_OTHER() );
		RatioINI.Write( _T("DownDataPort_PeerCache"), GetCumDownDataPort_PeerCache() );
		// Overhead
		RatioINI.Write( _T("DownOverheadTotal"), (theStats.GetDownDataOverheadFileRequest() +
													theStats.GetDownDataOverheadSourceExchange() +
													theStats.GetDownDataOverheadServer() +
													theStats.GetDownDataOverheadKad() +
													theStats.GetDownDataOverheadOther() +
													GetDownOverheadTotal())  );
		RatioINI.Write( _T("DownOverheadFileReq"), theStats.GetDownDataOverheadFileRequest() + GetDownOverheadFileReq() );
		RatioINI.Write( _T("DownOverheadSrcEx"), theStats.GetDownDataOverheadSourceExchange() + GetDownOverheadSrcEx() );
		RatioINI.Write( _T("DownOverheadServer"), theStats.GetDownDataOverheadServer() + GetDownOverheadServer() );
		RatioINI.Write( _T("DownOverheadKad"), theStats.GetDownDataOverheadKad() + GetDownOverheadKad() );
		RatioINI.Write( _T("DownOverheadTotalPackets"), (theStats.GetDownDataOverheadFileRequestPackets() + 
														theStats.GetDownDataOverheadSourceExchangePackets() + 
														theStats.GetDownDataOverheadServerPackets() + 
														theStats.GetDownDataOverheadKadPackets() + 
														theStats.GetDownDataOverheadOtherPackets() + 
														GetDownOverheadTotalPackets()) );
		RatioINI.Write( _T("DownOverheadFileReqPackets"), theStats.GetDownDataOverheadFileRequestPackets() + GetDownOverheadFileReqPackets() );
		RatioINI.Write( _T("DownOverheadSrcExPackets"), theStats.GetDownDataOverheadSourceExchangePackets() + GetDownOverheadSrcExPackets() );
		RatioINI.Write( _T("DownOverheadServerPackets"), theStats.GetDownDataOverheadServerPackets() + GetDownOverheadServerPackets() );
		RatioINI.Write( _T("DownOverheadKadPackets"), theStats.GetDownDataOverheadKadPackets() + GetDownOverheadKadPackets() );
		// Save Cumulative Upline Statistics
		RatioINI.Write( _T("TotalUploadedBytes"), theStats.sessionSentBytes + GetTotalUploaded() );
		RatioINI.Write( _T("UpSuccessfulSessions"), theApp.uploadqueue->GetSuccessfullUpCount() + GetUpSuccessfulSessions() );
		RatioINI.Write( _T("UpFailedSessions"), theApp.uploadqueue->GetFailedUpCount() + GetUpFailedSessions() );
		RatioINI.Write( _T("UpAvgTime"), ((theApp.uploadqueue->GetAverageUpTime() + GetUpAvgTime()) / 2) );
		// Client
		RatioINI.Write( _T("UpData_EDONKEY"), GetCumUpData_EDONKEY() );
		RatioINI.Write( _T("UpData_EDONKEYHYBRID"), GetCumUpData_EDONKEYHYBRID() );
		RatioINI.Write( _T("UpData_EMULE"), GetCumUpData_EMULE() );
		RatioINI.Write( _T("UpData_MLDONKEY"), GetCumUpData_MLDONKEY() );
		RatioINI.Write( _T("UpData_LMULE"), GetCumUpData_EMULECOMPAT() );
		RatioINI.Write( _T("UpData_AMULE"), GetCumUpData_AMULE() );
		RatioINI.Write( _T("UpData_SHAREAZA"), GetCumUpData_SHAREAZA() );
		RatioINI.Write( _T("UpDataPort_4662"), GetCumUpDataPort_4662() );
		RatioINI.Write( _T("UpDataPort_OTHER"), GetCumUpDataPort_OTHER() );
		RatioINI.Write( _T("UpDataPort_PeerCache"), GetCumUpDataPort_PeerCache() );
		RatioINI.Write( _T("UpData_File"), GetCumUpData_File() );
		RatioINI.Write( _T("UpData_Partfile"), GetCumUpData_Partfile() );
		// Overhead
		RatioINI.Write( _T("UpOverheadTotal"), (theStats.GetUpDataOverheadFileRequest() + 
												theStats.GetUpDataOverheadSourceExchange() + 
												theStats.GetUpDataOverheadServer() + 
												theStats.GetUpDataOverheadKad() + 
												theStats.GetUpDataOverheadOther() + 
												GetUpOverheadTotal()) );
		RatioINI.Write( _T("UpOverheadFileReq"), theStats.GetUpDataOverheadFileRequest() + GetUpOverheadFileReq() );
		RatioINI.Write( _T("UpOverheadSrcEx"), theStats.GetUpDataOverheadSourceExchange() + GetUpOverheadSrcEx() );
		RatioINI.Write( _T("UpOverheadServer"), theStats.GetUpDataOverheadServer() + GetUpOverheadServer() );
		RatioINI.Write( _T("UpOverheadKad"), theStats.GetUpDataOverheadKad() + GetUpOverheadKad() );
		RatioINI.Write( _T("UpOverheadTotalPackets"), (theStats.GetUpDataOverheadFileRequestPackets() + 
														theStats.GetUpDataOverheadSourceExchangePackets() + 
														theStats.GetUpDataOverheadServerPackets() + 
														theStats.GetUpDataOverheadKadPackets() + 
														theStats.GetUpDataOverheadOtherPackets() + 
														GetUpOverheadTotalPackets()) );
		RatioINI.Write( _T("UpOverheadFileReqPackets"), theStats.GetUpDataOverheadFileRequestPackets() + GetUpOverheadFileReqPackets() );
		RatioINI.Write( _T("UpOverheadSrcExPackets"), theStats.GetUpDataOverheadSourceExchangePackets() + GetUpOverheadSrcExPackets() );
		RatioINI.Write( _T("UpOverheadServerPackets"), theStats.GetUpDataOverheadServerPackets() + GetUpOverheadServerPackets() );
		RatioINI.Write( _T("UpOverheadKadPackets"), theStats.GetUpDataOverheadKadPackets() + GetUpOverheadKadPackets() );
		// Save Cumulative Connection Statistics
		float tempRate = 0.0F;

		// Download Rate Average
		tempRate = theStats.GetAvgDownloadRate(AVG_TOTAL);
		RatioINI.Write( _T("ConnAvgDownRate"), tempRate );

		// Max Download Rate Average
		if ( tempRate > GetConnMaxAvgDownRate() )   SetConnMaxAvgDownRate(tempRate);
		RatioINI.Write( _T("ConnMaxAvgDownRate"), GetConnMaxAvgDownRate() );

		// Max Download Rate
		tempRate = float(theApp.downloadqueue->GetDatarate()) / 1024;
		if ( tempRate > GetConnMaxDownRate() )   SetConnMaxDownRate(tempRate);
		RatioINI.Write( _T("ConnMaxDownRate"), GetConnMaxDownRate() );

		// Upload Rate Average
		tempRate = theStats.GetAvgUploadRate(AVG_TOTAL);
		RatioINI.Write( _T("ConnAvgUpRate"), tempRate );

		// Max Upload Rate Average
		if ( tempRate > GetConnMaxAvgUpRate() )   SetConnMaxAvgUpRate(tempRate);
		RatioINI.Write( _T("ConnMaxAvgUpRate"), GetConnMaxAvgUpRate() );

		// Max Upload Rate
		tempRate = float(theApp.uploadqueue->GetDatarate()) / 1024;
		if ( tempRate > GetConnMaxUpRate() )   SetConnMaxUpRate(tempRate);
		RatioINI.Write( _T("ConnMaxUpRate"), GetConnMaxUpRate() );
	
		// Overall Run Time
		RatioINI.Write( _T("ConnRunTime"), (GetTickCount() - theStats.starttime)/1000 + GetConnRunTime() );
	
		// Number of Reconnects
		RatioINI.Write( _T("ConnNumReconnects"), (theStats.reconnects>0) ? (theStats.reconnects - 1 + GetConnNumReconnects()) : GetConnNumReconnects() );
	
		// Average Connections
		if (theApp.serverconnect->IsConnected())
			RatioINI.Write( _T("ConnAvgConnections"), (theApp.listensocket->GetAverageConnections() + cumConnAvgConnections)/2 );
		else
			RatioINI.Write( _T("ConnAvgConnections"), cumConnAvgConnections );
	
		// Peak Connections
		if (theApp.listensocket->GetPeakConnections() > cumConnPeakConnections)
			cumConnPeakConnections = theApp.listensocket->GetPeakConnections();
		RatioINI.Write( _T("ConnPeakConnections"), cumConnPeakConnections );
	
		// Max Connection Limit Reached
		if (theApp.listensocket->GetMaxConnectionReached() + cumConnMaxConnLimitReached > cumConnMaxConnLimitReached)
			RatioINI.Write( _T("ConnMaxConnLimitReached"), theApp.listensocket->GetMaxConnectionReached() + cumConnMaxConnLimitReached );
		else
			RatioINI.Write( _T("ConnMaxConnLimitReached"), cumConnMaxConnLimitReached );
	
		// Time Stuff...
		RatioINI.Write( _T("ConnTransferTime"), GetConnTransferTime() + theStats.GetTransferTime() );
		RatioINI.Write( _T("ConnUploadTime"), GetConnUploadTime() + theStats.GetUploadTime() );
		RatioINI.Write( _T("ConnDownloadTime"), GetConnDownloadTime() + theStats.GetDownloadTime() );
		RatioINI.Write( _T("ConnServerDuration"), GetConnServerDuration() + theStats.GetServerDuration() );
	
		// Compare and Save Server Records
		uint32 servtotal, servfail, servuser, servfile, servlowiduser, servtuser, servtfile;
		float servocc;
		theApp.serverlist->GetStatus(servtotal, servfail, servuser, servfile, servlowiduser, servtuser, servtfile, servocc);
	
		if (servtotal - servfail > cumSrvrsMostWorkingServers)
			cumSrvrsMostWorkingServers = servtotal - servfail;
		RatioINI.Write( _T("SrvrsMostWorkingServers"), cumSrvrsMostWorkingServers );

		if (servtuser > cumSrvrsMostUsersOnline)
			cumSrvrsMostUsersOnline = servtuser;
		RatioINI.Write( _T("SrvrsMostUsersOnline"), cumSrvrsMostUsersOnline );

		if (servtfile > cumSrvrsMostFilesAvail)
			cumSrvrsMostFilesAvail = servtfile;
		RatioINI.Write( _T("SrvrsMostFilesAvail"), cumSrvrsMostFilesAvail );

		// Compare and Save Shared File Records
		if (theApp.sharedfiles->GetCount() > cumSharedMostFilesShared)
			cumSharedMostFilesShared = theApp.sharedfiles->GetCount();
		RatioINI.Write( _T("SharedMostFilesShared"), cumSharedMostFilesShared );

		uint64 bytesLargestFile = 0;
		uint64 allsize = theApp.sharedfiles->GetDatasize(bytesLargestFile);
		if (allsize > cumSharedLargestShareSize)   cumSharedLargestShareSize = allsize;
		RatioINI.Write( _T("SharedLargestShareSize"), cumSharedLargestShareSize );
		if (bytesLargestFile > cumSharedLargestFileSize)   cumSharedLargestFileSize = bytesLargestFile;
		RatioINI.Write( _T("SharedLargestFileSize"), cumSharedLargestFileSize );

		if (theApp.sharedfiles->GetCount() != 0)
		{
			uint64 tempint = allsize/theApp.sharedfiles->GetCount();
			if (tempint > cumSharedLargestAvgFileSize)   cumSharedLargestAvgFileSize = tempint;
		}

		RatioINI.Write( _T("SharedLargestAvgFileSize"), cumSharedLargestAvgFileSize );
		RatioINI.Write( _T("statsDateTimeLastReset"), stat_datetimeLastReset );
		//
		RatioINI.Write( _T("DownCompletedFiles"), GetDownCompletedFiles() );
		RatioINI.Write( _T("DownSessionCompletedFiles"), GetDownSessionCompletedFiles() );
		//
		RatioINI.CloseFile();
	}
}

// Ratio Category
void CPreferences::RT_SaveCategory()
{
	int CategoryCount = GetCatCount();
	if (CategoryCount < 1)   return;
	CString Filename;
	Filename.Format( _T("%sRT_Category.ini"), configdir);
	RatioAppendINI RatioINI;
	if (RatioINI.OpenFile(Filename, _T("w")) == true)
	{
		CString Buffer;
		// General
		RatioINI.WriteSection( _T("General") );
		RatioINI.Write( _T("Count"), GetCatCount() );
		// Category
		CategoryCount--;
		for (int i = 0; i <= CategoryCount; i++)
		{
			Buffer.Format( _T("[Cat#%u]\n"), i);
			RatioINI.Write( Buffer );
			RatioINI.Write( _T("Title"), CString(catMap.GetAt(i)->title) );
			RatioINI.Write( _T("TempDir"), GetTempDir(i) );
			RatioINI.Write( _T("VewFilter"), rt_CategoryViewFilter.GetAt(i) );
		}
		RatioINI.CloseFile();
	}
}

// Ratio Category
int CPreferences::AddCat(Category_Struct* cat)
{
	catMap.Add(cat);
	rt_CategoryTempDir.Add( CString(GetTempDir()) );
	rt_CategoryViewFilter.Add(0);
	return (catMap.GetCount() - 1);
}

// Category View Filter
int CPreferences::GetCategoryViewFilter(int Category)
{
	if ( (Category < 0) || (Category >= rt_CategoryViewFilter.GetCount()) )   return 0;
	return rt_CategoryViewFilter.GetAt(Category);
}

// Category View Filter
void CPreferences::SetCategoryViewFilter(int Category, int Filter)
{
	if ( (Category < 0) || (Category >= rt_CategoryViewFilter.GetCount()) )   return;
	if (Filter > 0)
	{
		uint16 WhichFilter = (1 << Filter);
		Filter = (uint16(rt_CategoryViewFilter.GetAt(Category)) ^ WhichFilter);
	}
	rt_CategoryViewFilter.SetAt(Category, Filter);
}

// Convert Old Format KnownFile to New Format
void CPreferences::RT_ConvertOldKnownFile()
{
	CString Filename;
	Filename.Format( _T("%sRT_KnownFile.ini"), thePrefs.GetConfigDir() );
	if (PathFileExists(Filename) == FALSE)   return;
	CIni RatioIni( Filename, _T("General") );
	uint16 OldVersion = RatioIni.GetInt( _T("KnownFileVersion"), RT_KNOWN_FILE_VERSION, _T("General") );
	if (OldVersion == RT_KNOWN_FILE_VERSION)   return;
	FILE *SourceFile, *TargetFile;
	SourceFile = _tfopen(Filename, _T("r"));
	if (SourceFile != NULL)
	{
		TargetFile = _tfopen(CString(Filename + _T(".new")), _T("w"));
		if (TargetFile != NULL)
		{
			// Initial
			TCHAR SourceBuffer[1024];
			int SourceBufferLen = 1024;
			CString Buffer;
			_fputts(_T("[General]\n"), TargetFile);
			Buffer.Format(_T("KnownFileVersion=%u\n"), RT_KNOWN_FILE_VERSION);
			_fputts(Buffer, TargetFile);
			_fputts(_T("[FileStatus]\n"), TargetFile);
			if (OldVersion == 1)
			{
				_fgetts(SourceBuffer, SourceBufferLen, SourceFile);
				_fgetts(SourceBuffer, SourceBufferLen, SourceFile);
				_fgetts(SourceBuffer, SourceBufferLen, SourceFile);
				while (feof(SourceFile) == 0)
				{
					SourceBuffer[0] = _T('\0');
					_fgetts(SourceBuffer, SourceBufferLen, SourceFile);
					_fputts(SourceBuffer, TargetFile);
				}
			}
			//
			fclose(TargetFile);
		}
		fclose(SourceFile);
		if (TargetFile != NULL)
		{
			_tremove(Filename);
			_trename( (Filename + _T(".new")), Filename );
		}
	}
}

// Convert Official Credits File to RT Format
void CPreferences::RT_ClientsMet2RT()
{
	CString Filename, NewFilename;
	Filename.Format( _T("%sclients.met"), thePrefs.GetConfigDir() );
	NewFilename.Format( _T("%sRT_Clients.dat"), thePrefs.GetConfigDir() );
	if (PathFileExists(NewFilename) == TRUE)   return;
	if (PathFileExists(Filename) == FALSE)   return;
	// Open File
	CFileException fexp;
	const int OpenFlags = (CFile::modeRead | CFile::osSequentialScan | CFile::typeBinary | CFile::shareDenyWrite);
	CSafeBufferedFile OfficialCreditsFile;
	if (OfficialCreditsFile.Open(Filename, OpenFlags, &fexp) == FALSE)   return;
	setvbuf(OfficialCreditsFile.m_pStream, NULL, _IOFBF, 16384);
	//
	CFile RT_CreditsFile;
	if (RT_CreditsFile.Open(NewFilename, CFile::modeWrite|CFile::modeCreate|CFile::typeBinary|CFile::shareDenyWrite, &fexp) == FALSE)
	{
		OfficialCreditsFile.Close();
		return;
	}
	//
	BYTE* WriteBuffer = NULL;
	try
	{
		// Check Version
		uint8 CreditsVersion = OfficialCreditsFile.ReadUInt8();
		if ( (CreditsVersion != CREDITFILE_VERSION) && (CreditsVersion != CREDITFILE_VERSION_29) )
		{
			OfficialCreditsFile.Close();
			RT_CreditsFile.Close();
			_tremove(NewFilename);
			return;
		}
		// Initial
		const uint32 CreditsCount = OfficialCreditsFile.ReadUInt32();
		const uint32 CreditsExpired = time(NULL) - 12960000;	// today - 150 day
		WriteBuffer = new BYTE[ (CreditsCount * sizeof(CreditStruct)) ];
		uint32 BufferPos = 0;
		uint32 ValidCreditsCount = 0;
		CreditStruct_Official* OfficialCredit = new CreditStruct_Official;
		CreditStruct* RT_Credit = new CreditStruct;
		// Convert
		for (uint32 i = 0; i < CreditsCount; i++)
		{
			// Load
			if (CreditsVersion == CREDITFILE_VERSION_29)
				OfficialCreditsFile.Read( OfficialCredit, sizeof(CreditStruct_29a) );
			else
				OfficialCreditsFile.Read( OfficialCredit, sizeof(CreditStruct_Official) );
			if (OfficialCredit->nLastSeen < CreditsExpired)   continue;
			// Reset Leecher Count and Don't Donwload
			RT_Credit->Feature = 0;
			// Write to Buffer
			if ( (OfficialCredit->nDownloadedLo > 1048576) || (OfficialCredit->nUploadedLo > 1048576) ||
				(OfficialCredit->nDownloadedHi > 0) || (OfficialCredit->nUploadedHi > 0) )
			{
				// Copy to RT Struct
				RT_Credit->UploadedTotal = ( (uint64(OfficialCredit->nUploadedHi) << 32) + OfficialCredit->nUploadedLo );
				RT_Credit->DownloadedTotal = ( (uint64(OfficialCredit->nDownloadedHi) << 32) + OfficialCredit->nDownloadedLo );
				RT_Credit->UploadQueueWaitedTime = 0;
				RT_Credit->nLastSeen = OfficialCredit->nLastSeen;
				RT_Credit->nKeySize = OfficialCredit->nKeySize;
				memcpy( RT_Credit->abyKey, OfficialCredit->abyKey, sizeof(OfficialCredit->abyKey) );
				memcpy( RT_Credit->abySecureIdent, OfficialCredit->abySecureIdent, sizeof(OfficialCredit->abySecureIdent) );
				// Write to Buffer
				memcpy( (WriteBuffer + BufferPos), RT_Credit, sizeof(CreditStruct) );
				ValidCreditsCount++;
				BufferPos += sizeof(CreditStruct);
			}
		}
		delete OfficialCredit;
		delete RT_Credit;
		// Save to File
		CreditsVersion = RT_CREDIT_FILE_VERSION;
		RT_CreditsFile.Write(&CreditsVersion, 1);
		RT_CreditsFile.Write(&ValidCreditsCount, 4);
		RT_CreditsFile.Write( WriteBuffer, (ValidCreditsCount * sizeof(CreditStruct)) );
		RT_CreditsFile.Flush();
		RT_CreditsFile.Close();
		OfficialCreditsFile.Close();
	}
	catch (CFileException* error)
	{
		if (error->m_cause == CFileException::endOfFile)
			AddLogLine(true, GetResString(IDS_CREDITFILECORRUPT));
		else
		{
			TCHAR Buffer[MAX_CFEXP_ERRORMSG];
			error->GetErrorMessage( Buffer, ARRSIZE(Buffer) );
			AddLogLine(true, GetResString(IDS_ERR_CREDITFILEREAD), Buffer);
		}
		error->Delete();
	}
	if (WriteBuffer != NULL)   delete [] WriteBuffer;
}

// Wap Server by MoNKi
void CPreferences::SetWapPass(CString NewValue)
{
	m_sWapPassword = MD5Sum(NewValue).GetHash();
}

// Wap Server by MoNKi
void CPreferences::SetWapLowPass(CString NewValue)
{
	m_sWapLowPassword = MD5Sum(NewValue).GetHash();
}