//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once

// RT, Include
#include "UpDownClient.h"
#include "0RatioFile/RT_Opcodes.h"
// End

#define	DFLT_TRANSFER_WND2	1

const CString strDefaultToolbar = _T("0099010203040506070899091011");

enum EViewSharedFilesAccess{
	vsfaEverybody = 0,
	vsfaFriends = 1,
	vsfaNobody = 2
};

enum EToolbarLabelType;

// DO NOT EDIT VALUES like making a uint16 to uint32, or insert any value. ONLY append new vars
#pragma pack(1)
struct Preferences_Ext_Struct{
	uint8	version;
	uchar	userhash[16];
	WINDOWPLACEMENT EmuleWindowPlacement;
};
#pragma pack()

// deadlake PROXYSUPPORT
struct ProxySettings{
	uint16 type;
	uint16 port;
	TCHAR name[50];
	CHAR user[50];
	CHAR password[50];
	bool EnablePassword;
	bool UseProxy;
};

#pragma pack(1)
struct Category_Struct{
	TCHAR	incomingpath[MAX_PATH];
	TCHAR	title[64];
	TCHAR	comment[255];

	DWORD	color;
	uint8	prio;

	CString autocat;
	bool	ac_regexpeval;

	BOOL    downloadInAlphabeticalOrder; // ZZ:DownloadManager
	int		filter;
	bool	filterNeg;
	bool	care4all;

	CString	regexp;
};
#pragma pack()

class CPreferences
{
// RT, New Member
public:
	// Friend Slot Auto
	static bool		IsFriendSlotAuto()						{ return rt_FriendSlotAuto;}
	static void		SetFriendSlotAuto(bool NewState)		{ rt_FriendSlotAuto = NewState;}
	// PreCheck Diskspace
	static bool		IsPreCheckDiskspace()					{ return rt_PreCheckDiskspace;}
	static void		SetPreCheckDiskspace(bool IsPCD)		{ rt_PreCheckDiskspace = IsPCD;}
	// Auto Swap A4AF
	static bool		IsAutoSwapA4AF()						{ return rt_AutoSwapA4AF;}
	static void		SetAutoSwapA4AF(bool AutoA4AF)			{ rt_AutoSwapA4AF = AutoA4AF;}
	// New User Hash
	static bool		IsNewUserHash()							{ return rt_NewUserHash;}
	// Use Original Color
	static bool		IsRatioColor()							{ return rt_RatioColor;}
	static void		SetRatioColor(bool RatioColor)			{ rt_RatioColor = RatioColor;}
	// Release Rarest Only
	static bool		IsReleaseRarestOnly()					{ return rt_ReleaseRarestOnly;}
	static void		SetReleaseRarestOnly(bool ReleaseRO)	{ rt_ReleaseRarestOnly = ReleaseRO;}
	// Use Hash Nick
	static bool		IsHashNick()							{ return rt_HashNick;}
	static void		SetHashNick(bool UseHN)					{ rt_HashNick = UseHN;}
	// Display Country Name
	static bool		IsDisplayCountry()						{ return rt_DisplayCountry;}
	static void		SetDisplayCountry(bool DisplayCountry)	{ rt_DisplayCountry = DisplayCountry;}
	// Display Country Flag
	static bool		IsDisplayFlag()							{ return rt_DisplayFlag;}
	static void		SetDisplayFlag(bool DisplayFlag)		{ rt_DisplayFlag = DisplayFlag;}
	// Leecher, if Count >
	static uint8	GetLeecherCount()						{ return rt_LeecherCount;}
	static void		SetLeecherCount(uint8 LeecherCount)		{ rt_LeecherCount =LeecherCount;}
	// More than Rarest Part
	static uint8	GetMoreRarestPart()						{ return rt_MoreRarestPart;}
	static void		SetMoreRarestPart(uint8 MoreRP)			{ rt_MoreRarestPart = MoreRP;}
	// Minimum of Upload Slot
	static uint8	GetMinUploadSlot()						{ return rt_MinUploadSlot;}
	static void		SetMinUploadSlot(uint8 MinUploadSlot)	{ rt_MinUploadSlot = MinUploadSlot;}
	// Maximum of Upload Slot
	static uint8	GetMaxUploadSlot()						{ return rt_MaxUploadSlot;}
	static void		SetMaxUploadSlot(uint8 MaxUploadSlot)	{ rt_MaxUploadSlot = MaxUploadSlot;}
	// Auto Release, if > Max and < Min
	static bool		IsAutoRelease()							{ return rt_AutoRelease;}
	static void		SetAutoRelease(bool AutoRelease)		{ rt_AutoRelease = AutoRelease;}
	static uint16	GetAutoReleaseMin()						{ return rt_AutoReleaseMin;}
	static void		SetAutoReleaseMin(uint16 MinAR)			{ rt_AutoReleaseMin = MinAR;}
	static uint16	GetAutoReleaseMax()						{ return rt_AutoReleaseMax;}
	static void		SetAutoReleaseMax(uint16 MaxAR)			{ rt_AutoReleaseMax = MaxAR;}
	// Max Limit of Download QR
	static uint16	GetMaxQR()								{ return rt_MaxQR;}
	static void		SetMaxQR(uint16 MaxQR)					{ rt_MaxQR = MaxQR;}
	// Load/Save Ratio Setting
	static void		RT_LoadSettings();
	static void		RT_SaveSettings();
	static void		RT_InitialSettings();
	// Transfer Bytes, MOD and Country
	static void		RT_AddStatistics(CUpDownClient* Client, bool IsDownloadData, uint32 Bytes);
	static bool		RT_LoadStatistics(int Backup = 0);
	static void		RT_SaveStatistics(int Backup = 0);
	// Status Expand
	static bool		IsStatusExpand(uint8 Pane);
	static void		SetStatusExpand(uint8 Pane, bool IsExpand);
	// Max Release Slot
	static uint8	GetMaxReleaseSlot()								{ return rt_MaxReleaseSlot;}
	static void		SetMaxReleaseSlot(uint8 NewValue)				{ rt_MaxReleaseSlot = NewValue;}
	// Max Credit1 Slot
	static uint8	GetMaxCredit1Slot()								{ return rt_MaxCredit1Slot;}
	static void		SetMaxCredit1Slot(uint8 NewValue)				{ rt_MaxCredit1Slot = NewValue;}
	// Keep Friend Slot Setting
	static bool		IsKeepFriendSlot()								{ return rt_KeepFriendSlot;}
	static void		SetKeepFriendSlot(bool KeepFS)					{ rt_KeepFriendSlot = KeepFS;}
	// UserHash of Friend Slot
	static uchar*	GetUserHashFS()									{ return rt_UserHashFS;}
	static void		SetUserHashFS(const uchar* NewUserHashFS);
	static void		SetUserHashFS(const CString NewUserHashFS);
	static bool		IsCurrentFS(const uchar* UserHash);
	// Focus Slot
	static bool		IsSlotFocus()									{ return rt_SlotFocus;}
	static void		SetSlotFocus(bool SlotFocus)					{ rt_SlotFocus = SlotFocus;}
	// User Nick for Server
	static CString	GetUserNickforServer()							{ return rt_UserNickforServer;}
	static void		SetUserNickforServer(CString UserNickServer)	{ rt_UserNickforServer = UserNickServer;}
	// Run in the High Priority
	static bool		IsRunHighPriority()								{ return rt_RunHighPriority;}
	static void		SetRunHighPriority(bool HighPriority)			{ rt_RunHighPriority = HighPriority;}
	// Font for All Windows
	static bool		IsFontForAllWindows()							{ return rt_FontForAllWindows;}
	static void		SetFontForAllWindows(bool AllWindows)			{ rt_FontForAllWindows = AllWindows;}
	// Download Priority Limit
	static uint16	GetDLPrioLimit(uint16 WhichDLP)					{ return rt_DLPrioLimit[WhichDLP];}
	static void		SetDLPrioLimit(uint16 WhichDLP, uint16 NL)		{ rt_DLPrioLimit[WhichDLP] = NL;}
	// Shared Priority Limit
	static uint16	GetULPrioLimit(uint16 WhichULP)					{ return rt_ULPrioLimit[WhichULP];}
	static void		SetULPrioLimit(uint16 WhichULP, uint16 NL)		{ rt_ULPrioLimit[WhichULP] = NL;}
	// Backup Config
	static uint8	GetAutoBackupConfig()							{ return rt_AutoBackupConfig;}
	static void		SetAutoBackupConfig(uint8 NewValue)				{ rt_AutoBackupConfig = NewValue;}
	// Include Stopped File
	static bool		IsIncludeStoppedFile()							{ return rt_IncludeStoppedFile;}
	static void		SetIncludeStoppedFile(bool NewState)			{ rt_IncludeStoppedFile = NewState;}
	// Log Ratio Verbose
	static bool		IsLogRatioVerbose()								{ return (m_bVerbose && rt_LogRatioVerbose);}
	static void		SetLogRatioVerbose(bool NewState)				{ rt_LogRatioVerbose = NewState;}
	// Log Normal Verbose
	static bool		IsLogNormalVerbose()							{ return (m_bVerbose && rt_LogNormalVerbose);}
	static void		SetLogNormalVerbose(bool NewState)				{ rt_LogNormalVerbose = NewState;}
	static bool		GetVerbose(bool IsReal = false)					{ return (IsReal ? m_bVerbose : (m_bVerbose && rt_LogNormalVerbose));}
	// Table Sort Plus
	static bool		GetTableSortPlus(uint16 Source);
	static void		SetTableSortPlus(uint16 Target, bool NewState);
	// Cumulative source breakdown stats for transfer bytes...
	static uint64	GetCumulativeUploadMod(int Index)				{ return rt_CumulativeUploadMod[Index];}
	static uint64	GetCumulativeUploadCountry(int Index)			{ return rt_CumulativeUploadCountry[Index];}
	static uint64	GetCumulativeDownloadMod(int Index)				{ return rt_CumulativeDownloadMod[Index];}
	static uint64	GetCumulativeDownloadCountry(int Index)			{ return rt_CumulativeDownloadCountry[Index];}
	// Session source breakdown stats for transfer bytes...
	static uint64	GetSessionUploadMod(int Index)					{ return rt_SessionUploadMod[Index];}
	static uint64	GetSessionUploadCountry(int Index)				{ return rt_SessionUploadCountry[Index];}
	static uint64	GetSessionDownloadMod(int Index)				{ return rt_SessionDownloadMod[Index];}
	static uint64	GetSessionDownloadCountry(int Index)			{ return rt_SessionDownloadCountry[Index];}
	// Ping Custom IP
	static bool		IsPingCustomIP()								{ return rt_PingCustomIP;}
	static void		SetPingCustomIP(bool NewState)					{ rt_PingCustomIP = NewState;}
	static uint32	GetCustomIP()									{ return rt_CustomIP;}
	static void		SetCustomIP(uint32 NewValue)					{ rt_CustomIP = NewValue;}
	// Start Next File By
	static uint8	GetStartNextFileBy()							{ return rt_StartNextFileBy;}
	static void		SetStartNextFileBy(uint8 NewValue)				{ rt_StartNextFileBy = NewValue;}
	// RT Style
	static bool		IsRatioStyleServer()							{ return rt_RatioStyleServer;}
	static void		SetRatioStyleServer(bool NewState)				{ rt_RatioStyleServer = NewState;}
	static bool		IsRatioStyleTransfer()							{ return rt_RatioStyleTransfer;}
	static void		SetRatioStyleTransfer(bool NewState)			{ rt_RatioStyleTransfer = NewState;}
	// Category Temporary Directory
	static CString	GetTempDir(int Category);
	static void		SetTempDir(int Category, CString Directory);
	static void		RT_LoadCategory();
	static void		RT_SaveCategory();
	static void		SetAddNewFilesPaused(bool NewState)				{ addnewfilespaused = NewState;}
	// Category View Filter
	static int		GetCategoryViewFilter(int Category);
	static void		SetCategoryViewFilter(int Category, int Filter);
	// RSA-CIDE by enkeyDev
	static void		SetUserHash(const uchar* NewHash)				{ memcpy(userhash, NewHash, 16);}
	// Ratio Color
	static COLORREF	GetRatioColor(int Which)						{ return rt_RatioColors[Which];}
	static void		SetRatioColor(int Which, COLORREF NewValue)		{ rt_RatioColors[Which] = NewValue;}
	// Convert Old Format KnownFile to New Format
	static void		RT_ConvertOldKnownFile();
	// Convert Official Credits File to RT Format
	static void		RT_ClientsMet2RT();
	// Upload Queue Waited Time
	static bool		IsRecordUploadQueueWaitedTime()					{ return rt_RecordUploadQueueWaitedTime;}
	static void		SetRecordUploadQueueWaitedTime(bool NewState)	{ rt_RecordUploadQueueWaitedTime = NewState;}
	// Extract Meta Data
	static void		SetExtractMetaData(int NewValue)				{ m_iExtractMetaData = NewValue;}
	// Download Sort Separate Stop
	static bool		IsDownloadSortSeparateStop()					{ return rt_DownloadSortSeparateStop;}
	static void		SetDownloadSortSeparateStop(bool NewState)		{ rt_DownloadSortSeparateStop = NewState;}
	// Flush Buffer Time Limit
	static uint32	GetFlushBufferTimeLimit()						{ return rt_FlushBufferTimeLimit;}
	static void		SetFlushBufferTimeLimit(uint32 NewValue)		{ rt_FlushBufferTimeLimit = NewValue;}
	// Normal Exit
	static bool		IsNormalExitLastTime()							{ return rt_NormalExitLastTime;}
	static void		SetNormalExit(CString EntryKey, bool Flag);
	// Reset DontDownload
	static bool		IsResetDontDownload()							{ return rt_ResetDontDownload;}
	// Display Icon of Filetype
	static bool		IsDisplayIconOfFiletype()						{ return rt_DisplayIconOfFiletype;}
	static void		SetDisplayIconOfFiletype(bool NewState)			{ rt_DisplayIconOfFiletype = NewState;}
	// Random Port
	static uint16	GetPort(bool IsGetReal)							{ return IsGetReal ? rt_RealTCPPort : port;}
	static void		SetPort(uint16 NewValue)						{ port = NewValue;}
	static uint16	GetUDPPort(bool IsGetReal)						{ return IsGetReal ? rt_RealUDPPort : udpport;}
	static void		SetUDPPort(uint16 NewValue)						{ udpport = NewValue;}
	static bool		IsRandomTCPPort()								{ return rt_RandomTCPPort;}
	static bool		IsSessionRandomTCPPort()						{ return rt_SessionRandomTCPPort;}
	static void		SetRandomTCPPort(bool NewState)					{ rt_RandomTCPPort = NewState;}
	static bool		IsRandomUDPPort()								{ return rt_RandomUDPPort;}
	static bool		IsSessionRandomUDPPort()						{ return rt_SessionRandomUDPPort;}
	static void		SetRandomUDPPort(bool NewState)					{ rt_RandomUDPPort = NewState;}
	static CString	GetRandomTCPPortList()							{ return rt_RandomTCPPortList;}
	static void		SetRandomTCPPortList(CString NewValue)			{ rt_RandomTCPPortList = NewValue;}
	static CString	GetRandomUDPPortList()							{ return rt_RandomUDPPortList;}
	static void		SetRandomUDPPortList(CString NewValue)			{ rt_RandomUDPPortList = NewValue;}
	// WebCache
	static	uint64	GetWebCacheUpDataSession()						{ return rt_WebCacheUpDataSession;}
	static	void	AddWebCacheUpDataSession(uint64 AddValue)		{ rt_WebCacheUpDataSession += AddValue;}
	static	uint64	GetWebCacheUpDataCumulative()					{ return (rt_WebCacheUpDataSession + rt_WebCacheUpDataCumulative);}
	//
	// *** Tweak ***
	//
	// Save Overhead Bandwidth
	static bool		IsSaveOverhead()								{ return rt_SaveOverhead;}
	static void		SetSaveOverhead(bool NewState)					{ rt_SaveOverhead = NewState;}
	// Save CPU Load
	static bool		IsSaveCpuLoad()									{ return rt_SaveCpuLoad;}
	static void		SetSaveCpuLoad(bool NewState)					{ rt_SaveCpuLoad = NewState;}
	// Connect Time Out
	static uint32	GetConnectTimeOut()								{ return rt_ConnectTimeOut;}
	static void		SetConnectTimeOut(uint32 NewValue)				{ rt_ConnectTimeOut = NewValue;}
	//
	// *** Category ***
	//
	// Add Category
	static int		AddCat(Category_Struct* cat);
	// All Category Type
	static int		GetAllCategoryType()							{ return rt_AllCategoryType;}
	static void		SetAllCategoryType(int NewValue)				{ rt_AllCategoryType = NewValue;}
	//
	// *** Wap Server ***
	//
	// Wap Server by MoNKi
	static CString	GetWapTemplate()								{ return CString(m_sWapTemplateFile);}
	static void		SetWapTemplate(CString NewValue)				{ _stprintf(m_sWapTemplateFile, _T("%s"), NewValue);}
	static bool		GetWapServerEnabled()							{ return m_bWapEnabled;}
	static void		SetWapServerEnabled(bool NewState)				{ m_bWapEnabled = NewState;}
	static uint16	GetWapPort()									{ return m_nWapPort;}
	static void		SetWapPort(uint16 NewValue)						{ m_nWapPort = NewValue;}
	static CString	GetWapServerDir() 								{ return m_strWapServerDir;}
	static uint8	GetWapGraphWidth()								{ return m_iWapGraphWidth;}
	static uint8	GetWapGraphHeight()								{ return m_iWapGraphHeight;}
	static void		SetWapGraphWidth(int NewValue)					{ m_iWapGraphWidth = NewValue;}
	static void		SetWapGraphHeight(int NewValue)					{ m_iWapGraphHeight = NewValue;}
	static bool		GetWapGraphsFilled()							{ return m_bWapFilledGraphs;}
	static void		SetWapGraphsFilled(bool NewState)				{ m_bWapFilledGraphs = NewState;}
	static void		SetWapMaxItemsInPages(int NewValue)				{ m_iWapMaxItemsInPages = NewValue;}
	static int		GetWapMaxItemsInPages()							{ return m_iWapMaxItemsInPages;}
	static void		SetWapSendImages(bool NewState)					{ m_bWapSendImages = NewState;}
	static bool		GetWapSendImages()								{ return m_bWapSendImages;}
	static void		SetWapSendGraphs(bool NewState)					{ m_bWapSendGraphs = NewState;}
	static bool		GetWapSendGraphs()								{ return m_bWapSendGraphs;}
	static void		SetWapSendProgressBars(bool NewState)			{ m_bWapSendProgressBars = NewState;}
	static bool		GetWapSendProgressBars()						{ return m_bWapSendProgressBars;}
	static bool		GetWapAllwaysSendBWImages()						{ return m_bWapAllwaysSendBWImages;}
	static void		SetWapAllwaysSendBWImages(bool NewState)		{ m_bWapAllwaysSendBWImages = NewState;}
	static UINT		GetWapLogsSize()								{ return m_iWapLogsSize;}
	static void		SetWapLogsSize(UINT NewValue)					{ m_iWapLogsSize = NewValue;}
	static CString	GetWapPass()									{ return m_sWapPassword;}
	static void		SetWapPass(CString NewValue);
	static bool		GetWapIsLowUserEnabled()						{ return m_bWapLowEnabled;}
	static void		SetWapIsLowUserEnabled(bool NewState)			{ m_bWapLowEnabled = NewState;}
	static CString	GetWapLowPass()									{ return m_sWapLowPassword;}
	static void		SetWapLowPass(CString NewValue);
private:
	// Backup Config
	static void		RT_BackupConfig();
	// Restore Config
	static void		RT_RestoreConfig();
private:
	// Friend Slot Auto
	static bool		rt_FriendSlotAuto;
	// PreCheck Diskspace
	static bool		rt_PreCheckDiskspace;
	// Auto Swap A4AF
	static bool		rt_AutoSwapA4AF;
	// Use Ratio Color
	static bool		rt_RatioColor;
	// New User Hash
	static bool		rt_NewUserHash;
	// Release Rarest Only
	static bool		rt_ReleaseRarestOnly;
	// Auto Release, if > Max and < Min
	static bool		rt_AutoRelease;
	// Use Hash Nick
	static bool		rt_HashNick;
	// More than Rarest Part
	static uint8	rt_MoreRarestPart;
	// Leecher, if Count >
	static uint8	rt_LeecherCount;
	// Minimum, Maximum of Upload Slot
	static uint8	rt_MinUploadSlot;
	static uint8	rt_MaxUploadSlot;
	// Max QR of Download
	static uint16	rt_MaxQR;
	// Auto Release Minimum, Maximum
	static uint16	rt_AutoReleaseMin;
	static uint16	rt_AutoReleaseMax;
	// Display Country Name
	static bool		rt_DisplayCountry;
	static bool		rt_DisplayFlag;
	// Keep Friend Slot Setting
	static bool		rt_KeepFriendSlot;
	static uchar	rt_UserHashFS[16];
	// Maximum of Release Slot
	static uint8	rt_MaxReleaseSlot;
	// Maximum of Credit1 Slot
	static uint8	rt_MaxCredit1Slot;
	// Slot Focus
	static bool		rt_SlotFocus;
	// User Nick for Server
	static CString	rt_UserNickforServer;
	// Run in the High Priority
	static bool		rt_RunHighPriority;
	// Font for All Windows
	static bool		rt_FontForAllWindows;
	// Backup Config
	static uint8	rt_AutoBackupConfig;
	// Download Priority Limit
	static uint16	rt_DLPrioLimit[RT_PRIORITY_COUNT];
	// Shared Priority Limit
	static uint16	rt_ULPrioLimit[RT_PRIORITY_COUNT];
	// Include Stopped File
	static bool		rt_IncludeStoppedFile;
	// Log Ratio Verbose
	static bool		rt_LogRatioVerbose;
	// Log Normal Verbose
	static bool		rt_LogNormalVerbose;
	// Table Sort Plus
	static uint16	rt_TableSortPlus;
	// Cumulative source breakdown stats for transfer bytes...
	static uint64	rt_CumulativeUploadMod[RT_MOD_COUNT];
	static uint64	rt_CumulativeUploadCountry[RT_COUNTRY_COUNT];
	static uint64	rt_CumulativeDownloadMod[RT_MOD_COUNT];
	static uint64	rt_CumulativeDownloadCountry[RT_COUNTRY_COUNT];
	// Session source breakdown stats for transfer bytes...
	static uint64	rt_SessionUploadMod[RT_MOD_COUNT];
	static uint64	rt_SessionUploadCountry[RT_COUNTRY_COUNT];
	static uint64	rt_SessionDownloadMod[RT_MOD_COUNT];
	static uint64	rt_SessionDownloadCountry[RT_COUNTRY_COUNT];
	// Status Expand
	static uint8	rt_StatusExpand;
	// Ping Custom IP
	static bool		rt_PingCustomIP;
	static uint32	rt_CustomIP;
	// Start Next File By
	static uint8	rt_StartNextFileBy;
	// RT Style
	static bool		rt_RatioStyleServer;
	static bool		rt_RatioStyleTransfer;
	// Upload Queue Waited Time
	static bool		rt_RecordUploadQueueWaitedTime;
	// Download Sort Separate Stop
	static bool		rt_DownloadSortSeparateStop;
	// Flush Buffer Time Limit (ms)
	static uint32	rt_FlushBufferTimeLimit;
	// Normal Exit
	static bool		rt_NormalExitLastTime;
	// Reset DontDownload
	static bool		rt_ResetDontDownload;
	// Display Icon of Filetype
	static bool		rt_DisplayIconOfFiletype;
	// Category
	static int		rt_AllCategoryType;
	// Random Port
	static uint16	rt_RealTCPPort;
	static uint16	rt_RealUDPPort;
	static bool		rt_RandomTCPPort;
	static bool		rt_SessionRandomTCPPort;
	static bool		rt_RandomUDPPort;
	static bool		rt_SessionRandomUDPPort;
	static CString	rt_RandomTCPPortList;
	static CString	rt_RandomUDPPortList;
	// WebCache
	static uint64	rt_WebCacheUpDataSession;
	static uint64	rt_WebCacheUpDataCumulative;
	//
	// *** Tweak ***
	//
	// Save Overhead
	static bool		rt_SaveOverhead;
	// Save CPU Load
	static bool		rt_SaveCpuLoad;
	// Connect Time Out (ms)
	static uint32	rt_ConnectTimeOut;
	//
	// *** Wap Server ***
	//
    // Wap Server by MoNKi
	static TCHAR	m_sWapTemplateFile[MAX_PATH];
	static bool		m_bWapEnabled;
	static uint16	m_nWapPort;
	static uint8	m_iWapGraphWidth;
	static uint8	m_iWapGraphHeight;
	static bool		m_bWapFilledGraphs;
	static int		m_iWapMaxItemsInPages;
	static bool		m_bWapSendImages;
	static bool		m_bWapSendGraphs;
	static bool		m_bWapSendProgressBars;
	static bool		m_bWapAllwaysSendBWImages;
	static UINT		m_iWapLogsSize;
	static CString	m_strWapServerDir;
	static CString	m_sWapPassword;
	static CString	m_sWapLowPassword;
	static bool		m_bWapLowEnabled;
// RT, WebCache (Code by JP/yonatan/Superlexx)
public:
	static	uint64	cumDownData_WEBCACHE; //jp webcache statistics
	static	uint64	sesDownData_WEBCACHE; //jp webcache statistics
	static  uint32	ses_WEBCACHEREQUESTS; //jp webcache statistics
	static	uint32	ses_successfull_WCDOWNLOADS;  //jp webcache statistics
	static	bool	m_bLogWebCacheEvents;//JP log webcache events
	static	bool	WebCacheDisabledThisSession; //JP temp disabler
	static	uint32	WebCachePingSendTime;//jp check proxy config
	static	bool	webcacheReleaseAllowed; //jp webcache release
	static	uint16	webcacheBlockLimit;
	static	bool	webcacheExtraTimeout;
	static	bool	webcacheCachesLocalTraffic;
	static	bool	webcacheEnabled;
	static	bool	detectWebcacheOnStartup; // jp detect webcache on startup
	static	uint32	webcacheLastSearch;
	static	uint32	webcacheLastGlobalIP;
	static	CString	webcacheLastResolvedName;
	static	bool	PersistentConnectionsForProxyDownloads;
	static	bool	expectingWebCachePing;//jp check proxy config
	static	uint16	webcachePort;
	static	CString	webcacheName;		//jp move these to private?? and make member functions to set and change them??
	//
	static	bool	IsWebCacheTestPossible(); //jp check proxy config
	static	bool	IsWebcacheReleaseAllowed() {return webcacheReleaseAllowed;}//jp webcache release
	static	bool	UpdateWebcacheReleaseAllowed();//jp webcache release
	static	bool	WebCacheIsTransparent() {return webcacheName.GetLength() > 15 && webcacheName.Left(12) == "transparent@";}
	static	void	SetWebCacheBlockLimit(uint16 limit) {webcacheBlockLimit = limit;}
	static	uint16	GetWebCacheBlockLimit() {return webcacheBlockLimit;}
	static	void	SetWebCacheExtraTimeout(bool value) {webcacheExtraTimeout = value;}
	static	bool	GetWebCacheExtraTimeout() {return webcacheExtraTimeout;}
	static	void	SetWebCacheCachesLocalTraffic(bool value) {webcacheCachesLocalTraffic = value;}
	static	bool	GetWebCacheCachesLocalTraffic() {return webcacheCachesLocalTraffic;}
	static	bool	IsWebCacheDownloadEnabled() {return webcacheEnabled && !WebCacheDisabledThisSession;} //jp
	static	bool	UsesCachedTCPPort();	//jp
	static	void	SetWebCacheLastSearch(uint32 time) {webcacheLastSearch = time;}
	static	uint32	GetWebCacheLastSearch() {return webcacheLastSearch;}
	static	void	SetWebCacheLastGlobalIP(uint32 IP) {webcacheLastGlobalIP = IP;}
	static	uint32	GetWebCacheLastGlobalIP() {return webcacheLastGlobalIP;}
	static	void	SetLastResolvedName(CString name) {webcacheLastResolvedName = name;}
	static	CString	GetLastResolvedName()	{return webcacheLastResolvedName;}
	static	uint64	GetCumDownData_WEBCACHE()		{ return (cumDownData_WEBCACHE + sesDownData_WEBCACHE);} //jp webcache statistics
	static	uint64	GetDownData_WEBCACHE()			{ return sesDownData_WEBCACHE;} //jp webcache statistics
	static	bool	GetLogWebCacheEvents()				{return m_bVerbose && m_bLogWebCacheEvents;}//JP log webcache events
	// Log WebCache Verbose
	static bool		IsLogWebCacheVerbose()							{ return (m_bVerbose && m_bLogWebCacheEvents);}
	static void		SetLogWebCacheVerbose(bool NewState)			{ m_bLogWebCacheEvents = NewState;}
// End--WebCache
	// Ratio Colors
	static COLORREF	rt_RatioColors[RT_COLOR_COUNT];
	// Category Temporary Directory
	static CArray	 <CString, CString&> rt_CategoryTempDir;
	// Category View Filter
	static CArray	<int, int> rt_CategoryViewFilter;
public:
	// Upload Column, Official = 13
	static uint16	downloadColumnWidths[14];
	static BOOL		downloadColumnHidden[14];
	static INT		downloadColumnOrder[14];
	// Upload Column, Official = 8
	static uint16	uploadColumnWidths[11];
	static BOOL		uploadColumnHidden[11];
	static INT		uploadColumnOrder[11];
	// Shared Column, Official = 12
	static uint16	sharedColumnWidths[13];
	static BOOL	sharedColumnHidden[13];
	static INT		sharedColumnOrder[13];
	// Queue Column, Official = 10
	static uint16	queueColumnWidths[13];
	static BOOL		queueColumnHidden[13];
	static INT		queueColumnOrder[13];
	// Known Column, Official = 8
	static uint16	clientListColumnWidths[9];
	static BOOL		clientListColumnHidden[9];
	static INT		clientListColumnOrder[9];
	// No Change
	static uint16	searchColumnWidths[14];
	static BOOL		searchColumnHidden[14];
	static INT		searchColumnOrder[14];
	static uint16	serverColumnWidths[14];
	static BOOL		serverColumnHidden[14];
	static INT		serverColumnOrder[14];
// End
public:
	static	CString	strNick;
	// ZZ:UploadSpeedSense -->
	static	uint16	minupload;
	// ZZ:UploadSpeedSense <--
	static	uint16	maxupload;
	static	uint16	maxdownload;
	static	uint16	port;
	static	uint16	udpport;
	static	uint16	nServerUDPPort;
	static	uint16	maxconnections;
	static	uint16	maxhalfconnections;
	static	uint8	reconnect;
	static	uint8	scorsystem;
	static	TCHAR	incomingdir[MAX_PATH];
	static	TCHAR	tempdir[MAX_PATH];
	static	uint8	ICH;
	static	uint8	autoserverlist;
	static	uint8	updatenotify;
	static	uint8	mintotray;
	static	uint8	autoconnect;
	static	uint8	autoconnectstaticonly; // Barry
	static	uint8	autotakeed2klinks;	   // Barry
	static	uint8	addnewfilespaused;	   // Barry
	static	uint8	depth3D;			   // Barry
	static	bool	m_bEnableMiniMule;
	static	int		m_iStraightWindowStyles;
	static	CString	m_strSkinProfile;
	static	CString	m_strSkinProfileDir;
	static	uint8	addserversfromserver;
	static	uint8	addserversfromclient;
	static	uint16	maxsourceperfile;
	static	uint16	trafficOMeterInterval;
	static	uint16	statsInterval;
	static	uchar	userhash[16];
	static	WINDOWPLACEMENT EmuleWindowPlacement;
	static	int		maxGraphDownloadRate;
	static	int		maxGraphUploadRate;
	static	uint8	beepOnError;
	static	uint8	confirmExit;
// RT, Move to Above
/* Official
	static	uint16	downloadColumnWidths[13];
	static	BOOL	downloadColumnHidden[13];
	static	INT		downloadColumnOrder[13];
	static	uint16	uploadColumnWidths[8];
	static	BOOL	uploadColumnHidden[8];
	static	INT		uploadColumnOrder[8];
	static	uint16	queueColumnWidths[10];
	static	BOOL	queueColumnHidden[10];
	static	INT		queueColumnOrder[10];
	static	uint16	searchColumnWidths[14];
	static	BOOL	searchColumnHidden[14];
	static	INT		searchColumnOrder[14];
	static	uint16	sharedColumnWidths[12];
	static	BOOL	sharedColumnHidden[12];
	static	INT		sharedColumnOrder[12];
	static	uint16	serverColumnWidths[14];
	static	BOOL	serverColumnHidden[14];
	static	INT		serverColumnOrder[14];
	static	uint16	clientListColumnWidths[8];
	static	BOOL	clientListColumnHidden[8];
	static	INT		clientListColumnOrder[8];
*/
	static	uint16	FilenamesListColumnWidths[2];
	static	BOOL	FilenamesListColumnHidden[2];
	static	INT		FilenamesListColumnOrder[2];
	static	DWORD	m_adwStatsColors[15];

	static	uint8	splashscreen;
	static	uint8	filterLANIPs;
	static	bool	m_bAllocLocalHostIP;
	static	uint8	onlineSig;

	// -khaos--+++> Struct Members for Storing Statistics

	// Saved stats for cumulative downline overhead...
	static	uint64	cumDownOverheadTotal;
	static	uint64	cumDownOverheadFileReq;
	static	uint64	cumDownOverheadSrcEx;
	static	uint64	cumDownOverheadServer;
	static	uint64	cumDownOverheadKad;
	static	uint64	cumDownOverheadTotalPackets;
	static	uint64	cumDownOverheadFileReqPackets;
	static	uint64	cumDownOverheadSrcExPackets;
	static	uint64	cumDownOverheadServerPackets;
	static	uint64	cumDownOverheadKadPackets;

	// Saved stats for cumulative upline overhead...
	static	uint64	cumUpOverheadTotal;
	static	uint64	cumUpOverheadFileReq;
	static	uint64	cumUpOverheadSrcEx;
	static	uint64	cumUpOverheadServer;
	static	uint64	cumUpOverheadKad;
	static	uint64	cumUpOverheadTotalPackets;
	static	uint64	cumUpOverheadFileReqPackets;
	static	uint64	cumUpOverheadSrcExPackets;
	static	uint64	cumUpOverheadServerPackets;
	static	uint64	cumUpOverheadKadPackets;

	// Saved stats for cumulative upline data...
	static	uint32	cumUpSuccessfulSessions;
	static	uint32	cumUpFailedSessions;
	static	uint32	cumUpAvgTime;
	// Cumulative client breakdown stats for sent bytes...
	static	uint64	cumUpData_EDONKEY;
	static	uint64	cumUpData_EDONKEYHYBRID;
	static	uint64	cumUpData_EMULE;
	static	uint64	cumUpData_MLDONKEY;
	static	uint64	cumUpData_AMULE;
	static	uint64	cumUpData_EMULECOMPAT;
	static	uint64	cumUpData_SHAREAZA;
	// Session client breakdown stats for sent bytes...
	static	uint64	sesUpData_EDONKEY;
	static	uint64	sesUpData_EDONKEYHYBRID;
	static	uint64	sesUpData_EMULE;
	static	uint64	sesUpData_MLDONKEY;
	static	uint64	sesUpData_AMULE;
	static	uint64	sesUpData_EMULECOMPAT;
	static	uint64	sesUpData_SHAREAZA;

	// Cumulative port breakdown stats for sent bytes...
	static	uint64	cumUpDataPort_4662;
	static	uint64	cumUpDataPort_OTHER;
	static	uint64	cumUpDataPort_PeerCache;
	// Session port breakdown stats for sent bytes...
	static	uint64	sesUpDataPort_4662;
	static	uint64	sesUpDataPort_OTHER;
	static	uint64	sesUpDataPort_PeerCache;

	// Cumulative source breakdown stats for sent bytes...
	static	uint64	cumUpData_File;
	static	uint64	cumUpData_Partfile;
	// Session source breakdown stats for sent bytes...
	static	uint64	sesUpData_File;
	static	uint64	sesUpData_Partfile;

	// Saved stats for cumulative downline data...
	static	uint32	cumDownCompletedFiles;
	static	uint32	cumDownSuccessfulSessions;
	static	uint32	cumDownFailedSessions;
	static	uint32	cumDownAvgTime;

	// Cumulative statistics for saved due to compression/lost due to corruption
	static	uint64	cumLostFromCorruption;
	static	uint64	cumSavedFromCompression;
	static	uint32	cumPartsSavedByICH;

	// Session statistics for download sessions
	static	uint32	sesDownSuccessfulSessions;
	static	uint32	sesDownFailedSessions;
	static	uint32	sesDownAvgTime;
	static	uint32	sesDownCompletedFiles;
	static	uint64	sesLostFromCorruption;
	static	uint64	sesSavedFromCompression;
	static	uint32	sesPartsSavedByICH;

	// Cumulative client breakdown stats for received bytes...
	static	uint64	cumDownData_EDONKEY;
	static	uint64	cumDownData_EDONKEYHYBRID;
	static	uint64	cumDownData_EMULE;
	static	uint64	cumDownData_MLDONKEY;
	static	uint64	cumDownData_AMULE;
	static	uint64	cumDownData_EMULECOMPAT;
	static	uint64	cumDownData_SHAREAZA;
	static	uint64	cumDownData_URL;
	// Session client breakdown stats for received bytes...
	static	uint64	sesDownData_EDONKEY;
	static	uint64	sesDownData_EDONKEYHYBRID;
	static	uint64	sesDownData_EMULE;
	static	uint64	sesDownData_MLDONKEY;
	static	uint64	sesDownData_AMULE;
	static	uint64	sesDownData_EMULECOMPAT;
	static	uint64	sesDownData_SHAREAZA;
	static	uint64	sesDownData_URL;

	// Cumulative port breakdown stats for received bytes...
	static	uint64	cumDownDataPort_4662;
	static	uint64	cumDownDataPort_OTHER;
	static	uint64	cumDownDataPort_PeerCache;
	// Session port breakdown stats for received bytes...
	static	uint64	sesDownDataPort_4662;
	static	uint64	sesDownDataPort_OTHER;
	static	uint64	sesDownDataPort_PeerCache;

	// Saved stats for cumulative connection data...
	static	float	cumConnAvgDownRate;
	static	float	cumConnMaxAvgDownRate;
	static	float	cumConnMaxDownRate;
	static	float	cumConnAvgUpRate;
	static	float	cumConnMaxAvgUpRate;
	static	float	cumConnMaxUpRate;
	static	uint64	cumConnRunTime;
	static	uint32	cumConnNumReconnects;
	static	uint32	cumConnAvgConnections;
	static	uint32	cumConnMaxConnLimitReached;
	static	uint32	cumConnPeakConnections;
	static	uint32	cumConnTransferTime;
	static	uint32	cumConnDownloadTime;
	static	uint32	cumConnUploadTime;
	static	uint32	cumConnServerDuration;

	// Saved records for servers / network...
	static	uint32	cumSrvrsMostWorkingServers;
	static	uint32	cumSrvrsMostUsersOnline;
	static	uint32	cumSrvrsMostFilesAvail;

	// Saved records for shared files...
	static	uint32	cumSharedMostFilesShared;
	static	uint64	cumSharedLargestShareSize;
	static	uint64	cumSharedLargestAvgFileSize;
	static	uint64	cumSharedLargestFileSize;

	// Save the date when the statistics were last reset...
	static	__int64 stat_datetimeLastReset;

	// Save new preferences for PPgStats
	static	uint8	statsConnectionsGraphRatio; // This will store the divisor, i.e. for 1:3 it will be 3, for 1:20 it will be 20.
	// Save the expanded branches of the stats tree
	static	TCHAR	statsExpandedTreeItems[256];

	static	UINT	statsSaveInterval;
	static  bool	m_bShowVerticalHourMarkers;
	// <-----khaos- End Statistics Members


	// Original Stats Stuff
	static	uint64	totalDownloadedBytes;
	static	uint64	totalUploadedBytes;
	// End Original Stats Stuff
	static	WORD	m_wLanguageID;
	static	uint8	transferDoubleclick;
	static	EViewSharedFilesAccess m_iSeeShares;
	static	uint8	m_iToolDelayTime;	// tooltip delay time in seconds
	static	uint8	bringtoforeground;
	static	uint8	splitterbarPosition;
	static	uint8	m_uTransferWnd2;
	//MORPH START - Added by SiRoB, Splitting Bar [O]
	static	uint8	splitterbarPositionStat;
	static	uint8	splitterbarPositionStat_HL;
	static	uint8	splitterbarPositionStat_HR;
	static	uint16	splitterbarPositionFriend;
	static	uint16	splitterbarPositionIRC;
	//MORPH END - Added by SiRoB, Splitting Bar [O]
	static	uint16	deadserverretries;
	static	DWORD	m_dwServerKeepAliveTimeout;
	// -khaos--+++> Changed data type to avoid overflows
	static	uint16	statsMax;
	// <-----khaos-
	static	uint8	statsAverageMinutes;

	static	uint8	useDownloadNotifier;
	static	uint8	useNewDownloadNotifier;
	static	uint8	useChatNotifier;
	static	uint8	useLogNotifier;
	static	uint8	useSoundInNotifier;
	static	uint8	notifierPopsEveryChatMsg;
	static	uint8	notifierImportantError;
	static	uint8	notifierNewVersion;
	static	TCHAR	notifierSoundFilePath[510];

	static	TCHAR	m_sircserver[50];
	static	TCHAR	m_sircnick[30];
	static	TCHAR	m_sircchannamefilter[50];
	static	bool	m_bircaddtimestamp;
	static	bool	m_bircusechanfilter;
	static	uint16	m_iircchanneluserfilter;
	static	TCHAR	m_sircperformstring[255];
	static	bool	m_bircuseperform;
	static	bool	m_birclistonconnect;
	static	bool	m_bircacceptlinks;
	static	bool	m_bircacceptlinksfriends;
	static	bool	m_bircsoundevents;
	static	bool	m_bircignoremiscmessage;
	static	bool	m_bircignorejoinmessage;
	static	bool	m_bircignorepartmessage;
	static	bool	m_bircignorequitmessage;
	static	bool	m_bircignoreemuleprotoaddfriend;
	static	bool	m_bircallowemuleprotoaddfriend;
	static	bool	m_bircignoreemuleprotosendlink;
	static	bool	m_birchelpchannel;

	static	bool	m_bRemove2bin;
	static	bool	m_bShowCopyEd2kLinkCmd;
	static	bool	m_bpreviewprio;
	static	bool	smartidcheck;
	static	uint8	smartidstate;
	static	bool	safeServerConnect;
	static	bool	startMinimized;
	static	bool	m_bAutoStart;
	static	bool	m_bRestoreLastMainWndDlg;
	static	int		m_iLastMainWndDlgID;
	static	bool	m_bRestoreLastLogPane;
	static	int		m_iLastLogPaneID;
	static	uint16	MaxConperFive;
	static	int		checkDiskspace; // SLUGFILLER: checkDiskspace
	static	UINT	m_uMinFreeDiskSpace;
	static	bool	m_bSparsePartFiles;
	static	CString	m_strYourHostname;
	static	bool	m_bEnableVerboseOptions;
	static	bool	m_bVerbose;
	static	bool	m_bFullVerbose;
	static	bool	m_bDebugSourceExchange; // Sony April 23. 2003, button to keep source exchange msg out of verbose log
	static	bool	m_bLogBannedClients;
	static	bool	m_bLogRatingDescReceived;
	static	bool	m_bLogSecureIdent;
	static	bool	m_bLogFilteredIPs;
	static	bool	m_bLogFileSaving;
    static  bool    m_bLogA4AF; // ZZ:DownloadManager
	static	bool	m_bLogUlDlEvents;
	static	bool	m_bUseDebugDevice;
	static	int		m_iDebugServerTCPLevel;
	static	int		m_iDebugServerUDPLevel;
	static	int		m_iDebugServerSourcesLevel;
	static	int		m_iDebugServerSearchesLevel;
	static	int		m_iDebugClientTCPLevel;
	static	int		m_iDebugClientUDPLevel;
	static	int		m_iDebugClientKadUDPLevel;
	static	bool	m_bupdatequeuelist;
	static	bool	m_bmanualhighprio;
	static	bool	m_btransferfullchunks;
	static	int		m_istartnextfile;
	static	bool	m_bshowoverhead;
	static	bool	m_bDAP;
	static	bool	m_bUAP;
	static	bool	m_bDisableKnownClientList;
	static	bool	m_bDisableQueueList;
	static	bool	m_bExtControls;
	static	bool	m_bTransflstRemain;

	static	uint8	versioncheckdays;

	// Barry - Provide a mechanism for all tables to store/retrieve sort order
	static	int		tableSortItemDownload;
	static	int		tableSortItemUpload;
	static	int		tableSortItemQueue;
	static	int		tableSortItemSearch;
	static	int		tableSortItemShared;
	static	int		tableSortItemServer;
	static	int		tableSortItemClientList;
	static  int		tableSortItemFilenames;
	static	bool	tableSortAscendingDownload;
	static	bool	tableSortAscendingUpload;
	static	bool	tableSortAscendingQueue;
	static	bool	tableSortAscendingSearch;
	static	bool	tableSortAscendingShared;
	static	bool	tableSortAscendingServer;
	static	bool	tableSortAscendingClientList;
	static  bool	tableSortAscendingFilenames;

	static	bool	showRatesInTitle;

	static	TCHAR	TxtEditor[256];
	static	TCHAR	VideoPlayer[256];
	static	bool	moviePreviewBackup;
	static	int		m_iPreviewSmallBlocks;
	static	int		m_iPreviewCopiedArchives;
	static	int		m_iInspectAllFileTypes;
	static	bool	m_bPreviewOnIconDblClk;
	static	bool	indicateratings;
	static	bool	watchclipboard;
	static	bool	filterserverbyip;
	static	bool	m_bFirstStart;
	static	bool	m_bCreditSystem;

	static	bool	log2disk;
	static	bool	debug2disk;
	static	int		iMaxLogBuff;
	static	UINT	uMaxLogFileSize;
	static	bool	scheduler;
	static	bool	dontcompressavi;
	static	bool	msgonlyfriends;
	static	bool	msgsecure;

	static	uint8	filterlevel;
	static	UINT	m_iFileBufferSize;
	static	UINT	m_iQueueSize;
	static	int		m_iCommitFiles;

	static	uint16	maxmsgsessions;
	static	uint32	versioncheckLastAutomatic;
	static	TCHAR	messageFilter[512];
	static	CString	commentFilter;
	static	TCHAR	filenameCleanups[512];
	static	TCHAR	notifierConfiguration[510];
	static	TCHAR	datetimeformat[64];
	static	TCHAR	datetimeformat4log[64];
	static	LOGFONT m_lfHyperText;
	static	LOGFONT m_lfLogText;
	static	COLORREF m_crLogError;
	static	COLORREF m_crLogWarning;
	static	COLORREF m_crLogSuccess;
	static	int		m_iExtractMetaData;
	static	bool	m_bAdjustNTFSDaylightFileTime;

	// Web Server [kuchin]
	static	TCHAR	m_sWebPassword[256];
	static	TCHAR	m_sWebLowPassword[256];
	static	uint16	m_nWebPort;
	static	bool	m_bWebEnabled;
	static	bool	m_bWebUseGzip;
	static	int		m_nWebPageRefresh;
	static	bool	m_bWebLowEnabled;
	static	TCHAR	m_sWebResDir[MAX_PATH];
	static	int		m_iWebTimeoutMins;

	static	TCHAR	m_sTemplateFile[MAX_PATH];
	static	ProxySettings proxy; // deadlake PROXYSUPPORT
	static	bool	m_bIsASCWOP;
	static	bool	m_bShowProxyErrors;

	static	bool	showCatTabInfos;
	static	bool	resumeSameCat;
	static	bool	dontRecreateGraphs;
	static	bool	autofilenamecleanup;
	//static	int		allcatType;
	//static	bool	allcatTypeNeg;
	static	bool	m_bUseAutocompl;
	static	bool	m_bShowDwlPercentage;
	static	bool	m_bRemoveFinishedDownloads;
	static	uint16	m_iMaxChatHistory;
	static	bool	m_bShowActiveDownloadsBold;

	static	int		m_iSearchMethod;
	static	bool	m_bAdvancedSpamfilter;
	static	bool	m_bUseSecureIdent;
	// mobilemule
	static	TCHAR	m_sMMPassword[256];
	static	bool	m_bMMEnabled;
	static	uint16	m_nMMPort;

	static	bool	networkkademlia;
	static	bool	networked2k;

	// toolbar
	static	EToolbarLabelType m_nToolbarLabels;
	static	CString	m_sToolbarBitmap;
	static	CString	m_sToolbarBitmapFolder;
	static	CString	m_sToolbarSettings;
	static	bool	m_bReBarToolbar;
	static	CSize	m_sizToolbarIconSize;

	//preview
	static	bool	m_bPreviewEnabled;

	// ZZ:UploadSpeedSense -->
	static	bool	m_bDynUpEnabled;
	static	int		m_iDynUpPingTolerance;
	static	int		m_iDynUpGoingUpDivider;
	static	int		m_iDynUpGoingDownDivider;
	static	int		m_iDynUpNumberOfPings;
	static  int		m_iDynUpPingToleranceMilliseconds;
	static  bool	m_bDynUpUseMillisecondPingTolerance;
	// ZZ:UploadSpeedSense <--

    static bool     m_bA4AFSaveCpu; // ZZ:DownloadManager

	static	CStringList shareddir_list;
	static	CStringList adresses_list;

	static	int		m_iDbgHeap;
	static	uint8	m_nWebMirrorAlertLevel;
	static	bool	m_bRunAsUser;

	static  bool	m_bUseOldTimeRemaining;

	// PeerCache
	static	uint32	m_uPeerCacheLastSearch;
	static	bool	m_bPeerCacheWasFound;
	static	bool	m_bPeerCacheEnabled;
	static	uint16	m_nPeerCachePort;
	static	bool	m_bPeerCacheShow;

	// Firewall settings
	static bool		m_bOpenPortsOnStartUp;

	//AICH Options
	static bool		m_bTrustEveryHash;

	static uint8	m_byLogLevel;

	enum Table
	{
		tableDownload, 
		tableUpload, 
		tableQueue, 
		tableSearch,
		tableShared, 
		tableServer, 
		tableClientList,
		tableFilenames
	};

	friend class CPreferencesWnd;
	friend class CPPgGeneral;
	friend class CPPgConnection;
	friend class CPPgServer;
	friend class CPPgDirectories;
	friend class CPPgFiles;
	friend class CPPgNotify;
	friend class CPPgIRC;
	friend class Wizard;
	friend class CPPgTweaks;
	friend class CPPgDisplay;
	friend class CPPgSecurity;
	friend class CPPgScheduler;
	friend class CPPgDebug;

	CPreferences();
	~CPreferences();

	static	void	Init();
	static	void	Uninit();

	static	const CString& GetAppDir()				{return appdir;}
	static	LPCTSTR GetIncomingDir()				{return incomingdir;}
	static	LPCTSTR GetTempDir()					{return tempdir;}
	static	const CString& GetConfigDir()			{return configdir;}
	static	const CString& GetWebServerDir()		{return m_strWebServerDir;}
	static	const CString& GetFileCommentsFilePath(){return m_strFileCommentsFilePath;}
	static	const CString& GetLogDir()				{return m_strLogDir;}

	static	bool	IsTempFile(const CString& rstrDirectory, const CString& rstrName);
	static	bool	IsConfigFile(const CString& rstrDirectory, const CString& rstrName);
	static	bool	IsShareableDirectory(const CString& rstrDirectory);
	static	bool	IsInstallationDirectory(const CString& rstrDir);

	static	bool	Save();
	static	void	SaveCats();

	static	uint8	Score()							{return scorsystem;}
	static	bool	Reconnect()						{return reconnect;}
	static	const CString& GetUserNick()			{return strNick;}
	static	void	SetUserNick(LPCTSTR pszNick);
	static	int		GetMaxUserNickLength()			{return 50;}

	static	uint16	GetPort()		{return port;}
	static	uint16	GetUDPPort()	{return udpport;}
	static	uint16	GetServerUDPPort(){return nServerUDPPort;}
	static	uchar*	GetUserHash()	{return userhash;}
	// ZZ:UploadSpeedSense -->
	static	uint16	GetMinUpload()	{return minupload;}
	// ZZ:UploadSpeedSense <--
	static	uint16	GetMaxUpload()	{return maxupload;}
	static	bool	IsICHEnabled()	{return ICH;}
	static	bool	AutoServerlist(){return autoserverlist;}
	static	bool	UpdateNotify()	{return updatenotify;}
	static	bool	DoMinToTray()	{return mintotray;}
	static	bool	DoAutoConnect() {return autoconnect;}
	static	void	SetAutoConnect( bool inautoconnect) {autoconnect = inautoconnect;}
	static	bool	AddServersFromServer()		{return addserversfromserver;}
	static	bool	AddServersFromClient()		{return addserversfromclient;}
	static	uint8*	GetMinTrayPTR() {return &mintotray;}
	static	uint16	GetTrafficOMeterInterval() { return trafficOMeterInterval;}
	static	void	SetTrafficOMeterInterval(uint16 in) { trafficOMeterInterval=in;}
	static	uint16	GetStatsInterval() { return statsInterval;}
	static	void	SetStatsInterval(uint16 in) { statsInterval=in;}
	static	void	Add2TotalDownloaded(uint64 in) {totalDownloadedBytes+=in;}
	static	void	Add2TotalUploaded(uint64 in) {totalUploadedBytes+=in;}

	// -khaos--+++> Many, many, many, many methods.
	static	void	SaveStats(int bBackUp = 0);
	static	void	SetRecordStructMembers();
	static	void	SaveCompletedDownloadsStat();
	static	bool	LoadStats(int loadBackUp = 0);
	static	void	ResetCumulativeStatistics();

	//		Functions from base code that update original cumulative stats, now obsolete. (KHAOS)
	//void	Add2TotalDownloaded(uint64 in) {totalDownloadedBytes+=in;}
	//void	Add2TotalUploaded(uint64 in) {totalUploadedBytes+=in;}
	//		End functions from base code.

	//		Add to, increment and replace functions.  They're all named Add2 for the sake of some kind of naming
	//		convention.
	static	void	Add2DownCompletedFiles()			{ cumDownCompletedFiles++; }
	static	void	SetConnMaxAvgDownRate(float in)		{ cumConnMaxAvgDownRate = in; }
	static	void	SetConnMaxDownRate(float in)		{ cumConnMaxDownRate = in; }
	static	void	SetConnAvgUpRate(float in)			{ cumConnAvgUpRate = in; }
	static	void	SetConnMaxAvgUpRate(float in)		{ cumConnMaxAvgUpRate = in; }
	static	void	SetConnMaxUpRate(float in)			{ cumConnMaxUpRate = in; }
	static	void	SetConnPeakConnections(int in)		{ cumConnPeakConnections = in; }
	static	void	SetUpAvgTime(int in)				{ cumUpAvgTime = in; }
	static	void	Add2DownSAvgTime(int in)			{ sesDownAvgTime += in; }
	static	void	SetDownCAvgTime(int in)				{ cumDownAvgTime = in; }
	static	void	Add2ConnTransferTime(int in)		{ cumConnTransferTime += in; }
	static	void	Add2ConnDownloadTime(int in)		{ cumConnDownloadTime += in; }
	static	void	Add2ConnUploadTime(int in)			{ cumConnUploadTime += in; }
	static	void	Add2DownSessionCompletedFiles()		{ sesDownCompletedFiles++; }
	static	void	Add2SessionTransferData				(UINT uClientID, UINT uClientPort, BOOL bFromPF, BOOL bUpDown, uint32 bytes, bool sentToFriend = false);
	static	void	Add2DownSuccessfulSessions()		{ sesDownSuccessfulSessions++;
														  cumDownSuccessfulSessions++; }
	static	void	Add2DownFailedSessions()			{ sesDownFailedSessions++;
														  cumDownFailedSessions++; }
	static	void	Add2LostFromCorruption(uint64 in)	{ sesLostFromCorruption += in;}
	static	void	Add2SavedFromCompression(uint64 in) { sesSavedFromCompression += in;}
	static	void	Add2SessionPartsSavedByICH(int in)	{ sesPartsSavedByICH += in;}

	//		Functions that return stats stuff...
	//		Saved stats for cumulative downline overhead
	static	uint64	GetDownOverheadTotal()			{ return cumDownOverheadTotal;}
	static	uint64	GetDownOverheadFileReq()		{ return cumDownOverheadFileReq;}
	static	uint64	GetDownOverheadSrcEx()			{ return cumDownOverheadSrcEx;}
	static	uint64	GetDownOverheadServer()			{ return cumDownOverheadServer;}
	static	uint64	GetDownOverheadKad()			{ return cumDownOverheadKad;}
	static	uint64	GetDownOverheadTotalPackets()	{ return cumDownOverheadTotalPackets;}
	static	uint64	GetDownOverheadFileReqPackets() { return cumDownOverheadFileReqPackets;}
	static	uint64	GetDownOverheadSrcExPackets()	{ return cumDownOverheadSrcExPackets;}
	static	uint64	GetDownOverheadServerPackets()	{ return cumDownOverheadServerPackets;}
	static	uint64	GetDownOverheadKadPackets()		{ return cumDownOverheadKadPackets;}

	//		Saved stats for cumulative upline overhead
	static	uint64	GetUpOverheadTotal()			{ return cumUpOverheadTotal;}
	static	uint64	GetUpOverheadFileReq()			{ return cumUpOverheadFileReq;}
	static	uint64	GetUpOverheadSrcEx()			{ return cumUpOverheadSrcEx;}
	static	uint64	GetUpOverheadServer()			{ return cumUpOverheadServer;}
	static	uint64	GetUpOverheadKad()				{ return cumUpOverheadKad;}
	static	uint64	GetUpOverheadTotalPackets()		{ return cumUpOverheadTotalPackets;}
	static	uint64	GetUpOverheadFileReqPackets()	{ return cumUpOverheadFileReqPackets;}
	static	uint64	GetUpOverheadSrcExPackets()		{ return cumUpOverheadSrcExPackets;}
	static	uint64	GetUpOverheadServerPackets()	{ return cumUpOverheadServerPackets;}
	static	uint64	GetUpOverheadKadPackets()		{ return cumUpOverheadKadPackets;}

	//		Saved stats for cumulative upline data
	static	uint32	GetUpSuccessfulSessions()		{ return cumUpSuccessfulSessions;}
	static	uint32	GetUpFailedSessions()			{ return cumUpFailedSessions;}
	static	uint32	GetUpAvgTime()					{ return cumUpAvgTime;}

	//		Saved stats for cumulative downline data
	static	uint32	GetDownCompletedFiles()			{ return cumDownCompletedFiles;}
	static	uint32	GetDownC_SuccessfulSessions()	{ return cumDownSuccessfulSessions;}
	static	uint32	GetDownC_FailedSessions()		{ return cumDownFailedSessions;}
	static	uint32	GetDownC_AvgTime()				{ return cumDownAvgTime;}
	//		Session download stats
	static	uint32	GetDownSessionCompletedFiles()	{ return sesDownCompletedFiles;}
	static	uint32	GetDownS_SuccessfulSessions()	{ return sesDownSuccessfulSessions;}
	static	uint32	GetDownS_FailedSessions()		{ return sesDownFailedSessions;}
	static	uint32	GetDownS_AvgTime()				{ return GetDownS_SuccessfulSessions()?sesDownAvgTime/GetDownS_SuccessfulSessions():0;}

	//		Saved stats for corruption/compression
	static	uint64	GetCumLostFromCorruption()			{ return cumLostFromCorruption;}
	static	uint64	GetCumSavedFromCompression()		{ return cumSavedFromCompression;}
	static	uint64	GetSesLostFromCorruption()			{ return sesLostFromCorruption;}
	static	uint64	GetSesSavedFromCompression()		{ return sesSavedFromCompression;}
	static	uint32	GetCumPartsSavedByICH()				{ return cumPartsSavedByICH;}
	static	uint32	GetSesPartsSavedByICH()				{ return sesPartsSavedByICH;}

	// Cumulative client breakdown stats for sent bytes
	static	uint64	GetUpTotalClientData()			{ return   GetCumUpData_EDONKEY()
															 + GetCumUpData_EDONKEYHYBRID()
															 + GetCumUpData_EMULE()
															 + GetCumUpData_MLDONKEY()
															 + GetCumUpData_AMULE()
															 + GetCumUpData_EMULECOMPAT()
															 + GetCumUpData_SHAREAZA(); }
	static	uint64	GetCumUpData_EDONKEY()			{ return (cumUpData_EDONKEY +		sesUpData_EDONKEY );}
	static	uint64	GetCumUpData_EDONKEYHYBRID()	{ return (cumUpData_EDONKEYHYBRID +	sesUpData_EDONKEYHYBRID );}
	static	uint64	GetCumUpData_EMULE()			{ return (cumUpData_EMULE +			sesUpData_EMULE );}
	static	uint64	GetCumUpData_MLDONKEY()			{ return (cumUpData_MLDONKEY +		sesUpData_MLDONKEY );}
	static	uint64	GetCumUpData_AMULE()			{ return (cumUpData_AMULE +			sesUpData_AMULE );}
	static	uint64	GetCumUpData_EMULECOMPAT()		{ return (cumUpData_EMULECOMPAT +	sesUpData_EMULECOMPAT );}
	static	uint64	GetCumUpData_SHAREAZA()			{ return (cumUpData_SHAREAZA +		sesUpData_SHAREAZA );}
	// Session client breakdown stats for sent bytes
	static	uint64	GetUpSessionClientData()		{ return   sesUpData_EDONKEY 
															 + sesUpData_EDONKEYHYBRID 
															 + sesUpData_EMULE 
															 + sesUpData_MLDONKEY 
															 + sesUpData_AMULE
															 + sesUpData_EMULECOMPAT
															 + sesUpData_SHAREAZA; }
	static	uint64	GetUpData_EDONKEY()				{ return sesUpData_EDONKEY;}
	static	uint64	GetUpData_EDONKEYHYBRID()		{ return sesUpData_EDONKEYHYBRID;}
	static	uint64	GetUpData_EMULE()				{ return sesUpData_EMULE;}
	static	uint64	GetUpData_MLDONKEY()			{ return sesUpData_MLDONKEY;}
	static	uint64	GetUpData_AMULE()				{ return sesUpData_AMULE;}
	static	uint64	GetUpData_EMULECOMPAT()			{ return sesUpData_EMULECOMPAT;}
	static	uint64	GetUpData_SHAREAZA()			{ return sesUpData_SHAREAZA;}

	// Cumulative port breakdown stats for sent bytes...
	static	uint64	GetUpTotalPortData()			{ return   GetCumUpDataPort_4662() 
															 + GetCumUpDataPort_OTHER()
															 + GetCumUpDataPort_PeerCache(); }
	static	uint64	GetCumUpDataPort_4662()			{ return (cumUpDataPort_4662 +		sesUpDataPort_4662 );}
	static	uint64	GetCumUpDataPort_OTHER()		{ return (cumUpDataPort_OTHER +		sesUpDataPort_OTHER );}
	static	uint64	GetCumUpDataPort_PeerCache()	{ return (cumUpDataPort_PeerCache +	sesUpDataPort_PeerCache );}

	// Session port breakdown stats for sent bytes...
	static	uint64	GetUpSessionPortData()			{ return   sesUpDataPort_4662 
															 + sesUpDataPort_OTHER
															 + sesUpDataPort_PeerCache; }
	static	uint64	GetUpDataPort_4662()			{ return sesUpDataPort_4662; }
	static	uint64	GetUpDataPort_OTHER()			{ return sesUpDataPort_OTHER; }
	static	uint64	GetUpDataPort_PeerCache()		{ return sesUpDataPort_PeerCache; }

	// Cumulative DS breakdown stats for sent bytes...
	static	uint64	GetUpTotalDataFile()			{ return (GetCumUpData_File() +		GetCumUpData_Partfile() );}
	static	uint64	GetCumUpData_File()				{ return (cumUpData_File +			sesUpData_File );}
	static	uint64	GetCumUpData_Partfile()			{ return (sesUpData_Partfile +		sesUpData_Partfile );}
	// Session DS breakdown stats for sent bytes...
	static	uint64	GetUpSessionDataFile()			{ return (sesUpData_File +			sesUpData_Partfile );}
	static	uint64	GetUpData_File()				{ return sesUpData_File;}
	static	uint64	GetUpData_Partfile()			{ return sesUpData_Partfile;}

	// Cumulative client breakdown stats for received bytes
	static	uint64	GetDownTotalClientData()		{ return   GetCumDownData_EDONKEY() 
															 + GetCumDownData_EDONKEYHYBRID() 
															 + GetCumDownData_EMULE() 
															 + GetCumDownData_MLDONKEY() 
															 + GetCumDownData_AMULE()
															 + GetCumDownData_EMULECOMPAT()
															 + GetCumDownData_SHAREAZA()
// RT, WebCache (Code by JP/yonatan/Superlexx)
															 + GetCumDownData_WEBCACHE()
// End
															 + GetCumDownData_URL(); }
	static	uint64	GetCumDownData_EDONKEY()		{ return (cumDownData_EDONKEY +			sesDownData_EDONKEY);}
	static	uint64	GetCumDownData_EDONKEYHYBRID()	{ return (cumDownData_EDONKEYHYBRID +	sesDownData_EDONKEYHYBRID);}
	static	uint64	GetCumDownData_EMULE()			{ return (cumDownData_EMULE +			sesDownData_EMULE);}
	static	uint64	GetCumDownData_MLDONKEY()		{ return (cumDownData_MLDONKEY +		sesDownData_MLDONKEY);}
	static	uint64	GetCumDownData_AMULE()			{ return (cumDownData_AMULE +			sesDownData_AMULE);}
	static	uint64	GetCumDownData_EMULECOMPAT()	{ return (cumDownData_EMULECOMPAT +		sesDownData_EMULECOMPAT);}
	static	uint64	GetCumDownData_SHAREAZA()		{ return (cumDownData_SHAREAZA +		sesDownData_SHAREAZA);}
	static	uint64	GetCumDownData_URL()			{ return (cumDownData_URL +				sesDownData_URL);}
	// Session client breakdown stats for received bytes
	static	uint64	GetDownSessionClientData()		{ return   sesDownData_EDONKEY 
															 + sesDownData_EDONKEYHYBRID 
															 + sesDownData_EMULE 
															 + sesDownData_MLDONKEY 
															 + sesDownData_AMULE
															 + sesDownData_EMULECOMPAT
															 + sesDownData_SHAREAZA
// RT, WebCache (Code by JP/yonatan/Superlexx)
															 + sesDownData_WEBCACHE
// End
															 + sesDownData_URL; }
	static	uint64	GetDownData_EDONKEY()			{ return sesDownData_EDONKEY;}
	static	uint64	GetDownData_EDONKEYHYBRID()		{ return sesDownData_EDONKEYHYBRID;}
	static	uint64	GetDownData_EMULE()				{ return sesDownData_EMULE;}
	static	uint64	GetDownData_MLDONKEY()			{ return sesDownData_MLDONKEY;}
	static	uint64	GetDownData_AMULE()				{ return sesDownData_AMULE;}
	static	uint64	GetDownData_EMULECOMPAT()		{ return sesDownData_EMULECOMPAT;}
	static	uint64	GetDownData_SHAREAZA()			{ return sesDownData_SHAREAZA;}
	static	uint64	GetDownData_URL()				{ return sesDownData_URL;}

	// Cumulative port breakdown stats for received bytes...
	static	uint64	GetDownTotalPortData()			{ return   GetCumDownDataPort_4662() 
															 + GetCumDownDataPort_OTHER()
															 + GetCumDownDataPort_PeerCache(); }
	static	uint64	GetCumDownDataPort_4662()		{ return cumDownDataPort_4662		+ sesDownDataPort_4662; }
	static	uint64	GetCumDownDataPort_OTHER()		{ return cumDownDataPort_OTHER		+ sesDownDataPort_OTHER; }
	static	uint64	GetCumDownDataPort_PeerCache()	{ return cumDownDataPort_PeerCache	+ sesDownDataPort_PeerCache; }

	// Session port breakdown stats for received bytes...
	static	uint64	GetDownSessionDataPort()		{ return   sesDownDataPort_4662 
															 + sesDownDataPort_OTHER
															 + sesDownDataPort_PeerCache; }
	static	uint64	GetDownDataPort_4662()			{ return sesDownDataPort_4662; }
	static	uint64	GetDownDataPort_OTHER()			{ return sesDownDataPort_OTHER; }
	static	uint64	GetDownDataPort_PeerCache()		{ return sesDownDataPort_PeerCache; }

	//		Saved stats for cumulative connection data
	static	float	GetConnAvgDownRate()			{ return cumConnAvgDownRate;}
	static	float	GetConnMaxAvgDownRate()			{ return cumConnMaxAvgDownRate;}
	static	float	GetConnMaxDownRate()			{ return cumConnMaxDownRate;}
	static	float	GetConnAvgUpRate()				{ return cumConnAvgUpRate;}
	static	float	GetConnMaxAvgUpRate()			{ return cumConnMaxAvgUpRate;}
	static	float	GetConnMaxUpRate()				{ return cumConnMaxUpRate;}
	static	uint64	GetConnRunTime()				{ return cumConnRunTime;}
	static	uint32	GetConnNumReconnects()			{ return cumConnNumReconnects;}
	static	uint32	GetConnAvgConnections()			{ return cumConnAvgConnections;}
	static	uint32	GetConnMaxConnLimitReached()	{ return cumConnMaxConnLimitReached;}
	static	uint32	GetConnPeakConnections()		{ return cumConnPeakConnections;}
	static	uint32	GetConnTransferTime()			{ return cumConnTransferTime;}
	static	uint32	GetConnDownloadTime()			{ return cumConnDownloadTime;}
	static	uint32	GetConnUploadTime()				{ return cumConnUploadTime;}
	static	uint32	GetConnServerDuration()			{ return cumConnServerDuration;}

	//		Saved records for servers / network
	static	uint32	GetSrvrsMostWorkingServers()	{ return cumSrvrsMostWorkingServers;}
	static	uint32	GetSrvrsMostUsersOnline()		{ return cumSrvrsMostUsersOnline;}
	static	uint32	GetSrvrsMostFilesAvail()		{ return cumSrvrsMostFilesAvail;}

	//		Saved records for shared files
	static	uint32	GetSharedMostFilesShared()		{ return cumSharedMostFilesShared;}
	static	uint64	GetSharedLargestShareSize()		{ return cumSharedLargestShareSize;}
	static	uint64	GetSharedLargestAvgFileSize()	{ return cumSharedLargestAvgFileSize;}
	static	uint64	GetSharedLargestFileSize()		{ return cumSharedLargestFileSize;}

	//		Get the long date/time when the stats were last reset
	static	__int64 GetStatsLastResetLng()			{ return stat_datetimeLastReset;}
	static	CString GetStatsLastResetStr(bool formatLong = true);
	static	UINT	GetStatsSaveInterval()			{ return statsSaveInterval; }

	//		Get and Set our new preferences
	static	void	SetStatsMax(uint16 in)						{ statsMax = in; }
	static	void	SetStatsConnectionsGraphRatio(uint8 in)		{ statsConnectionsGraphRatio = in; }
	static	uint8	GetStatsConnectionsGraphRatio()				{ return statsConnectionsGraphRatio; }
	static	void	SetExpandedTreeItems(CString in)			{ _stprintf(statsExpandedTreeItems,_T("%s"),in); }
	static	CString GetExpandedTreeItems()						{ return statsExpandedTreeItems; }
	// <-----khaos- End Statistics Methods

	//		Original Statistics Functions
	static	uint64	GetTotalDownloaded()		{return totalDownloadedBytes;}
	static	uint64	GetTotalUploaded()			{return totalUploadedBytes;}
	//		End Original Statistics Functions
	static	bool	IsErrorBeepEnabled()		{return beepOnError;}
	static	bool	IsConfirmExitEnabled()		{return confirmExit;}
	static	bool	UseSplashScreen()			{return splashscreen;}
	static	bool	FilterLANIPs()				{return filterLANIPs;}
	static	bool	GetAllowLocalHostIP()		{return m_bAllocLocalHostIP;}
	static	bool	IsOnlineSignatureEnabled()	{return onlineSig;}
	static	int		GetMaxGraphUploadRate()		{return maxGraphUploadRate;}
	static	int		GetMaxGraphDownloadRate()		{return maxGraphDownloadRate;}
	static	void	SetMaxGraphUploadRate(int in)	{maxGraphUploadRate	=(in)?in:16;}
	static	void	SetMaxGraphDownloadRate(int in) {maxGraphDownloadRate=(in)?in:96;}

	static	uint16	GetMaxDownload();
	static	uint64	GetMaxDownloadInBytesPerSec(bool dynamic = false);
	static	uint16	GetMaxConnections()			{return maxconnections;}
	static	uint16	GetMaxHalfConnections()		{return maxhalfconnections;}
	static	uint16	GetMaxSourcePerFile()		{return maxsourceperfile;}
	static	uint16	GetMaxSourcePerFileSoft();
	static	uint16	GetMaxSourcePerFileUDP();
	static	uint16	GetDeadserverRetries()		{return deadserverretries;}
	static	DWORD	GetServerKeepAliveTimeout() {return m_dwServerKeepAliveTimeout;}

	static	int		GetColumnWidth (Table t, int index);
	static	BOOL	GetColumnHidden(Table t, int index);
	static	int		GetColumnOrder (Table t, int index);
	static	void	SetColumnWidth (Table t, int index, int width);
	static	void	SetColumnHidden(Table t, int index, BOOL bHidden);
	static	void	SetColumnOrder (Table t, INT *piOrder);

	// Barry - Provide a mechanism for all tables to store/retrieve sort order
	static	int		GetColumnSortItem (Table t);
	static	bool	GetColumnSortAscending (Table t);
	static	void	SetColumnSortItem (Table t, int sortItem);
	static	void	SetColumnSortAscending (Table t, bool sortAscending);

	static	WORD	GetLanguageID();
	static	void	SetLanguageID(WORD lid);
	static	void	GetLanguages(CWordArray& aLanguageIDs);
	static	void	SetLanguage();
	static	const CString& GetLangDir()					{return m_strLangDir;}
	static	bool	IsLanguageSupported(LANGID lidSelected, bool bUpdateBefore);
	static	CString GetLangDLLNameByID(LANGID lidSelected);
	static	void	InitThreadLocale();
	static	void	SetRtlLocale(LCID lcid);
	static	CString GetHtmlCharset();

	static	uint8	IsDoubleClickEnabled()				{return transferDoubleclick;}
	static	EViewSharedFilesAccess CanSeeShares(void) {return m_iSeeShares;}
	static	uint8	GetToolTipDelay(void)				{return m_iToolDelayTime;}
	static	uint8	IsBringToFront()					{return bringtoforeground;}

	static	uint8	GetSplitterbarPosition()			{return splitterbarPosition;}
	static	void	SetSplitterbarPosition(uint8 pos)	{splitterbarPosition=pos;}
	static	uint8	GetTransferWnd2()					{return m_uTransferWnd2;}
	static	void	SetTransferWnd2(uint8 uWnd2)		{m_uTransferWnd2 = uWnd2;}
	//MORPH START - Added by SiRoB, Splitting Bar [O]
	static	uint8   GetSplitterbarPositionStat()	{return splitterbarPositionStat;}
	static	void	SetSplitterbarPositionStat(uint8 pos) {splitterbarPositionStat=pos;}
	static	uint8   GetSplitterbarPositionStat_HL()	{return splitterbarPositionStat_HL;}
	static	void	SetSplitterbarPositionStat_HL(uint8 pos) {splitterbarPositionStat_HL=pos;}
	static	uint8   GetSplitterbarPositionStat_HR()	{return splitterbarPositionStat_HR;}
	static	void	SetSplitterbarPositionStat_HR(uint8 pos) {splitterbarPositionStat_HR=pos;}
	static	uint16   GetSplitterbarPositionFriend()	{return splitterbarPositionFriend;}
	static	void	SetSplitterbarPositionFriend(uint16 pos) {splitterbarPositionFriend=pos;}
	static	uint16  GetSplitterbarPositionIRC()	{return splitterbarPositionIRC;}
	static	void	SetSplitterbarPositionIRC(uint16 pos) {splitterbarPositionIRC=pos;}
	//MORPH END   - Added by SiRoB, Splitting Bar [O]
	// -khaos--+++> Changed datatype to avoid overflows
	static	uint16	GetStatsMax()						{return statsMax;}
	// <-----khaos-
	static	uint8	UseFlatBar()						{return (depth3D==0);}
	static	int		GetStraightWindowStyles()			{return m_iStraightWindowStyles;}

	static	const CString& GetSkinProfile()				{return m_strSkinProfile;}
	static	void	SetSkinProfile(LPCTSTR pszProfile)	{m_strSkinProfile = pszProfile; }

	static	const CString& GetSkinProfileDir()			{return m_strSkinProfileDir;}
	static	void	SetSkinProfileDir(LPCTSTR pszDir)	{m_strSkinProfileDir = pszDir; }

	static	uint8	GetStatsAverageMinutes()			{return statsAverageMinutes;}
	static	void	SetStatsAverageMinutes(uint8 in)	{statsAverageMinutes=in;}

	static	bool	GetUseDownloadNotifier()			{return useDownloadNotifier;}
	static	bool	GetUseNewDownloadNotifier()			{return useNewDownloadNotifier;}
	static	bool	GetUseChatNotifier()				{return useChatNotifier;}
	static	bool	GetUseLogNotifier()					{return useLogNotifier;}
	static	bool	GetUseSoundInNotifier()				{return useSoundInNotifier;}
	static	bool	GetNotifierPopsEveryChatMsg()		{return notifierPopsEveryChatMsg;}
	static	bool	GetNotifierPopOnImportantError()	{return notifierImportantError;}
	static	bool	GetNotifierPopOnNewVersion()		{return notifierNewVersion;}
	static	TCHAR*	GetNotifierWavSoundPath()			{return notifierSoundFilePath;}
	static	bool	GetEnableMiniMule()					{return m_bEnableMiniMule;}

	static	CString GetIRCNick()						{return m_sircnick;}
	static	void	SetIRCNick( TCHAR in_nick[] )		{ _tcscpy(m_sircnick,in_nick);}
	static	CString GetIRCServer()						{return m_sircserver;}
	static	bool	GetIRCAddTimestamp()				{return m_bircaddtimestamp;}
	static	CString GetIRCChanNameFilter()				{return m_sircchannamefilter;}
	static	bool	GetIRCUseChanFilter()				{return m_bircusechanfilter;}
	static	uint16	GetIRCChannelUserFilter()			{return m_iircchanneluserfilter;}
	static	CString GetIrcPerformString()				{return m_sircperformstring;}
	static	bool	GetIrcUsePerform()					{return m_bircuseperform;}
	static	bool	GetIRCListOnConnect()				{return m_birclistonconnect;}
	static	bool	GetIrcAcceptLinks()					{return m_bircacceptlinks;}
	static	bool	GetIrcAcceptLinksFriends()			{return m_bircacceptlinksfriends;}
	static	bool	GetIrcSoundEvents()					{return m_bircsoundevents;}
	static	bool	GetIrcIgnoreMiscMessage()			{return m_bircignoremiscmessage;}
	static	bool	GetIrcIgnoreJoinMessage()			{return m_bircignorejoinmessage;}
	static	bool	GetIrcIgnorePartMessage()			{return m_bircignorepartmessage;}
	static	bool	GetIrcIgnoreQuitMessage()			{return m_bircignorequitmessage;}
	static	bool	GetIrcIgnoreEmuleProtoAddFriend()	{return m_bircignoreemuleprotoaddfriend;}
	static	bool	GetIrcAllowEmuleProtoAddFriend()	{return m_bircallowemuleprotoaddfriend;}
	static	bool	GetIrcIgnoreEmuleProtoSendLink()	{return m_bircignoreemuleprotosendlink;}
	static	bool	GetIrcHelpChannel()					{return m_birchelpchannel;}
	static	WORD	GetWindowsVersion();
	static	bool	GetStartMinimized()					{return startMinimized;}
	static	void	SetStartMinimized( bool instartMinimized) {startMinimized = instartMinimized;}
	static	bool	GetAutoStart()						{return m_bAutoStart;}
	static	void	SetAutoStart( bool val)				{m_bAutoStart = val;}

	static	bool	GetRestoreLastMainWndDlg()			{return m_bRestoreLastMainWndDlg;}
	static	int		GetLastMainWndDlgID()				{return m_iLastMainWndDlgID;}
	static	void	SetLastMainWndDlgID(int iID)		{m_iLastMainWndDlgID = iID;}

	static	bool	GetRestoreLastLogPane()				{return m_bRestoreLastLogPane;}
	static	int		GetLastLogPaneID()					{return m_iLastLogPaneID;}
	static	void	SetLastLogPaneID(int iID)			{m_iLastLogPaneID = iID;}

	static	bool	GetSmartIdCheck()					{return smartidcheck;}
	static	void	SetSmartIdCheck(bool in_smartidcheck) {smartidcheck = in_smartidcheck;}
	static	uint8	GetSmartIdState()					{return smartidstate;}
	static	void	SetSmartIdState(uint8 in_smartidstate) {smartidstate = in_smartidstate;}
	static	bool	GetPreviewPrio()					{return m_bpreviewprio;}
	static	void	SetPreviewPrio(bool in)				{m_bpreviewprio=in;}
	static	bool	GetUpdateQueueList()				{return m_bupdatequeuelist;}
	static	bool	GetManualHighPrio()					{return m_bmanualhighprio;}
	static	bool	TransferFullChunks()				{return m_btransferfullchunks;}
	static	void	SetTransferFullChunks( bool m_bintransferfullchunks )				{m_btransferfullchunks = m_bintransferfullchunks;}
	static	int		StartNextFile()						{return m_istartnextfile;}
	static	bool	ShowOverhead()						{return m_bshowoverhead;}
	static	void	SetNewAutoUp(bool m_bInUAP)			{m_bUAP = m_bInUAP;}
	static	bool	GetNewAutoUp()						{return m_bUAP;}
	static	void	SetNewAutoDown(bool m_bInDAP)		{m_bDAP = m_bInDAP;}
	static	bool	GetNewAutoDown()					{return m_bDAP;}
	static	bool	IsKnownClientListDisabled()			{return m_bDisableKnownClientList;}
	static	bool	IsQueueListDisabled()				{return m_bDisableQueueList;}
	static	bool	IsFirstStart()						{return m_bFirstStart;}
	static	bool	UseCreditSystem()					{return m_bCreditSystem;}
	static	void	SetCreditSystem(bool m_bInCreditSystem) {m_bCreditSystem = m_bInCreditSystem;}

	static	TCHAR*	GetTxtEditor()						{return TxtEditor;}
	static	CString	GetVideoPlayer()					{if (_tcslen(VideoPlayer)==0) return _T(""); else return CString(VideoPlayer);}

	static	UINT	GetFileBufferSize()					{return m_iFileBufferSize;}
	static	UINT	GetQueueSize()						{return m_iQueueSize;}
	static	int		GetCommitFiles()					{return m_iCommitFiles;}
	static	bool	GetShowCopyEd2kLinkCmd()			{return m_bShowCopyEd2kLinkCmd;}

	// Barry
	static	uint16	Get3DDepth() { return depth3D;}
	static	bool	AutoTakeED2KLinks() {return autotakeed2klinks;}
	static	bool	AddNewFilesPaused() {return addnewfilespaused;}

	static	bool	TransferlistRemainSortStyle()	{ return m_bTransflstRemain;}
	static	void	TransferlistRemainSortStyle(bool in)	{ m_bTransflstRemain=in;}

	static	DWORD	GetStatsColor(int index)			{return m_adwStatsColors[index];}
	static	void	SetStatsColor(int index, DWORD value){m_adwStatsColors[index] = value;}
	static	int		GetNumStatsColors()					{return ARRSIZE(m_adwStatsColors);}
	static	void	GetAllStatsColors(int iCount, LPDWORD pdwColors);
	static	bool	SetAllStatsColors(int iCount, const DWORD* pdwColors);
	static	void	ResetStatsColor(int index);

	static	void	SetMaxConsPerFive(int in)			{MaxConperFive=in;}
	static	LPLOGFONT GetHyperTextLogFont()				{return &m_lfHyperText;}
	static	void	SetHyperTextFont(LPLOGFONT plf)		{m_lfHyperText = *plf;}
	static	LPLOGFONT GetLogFont()						{return &m_lfLogText;}
	static	void	SetLogFont(LPLOGFONT plf)			{m_lfLogText = *plf;}
	static	COLORREF GetLogErrorColor()					{return m_crLogError;}
	static	COLORREF GetLogWarningColor()				{return m_crLogWarning;}
	static	COLORREF GetLogSuccessColor()				{return m_crLogSuccess;}

	static	uint16	GetMaxConperFive()					{return MaxConperFive;}
	static	uint16	GetDefaultMaxConperFive();

	static	bool	IsSafeServerConnectEnabled()		{return safeServerConnect;}
	static	void	SetSafeServerConnectEnabled(bool in){safeServerConnect=in;}
	static	bool	IsMoviePreviewBackup()				{return moviePreviewBackup;}
	static	int		GetPreviewSmallBlocks()				{return m_iPreviewSmallBlocks;}
	static	int		GetPreviewCopiedArchives()			{return m_iPreviewCopiedArchives;}
	static	int		GetInspectAllFileTypes()			{return m_iInspectAllFileTypes;}
	static	int		GetExtractMetaData()				{return m_iExtractMetaData;}
	static	bool	GetAdjustNTFSDaylightFileTime()		{return m_bAdjustNTFSDaylightFileTime;}

	static	const CString& GetYourHostname()			{return m_strYourHostname;}
	static	void	SetYourHostname(LPCTSTR pszHostname){m_strYourHostname = pszHostname;}
	static	bool	IsCheckDiskspaceEnabled()			{return checkDiskspace != 0;}	// SLUGFILLER: checkDiskspace
	static	UINT	GetMinFreeDiskSpace()				{return m_uMinFreeDiskSpace;}
	static	bool	GetSparsePartFiles()				{return m_bSparsePartFiles;}
	static	void	SetSparsePartFiles(bool bEnable)	{m_bSparsePartFiles = bEnable;}

	static	void	SetMaxUpload(uint16 in);
	static	void	SetMaxDownload(uint16 in);

	static	WINDOWPLACEMENT GetEmuleWindowPlacement() {return EmuleWindowPlacement; }
	static	void	SetWindowLayout(WINDOWPLACEMENT in) {EmuleWindowPlacement=in; }

	static	uint8	AutoConnectStaticOnly() {return autoconnectstaticonly;}
	static	uint8	GetUpdateDays()			{return versioncheckdays;}
	static	uint32	GetLastVC()				{return versioncheckLastAutomatic;}
	static	void	UpdateLastVC();
	static	int		GetIPFilterLevel()		{ return filterlevel;}
	static	CString GetMessageFilter()		{ return CString(messageFilter);}
	static	const CString& GetCommentFilter(){ return commentFilter; }
	static	CString GetFilenameCleanups()	{ return CString(filenameCleanups);}

	static	bool	ShowRatesOnTitle()		{ return showRatesInTitle;}
	static	TCHAR*	GetNotifierConfiguration()	  {return notifierConfiguration;}; //<<-- enkeyDEV(kei-kun) -skinnable notifier-
	static	void	SetNotifierConfiguration(CString configFullPath) {_stprintf(notifierConfiguration,_T("%s"),configFullPath); } //<<-- enkeyDEV(kei-kun) -skinnable notifier-
	static	void	LoadCats();
	static	CString GetDateTimeFormat()		{ return CString(datetimeformat);}
	static	CString GetDateTimeFormat4Log() { return CString(datetimeformat4log);}

	// Download Categories (Ornis)
// RT, New Code at Above
/* Original
	static	int		AddCat(Category_Struct* cat) { catMap.Add(cat); return catMap.GetCount()-1;}
*/
	static	bool	MoveCat(UINT from, UINT to);
	static	void	RemoveCat(int index);
	static	int		GetCatCount()			{ return catMap.GetCount();}
	static  bool	SetCatFilter(int index, int filter);
	static  int		GetCatFilter(int index);
	static	bool	GetCatFilterNeg(int index);
	static	void	SetCatFilterNeg(int index, bool val);
	static	Category_Struct* GetCategory(int index) { if (index>=0 && index<catMap.GetCount()) return catMap.GetAt(index); else return NULL;}
	static	TCHAR*	GetCatPath(uint8 index) { return catMap.GetAt(index)->incomingpath;}
	static	DWORD	GetCatColor(uint8 index)	{ if (index>=0 && index<catMap.GetCount()) return catMap.GetAt(index)->color; else return 0;}

	static	bool	GetPreviewOnIconDblClk() { return m_bPreviewOnIconDblClk; }
	static	bool	ShowRatingIndicator()	{ return indicateratings;}
	static	bool	WatchClipboard4ED2KLinks()	{ return watchclipboard;}
	static	bool	GetRemoveToBin()			{ return m_bRemove2bin;}
	static	bool	FilterServerByIP()		{ return filterserverbyip;}

	static	bool	GetLog2Disk()							{ return log2disk;}
	static	bool	GetDebug2Disk()							{ return m_bVerbose && debug2disk;}
	static	int		GetMaxLogBuff()							{ return iMaxLogBuff;}
	static	UINT	GetMaxLogFileSize()						{ return uMaxLogFileSize; }

	// WebServer
	static	uint16	GetWSPort()								{ return m_nWebPort; }
	static	void	SetWSPort(uint16 uPort)					{ m_nWebPort=uPort; }
	static	CString GetWSPass()								{ return CString(m_sWebPassword); }
	static	void	SetWSPass(CString strNewPass);
	static	bool	GetWSIsEnabled()						{ return m_bWebEnabled; }
	static	void	SetWSIsEnabled(bool bEnable)			{ m_bWebEnabled=bEnable; }
	static	bool	GetWebUseGzip()							{ return m_bWebUseGzip; }
	static	void	SetWebUseGzip(bool bUse)				{ m_bWebUseGzip=bUse; }
	static	int		GetWebPageRefresh()						{ return m_nWebPageRefresh; }
	static	void	SetWebPageRefresh(int nRefresh)			{ m_nWebPageRefresh=nRefresh; }
	static	bool	GetWSIsLowUserEnabled()					{ return m_bWebLowEnabled; }
	static	void	SetWSIsLowUserEnabled(bool in)			{ m_bWebLowEnabled=in; }
	static	CString GetWSLowPass()							{ return CString(m_sWebLowPassword); }
	static	int		GetWebTimeoutMins()						{ return m_iWebTimeoutMins;}
	static	void	SetWSLowPass(CString strNewPass);

	static	void	SetMaxSourcesPerFile(uint16 in)			{ maxsourceperfile=in;}
	static	void	SetMaxConnections(uint16 in)			{ maxconnections =in;}
	static	void	SetMaxHalfConnections(uint16 in)		{ maxhalfconnections =in;}
	static	bool	IsSchedulerEnabled()					{ return scheduler;}
	static	void	SetSchedulerEnabled(bool in)			{ scheduler=in;}
	static	bool	GetDontCompressAvi()					{ return dontcompressavi;}

	static	bool	MsgOnlyFriends()						{ return msgonlyfriends;}
	static	bool	MsgOnlySecure()							{ return msgsecure;}
	static	uint16	GetMsgSessionsMax()						{ return maxmsgsessions;}
	static	bool	IsSecureIdentEnabled()					{ return m_bUseSecureIdent;} // use clientcredits->CryptoAvailable() to check if crypting is really available and not this function
	static	bool	IsAdvSpamfilterEnabled()				{ return m_bAdvancedSpamfilter;}
	static	CString GetTemplate()							{ return CString(m_sTemplateFile);}
	static	void	SetTemplate(CString in)					{ _stprintf(m_sTemplateFile,_T("%s"),in);}
	static	bool	GetNetworkKademlia()					{ return networkkademlia;}
	static	void	SetNetworkKademlia(bool val);
	static	bool	GetNetworkED2K()						{ return networked2k;}
	static	void	SetNetworkED2K(bool val)				{ networked2k = val;}

	// mobileMule
	static	CString GetMMPass()								{ return CString(m_sMMPassword); }
	static	void	SetMMPass(CString strNewPass);
	static	bool	IsMMServerEnabled()						{ return m_bMMEnabled; }
	static	void	SetMMIsEnabled(bool bEnable)			{ m_bMMEnabled=bEnable; }
	static	uint16	GetMMPort()								{ return m_nMMPort; }
	static	void	SetMMPort(uint16 uPort)					{ m_nMMPort=uPort; }

	// deadlake PROXYSUPPORT
	static	const ProxySettings& GetProxy()					{ return proxy; }
	static	void	SetProxySettings(const ProxySettings& proxysettings) { proxy = proxysettings; }
	static	uint16	GetListenPort()							{ if (m_UseProxyListenPort) return ListenPort; else return port; }
	static	void	SetListenPort(uint16 uPort)				{ ListenPort = uPort; m_UseProxyListenPort = true; }
	static	void	ResetListenPort()						{ ListenPort = 0; m_UseProxyListenPort = false; }
	static	void	SetUseProxy(bool in)					{ proxy.UseProxy=in;}
	static	bool	GetShowProxyErrors()					{ return m_bShowProxyErrors; }
	static	void	SetShowProxyErrors(bool bEnable)		{ m_bShowProxyErrors = bEnable; }

	static	bool	IsProxyASCWOP()							{ return m_bIsASCWOP;}
	static	void	SetProxyASCWOP(bool in)					{ m_bIsASCWOP=in;}

	static	bool	ShowCatTabInfos()						{ return showCatTabInfos;}
	static	void	ShowCatTabInfos(bool in)				{ showCatTabInfos=in;}

	static	bool	AutoFilenameCleanup()						{ return autofilenamecleanup;}
	static	void	AutoFilenameCleanup(bool in)				{ autofilenamecleanup=in;}
	static	void	SetFilenameCleanups(CString in)				{ _stprintf(filenameCleanups,_T("%s"),in);}

	static	bool	GetResumeSameCat()							{ return resumeSameCat;}
	static	bool	IsGraphRecreateDisabled()					{ return dontRecreateGraphs;}
	static	bool	IsExtControlsEnabled()						{ return m_bExtControls;}
	static	void	SetExtControls(bool in)						{ m_bExtControls=in;}
	static	bool	GetRemoveFinishedDownloads()				{ return m_bRemoveFinishedDownloads;}

	static	uint16	GetMaxChatHistoryLines()					{ return m_iMaxChatHistory;}
	static	bool	GetUseAutocompletion()						{ return m_bUseAutocompl;}
	static	bool	GetUseDwlPercentage()						{ return m_bShowDwlPercentage;}
	static	void	SetUseDwlPercentage(bool in)				{ m_bShowDwlPercentage=in;}
	static	bool	GetShowActiveDownloadsBold()				{ return m_bShowActiveDownloadsBold; }

	//Toolbar
	static	const CString& GetToolbarSettings()					{ return m_sToolbarSettings; }
	static	void	SetToolbarSettings(const CString& in)		{ m_sToolbarSettings = in; }
	static	const CString& GetToolbarBitmapSettings()			{ return m_sToolbarBitmap; }
	static	void	SetToolbarBitmapSettings(const CString& path){ m_sToolbarBitmap = path; }
	static	const CString& GetToolbarBitmapFolderSettings()		{ return m_sToolbarBitmapFolder; }
	static	void	SetToolbarBitmapFolderSettings(const CString& path){ m_sToolbarBitmapFolder = path; }
	static	EToolbarLabelType GetToolbarLabelSettings()			{ return m_nToolbarLabels; }
	static	void	SetToolbarLabelSettings(EToolbarLabelType eLabelType) { m_nToolbarLabels = eLabelType; }
	static	bool	GetReBarToolbar()							{ return m_bReBarToolbar; }
	static	bool	GetUseReBarToolbar();
	static	CSize	GetToolbarIconSize()						{ return m_sizToolbarIconSize; }
	static	void	SetToolbarIconSize(CSize siz)				{ m_sizToolbarIconSize = siz; }

	static	int		GetSearchMethod()							{ return m_iSearchMethod; }
	static	void	SetSearchMethod(int iMethod)				{ m_iSearchMethod = iMethod; }

	// ZZ:UploadSpeedSense -->
	static	bool	IsDynUpEnabled()							{ return m_bDynUpEnabled; }
	static	void	SetDynUpEnabled(bool newValue)				{ m_bDynUpEnabled = newValue; }
	static	int		GetDynUpPingTolerance()						{ return m_iDynUpPingTolerance; }
	static	int		GetDynUpGoingUpDivider()					{ return m_iDynUpGoingUpDivider; }
	static	int		GetDynUpGoingDownDivider()					{ return m_iDynUpGoingDownDivider; }
	static	int		GetDynUpNumberOfPings()						{ return m_iDynUpNumberOfPings; }
    static  bool	IsDynUpUseMillisecondPingTolerance()        { return m_bDynUpUseMillisecondPingTolerance;} // EastShare - Added by TAHO, USS limit
	static  int		GetDynUpPingToleranceMilliseconds()         { return m_iDynUpPingToleranceMilliseconds; } // EastShare - Added by TAHO, USS limit
	static  void	SetDynUpPingToleranceMilliseconds(int in)   { m_iDynUpPingToleranceMilliseconds = in; }
	// ZZ:UploadSpeedSense <--

    static bool     GetA4AFSaveCpu()                            { return m_bA4AFSaveCpu; } // ZZ:DownloadManager

	static	CString	GetHomepageBaseURL()						{ return GetHomepageBaseURLForLevel(GetWebMirrorAlertLevel()); }
	static	CString	GetVersionCheckBaseURL();					
	static	void	SetWebMirrorAlertLevel(uint8 newValue)		{ m_nWebMirrorAlertLevel = newValue; }
	static bool	IsDefaultNick(const CString strCheck);
	static	uint8	GetWebMirrorAlertLevel();
	static bool		UseSimpleTimeRemainingComputation()			{ return m_bUseOldTimeRemaining;}

	static	bool	IsRunAsUserEnabled();

	// PeerCache
	static	bool	IsPeerCacheDownloadEnabled()				{ return m_bPeerCacheEnabled; }
	static	uint32	GetPeerCacheLastSearch()					{ return m_uPeerCacheLastSearch; }
	static	bool	WasPeerCacheFound()							{ return m_bPeerCacheWasFound; }
	static	void	SetPeerCacheLastSearch(uint32 dwLastSearch) { m_uPeerCacheLastSearch = dwLastSearch; }
	static	void	SetPeerCacheWasFound(bool bFound)			{ m_bPeerCacheWasFound = bFound; }
	static	uint16	GetPeerCachePort()							{ return m_nPeerCachePort; }
	static	void	SetPeerCachePort(uint16 nPort)				{ m_nPeerCachePort = nPort; }
	static	bool	GetPeerCacheShow()							{ return m_bPeerCacheShow; }

	// Verbose log options
	static	bool	GetEnableVerboseOptions()			{return m_bEnableVerboseOptions;}
// RT, New Code at Above
/* Original
	static	bool	GetVerbose()						{return m_bVerbose;}
*/
	static	bool	GetFullVerbose()					{return m_bVerbose && m_bFullVerbose;}
	static	bool	GetDebugSourceExchange()			{return m_bVerbose && m_bDebugSourceExchange;}
	static	bool	GetLogBannedClients()				{return m_bVerbose && m_bLogBannedClients;}
	static	bool	GetLogRatingDescReceived()			{return m_bVerbose && m_bLogRatingDescReceived;}
	static	bool	GetLogSecureIdent()					{return m_bVerbose && m_bLogSecureIdent;}
	static	bool	GetLogFilteredIPs()					{return m_bVerbose && m_bLogFilteredIPs;}
	static	bool	GetLogFileSaving()					{return m_bVerbose && m_bLogFileSaving;}
    static	bool	GetLogA4AF()    					{return m_bVerbose && m_bLogA4AF;} // ZZ:DownloadManager
	static	bool	GetLogUlDlEvents()					{return m_bVerbose && m_bLogUlDlEvents;}
	static	bool	GetUseDebugDevice()					{return m_bUseDebugDevice;}
	static	int		GetDebugServerTCPLevel()			{return m_iDebugServerTCPLevel;}
	static	int		GetDebugServerUDPLevel() 			{return m_iDebugServerUDPLevel;}
	static	int		GetDebugServerSourcesLevel()		{return m_iDebugServerSourcesLevel;}
	static	int		GetDebugServerSearchesLevel()		{return m_iDebugServerSearchesLevel;}
	static	int		GetDebugClientTCPLevel()			{return m_iDebugClientTCPLevel;}
	static	int		GetDebugClientUDPLevel()			{return m_iDebugClientUDPLevel;}
	static	int		GetDebugClientKadUDPLevel()			{return m_iDebugClientKadUDPLevel;}
	static	uint8	GetVerboseLogPriority()	{return	m_byLogLevel;} // hard coded now, will of course be selectable later

	// Firewall settings
	static  bool	IsOpenPortsOnStartupEnabled()		{return m_bOpenPortsOnStartUp; }
	
	//AICH Hash
	static	bool	IsTrustingEveryHash()				{return m_bTrustEveryHash;} // this is a debug option

protected:
	static	CString appdir;
	static	CString configdir;
	static	CString m_strWebServerDir;
	static	CString m_strLangDir;
	static	CString m_strFileCommentsFilePath;
	static	CString m_strLogDir;
	static	Preferences_Ext_Struct* prefsExt;
	static	WORD m_wWinVer;
	static	bool m_UseProxyListenPort;
	static	uint16	ListenPort;
	static	CArray<Category_Struct*,Category_Struct*> catMap;

	static void	CreateUserHash();
	static void	SetStandartValues();
	static int	GetRecommendedMaxConnections();
	static void LoadPreferences();
	static void SavePreferences();
	static CString GetHomepageBaseURLForLevel(uint8 nLevel);
};

extern CPreferences thePrefs;
