//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "QueueListCtrl.h"
#include "OtherFunctions.h"
#include "MenuCmds.h"
#include "ClientDetailDialog.h"
#include "Exceptions.h"
#include "KademliaWnd.h"
#include "emuledlg.h"
#include "FriendList.h"
#include "UploadQueue.h"
#include "UpDownClient.h"
#include "TransferWnd.h"
#include "MemDC.h"
#include "SharedFileList.h"
#include "ClientCredits.h"
#include "PartFile.h"
#include "ChatWnd.h"
#include "Kademlia/Kademlia/Kademlia.h"
#include "Kademlia/Kademlia/Prefs.h"
#include "kademlia/net/KademliaUDPListener.h"
#include "Log.h"
// RT, Include
#include "EnBitmap.h"
#include "ServerWnd.h"
#include "0RatioFile/RT_Other.h"
#include "0RatioFile/RT_MenuCommands.h"
// End

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// CQueueListCtrl

IMPLEMENT_DYNAMIC(CQueueListCtrl, CMuleListCtrl)

CQueueListCtrl::CQueueListCtrl()
	: CListCtrlItemWalk(this)
{
	// Barry - Refresh the queue every 10 secs
	VERIFY( (m_hTimer = ::SetTimer(NULL, NULL, 10000, QueueUpdateTimer)) != NULL );
	if (thePrefs.GetVerbose() && !m_hTimer)
		AddDebugLogLine(true,_T("Failed to create 'queue list control' timer - %s"),GetErrorMessage(GetLastError()));
}

void CQueueListCtrl::Init()
{
	CImageList ilDummyImageList; //dummy list for getting the proper height of listview entries
	ilDummyImageList.Create(1, theApp.GetSmallSytemIconSize().cy,theApp.m_iDfltImageListColorFlags|ILC_MASK, 1, 1); 
	SetImageList(&ilDummyImageList, LVSIL_SMALL);
	ASSERT( (GetStyle() & LVS_SHAREIMAGELISTS) == 0 );
	ilDummyImageList.Detach();

	SetExtendedStyle(LVS_EX_FULLROWSELECT);
	InsertColumn(0,GetResString(IDS_QL_USERNAME),LVCFMT_LEFT,150,0);
	InsertColumn(1,GetResString(IDS_FILE),LVCFMT_LEFT,275,1);
	InsertColumn(2,GetResString(IDS_FILEPRIO),LVCFMT_LEFT,110,2);
	InsertColumn(3,GetResString(IDS_QL_RATING),LVCFMT_LEFT,60,3);
	InsertColumn(4,GetResString(IDS_SCORE),LVCFMT_LEFT,60,4);
	InsertColumn(5,GetResString(IDS_ASKED),LVCFMT_LEFT,60,5);
	InsertColumn(6,GetResString(IDS_LASTSEEN),LVCFMT_LEFT,110,6);
	InsertColumn(7,GetResString(IDS_ENTERQUEUE),LVCFMT_LEFT,110,7);
	InsertColumn(8,GetResString(IDS_BANNED),LVCFMT_LEFT,60,8);
	InsertColumn(9,GetResString(IDS_UPSTATUS),LVCFMT_LEFT,100,9);
// RT, New display--Client Software, Friend, UL/DL Total
	InsertColumn(10, GetResString(RT_IDS_UD_TOTAL), LVCFMT_LEFT, 100, 10);
	InsertColumn(11, GetResString(IDS_CW_FRIENDS), LVCFMT_LEFT, 60, 11);
	InsertColumn(12, GetResString(IDS_CLIENTSOFTWARE), LVCFMT_LEFT, 100, 12);
// End

	SetAllIcons();
	Localize();
	LoadSettings(CPreferences::tableQueue);
	// Barry - Use preferred sort order from preferences
	int sortItem = thePrefs.GetColumnSortItem(CPreferences::tableQueue);
	bool sortAscending = thePrefs.GetColumnSortAscending(CPreferences::tableQueue);
	SetSortArrow(sortItem, sortAscending);
	SortItems(SortProc, sortItem + (sortAscending ? 0:100));
// RT, Load Flag Image
	CBitmap Bitmap;
	if (Bitmap.LoadBitmap(RT_IDB_FLAG) == TRUE)
	{
		BITMAP bm = {0};
		Bitmap.GetObject(sizeof(bm), &bm);
		if ( rt_FlagImageList.Create(16, bm.bmHeight, ILC_COLOR16|ILC_MASK, 0, 1) )
		{
			rt_FlagImageList.Add(&Bitmap, RGB(0, 254, 0));
		}
		Bitmap.DeleteObject();
//		rt_FlagImageList.SetOverlayImage(RT_NO_FLAG, 1);
	}
	else
		AddLogLine( true, _T(">> [RT Debug] Error when Load Flag") );
	// Sort Plus
	rt_SortPlus = thePrefs.GetTableSortPlus(CPreferences::tableQueue);
	// Sort table, SortPlus +200
	if (rt_SortPlus == true)
	{
		SetSortArrow( sortItem, (sortAscending ? arrowDoubleUp : arrowDoubleDown) );
		SortItems( SortProc, sortItem + (sortAscending ? 200 : 300) );
	}
	else
	{
		SetSortArrow(sortItem, sortAscending);
		SortItems( SortProc, sortItem + (sortAscending ? 0 : 100) );
	}
// End
}

CQueueListCtrl::~CQueueListCtrl()
{
	// Barry - Kill the timer that was created
	try
	{
		if (m_hTimer)
			::KillTimer(NULL, m_hTimer);
	}
	catch(...){
		ASSERT(0);
	}
}

void CQueueListCtrl::OnSysColorChange()
{
	CMuleListCtrl::OnSysColorChange();
	SetAllIcons();
}

void CQueueListCtrl::SetAllIcons()
{
	imagelist.DeleteImageList();
	imagelist.Create(16,16,theApp.m_iDfltImageListColorFlags|ILC_MASK,0,1);
	imagelist.SetBkColor(CLR_NONE);
// RT, New Display--Icon
	imagelist.Add( CTempIconLoader(_T("ClientEDonkey")) );
	imagelist.Add( CTempIconLoader(_T("ClientCompatible")) );
	imagelist.Add( CTempIconLoader(_T("ClientMLDonkey")) );
	imagelist.Add( CTempIconLoader(_T("ClientEDonkeyHybrid")) );
	imagelist.Add( CTempIconLoader(_T("ClientShareaza")) );
	imagelist.Add( CTempIconLoader(_T("ClientAMule")) );
	imagelist.Add( CTempIconLoader(_T("ClientLphant")) );
	imagelist.Add( CTempIconLoader(_T("Server")) );
	imagelist.Add( CTempIconLoader(_T("Friend")) );
	imagelist.Add( CTempIconLoader(_T("ClientEastShare")) );
	imagelist.Add( CTempIconLoader(_T("ClientWombat")) );
	imagelist.Add( CTempIconLoader(_T("ClientLSD")) );
	imagelist.Add( CTempIconLoader(_T("ClientMorph")) );
	imagelist.Add( CTempIconLoader(_T("ClientPhoenix")) );
	imagelist.Add( CTempIconLoader(_T("ClientPlus")) );
	imagelist.Add( CTempIconLoader(_T("ClientRT")) );
	imagelist.Add( CTempIconLoader(_T("ClientSivka")) );
	imagelist.Add( CTempIconLoader(_T("ClientWebCache")) );
	imagelist.SetOverlayImage(imagelist.Add(CTempIconLoader(_T("ClientMaskPlus"))), 1);
	imagelist.SetOverlayImage(imagelist.Add(CTempIconLoader(_T("ClientMaskFriend"))), 2);
	imagelist.SetOverlayImage(imagelist.Add(CTempIconLoader(_T("ClientMaskPlusFriend"))), 3);
	imagelist.SetOverlayImage(imagelist.Add(CTempIconLoader(_T("ClientSecureOvl"))), 4);
}
/* Originl
	imagelist.Add(CTempIconLoader(_T("ClientEDonkey")));
	imagelist.Add(CTempIconLoader(_T("ClientCompatible")));
	imagelist.Add(CTempIconLoader(_T("ClientEDonkeyPlus")));
	imagelist.Add(CTempIconLoader(_T("ClientCompatiblePlus")));
	imagelist.Add(CTempIconLoader(_T("Friend")));
	imagelist.Add(CTempIconLoader(_T("ClientMLDonkey")));
	imagelist.Add(CTempIconLoader(_T("ClientMLDonkeyPlus")));
	imagelist.Add(CTempIconLoader(_T("ClientEDonkeyHybrid")));
	imagelist.Add(CTempIconLoader(_T("ClientEDonkeyHybridPlus")));
	imagelist.Add(CTempIconLoader(_T("ClientShareaza")));
	imagelist.Add(CTempIconLoader(_T("ClientShareazaPlus")));
	imagelist.Add(CTempIconLoader(_T("ClientAMule")));
	imagelist.Add(CTempIconLoader(_T("ClientAMulePlus")));
	imagelist.Add(CTempIconLoader(_T("ClientLPhant")));
	imagelist.Add(CTempIconLoader(_T("ClientLPhantPlus")));
	imagelist.SetOverlayImage(imagelist.Add(CTempIconLoader(_T("ClientSecureOvl"))), 1);
}
*/
void CQueueListCtrl::Localize()
{
	CHeaderCtrl* pHeaderCtrl = GetHeaderCtrl();
	HDITEM hdi;
	hdi.mask = HDI_TEXT;

	if(pHeaderCtrl->GetItemCount() != 0) {
		CString strRes;

		strRes = GetResString(IDS_QL_USERNAME);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(0, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_FILE);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(1, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_FILEPRIO);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(2, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_QL_RATING);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(3, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_SCORE);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(4, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_ASKED);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(5, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_LASTSEEN);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(6, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_ENTERQUEUE);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(7, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_BANNED);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(8, &hdi);
		strRes.ReleaseBuffer();
		
		strRes = GetResString(IDS_UPSTATUS);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(9, &hdi);
		strRes.ReleaseBuffer();

// RT, New Display--UL/DL Total
		strRes = GetResString(RT_IDS_UD_TOTAL);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(10, &hdi);
		strRes.ReleaseBuffer();
		// Friend
		strRes = GetResString(IDS_CW_FRIENDS);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(11, &hdi);
		strRes.ReleaseBuffer();
		// Client Software
		strRes = GetResString(IDS_CLIENTSOFTWARE);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(12, &hdi);
		strRes.ReleaseBuffer();
// End
	}
}

void CQueueListCtrl::AddClient(/*const*/ CUpDownClient* client, bool resetclient)
{
	if (resetclient && client){
		client->SetWaitStartTime();
		client->SetAskedCount(1);
	}

	if (!theApp.emuledlg->IsRunning())
		return;
	if (thePrefs.IsQueueListDisabled())
		return;

	int iItemCount = GetItemCount();
	int iItem = InsertItem(LVIF_TEXT|LVIF_PARAM,iItemCount,LPSTR_TEXTCALLBACK,0,0,0,(LPARAM)client);
	Update(iItem);
	theApp.emuledlg->transferwnd->UpdateListCount(2, iItemCount+1);
}

void CQueueListCtrl::RemoveClient(const CUpDownClient* client)
{
	if (!theApp.emuledlg->IsRunning())
		return;

	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)client;
	sint32 result = FindItem(&find);
	if (result != -1){
		DeleteItem(result);
		theApp.emuledlg->transferwnd->UpdateListCount(2);
	}
}

void CQueueListCtrl::RefreshClient(const CUpDownClient* client)
{
	// There is some type of timing issue here.. If you click on item in the queue or upload and leave
	// the focus on it when you exit the cient, it breaks on line 854 of emuleDlg.cpp.. 
	// I added this IsRunning() check to this function and the DrawItem method and
	// this seems to keep it from crashing. This is not the fix but a patch until
	// someone points out what is going wrong.. Also, it will still assert in debug mode..
	if (!theApp.emuledlg->IsRunning())
		return;

	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)client;
	sint16 result = FindItem(&find);
	if (result != -1)
		Update(result);
}

#define DLC_DT_TEXT (DT_LEFT|DT_SINGLELINE|DT_VCENTER|DT_NOPREFIX|DT_END_ELLIPSIS)

void CQueueListCtrl::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	if( !theApp.emuledlg->IsRunning() )
		return;
	if (!lpDrawItemStruct->itemData)
		return;
	CDC* odc = CDC::FromHandle(lpDrawItemStruct->hDC);
	BOOL bCtrlFocused = ((GetFocus() == this ) || (GetStyle() & LVS_SHOWSELALWAYS));
	if( (lpDrawItemStruct->itemAction | ODA_SELECT) && (lpDrawItemStruct->itemState & ODS_SELECTED )){
		if(bCtrlFocused)
			odc->SetBkColor(m_crHighlight);
		else
			odc->SetBkColor(m_crNoHighlight);
	}
	else
		odc->SetBkColor(GetBkColor());
	const CUpDownClient* client = (CUpDownClient*)lpDrawItemStruct->itemData;
	CMemDC dc(CDC::FromHandle(lpDrawItemStruct->hDC), &lpDrawItemStruct->rcItem);
	CFont* pOldFont = dc.SelectObject(GetFont());
	RECT cur_rec = lpDrawItemStruct->rcItem;
	COLORREF crOldTextColor = dc.SetTextColor(m_crWindowText);

	int iOldBkMode;
	if (m_crWindowTextBk == CLR_NONE){
		DefWindowProc(WM_ERASEBKGND, (WPARAM)(HDC)dc, 0);
		iOldBkMode = dc.SetBkMode(TRANSPARENT);
	}
	else
		iOldBkMode = OPAQUE;

	CString Sbuffer;
	CKnownFile* file = theApp.sharedfiles->GetFileByID(client->GetUploadFileID());
	CHeaderCtrl *pHeaderCtrl = GetHeaderCtrl();
	int iCount = pHeaderCtrl->GetItemCount();
	cur_rec.right = cur_rec.left - 8;
	cur_rec.left += 4;

	for(int iCurrent = 0; iCurrent < iCount; iCurrent++){
		int iColumn = pHeaderCtrl->OrderToIndex(iCurrent);
		if( !IsColumnHidden(iColumn) ){
			cur_rec.right += GetColumnWidth(iColumn);
			switch(iColumn){
// RT, New Display
				case 0:
				{
					uint8 Image = client->GetIconNO();
					POINT point = {cur_rec.left, cur_rec.top+1};
					imagelist.Draw( dc, Image, point, (ILD_NORMAL | INDEXTOOVERLAYMASK(client->GetMaskNO())) );
					// Text Color
					if (thePrefs.IsRatioColor() == true)
					{
						if (client->GetDownloadState() == DS_DOWNLOADING)
							dc->SetTextColor( thePrefs.GetRatioColor(RT_CR_CT_TRANSFER) );
						else
						{
							// Red Color for Ban, Invalid, Leecher
							if (client->GetQueueScore() < RT_SCORE_DONT_UPLOAD)
								dc->SetTextColor( thePrefs.GetRatioColor(RT_CR_CT_BAD) );
						}
					}
					// Display Country Code
					if (thePrefs.IsDisplayCountry() == true)
						Sbuffer.Format( _T("<%s> %s"), client->GetCountryCode(), client->GetUserName() );
					else
						Sbuffer = client->GetUserName();
					// Display Flag
					Image = client->GetFlagNO();
					cur_rec.left += 20;
					if (thePrefs.IsDisplayFlag() == true)
					{
						POINT FlagPoint = {cur_rec.left, (cur_rec.top + 3)};
						rt_FlagImageList.Draw( dc, Image, FlagPoint, ILD_NORMAL);
						cur_rec.left += 20;
						dc->DrawText(Sbuffer,Sbuffer.GetLength(),&cur_rec,DLC_DT_TEXT);
						cur_rec.left -= 20;
					}
					else
						dc->DrawText(Sbuffer,Sbuffer.GetLength(),&cur_rec,DLC_DT_TEXT);
					cur_rec.left -= 20;
					break;
				}
				case 1:
					if (file != NULL)
						Sbuffer = file->GetFileName();
					else
						Sbuffer = _T("?");
					break;
				// Priority
				case 2:
					if (file != NULL)
					{
						if (file->IsAutoUpPriority() == true)
							Sbuffer = GetResString(RT_IDS_PRIO_AUTO);
						else
							Sbuffer.Empty();
						switch ( file->GetUpPriority() )
						{
							case PR_VERYLOW :
								Sbuffer += GetResString(IDS_PRIOVERYLOW);
								break;
							case PR_LOW :
								Sbuffer += GetResString(IDS_PRIOLOW);
								break;
							case PR_NORMAL :
								Sbuffer += GetResString(IDS_PRIONORMAL);
								break;
							case PR_HIGH :
								Sbuffer += GetResString(IDS_PRIOHIGH);
								break;
							case PR_VERYHIGH :
								if (file->IsReleaseFile() == true)
									Sbuffer += GetResString(RT_IDS_PRIORELEASE);
								else
									Sbuffer += GetResString(IDS_PRIOVERYHIGH);
								break;
							default:
								Sbuffer.Empty();
						}
						break;
					}
					else
						Sbuffer = _T("?");
					break;
				// Rating
				case 3:
					Sbuffer = client->GetRatingString();
					break;
				// Score
				case 4:
				{
					if (client->HasLowID() == true)
					{
						if (client->m_bAddNextConnect == true)
							Sbuffer.Format( _T("%i ****"), client->GetQueueScore() );
						else
                            Sbuffer.Format( _T("%i LowID"), client->GetQueueScore() );
					}
					else
						Sbuffer.Format( _T("%i"), client->GetQueueScore() );
					break;
				}
				// Asked Count
				case 5:
					Sbuffer.Format(_T("%i"),client->GetAskedCount());
					break;
				// Last Request Time
				case 6:
					Sbuffer = CastSecondsToHM((::GetTickCount() - client->GetLastUpRequest())/1000);
					break;
				// Waited Time
				case 7:
					Sbuffer.Format( _T("%s"), CastSecondsToHM(client->GetWaitTime()) );
					// Upload Queue Waited Time
					if ( (client->GetUploadQueueWaitedTime() > 0) && (thePrefs.IsRecordUploadQueueWaitedTime() == true) )
						Sbuffer.AppendFormat( _T(" (+%s)"), CastSecondsToHM(client->GetUploadQueueWaitedTime()) );
					break;
				// UL/DL Total
				case 10:
					if (client->credits != NULL)
						Sbuffer.Format( _T("%s/%s"), CastItoXBytes(client->credits->GetUploadedTotal()), CastItoXBytes(client->credits->GetDownloadedTotal()) );
					else
						Sbuffer.Empty();
					break;
				// Friend
				case 11:
					if (client->IsFriend() == true)
						Sbuffer = GetResString(IDS_YES);
					else
						Sbuffer = GetResString(IDS_NO);
					break;
				// Client Software
				case 12:
					Sbuffer = client->GetClientSoftVer();
					break;
/* Original
				case 0:{
					uint8 image;
					if (client->IsFriend())
						image = 4;
					else if (client->GetClientSoft() == SO_EDONKEYHYBRID){
						if (client->credits->GetScoreRatio(client->GetIP()) > 1)
							image = 8;
						else
							image = 7;
					}
					else if (client->GetClientSoft() == SO_MLDONKEY){
						if (client->credits->GetScoreRatio(client->GetIP()) > 1)
							image = 6;
						else
							image = 5;
					}
					else if (client->GetClientSoft() == SO_SHAREAZA){
						if(client->credits->GetScoreRatio(client->GetIP()) > 1)
							image = 10;
						else
							image = 9;
					}
					else if (client->GetClientSoft() == SO_AMULE){
						if(client->credits->GetScoreRatio(client->GetIP()) > 1)
							image = 12;
						else
							image = 11;
					}
					else if (client->GetClientSoft() == SO_LPHANT){
						if(client->credits->GetScoreRatio(client->GetIP()) > 1)
							image = 14;
						else
							image = 13;
					}
					else if (client->ExtProtocolAvailable()){
						if(client->credits->GetScoreRatio(client->GetIP()) > 1)
							image = 3;
						else
							image = 1;
					}
					else{
						if (client->credits->GetScoreRatio(client->GetIP()) > 1)
							image = 2;
						else
							image = 0;
					}

					POINT point = {cur_rec.left, cur_rec.top+1};
					imagelist.Draw(dc,image, point, ILD_NORMAL | ((client->Credits() && client->Credits()->GetCurrentIdentState(client->GetIP()) == IS_IDENTIFIED) ? INDEXTOOVERLAYMASK(1) : 0));
					Sbuffer = client->GetUserName();
					cur_rec.left +=20;
					dc->DrawText(Sbuffer,Sbuffer.GetLength(),&cur_rec,DLC_DT_TEXT);
					cur_rec.left -=20;
					break;
				}
				case 1:
					if(file)
						Sbuffer = file->GetFileName();
					else
						Sbuffer = "?";
					break;
				case 2:
					if(file){
						switch (file->GetUpPriority()) {
							case PR_VERYLOW : {
								Sbuffer = GetResString(IDS_PRIOVERYLOW);
								break; }
							case PR_LOW : {
								if( file->IsAutoUpPriority() )
									Sbuffer = GetResString(IDS_PRIOAUTOLOW);
								else
									Sbuffer = GetResString(IDS_PRIOLOW);
								break; }
							case PR_NORMAL : {
								if( file->IsAutoUpPriority() )
									Sbuffer = GetResString(IDS_PRIOAUTONORMAL);
								else
									Sbuffer = GetResString(IDS_PRIONORMAL);
								break; }
							case PR_HIGH : {
								if( file->IsAutoUpPriority() )
									Sbuffer = GetResString(IDS_PRIOAUTOHIGH);
								else
									Sbuffer = GetResString(IDS_PRIOHIGH);
								break; }
							case PR_VERYHIGH : {
								Sbuffer = GetResString(IDS_PRIORELEASE);
								break; }
							default:
								Sbuffer.Empty();
						}
					}
					else
						Sbuffer = _T("?");
					break;
				case 3:
					Sbuffer.Format(_T("%i"),client->GetScore(false,false,true));
					break;
				case 4:
					if (client->HasLowID()){
						if (client->m_bAddNextConnect)
							Sbuffer.Format(_T("%i ****"),client->GetScore(false));
						else
                            Sbuffer.Format(_T("%i LowID"),client->GetScore(false));
					}
					else
						Sbuffer.Format(_T("%i"),client->GetScore(false));
					break;
				case 5:
					Sbuffer.Format(_T("%i"),client->GetAskedCount());
					break;
				case 6:
					Sbuffer = CastSecondsToHM((::GetTickCount() - client->GetLastUpRequest())/1000);
					break;
				case 7:
					Sbuffer = CastSecondsToHM((::GetTickCount() - client->GetWaitStartTime())/1000);
					break;
*/
				case 8:
					if(client->IsBanned())
						Sbuffer = GetResString(IDS_YES);
					else
						Sbuffer = GetResString(IDS_NO);
					break;
				case 9:
					if( client->GetUpPartCount()){
						cur_rec.bottom--;
						cur_rec.top++;
						client->DrawUpStatusBar(dc,&cur_rec,false,thePrefs.UseFlatBar());
						cur_rec.bottom++;
						cur_rec.top--;
					}
					break;
					   }
				if( iColumn != 9 && iColumn != 0)
				dc->DrawText(Sbuffer,Sbuffer.GetLength(),&cur_rec,DLC_DT_TEXT);
			cur_rec.left += GetColumnWidth(iColumn);
		}
	}
//draw rectangle around selected item(s)
	if ((lpDrawItemStruct->itemAction | ODA_SELECT) && (lpDrawItemStruct->itemState & ODS_SELECTED))
	{
		RECT outline_rec = lpDrawItemStruct->rcItem;

		outline_rec.top--;
		outline_rec.bottom++;
		dc->FrameRect(&outline_rec, &CBrush(GetBkColor()));
		outline_rec.top++;
		outline_rec.bottom--;
		outline_rec.left++;
		outline_rec.right--;

		if(bCtrlFocused)
			dc->FrameRect(&outline_rec, &CBrush(m_crFocusLine));
		else
			dc->FrameRect(&outline_rec, &CBrush(m_crNoFocusLine));
	}
	
	if (m_crWindowTextBk == CLR_NONE)
		dc.SetBkMode(iOldBkMode);
	dc.SelectObject(pOldFont);
	dc.SetTextColor(crOldTextColor);
}

BEGIN_MESSAGE_MAP(CQueueListCtrl, CMuleListCtrl)
	ON_WM_CONTEXTMENU()
	ON_WM_SYSCOLORCHANGE()
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnClick)
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnNMDblclk)
	ON_NOTIFY_REFLECT(LVN_GETDISPINFO, OnGetDispInfo)
END_MESSAGE_MAP()

// CQueueListCtrl message handlers
void CQueueListCtrl::OnContextMenu(CWnd* pWnd, CPoint point)
{
	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	const CUpDownClient* client = (iSel != -1) ? (CUpDownClient*)GetItemData(iSel) : NULL;

	CTitleMenu ClientMenu;
	ClientMenu.CreatePopupMenu();
	ClientMenu.AddMenuTitle(GetResString(IDS_CLIENTS), true);
	ClientMenu.AppendMenu(MF_STRING | (client ? MF_ENABLED : MF_GRAYED), MP_DETAIL, GetResString(IDS_SHOWDETAILS), _T("CLIENTDETAILS"));
	ClientMenu.SetDefaultItem(MP_DETAIL);
// RT, RT Feature
	// Add / Remove Friend
	if ( (client != NULL) && (client->IsEd2kClient() == true) )
	{
		if (client->IsFriend() == true)
			ClientMenu.AppendMenu( MF_STRING | MF_ENABLED, MP_REMOVEFRIEND, GetResString(IDS_REMOVEFRIEND), _T("ADDFRIEND") );
		else
			ClientMenu.AppendMenu( MF_STRING | MF_ENABLED, MP_ADDFRIEND, GetResString(IDS_ADDFRIEND), _T("ADDFRIEND") );
	}
	else
		ClientMenu.AppendMenu( MF_STRING | MF_GRAYED, MP_ADDFRIEND, GetResString(IDS_ADDFRIEND), _T("ADDFRIEND") );
	// Message
	if (theApp.emuledlg->chatwnd != NULL)
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient()) ? MF_ENABLED : MF_GRAYED), MP_MESSAGE, GetResString(IDS_SEND_MSG), _T("SENDMESSAGE"));
	// File List
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && client->GetViewSharedFilesSupport()) ? MF_ENABLED : MF_GRAYED), MP_SHOWLIST, GetResString(IDS_VIEWFILES), _T("VIEWFILES"));
	// Establish Friend Slot
	ClientMenu.AppendMenu( MF_STRING | MF_GRAYED, MP_FRIENDSLOT, GetResString(IDS_FRIENDSLOT), _T("FRIENDSLOT") );
	// Ban & Unban
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && client->IsBanned()) ? MF_ENABLED : MF_GRAYED), MP_UNBAN, GetResString(IDS_UNBAN));
	// Kademlia Bootstrap
	if (Kademlia::CKademlia::isRunning() && !Kademlia::CKademlia::getPrefs()->getLastContact())
		ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && client->GetKadPort()!=0) ? MF_ENABLED : MF_GRAYED), MP_BOOT, GetResString(IDS_BOOTSTRAP));
	// Reset Leecher Count
	ClientMenu.AppendMenu( MF_STRING | MF_GRAYED, MP_ResetLeechCount, GetResString(RT_IDS_RESET_LEECH_COUNT) );
	if ( (client != NULL) && (client->IsEd2kClient() == true) )
	{
		if (thePrefs.IsFriendSlotAuto() == false)
		{
			ClientMenu.CheckMenuItem(MP_FRIENDSLOT, client->GetFriendSlot() ? MF_CHECKED : MF_UNCHECKED);
			ClientMenu.EnableMenuItem(MP_FRIENDSLOT, MF_ENABLED);
		}
		// Reset Leech Count
		if ( (client->GetLeecherCount() >= thePrefs.GetLeecherCount()) && (client->GetLeecherCount() != RT_LEECHER) )
			ClientMenu.EnableMenuItem(MP_ResetLeechCount, MF_ENABLED);
	}
/* Original
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && !client->IsFriend()) ? MF_ENABLED : MF_GRAYED), MP_ADDFRIEND, GetResString(IDS_ADDFRIEND), _T("ADDFRIEND"));
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient()) ? MF_ENABLED : MF_GRAYED), MP_MESSAGE, GetResString(IDS_SEND_MSG), _T("SENDMESSAGE"));
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && client->GetViewSharedFilesSupport()) ? MF_ENABLED : MF_GRAYED), MP_SHOWLIST, GetResString(IDS_VIEWFILES), _T("VIEWFILES"));
	ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && client->IsBanned()) ? MF_ENABLED : MF_GRAYED), MP_UNBAN, GetResString(IDS_UNBAN));
	if (Kademlia::CKademlia::isRunning() && !Kademlia::CKademlia::isConnected())
		ClientMenu.AppendMenu(MF_STRING | ((client && client->IsEd2kClient() && client->GetKadPort()!=0) ? MF_ENABLED : MF_GRAYED), MP_BOOT, GetResString(IDS_BOOTSTRAP));
*/
	GetPopupMenuPos(*this, point);
	ClientMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON, point.x, point.y, this);
}

BOOL CQueueListCtrl::OnCommand(WPARAM wParam,LPARAM lParam )
{
	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	if (iSel != -1){
		CUpDownClient* client = (CUpDownClient*)GetItemData(iSel);
		switch (wParam){
// RT, Remove Friend
			case MP_REMOVEFRIEND:
				if (client->IsFriend() == true)
				{
					client->SetFriendSlot(false);
					theApp.friendlist->RemoveFriend(client->m_Friend);
					Update(iSel);
				}
				break;
			// Establish Friend Slot
			case MP_FRIENDSLOT:
				if (client->IsFriend() == false)
				{
					if (theApp.friendlist->AddFriend(client) == false)   break;
				}
				theApp.friendlist->SetFriendSlot( client, client->GetFriendSlot() );
				Update(iSel);
				break;
			// Reset Leech Count
			case MP_ResetLeechCount:
				if (client->credits != NULL)
				{
					if (AfxMessageBox(GetResString(RT_IDS_IS_RESET_LEECHER_COUNT), MB_ICONQUESTION | MB_YESNO) == IDYES)
					{
						client->SetLeecherCount(0);
						Update(iSel);
					}
				}
				break;
// End
			case MP_SHOWLIST:
				client->RequestSharedFileList();
				break;
			case MP_MESSAGE:
				theApp.emuledlg->chatwnd->StartSession(client);
				break;
			case MP_ADDFRIEND:
				if (theApp.friendlist->AddFriend(client))
					Update(iSel);
				break;
			case MP_UNBAN:
				if (client->IsBanned()){
					client->UnBan();
					Update(iSel);
				}
				break;
			case MPG_ALTENTER:
			case MP_DETAIL:{
				CClientDetailDialog dialog(client, this);
				dialog.DoModal();
				break;
			}
			case MP_BOOT:
				if (client->GetKadPort())
					Kademlia::CKademlia::bootstrap(ntohl(client->GetIP()), client->GetKadPort());
				break;
		}
	}
	return true;
} 

void CQueueListCtrl::OnColumnClick( NMHDR* pNMHDR, LRESULT* pResult){

	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	// Barry - Store sort order in preferences
	// Determine ascending based on whether already sorted on this column
	int sortItem = thePrefs.GetColumnSortItem(CPreferences::tableQueue);
	bool m_oldSortAscending = thePrefs.GetColumnSortAscending(CPreferences::tableQueue);
	bool sortAscending = (sortItem != pNMListView->iSubItem) ? true : !m_oldSortAscending;
// RT, Extended Sort
	if (sortItem == pNMListView->iSubItem)
	{
		// Name(0) or UL/DL Total(10) or Client Software(12)
		switch(sortItem)
		{
			case 0:
				if (thePrefs.IsDisplayCountry() == false)   break;
			case 10:
			case 12:
				if (m_oldSortAscending == false)   rt_SortPlus = !rt_SortPlus;
		}
	}
	else
		rt_SortPlus = false;
	// Item is column clicked
	sortItem = pNMListView->iSubItem;
	// Save new preferences
	thePrefs.SetColumnSortItem(CPreferences::tableQueue, sortItem);
	thePrefs.SetColumnSortAscending(CPreferences::tableQueue, sortAscending);
	//
	thePrefs.SetTableSortPlus(CPreferences::tableQueue, rt_SortPlus);
	// Sort table, SortPlus +200
	if (rt_SortPlus == true)
	{
		SetSortArrow( sortItem, (sortAscending ? arrowDoubleUp : arrowDoubleDown) );
		SortItems( SortProc, sortItem + (sortAscending ? 200 : 300) );
	}
	else
	{
		SetSortArrow(sortItem, sortAscending);
		SortItems( SortProc, sortItem + (sortAscending ? 0 : 100) );
	}
/* Original
	// Item is column clicked
	sortItem = pNMListView->iSubItem;
	// Save new preferences
	thePrefs.SetColumnSortItem(CPreferences::tableQueue, sortItem);
	thePrefs.SetColumnSortAscending(CPreferences::tableQueue, sortAscending);
	// Sort table
	SetSortArrow(sortItem, sortAscending);
	SortItems(SortProc, sortItem + (sortAscending ? 0:100));
*/
	*pResult = 0;
}

int CQueueListCtrl::SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	const CUpDownClient* item1 = (CUpDownClient*)lParam1;
	const CUpDownClient* item2 = (CUpDownClient*)lParam2;
// RT, Add Sort by Country
	bool SortPlus = false;
	if (lParamSort >= 200)
	{
		SortPlus = true;
		lParamSort = lParamSort - 200;
	}
	int SortMode = 1;
	if (lParamSort >= 100)   SortMode = -1;
	switch(lParamSort)
	{
		case 0:
		case 100:
			return CompareUsername(item1, item2, SortPlus) * SortMode;
		// File Priority
		case 2:
		{
			CKnownFile* file1 = theApp.sharedfiles->GetFileByID( item1->GetUploadFileID() );
			CKnownFile* file2 = theApp.sharedfiles->GetFileByID( item2->GetUploadFileID() );
			if ( (file1 != NULL) && (file2 != NULL) )
			{
				if ( file1->IsReleaseFile() != file2->IsReleaseFile() )
				{
					if (file1->IsReleaseFile() == true)
						return 1;
					else
					{
						if (file2->IsReleaseFile() == true)   return -1;
					}
				}
				return ((file1->GetUpPriority()==PR_VERYLOW) ? -1 : file1->GetUpPriority()) - ((file2->GetUpPriority()==PR_VERYLOW) ? -1 : file2->GetUpPriority());
			}
			else
			{
				if (file1 == NULL)
					return 1;
				else
					return -1;
			}
		}
		case 102:
		{
			CKnownFile* file1 = theApp.sharedfiles->GetFileByID(item1->GetUploadFileID());
			CKnownFile* file2 = theApp.sharedfiles->GetFileByID(item2->GetUploadFileID());
			if ( (file1 != NULL) && (file2 != NULL) )
			{
				if ( file1->IsReleaseFile() != file2->IsReleaseFile() )
				{
					if (file1->IsReleaseFile() == true)
						return -1;
					else
					{
						if (file2->IsReleaseFile() == true)   return 1;
					}
				}
				return ((file2->GetUpPriority()==PR_VERYLOW) ? -1 : file2->GetUpPriority()) - ((file1->GetUpPriority()==PR_VERYLOW) ? -1 : file1->GetUpPriority());
			}
			else
			{
				if (file1 == NULL)
					return 1;
				else
					return -1;
			}
		}
		// Queue Score
		case 4: 
			return CompareUnsigned(item1->GetQueueScore(), item2->GetQueueScore());
		case 104: 
			return CompareUnsigned(item2->GetQueueScore(), item1->GetQueueScore());
		// Entered Queue Fix
		case 7: 
			return item2->GetWaitStartTime() - item1->GetWaitStartTime();
		case 107: 
			return item1->GetWaitStartTime() - item2->GetWaitStartTime();
		// UL/DL Total
		case 10: 
		case 110: 
			return CompareUDTotal(item1, item2, SortPlus) * SortMode;
		// Friend
		case 11: 
			return item2->IsFriend() - item1->IsFriend();
		case 111: 
			return item1->IsFriend() - item2->IsFriend();
		// Client Software
		case 12:
		case 112:
			return CompareSoftware(item1, item2, SortPlus, SortMode);
		//
		case 1:
		{
			CKnownFile* file1 = theApp.sharedfiles->GetFileByID(item1->GetUploadFileID());
			CKnownFile* file2 = theApp.sharedfiles->GetFileByID(item2->GetUploadFileID());
			if( (file1 != NULL) && (file2 != NULL))
				return CompareLocaleStringNoCase( file1->GetFileName(), file2->GetFileName() );
			else if( file1 == NULL )
				return 1;
			else
				return -1;
		}
		case 101:
		{
			CKnownFile* file1 = theApp.sharedfiles->GetFileByID(item1->GetUploadFileID());
			CKnownFile* file2 = theApp.sharedfiles->GetFileByID(item2->GetUploadFileID());
			if( (file1 != NULL) && (file2 != NULL))
				return CompareLocaleStringNoCase( file2->GetFileName(), file1->GetFileName() );
			else if( file1 == NULL )
				return 1;
			else
				return -1;
		}
		case 3: 
			return CompareUnsigned(item1->GetScore(false,false,true), item2->GetScore(false,false,true));
		case 103: 
			return CompareUnsigned(item2->GetScore(false,false,true), item1->GetScore(false,false,true));

		case 5: 
			return item1->GetAskedCount() - item2->GetAskedCount();
		case 105: 
			return item2->GetAskedCount() - item1->GetAskedCount();
		
		case 6: 
			return item1->GetLastUpRequest() - item2->GetLastUpRequest();
		case 106: 
			return item2->GetLastUpRequest() - item1->GetLastUpRequest();
/* Original
	switch(lParamSort){
		case 0: 
			if(item1->GetUserName() && item2->GetUserName())
				return CompareLocaleStringNoCase(item1->GetUserName(), item2->GetUserName());
			else if(item1->GetUserName())
				return 1;
			else
				return -1;
		case 100:
			if(item2->GetUserName() && item1->GetUserName())
				return CompareLocaleStringNoCase(item2->GetUserName(), item1->GetUserName());
			else if(item2->GetUserName())
				return 1;
			else
				return -1;
		
		case 1: {
			CKnownFile* file1 = theApp.sharedfiles->GetFileByID(item1->GetUploadFileID());
			CKnownFile* file2 = theApp.sharedfiles->GetFileByID(item2->GetUploadFileID());
			if( (file1 != NULL) && (file2 != NULL))
				return CompareLocaleStringNoCase(file1->GetFileName(), file2->GetFileName());
			else if( file1 == NULL )
				return 1;
			else
				return -1;
		}
		case 101: {
			CKnownFile* file1 = theApp.sharedfiles->GetFileByID(item1->GetUploadFileID());
			CKnownFile* file2 = theApp.sharedfiles->GetFileByID(item2->GetUploadFileID());
			if( (file1 != NULL) && (file2 != NULL))
				return CompareLocaleStringNoCase(file2->GetFileName(), file1->GetFileName());
			else if( file1 == NULL )
				return 1;
			else
				return -1;
		}
		
		case 2: {
			CKnownFile* file1 = theApp.sharedfiles->GetFileByID(item1->GetUploadFileID());
			CKnownFile* file2 = theApp.sharedfiles->GetFileByID(item2->GetUploadFileID());
			if( (file1 != NULL) && (file2 != NULL))
				return ((file1->GetUpPriority()==PR_VERYLOW) ? -1 : file1->GetUpPriority()) - ((file2->GetUpPriority()==PR_VERYLOW) ? -1 : file2->GetUpPriority());
			else if( file1 == NULL )
				return 1;
			else
				return -1;
		}
		case 102:{
			CKnownFile* file1 = theApp.sharedfiles->GetFileByID(item1->GetUploadFileID());
			CKnownFile* file2 = theApp.sharedfiles->GetFileByID(item2->GetUploadFileID());
			if( (file1 != NULL) && (file2 != NULL))
				return ((file2->GetUpPriority()==PR_VERYLOW) ? -1 : file2->GetUpPriority()) - ((file1->GetUpPriority()==PR_VERYLOW) ? -1 : file1->GetUpPriority());
			else if( file1 == NULL )
				return 1;
			else
				return -1;
		}

		case 3: 
			return CompareUnsigned(item1->GetScore(false,false,true), item2->GetScore(false,false,true));
		case 103: 
			return CompareUnsigned(item2->GetScore(false,false,true), item1->GetScore(false,false,true));

		case 4: 
			return CompareUnsigned(item1->GetScore(false), item2->GetScore(false));
		case 104: 
			return CompareUnsigned(item2->GetScore(false), item1->GetScore(false));

		case 5: 
			return item1->GetAskedCount() - item2->GetAskedCount();
		case 105: 
			return item2->GetAskedCount() - item1->GetAskedCount();
		
		case 6: 
			return item1->GetLastUpRequest() - item2->GetLastUpRequest();
		case 106: 
			return item2->GetLastUpRequest() - item1->GetLastUpRequest();
		
		case 7: 
			return item1->GetWaitStartTime() - item2->GetWaitStartTime();
		case 107: 
			return item2->GetWaitStartTime() - item1->GetWaitStartTime();
*/		
		case 8: 
			return item1->IsBanned() - item2->IsBanned();
		case 108: 
			return item2->IsBanned() - item1->IsBanned();
		
		case 9: 
			return item1->GetUpPartCount() - item2->GetUpPartCount();
		case 109: 
			return item2->GetUpPartCount() - item1->GetUpPartCount();

		default:
			return 0;
	}
}

// Barry - Refresh the queue every 10 secs
void CALLBACK CQueueListCtrl::QueueUpdateTimer(HWND hwnd, UINT uiMsg, UINT idEvent, DWORD dwTime)
{
	// NOTE: Always handle all type of MFC exceptions in TimerProcs - otherwise we'll get mem leaks
	try
	{
		if (   !theApp.emuledlg->IsRunning() // Don't do anything if the app is shutting down - can cause unhandled exceptions
			|| !thePrefs.GetUpdateQueueList()
			|| theApp.emuledlg->activewnd != theApp.emuledlg->transferwnd
			|| !theApp.emuledlg->transferwnd->queuelistctrl.IsWindowVisible() )
			return;

// RT, Update
			theApp.uploadqueue->UpdateQueue();
	}
/* Original
		const CUpDownClient* update = theApp.uploadqueue->GetNextClient(NULL);
		while( update )
		{
			theApp.emuledlg->transferwnd->queuelistctrl.RefreshClient(update);
			update = theApp.uploadqueue->GetNextClient(update);
		}
	}
*/
	CATCH_DFLT_EXCEPTIONS(_T("CQueueListCtrl::QueueUpdateTimer"))
}

void CQueueListCtrl::ShowQueueClients()
{
	DeleteAllItems(); 
	CUpDownClient* update = theApp.uploadqueue->GetNextClient(NULL);
	while( update )
	{
		AddClient(update, false);
		update = theApp.uploadqueue->GetNextClient(update);
	}
}

void CQueueListCtrl::ShowSelectedUserDetails()
{
	POINT point;
	::GetCursorPos(&point);
	CPoint p = point; 
    ScreenToClient(&p); 
    int it = HitTest(p); 
    if (it == -1)
		return;

	SetItemState(-1, 0, LVIS_SELECTED);
	SetItemState(it, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
	SetSelectionMark(it);   // display selection mark correctly!

	CUpDownClient* client = (CUpDownClient*)GetItemData(GetSelectionMark());
	if (client){
		CClientDetailDialog dialog(client, this);
		dialog.DoModal();
	}
}

void CQueueListCtrl::OnNMDblclk(NMHDR *pNMHDR, LRESULT *pResult)
{
	int iSel = GetNextItem(-1, LVIS_SELECTED | LVIS_FOCUSED);
	if (iSel != -1) {
		CUpDownClient* client = (CUpDownClient*)GetItemData(iSel);
		if (client){
			CClientDetailDialog dialog(client, this);
			dialog.DoModal();
		}
	}
	*pResult = 0;
}

void CQueueListCtrl::OnGetDispInfo(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLVDISPINFO *pDispInfo = reinterpret_cast<NMLVDISPINFO*>(pNMHDR);

	if (theApp.emuledlg->IsRunning()){
		// Although we have an owner drawn listview control we store the text for the primary item in the listview, to be
		// capable of quick searching those items via the keyboard. Because our listview items may change their contents,
		// we do this via a text callback function. The listview control will send us the LVN_DISPINFO notification if
		// it needs to know the contents of the primary item.
		//
		// But, the listview control sends this notification all the time, even if we do not search for an item. At least
		// this notification is only sent for the visible items and not for all items in the list. Though, because this
		// function is invoked *very* often, no *NOT* put any time consuming code here in.

		if (pDispInfo->item.mask & LVIF_TEXT){
			const CUpDownClient* pClient = reinterpret_cast<CUpDownClient*>(pDispInfo->item.lParam);
			if (pClient != NULL){
				switch (pDispInfo->item.iSubItem){
					case 0:
						if (pClient->GetUserName() != NULL && pDispInfo->item.cchTextMax > 0){
							_tcsncpy(pDispInfo->item.pszText, pClient->GetUserName(), pDispInfo->item.cchTextMax);
							pDispInfo->item.pszText[pDispInfo->item.cchTextMax-1] = _T('\0');
						}
						break;
					default:
						// shouldn't happen
						pDispInfo->item.pszText[0] = _T('\0');
						break;
				}
			}
		}
	}
	*pResult = 0;
}
