//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "stdafx.h"
#include "emule.h"
#include "UploadQueue.h"
#include "Packets.h"
#include "KnownFile.h"
#include "ListenSocket.h"
#include "Exceptions.h"
#include "Scheduler.h"
#include "PerfLog.h"
#include "UploadBandwidthThrottler.h"
#include "ClientList.h"
#include "LastCommonRouteFinder.h"
#include "DownloadQueue.h"
#include "FriendList.h"
#include "Statistics.h"
#include "MMServer.h"
#include "OtherFunctions.h"
#include "UpDownClient.h"
#include "SharedFileList.h"
#include "KnownFileList.h"
#include "Sockets.h"
#include "ClientCredits.h"
#include "Server.h"
#include "ServerList.h"
#include "WebServer.h"
#include "emuledlg.h"
#include "ServerWnd.h"
#include "TransferWnd.h"
#include "SearchDlg.h"
#include "StatisticsDlg.h"
#include "Kademlia/Kademlia/Kademlia.h"
#include "Kademlia/Kademlia/Prefs.h"
#include "Log.h"
// RT, Include
#include <math.h>
#include "PartFile.h"
#include "0RatioFile/RT_Opcodes.h"
// End

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


static uint32 counter, sec, statsave;
static UINT _uSaveStatistics = 0;
// -khaos--+++> Added iupdateconnstats...
static uint32 igraph, istats, iupdateconnstats;
// <-----khaos-

//TODO rewrite the whole networkcode, use overlapped sockets.. sure....

CUploadQueue::CUploadQueue()
{
	VERIFY( (h_timer = SetTimer(0,0,100,UploadTimer)) != NULL );
// RT, Initial
	// Special count in the queue
	rt_InvalidCount = 0;
	rt_LeecherCount = 0;
	rt_GPLEvildoerCount = 0;
	rt_FriendCount = 0;
	// Release Slot
	rt_ReleaseSlotCount = 0;
	rt_ReleaseSlotLowID = false;
	// Credit1 Slot
	rt_ReleaseSlotCount = 0;
	rt_Credit1SlotLowID = false;
	//
	rt_UpdatingQueue = false;
// End
	if (thePrefs.GetVerbose() && !h_timer)
		AddDebugLogLine(true,_T("Failed to create 'upload queue' timer - %s"),GetErrorMessage(GetLastError()));
	datarate = 0;
	counter=0;
	successfullupcount = 0;
	failedupcount = 0;
	totaluploadtime = 0;
	m_nLastStartUpload = 0;
	statsave=0;
	// -khaos--+++>
	iupdateconnstats=0;
	// <-----khaos-
	m_dwRemovedClientByScore = ::GetTickCount();
    m_iHighestNumberOfFullyActivatedSlotsSinceLastCall = 0;
    m_MaxActiveClients = 0;
    m_MaxActiveClientsShortTime = 0;

    m_lastCalculatedDataRateTick = 0;
    m_avarage_dr_sum = 0;
    friendDatarate = 0;

    m_dwLastResortedUploadSlots = 0;
}

/**
 * Find the highest ranking client in the waiting queue, and return it.
 *
 * Low id client are ranked as lowest possible, unless they are currently connected.
 * A low id client that is not connected, but would have been ranked highest if it
 * had been connected, gets a flag set. This flag means that the client should be
 * allowed to get an upload slot immediately once it connects.
 *
 * @return address of the highest ranking client.
 */
CUpDownClient* CUploadQueue::FindBestClientInQueue()
{
	POSITION toadd = 0;
	POSITION toaddlow = 0;
	uint32	bestscore = 0;
	uint32  bestlowscore = 0;
    CUpDownClient* newclient = NULL;
    CUpDownClient* lowclient = NULL;

	POSITION pos1, pos2;
	for (pos1 = waitinglist.GetHeadPosition();( pos2 = pos1 ) != NULL;)
	{
		waitinglist.GetNext(pos1);
		CUpDownClient* cur_client =	waitinglist.GetAt(pos2);
		//While we are going through this list.. Lets check if a client appears to have left the network..
		ASSERT ( cur_client->GetLastUpRequest() );
		if ((::GetTickCount() - cur_client->GetLastUpRequest() > MAX_PURGEQUEUETIME) || !theApp.sharedfiles->GetFileByID(cur_client->GetUploadFileID()) )
		{
// RT, Upload Queue Waited Time
			if (thePrefs.IsRecordUploadQueueWaitedTime() == true)
				cur_client->SetUploadQueueWaitedTime( cur_client->GetWaitTime(true) );
// End
			//This client has either not been seen in a long time, or we no longer share the file he wanted anymore..
			cur_client->ClearWaitStartTime();
			RemoveFromWaitingQueue(pos2,true);
			continue;
		}
        else
        {
		    // finished clearing
		    uint32 cur_score = cur_client->GetScore(false);

		    if ( cur_score > bestscore)
		    {
                // cur_client is more worthy than current best client that is ready to go (connected).
                if(!cur_client->HasLowID() || (cur_client->socket && cur_client->socket->IsConnected())) {
                    // this client is a HighID or a lowID client that is ready to go (connected)
                    // and it is more worthy
			        bestscore = cur_score;
			        toadd = pos2;
                    newclient = waitinglist.GetAt(toadd);
                } 
				else if(!cur_client->m_bAddNextConnect) 
				{
                    // this client is a lowID client that is not ready to go (not connected)
    
                    // now that we know this client is not ready to go, compare it to the best not ready client
                    // the best not ready client may be better than the best ready client, so we need to check
                    // against that client
			        if (cur_score > bestlowscore)
			        {
                        // it is more worthy, keep it
				        bestlowscore = cur_score;
				        toaddlow = pos2;
                        lowclient = waitinglist.GetAt(toaddlow);
			        }
                }
            } 
		}
	}
	
	if (bestlowscore > bestscore && lowclient)
		lowclient->m_bAddNextConnect = true;

    if (!toadd)
		return NULL;
    else
	    return waitinglist.GetAt(toadd);
}

void CUploadQueue::InsertInUploadingList(CUpDownClient* newclient) 
{
	//Lets make sure any client that is added to the list has this flag reset!
	newclient->m_bAddNextConnect = false;
    // Add it last
    theApp.uploadBandwidthThrottler->AddToStandardList(uploadinglist.GetCount(), newclient->GetFileUploadSocket());
	uploadinglist.AddTail(newclient);
    newclient->SetSlotNumber(uploadinglist.GetCount());
}

// RT, New Code at Bottom
/* Original
bool CUploadQueue::AddUpNextClient(LPCTSTR pszReason, CUpDownClient* directadd){
	CUpDownClient* newclient = NULL;
	// select next client or use given client
	if (!directadd)
	{
        newclient = FindBestClientInQueue();

        if(newclient)
		{
		    RemoveFromWaitingQueue(newclient, true);
		    theApp.emuledlg->transferwnd->ShowQueueCount(waitinglist.GetCount());
        }
	}
	else 
		newclient = directadd;

    if(newclient == NULL) 
        return false;

	if (!thePrefs.TransferFullChunks())
		UpdateMaxClientScore(); // refresh score caching, now that the highest score is removed

	if (IsDownloading(newclient))
		return false;

    if(pszReason && thePrefs.GetLogUlDlEvents())
        AddDebugLogLine(false, _T("Adding client to upload list: %s Client: %s"), pszReason, newclient->DbgGetClientInfo());

	// tell the client that we are now ready to upload
	if (!newclient->socket || !newclient->socket->IsConnected())
	{
		newclient->SetUploadState(US_CONNECTING);
		if (!newclient->TryToConnect(true))
			return false;
	}
	else
	{
		if (thePrefs.GetDebugClientTCPLevel() > 0)
			DebugSend("OP__AcceptUploadReq", newclient);
		Packet* packet = new Packet(OP_ACCEPTUPLOADREQ,0);
		theStats.AddUpDataOverheadFileRequest(packet->size);
		newclient->socket->SendPacket(packet,true);
		newclient->SetUploadState(US_UPLOADING);
	}
	newclient->SetUpStartTime();
	newclient->ResetSessionUp();

    InsertInUploadingList(newclient);

    m_nLastStartUpload = ::GetTickCount();
	
	// statistic
	CKnownFile* reqfile = theApp.sharedfiles->GetFileByID((uchar*)newclient->GetUploadFileID());
	if (reqfile)
		reqfile->statistic.AddAccepted();
		
	theApp.emuledlg->transferwnd->uploadlistctrl.AddClient(newclient);

	return true;
}
*/

void CUploadQueue::UpdateActiveClientsInfo(DWORD curTick) {
    // Save number of active clients for statistics
    uint32 tempHighest = theApp.uploadBandwidthThrottler->GetHighestNumberOfFullyActivatedSlotsSinceLastCallAndReset();

    if(thePrefs.GetLogUlDlEvents() && theApp.uploadBandwidthThrottler->GetStandardListSize() > (uint32)uploadinglist.GetSize()) {
        // debug info, will remove this when I'm done.
        //AddDebugLogLine(false, _T("UploadQueue: Error! Throttler has more slots than UploadQueue! Throttler: %i UploadQueue: %i Tick: %i"), theApp.uploadBandwidthThrottler->GetStandardListSize(), uploadinglist.GetSize(), ::GetTickCount());

		if(tempHighest > (uint32)uploadinglist.GetSize()) {
        	tempHighest = uploadinglist.GetSize();
		}
    }

    m_iHighestNumberOfFullyActivatedSlotsSinceLastCall = tempHighest;

    // save 15 minutes of data about number of fully active clients
    uint32 tempMaxRemoved = -1;
    while(!activeClients_tick_list.IsEmpty() && !activeClients_list.IsEmpty() && curTick-activeClients_tick_list.GetHead() > 20*1000) {
        activeClients_tick_list.RemoveHead();
	    uint32 removed = activeClients_list.RemoveHead();

        if(removed > tempMaxRemoved) {
            tempMaxRemoved = removed;
        }
    }

	activeClients_list.AddTail(m_iHighestNumberOfFullyActivatedSlotsSinceLastCall);
    activeClients_tick_list.AddTail(curTick);

    if(activeClients_tick_list.GetSize() > 1) {
        uint32 tempMaxActiveClients = m_iHighestNumberOfFullyActivatedSlotsSinceLastCall;
        uint32 tempMaxActiveClientsShortTime = m_iHighestNumberOfFullyActivatedSlotsSinceLastCall;
        POSITION activeClientsTickPos = activeClients_tick_list.GetTailPosition();
        POSITION activeClientsListPos = activeClients_list.GetTailPosition();
        while(activeClientsListPos != NULL && (tempMaxRemoved > tempMaxActiveClients && tempMaxRemoved >= m_MaxActiveClients || curTick - activeClients_tick_list.GetAt(activeClientsTickPos) < 10 * 1000)) {
            DWORD activeClientsTickSnapshot = activeClients_tick_list.GetAt(activeClientsTickPos);
            uint32 activeClientsSnapshot = activeClients_list.GetAt(activeClientsListPos);

            if(activeClientsSnapshot > tempMaxActiveClients) {
                tempMaxActiveClients = activeClientsSnapshot;
            }

            if(activeClientsSnapshot > tempMaxActiveClientsShortTime && curTick - activeClientsTickSnapshot < 10 * 1000) {
                tempMaxActiveClientsShortTime = activeClientsSnapshot;
            }

            activeClients_tick_list.GetPrev(activeClientsTickPos);
            activeClients_list.GetPrev(activeClientsListPos);
        }

        if(tempMaxRemoved > m_MaxActiveClients) {
            m_MaxActiveClients = tempMaxActiveClients;
        }

        m_MaxActiveClientsShortTime = tempMaxActiveClientsShortTime;
    } else {
        m_MaxActiveClients = m_iHighestNumberOfFullyActivatedSlotsSinceLastCall;
        m_MaxActiveClientsShortTime = m_iHighestNumberOfFullyActivatedSlotsSinceLastCall;
    }
}

/**
 * Maintenance method for the uploading slots. It adds and removes clients to the
 * uploading list. It also makes sure that all the uploading slots' Sockets always have
 * enough packets in their queues, etc.
 *
 * This method is called approximately once every 100 milliseconds.
 */
void CUploadQueue::Process() {

    DWORD curTick = ::GetTickCount();

// RT, UpdateActiveClientsInfo() Move to UploadTimer(), one second
	// Accept new client
	if ( (AcceptNewClient() == true) && (waitinglist.GetCount() > 0) )
	{
		m_nLastStartUpload = ::GetTickCount();
		AddUpNextClient( _T("Not enough open upload slots for current ul speed") );
	}
/* Original
    UpdateActiveClientsInfo(curTick);

	if (ForceNewClient()){
        // There's not enough open uploads. Open another one.
        AddUpNextClient(_T("Not enough open upload slots for current ul speed"));
	}
*/
    // The loop that feeds the upload slots with data.
	POSITION pos = uploadinglist.GetHeadPosition();
	while(pos != NULL){
        // Get the client. Note! Also updates pos as a side effect.
		CUpDownClient* cur_client = uploadinglist.GetNext(pos);
		if (thePrefs.m_iDbgHeap >= 2)
			ASSERT_VALID(cur_client);
		//It seems chatting or friend slots can get stuck at times in upload.. This needs looked into..
		if (!cur_client->socket)
		{
			RemoveFromUploadQueue(cur_client, _T("Uploading to client without socket? (CUploadQueue::Process)"));
			if(cur_client->Disconnected(_T("CUploadQueue::Process"))){
				delete cur_client;
			}
		} else {
            cur_client->SendBlockData();
        }
	}

    // Save used bandwidth for speed calculations
	uint64 sentBytes = theApp.uploadBandwidthThrottler->GetNumberOfSentBytesSinceLastCallAndReset();
	avarage_dr_list.AddTail(sentBytes);
    m_avarage_dr_sum += sentBytes;

    (void)theApp.uploadBandwidthThrottler->GetNumberOfSentBytesOverheadSinceLastCallAndReset();

    avarage_friend_dr_list.AddTail(theStats.sessionSentBytesToFriend);

    // Save time beetween each speed snapshot
    avarage_tick_list.AddTail(curTick);

    // don't save more than 30 secs of data
    while(avarage_tick_list.GetCount() > 3 && !avarage_friend_dr_list.IsEmpty() && ::GetTickCount()-avarage_tick_list.GetHead() > 30*1000) {
   	    m_avarage_dr_sum -= avarage_dr_list.RemoveHead();
        avarage_friend_dr_list.RemoveHead();
        avarage_tick_list.RemoveHead();
    }
};

// RT, New Code at Bottom
/* Original
bool CUploadQueue::AcceptNewClient(bool addOnNextConnect)
{
	uint32 curUploadSlots = (uint32)uploadinglist.GetCount();

	//We allow ONE extra slot to be created to accommodate lowID users.
	//This is because we skip these users when it was actually their turn
	//to get an upload slot..
	if(addOnNextConnect && curUploadSlots > 0)
		curUploadSlots--;		

    return AcceptNewClient(curUploadSlots);
}
*/

bool CUploadQueue::AcceptNewClient(uint32 curUploadSlots){
	// check if we can allow a new client to start downloading from us

	if (curUploadSlots < MIN_UP_CLIENTS_ALLOWED)
		return true;

	uint16 MaxSpeed;

    if (thePrefs.IsDynUpEnabled())
        MaxSpeed = theApp.lastCommonRouteFinder->GetUpload()/1024;        
    else
		MaxSpeed = thePrefs.GetMaxUpload();
	
	if (curUploadSlots >= MAX_UP_CLIENTS_ALLOWED ||
        curUploadSlots >= 4 &&
        (
         curUploadSlots >= (datarate/UPLOAD_CHECK_CLIENT_DR) ||
         curUploadSlots >= ((uint32)MaxSpeed)*1024/UPLOAD_CLIENT_DATARATE ||
         (
          thePrefs.GetMaxUpload() == UNLIMITED &&
          !thePrefs.IsDynUpEnabled() &&
          thePrefs.GetMaxGraphUploadRate() > 0 &&
          curUploadSlots >= ((uint32)thePrefs.GetMaxGraphUploadRate())*1024/UPLOAD_CLIENT_DATARATE
         )
        )
    ) // max number of clients to allow for all circumstances
	    return false;

	return true;
}

bool CUploadQueue::ForceNewClient(bool allowEmptyWaitingQueue) {
    if(!allowEmptyWaitingQueue && waitinglist.GetSize() <= 0)
        return false;

	if (::GetTickCount() - m_nLastStartUpload < 1000 && datarate < 102400 )
		return false;

	uint32 curUploadSlots = (uint32)uploadinglist.GetCount();

	if (curUploadSlots < MIN_UP_CLIENTS_ALLOWED)
		return true;

    if(!AcceptNewClient(curUploadSlots) || !theApp.lastCommonRouteFinder->AcceptNewClient()) { // UploadSpeedSense can veto a new slot if USS enabled
		return false;
    }

	uint16 MaxSpeed;

    if (thePrefs.IsDynUpEnabled())
        MaxSpeed = theApp.lastCommonRouteFinder->GetUpload()/1024;        
    else
		MaxSpeed = thePrefs.GetMaxUpload();

	uint32 upPerClient = UPLOAD_CLIENT_DATARATE;

    // if throttler doesn't require another slot, go with a slightly more restrictive method
	if( MaxSpeed > 20 || MaxSpeed == UNLIMITED)
		upPerClient += datarate/43;

	if( upPerClient > 7680 )
		upPerClient = 7680;

	//now the final check

	if ( MaxSpeed == UNLIMITED )
	{
		if (curUploadSlots < (datarate/upPerClient))
			return true;
	}
	else{
		uint16 nMaxSlots;
		if (MaxSpeed > 12)
			nMaxSlots = (uint16)(((float)(MaxSpeed*1024)) / upPerClient);
		else if (MaxSpeed > 7)
			nMaxSlots = MIN_UP_CLIENTS_ALLOWED + 2;
		else if (MaxSpeed > 3)
			nMaxSlots = MIN_UP_CLIENTS_ALLOWED + 1;
		else
			nMaxSlots = MIN_UP_CLIENTS_ALLOWED;
//		AddLogLine(true,"maxslots=%u, upPerClient=%u, datarateslot=%u|%u|%u",nMaxSlots,upPerClient,datarate/UPLOAD_CHECK_CLIENT_DR, datarate, UPLOAD_CHECK_CLIENT_DR);

		if ( curUploadSlots < nMaxSlots )
		{
			return true;
		}
	}

    if(m_iHighestNumberOfFullyActivatedSlotsSinceLastCall > (uint32)uploadinglist.GetSize()) {
        // uploadThrottler requests another slot. If throttler says it needs another slot, we will allow more slots
        // than what we require ourself. Never allow more slots than to give each slot high enough average transfer speed, though (checked above).
        if(thePrefs.GetLogUlDlEvents() && waitinglist.GetSize() > 0)
            AddDebugLogLine(false, _T("UploadQueue: Added new slot since throttler needs it. m_iHighestNumberOfFullyActivatedSlotsSinceLastCall: %i uploadinglist.GetSize(): %i tick: %i"), m_iHighestNumberOfFullyActivatedSlotsSinceLastCall, uploadinglist.GetSize(), ::GetTickCount());
        return true;
    }

    //nope
	return false;
}
    
CUploadQueue::~CUploadQueue(){
	if (h_timer)
		KillTimer(0,h_timer);
}

CUpDownClient* CUploadQueue::GetWaitingClientByIP_UDP(uint32 dwIP, uint16 nUDPPort){
	for (POSITION pos = waitinglist.GetHeadPosition();pos != 0;){
		CUpDownClient* cur_client = waitinglist.GetNext(pos);
		if (dwIP == cur_client->GetIP() && nUDPPort == cur_client->GetUDPPort())
			return cur_client;
	}
	return 0;
}

CUpDownClient* CUploadQueue::GetWaitingClientByIP(uint32 dwIP){
	for (POSITION pos = waitinglist.GetHeadPosition();pos != 0;){
		CUpDownClient* cur_client = waitinglist.GetNext(pos);
		if (dwIP == cur_client->GetIP())
			return cur_client;
	}
	return 0;
}

/**
 * Add a client to the waiting queue for uploads.
 *
 * @param client address of the client that should be added to the waiting queue
 *
 * @param bIgnoreTimelimit don't check time limit to possibly ban the client.
 */
// RT, New Code at Bottom
/* Original
void CUploadQueue::AddClientToQueue(CUpDownClient* client, bool bIgnoreTimelimit)
{
	//This is to keep users from abusing the limits we put on lowID callbacks.
	//1)Check if we are connected to any network and that we are a lowID.
	//(Although this check shouldn't matter as they wouldn't have found us..
	// But, maybe I'm missing something, so it's best to check as a precaution.)
	//2)Check if the user is connected to Kad. We do allow all Kad Callbacks.
	//3)Check if the user is in our download list or a friend..
	//We give these users a special pass as they are helping us..
	//4)Are we connected to a server? If we are, is the user on the same server?
	//TCP lowID callbacks are also allowed..
	//5)If the queue is very short, allow anyone in as we want to make sure
	//our upload is always used.
	if (theApp.IsConnected() 
		&& theApp.IsFirewalled()
		&& !client->GetKadPort()
		&& client->GetDownloadState() == DS_NONE 
		&& !client->IsFriend()
		&& theApp.serverconnect
		&& !theApp.serverconnect->IsLocalServer(client->GetServerIP(),client->GetServerPort())
		&& GetWaitingUserCount() > 50)
		return;
	client->AddAskedCount();
	client->SetLastUpRequest();
	if (!bIgnoreTimelimit)
		client->AddRequestCount(client->GetUploadFileID());
	if (client->IsBanned())
		return;
	uint16 cSameIP = 0;
	// check for double
	POSITION pos1, pos2;
	for (pos1 = waitinglist.GetHeadPosition();( pos2 = pos1 ) != NULL;)
	{
		waitinglist.GetNext(pos1);
		CUpDownClient* cur_client= waitinglist.GetAt(pos2);
		if (cur_client == client)
		{	
			if (client->m_bAddNextConnect && AcceptNewClient(client->m_bAddNextConnect))
			{
				//Special care is given to lowID clients that missed their upload slot
				//due to the saving bandwidth on callbacks.
				if(thePrefs.GetLogUlDlEvents())
					AddDebugLogLine(true, _T("Adding ****lowid when reconneting. Client: %s"), client->DbgGetClientInfo());
				client->m_bAddNextConnect = false;
				RemoveFromWaitingQueue(client, true);
				AddUpNextClient(_T("Adding ****lowid when reconneting."), client);
				return;
			}
			client->SendRankingInfo();
			theApp.emuledlg->transferwnd->queuelistctrl.RefreshClient(client);
			return;			
		}
		else if ( client->Compare(cur_client) ) 
		{
			theApp.clientlist->AddTrackClient(client); // in any case keep track of this client

			// another client with same ip:port or hash
			// this happens only in rare cases, because same userhash / ip:ports are assigned to the right client on connecting in most cases
			if (cur_client->credits != NULL && cur_client->credits->GetCurrentIdentState(cur_client->GetIP()) == IS_IDENTIFIED)
			{
				//cur_client has a valid secure hash, don't remove him
				if (thePrefs.GetVerbose())
					AddDebugLogLine(false,CString(GetResString(IDS_SAMEUSERHASH)),client->GetUserName(),cur_client->GetUserName(),client->GetUserName() );
				return;
			}
			if (client->credits != NULL && client->credits->GetCurrentIdentState(client->GetIP()) == IS_IDENTIFIED)
			{
				//client has a valid secure hash, add him remove other one
				if (thePrefs.GetVerbose())
					AddDebugLogLine(false,CString(GetResString(IDS_SAMEUSERHASH)),client->GetUserName(),cur_client->GetUserName(),cur_client->GetUserName() );
				RemoveFromWaitingQueue(pos2,true);
				if (!cur_client->socket)
				{
					if(cur_client->Disconnected(_T("AddClientToQueue - same userhash 1")))
						delete cur_client;
				}
			}
			else
			{
				// remove both since we do not know who the bad one is
				if (thePrefs.GetVerbose())
					AddDebugLogLine(false,CString(GetResString(IDS_SAMEUSERHASH)),client->GetUserName(),cur_client->GetUserName(),"Both" );
				RemoveFromWaitingQueue(pos2,true);	
				if (!cur_client->socket)
				{
					if(cur_client->Disconnected(_T("AddClientToQueue - same userhash 2")))
						delete cur_client;
				}
				return;
			}
		}
		else if (client->GetIP() == cur_client->GetIP())
		{
			// same IP, different port, different userhash
			cSameIP++;
		}
	}
	if (cSameIP >= 3)
	{
		// do not accept more than 3 clients from the same IP
		if (thePrefs.GetVerbose())
			DEBUG_ONLY( AddDebugLogLine(false,_T("%s's (%s) request to enter the queue was rejected, because of too many clients with the same IP"), client->GetUserName(), ipstr(client->GetConnectIP())) );
		return;
	}
	else if (theApp.clientlist->GetClientsFromIP(client->GetIP()) >= 3)
	{
		if (thePrefs.GetVerbose())
			DEBUG_ONLY( AddDebugLogLine(false,_T("%s's (%s) request to enter the queue was rejected, because of too many clients with the same IP (found in TrackedClientsList)"), client->GetUserName(), ipstr(client->GetConnectIP())) );
		return;
	}
	// done

	// statistic values
	CKnownFile* reqfile = theApp.sharedfiles->GetFileByID((uchar*)client->GetUploadFileID());
	if (reqfile)
		reqfile->statistic.AddRequest();

   // cap the list
    // the queue limit in prefs is only a soft limit. Hard limit is 25% higher, to let in powershare clients and other
    // high ranking clients after soft limit has been reached
    uint32 softQueueLimit = thePrefs.GetQueueSize();
    uint32 hardQueueLimit = thePrefs.GetQueueSize() + max(thePrefs.GetQueueSize()/4, 200);

    // if soft queue limit has been reached, only let in high ranking clients
    if ((uint32)waitinglist.GetCount() >= hardQueueLimit ||
        (uint32)waitinglist.GetCount() >= softQueueLimit && // soft queue limit is reached
        (client->IsFriend() && client->GetFriendSlot()) == false && // client is not a friend with friend slot
        client->GetCombinedFilePrioAndCredit() < GetAverageCombinedFilePrioAndCredit()) { // and client has lower credits/wants lower prio file than average client in queue

        // then block client from getting on queue
		return;
	}
	if (client->IsDownloading())
	{
		// he's already downloading and wants probably only another file
		if (thePrefs.GetDebugClientTCPLevel() > 0)
			DebugSend("OP__AcceptUploadReq", client);
		Packet* packet = new Packet(OP_ACCEPTUPLOADREQ,0);
		theStats.AddUpDataOverheadFileRequest(packet->size);
		client->socket->SendPacket(packet,true);
		return;
	}
	if (waitinglist.IsEmpty() && AcceptNewClient())
	{
		AddUpNextClient(_T("Direct add with empty queue."), client);
	}
	else
	{
		waitinglist.AddTail(client);
		client->SetUploadState(US_ONUPLOADQUEUE);
		theApp.emuledlg->transferwnd->queuelistctrl.AddClient(client,true);
		theApp.emuledlg->transferwnd->ShowQueueCount(waitinglist.GetCount());
		client->SendRankingInfo();
	}
}
*/

float CUploadQueue::GetAverageCombinedFilePrioAndCredit() {
    DWORD curTick = ::GetTickCount();

    if (curTick - m_dwLastCalculatedAverageCombinedFilePrioAndCredit > 5*1000) {
        m_dwLastCalculatedAverageCombinedFilePrioAndCredit = curTick;

        // TODO: is there a risk of overflow? I don't think so...
        double sum = 0;
	    for (POSITION pos = waitinglist.GetHeadPosition(); pos != NULL; /**/){
		    CUpDownClient* cur_client =	waitinglist.GetNext(pos);
            sum += cur_client->GetCombinedFilePrioAndCredit();
        }
        m_fAverageCombinedFilePrioAndCredit = sum/waitinglist.GetSize();
    }

    return m_fAverageCombinedFilePrioAndCredit;
}

// RT, New Code at Bottom
/* Original
bool CUploadQueue::RemoveFromUploadQueue(CUpDownClient* client, LPCTSTR pszReason, bool updatewindow, bool earlyabort){
    bool result = false;
    uint32 slotCounter = 1;
	for (POSITION pos = uploadinglist.GetHeadPosition();pos != 0;){
        POSITION curPos = pos;
        CUpDownClient* curClient = uploadinglist.GetNext(pos);
		if (client == curClient){
			if (updatewindow)
				theApp.emuledlg->transferwnd->uploadlistctrl.RemoveClient(client);

			if (thePrefs.GetLogUlDlEvents())
                AddDebugLogLine(DLP_VERYLOW, true,_T("Removing client from upload list: %s Client: %s Transferred: %s SessionUp: %s QueueSessionPayload: %s"), pszReason==NULL ? _T("") : pszReason, client->DbgGetClientInfo(), CastSecondsToHM( client->GetUpStartTimeDelay()/1000), CastItoXBytes(client->GetSessionUp(), false, false), CastItoXBytes(client->GetQueueSessionPayloadUp(), false, false));
            client->m_bAddNextConnect = false;
			uploadinglist.RemoveAt(curPos);

            bool removed = theApp.uploadBandwidthThrottler->RemoveFromStandardList(client->socket);
            bool pcRemoved = theApp.uploadBandwidthThrottler->RemoveFromStandardList((CClientReqSocket*)client->m_pPCUpSocket);
			(void)removed;
			(void)pcRemoved;
            //if(thePrefs.GetLogUlDlEvents() && !(removed || pcRemoved)) {
            //    AddDebugLogLine(false, _T("UploadQueue: Didn't find socket to delete. Adress: 0x%x"), client->socket);
            //}

			if(client->GetSessionUp() > 0) {
				++successfullupcount;
				totaluploadtime += client->GetUpStartTimeDelay()/1000;
            } else if(earlyabort == false)
				++failedupcount;

            CKnownFile* requestedFile = theApp.sharedfiles->GetFileByID(client->GetUploadFileID());
            if(requestedFile != NULL) {
                requestedFile->UpdatePartsInfo();
            }
			theApp.clientlist->AddTrackClient(client); // Keep track of this client
			client->SetUploadState(US_NONE);
			client->ClearUploadBlockRequests();

            m_iHighestNumberOfFullyActivatedSlotsSinceLastCall = 0;

			result = true;
        } else {
            curClient->SetSlotNumber(slotCounter);
            slotCounter++;
        }
	}
	return result;
}
*/

uint32 CUploadQueue::GetAverageUpTime(){
	if( successfullupcount ){
		return totaluploadtime/successfullupcount;
	}
	return 0;
}

bool CUploadQueue::RemoveFromWaitingQueue(CUpDownClient* client, bool updatewindow){
	POSITION pos = waitinglist.Find(client);
	if (pos){
		RemoveFromWaitingQueue(pos,updatewindow);
		if (updatewindow)
			theApp.emuledlg->transferwnd->ShowQueueCount(waitinglist.GetCount());
		client->m_bAddNextConnect = false;
		return true;
	}
	else
		return false;
}

void CUploadQueue::RemoveFromWaitingQueue(POSITION pos, bool updatewindow){	
	CUpDownClient* todelete = waitinglist.GetAt(pos);
	waitinglist.RemoveAt(pos);
	if (updatewindow)
		theApp.emuledlg->transferwnd->queuelistctrl.RemoveClient(todelete);
	todelete->SetUploadState(US_NONE);
}

void CUploadQueue::UpdateMaxClientScore()
{
	m_imaxscore=0;
	for(POSITION pos = waitinglist.GetHeadPosition(); pos != 0; ) {
		uint32 score = waitinglist.GetNext(pos)->GetScore(true, false);
		if(score > m_imaxscore )
			m_imaxscore=score;
	}
}

// RT, New Code at Bottom
/* Original
bool CUploadQueue::CheckForTimeOver(CUpDownClient* client){
	//If we have nobody in the queue, do NOT remove the current uploads..
	//This will save some bandwidth and some unneeded swapping from upload/queue/upload..
	if ( waitinglist.IsEmpty() || client->GetFriendSlot() )
		return false;
	if (!thePrefs.TransferFullChunks()){
	    if( client->GetUpStartTimeDelay() > SESSIONMAXTIME){ // Try to keep the clients from downloading for ever
		    if (thePrefs.GetLogUlDlEvents())
			    AddDebugLogLine(DLP_LOW, false, _T("%s: Upload session ended due to max time %s."), client->GetUserName(), CastSecondsToHM(SESSIONMAXTIME/1000));
		    return true;
	    }

		// Cache current client score
		const uint32 score = client->GetScore(true, true);

		// Check if another client has a bigger score
		if (score < GetMaxClientScore() && m_dwRemovedClientByScore < GetTickCount()) {
			if (thePrefs.GetLogUlDlEvents())
				AddDebugLogLine(DLP_VERYLOW, false, _T("%s: Upload session ended due to score."), client->GetUserName());
			//Set timer to prevent to many uploadslot getting kick do to score.
			//Upload slots are delayed by a min of 1 sec and the maxscore is reset every 5 sec.
			//So, I choose 6 secs to make sure the maxscore it updated before doing this again.
			m_dwRemovedClientByScore = GetTickCount()+SEC2MS(6);
			return true;
		}
	}
	else{
		// Allow the client to download a specified amount per session
		if( client->GetQueueSessionPayloadUp() > SESSIONMAXTRANS ){
			if (thePrefs.GetLogUlDlEvents())
				AddDebugLogLine(DLP_DEFAULT, false, _T("%s: Upload session ended due to max transferred amount. %s"), client->GetUserName(), CastItoXBytes(SESSIONMAXTRANS, false, false));
			return true;
		}
	}
	return false;
}
*/

void CUploadQueue::DeleteAll(){
	waitinglist.RemoveAll();
	uploadinglist.RemoveAll();
    // PENDING: Remove from UploadBandwidthThrottler as well!
}

// RT, New Code at Bottom
/* Original
uint16 CUploadQueue::GetWaitingPosition(CUpDownClient* client)
{
	if (!IsOnUploadQueue(client))
		return 0;
	UINT rank = 1;
	uint32 myscore = client->GetScore(false);
	for (POSITION pos = waitinglist.GetHeadPosition(); pos != 0; ){
		if (waitinglist.GetNext(pos)->GetScore(false) > myscore)
			rank++;
	}
	return rank;
}

VOID CALLBACK CUploadQueue::UploadTimer(HWND hwnd, UINT uMsg,UINT_PTR idEvent,DWORD dwTime)
{
	// NOTE: Always handle all type of MFC exceptions in TimerProcs - otherwise we'll get mem leaks
	try
	{
		// Barry - Don't do anything if the app is shutting down - can cause unhandled exceptions
		if (!theApp.emuledlg->IsRunning())
			return;

        // Elandal:ThreadSafeLogging -->
        // other threads may have queued up log lines. This prints them.
        theApp.HandleDebugLogQueue();
        theApp.HandleLogQueue();
        // Elandal: ThreadSafeLogging <--

		// ZZ:UploadSpeedSense -->
		theApp.lastCommonRouteFinder->SetPrefs(thePrefs.IsDynUpEnabled(), theApp.uploadqueue->GetDatarate(), thePrefs.GetMinUpload()*1024, (thePrefs.GetMaxUpload() != 0)?thePrefs.GetMaxUpload()*1024:thePrefs.GetMaxGraphUploadRate()*1024, thePrefs.IsDynUpUseMillisecondPingTolerance(), (thePrefs.GetDynUpPingTolerance() > 100)?((thePrefs.GetDynUpPingTolerance()-100)/100.0f):0, thePrefs.GetDynUpPingToleranceMilliseconds(), thePrefs.GetDynUpGoingUpDivider(), thePrefs.GetDynUpGoingDownDivider(), thePrefs.GetDynUpNumberOfPings(), 20); // PENDING: Hard coded min pLowestPingAllowed
		// ZZ:UploadSpeedSense <--

        theApp.uploadqueue->Process();
		theApp.downloadqueue->Process();
		if (thePrefs.ShowOverhead()){
			theStats.CompUpDatarateOverhead();
			theStats.CompDownDatarateOverhead();
		}
		counter++;

		// one second
		if (counter >= 10){
			counter=0;

			// try to use different time intervals here to not create any disk-IO bottle necks by saving all files at once
			theApp.clientcredits->Process();	// 13 minutes
			theApp.serverlist->Process();		// 17 minutes
			theApp.knownfiles->Process();		// 11 minutes
			theApp.friendlist->Process();		// 19 minutes
			theApp.clientlist->Process();
			theApp.sharedfiles->Process();
			if( Kademlia::CKademlia::isRunning() )
			{
				Kademlia::CKademlia::process();
				if(Kademlia::CKademlia::getPrefs()->hasLostConnection())
				{
					Kademlia::CKademlia::stop();
					theApp.emuledlg->ShowConnectionState();
				}
			}
			if( theApp.serverconnect->IsConnecting() && !theApp.serverconnect->IsSingleConnect() )
				theApp.serverconnect->TryAnotherConnectionrequest();

			theApp.listensocket->UpdateConnectionsStatus();
			if (thePrefs.WatchClipboard4ED2KLinks())
				theApp.SearchClipboard();		

			if (theApp.serverconnect->IsConnecting())
				theApp.serverconnect->CheckForTimeout();

			// -khaos--+++> Update connection stats...
			iupdateconnstats++;
			// 2 seconds
			if (iupdateconnstats>=2) {
				iupdateconnstats=0;
				theStats.UpdateConnectionStats((float)theApp.uploadqueue->GetDatarate()/1024, (float)theApp.downloadqueue->GetDatarate()/1024);
			}
			// <-----khaos-

			// display graphs
			if (thePrefs.GetTrafficOMeterInterval()>0) {
				igraph++;

				if (igraph >= (uint32)(thePrefs.GetTrafficOMeterInterval()) ) {
					igraph=0;
					//theApp.emuledlg->statisticswnd->SetCurrentRate((float)(theApp.uploadqueue->Getavgupload()/theApp.uploadqueue->Getavg())/1024,(float)(theApp.uploadqueue->Getavgdownload()/theApp.uploadqueue->Getavg())/1024);
					theApp.emuledlg->statisticswnd->SetCurrentRate((float)(theApp.uploadqueue->GetDatarate())/1024,(float)(theApp.downloadqueue->GetDatarate())/1024);
					//theApp.uploadqueue->Zeroavg();
				}
			}
			if (theApp.emuledlg->activewnd == theApp.emuledlg->statisticswnd && theApp.emuledlg->IsWindowVisible() )  {
				// display stats
				if (thePrefs.GetStatsInterval()>0) {
					istats++;

					if (istats >= (uint32)(thePrefs.GetStatsInterval()) ) {
						istats=0;
						theApp.emuledlg->statisticswnd->ShowStatistics();
					}
				}
			}
			//save rates every second
			theStats.RecordRate();
			// mobilemule sockets
			theApp.mmserver->Process();

			// ZZ:UploadSpeedSense -->
            theApp.emuledlg->ShowPing();

            bool gotEnoughHosts = theApp.clientlist->GiveClientsForTraceRoute();
            if(gotEnoughHosts == false) {
                theApp.serverlist->GiveServersForTraceRoute();
            }
			// ZZ:UploadSpeedSense <--

            sec++;
			// 5 seconds
			if (sec>=5) {
#ifdef _DEBUG
				if (thePrefs.m_iDbgHeap > 0 && !AfxCheckMemory())
					AfxDebugBreak();
#endif

				sec = 0;
				theApp.listensocket->Process();
				theApp.OnlineSig(); // Added By Bouc7 
				theApp.emuledlg->ShowTransferRate();
				
				if (!thePrefs.TransferFullChunks())
					theApp.uploadqueue->UpdateMaxClientScore();

				// update cat-titles with downloadinfos only when needed
				if (thePrefs.ShowCatTabInfos() && 
					theApp.emuledlg->activewnd == theApp.emuledlg->transferwnd && 
					theApp.emuledlg->IsWindowVisible()) 
						theApp.emuledlg->transferwnd->UpdateCatTabTitles(false);
				
				if (thePrefs.IsSchedulerEnabled())
					theApp.scheduler->Check();

                theApp.emuledlg->transferwnd->UpdateListCount(1, -1);
			}

			statsave++;
			// 60 seconds
			if (statsave>=60) {
				statsave=0;

				if (thePrefs.GetWSIsEnabled())
					theApp.webserver->UpdateSessionCount();

				theApp.serverconnect->KeepConnectionAlive();
			}

			_uSaveStatistics++;
			if (_uSaveStatistics >= thePrefs.GetStatsSaveInterval())
			{
				_uSaveStatistics = 0;
				thePrefs.SaveStats();
			}
		}

		// need more accuracy here. don't rely on the 'sec' and 'statsave' helpers.
		thePerfLog.LogSamples();
	}
	CATCH_DFLT_EXCEPTIONS(_T("CUploadQueue::UploadTimer"))
}
*/

CUpDownClient* CUploadQueue::GetNextClient(const CUpDownClient* lastclient){
	if (waitinglist.IsEmpty())
		return 0;
	if (!lastclient)
		return waitinglist.GetHead();
	POSITION pos = waitinglist.Find(const_cast<CUpDownClient*>(lastclient));
	if (!pos){
		TRACE("Error: CUploadQueue::GetNextClient");
		return waitinglist.GetHead();
	}
	waitinglist.GetNext(pos);
	if (!pos)
		return NULL;
	else
		return waitinglist.GetAt(pos);
}

void CUploadQueue::UpdateDatarates() {
    // Calculate average datarate
    if(::GetTickCount()-m_lastCalculatedDataRateTick > 500) {
        m_lastCalculatedDataRateTick = ::GetTickCount();

        if(avarage_dr_list.GetSize() >= 2 && (avarage_tick_list.GetTail() > avarage_tick_list.GetHead())) {
	        datarate = ((m_avarage_dr_sum-avarage_dr_list.GetHead())*1000) / (avarage_tick_list.GetTail()-avarage_tick_list.GetHead());
            friendDatarate = ((avarage_friend_dr_list.GetTail()-avarage_friend_dr_list.GetHead())*1000) / (avarage_tick_list.GetTail()-avarage_tick_list.GetHead());
        }
    }
}

uint32 CUploadQueue::GetDatarate() {
    UpdateDatarates();
    return datarate;
}

uint32 CUploadQueue::GetToNetworkDatarate() {
    UpdateDatarates();
    if(datarate > friendDatarate) {
        return datarate - friendDatarate;
    } else {
        return 0;
    }
}

void CUploadQueue::ReSortUploadSlots(bool force) {
// RT, Disable
	return;
// End
    DWORD curtick = ::GetTickCount();
    if(force ||  curtick - m_dwLastResortedUploadSlots >= 10*1000) {
        m_dwLastResortedUploadSlots = curtick;

        theApp.uploadBandwidthThrottler->Pause(true);

    	CTypedPtrList<CPtrList, CUpDownClient*> tempUploadinglist;

        // Remove all clients from uploading list and store in tempList
        POSITION ulpos = uploadinglist.GetHeadPosition();
        while (ulpos != NULL) {
            POSITION curpos = ulpos;
            uploadinglist.GetNext(ulpos);

            // Get and remove the client from upload list.
		    CUpDownClient* cur_client = uploadinglist.GetAt(curpos);

            uploadinglist.RemoveAt(curpos);

            // Remove the found Client from UploadBandwidthThrottler
            theApp.uploadBandwidthThrottler->RemoveFromStandardList(cur_client->socket);
// RT, MINI Version
#ifndef MINI
            theApp.uploadBandwidthThrottler->RemoveFromStandardList((CClientReqSocket*)cur_client->m_pPCUpSocket);
#endif
/*Original
            theApp.uploadBandwidthThrottler->RemoveFromStandardList((CClientReqSocket*)cur_client->m_pPCUpSocket);
*/

            tempUploadinglist.AddTail(cur_client);
        }

        // Remove one at a time from temp list and reinsert in correct position in uploading list
        POSITION tempPos = tempUploadinglist.GetHeadPosition();
        while(tempPos != NULL) {
            POSITION curpos = tempPos;
            tempUploadinglist.GetNext(tempPos);

            // Get and remove the client from upload list.
		    CUpDownClient* cur_client = tempUploadinglist.GetAt(curpos);

            tempUploadinglist.RemoveAt(curpos);

            // This will insert in correct place
            InsertInUploadingList(cur_client);
        }

        theApp.uploadBandwidthThrottler->Pause(false);
    }
}

//*************
// RT, New Code
//-------------
//
CString Section;
VOID CALLBACK CUploadQueue::UploadTimer(HWND hwnd, UINT uMsg,UINT_PTR idEvent,DWORD dwTime)
{
	// NOTE: Always handle all type of MFC exceptions in TimerProcs - otherwise we'll get mem leaks
	try
	{
		// Barry - Don't do anything if the app is shutting down - can cause unhandled exceptions
		if (theApp.emuledlg->IsRunning() == false)   return;

		if (thePrefs.GetVerbose(true) == true)   Section = _T("Upload Queue");
        theApp.uploadqueue->Process();
		if (thePrefs.GetVerbose(true) == true)   Section = _T("Download Queue");
		theApp.downloadqueue->Process();

		counter++;
		// one second
		if (counter >= 10)
		{
			counter = 0;
			if (thePrefs.GetVerbose(true) == true)   Section = _T("1 Sec");
			// Exit Smoothly
			if (theApp.ExitSmoothlyDialog != NULL)
			{
				if (theApp.ExitSmoothlyDialog->CheckUploadQueueEmpty() == true)
				{
					theApp.ExitSmoothlyDialog->EndDialog(0);
					theApp.ExitSmoothlyDialog = NULL;
				}
			}
			// Download Queue Process
			// Kademlia
			if (Kademlia::CKademlia::isRunning() == true)
			{
				ASSERT(Kademlia::CKademlia::getPrefs() != NULL);
				Kademlia::CKademlia::process();
/*
				if (Kademlia::CKademlia::getPrefs()->hasLostConnection() == true)
				{
					Kademlia::CKademlia::stop();
					theApp.emuledlg->ShowConnectionState();
				}
*/
			}
			// Overhead
			if (thePrefs.ShowOverhead() == true)
			{
				theStats.CompUpDatarateOverhead();
				theStats.CompDownDatarateOverhead();
			}
			// Show Ping
			if (theApp.emuledlg->TrayIsVisible() == FALSE)   theApp.emuledlg->ShowPing();
			// save rates every second
			theStats.RecordRate();
			// Fix the Bug of CPU Load
			theApp.listensocket->ResetOpenSocketsInterval();
// RT, MINI Version
#ifndef MINI
			// mobilemule sockets
			theApp.mmserver->Process();
#endif
/* Original
			// mobilemule sockets
			theApp.mmserver->Process();
*/
			// Save CPU Load
			if (thePrefs.GetVerbose(true) == true)   Section = _T("Save CPU Load");
			switch (sec)
			{
				case 0:
					//
					theApp.clientcredits->Process();	// 13 minutes
					theApp.serverlist->Process();		// 17 minutes
					break;
				case 1:
					theApp.friendlist->Process();		// 19 minutes
					theApp.knownfiles->Process();		// 11 minutes
					break;
				case 2:
					theApp.clientlist->Process();
					theApp.sharedfiles->Process();
					break;
				case 3:
					// Server Connection
					if( theApp.serverconnect->IsConnecting() && !theApp.serverconnect->IsSingleConnect() )
						theApp.serverconnect->TryAnotherConnectionrequest();
					//
					if (theApp.serverconnect->IsConnecting() == true)   theApp.serverconnect->CheckForTimeout();
					// Upload Queue Process
					theApp.sharedfiles->Publish();
					break;
				case 4:
					// Download Limit
					theApp.downloadqueue->SetDownloadLimit( theApp.uploadqueue->GetDatarate() );
//					theApp.downloadqueue->SetDownloadLimit(theStats.GetAvgUploadRate(AVG_TIME) * 1024);
					// Update Queue Count
					theApp.emuledlg->transferwnd->UpdateListCount(2);
					// Update Client Count
					theApp.emuledlg->transferwnd->UpdateListCount(0);
					// Upload Queue Process
					theApp.uploadqueue->UpdateActiveClientsInfo( ::GetTickCount() );
					break;
			}
			if (thePrefs.GetVerbose(true) == true)   Section = _T("Save CPU Load 2");
			// Save CPU Load
			switch (sec)
			{
				case 1:
				case 3:
				    // Elandal:ThreadSafeLogging, other threads may have queued up log lines. This prints them.
					theApp.HandleDebugLogQueue();
					theApp.HandleLogQueue();
					theApp.listensocket->Process();
				case 0:
				case 2:
				case 4:
					// Watch Clipboard
					if (thePrefs.WatchClipboard4ED2KLinks() == true)   theApp.SearchClipboard();		
					// Update Connections Status
					theApp.listensocket->UpdateConnectionsStatus();
					// ZZ:UploadSpeedSense
					theApp.lastCommonRouteFinder->SetPrefs(thePrefs.IsDynUpEnabled(), theApp.uploadqueue->GetDatarate(), thePrefs.GetMinUpload()*1024, ((thePrefs.GetMaxUpload() != UNLIMITED) ? (thePrefs.GetMaxUpload() * 1024) : 0), thePrefs.IsDynUpUseMillisecondPingTolerance(), (thePrefs.GetDynUpPingTolerance() > 100)?((thePrefs.GetDynUpPingTolerance()-100)/100.0f):0, thePrefs.GetDynUpPingToleranceMilliseconds(), thePrefs.GetDynUpGoingUpDivider(), thePrefs.GetDynUpGoingDownDivider(), thePrefs.GetDynUpNumberOfPings(), 20); // PENDING: Hard coded min pLowestPingAllowed
// RT, WebCache (Code by JP/yonatan/Superlexx)
					if ( thePrefs.expectingWebCachePing && (::GetTickCount() - thePrefs.WebCachePingSendTime > SEC2MS(30)) )
					{
						thePrefs.expectingWebCachePing = false;
						thePrefs.WebCacheDisabledThisSession = true; //Disable webcache downloads for the current proxy settings
						theApp.QueueLogLine(false, _T("Proxy configuration Test Failed please review your proxy-settings. Webcache downloads have been deactivated until emule is restarted."));
					}
// End
			}
			if (thePrefs.GetVerbose(true) == true)   Section = _T("Update Connection Statistics");
			// 2 seconds
			iupdateconnstats++;
			if (iupdateconnstats >= 2)
			{
				iupdateconnstats = 0;
				// Update connection stats
				theStats.UpdateConnectionStats(float(theApp.uploadqueue->GetDatarate())/1024, float(theApp.downloadqueue->GetDatarate())/1024);
			}
			if (thePrefs.GetVerbose(true) == true)   Section = _T("Update Statistics Graph");
			// display graphs
			if ( (theApp.emuledlg->statisticswnd != NULL) && (thePrefs.GetTrafficOMeterInterval() > 0) )
			{
				igraph++;
				if ( igraph >= uint32(thePrefs.GetTrafficOMeterInterval()) )
				{
					igraph = 0;
					theApp.emuledlg->statisticswnd->SetCurrentRate(float(theApp.uploadqueue->GetDatarate())/1024, float(theApp.downloadqueue->GetDatarate())/1024);
				}
			}
			if (theApp.emuledlg->activewnd == theApp.emuledlg->statisticswnd)
			{
				// display stats
				if (thePrefs.GetStatsInterval() > 0)
				{
					istats++;
					if (istats >= (uint32)(thePrefs.GetStatsInterval()) )
					{
						istats = 0;
						theApp.emuledlg->statisticswnd->ShowStatistics();
					}
				}
			}
			if (thePrefs.GetVerbose(true) == true)   Section = _T("5 Sec");
			// 5 seconds
            sec++;
			if (sec >= 5)
			{
#ifdef _DEBUG
				if (thePrefs.m_iDbgHeap > 0 && !AfxCheckMemory())   AfxDebugBreak();
#endif
				sec = 0;
				theApp.OnlineSig();
				theApp.emuledlg->ShowTransferRate();
				//				
				if (thePrefs.TransferFullChunks() == false)   theApp.uploadqueue->UpdateMaxClientScore();
				// update cat-titles with downloadinfos only when needed
				if (thePrefs.ShowCatTabInfos() && theApp.emuledlg->activewnd == theApp.emuledlg->transferwnd)
					theApp.emuledlg->transferwnd->UpdateCatTabTitles(false);
				//
// RT, MINI Version
#ifndef MINI
				if (thePrefs.IsSchedulerEnabled() == true)   theApp.scheduler->Check();
#endif
/*Original
				if (thePrefs.IsSchedulerEnabled() == true)   theApp.scheduler->Check();
*/
				// need more accuracy here. don't rely on the 'sec' and 'statsave' helpers.
				thePerfLog.LogSamples();
				// ZZ:UploadSpeedSense
		        if (theApp.clientlist->GiveClientsForTraceRoute() == false)
					theApp.serverlist->GiveServersForTraceRoute();
			}
			if (thePrefs.GetVerbose(true) == true)   Section = _T("60 Sec");
			// 60 seconds
			statsave++;
			switch (statsave)
			{
				case 120:
					statsave = 0;
					// This function does NOT update the tree!
					thePrefs.SaveStats();
					// Save RT Statistics
//					thePrefs.RT_SaveStatistics();
				case 60:
// RT, MINI Version
#ifndef MINI
					// Time to save our cumulative statistics.
					if (thePrefs.GetWSIsEnabled() == true)   theApp.webserver->UpdateSessionCount();
#endif
/*Original
					// Time to save our cumulative statistics.
					if (thePrefs.GetWSIsEnabled() == true)   theApp.webserver->UpdateSessionCount();
*/
					//
					theApp.serverconnect->KeepConnectionAlive();
			}
		}
	}
//	CATCH_DFLT_EXCEPTIONS( _T("CUploadQueue::UploadTimer") )
	catch (CException* e)
	{
		TCHAR szError[1024];
		e->GetErrorMessage(szError, ARRSIZE(szError));
		const CRuntimeClass* pRuntimeClass = e->GetRuntimeClass();
		LPCSTR pszClassName = (pRuntimeClass) ? pRuntimeClass->m_lpszClassName : NULL;
		if (pszClassName == NULL)   pszClassName = "CException";
		if (thePrefs.GetVerbose(true) == true)
			AddDebugLogLine(false, _T("[Section = %s] Unknown %hs exception in CUploadQueue::UploadTimer - %s"), Section, pszClassName, szError);
		e->Delete();
	}
	catch (CString strError)
	{
		if (thePrefs.GetVerbose(true) == true)
			AddDebugLogLine(false, _T("[Section = %s] Unknown CString exception in CUploadQueue::UploadTimer - %s"), Section, strError);
	}
}

// Friend Slot Auto
bool CUploadQueue::IsFriendInQueue(bool IsSetFriendSlot)
{
	uint32 CurrentWaitStartTime;
	uint32 WaitStartTime = ::GetTickCount() - 60000;
	uint32 WaitStartTimeLowID = ::GetTickCount() - 60000;
	CUpDownClient* Client;
	CUpDownClient* Friend = NULL;
	CUpDownClient* FriendLowID = NULL;
	bool UseFriendSlotByLowID = false;

	POSITION Pos = waitinglist.GetHeadPosition();
	while (Pos != NULL)
	{
		Client = waitinglist.GetNext(Pos);
		if (Client->IsFriend() == true)
		{
			if (IsSetFriendSlot == false)   return true;
			if (Client->GetScore(false) >= RT_SCORE_BASIC)
			{
				// Is Already Accept to Upload
				if (Client->m_bAddNextConnect == false)
				{
					// Clear Flag
					if (Client->GetFriendSlot() == true)   Client->SetFriendSlot(false);
					if (Client->HasLowID() == true)
					{
						// Find LowID Client which has the Longest WaitTime
						CurrentWaitStartTime = Client->GetWaitStartTime();
						if (CurrentWaitStartTime < WaitStartTimeLowID)
						{
							WaitStartTimeLowID = CurrentWaitStartTime;
							FriendLowID = Client;
						}
					}
					else
					{
						// Find Client which has the Longest WaitTime
						CurrentWaitStartTime = Client->GetWaitStartTime();
						if (CurrentWaitStartTime < WaitStartTime)
						{
							WaitStartTime = CurrentWaitStartTime;
							Friend = Client;
						}
					}
				}
				else if (Client->GetFriendSlot() == true)
					UseFriendSlotByLowID = true;
			}
		}
	}
	if (UseFriendSlotByLowID == true)   FriendLowID = NULL;
	// Set Frined Slot
	if (FriendLowID != NULL)
	{
		if ( (Friend == NULL) || (WaitStartTimeLowID < WaitStartTime) )
		{
			FriendLowID->SetFriendSlot(true);
			return true;
		}
	}
	if (Friend != NULL)
	{
		Friend->SetFriendSlot(true);
		return true;
	}
	return false;
}

// Friend Slot Auto
bool CUploadQueue::IsFriendSlotInUse() const
{
	CUpDownClient* Client;
	POSITION Pos = uploadinglist.GetHeadPosition();
	// Find Client who use the Frined Slot
	while (Pos != NULL)
	{
		Client = uploadinglist.GetNext(Pos);
		if (Client->GetFriendSlot() == true)   return true;
	}
	return false;
}

// Check Uploading Status
void CUploadQueue::CheckUploadingStatus()
{
	CUpDownClient* Client;
	rt_ReleaseSlotCount = 0;
	rt_Credit1SlotCount = 0;
	POSITION pos = uploadinglist.GetHeadPosition();
	while (pos != NULL)
	{
		Client =  uploadinglist.GetNext(pos);
		if ( (Client->GetQueueScore() >= RT_SCORE_RELEASE) && (Client->GetFriendSlot() == false) )
		{
			if (Client->GetQueueScore() >= RT_SCORE_CREDIT1)
				rt_Credit1SlotCount++;
			else
				rt_ReleaseSlotCount++;
		}
	}
/*
	if ( (thePrefs.IsLogRatioVerbose() == true) &&
		( (rt_Credit1SlotCount > 0) || (rt_ReleaseSlotCount > 0) || (rt_Credit1SlotLowID == true) ||
		(rt_ReleaseSlotLowID == true) ) )
	{
		AddDebugLogLine( false, _T(">> [RT Debug] Credit1SlotCount = %u, ReleaseSlotCount = %u, Credit1SlotLowID = %u, ReleaseSlotLowID = %u"),
							rt_Credit1SlotCount, rt_ReleaseSlotCount, rt_Credit1SlotLowID, rt_ReleaseSlotLowID );
	}
*/
}

// New Method to AddUpNextClient
bool CUploadQueue::AddUpNextClient(LPCTSTR pszReason, CUpDownClient* DirectAdd)
{
	if (theApp.ExitSmoothlyDialog != NULL)   return false;

	// select next client or use given client
	CUpDownClient* NewClient = NULL;
	if (DirectAdd == NULL)
	{
		CUpDownClient* BestClient = NULL;
		CUpDownClient* BestClientLowID = NULL;
		uint32	BestScore = 0;
		uint32  BestScoreLowID = 0;
		// Special count of queue
		rt_InvalidCount = 0;
		rt_LeecherCount = 0;
		rt_GPLEvildoerCount = 0;
		rt_FriendCount = 0;
		// Check Uploading Status before Search Client
		CheckUploadingStatus();
		// Friend Slot Auto
		if ( thePrefs.IsFriendSlotAuto() && (IsFriendSlotInUse() == false) )   IsFriendInQueue(true);
		// Search client who has best score
		bool IsReleaseSlotLowID = false;
		bool IsCredit1SlotLowID = false;
		DWORD CurrentTick = ::GetTickCount();
		POSITION ListPos = waitinglist.GetHeadPosition();
		while (ListPos != NULL)
		{
			CUpDownClient* CurrentClient = waitinglist.GetNext(ListPos);
			// clear dead clients
			ASSERT ( CurrentClient->GetLastUpRequest() );
			if ( (CurrentTick - CurrentClient->GetLastUpRequest() > HR2MS(2)) ||
				(theApp.sharedfiles->GetFileByID(CurrentClient->GetUploadFileID()) == NULL) )
			{
				// Upload Queue Waited Time
				if (thePrefs.IsRecordUploadQueueWaitedTime() == true)
					CurrentClient->SetUploadQueueWaitedTime( CurrentClient->GetWaitTime(true) );
				//
				CurrentClient->ClearWaitStartTime();
				RemoveFromWaitingQueue(CurrentClient, false);
				theApp.emuledlg->transferwnd->queuelistctrl.RemoveClient(CurrentClient);
				//
				if (CurrentClient->socket == NULL)
				{
					if (CurrentClient->Disconnected(_T("AddUpNextClient - purged")) == true)
					{
						delete CurrentClient;
						CurrentClient = NULL;
					}
				}
				continue;
			}
			// Compare Score
			if (CurrentClient->m_bAddNextConnect == false)
			{
				// finished clearing
				uint32 CurrentScore = CurrentClient->GetScore(false);
				CurrentClient->SetQueueScore(CurrentScore);
				// Special count of queue
				if (CurrentClient->IsFriend() == true)   rt_FriendCount++;
				if (CurrentScore < RT_SCORE_BASIC)
				{
					switch (CurrentScore)
					{
						case RT_SCORE_INVALID:
							rt_InvalidCount++;
							break;
						case RT_SCORE_LEECHER:
							rt_LeecherCount++;
							break;
						case RT_SCORE_GPL_EVILDOER:
							rt_GPLEvildoerCount++;
							break;
					}
				}
				else
				{
					if (CurrentClient->HasLowID() == false)
					{
						// Best Score
						if (CurrentScore > BestScore)
						{
							BestScore = CurrentScore;
							BestClient = CurrentClient;
						}
					}
					else
					{
						// LowID Best Score
						if (CurrentScore > BestScoreLowID)
						{
							BestScoreLowID = CurrentScore;
							BestClientLowID = CurrentClient;
						}
					}
				}
			}
			else if ( (CurrentClient->GetQueueScore() >= RT_SCORE_RELEASE) && (CurrentClient->GetFriendSlot() == false) )
			{
				if (CurrentClient->GetQueueScore() >= RT_SCORE_CREDIT1)
					IsCredit1SlotLowID = true;
				else
					IsReleaseSlotLowID = true;
			}
		}
		rt_Credit1SlotLowID = IsCredit1SlotLowID;
		rt_ReleaseSlotLowID = IsReleaseSlotLowID;
		
		if (BestScoreLowID > BestScore)
		{
			NewClient = BestClientLowID;
			NewClient->m_bAddNextConnect = true;
			if (NewClient->GetQueueScore() >= RT_SCORE_RELEASE)
			{
				if (NewClient->GetQueueScore() >= RT_SCORE_CREDIT1)
					rt_Credit1SlotLowID = true;
				else
					rt_ReleaseSlotLowID = true;
			}
		}
		if ( (NewClient == NULL) || (NewClient->socket == NULL) || (NewClient->socket->IsConnected() == false) )
		{
			if (BestClient == NULL)   return false;
			// Don't Add Client which Sorce < RT_SCORE_BASIC
			if (BestClient->GetScore(false) < RT_SCORE_BASIC)   return false;
			NewClient = BestClient;
			RemoveFromWaitingQueue(BestClient, true);
			theApp.emuledlg->transferwnd->ShowQueueCount( waitinglist.GetCount() );
		}
		else
		{
			RemoveFromWaitingQueue(NewClient, true);
			if (thePrefs.IsLogRatioVerbose() == true)
				AddDebugLogLine( false, _T(">> [RT Debug] LowID Direct to Upload. { %s }"), NewClient->GetUserName() );
		}
	}
	else
	{
		// Don't Add Client which Sorce < RT_SCORE_BASIC
		if (DirectAdd->GetScore(false) < RT_SCORE_BASIC)
		{
			if (waitinglist.Find(DirectAdd) == NULL)   waitinglist.AddTail(DirectAdd);
			return false;
		}
//		if (thePrefs.IsLogRatioVerbose() == true)
//			AddDebugLogLine( false, _T(">> [RT Debug] Direct to Upload. { %s }"), DirectAdd->GetUserName() );
		NewClient = DirectAdd;
	}
	//
	if (IsDownloading(NewClient) == true)   return false;
	// New Method to tell the client that we are now ready to upload
	CKnownFile* RequstFile = theApp.sharedfiles->GetFileByID(NewClient->GetUploadFileID());
	if (RequstFile == NULL)   return false;
	//
    if ( (pszReason != NULL) && (thePrefs.GetLogUlDlEvents() == true) )
        AddDebugLogLine( false, _T("Adding client to upload list: %s Client: %s"), pszReason, NewClient->DbgGetClientInfo() );
	//
	bool IsSendAcceptUpload = false;
	if ( (NewClient->socket == NULL) || (NewClient->socket->IsConnected() == false) )
	{
		NewClient->SetUploadState(US_CONNECTING);
		if (NewClient->TryToConnect(true) == false)   return false;
	}
	else
	{
		NewClient->SetUpdateFileStatus(true);
		NewClient->SetUploadState(US_UPLOADING);
		IsSendAcceptUpload = true;
	}
	// Statistic
	RequstFile->statistic.AddAccepted();
	// Force Update Parts Info
	RequstFile->ForceUpdatePartsInfo();
	// Upload Special State
	if ( (NewClient->GetFriendSlot() == false) && (NewClient->GetQueueScore() >= RT_SCORE_RELEASE) )
	{
		if (NewClient->GetQueueScore() >= RT_SCORE_CREDIT1)
			rt_Credit1SlotCount++;
		else
			rt_ReleaseSlotCount++;
	}
	NewClient->SetNoTransferTimeUL(0);
	//
	NewClient->SetUpStartTime();
	NewClient->ResetSessionUp();
    InsertInUploadingList(NewClient);
    m_nLastStartUpload = ::GetTickCount();
	theApp.emuledlg->transferwnd->uploadlistctrl.AddClient(NewClient);
	//
	if (IsSendAcceptUpload)
	{
		// Update File Status
		if (NewClient->UpdateFileStatus() == false)
		{
			NewClient->SetUpdateFileStatus(false);
			Packet* packet = new Packet(OP_ACCEPTUPLOADREQ, 0);
			theStats.AddUpDataOverheadFileRequest(packet->size);
			NewClient->socket->SendPacket(packet,true);
		}
	}
	return true;
}

// New Method for AcceptNewClient
bool CUploadQueue::AcceptNewClient(bool addOnNextConnect)
{
	if ( (::GetTickCount() - m_nLastStartUpload) < SEC2MS(1) )   return false;
	if ( uploadinglist.GetCount() < int(thePrefs.GetMinUploadSlot()) )   return true;
	uint32 MaxUpload = theApp.lastCommonRouteFinder->GetUpload();
	if ( (datarate + 2000) < MaxUpload )
	{
		uint32 DelayTime = uint32(::GetTickCount()) - m_nLastStartUpload;
		if ( uploadinglist.GetCount() >= int(thePrefs.GetMaxUploadSlot()) )
		{
			uint32 DelayLimit = SEC2MS(20) * ((uploadinglist.GetCount() + 1) - int(thePrefs.GetMaxUploadSlot()) );
			if ( (DelayTime > DelayLimit) &&
				(uint32(uint32(uploadinglist.GetCount()) * 2000) < MaxUpload) )
			{
				return true;
			}
		}
		else
		{
			if ( (DelayTime >= SEC2MS(10)) || ((datarate + (SEC2MS(10) - DelayTime)) < MaxUpload) )   return true;
		}
	}
	else
		m_nLastStartUpload = ::GetTickCount();
	return false;
}

// New Method to CheckForTimeOver
bool CUploadQueue::CheckForTimeOver(CUpDownClient* client)
{
	// Check Friend Slot
	if (client->GetFriendSlot() == true)
	{
		if ( (thePrefs.IsFriendSlotAuto() == false) && (theApp.ExitSmoothlyDialog == NULL) )   return false;
    }
	else
	{
		// Transfer Limit
		if ( (theApp.ExitSmoothlyDialog == NULL) && (thePrefs.GetMaxCredit1Slot() > 0) &&
			(client->GetCreditRatio() < 1) )
		{
			if ( client->GetSessionUp() > GetTransferLimit(client) )
			{
				if (thePrefs.IsLogRatioVerbose() == true)
					AddDebugLogLine( false, _T(">> [RT Debug] Upload session ended due to Credit < 1. { %s } { %s }"), CastItoXBytes(client->GetSessionUp()), client->GetUserName() );
				return true;
			}
		}
	}
	// Transfer Full Chunks
	if (thePrefs.TransferFullChunks() == false)
	{
		// Try to keep the clients from downloading for ever.
		if (client->GetUpStartTimeDelay() > SESSIONMAXTIME)
		{
			AddDebugLogLine( false, _T("%s: Upload session ended due to excessive time."), client->GetUserName() );
			return true;
		}
		// Cache current client score
		const uint32 score = client->GetScore(true, true);
		// Check if another client has a bigger score
		if ( score < GetMaxClientScore() )
		{
			AddDebugLogLine(false, _T("%s: Upload session ended due to score."), client->GetUserName());
			return true;
		}
	}
	else
	{
		// Allow the client to download a specified amount per session
		if (client->GetQueueSessionPayloadUp() > SESSIONMAXTRANS)
		{
			AddDebugLogLine( false, _T("%s: Upload session ended due to excessive transfered amount."), client->GetUserName() );
			return true;
		}
	}
	// Sorce < RT_SCORE_BASIC
	if (client->GetQueueScore() < RT_SCORE_BASIC)
	{
//		client->SetQueueScore( client->GetScore(false, true) );
		if (thePrefs.IsLogRatioVerbose() == true)
			AddDebugLogLine( false, _T(">> [RT Debug] Upload session ended due to { %s }. { %s, %s, %s }"), client->GetRatingString(), client->GetUserName(), client->GetClientSoftVer(), CastSecondsToHM(client->GetWaitTime()) );
		return true;
	}
	// Check Time for No Transfer
	return client->CheckNoTransferTime(false);
}

// Transfer Limit
uint32 CUploadQueue::GetTransferLimit(CUpDownClient* Client)
{
	if (Client->IsFriend() == true)   return 10000000;
	if (Client->GetFirstRequestedPart() == 0xFFFF)   return 10000000;
	CKnownFile* UploadFile = theApp.sharedfiles->GetFileByID( Client->GetUploadFileID() );
	if (UploadFile == NULL)   return 10000000;
	if (UploadFile->IsReleaseFile() == true)   return 10000000;
	if (UploadFile->IsPartFile() == true)
	{
		uint16 PartFrequency = ((CPartFile*)UploadFile)->GetPartFrequency( Client->GetFirstRequestedPart() );
		if (PartFrequency > 400)   return 2000000;
		if (PartFrequency > 200)   return 4000000;
		if (PartFrequency > 100)   return 6000000;
		if (PartFrequency > 50)   return 8000000;
	}
	else
	{
		uint16 PartFrequency = UploadFile->GetPartFrequency( Client->GetFirstRequestedPart() );
		if (PartFrequency > 80)   return 2000000;
		if (PartFrequency > 40)   return 4000000;
		if (PartFrequency > 20)   return 6000000;
		if (PartFrequency > 10)   return 8000000;
	}
	return 10000000;
}

// Queue Score
uint16 CUploadQueue::GetWaitingPosition(CUpDownClient* Client, bool RealScore)
{
	if ( (Client->IsDownloading() == true) || (Client->m_bAddNextConnect == true) )   return 0;
	UINT Rank = 1;
	uint32 ClientScore, Score;
	if (RealScore == true)
	{
		ClientScore = Client->GetScore(false);
		Client->SetQueueScore(ClientScore);
	}
	else
		ClientScore = Client->GetQueueScore();
	//
	POSITION Pos = waitinglist.GetHeadPosition();
	while (Pos != NULL)
	{
		CUpDownClient* CurrentClient = waitinglist.GetNext(Pos);
		if (RealScore == true)
		{
			Score = CurrentClient->GetScore(false);
			CurrentClient->SetQueueScore(Score);
		}
		else
			Score = CurrentClient->GetQueueScore();
		if (Score > ClientScore)   Rank++;
	}
	return Rank;
}

// Keep Friend Slot
void CUploadQueue::KeepFriendSlot(CUpDownClient* Client)
{
	if (thePrefs.IsCurrentFS( Client->GetUserHash() ) == true)
	{
		theApp.friendlist->RemoveAllFriendSlots();
		Client->SetFriendSlot(true);
		if (thePrefs.IsLogRatioVerbose() == true)
			AddDebugLogLine( false, _T(">> [RT Debug] Keep Friend Slot { %s } { %s }"), md4str(Client->GetUserHash()), Client->GetUserName() );
	}
	else
		Client->SetFriendSlot(false);
}

// Upload Queue Waited Time
void CUploadQueue::RecordUploadQueueWaitedTime()
{
	POSITION Pos = waitinglist.GetHeadPosition();
	while (Pos != NULL)
	{
		CUpDownClient* CurrentClient = waitinglist.GetNext(Pos);
		CurrentClient->SetUploadQueueWaitedTime( CurrentClient->GetWaitTime(true) );
		CurrentClient->ClearWaitStartTime();
	}
	Pos = uploadinglist.GetHeadPosition();
	while (Pos != NULL)
	{
		CUpDownClient* CurrentClient = uploadinglist.GetNext(Pos);
		CurrentClient->SetUploadQueueWaitedTime( CurrentClient->GetWaitTime(true) );
		CurrentClient->ClearWaitStartTime();
	}
}

// New Code for RemoveFromUploadQueue()
bool CUploadQueue::RemoveFromUploadQueue(CUpDownClient* client, LPCTSTR pszReason, bool updatewindow, bool earlyabort){
	POSITION Pos = uploadinglist.Find(client);
	if (Pos != NULL)
	{
		client->SetUploadState(US_NONE);
		uploadinglist.RemoveAt(Pos);
		theApp.uploadBandwidthThrottler->RemoveFromStandardList(client->socket);
		if (updatewindow == true)   theApp.emuledlg->transferwnd->uploadlistctrl.RemoveClient(client);

		if (thePrefs.GetLogUlDlEvents() == true)
			AddDebugLogLine(DLP_VERYLOW, true,_T("---- %s: Removing client from upload list. Reason: %s ----"), client->GetUserName(), pszReason==NULL ? _T("") : pszReason);

		CKnownFile* requestedFile = theApp.sharedfiles->GetFileByID(client->GetUploadFileID());
		if (client->GetSessionUp() > 0)
		{
			++successfullupcount;
			totaluploadtime += client->GetUpStartTimeDelay()/1000;
			// Update Parts Info
			if (requestedFile != NULL)   requestedFile->UpdatePartsInfo();
			// Last Upload Time
			if ( (client->GetSessionUp() > 1048576) && (requestedFile->statistic.GetTransferred() >= PARTSIZE) )
				requestedFile->ResetLastUploadTime();
			// Reset Upload Queue Waited Time
			if (pszReason != NULL)
			{
				CString Buffer( _T("Completed transfer") );
				if ( (Buffer.Compare(pszReason) == 0) && (client->GetSessionUp() > 1048576) )
				{
					client->SetUploadQueueWaitedTime(0);
//					if (thePrefs.IsLogRatioVerbose() == true)
//						AddDebugLogLine( false, _T(">> [RT Debug] Completed Transfer, Reset [Upload Queue Waited Time]. { %s } [Waited Time = %u]"), client->GetUserName(), client->credits->GetUploadQueueWaitedTime() );
				}
			}
		}
		else if ( (earlyabort == false) && (client->IsUpdateFileStatus() == false) )
			++failedupcount;
		// Keep track of this client
//		theApp.clientlist->AddTrackClient(client);
		// Reset
		client->ClearUploadBlockRequests();
		client->ClearUploadTime();
		client->SetFirstRequestedPart(0xFFFF);
		client->SetFriendSlot(false);
		client->m_bAddNextConnect = false;
		client->SetUpdateFileStatus(false);
		client->SetQueueScore(0);
		return true;
	}
	return false;
}

// Update Queue
void CUploadQueue::UpdateQueue()
{
	// Update Queue Thread
	bool IsUpdating = false;
	CSingleLock SingleLock(&UpdateQueueLocker);
	SingleLock.Lock();
	IsUpdating = rt_UpdatingQueue;
	if (IsUpdating == false)   rt_UpdatingQueue = true;
	SingleLock.Unlock();
	if (IsUpdating == true)   return;
	// Update
	DWORD CurrentTick = ::GetTickCount();
	POSITION Pos = waitinglist.GetHeadPosition();
	while (Pos != NULL)
	{
		CUpDownClient* CurrentClient = waitinglist.GetNext(Pos);
		if ( (CurrentTick - CurrentClient->GetLastRefreshUploadList()) > SEC2MS(5) )
		{
			CurrentClient->SetLastRefreshUploadList(CurrentTick);
			CurrentClient->SetQueueScore( CurrentClient->GetScore(false) );
			theApp.emuledlg->transferwnd->queuelistctrl.RefreshClient(CurrentClient);
		}
	}
	rt_UpdatingQueue = false;
}

// AddClient To Queue
void CUploadQueue::AddClientToQueue(CUpDownClient* client, bool bIgnoreTimelimit)
{
	client->SetUploadState(US_QUEUEFULL);
	//
	if ( (theApp.serverconnect->IsConnected() == true) &&
		(theApp.serverconnect->IsLowID() == true) && //This may need to be changed with the Kad now being used.
		(theApp.serverconnect->IsLocalServer(client->GetServerIP(), client->GetServerPort()) == false) &&
		(client->GetDownloadState() == DS_NONE) &&
		(client->IsFriend() == false) &&
		(GetWaitingUserCount() > 50) )
	{
		return;
	}
	//
	client->UpdateBaseData();
	//
	client->SetLastUpRequest();
	if (bIgnoreTimelimit == false)
	{
		client->AddAskedCount();
		client->AddRequestCount( client->GetUploadFileID() );
	}
	// Check Tracked Clients
	if (theApp.clientlist->GetClientsFromIP(client->GetIP()) > 0)
	{
		if (thePrefs.GetLogFilteredIPs() == true)
			AddDebugLogLine( false, _T("%s's (%s) Request to enter the queue was rejected, because of Found in TrackedClientsList"), client->GetUserName(), ipstr(client->GetConnectIP()) );
		return;
	}
	// Check Queue Full, 10100 = Infinite Queue
	if ( (thePrefs.GetQueueSize() < 10100) && (client->m_bAddNextConnect == false) )
	{
		// Ban the Client which Modifier <= 1, when waitinglist > QueueSize
		uint32 WaitingCount = uint32(waitinglist.GetCount()) - rt_InvalidCount - rt_LeecherCount - rt_GPLEvildoerCount;
		if ( WaitingCount > thePrefs.GetQueueSize() )
		{
			if ( WaitingCount > uint32(thePrefs.GetQueueSize() * 1.1) )   return;
			CKnownFile* RequestFile = theApp.sharedfiles->GetFileByID( (uchar*)client->GetUploadFileID() );
			if (RequestFile == NULL)   return;
			if ( (client->GetUploadState() != US_ONUPLOADQUEUE) &&
				(client->IsFriend() == false) &&
				(RequestFile->IsReleaseFile() == false) &&
				(client->GetCreditRatio() <= 1)	)
			{
				return;
			}
		}
	}
	// check for double
	uint16 cSameIP = 0;
	POSITION NextPos = waitinglist.GetHeadPosition();
	while (NextPos != NULL)
	{
		POSITION CurrentPos = NextPos;
		CUpDownClient* cur_client = waitinglist.GetNext(NextPos);
		if (cur_client == client)
		{	
			//already on queue
			// VQB LowID Slot Patch -- note:  should add limit so only if #slots < UL -or- UL+1 for Low UL (?)
// RT, Reset Release Slot for LowID or Credit1 Slot for LowID
			if ( (client->HasLowID() == true) && (client->m_bAddNextConnect == true) )
			{
				if ( (uploadinglist.GetCount() < int(thePrefs.GetMaxUploadSlot() + 1)) ||
					(uploadinglist.GetCount() < int(sqrt(theStats.GetAvgUploadRate(AVG_TIME)))) )
				{
					if ( (client->GetFriendSlot() == true) && (thePrefs.IsLogRatioVerbose() == true) )
						AddDebugLogLine( false, _T(">> [RT Debug] LowID Using Friend Slot. { %s } { %s }"), client->GetUserHash(), client->GetUserName() );
					RemoveFromWaitingQueue(client, true);
					AddUpNextClient( _T("Adding ****lowid when reconneting."), client );
					client->m_bAddNextConnect = false;
					return;
				}
			}
			// VQB end
			client->SendRankingInfo();
			theApp.emuledlg->transferwnd->queuelistctrl.RefreshClient(client);
			return;			
		}
		else if (client->Compare(cur_client) == true)
		{
			// another client with same ip:port or hash
			// this happens only in rare cases, because same userhash / ip:ports are assigned to the right client on connecting in most cases
			if (cur_client->credits != NULL && cur_client->credits->GetCurrentIdentState(cur_client->GetIP()) == IS_IDENTIFIED)
			{
				//cur_client has a valid secure hash, don't remove him
				if (thePrefs.GetVerbose() == true)
					AddDebugLogLine(false,CString(GetResString(IDS_SAMEUSERHASH)),client->GetUserName(),cur_client->GetUserName(),client->GetUserName() );
				// in any case keep track of this client
				theApp.clientlist->AddTrackClient(client);
				return;
			}
			//client has a valid secure hash, add him remove other one
			if (client->credits != NULL && client->credits->GetCurrentIdentState(client->GetIP()) == IS_IDENTIFIED)
			{
				if (thePrefs.GetVerbose() == true)
					AddDebugLogLine(false,CString(GetResString(IDS_SAMEUSERHASH)),client->GetUserName(),cur_client->GetUserName(),cur_client->GetUserName() );
// RT, Upload Waited Time
				theApp.clientlist->AddTrackClient(cur_client);
				cur_client->SetUploadQueueWaitedTime(0);
				cur_client->Ban( _T("Identification Invaild") );
// End
				RemoveFromWaitingQueue(CurrentPos, true);
				if (!cur_client->socket)
				{
					if (cur_client->Disconnected(_T("AddClientToQueue - same userhash 1")) == true)
					{
						delete cur_client;
					}
				}
			}
			// remove both since we dont know who the bad on is
			else
			{
				if (thePrefs.GetVerbose() == true)
					AddDebugLogLine(false,CString(GetResString(IDS_SAMEUSERHASH)),client->GetUserName(),cur_client->GetUserName(),"Both" );
// RT, Upload Waited Time
				theApp.clientlist->AddTrackClient(client);
				theApp.clientlist->AddTrackClient(cur_client);
				client->SetUploadQueueWaitedTime(0);
				cur_client->SetUploadQueueWaitedTime(0);
				client->Ban( _T("Client with same IP:PORT or Hash") );
				cur_client->Ban( _T("Client with same IP:PORT or Hash") );
// End
				RemoveFromWaitingQueue(CurrentPos, true);
				if (!cur_client->socket)
				{
					if (cur_client->Disconnected(_T("AddClientToQueue - same userhash 2")) == true)
					{
						delete cur_client;
					}
				}
				return;
			}
		}
		// same IP, different port, different userhash
		else if ( client->GetIP() == cur_client->GetIP() )
		{
			cSameIP++;
			if (cSameIP >= 2)
			{
				if (thePrefs.GetVerbose() == true)
					AddDebugLogLine( false, _T("%s's (%s) Request to enter the queue was rejected, because of Too many clients with the same IP"), client->GetUserName(), ipstr(client->GetConnectIP()) );
				return;
			}
		}
	}
	// Add clients server to list.
	if (thePrefs.AddServersFromClient() && client->GetServerIP() && client->GetServerPort())
	{
		CServer* srv = new CServer( client->GetServerPort(), ipstr(client->GetServerIP()) );
		srv->SetListName( srv->GetAddress() );
		if (theApp.emuledlg->serverwnd->serverlistctrl.AddServer(srv, true) == false)
			delete srv;
	}
	// statistic values
	CKnownFile* reqfile = theApp.sharedfiles->GetFileByID((uchar*)client->GetUploadFileID());
	if (reqfile != NULL)
		reqfile->statistic.AddRequest();
	else
		return;
	// Update File Status before Upload
	client->SetUpdateFileStatus(false);
	// Check Client
	if (client->IsBadClient() == true)
	{
		client->SetLeecherCount(RT_LEECHER_COUNT_MAX);
		if (thePrefs.IsLogRatioVerbose() == true)
			AddDebugLogLine( false, _T(">> [RT Debug] Bad Client. { %s } { %s } { %s }"), md4str(client->GetUserHash()), client->GetUserName(), client->GetClientSoftVer() );
	}
	// GPL Evildoer
	if ( (client->m_bGPLEvildoer == true) && (client->GetCreditRatio() > 1) )   client->m_bGPLEvildoer = false;
	// Special Count of Queue
	if (client->IsFriend() == true)
	{
		rt_FriendCount++;
		client->SetFriendSlot(false);
		// Keep Friend Slot
		if ( (thePrefs.IsKeepFriendSlot() == true) && (thePrefs.IsFriendSlotAuto() == false) )
			KeepFriendSlot(client);
	}
	client->SetWaitStartTime();
	client->SetCreditRatio();
	uint32 ClientScore = client->GetScore(false);
	client->SetQueueScore(ClientScore);
	if (ClientScore < RT_SCORE_BASIC)
	{
		switch (ClientScore)
		{
			case RT_SCORE_INVALID:
				rt_InvalidCount++;
				break;
			case RT_SCORE_LEECHER:
				rt_LeecherCount++;
				break;
			case RT_SCORE_GPL_EVILDOER:
				rt_GPLEvildoerCount++;
				break;
		}
	}
	// Add Client to Queue
	if ( (waitinglist.IsEmpty() == TRUE) && (AcceptNewClient() == true) )
	{
		m_nLastStartUpload = ::GetTickCount();
		AddUpNextClient( _T("Direct add with empty queue."), client );
		return;
	}
	else
	{
		waitinglist.AddTail(client);
		client->SetUploadState(US_ONUPLOADQUEUE);
		theApp.emuledlg->transferwnd->queuelistctrl.AddClient(client, false);
		theApp.emuledlg->transferwnd->ShowQueueCount( waitinglist.GetCount() );
		client->SendRankingInfo();
	}
	//
	theApp.emuledlg->transferwnd->queuelistctrl.RefreshClient(client);
}

// RT, WebCache (Code by JP/yonatan/Superlexx)
CUpDownClient*	CUploadQueue::FindClientByWebCacheUploadId(const uint32 id) // Superlexx - webcache - can be made more efficient
{
	for (POSITION pos = uploadinglist.GetHeadPosition(); pos != NULL;)
	{
		CUpDownClient* cur_client = uploadinglist.GetNext(pos);
		if ( cur_client->m_uWebCacheUploadId == id )
			return cur_client;
	}
	return 0;
}
// End--WebCache