//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once

class CUpDownClient;
typedef CTypedPtrList<CPtrList, CUpDownClient*> CUpDownClientPtrList;

class CUploadQueue
{
// RT, New Member
public:
	// Friend Slot Auto
	bool		IsFriendInQueue(bool IsSetFirstSlot = false);
	bool		IsFriendSlotInUse() const;
	// Check Uploading Status
	void		CheckUploadingStatus();
	// Release Slot
	bool		IsReleaseSlotLowID()				{ return rt_ReleaseSlotLowID;}
	uint8		GetReleaseSlotCount() const			{ return rt_ReleaseSlotCount;}
	// Credit1 Slot
	bool		IsCredit1SlotLowID()				{ return rt_Credit1SlotLowID;}
	uint8		GetCredit1SlotCount() const			{ return rt_Credit1SlotCount;}
	// Keep Friend Slot
	void		KeepFriendSlot(CUpDownClient* Client);
	// Special count of the queue
	uint16		GetInvalidCount() const				{ return rt_InvalidCount;}
	uint16		GetLeecherCount() const				{ return rt_LeecherCount;}
	uint16		GetGPLEvildoerCount() const			{ return rt_GPLEvildoerCount;}
	uint16		GetFriendCount() const				{ return rt_FriendCount;}
	// Transfer Limit
	uint32		GetTransferLimit(CUpDownClient* Client);
	// Upload Queue Waited Time
	void		RecordUploadQueueWaitedTime();
	// Update Queue
	void		UpdateQueue();
// RT, WebCache (Code by JP/yonatan/Superlexx)
	CUpDownClient*	FindClientByWebCacheUploadId(const uint32 id); // Superlexx - webcache
// End--WebCache
private:
	uint16		rt_InvalidCount;					// the count of Invalid in the queue
	uint16		rt_LeecherCount;					// the count of Leecher in the queue
	uint16		rt_GPLEvildoerCount;				// the count of GPL Evildoer in the queue
	uint16		rt_FriendCount;						// the count of Friend in the queue
	bool		rt_ReleaseSlotLowID;				// Release Slot for LowID
	uint8		rt_ReleaseSlotCount;				// Release Slot Count
	bool		rt_Credit1SlotLowID;				// Credit1 Slot for LowID
	uint8		rt_Credit1SlotCount;				// Credit1 Slot Count
	//
	bool		rt_UpdatingQueue;
	// Update Queue Thread
	CCriticalSection UpdateQueueLocker;
// End
public:
	CUploadQueue();
	~CUploadQueue();

	void	Process();
	void	AddClientToQueue(CUpDownClient* client,bool bIgnoreTimelimit = false);
	bool	RemoveFromUploadQueue(CUpDownClient* client, LPCTSTR pszReason = NULL, bool updatewindow = true, bool earlyabort = false);
	bool	RemoveFromWaitingQueue(CUpDownClient* client,bool updatewindow = true);
	bool	IsOnUploadQueue(CUpDownClient* client)	const {return (waitinglist.Find(client) != 0);}
	bool	IsDownloading(CUpDownClient* client)	const {return (uploadinglist.Find(client) != 0);}

    void    UpdateDatarates();
	uint32	GetDatarate();
    uint32  GetToNetworkDatarate();

	bool	CheckForTimeOver(CUpDownClient* client);
	int		GetWaitingUserCount()					{return waitinglist.GetCount();}
	int		GetUploadQueueLength()					{return uploadinglist.GetCount();}
	uint32	GetActiveUploadsCount()					{return m_MaxActiveClientsShortTime;}
	
	POSITION GetFirstFromUploadList()				{return uploadinglist.GetHeadPosition();}
	CUpDownClient* GetNextFromUploadList(POSITION &curpos)	{return uploadinglist.GetNext(curpos);}
	CUpDownClient* GetQueueClientAt(POSITION &curpos)	{return uploadinglist.GetAt(curpos);}

	POSITION GetFirstFromWaitingList()				{return waitinglist.GetHeadPosition();}
	CUpDownClient* GetNextFromWaitingList(POSITION &curpos)	{return waitinglist.GetNext(curpos);}
	CUpDownClient* GetWaitClientAt(POSITION &curpos)	{return waitinglist.GetAt(curpos);}

	CUpDownClient*	GetWaitingClientByIP_UDP(uint32 dwIP, uint16 nUDPPort);
	CUpDownClient*	GetWaitingClientByIP(uint32 dwIP);
	CUpDownClient*	GetNextClient(const CUpDownClient* update);

	
	void	DeleteAll();
// RT, Upload QR
	uint16	GetWaitingPosition(CUpDownClient* Client, bool RealScore = false);
/* Original
	uint16	GetWaitingPosition(CUpDownClient* client);
*/
	
	uint32	GetSuccessfullUpCount()					{return successfullupcount;}
	uint32	GetFailedUpCount()						{return failedupcount;}
	uint32	GetAverageUpTime();

    CUpDownClient* FindBestClientInQueue();
    void ReSortUploadSlots(bool force = false);

protected:
	void	RemoveFromWaitingQueue(POSITION pos, bool updatewindow);
	bool		AcceptNewClient(bool addOnNextConnect = false);
	bool		AcceptNewClient(uint32 curUploadSlots);
	bool		ForceNewClient(bool allowEmptyWaitingQueue = false);

	bool		AddUpNextClient(LPCTSTR pszReason, CUpDownClient* directadd = 0);
	
	static VOID CALLBACK UploadTimer(HWND hWnd, UINT nMsg, UINT nId, DWORD dwTime);

private:
	void	UpdateMaxClientScore();
	uint32	GetMaxClientScore()						{return m_imaxscore;}
    void    UpdateActiveClientsInfo(DWORD curTick);

    void InsertInUploadingList(CUpDownClient* newclient);
    float GetAverageCombinedFilePrioAndCredit();

	CUpDownClientPtrList waitinglist;
	CUpDownClientPtrList uploadinglist;

	// By BadWolf - Accurate Speed Measurement
	typedef struct TransferredData {
		uint32	datalen;
		DWORD	timestamp;
	};
	CList<uint64> avarage_dr_list;
    CList<uint64> avarage_friend_dr_list;
	CList<DWORD,DWORD> avarage_tick_list;
	CList<int,int> activeClients_list;
    CList<DWORD,DWORD> activeClients_tick_list;
	uint32	datarate;   //datarate sent to network (including friends)
    uint32  friendDatarate; // datarate of sent to friends (included in above total)
	// By BadWolf - Accurate Speed Measurement

	UINT_PTR h_timer;
	uint32	successfullupcount;
	uint32	failedupcount;
	uint32	totaluploadtime;
	uint32	m_nLastStartUpload;
	uint32	m_dwRemovedClientByScore;

	uint32	m_imaxscore;

    DWORD   m_dwLastCalculatedAverageCombinedFilePrioAndCredit;
    float   m_fAverageCombinedFilePrioAndCredit;
    uint32  m_iHighestNumberOfFullyActivatedSlotsSinceLastCall;
    uint32  m_MaxActiveClients;
    uint32  m_MaxActiveClientsShortTime;

    DWORD   m_lastCalculatedDataRateTick;
    uint64  m_avarage_dr_sum;

    DWORD   m_dwLastResortedUploadSlots;
};
